var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command selectGem
 * @text ジェム選択
 * @des ジェム選択
 *
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_GemUi';
    PluginManager.registerCommand(pluginName, 'selectGem', function (args) {
        SceneManager.push(Scene_Gem);
    });
})(Nore || (Nore = {}));
var GET_GEM_SW = 33;
var GET_GEM2_SW = 40;
var GEM2_SW = 70;
var Scene_Gem = /** @class */ (function (_super) {
    __extends(Scene_Gem, _super);
    function Scene_Gem() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_Gem.prototype.create = function () {
        _super.prototype.create.call(this);
        this.createBackground();
        this.createGemSelectWindow();
        this.createRemoveGemSelectWindow();
        this.createLabel();
        $gameSwitches.setValue(20, false);
    };
    Scene_Gem.prototype.createBackground = function () {
        this._backgroundSprite = new Sprite();
        this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
        this.addChild(this._backgroundSprite);
        this._backgroundSprite.opacity = 152;
    };
    Scene_Gem.prototype.createGemSelectWindow = function () {
        this._gemSelectWindow = new Window_GemSelect();
        this.addChild(this._gemSelectWindow);
        this._gemSelectWindow.setup();
        this._gemSelectWindow.setHandler('ok', this.onOk.bind(this));
        this._gemSelectWindow.setHandler('cancel', this.onCancel.bind(this));
    };
    Scene_Gem.prototype.createRemoveGemSelectWindow = function () {
        this._removeGemSelectWindow = new Window_RemoveGemSelect();
        this.addChild(this._removeGemSelectWindow);
        this._removeGemSelectWindow.setup();
        this._removeGemSelectWindow.setHandler('ok', this.onRemoveOk.bind(this));
        this._removeGemSelectWindow.setHandler('cancel', this.onRemoveCancel.bind(this));
        this._removeGemSelectWindow.hide();
    };
    Scene_Gem.prototype.createLabel = function () {
        this._labelWindow1 = new Window_Label(TextManager.selectGem, 430, 56, 450);
        this.addChild(this._labelWindow1);
        this._labelWindow3 = new Window_Label(TextManager.selectGem2, 430, 82, 450);
        this.addChild(this._labelWindow3);
        this._labelWindow2 = new Window_Label(TextManager.disposeGem, 350, 430, 650);
        this.addChild(this._labelWindow2);
        this._labelWindow2.hide();
    };
    Scene_Gem.prototype.onOk = function () {
        var user = $gameParty.user();
        if (user.battleEquipList().length >= 6) {
            this._removeGemSelectWindow.show();
            this._removeGemSelectWindow.activate();
            this._labelWindow2.show();
            return;
        }
        this.gainGem();
    };
    Scene_Gem.prototype.onCancel = function () {
        if ($gameSwitches.value(GEM2_SW)) {
            $gameSwitches.setValue(GET_GEM2_SW, false);
        }
        else {
            $gameSwitches.setValue(GET_GEM_SW, false);
        }
        this.popScene();
    };
    Scene_Gem.prototype.onRemoveOk = function () {
        var eqiup = this._removeGemSelectWindow.selectedItem();
        $gameParty.user().removeBattleEquip(eqiup);
        this.gainGem();
    };
    Scene_Gem.prototype.gainGem = function () {
        $gameSwitches.setValue(20, true);
        var eqiup = this._gemSelectWindow.selectedItem();
        eqiup.onDungeonStart();
        $gameParty.user().addBattleEquip(eqiup);
        this.popScene();
    };
    Scene_Gem.prototype.onRemoveCancel = function () {
        this._removeGemSelectWindow.hide();
        this._labelWindow2.hide();
        this._gemSelectWindow.activate();
    };
    return Scene_Gem;
}(Scene_Base));
var Window_GemSelect = /** @class */ (function (_super) {
    __extends(Window_GemSelect, _super);
    function Window_GemSelect() {
        var r = new Rectangle(240, 130, 800, 220);
        return _super.call(this, r) || this;
    }
    Window_GemSelect.prototype.setup = function () {
        this.makeItems();
        this.refresh();
        this.activate();
        this.select(0);
    };
    Window_GemSelect.prototype.makeItems = function () {
        this._items = [];
        var dungeon = $gameSystem.world().dungeon($gameSystem.dungeonId());
        var floor = dungeon.floor($gameSystem.floor());
        var armors;
        if ($gameSwitches.value(GEM2_SW)) {
            armors = floor.gemList2();
        }
        else {
            armors = floor.gemList();
        }
        for (var i = 0; i < armors.length; i++) {
            var user = new Game_UserEquip();
            user.forceChangeEquip(armors[i]);
            this._items.push(user);
        }
    };
    Window_GemSelect.prototype.maxItems = function () {
        if (!this._items) {
            return 0;
        }
        return 3;
    };
    Window_GemSelect.prototype.maxCols = function () {
        return 3;
    };
    Window_GemSelect.prototype.itemHeight = function () {
        return 190;
    };
    Window_GemSelect.prototype.drawItem = function (index) {
        var item = this._items[index];
        var r = this.itemRect(index);
        this.contents.fontSize = 20;
        this.drawIcon(item.iconIndex(), r.x + 10, r.y + 10);
        this.drawText(item.name(), r.x + 44, r.y + 10, 200);
        this.drawCoolTime(item, r);
        this.drawDescription(item, r);
    };
    Window_GemSelect.prototype.drawCoolTime = function (item, r) {
        this.contents.fontSize = 16;
        var cooltime = item.maxCoolTime();
        var text = TextManager.cooltime.format(cooltime);
        this.drawText(text, r.x + this.textXOffset(), 50, 200);
    };
    Window_GemSelect.prototype.drawDescription = function (item, r) {
        var texts = item.descriptions();
        var yy = 90;
        for (var _i = 0, texts_1 = texts; _i < texts_1.length; _i++) {
            var text = texts_1[_i];
            this.drawText(text, r.x + this.textXOffset(), r.y + yy, 200);
            yy += this.lineHeight();
        }
    };
    Window_GemSelect.prototype.textXOffset = function () {
        return 10;
    };
    Window_GemSelect.prototype.lineHeight = function () {
        return 26;
    };
    Window_GemSelect.prototype.selectedItem = function () {
        return this._items[this.index()];
    };
    return Window_GemSelect;
}(Window_Selectable));
var Window_Gem = /** @class */ (function (_super) {
    __extends(Window_Gem, _super);
    function Window_Gem() {
        var r = new Rectangle(0, 510, 242, 288);
        return _super.call(this, r) || this;
    }
    Window_Gem.prototype.setup = function (user) {
        this._user = user;
        this.makeItems();
        this.refresh();
    };
    Window_Gem.prototype.makeItems = function () {
        if (this._user) {
            this._items = this._user.battleEquipList();
        }
    };
    Window_Gem.prototype.maxItems = function () {
        if (this._items) {
            return this._items.length;
        }
        else {
            return 0;
        }
    };
    Window_Gem.prototype.update = function () {
        _super.prototype.update.call(this);
        this.visible = this.isVisible();
    };
    Window_Gem.prototype.isEnabled = function (index) {
        var item = this._items[index];
        return item.isEnabled();
    };
    Window_Gem.prototype.drawItem = function (index) {
        this.changeTextColor(ColorManager.normalColor());
        this.contents.fontBold = false;
        var item = this._items[index];
        var r = this.itemRect(index);
        this.changePaintOpacity(this.isEnabled(index));
        this.contents.fontSize = 18;
        this.drawIcon(item.iconIndex(), r.x, r.y);
        this.drawText(item.name(), r.x + 32, r.y, 170);
        if (item.coolTime() > 0) {
            this.changeTextColor(ColorManager.crisisColor());
            this.changePaintOpacity(true);
            this.contents.fontBold = true;
            this.contents.fontSize = 22;
            this.drawText(item.coolTime(), r.x, r.y, 32, 'center');
        }
    };
    Window_Gem.prototype.isVisible = function () {
        if ($gameSwitches.value(FINAL_BATTLE_SW)) {
            return false;
        }
        if (!$gameParty.inDungeon()) {
            return false;
        }
        if (this.maxItems() == 0) {
            return false;
        }
        return $gameSwitches.value(43);
    };
    return Window_Gem;
}(Window_Selectable));
var Window_RemoveGemSelect = /** @class */ (function (_super) {
    __extends(Window_RemoveGemSelect, _super);
    function Window_RemoveGemSelect() {
        var r = new Rectangle(240, 480, 800, 220);
        return _super.call(this, r) || this;
    }
    Window_RemoveGemSelect.prototype.setup = function () {
        this.makeItems();
        this.refresh();
        this.activate();
        this.select(0);
    };
    Window_RemoveGemSelect.prototype.makeItems = function () {
        this._items = [];
        var list = $gameParty.user().battleEquipList();
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var e = list_1[_i];
            if (e.isMagic()) {
                this._items.push(e);
            }
        }
    };
    Window_RemoveGemSelect.prototype.maxItems = function () {
        if (!this._items) {
            return 0;
        }
        return 3;
    };
    Window_RemoveGemSelect.prototype.maxCols = function () {
        return 3;
    };
    Window_RemoveGemSelect.prototype.itemHeight = function () {
        return 190;
    };
    Window_RemoveGemSelect.prototype.drawItem = function (index) {
        var item = this._items[index];
        if (!item) {
            return;
        }
        var r = this.itemRect(index);
        this.changeTextColor(ColorManager.normalColor());
        this.contents.fontSize = 20;
        this.drawIcon(item.iconIndex(), r.x + 10, r.y + 10);
        this.drawText(item.name(), r.x + 44, r.y + 10, 200);
        this.drawCoolTime(item, r);
        this.drawDescription(item, r);
        if (item.coolTime() > 0) {
            this.changeTextColor(ColorManager.crisisColor());
            this.changePaintOpacity(true);
            this.contents.fontBold = true;
            this.contents.fontSize = 22;
            this.drawText(item.coolTime(), r.x + 10, r.y + 10, 32, 'center');
        }
    };
    Window_RemoveGemSelect.prototype.drawCoolTime = function (item, r) {
        this.contents.fontSize = 16;
        var cooltime = item.maxCoolTime();
        var text = TextManager.cooltime.format(cooltime);
        this.drawText(text, r.x + this.textXOffset(), 50, 200);
    };
    Window_RemoveGemSelect.prototype.drawDescription = function (item, r) {
        var texts = item.descriptions();
        var yy = 90;
        for (var _i = 0, texts_2 = texts; _i < texts_2.length; _i++) {
            var text = texts_2[_i];
            this.drawText(text, r.x + this.textXOffset(), r.y + yy, 200);
            yy += this.lineHeight();
        }
    };
    Window_RemoveGemSelect.prototype.textXOffset = function () {
        return 10;
    };
    Window_RemoveGemSelect.prototype.lineHeight = function () {
        return 26;
    };
    Window_RemoveGemSelect.prototype.selectedItem = function () {
        return this._items[this.index()];
    };
    return Window_RemoveGemSelect;
}(Window_Selectable));
