var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Window_Help2 = /** @class */ (function (_super) {
    __extends(Window_Help2, _super);
    function Window_Help2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_Help2.prototype.baseTextRect = function () {
        var rect = new Rectangle(20, 0, this.innerWidth - 80, this.innerHeight);
        rect.pad(-this.itemPadding(), 0);
        return rect;
    };
    Window_Help2.prototype.setItem = function (item) {
        var text = this.description(item);
        this.setText(text);
    };
    Window_Help2.prototype.description = function (item) {
        if (!item) {
            return '';
        }
        if (DataManager.isSkill(item)) {
            return this.skillDescription(item);
        }
        if (DataManager.isWeapon(item)) {
            return this.weaponDescription(item);
        }
        return item.description;
    };
    Window_Help2.prototype.weaponDescription = function (weapon) {
        var slot = new EquipSlot(100, 0, weapon);
        var t = '';
        t += slot.skillName();
        t += '　　ダメージ %1 '.format(weapon.params[2]);
        t += '　　クールダウン %1'.format(slot.cooldownText());
        return t;
    };
    Window_Help2.prototype.skillDescription = function (skill) {
        var texts = [];
        var testActor = $gameActors.actor(100);
        var action = new Game_Action2(testActor);
        action.setSkill(skill.id);
        if (action.isDamage()) {
            var damage = Math.round(action.evalDamageFormula(testActor));
            if (damage > 0) {
                texts.push(TextManager.skillDamage.format(damage));
            }
        }
        if (skill.meta['breakUp']) {
            var breakUp = hankaku2Zenkaku(parseInt(skill.meta['breakUp']) - 100);
            texts.push(TextManager.skillBreakUp.format(breakUp));
        }
        if (skill.meta['cancel']) {
            texts.push(TextManager.skillCancel.format());
        }
        if (skill.meta['delay']) {
            var delay = hankaku2Zenkaku(parseInt(skill.meta['delay']));
            texts.push(TextManager.skillDelay.format(delay));
        }
        if (skill.meta['wait']) {
            var wait = hankaku2Zenkaku(parseInt(skill.meta['wait']) + 1);
            texts.push(TextManager.skillWait.format(wait));
        }
        if (skill.meta['noBreak']) {
            texts.push(TextManager.skillNoBreak.format());
        }
        if (skill.meta['stunPlus']) {
            texts.push(TextManager.skillStunPlus.format());
        }
        if (skill.meta['provoke']) {
            texts.push(TextManager.skillProvoke.format());
            texts.push(TextManager.skillGuard.format());
        }
        var skillParamChangeText = this.skillParamChangeText(skill);
        if (skillParamChangeText) {
            texts.push(skillParamChangeText);
        }
        //if (texts.length <= 2) {
        return texts.join('\n');
        /*}
        else {
            return texts[0] + '　　' + texts[1] + '\n'+ texts[2]
        }*/
    };
    Window_Help2.prototype.skillParamChangeText = function (skill) {
        for (var _i = 0, _a = skill.effects; _i < _a.length; _i++) {
            var e = _a[_i];
            p(e);
            if (e.code == 21) {
                var state = $dataStates[e.dataId];
                var stateValue = hankaku2Zenkaku(skill.meta['stateValue']);
                return TextManager.skillState.format(getItemName(state), stateValue);
            }
            if (e.code == 32) {
                if (e.dataId == 2) {
                    //const stateValue = skill.meta['stateValue'];
                    var value = hankaku2Zenkaku(e.value1);
                    return TextManager.skillAtkDown.format(value);
                }
            }
        }
        return null;
    };
    return Window_Help2;
}(Window_Help));
var Nore;
(function (Nore) {
    function getParamChangeName(effect, inBattle) {
        if (inBattle === void 0) { inBattle = false; }
        if (effect.dataId == 2) {
            if (effect.code == 32) {
                return inBattle ? TextManager.atkDownBattle : TextManager.atkDown;
            }
            else {
                return inBattle ? TextManager.atkUpBattle : TextManager.atkUp;
            }
        }
        if (effect.dataId == 3) {
            if (effect.code == 32) {
                return inBattle ? TextManager.defDownBattle : TextManager.defDown;
            }
            else {
                return inBattle ? TextManager.defUpBattle : TextManager.defUp;
            }
        }
        if (effect.dataId == 4) {
            if (effect.code == 32) {
                return inBattle ? TextManager.matDownBattle : TextManager.matDown;
            }
            else {
                return inBattle ? TextManager.matUpBattle : TextManager.matUp;
            }
        }
        if (effect.dataId == 5) {
            if (effect.code == 32) {
                return inBattle ? TextManager.mdfDownBattle : TextManager.mdfDown;
            }
            else {
                return inBattle ? TextManager.mdfUpBattle : TextManager.mdfUp;
            }
        }
        return TextManager.atkUp;
    }
    Nore.getParamChangeName = getParamChangeName;
})(Nore || (Nore = {}));
