/*:ja
 * @target MZ
 * @author ル
 *
 *
 *
 * @command addHistory
 * @text 履歴追加
 * @arg actorId
 * @type number
 * @text actorId
 * @arg type
 * @type string
 * @text event, baisyun, dousei, syusan
 * @arg manId
 * @type number
 * @text manId
 * @desc 0 なら変数63 -1なら非表示
 * @min -1
 * @arg commonId
 * @type number
 * @text commonId
 * @desc 0 ならなし
 * @arg dayOffset
 * @desc 日付調整 -1 なら１日前
 * @min -1
 * @default 0
 *
 * @command setLastSexManToVar31
 * @text 最後にHした男の名前を変数31に入れる
 * @arg actorId
 * @type number
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_History';
    PluginManager.registerCommand(pluginName, 'addHistory', function (args) {
        if ($gameSystem.isRecollection()) {
            return;
        }
        var actorId = parseInt(args.actorId);
        var type = args.type;
        var manId = parseInt(args.manId);
        if (manId <= 0) {
            manId = $gameVariables.value(BAISYUN_MAN_ID);
        }
        var commonId = parseInt(args.commonId);
        var dayOffset = parseInt(args.dayOffset);
        var maker = new HistoryMaker(actorId, commonId, type, manId, dayOffset);
        var seiekiResult = maker.make();
        if (!seiekiResult) {
            console.error('精液リザルトが存在しません');
            return;
        }
        $gameParty.addSeiekiResultAndGainSeieki(seiekiResult);
        if ($gameParty.inBaisyun()) {
            var actor = $gameActors.actor(actorId);
            var sikyu = actor.sikyu();
            sikyu.addSeieki(seiekiResult.seieki());
        }
    });
    PluginManager.registerCommand(pluginName, 'setLastSexManToVar31', function (args) {
        var actorId = parseInt(args.actorId);
        if ($gameSystem.isRecollection()) {
            var name_1;
            if (actorId == 2) {
                name_1 = $gameActors.actor(3).name();
            }
            else {
                name_1 = $gameActors.actor(10).name();
            }
            $gameVariables.setValue(NAME_MAN_NAME_VAR_ID, name_1);
            return;
        }
        var list = $gameParty.dayResultHistory().makeHistory(actorId);
    });
})(Nore || (Nore = {}));
var EroHistoryType;
(function (EroHistoryType) {
    EroHistoryType["event"] = "event";
    EroHistoryType["baisyun"] = "baisyun";
    EroHistoryType["dousei"] = "dousei";
})(EroHistoryType || (EroHistoryType = {}));
var EroBaisyunHistory = /** @class */ (function () {
    function EroBaisyunHistory() {
        this._acme = 0;
        this._sex = 0;
        this._nakadashi = 0;
    }
    return EroBaisyunHistory;
}());
var HistoryMaker = /** @class */ (function () {
    function HistoryMaker(actorId, commonId, type, manId, dayOffset) {
        this._actorId = actorId;
        this._commonId = commonId;
        this._type = type;
        this._manId = manId;
        this._dayOffset = dayOffset;
        if (isNaN(this._dayOffset)) {
            this._dayOffset = 0;
        }
    }
    HistoryMaker.prototype.make = function () {
        if (this.isCommonBaisyun()) {
            return this.makeCommonBaisyunResult();
        }
        else {
            return this.makeCommonEventResult();
        }
    };
    HistoryMaker.prototype.isCommonBaisyun = function () {
        return this._commonId == 2 || this._commonId == 3;
    };
    HistoryMaker.prototype.makeCommonBaisyunResult = function () {
        var result = $gameTemp.lastBaisyunResult;
        var seiekiValue = 1;
        var param = $baisyunManParamManager.findManParam(this._actorId, this._manId);
        if (param.hasZetsurinAbility()) {
            seiekiValue++;
        }
        var actor = $gameActors.actor(this._actorId);
        var eroMap = ERO_MAP[this._commonId];
        var eroParam = new EroParam(eroMap);
        var fValue = Nore.calcFriendshipUp(eroParam.friendshipUp());
        var fResult = actor.friendshipActor().upFriendship(this._manId, fValue, eroParam.isMax());
        var commonEventId = this.calcBaisyunCommonId(this._actorId);
        var seiekiResult = new SeiekiResult(this._actorId, SeiekiType.baisyun, commonEventId, result.seieki(), fResult, null, this._dayOffset);
        return seiekiResult;
    };
    HistoryMaker.prototype.calcBaisyunCommonId = function (actorId) {
        if (actorId == 3) {
            return CommonEventId.baisyunPattyEroParam;
        }
        else {
            return CommonEventId.baisyunEroParam;
        }
    };
    HistoryMaker.prototype.makeCommonEventResult = function () {
        var eroMap = ERO_MAP[this._commonId];
        if (!eroMap) {
            console.error(this._commonId + 'のERO_MAPが見つかりません');
            return null;
        }
        var param = new EroParam(eroMap);
        if (param.manId() > 0) {
            this._manId = param.manId();
        }
        var seiekiValue = param.seiekiValue();
        var condom = !$gameTemp.notUseCondom;
        var sotodashi = $gameTemp.sotodashi;
        var seieki = new Seieki(this._manId, condom, sotodashi, seiekiValue);
        var actor = $gameActors.actor(this._actorId);
        // コピーをとって計算だけ
        var a = JsonEx.makeDeepCopy(actor);
        var ranshiResult = a.upNinshinDamage(param.calcNinshinDamage(), this._manId, this._commonId, true);
        if (param.type() != this._type) {
            console.error('タイプが異なります' + this._commonId + ' param:' + param.type() + ' ' + this._type);
        }
        var fValue = Nore.calcFriendshipUp(param.friendshipUp());
        var fResult = actor.friendshipActor().upFriendship(this._manId, fValue, param.isMax());
        var seiekiResult = new SeiekiResult(this._actorId, param.type(), this._commonId, seieki, fResult, ranshiResult, this._dayOffset);
        return seiekiResult;
    };
    return HistoryMaker;
}());
