var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Scene_EroHistory = /** @class */ (function (_super) {
    __extends(Scene_EroHistory, _super);
    function Scene_EroHistory() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_EroHistory.prototype.create = function () {
        _super.prototype.create.call(this);
        this.createLabelSprite();
        this.createHistoryWindow();
    };
    Scene_EroHistory.prototype.createLabelSprite = function () {
        var actorId = $gameParty.menuActorId();
        this._labelSprite = new Sprite_EroStatusLabel(actorId);
        this.addChild(this._labelSprite);
    };
    Scene_EroHistory.prototype.createHistoryWindow = function () {
        var actorId = $gameParty.menuActorId();
        this._historyWindow = new Window_EroHistory(actorId);
        this.addChild(this._historyWindow);
        this._historyWindow.setHandler('cancel', this.onCancel.bind(this));
        this._historyWindow.activate();
    };
    Scene_EroHistory.prototype.onCancel = function () {
        this.popScene();
    };
    return Scene_EroHistory;
}(Scene_MenuBase));
var Sprite_EroStatusLabel = /** @class */ (function (_super) {
    __extends(Sprite_EroStatusLabel, _super);
    function Sprite_EroStatusLabel(actorId) {
        var _this = _super.call(this) || this;
        _this._actorId = actorId;
        _this.bitmap = new Bitmap(600, 100);
        _this.refresh();
        _this.x = 10;
        _this.y = 10;
        return _this;
    }
    Sprite_EroStatusLabel.prototype.refresh = function () {
        this.bitmap.clear();
        var actor = $gameActors.actor(this._actorId);
        var name = actor.name();
        var text = '%1のH履歴'.format(name);
        this.bitmap.drawText(text, 0, 0, 200, 32);
    };
    return Sprite_EroStatusLabel;
}(Sprite));
var Window_EroHistory = /** @class */ (function (_super) {
    __extends(Window_EroHistory, _super);
    function Window_EroHistory(actorId) {
        var _this = this;
        var r = new Rectangle(50, 50, 1100, 700);
        _this = _super.call(this, r) || this;
        _this._actorId = actorId;
        _this.makeData();
        _this.refresh();
        return _this;
    }
    Window_EroHistory.prototype.makeData = function () {
        var actor = $gameActors.actor(this._actorId);
        this._historyList = actor.eroHistoryList().list();
    };
    Window_EroHistory.prototype.maxItems = function () {
        if (!this._historyList) {
            return 0;
        }
        return this._historyList.length;
    };
    Window_EroHistory.prototype.drawItem = function (index) {
        var r = this.itemRect(index);
        var h = this._historyList[index];
        this.drawDay(h, r.y);
        this.drawMan(h, r.y);
        this.drawType(h, r.y);
        this.drawNakadashi(h, r.y);
    };
    Window_EroHistory.prototype.drawDay = function (h, y) {
        this.drawText(TextManager.day.format(h.day()), 50, y, 100);
    };
    Window_EroHistory.prototype.drawMan = function (h, y) {
        this.drawText(h.manName(), 180, y, 240);
    };
    Window_EroHistory.prototype.drawType = function (h, y) {
        this.drawText(h.typeName(), 450, y, 240);
    };
    Window_EroHistory.prototype.drawNakadashi = function (h, y) {
        var sexType = 'コンドーム使用';
        if (h.nakadashi()) {
            sexType = '生ハメ';
        }
        this.drawText(sexType, 650, y, 200);
    };
    return Window_EroHistory;
}(Window_Selectable));
