var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Scene_Item2 = /** @class */ (function (_super) {
    __extends(Scene_Item2, _super);
    function Scene_Item2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_Item2.prototype.create = function () {
        _super.prototype.create.call(this);
        this.createEquipHelpWindow();
    };
    Scene_Item2.prototype.start = function () {
        _super.prototype.start.call(this);
        this.onCategoryOk();
        this._categoryWindow.deactivate();
    };
    Scene_Item2.prototype.createEquipHelpWindow = function () {
    };
    Scene_Item2.prototype.itemWindowRect = function () {
        var wx = 0;
        var wy = this._categoryWindow.y + this._categoryWindow.height;
        var ww = Graphics.boxWidth - 400;
        var wh = this.mainAreaBottom() - wy + 100;
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_Item2.prototype.categoryWindowRect = function () {
        var r = _super.prototype.categoryWindowRect.call(this);
        r.width -= 400;
        return r;
    };
    Scene_Item2.prototype.createHelpWindow = function () {
        var rect = this.helpWindowRect();
        this._helpWindow = new Window_EquipHelp(rect);
        this.addWindow(this._helpWindow);
    };
    Scene_Item2.prototype.helpWindowRect = function () {
        var wx = 870;
        var wy = this.mainAreaTop() + this.calcWindowHeight(1, true);
        var ww = 400;
        var wh = 400;
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_Item2.prototype.createItemWindow = function () {
        var rect = this.itemWindowRect();
        this._itemWindow = new Window_ItemList2(rect);
        this._itemWindow.setHelpWindow(this._helpWindow);
        this._itemWindow.setHandler("ok", this.onItemOk.bind(this));
        this._itemWindow.setHandler("cancel", this.onItemCancel.bind(this));
        this.addWindow(this._itemWindow);
        this._categoryWindow.setItemWindow(this._itemWindow);
        if (!this._categoryWindow.needsSelection()) {
            this._itemWindow.y -= this._categoryWindow.height;
            this._itemWindow.height += this._categoryWindow.height;
            this._itemWindow.createContents();
            this._categoryWindow.update();
            this._categoryWindow.hide();
            this._categoryWindow.deactivate();
            this.onCategoryOk();
        }
    };
    ;
    return Scene_Item2;
}(Scene_Item));
var Window_ItemList2 = /** @class */ (function (_super) {
    __extends(Window_ItemList2, _super);
    function Window_ItemList2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_ItemList2.prototype.includes = function (item) {
        switch (this._category) {
            case "item":
                return DataManager.isItem(item) && item.itypeId === 1;
            case "weapon":
                return DataManager.isWeapon(item);
            case "armor":
                if (!DataManager.isArmor(item)) {
                    return false;
                }
                var armor = item;
                return this.includesArmor(armor);
            case "keyItem":
                return DataManager.isItem(item) && item.itypeId === 2;
            default:
                return false;
        }
    };
    Window_ItemList2.prototype.includesArmor = function (armor) {
        if ($gameMedals.isMedal(armor)) {
            return false;
        }
        return true;
    };
    return Window_ItemList2;
}(Window_ItemList));
