var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Sprite_ActorCharacter = /** @class */ (function (_super) {
    __extends(Sprite_ActorCharacter, _super);
    function Sprite_ActorCharacter(character, cos) {
        var _this = this;
        if (!cos || !(cos instanceof CostumeSaver)) {
            throw new Error();
        }
        _this = _super.call(this, character) || this;
        _this._cos = cos;
        //this._meganeLayer = new Sprite_LayeredCharacter(character, EquipType.megane, cos);
        _this._hoppeLayer = new Sprite_LayeredCharacter(character, EquipType.hoppe, cos);
        _this._innerBottomLayer = new Sprite_LayeredCharacter(character, EquipType.innerBottom, cos);
        _this._innerTopLayer = new Sprite_LayeredCharacter(character, EquipType.innerTop, cos);
        _this._outerLayer = new Sprite_LayeredCharacter(character, EquipType.outer, cos);
        //this._legLayer = new Sprite_LayeredCharacter(character, EquipType.leg, cos);
        _this.addChild(_this._innerBottomLayer);
        _this.addChild(_this._innerTopLayer);
        _this.addChild(_this._outerLayer);
        //this.addChild(this._legLayer);
        _this.addChild(_this._hoppeLayer);
        //this.addChild(this._meganeLayer);
        _this._medalLayer = new Sprite_CharacterMedal(cos.actorId(), cos.medalId());
        _this.addChild(_this._medalLayer);
        _this._colorFilter = new ColorFilter();
        if (!_this.filters) {
            _this.filters = [];
        }
        _this._monoToneColor = [40, 40, 40, 190];
        _this.filters.push(_this._colorFilter);
        return _this;
    }
    Sprite_ActorCharacter.prototype.isEmptyCharacter = function () {
        if (this._character == $gamePlayer) {
            return false;
        }
        if (!this._character.characterName()) {
            return true;
        }
        return _super.prototype.isEmptyCharacter.call(this);
    };
    Sprite_ActorCharacter.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateCostume();
        this.updateVisible();
        this.updateRotation();
    };
    Sprite_ActorCharacter.prototype.updateRotation = function () {
        if (this._rotation !== undefined) {
            return;
        }
        if (this._character instanceof Game_Event) {
            var event_1 = this._character;
            var e = event_1.event();
            if (e && e.meta['rotation']) {
                var r = parseInt(e.meta['rotation']);
                this._rotation = r;
                this.rotation = r * Math.PI / 180;
                return;
            }
        }
        this._rotation = 0;
    };
    Sprite_ActorCharacter.prototype.updateCostume = function () {
        var actorId = $gameVariables.value(135);
        if (actorId == 0) {
            return;
        }
        if (this._cos.actorId() == actorId) {
            this.refreshCostume();
            $gameVariables.setValue(135, 0);
        }
    };
    Sprite_ActorCharacter.prototype.updateVisible = function () {
        if (this._character && this._character._characterIndex == 7) {
            this.visible = false;
        }
        else {
            this.updateVisibility();
        }
    };
    Sprite_ActorCharacter.prototype.refreshCostume = function () {
        this._cos = new CostumeSaver(this._cos.actorId());
        this._outerLayer.refreshCostume(this._cos);
    };
    Sprite_ActorCharacter.prototype.updateBitmap = function () {
        this.updateTone();
        if (this.isImageChanged()) {
            this._initialized = true;
            this._characterName = this.characterName();
            this._characterIndex = this.characterIndex();
            this.setCharacterBitmap();
        }
    };
    Sprite_ActorCharacter.prototype.characterIndex = function () {
        if (this._cos.actorId() == 3) {
            if (this._cos.hairId() == 2) {
                return 1;
            }
            return 0;
        }
        if (this._cos.boteId() >= 1) {
            return 1;
        }
        return 0;
    };
    Sprite_ActorCharacter.prototype.updateTone = function () {
        if (!this._character.isMonoTone) {
            return;
        }
        if (this._character.isMonoTone()) {
            this._colorFilter.setBlendColor(this._monoToneColor);
        }
        else {
            this._colorFilter.setBlendColor([0, 0, 0, 0]);
        }
    };
    Sprite_ActorCharacter.prototype.isImageChanged = function () {
        if (this._initialized) {
            return this._characterName != this.characterName();
        }
        return true;
    };
    Sprite_ActorCharacter.prototype.characterName = function () {
        var actorId = this._cos.actorId();
        var fileName = 'actor' + actorId.padZero(2);
        if (actorId > 90) {
            return '';
        }
        return fileName + '_base';
    };
    Sprite_ActorCharacter.prototype.updateOther = function () {
        this.opacity = this._character.opacity();
        this.blendMode = this._character.blendMode();
        //this._bushDepth = this._character.bushDepth();
    };
    Sprite_ActorCharacter.prototype.listFiles = function () {
        var files = [];
        files.push(this._characterName + ' ' + this.characterIndex());
        files.push(this._hoppeLayer.fileName() + ' ' + this._hoppeLayer.characterIndex());
        files.push(this._innerBottomLayer.fileName());
        files.push(this._innerTopLayer.fileName());
        //files.push(this._legLayer.fileName());
        files.push(this._outerLayer.fileName() + ' ' + this._outerLayer.characterIndex());
        //files.push(this._meganeLayer.fileName());
        return files;
    };
    Sprite_ActorCharacter.prototype.characterBlockX = function () {
        var index = this._characterIndex;
        return (index % 4) * 3;
    };
    Sprite_ActorCharacter.prototype.characterBlockY = function () {
        var index = this._characterIndex;
        return Math.floor(index / 4) * 4;
    };
    return Sprite_ActorCharacter;
}(Sprite_Character));
var Sprite_Follower = /** @class */ (function (_super) {
    __extends(Sprite_Follower, _super);
    function Sprite_Follower() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Sprite_Follower.prototype.update = function () {
        _super.prototype.update.call(this);
        //this.visible = this._character.isVisible() && ! $gamePlayer.isTransparent();
    };
    return Sprite_Follower;
}(Sprite_ActorCharacter));
var Sprite_Player = /** @class */ (function (_super) {
    __extends(Sprite_Player, _super);
    function Sprite_Player() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Sprite_Player.prototype.characterName = function () {
        var actor;
        if ($gameSystem.sarachiActorId() > 0) {
            actor = $gameActors.actor(18);
            this._meganeLayer.visible = false;
            this._hoppeLayer.visible = false;
            this._innerBottomLayer.visible = false;
            this._innerTopLayer.visible = false;
            this._outerLayer.visible = false;
            this._legLayer.visible = false;
        }
        actor = $gamePlayer.mainActor();
        var fileName = 'actor' + actor.actorId().padZero(2) + '_base';
        return fileName;
    };
    Sprite_Player.prototype.characterIndex = function () {
        var actor = $gamePlayer.mainActor();
        if (this._cos.actorId() == 3) {
            if (this._cos.hairId() == 2) {
                return 1;
            }
            return 0;
        }
        if (actor.isBote()) {
            return 1;
        }
        return 0;
    };
    Sprite_Player.prototype.update = function () {
        _super.prototype.update.call(this);
        if ($gameSwitches.value(165)) {
            $gameSwitches.setValue(165, false);
            var actor = $gamePlayer.mainActor();
            var actorId = actor.actorId();
            this._cos = new CharacterCostume(actorId);
            this._hoppeLayer.refreshCostume(this._cos);
            this._outerLayer.refreshCostume(this._cos);
            this._innerBottomLayer.refreshCostume(this._cos);
            this._innerTopLayer.refreshCostume(this._cos);
            this._medalLayer.refresh(actorId, actor.currentMedalId());
        }
    };
    return Sprite_Player;
}(Sprite_ActorCharacter));
var Sprite_Prisoner = /** @class */ (function (_super) {
    __extends(Sprite_Prisoner, _super);
    function Sprite_Prisoner() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Sprite_Prisoner.prototype.updateCharacterFrame = function () {
        var pw = this.patternWidth();
        var ph = this.patternHeight();
        var sx = (this.characterBlockX() + this.characterPatternX()) * pw;
        var sy = (this.characterBlockY() + this.characterPatternY()) * ph;
        this.updateHalfBodySprites();
        var hh = ph - 28;
        this.setFrame(sx, sy, pw, hh);
        this._outerLayer.setFrame(sx, sy, pw, hh);
        this._innerBottomLayer.setFrame(sx, sy, pw, hh);
        this._innerTopLayer.setFrame(sx, sy, pw, hh);
        this._legLayer.setFrame(sx, sy, pw, hh);
        this._hoppeLayer.setFrame(sx, sy, pw, hh);
        this._meganeLayer.setFrame(sx, sy, pw, hh);
    };
    ;
    return Sprite_Prisoner;
}(Sprite_ActorCharacter));
var EquipType;
(function (EquipType) {
    EquipType[EquipType["megane"] = 0] = "megane";
    EquipType[EquipType["hoppe"] = 1] = "hoppe";
    EquipType[EquipType["outer"] = 2] = "outer";
    EquipType[EquipType["outerTop"] = 3] = "outerTop";
    EquipType[EquipType["outerBottom"] = 4] = "outerBottom";
    EquipType[EquipType["head"] = 5] = "head";
    EquipType[EquipType["head2"] = 6] = "head2";
    EquipType[EquipType["leg"] = 7] = "leg";
    EquipType[EquipType["arm"] = 8] = "arm";
    EquipType[EquipType["innerBottom"] = 9] = "innerBottom";
    EquipType[EquipType["innerTop"] = 10] = "innerTop";
})(EquipType || (EquipType = {}));
var Sprite_LayeredCharacter = /** @class */ (function (_super) {
    __extends(Sprite_LayeredCharacter, _super);
    function Sprite_LayeredCharacter(character, _type, _cos) {
        var _this = _super.call(this, character) || this;
        _this._type = _type;
        _this._cos = _cos;
        return _this;
    }
    Sprite_LayeredCharacter.prototype.updateBitmap = function () {
        if (this.isImageChanged()) {
            this._fileName = this.fileName();
            this._characterName = this._fileName;
            this._characterIndex = this.characterIndex();
            this.setCharacterBitmap();
        }
    };
    Sprite_LayeredCharacter.prototype.characterIndex = function () {
        var cos = this._cos;
        if (!cos) {
            return 0;
        }
        if (this._cos.actorId() == 3) {
            if (this._cos.hairId() == 2) {
                return 1;
            }
            return 0;
        }
        if (cos.boteId() == 0) {
            return 0;
        }
        switch (this._type) {
            case EquipType.outer:
            case EquipType.innerBottom:
            case EquipType.innerTop:
                return 1;
        }
        return 0;
    };
    Sprite_LayeredCharacter.prototype.refreshCostume = function (cos) {
        this._cos = cos;
    };
    Sprite_LayeredCharacter.prototype.updatePosition = function () {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    };
    Sprite_LayeredCharacter.prototype.isImageChanged = function () {
        return this._fileName != this.fileName() || this._characterIndex != this.characterIndex();
    };
    Sprite_LayeredCharacter.prototype.fileNameActor7 = function () {
        return '';
    };
    Sprite_LayeredCharacter.prototype.fileName = function () {
        var cos = this._cos;
        if (!cos) {
            console.error('actornas');
            return '';
        }
        if (cos.isNull()) {
            return '';
        }
        var bote = '';
        var actorStr = cos.actorId().padZero(2);
        switch (this._type) {
            case EquipType.hoppe:
                if (cos.hoppeId() <= 0) {
                    return '';
                }
                return 'actor%1_hoppe'.format(cos.actorId().padZero(2));
            case EquipType.outer:
                if (cos.outerId() == 'a') {
                    return '';
                }
                if (cos.outerId() == 'g') {
                    return '';
                }
                return 'actor%2_outer_%1'.format(cos.outerId(), actorStr) + bote;
            case EquipType.megane:
                if (!cos.hasAcce(1099)) {
                    return '';
                }
                return 'actor%1_megane'.format(actorStr);
            case EquipType.leg:
                if (cos.legId() == 'a') {
                    return '';
                }
                return 'actor%2_leg_%1'.format(cos.legId(), actorStr);
            /*case EquipType.arm:
                if (actor.armId == 'a') {
                    return '';
                }
                return 'actor%2_arm_%1'.format(actor.armId, actorStr);*/
            case EquipType.innerBottom:
                switch (cos.innerBottomId()) {
                    case 'a':
                    case 'f':
                    case 'g':
                    case 'h':
                        return '';
                }
                switch (cos.outerId()) {
                    case 'b':
                        return '';
                }
                return 'actor%2_innerBottom_%1'.format(cos.innerBottomId(), actorStr) + bote;
            case EquipType.innerTop:
                if (cos.innerTopId() == 'a') {
                    return '';
                }
                switch (cos.outerId()) {
                    case 'b':
                    case 'g':
                        return '';
                }
                return 'actor%2_innerTop_%1'.format(cos.innerTopId(), actorStr);
        }
    };
    Sprite_LayeredCharacter.prototype.characterBlockX = function () {
        var index = this._characterIndex;
        return (index % 4) * 3;
    };
    Sprite_LayeredCharacter.prototype.characterBlockY = function () {
        var index = this._characterIndex;
        return Math.floor(index / 4) * 4;
    };
    return Sprite_LayeredCharacter;
}(Sprite_Character));
var Sprite_CharacterMedal = /** @class */ (function (_super) {
    __extends(Sprite_CharacterMedal, _super);
    function Sprite_CharacterMedal(actorId, medalId) {
        var _this = _super.call(this) || this;
        _this.x = -50;
        _this.y = -92;
        _this._actorId = actorId;
        _this._medalId = medalId;
        _this.drawMedal();
        return _this;
    }
    Sprite_CharacterMedal.prototype.drawMedal = function () {
        var medalId = this._medalId;
        this._lastMedalId = medalId;
        if (!medalId) {
            return;
        }
        var param = $medalParamManager.getParam(medalId);
        if (!param) {
            console.error(medalId + 'の称号がみつかりません');
            return;
        }
        if (param.isVisible()) {
            if (!this.bitmap) {
                this.bitmap = new Bitmap(100, 50);
            }
            this.bitmap.clear();
            this.bitmap.outlineWidth = 5;
            this.bitmap.fontSize = 10;
            this.bitmap.drawText(param.name(), 0, 10, 100, 32, 'center');
        }
    };
    Sprite_CharacterMedal.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateVisible();
        if (this.isChanged()) {
            this.drawMedal();
        }
    };
    Sprite_CharacterMedal.prototype.isChanged = function () {
        if (!$gameSwitches.value(39)) {
            return false;
        }
        if (this._lastMedalId != $gameActors.actor(this._actorId).currentMedalId()) {
            $gameSwitches.setValue(39, false);
            this._lastMedalId = $gameActors.actor(this._actorId).currentMedalId();
            this._medalId = this._lastMedalId;
            return true;
        }
        return false;
    };
    Sprite_CharacterMedal.prototype.updateVisible = function () {
        /*if ($gameParty.inDungeon()) {
            this.visible = false;
            return;
        }*/
        this.visible = true;
    };
    Sprite_CharacterMedal.prototype.refresh = function (actorId, medalId) {
        this._actorId = actorId;
        this._medalId = medalId;
        this.drawMedal();
    };
    return Sprite_CharacterMedal;
}(Sprite));
function isLayerdActor(actorId) {
    return [1, 2, 3, 4, 5, 35].contains(actorId);
}
