var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var REFRESH_ACTOR_LIST_SW = 258;
var Window_LeftList = /** @class */ (function (_super) {
    __extends(Window_LeftList, _super);
    function Window_LeftList() {
        var _this = this;
        var r = new Rectangle(-3, 66, 295, 764);
        if ($gameParty.inBaisyun()) {
            r.width = 250;
        }
        _this = _super.call(this, r) || this;
        //_warpButton: Sprite_OverableButton;
        //_warpSprite: Sprite;
        _this._hideWait = 0;
        _this.backOpacity = 0;
        _this.frameVisible = false;
        _this._margin = 0;
        _this.padding = 0;
        _this.createContents();
        _this.contents.outlineWidth = 6;
        _this.refreshAll();
        //this.createWarpButton();
        _this.createCursorSprite();
        _this.updateVisible();
        return _this;
    }
    Window_LeftList.prototype.createCursorSprite = function () {
        this._turoArrowSprite = new Sprite();
        this._turoArrowSprite.bitmap = ImageManager.loadSystem('alchemy_arrow');
        this.addChild(this._turoArrowSprite);
    };
    /*
    createWarpButton() {
        this._warpButton = new Sprite_OverableButton("warp", true);
        this._warpButton.x = 250;
        this._warpButton.y = -46;
        this.addChild(this._warpButton);

        this._warpSprite = new Sprite();
        this._warpSprite.x = 250;
        this._warpSprite.y = -80;
        this._warpSprite.bitmap = ImageManager.loadSystem('menu_ui');
        this._warpSprite.setFrame(300, 250, 50, 50);
        this.addChild(this._warpSprite);

    }*/
    Window_LeftList.prototype.onConfirmOk = function () {
        var commonId = 307;
        switch (this._baisyunActorId) {
            case 2:
                commonId = 307;
                break;
            case 3:
                commonId = 312;
                break;
        }
        $gameTemp.reserveCommonEvent(commonId);
    };
    Window_LeftList.prototype.refreshAll = function () {
        this._windowContentsSprite.removeChildren();
        this._douseiSpriteList = [];
        this._faceSpriteList = [];
        this._sexList = [];
        this.makeItems();
        this.refresh();
        this.createActorFaceSprites();
        this.createDouseiSprites();
        this.createBorder();
    };
    Window_LeftList.prototype.createBorder = function () {
        var g = new PIXI.Graphics();
        g.beginFill(0xa06226, 1);
        var hh = 746;
        var ww = 294;
        var lw = 2;
        g.drawRect(0, 1, ww, lw);
        g.drawRect(0, hh - 13 - lw + 1, ww, lw);
        g.drawRect(ww - lw + 1, 1, lw, hh);
        g.drawRect(3, 1, lw, hh);
        g.endFill();
        g.x = 0;
        this._windowContentsSprite.addChild(g);
    };
    Window_LeftList.prototype.createDouseiSprites = function () {
        for (var i = 0; i < this._data.length; i++) {
            var actor = this._data[i];
            if (!actor) {
                return;
            }
            var rect = this.itemRect(i);
            this.createDouseiSprite(actor, rect);
        }
    };
    Window_LeftList.prototype.createDouseiSprite = function (actor, rect) {
        var dousei = actor.dousei();
        var s = new Sprite_Dousei(dousei, rect.y - 18);
        this._windowContentsSprite.addChild(s);
        this._douseiSpriteList.push(s);
    };
    Window_LeftList.prototype.createActorFaceSprites = function () {
        for (var i = 0; i < this._data.length; i++) {
            var actor = this._data[i];
            if (!actor) {
                return;
            }
            this.createActorFaceSprite(actor, i);
        }
    };
    Window_LeftList.prototype.createActorFaceSprite = function (actor, index) {
        var rect = this.itemRect(index);
        var s = new Sprite_SlgActorFace(actor);
        s.y = rect.y - 50;
        s.x = -80;
        this._windowContentsSprite.addChild(s);
        this._faceSpriteList.push(s);
    };
    Window_LeftList.prototype.update = function () {
        _super.prototype.update.call(this);
        var lastVisible = this.visible;
        this.updateFaceVisible();
        //this.updateWarpVisible();
        this.updateVisible();
        this.updateCursorSprite();
        $gameSwitches.setValue(259, this.visible);
        if (!lastVisible && this.visible) {
            this.refreshAll();
        }
        this.updateOpacity();
    };
    Window_LeftList.prototype.updateCursorSprite = function () {
        if (!$gameSwitches.value(472)) {
            this._turoArrowSprite.visible = false;
            return;
        }
        this._turoArrowSprite.x = 202;
        this._turoArrowSprite.y = -10;
        this._turoArrowSprite.visible = true;
    };
    /*updateWarpVisible() {
        this._warpButton.visible = $gameSystem.isWarpOpen();
        this._warpSprite.visible = $gameSystem.isWarpOpen();
    }*/
    Window_LeftList.prototype.itemWidth = function () {
        return 292;
    };
    Window_LeftList.prototype.updateVisible = function () {
        this.visible = this.checkVisible();
    };
    Window_LeftList.prototype.updateOpacity = function () {
        if (this._hideWait > 0 && this.visible) {
            this.alpha = this._hideWait / 6;
        }
        else {
            this.alpha = 1;
        }
    };
    Window_LeftList.prototype.checkVisible = function () {
        if ($gameParty.inDungeon()) {
            return false;
        }
        if ($gameSystem.isEroEvent()) {
            return false;
        }
        if ($gameSystem.isRecollection()) {
            return false;
        }
        if ($gameParty.inBaisyun()) {
            return false;
        }
        if ($gameSwitches.value(42)) {
            return false;
        }
        if ($gameMap._interpreter.isRunning()) {
            if ($gameSwitches.value(52)) {
                this._hideWait = 0;
                return true;
            }
            if (this._hideWait > 0) {
                this._hideWait--;
                if (this._hideWait == 0) {
                    return false;
                }
                return true;
            }
            return false;
        }
        if (!this.inAtelier()) {
            return false;
        }
        this._hideWait = 6;
        return true;
    };
    Window_LeftList.prototype.inAtelier = function () {
        switch ($gameMap.mapId()) {
            case 13: return true;
            case 75: return true;
            case 78: return true;
            case 86: return true;
        }
        return false;
    };
    Window_LeftList.prototype.updateFaceVisible = function () {
        for (var i = 0; i < this._data.length; i++) {
            var actor = this._data[i];
            var f = this._faceSpriteList[i];
            if (!f) {
                return;
            }
            if (!actor) {
                f.visible = false;
                continue;
            }
        }
    };
    Window_LeftList.prototype.refresh = function () {
        this._avButtonList = [];
        $gameSwitches.setValue(REFRESH_ACTOR_LIST_SW, false);
        this._windowContentsSprite.removeChildren();
        this._windowContentsSprite.x = 0;
        this._windowContentsSprite.y = 0;
        _super.prototype.refresh.call(this);
    };
    Window_LeftList.prototype.maxItems = function () {
        if (!this._data) {
            return 0;
        }
        return 3;
    };
    Window_LeftList.prototype.maxCols = function () {
        return 1;
    };
    Window_LeftList.prototype.itemHeight = function () {
        return 244;
    };
    Window_LeftList.prototype.makeItems = function () {
        this._data = [];
        var idList = $gameParty.getActorIdList();
        for (var _i = 0, idList_1 = idList; _i < idList_1.length; _i++) {
            var id = idList_1[_i];
            this._data.push($gameActors.actor(id));
        }
    };
    Window_LeftList.prototype.drawItemBackground = function (index) {
        var actor = this._data[index];
        var bitmap = ImageManager.loadSystem('menu_ui');
        var rect = this.itemRect(index);
        //this.contents.blt(bitmap, 300, 0, 294, 243, rect.x, rect.y);
        if (!actor) {
            //this.contents.blt(bitmap, 300, 0, 294, 243, rect.x, rect.y);
            this.changePaintOpacity(false);
            //this.contents.blt(bitmap, 0, 0, 294, 243, rect.x, rect.y);
            this.changePaintOpacity(true);
            return;
        }
        this.contents.paintOpacity = 240;
        //this.changePaintOpacity(false);
        if (actor.dousei().manId() == 0) {
            //this.contents.blt(bitmap, 300, 0, 294, 243, rect.x, rect.y);
            this.contents.blt(bitmap, 0, 0, 294, 243, rect.x, rect.y);
        }
        else {
            this.contents.blt(bitmap, 0, 0, 294, 243, rect.x, rect.y);
        }
        this.changePaintOpacity(true);
    };
    Window_LeftList.prototype.drawItem = function (index) {
        var actor = this._data[index];
        if (!actor) {
            return;
        }
        var rect = this.itemRect(index);
        if (!actor.dousei().isEnabled()) {
            this.drawName(actor, rect);
        }
        this.createButtons(actor.actorId(), rect);
        //this.createDouseiSprite(actor.actorId(), rect);
        this.createSexSprite(actor.actorId(), rect);
    };
    Window_LeftList.prototype.drawName = function (actor, rect) {
        var name = actor.name();
        this.contents.fontSize = 20;
        this.drawText(name, 150, rect.y + 10, 100);
    };
    Window_LeftList.prototype.createSexSprite = function (actorId, rect) {
        var sex = new Sprite_Sex(actorId, rect);
        this._sexList.push(sex);
        this.addChild(sex);
    };
    Window_LeftList.prototype.createButtons = function (actorId, rect) {
        if ($gameParty.inBaisyun()) {
            return;
        }
        var actor = $gameActors.actor(actorId);
        var button = new Sprite_OverableButton("status");
        var left = rect.x + 234;
        var yy = rect.y + 5;
        var interval = 47;
        button.x = left;
        button.y = yy;
        this._windowContentsSprite.addChild(button);
        button.setClickHandler(this.onStatus.bind(this, actorId));
        if (!actor.dousei().isEnabled()) {
            return;
        }
        var button2 = new Sprite_OverableButton("up", this.canChangeDousei(actor));
        button2.x = left - interval;
        button2.y = yy;
        this._windowContentsSprite.addChild(button2);
        button2.setClickHandler(this.onDousei.bind(this, actorId));
        var button3 = new Sprite_OverableButton("pagedown", this.canBaisyun(actor));
        button3.x = left - interval * 2;
        button3.y = yy;
        this._windowContentsSprite.addChild(button3);
        button3.setClickHandler(this.onBaisyun.bind(this, actorId, button2, button3));
    };
    Window_LeftList.prototype.canChangeDousei = function (actor) {
        if (!$gameSystem.isNight()) {
            //return false;
        }
        /*const dousei = actor.dousei();
        if (dousei.isStartDouseiSex()) {
            return false;
        }*/
        return true;
    };
    Window_LeftList.prototype.canBaisyun = function (actor) {
        if ($gameSystem.isMorning()) {
            return false;
        }
        var dousei = actor.dousei();
        if (dousei.manId() == 0) {
            return false;
        }
        if (actor.actorId() == 3 && dousei.manId() == 2) {
            // サツキとパティ
            return false;
        }
        return true;
        //return actor.dousei().canStartDousei();
    };
    Window_LeftList.prototype.onStatus = function (actorId) {
        if ($gameMap.isEventRunning()) {
            return;
        }
        SoundManager.playOk();
        $gameParty.setMenuActorId(actorId);
        SceneManager.push(Nore.Scene_EroStatus);
    };
    Window_LeftList.prototype.onDousei = function (actorId) {
        if ($gameMap.isEventRunning()) {
            return;
        }
        SoundManager.playOk();
        $gameParty.setMenuActorId(actorId);
        SceneManager.push(Scene_Dousei);
    };
    Window_LeftList.prototype.onBaisyun = function (actorId, button, button2) {
        if ($gameMap.isEventRunning()) {
            return;
        }
        SoundManager.playOk();
        var actor = $gameActors.actor(actorId);
        var dousei = actor.dousei();
        if (dousei.isStartDouseiSex()) {
            //button.enable();
            $gameActors.actor(actorId).dousei().endDouseiSex();
        }
        else {
            //button.disable();
            $gameActors.actor(actorId).dousei().startDouseiSex();
        }
        $gameSwitches.setValue(62, false);
        $gameSwitches.setValue(63, false);
        if (actorId == 2) {
            if ($gamePlayer.isInFloor2()) {
                $gameSwitches.setValue(165, true);
                $gamePlayer.reserveGinaActorScenario();
            }
        }
        //button.disable();
    };
    return Window_LeftList;
}(Window_Selectable));
var Sprite_SlgActorFace = /** @class */ (function (_super) {
    __extends(Sprite_SlgActorFace, _super);
    function Sprite_SlgActorFace(actor) {
        var _this = _super.call(this) || this;
        _this._actor = actor;
        _this._dousei = actor.dousei();
        return _this;
    }
    Sprite_SlgActorFace.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this._lastX != this.getGlobalPosition().x) {
            this.refresh();
        }
        if (this._isStartDousei == this._dousei.isStartDouseiSex()) {
            return;
        }
        this._isStartDousei = this._dousei.isStartDouseiSex();
        this.refresh();
    };
    Sprite_SlgActorFace.prototype.refresh = function () {
        this._lastX = this.getGlobalPosition().x;
        this.removeChildren();
        var rect = new Rectangle(0, 22, 216, 270);
        if (this._lastX == -71) {
            // 初期化した瞬間とずれる。原因不明
            rect.x -= 12;
            rect.y -= 12;
        }
        var actor = JsonEx.makeDeepCopy(this._actor);
        var hoppe = actor.getAcceHoppeId();
        var namida = actor.getNamidaAcceId();
        if (this._isStartDousei) {
            this.changeDouseiSexCos(actor);
            hoppe = 2;
            //actor.setInnerTopId('a');
        }
        actor.setClone(true);
        var face = actor.getDefaultFaceId();
        var s = this.drawTachieActor(actor, this, this.posX() - 0, this.posY() - 40, rect, face, 0.5, hoppe, namida);
        if (s) {
            s.filters = [this.tachieGlowFilter()];
        }
    };
    Sprite_SlgActorFace.prototype.tachieGlowFilter = function () {
        return new PIXI.filters.GlowFilter({ distance: 4, outerStrength: 3, color: 0x000000, quality: 0.7 });
    };
    Sprite_SlgActorFace.prototype.changeDouseiSexCos = function (clone) {
        var cos = this._actor.costume(CostumeSlot.dousei);
        if (!cos) {
            clone.setOuterId('a');
            clone.setInnerBottomId('a');
            clone.setInnerTopId('a');
            if (clone.actorId() == 3) {
                clone.addAcce(1012);
                clone.setPoseId(2);
                clone.setHairId(2);
            }
            clone.setHoppeId(2);
            clone.setAcceHoppeId(2);
            clone.setDefaultFaceId(this.douseiSexFace(clone.actorId()));
            var saver = new CostumeSaver(this._actor.actorId());
            saver.saveCostumeActor(clone, clone.getDefaultFaceId());
            this._actor.setCostume(CostumeSlot.dousei, saver);
            //p('new コスチューム作成')
        }
        else {
            cos.restoreCostume(clone, true);
            clone.setDefaultFaceId(cos.faceId());
            //p('new コスチューム同棲用' + cos.faceId())
        }
    };
    Sprite_SlgActorFace.prototype.douseiSexFace = function (actorId) {
        switch (actorId) {
            case 1: return 19;
            case 2: return 16;
            case 3: return 10;
        }
        return 1;
    };
    Sprite_SlgActorFace.prototype.faceId = function () {
        var actorId = this._actor.actorId();
        switch (actorId) {
            case 8: return 1;
            case 10: return 1;
            case 11: return 2;
        }
        return 4;
    };
    Sprite_SlgActorFace.prototype.posX = function () {
        switch (this._actor.actorId()) {
            case 1: return -10;
            case 3: return 26;
        }
        return 0;
    };
    Sprite_SlgActorFace.prototype.posY = function () {
        switch (this._actor.actorId()) {
            case 2: return 70;
            case 4: return 30;
        }
        return 0;
    };
    return Sprite_SlgActorFace;
}(Sprite));
