var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Sprite_SexCircle = /** @class */ (function (_super) {
    __extends(Sprite_SexCircle, _super);
    function Sprite_SexCircle() {
        var _this = _super.call(this) || this;
        _this.bitmap = ImageManager.loadSystem('menu_ui');
        _this.setFrame(350, 250, 152, 152);
        return _this;
    }
    return Sprite_SexCircle;
}(Sprite));
var Sprite_Sex = /** @class */ (function (_super) {
    __extends(Sprite_Sex, _super);
    function Sprite_Sex(actorId, rect) {
        var _this = _super.call(this) || this;
        _this._actorId = actorId;
        _this._rect = rect;
        _this._dousei = $gameActors.actor(actorId).dousei();
        _this.x = rect.x + 170;
        _this.y = rect.y + 90;
        _this.bitmap = new Bitmap(200, 200);
        _this.initCharacter();
        _this.initBg();
        _this.initCircle();
        _this.visible = false;
        return _this;
    }
    Sprite_Sex.prototype.initCircle = function () {
        this._circle = new Sprite_SexCircle();
        this._circle.x = -6;
        this._circle.y = -6;
        this.addChild(this._circle);
    };
    Sprite_Sex.prototype.initBg = function () {
        var bitmap = ImageManager.loadSystem('sex_bg' + this.actorId());
        this.bitmap.blt(bitmap, 0, 0, bitmap.width, bitmap.height, 0, 0);
    };
    Sprite_Sex.prototype.actorId = function () {
        if (this._actorId == 3 && this._dousei.manId() == 2) {
            // パティとサツキの場合
            return 2;
        }
        return this._actorId;
    };
    Sprite_Sex.prototype.initCharacter = function () {
        this._sexActor = new Game_Sex(this.actorId(), this._dousei);
        this._sexMan = new Game_SexMan(this._actorId, this._sexActor);
        var char = new Sprite_Character(this._sexActor);
        var charMan = new Sprite_Character(this._sexMan);
        this.addChild(charMan);
        this.addChild(char);
        this._charActor = char;
        this._charMan = charMan;
    };
    Sprite_Sex.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateVisible();
        this.updateChar();
        this.updateLayer();
    };
    Sprite_Sex.prototype.updateLayer = function () {
        var type = $gameSystem.timeSexType();
        if (this._lastType != type) {
            //p(this._sexActor.screenY() + ' ' + this._sexMan.screenY())
            if (this._sexActor.screenY() < this._sexMan.screenY()) {
                this.addChild(this._charMan);
            }
            else {
                this.addChild(this._charActor);
            }
        }
        this._lastType = type;
    };
    Sprite_Sex.prototype.updateChar = function () {
        if (this._sexActor) {
            this._sexActor.update();
        }
        if (this._sexMan) {
            this._sexMan.update();
        }
    };
    Sprite_Sex.prototype.updateVisible = function () {
        if (!this._dousei) {
            this.visible = false;
            return;
        }
        this.visible = this._dousei.isStartDouseiSex();
    };
    return Sprite_Sex;
}(Sprite));
var Game_Sex = /** @class */ (function (_super) {
    __extends(Game_Sex, _super);
    function Game_Sex(actorId, dousei) {
        var _this = _super.call(this) || this;
        _this._actorId = actorId;
        _this._dousei = dousei;
        return _this;
    }
    Game_Sex.prototype.characterName = function () {
        if (!this._dousei.isStartDouseiSex()) {
            return '';
        }
        return '$sex0' + this._actorId;
    };
    Game_Sex.prototype.characterIndex = function () {
        return 0;
    };
    Game_Sex.prototype.calcIndex = function () {
    };
    Game_Sex.prototype.hasStepAnime = function () {
        return true;
    };
    Game_Sex.prototype.screenX = function () {
        var type = this.sexType();
        switch (type) {
            case SexType.fela: return 65;
        }
        return 70;
    };
    Game_Sex.prototype.screenY = function () {
        var type = this.sexType();
        switch (type) {
            case 0: return 80 + 50;
            case 1: return 80 + 30;
            case 2: return 80 + 10;
            case SexType.fela: return 80 + 15;
        }
        return 80 + 50;
    };
    Game_Sex.prototype.screenZ = function () {
        var type = this.sexType();
        switch (type) {
            case SexType.seijoui: return 5;
            case SexType.gyaku: return 4;
            case SexType.paizuri: return 4;
            case SexType.fela: return 5;
        }
        return 3;
    };
    Game_Sex.prototype.direction = function () {
        var type = this.sexType();
        switch (type) {
            case 0: return 8;
            case 1: return 2;
            case 2: return 4;
            case 3: return 6;
        }
        return 8;
    };
    Game_Sex.prototype.sexType = function () {
        var type = $gameSystem.timeSexType();
        type += this._dousei.actorId();
        if (type > 3) {
            return type - 4;
        }
        return type;
    };
    return Game_Sex;
}(Game_Character));
var SexType;
(function (SexType) {
    SexType[SexType["seijoui"] = 0] = "seijoui";
    SexType[SexType["fela"] = 3] = "fela";
    SexType[SexType["gyaku"] = 1] = "gyaku";
    SexType[SexType["paizuri"] = 2] = "paizuri";
})(SexType || (SexType = {}));
var Game_SexMan = /** @class */ (function (_super) {
    __extends(Game_SexMan, _super);
    function Game_SexMan(actorId) {
        var _this = _super.call(this) || this;
        _this._actorId = actorId;
        _this._dousei = $gameActors.actor(actorId).dousei();
        _this.refresh();
        return _this;
    }
    Game_SexMan.prototype.manId = function () {
        if (this._actorId == 3 && this._dousei.manId() == 2) {
            return 3;
        }
        return this._dousei.manId();
    };
    Game_SexMan.prototype.characterName = function () {
        if (!this._dousei.isStartDouseiSex()) {
            return '';
        }
        if (this._lastMan != this.manId()) {
            this.refresh();
        }
        return this._lastCharName;
    };
    Game_SexMan.prototype.refresh = function () {
        var manId = this.manId();
        this._lastMan = manId;
        if (manId > 0) {
            var man = $gameActors.actor(manId);
            this._lastCharName = man.characterName();
            this._lastCharIndex = man.characterIndex();
        }
        else {
            this._lastCharName = '';
            this._lastCharIndex = 0;
        }
    };
    Game_SexMan.prototype.characterIndex = function () {
        return this._lastCharIndex + 4;
    };
    Game_SexMan.prototype.hasStepAnime = function () {
        return true;
    };
    Game_SexMan.prototype.screenX = function () {
        var type = this.sexType();
        switch (type) {
            case SexType.fela: return 58;
            case SexType.gyaku: return 70;
            case SexType.paizuri: return 80;
        }
        return 70;
    };
    Game_SexMan.prototype.screenY = function () {
        var type = this.sexType();
        switch (type) {
            case SexType.seijoui:
                if (this.characterName() == 'gob') {
                    return 78;
                }
                return 90;
            case 1: return 115;
            case SexType.paizuri: return 92;
            case SexType.fela: return 95;
        }
        return 90;
    };
    Game_SexMan.prototype.screenZ = function () {
        var type = this.sexType();
        switch (type) {
            case SexType.seijoui: return 4;
            case SexType.gyaku: return 5;
            case SexType.paizuri: return 5;
            case SexType.fela: return 4;
        }
        return 3;
    };
    Game_SexMan.prototype.direction = function () {
        var type = this.sexType();
        switch (type) {
            case 0: return 2;
            case 1: return 8;
            case SexType.paizuri: return 4;
            case SexType.fela: return 6;
        }
        return 2;
    };
    Game_SexMan.prototype.sexType = function () {
        var type = $gameSystem.timeSexType();
        type += this._dousei.actorId();
        if (type > 3) {
            return type - 4;
        }
        return type;
    };
    return Game_SexMan;
}(Game_Character));
