var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var MANKO_ID_LIST = [100, 300, 500, 700, 1000, 1500, 2000];
var ANAL_ID_LIST = [100, 200, 400, 600, 900, 1300, 1600];
var NAKADASHI_COUNT_ACCE_LIST = [
    1101, 1102, 1103, 1104, 1105,
];
var DEPRAVITY_LIST = [20, 40, 60, 80];
var REPUTATION_LIST = [200, 400, 600, 800];
var Nore;
(function (Nore) {
    var MankoSprite = /** @class */ (function (_super) {
        __extends(MankoSprite, _super);
        function MankoSprite(status) {
            var _this = _super.call(this) || this;
            _this._showActionWait = 0;
            _this._actionFaceId = -1;
            _this._status = status;
            _this._frame.width = 300;
            _this._frame.height = 350;
            _this.refresh();
            return _this;
        }
        MankoSprite.prototype.refresh = function () {
            this.removeChildren();
            this.createBackImage();
            this.createBaseImage();
            this.createInmonImage();
            this.createChikubiImage();
            this.createMankoImage();
            this.createAnalImage();
            this.createKuriRingImage();
            this.createNippleRingImage();
            this.createYakiinImage();
            this.createIrezumiImage();
            this.createIrezumi2Image();
            this.createHesoImage();
            this.createSyusanImage();
            this.createKubiwaImage();
            this.createHoppeImage();
            this.createFaceImage();
            this.createKuchiImage();
            this.createNamidaImage();
            this.createMankoRingImage();
            this.createMekakushiImage();
            this.createNakadashiRakugakiImage();
            this.createBontageImage();
            this.createNoseHookImage();
            this.createActionImage();
        };
        MankoSprite.prototype.createBackImage = function () {
            this._backSprite = new PIXI.Sprite(this.getBackImage());
            this.addChild(this._backSprite);
        };
        MankoSprite.prototype.createSyusanImage = function () {
            this._syusanSprite = this.getSyusanSprite();
            if (this._syusanSprite) {
                this.addChild(this._syusanSprite);
            }
        };
        MankoSprite.prototype.createBaseImage = function () {
            this._baseSprite = new PIXI.Sprite(this.getBaseImage());
            this.addChild(this._baseSprite);
        };
        MankoSprite.prototype.createInmonImage = function () {
            this._inmonSprite = new PIXI.Sprite(this.getInmonImage());
            this.addChild(this._inmonSprite);
        };
        MankoSprite.prototype.createChikubiImage = function () {
            this._chikubiSprite = new PIXI.Sprite(this.getChikubiImage());
            this._chikubiSprite.alpha = this._status.chikubiKuroImageAlpha();
            this.addChild(this._chikubiSprite);
        };
        MankoSprite.prototype.createAnalImage = function () {
            this._analSprite = new PIXI.Sprite(this.getAnalImage());
            this.addChild(this._analSprite);
        };
        MankoSprite.prototype.createMankoImage = function () {
            this._mankoSprite = new PIXI.Sprite(this.getMankoImage());
            this.addChild(this._mankoSprite);
            this._mankoKuroSprite = new PIXI.Sprite(this.getMankoKuroImage());
            this._mankoKuroSprite.alpha = this._status.mankoKuroImageAlpha();
            this.addChild(this._mankoKuroSprite);
        };
        MankoSprite.prototype.createIrezumiImage = function () {
            this._irezumiSprite = new PIXI.Sprite(this.getIrezumiImage());
            this.addChild(this._irezumiSprite);
        };
        MankoSprite.prototype.createIrezumi2Image = function () {
            this._irezumi2Sprite = new PIXI.Sprite(this.getIrezumi2Image());
            this.addChild(this._irezumi2Sprite);
        };
        MankoSprite.prototype.createMankoRingImage = function () {
            this._labiaSprite = new PIXI.Sprite(this.getLabiaImage());
            this.addChild(this._labiaSprite);
        };
        MankoSprite.prototype.createYakiinImage = function () {
            this._yakiinSprite = new PIXI.Sprite(this.getYakiinImage());
            this.addChild(this._yakiinSprite);
        };
        MankoSprite.prototype.createNippleRingImage = function () {
            this._nippleSprite = new PIXI.Sprite(this.getNippleImage());
            this.addChild(this._nippleSprite);
        };
        MankoSprite.prototype.createKuriRingImage = function () {
            this._kuriSprite = new PIXI.Sprite(this.getKuriRingImage());
            this.addChild(this._kuriSprite);
        };
        MankoSprite.prototype.createHesoImage = function () {
            this._hesoSprite = new PIXI.Sprite(this.getHesoImage());
            this.addChild(this._hesoSprite);
        };
        MankoSprite.prototype.createKubiwaImage = function () {
        };
        MankoSprite.prototype.createHoppeImage = function () {
            this._hoppeSprite = new PIXI.Sprite(this.getHoppeImage());
            this.addChild(this._hoppeSprite);
        };
        MankoSprite.prototype.createNamidaImage = function () {
            this._namidaSprite = new PIXI.Sprite(this.getNamidaImage());
            this.addChild(this._namidaSprite);
        };
        MankoSprite.prototype.createFaceImage = function () {
            this._faceSprite = new PIXI.Sprite(this.getFaceImage());
            this.addChild(this._faceSprite);
        };
        MankoSprite.prototype.createKuchiImage = function () {
            this._kuchiSprite = new PIXI.Sprite(this.getKuchiImage());
            this.addChild(this._kuchiSprite);
        };
        MankoSprite.prototype.createMekakushiImage = function () {
            this._mekakushiSprite = new PIXI.Sprite(this.getMekakushiImage());
            this.addChild(this._mekakushiSprite);
        };
        MankoSprite.prototype.createNakadashiRakugakiImage = function () {
            this._rakugakiSprite = new PIXI.Sprite(this.getNakadashiRakugakiImage());
            this.addChild(this._rakugakiSprite);
        };
        MankoSprite.prototype.createBontageImage = function () {
            this._bontageSprite = new PIXI.Sprite(this.getBontageImage());
            this.addChild(this._bontageSprite);
        };
        MankoSprite.prototype.createActionImage = function () {
            this._actionSprite = new PIXI.Sprite(this.getActionImage());
            this.addChild(this._actionSprite);
            this._actionSprite.visible = false;
        };
        MankoSprite.prototype.createNoseHookImage = function () {
            this._noseHookSprite = new PIXI.Sprite(this.getNoseHookImage());
            this.addChild(this._noseHookSprite);
        };
        MankoSprite.prototype.getBackImage = function () {
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var backId = 1;
            var text = '%1_%2_status_back_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), backId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getBaseImage = function () {
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var baseId = this._status.baseImageId();
            if (this._status.boteId() > 0) {
                var text = '%1_%2_status_bote_01.png'.format(this.getEroActorId(actorId), eroId.padZero(2));
                return PIXI.utils.TextureCache[text];
            }
            else {
                var text = '%1_%2_status_base_01.png'.format(this.getEroActorId(actorId), eroId.padZero(2));
                return PIXI.utils.TextureCache[text];
            }
        };
        MankoSprite.prototype.getChikubiImage = function () {
            /*if (! this._status.costume().isKuroChikubi()) {
                return null;
            }*/
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var chikubiId = 1;
            var text = '%1_%2_status_kuro_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), chikubiId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getInmonImage = function () {
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var boteId = this._status.costume().boteId();
            var text = '%1_%2_status_inmon_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), boteId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getAnalImage = function () {
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var analId = this._status.analImageId();
            var text = '%1_%2_status_anal_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), analId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getEroActorId = function (actorId) {
            return '0' + actorId;
        };
        MankoSprite.prototype.getMankoImage = function () {
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var mankoId = this._status.mankoImageId();
            var text = '%1_%2_status_manko_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), mankoId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getMankoKuroImage = function () {
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var mankoId = this._status.mankoImageId();
            var text = '%1_%2_status_manko_k_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), mankoId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getIrezumiImage = function () {
            if (!this._status.hasAcce(1080)) {
                return null;
            }
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var boteId = this._status.boteId() + 1;
            var text = '%1_%2_status_irezumi_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), boteId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getIrezumi2Image = function () {
            if (!this._status.hasAcce(1081)) {
                return null;
            }
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var text = '%1_%2_status_irezumi_03.png'.format(this.getEroActorId(actorId), eroId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getLabiaImage = function () {
            if (!this._status.hasAcce(1008)) {
                return null;
            }
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var mankoId = this._status.mankoImageId();
            var text = '%1_%2_status_labia_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), mankoId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getYakiinImage = function () {
            if (!this._status.hasAcce(1000) && !this._status.hasAcce(1001)) {
                return null;
            }
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var boteId = this._status.costume().boteId();
            var text = '%1_%2_yakiin_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), boteId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getNippleImage = function () {
            if (!this._status.hasAcce(1001) && !this._status.hasAcce(1002)) {
                return null;
            }
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var nippleId = 1;
            var text = '%1_%2_status_nipple_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), nippleId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getKuriRingImage = function () {
            if (!this._status.costume().hasAcce(1005)) {
                return null;
            }
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var mankoId = 1;
            /*if (this._status.day() == $gameSystem.day()) {
                mankoId = this._status.beforeMankoImageId();
            }*/
            var text = '%1_%2_status_kuri_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), mankoId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getSeiekiImage = function () {
        };
        MankoSprite.prototype.getSyusanSprite = function () {
            if (!this._status.costume().hasAcce(1021)) {
                return null;
            }
            var s = new PIXI.Sprite();
            var actorId = this._status.actorId();
            var actor = $gameActors.actor(actorId);
            var babyList = actor.babyList();
            for (var i = 0; i < babyList.length; i++) {
                var baby = babyList[i];
                if (!baby.isSyusan()) {
                    continue;
                }
                var index = i + 1;
                var file = this.getSyusanAcceFile(index, baby.isMale());
                if (PIXI.utils.TextureCache[file + '.png']) {
                    s.addChild(new PIXI.Sprite(PIXI.utils.TextureCache[file + '.png']));
                }
            }
            return s;
        };
        MankoSprite.prototype.getSyusanAcceFile = function (syusanCount, male) {
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var boteId = this._status.costume().boteId();
            var actor = $gameActors.actor(actorId);
            if (male) {
                if (boteId == 0) {
                    return '%1_%2_status_syusan_m_%3'.format(this.getEroActorId(actorId), eroId.padZero(2), syusanCount.padZero(2));
                }
                else {
                    return '%1_%2_status_syusan_m_%3_b'.format(this.getEroActorId(actorId), eroId.padZero(2), syusanCount.padZero(2), boteId);
                }
            }
            else {
                if (boteId == 0) {
                    return '%1_%2_status_syusan_f_%3'.format(this.getEroActorId(actorId), eroId.padZero(2), syusanCount.padZero(2));
                }
                else {
                    return '%1_%2_status_syusan_f_%3_b'.format(this.getEroActorId(actorId), eroId.padZero(2), syusanCount.padZero(2), boteId);
                }
            }
        };
        MankoSprite.prototype.getHesoImage = function () {
            if (!this._status.hasAcce(1003) && !this._status.hasAcce(1004)) {
                return null;
            }
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var boteId = this._status.costume().boteId() + 1;
            var text = '%1_%2_status_heso_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), boteId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getBontageImage = function () {
            if (this._status.outerId() != 'c') {
                return null;
            }
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var boteId = 1;
            if (this._status.actorId() == 4 && this._status.boteId() > 0) {
                boteId = 2;
            }
            var text = '%1_%2_status_bontage_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), boteId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getActionImage = function () {
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var actionId = 1;
            var text = '%1_%2_status_action_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), actionId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getFaceImage = function () {
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var faceId = this._status.faceId();
            if (this._actionFaceId > 0) {
                faceId = this._actionFaceId;
            }
            if (this._status.isNoHightlight()) {
                var text_1 = '%1_%2_status_face_%3_n.png'.format(this.getEroActorId(actorId), eroId.padZero(2), faceId.padZero(2));
                if (PIXI.utils.TextureCache[text_1]) {
                    return PIXI.utils.TextureCache[text_1];
                }
            }
            if (this._status.isBottomHightlight()) {
                var text_2 = '%1_%2_status_face_%3_l.png'.format(this.getEroActorId(actorId), eroId.padZero(2), faceId.padZero(2));
                if (PIXI.utils.TextureCache[text_2]) {
                    return PIXI.utils.TextureCache[text_2];
                }
            }
            var text = '%1_%2_status_face_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), faceId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getKuchiImage = function () {
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var kuchiId = this._status.kuchiId();
            var text = '%1_%2_status_kuchi_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), kuchiId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getMekakushiImage = function () {
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var mekakushiId = this._status.mekakushiId();
            var text = '%1_%2_status_mekakushi_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), mekakushiId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getHoppeImage = function () {
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var hoppeId = this._status.hoppeId();
            if (this._showActionWait > 0) {
                hoppeId = 2;
            }
            var text = '%1_%2_status_hoppe_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), hoppeId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getNamidaImage = function () {
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var namidaId = this._status.namidaId();
            var text = '%1_%2_status_namida_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), namidaId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getNoseHookImage = function () {
            if (!this._status.hasAcce(1009)) {
                return null;
            }
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var text = '%1_%2_status_nose_01.png'.format(this.getEroActorId(actorId), eroId.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getNakadashiRakugakiImage = function () {
            var actorId = this._status.actorId();
            var eroId = this.getEroImageId();
            var cos = this._status.costume();
            var nakadashi = this.getNakadashiRakugakiImageId(cos);
            var text = '%1_%2_status_naka_%3.png'.format(this.getEroActorId(actorId), eroId.padZero(2), nakadashi.padZero(2));
            return PIXI.utils.TextureCache[text];
        };
        MankoSprite.prototype.getNakadashiRakugakiImageId = function (cos) {
            var count = 0;
            for (var i = 0; i < NAKADASHI_COUNT_ACCE_LIST.length; i++) {
                var acce = NAKADASHI_COUNT_ACCE_LIST[i];
                if (cos._acceMap[acce]) {
                    count++;
                }
                else {
                    return count;
                }
            }
            return count;
        };
        MankoSprite.prototype.getEroImageId = function () {
            switch (this._status.actorId()) {
                case 4: return 13;
                case 8: return 7;
                case 9: return 5;
                case 10: return 11;
                case 11: return 11;
                case 13: return 14;
                case 17: return 1;
            }
            return 0;
        };
        MankoSprite.prototype.destroy = function () {
            this.removeChildren();
            _super.prototype.destroy.call(this);
        };
        MankoSprite.prototype.update = function () {
            _super.prototype.update.call(this);
            this.updateAction();
            this.updateTouch();
        };
        MankoSprite.prototype.updateAction = function () {
            if (this._showActionWait > 0) {
                this._showActionWait--;
                if (this._showActionWait <= 0) {
                    this._actionFaceId = -1;
                    this.refresh();
                }
            }
        };
        MankoSprite.prototype.showAction = function (faceId) {
            this._showActionWait = 60;
            this._actionFaceId = faceId;
            this.refresh();
            this._actionSprite.visible = true;
        };
        MankoSprite.prototype.setHandler = function (f) {
            this._onClick = f;
        };
        MankoSprite.prototype.updateTouch = function () {
            if (!TouchInput.isTriggered()) {
                return;
            }
            var touchPos = new Point(TouchInput.x, TouchInput.y);
            var localPos = this.worldTransform.applyInverse(touchPos);
            if (this._frame.contains(localPos.x, localPos.y)) {
                if (this._onClick) {
                    this._onClick();
                }
            }
        };
        return MankoSprite;
    }(Sprite));
    Nore.MankoSprite = MankoSprite;
})(Nore || (Nore = {}));
