var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Scene_Map2 = /** @class */ (function (_super) {
    __extends(Scene_Map2, _super);
    function Scene_Map2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_Map2.prototype.createSpriteset = function () {
        this._spriteset = new Spriteset_Map2();
        this.addChild(this._spriteset);
        this._spriteset.update();
    };
    Scene_Map2.prototype.updateTransferPlayer = function () {
        if ($gamePlayer.isTransferring()) {
            SceneManager.goto(Scene_Map2);
        }
    };
    Scene_Map2.prototype.terminate = function () {
        _super.prototype.terminate.call(this);
        if (SceneManager.isNextScene(Scene_Baisyun)) {
            this._spriteset.update();
            this._spriteset._rightTachie.visible = false;
            this._spriteset._dayWindow.visible = false;
            SceneManager.snapForBackground();
        }
    };
    Scene_Map2.prototype.isMenuEnabled = function () {
        if ($gameSystem.isRecollection() && !$gameTemp.isPlaytest()) {
            return false;
        }
        return _super.prototype.isMenuEnabled.call(this);
    };
    Scene_Map2.prototype.callMenu = function () {
        SoundManager.playOk();
        SceneManager.push(Scene_Menu2);
        Window_MenuCommand.initCommandPosition();
        $gameTemp.clearDestination();
        this._mapNameWindow.hide();
        this._waitCount = 2;
    };
    Scene_Map2.prototype.startEncounterEffect = function () {
        //this._spriteset.hideCharacters();
        this._encounterEffectDuration = this.encounterEffectSpeed();
    };
    Scene_Map2.prototype.hideForSnapshot = function () {
        $gameScreen.clearFade();
        _super.prototype.update.call(this);
        this._messageWindow.visible = false;
        this._nameBoxWindow.visible = false;
    };
    Scene_Map2.prototype.showBaisyunLevel = function (before, after, exp) {
        this._spriteset.showBaisyunLevel(before, after, exp);
    };
    Scene_Map2.prototype.hideBaisyunLevel = function () {
        this._spriteset.hideBaisyunLevel();
    };
    Scene_Map2.prototype.refreshRightTachie = function () {
        this._spriteset.refreshRightTachie();
    };
    Scene_Map2.prototype.onMapTouch = function () {
        var x = $gameMap.canvasToMapX(TouchInput.x);
        var y = $gameMap.canvasToMapY(TouchInput.y);
        if ($gameSwitches.value(259)) {
            if (TouchInput.x < 300) {
                return;
            }
        }
        if ($gameParty.inBaisyun()) {
            if (TouchInput.x >= 930) {
                return;
            }
        }
        if (TouchInput.y <= 60) {
            if (TouchInput.x < 300) {
                return;
            }
        }
        $gameTemp.setDestination(x, y);
    };
    Scene_Map2.prototype.updateEncounterEffect = function () {
        if (this._encounterEffectDuration > 0) {
            this._encounterEffectDuration--;
            var speed = this.encounterEffectSpeed();
            var n = speed - this._encounterEffectDuration;
            var p_1 = n / speed;
            var q = ((p_1 - 1) * 20 * p_1 + 5) * p_1 + 1;
            var zoomX = $gamePlayer.screenX();
            var zoomY = $gamePlayer.screenY() - 24;
            if (n === 2) {
                $gameScreen.setZoom(zoomX, zoomY, 1);
                this.snapForBattleBackground();
                this.startFlashForEncounter(speed / 2);
            }
            $gameScreen.setZoom(zoomX, zoomY, q);
            if (n === Math.floor(speed / 6)) {
                this.startFlashForEncounter(speed / 2);
            }
            if (n === Math.floor(speed / 2)) {
                BattleManager.playBattleBgm();
                this.startFadeOut(this.fadeSpeed());
            }
        }
    };
    Scene_Map2.prototype.startFlashForEncounter = function (duration) {
        var color = [255, 255, 255, 205];
        $gameScreen.startFlash(color, duration);
    };
    return Scene_Map2;
}(Scene_Map));
Scene_Load.prototype.onLoadSuccess = function () {
    SoundManager.playLoad();
    this.fadeOutAll();
    this.reloadMapIfUpdated();
    SceneManager.goto(Scene_Map2);
    this._loadSuccess = true;
};
Scene_Title.prototype.commandNewGame = function () {
    DataManager.setupNewGame();
    this._commandWindow.close();
    this.fadeOutAll();
    SceneManager.goto(Scene_Map2);
};
Game_Map.prototype.setupEvents = function () {
    this._events = [];
    this._commonEvents = [];
    for (var _i = 0, _a = $dataMap.events.filter(function (event) { return !!event; }); _i < _a.length; _i++) {
        var event_1 = _a[_i];
        if (event_1.meta[DUNGEON_ITEM_META]) {
            this._events[event_1.id] = new Game_EventItem(this._mapId, event_1.id);
            this._events[event_1.id].setup();
        }
        else {
            this._events[event_1.id] = new Game_Event(this._mapId, event_1.id);
        }
    }
    for (var _b = 0, _c = this.parallelCommonEvents(); _b < _c.length; _b++) {
        var commonEvent = _c[_b];
        this._commonEvents.push(new Game_CommonEvent(commonEvent.id));
    }
    this.refreshTileEvents();
};
Game_Map.prototype.eventById = function (id) {
    for (var _i = 0, _a = this.events(); _i < _a.length; _i++) {
        var e = _a[_i];
        var ee = e;
        if (ee.eventId() == id) {
            return ee;
        }
    }
    return null;
};
