var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var RIGHT_WIDTH = 340;
var Spriteset_Map2 = /** @class */ (function (_super) {
    __extends(Spriteset_Map2, _super);
    function Spriteset_Map2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Spriteset_Map2.prototype.createUpperLayer = function () {
        this.createBaisyunBalloonLayer();
        this.createBasketWindow();
        this.createGemWindow();
        if ($gameParty.inDungeon()) {
            this.createDayWindow();
        }
        _super.prototype.createUpperLayer.call(this);
        if (!$gameParty.inDungeon()) {
            this.createDayWindow();
        }
        //this.createRightBack();
        this.createRightTachie();
        //this.createRecipeWindow();
        this.createLeftList();
        //this.createManInfoWindow();
        this.createFukidashiManager();
        this.createMedalProgressSprite();
        this.createDungeonItemWindow();
        this.createRelicSprite();
        this.createNinshinBarSprite();
        //this.createDebugSprite();
    };
    Spriteset_Map2.prototype.createRelicSprite = function () {
        this._relicSprite = new Sprite_BaisyunRelicMap();
        this._relicSprite.y = 70;
        this.addChild(this._relicSprite);
        if ($gameParty.inBaisyun()) {
            var actor = $gameSystem.baisyunActor();
            var level = actor.baisyunLevel().level();
            var list = $relicManager.relicList(level);
            var result = $relicManager.viewRelicList(list);
            this._relicSprite.setup(result);
        }
    };
    Spriteset_Map2.prototype.createDebugSprite = function () {
        var s = new Sprite();
        s.bitmap = ImageManager.loadSystem('menu');
        this.addChild(s);
    };
    Spriteset_Map2.prototype.createLowerLayer = function () {
        _super.prototype.createLowerLayer.call(this);
    };
    Spriteset_Map2.prototype.createBaisyunBalloonLayer = function () {
        this._baisyunBalloonLayer = new Sprite();
        this.addChild(this._baisyunBalloonLayer);
    };
    Spriteset_Map2.prototype.createRightTachie = function () {
        if (!$gameParty.inBaisyun()) {
            return;
        }
        this._rightTachie = new Sprite_RightTachie();
        this.addChild(this._rightTachie);
    };
    Spriteset_Map2.prototype.createRightBack = function () {
        var color = 0x000000;
        var w = RIGHT_WIDTH;
        var h = Graphics.height;
        var g = new PIXI.Graphics();
        g.beginFill(color, 1);
        g.drawRect(0, 0, w, h);
        g.endFill();
        g.x = Graphics.width - w;
        g.y = 0;
        this.addChild(g);
        this._rightBack = g;
    };
    Spriteset_Map2.prototype.createDayWindow = function () {
        this._dayWindow = new Window_DayAtelier();
        if ($gameParty.inDungeon()) {
            this._dungeonSprite = new Sprite_DayDungeon(this._dayWindow);
            this.addChild(this._dungeonSprite);
        }
        else {
            this._daySprite = new Sprite_DayAtelier(this._dayWindow);
            this.addChild(this._daySprite);
        }
        this.addChild(this._dayWindow);
    };
    Spriteset_Map2.prototype.createBasketWindow = function () {
        this._basketWindow = new Window_Basket();
        this.addChild(this._basketWindow);
        var basket = $gameSystem.basket();
        this._basketWindow.setup(basket);
    };
    Spriteset_Map2.prototype.createGemWindow = function () {
        this._gemWindow = new Window_Gem();
        this.addChild(this._gemWindow);
        var user = $gameParty.user();
        this._gemWindow.setup(user);
    };
    Spriteset_Map2.prototype.createLeftList = function () {
        if ($gameParty.inBaisyun()) {
            return;
        }
        if ($gameParty.inDungeon()) {
            return;
        }
        this._leftList = new Window_LeftList();
        this.addChild(this._leftList);
        if (this._daySprite) {
            this._daySprite.setLeftList(this._leftList);
        }
    };
    Spriteset_Map2.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateRightTachie();
        this.updateRelicVisible();
    };
    Spriteset_Map2.prototype.updateRelicVisible = function () {
        this._relicSprite.updateVisibleMap(this._dayWindow.visible);
    };
    Spriteset_Map2.prototype.updateRightTachie = function () {
        if (this._rightBack) {
            this._rightBack.visible = $gameSystem.isShowRightTachie();
        }
    };
    Spriteset_Map2.prototype.createRecipeWindow = function () {
        if (this._recipeWindow) {
            return;
        }
        this._recipeWindow = new Window_Recipe();
        this.addChild(this._recipeWindow);
    };
    Spriteset_Map2.prototype.createManInfoWindow = function () {
        if (this._manInfoWindow) {
            return;
        }
        this._manInfoWindow = new Window_BaisyunManInfo();
        this.addChild(this._manInfoWindow);
        this._manInfoWindow.hide();
    };
    Spriteset_Map2.prototype.createFukidashiManager = function () {
        this._fukidashiManager = new Sprite_FukidashiManager();
        this.addChild(this._fukidashiManager);
    };
    Spriteset_Map2.prototype.createMedalProgressSprite = function () {
        this._medalProgressSetSprite = new Sprite_MedalProgressSet();
        this.addChild(this._medalProgressSetSprite);
    };
    Spriteset_Map2.prototype.createNinshinBarSprite = function () {
        this._ninshinBarSprite = new Sprite_NinshinBar();
        this.addChild(this._ninshinBarSprite);
    };
    Spriteset_Map2.prototype.createBalloon = function (request) {
        var targetSprite = this.findTargetSprite(request.target);
        if (!targetSprite) {
            return;
        }
        var success = this.createBaisyunBalloon(request, targetSprite);
        if (success) {
            return;
        }
        var sprite = new Sprite_Balloon();
        sprite.targetObject = request.target;
        sprite.setup(targetSprite, request.balloonId);
        this._effectsContainer.addChild(sprite);
        this._balloonSprites.push(sprite);
    };
    Spriteset_Map2.prototype.createBaisyunBalloon = function (request, targetSprite) {
        if (request.balloonId != 4) {
            return false;
        }
        var chara = (targetSprite._character);
        if (!(chara instanceof Game_Event)) {
            return false;
        }
        var event = chara;
        if (!event.event().meta['manId']) {
            return false;
        }
        var manId = parseInt(event.event().meta['manId']);
        var sprite = new Sprite_BaisyunBalloon(manId);
        sprite.targetObject = request.target;
        sprite.setup(targetSprite, request.balloonId);
        this._baisyunBalloonLayer.addChild(sprite);
        //this._balloonSprites.push(sprite);
        return true;
    };
    Spriteset_Map2.prototype.createCharacters = function () {
        this._characterSprites = [];
        this.createEvents();
        this.createVehicles();
        this.createFollowers();
        this.createPlayer();
    };
    Spriteset_Map2.prototype.createEvents = function () {
        for (var _i = 0, _a = $gameMap.events(); _i < _a.length; _i++) {
            var event_1 = _a[_i];
            if (this.createActorEvent(event_1)) {
                continue;
            }
            if (this.createActorEventByMemo(event_1)) {
                continue;
            }
            if (this.isMovableEventItem(event_1)) {
                this._characterSprites.push(new Sprite_EventItem(event_1));
                continue;
            }
            if (this.createBaisyunManEvent(event_1)) {
                continue;
            }
            if (this.createSyusanManEvent(event_1)) {
                continue;
            }
            if (this.createDouseiManEvent(event_1)) {
                continue;
            }
            if (this.createNpcActorEvent(event_1)) {
                continue;
            }
            if (this.createBabyEvent(event_1)) {
                continue;
            }
            if (this.createBabyBedEvent(event_1)) {
                continue;
            }
            if (this.createEndingManEvent(event_1)) {
                continue;
            }
            if (this.createDouseiSexEvent(event_1)) {
                continue;
            }
            this._characterSprites.push(new Sprite_Character(event_1));
        }
    };
    Spriteset_Map2.prototype.createBabyEvent = function (event) {
        if (!event.event()) {
            return false;
        }
        var result = event.event().name.match(/baby_([0-9]+)_([0-9]+)/);
        if (!result) {
            return false;
        }
        var actorId = parseInt(result[1]);
        var index = parseInt(result[2]);
        if (!$gameActors.actor(actorId).babyHistory().hasBaby(index)) {
            return true;
        }
        var baby = $gameActors.actor(actorId).babyHistory().baby(index);
        this._characterSprites.push(new Sprite_BabyCharacter(event, baby));
        return true;
    };
    Spriteset_Map2.prototype.createBabyBedEvent = function (event) {
        if (!event.event()) {
            return false;
        }
        var result = event.event().name.match(/bed_([0-9]+)_([0-9]+)/);
        if (!result) {
            return false;
        }
        var actorId = parseInt(result[1]);
        var index = parseInt(result[2]);
        if (!$gameActors.actor(actorId).babyHistory().hasBaby(index)) {
            return true;
        }
        this._characterSprites.push(new Sprite_Character(event));
        return true;
    };
    Spriteset_Map2.prototype.createActorEvent = function (event) {
        if (!event.event()) {
            return false;
        }
        if (event.event().meta['actor']) {
            var actorId_1 = Math.trunc(event.event().meta['actor']);
            var cos = new CharacterCostume(actorId_1);
            this._characterSprites.push(new Sprite_ActorCharacter(event, cos));
            return true;
        }
        var result = event.characterName().match(/actor([0-9/]+)/);
        if (!result) {
            return false;
        }
        var actorId = Math.trunc(result[1]);
        if (isLayerdActor(actorId)) {
            var cos = new CharacterCostume(actorId);
            this._characterSprites.push(new Sprite_ActorCharacter(event, cos));
            return true;
            ;
        }
        return false;
    };
    Spriteset_Map2.prototype.createDouseiSexEvent = function (event) {
        if (!event.event()) {
            return false;
        }
        if (event.event().meta['douseiSex']) {
            var actorId = Math.trunc(event.event().meta['douseiSex']);
            var s = new Sprite_DouseiSexActor(actorId, event);
            this._characterSprites.push(s);
            return true;
        }
        if (event.event().meta['douseiSexMan']) {
            var actorId = Math.trunc(event.event().meta['douseiSexMan']);
            var s = new Sprite_DouseiSexMan(actorId, event);
            this._characterSprites.push(s);
            return true;
        }
        return false;
    };
    Spriteset_Map2.prototype.createActorEventByMemo = function (event) {
        if (!event.event()) {
            return false;
        }
        if (!event.event().meta['actor']) {
            return false;
        }
        var actorId = Math.trunc(event.event().meta['actor']);
        if (isLayerdActor(actorId)) {
            var cos = new CharacterCostume(actorId);
            this._characterSprites.push(new Sprite_ActorCharacter(event, cos));
            return true;
            ;
        }
        return false;
    };
    Spriteset_Map2.prototype.createSyusanManEvent = function (event) {
        var actorId = this.syusanManId(event);
        if (actorId > 0) {
            var lastBaby = $gameActors.actor(actorId).babyHistory().lastBaby();
            if (!lastBaby || lastBaby.fatherId() == 0) {
                console.error('出産時に女の子の子供がいません');
                return false;
            }
            var manId = lastBaby.fatherId();
            this._characterSprites.push(new Sprite_SyusanMan(manId, event));
            return true;
        }
        return false;
    };
    Spriteset_Map2.prototype.syusanManId = function (event) {
        if (!event) {
            return 0;
        }
        if (!event.event()) {
            return 0;
        }
        if (!event.event().meta['syusanMan']) {
            return 0;
        }
        return parseInt(event.event().meta['syusanMan']);
    };
    Spriteset_Map2.prototype.createBaisyunManEvent = function (event) {
        var manId = this.baisyunManId(event);
        if (manId > 0) {
            if (this.isConditionMatch(manId)) {
                this._characterSprites.push(new Sprite_BaisyunMan(manId, event));
            }
            return true;
        }
        return false;
    };
    Spriteset_Map2.prototype.createDouseiManEvent = function (event) {
        var actorId = this.douseActorId(event);
        if (actorId == 0) {
            return false;
        }
        var actor = $gameActors.actor(actorId);
        var manId = actor.dousei().manId();
        if (manId == 0) {
            return true;
        }
        this._characterSprites.push(new Sprite_DouseiMan(manId, actorId, event));
        return true;
    };
    Spriteset_Map2.prototype.createEndingManEvent = function (event) {
        if (!this.isEndingMan(event)) {
            return false;
        }
        this._characterSprites.push(new Sprite_EndingMan(event));
        return true;
    };
    Spriteset_Map2.prototype.createNpcActorEvent = function (event) {
        var actorId = this.npcActorId(event);
        if (actorId > 0) {
            this._characterSprites.push(new Sprite_NpcCharacter(actorId, event));
            return true;
        }
        return false;
    };
    Spriteset_Map2.prototype.createVehicles = function () {
        for (var _i = 0, _a = $gameMap.vehicles(); _i < _a.length; _i++) {
            var vehicle = _a[_i];
            this._characterSprites.push(new Sprite_Character(vehicle));
        }
    };
    Spriteset_Map2.prototype.createFollowers = function () {
        for (var _i = 0, _a = $gamePlayer.followers().reverseData(); _i < _a.length; _i++) {
            var follower = _a[_i];
            if (!$gameParty.inBaisyun() && follower.actor()) {
                var cos = new CostumeSaver(follower.actor().actorId());
                this._characterSprites.push(new Sprite_Follower(follower, cos));
            }
            else {
                this._characterSprites.push(new Sprite_Character(follower));
            }
        }
    };
    Spriteset_Map2.prototype.createPlayer = function () {
        var cos;
        if ($gameParty.inBaisyun()) {
            cos = new CharacterCostume($gamePlayer.mainActor().actorId());
        }
        else if ($gamePlayer.followers().isVisible()) {
            cos = new CharacterCostume($gameParty.battleMembers()[0].actorId());
        }
        else {
            cos = new CharacterCostume($gamePlayer.mainActor().actorId());
        }
        this._characterSprites.push(new Sprite_Player($gamePlayer, cos));
        for (var _i = 0, _a = this._characterSprites; _i < _a.length; _i++) {
            var sprite = _a[_i];
            this._tilemap.addChild(sprite);
        }
    };
    Spriteset_Map2.prototype.isMovableEventItem = function (event) {
        if (!event) {
            return false;
        }
        if (!event.event()) {
            return false;
        }
        return event.event().meta[DUNGEON_ITEM_META] != null;
    };
    Spriteset_Map2.prototype.douseActorId = function (event) {
        if (!event) {
            return 0;
        }
        if (!event.event()) {
            return 0;
        }
        if (!event.event().meta['douseiActorId']) {
            return 0;
        }
        var actorId = parseInt(event.event().meta['douseiActorId']);
        return actorId;
    };
    Spriteset_Map2.prototype.isEndingMan = function (event) {
        if (!event) {
            return false;
        }
        if (!event.event()) {
            return false;
        }
        if (!event.event().meta['endingMan']) {
            return false;
        }
        return true;
    };
    Spriteset_Map2.prototype.baisyunManId = function (event) {
        if (!event) {
            return 0;
        }
        if (!event.event()) {
            return 0;
        }
        if (!event.event().meta['manId']) {
            return 0;
        }
        return parseInt(event.event().meta['manId']);
    };
    Spriteset_Map2.prototype.npcActorId = function (event) {
        if (!event) {
            return 0;
        }
        if (!event.event()) {
            return 0;
        }
        if (!event.event().meta['actorId']) {
            return 0;
        }
        return parseInt(event.event().meta['actorId']);
    };
    Spriteset_Map2.prototype.isConditionMatch = function (manId) {
        return $gamePlayer.isBaisyunConditionMatch(manId);
    };
    Spriteset_Map2.prototype.createDungeonItemWindow = function () {
        this._dungeonItemWindow = new Window_DungeonItemLog($gameSystem.basket(), $gamePlayer);
        this.addChild(this._dungeonItemWindow);
    };
    Spriteset_Map2.prototype.showBaisyunLevel = function (before, after, exp) {
        if (this._baisyunLevelWindow) {
            this._baisyunLevelWindow.setLevelUpHandler(null);
            this.removeChild(this._baisyunLevelWindow);
        }
        this._baisyunLevelWindow = new Window_BaisyunLevel(before, after, exp);
        this._baisyunLevelWindow.setLevelUpHandler(this.onLevelUp.bind(this));
        this.addChild(this._baisyunLevelWindow);
    };
    Spriteset_Map2.prototype.onLevelUp = function () {
        if (this._rightTachie) {
            this._rightTachie.refresh();
        }
    };
    Spriteset_Map2.prototype.hideBaisyunLevel = function () {
        if (this._baisyunLevelWindow) {
            this.removeChild(this._baisyunLevelWindow);
            this._baisyunLevelWindow = null;
        }
    };
    return Spriteset_Map2;
}(Spriteset_Map));
var _Game_Map_prototype_screenTileX = Game_Map.prototype.screenTileX;
Game_Map.prototype.screenTileX = function () {
    if ($gameSwitches.value(372)) {
        return Math.round(((Graphics.width) / this.tileWidth()) * 16) / 16 - 2;
    }
    else {
        return _Game_Map_prototype_screenTileX.call(this);
    }
};
