/*:ja
 * @target MZ
 * @author ル
 *
 * @command addMedal
 * @text 勲章獲得
 * @des 勲章獲得
 * @arg medalId
 * @type number
 * @text medalId
 * @desc medalId
 * @arg show
 * @type boolean
 *
 * @command addInitialMedal
 * @text ゲーム開始の勲章獲得
 * @des ゲーム開始の勲章獲得
 *
 * @command setCurrentMedal
 * @arg actorId
 * @type number
 * @text actorId
 * @arg medalId
 * @type number
 * @text medalId
 *
 * @command onBaisyun
 * @text 売春した
 * @des 売春した
 * @arg actorId
 * @type number
 *
 * @command onStageChange
 * @text ステージが変わった
 * @arg stage
 * @type number
 *
 * @command onShota
 * @text ショタとセックス
 * @arg actorId
 * @type number
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Medal';
    PluginManager.registerCommand(pluginName, 'addMedal', function (args) {
        if ($gameSystem.isRecollection()) {
            return;
        }
        var medalId = parseInt(args.medalId);
        var show = args.show;
        $gameMedals.addMedal(medalId);
        var progress = new MedalProgress(medalId);
        progress.setProgress(0, 1, 0, 1);
        $gameTemp.addMedalProgress(progress);
        /*
        if (show) {
            const id = '称号獲得_01';
            let normalized = id.normalize('NFC');

            const list = $dataScenario[normalized];

            this.setupChild(list, this._eventId);

            //this._list.push({'code': 357, 'indent': 0, 'parameters': ['Nore_Tes', 'Run', null, {'id': id}]});
        }*/
    });
    PluginManager.registerCommand(pluginName, 'addInitialMedal', function (args) {
        $gameMedals.addInitialMedals();
        for (var i = 1; i <= 5; i++) {
            $gameActors.actor(i).initSetMedal();
        }
    });
    PluginManager.registerCommand(pluginName, 'setCurrentMedal', function (args) {
        var actorId = parseInt(args.actorId);
        var actor = $gameActors.actor(actorId);
        var medalId = parseInt(args.medalId);
        actor.setCurrentMedalId(medalId);
    });
    PluginManager.registerCommand(pluginName, 'onBaisyun', function (args) {
        var actorId = parseInt(args.actorId);
        $gameMedals.onBaisyun(actorId);
    });
    PluginManager.registerCommand(pluginName, 'onStageChange', function (args) {
        var stage = parseInt(args.stage);
        $gameMedals.onStageChange(stage);
    });
    var DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        DataManager_createGameObjects.call(this);
        $gameMedals = new Game_Medals();
    };
    var _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
        _DataManager_extractSaveContents.call(this, contents);
        $gameMedals = contents.medals;
    };
    var _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function () {
        var contents = _DataManager_makeSaveContents.call(this);
        contents.medals = $gameMedals;
        return contents;
    };
})(Nore || (Nore = {}));
var $gameMedals = null;
var MEDAL_ETYPE_ID = 5;
var MEDAL_NOT_FOUND = 9999;
var Game_Medals = /** @class */ (function () {
    function Game_Medals() {
        this._medalMap = {};
        this._medalParamMap = {};
    }
    Game_Medals.prototype.addInitialMedals = function () {
        for (var _i = 0, _a = $medalParamManager.allList(); _i < _a.length; _i++) {
            var param = _a[_i];
            if (param.condition() == MedalCondition.initial) {
                this.addMedal(param.id());
            }
        }
    };
    Game_Medals.prototype.isMedal = function (item) {
        if (!DataManager.isArmor(item)) {
            return false;
        }
        if (item.id < 10) {
            return false;
        }
        return MEDAL_PARAMS[item.id] != null;
    };
    Game_Medals.prototype.actorIconIndex = function (armor) {
        var actorId = parseInt(armor.meta['actor']);
        if (actorId > 0) {
            return $gameActors.actor(actorId).iconIndex();
        }
        else {
            return -1;
        }
    };
    Game_Medals.prototype.medalParamList = function (actorId) {
        var result = [];
        for (var _i = 0, _a = $medalParamManager.allList(); _i < _a.length; _i++) {
            var m = _a[_i];
            if (m.actorId() == 0 || m.actorId() == actorId) {
                result.push(m);
            }
        }
        return result;
    };
    Game_Medals.prototype.armorList = function (actorId) {
        var ret = [];
        for (var i = 500; i < 650; i++) {
            var armor = $dataArmors[i];
            if (this.isMatch(armor, actorId)) {
                ret.push(armor);
            }
        }
        ret = ret.sort(function (a, b) {
            var orderA = a.id;
            var orderB = b.id;
            var actorA = -1;
            var actorB = -1;
            if (a.meta['actor']) {
                actorA = parseInt(a.meta['actor']);
            }
            if (b.meta['actor']) {
                actorB = parseInt(b.meta['actor']);
            }
            if (actorA != actorB) {
                return actorA - actorB;
            }
            if (a.meta['order']) {
                orderA = parseInt(a.meta['order']);
            }
            if (b.meta['order']) {
                orderB = parseInt(b.meta['order']);
            }
            if (orderA == orderB) {
                return b.id - b.id;
            }
            return orderA - orderB;
        });
        return ret;
    };
    Game_Medals.prototype.isMatch = function (armor, actorId) {
        if (!armor) {
            return false;
        }
        if (armor.etypeId != 5) {
            return false;
        }
        if (actorId == -1) {
            return true;
        }
        var id = parseInt(armor.meta['actor']);
        if (id < 0) {
            return true;
        }
        if (actorId != id) {
            return false;
        }
        return true;
    };
    Game_Medals.prototype.addMedal = function (medalId) {
        if (this._medalMap[medalId]) {
            return;
        }
        if ($gameSwitches.value(999)) {
            return;
        }
        if ($gameSystem.stage() >= 1) {
            p('addMedal:' + medalId);
        }
        this._medalMap[medalId] = true;
        var newMedal = $dataArmors[medalId];
        $gameParty.gainItem(newMedal, 1, false);
        //$gameTemp.addItemLog(newMedal);
        return true;
    };
    Game_Medals.prototype.hasMedal = function (id) {
        return this._medalMap[id] == true;
    };
    Game_Medals.prototype.getProgress = function (medalId) {
        if (this._medalMap[medalId]) {
            return 100;
        }
        var info = $medalParamManager.getParam(medalId);
        if (!info) {
            return 0;
        }
        if (info.value() == 0) {
            return 0;
        }
        //var beforeValue = this.findBeforeValue(info[0], info[1]);
        var beforeValue = 0;
        return this.calcProgress(info.condition(), info.value(), beforeValue);
    };
    Game_Medals.prototype.findBeforeValue = function (name, value) {
        var max = 0;
        for (var _i = 0, _a = $medalParamManager.allList(); _i < _a.length; _i++) {
            var param = _a[_i];
            if (param.condition() != name) {
                continue;
            }
            if (param.value() < value) {
                if (max < param.value()) {
                    max = param.value();
                }
            }
        }
        return max;
    };
    Game_Medals.prototype.calcProgress = function (type, max, beforeValue) {
        var n = this._updateParam(type, 0);
        var per = Math.floor((n - beforeValue) * 100 / (max - beforeValue));
        if (per > 100) {
            per = 100;
        }
        if (per < 0) {
            per = 0;
        }
        return per;
    };
    Game_Medals.prototype.checkGet = function (type) {
        for (var _i = 0, _a = $medalParamManager.allList(); _i < _a.length; _i++) {
            var param = _a[_i];
            if (param.condition() != type) {
                continue;
            }
            if (this.getProgress(param.id()) >= 100) {
                this.addMedal(param.id());
            }
        }
    };
    Game_Medals.prototype.onActiveSkill = function (skill) {
        if (skill.meta['userActor']) {
            var actorId = parseInt(skill.meta['userActor']);
            if (actorId == 1) {
                this._updateParam('bomb', 1);
            }
        }
    };
    Game_Medals.prototype.onAlchemyLevelChange = function (level) {
        this._updateMaxParam('alchemyLevel', level);
    };
    Game_Medals.prototype.onFriehdshipLevelChange = function (level, actorId, manId) {
        var key = 'friendship%1_%2'.format(actorId, manId);
        this._updateMaxParam(key, level);
    };
    Game_Medals.prototype.onSyusan = function (actorId, count) {
        var key = 'syusan%1'.format(actorId);
        this._updateMaxParam(key, count);
    };
    Game_Medals.prototype.onKekkon = function (actorId, count) {
        var key = 'kekkon%1'.format(actorId);
        this._updateMaxParam(key, count);
    };
    Game_Medals.prototype.onVictory = function () {
        this._updateParam('victory', 1);
    };
    Game_Medals.prototype.onDefeat = function () {
        this._updateParam('defeat', 1);
    };
    Game_Medals.prototype.onExp = function (n) {
        if (n <= 0) {
            return;
        }
        this._updateParam('exp', n);
    };
    Game_Medals.prototype.onGold = function (n) {
        if (n <= 0) {
            return;
        }
        this._updateParam('gold', n);
    };
    Game_Medals.prototype.onLoseGold = function (n) {
        if (n <= 0) {
            return;
        }
        this._updateParam('loseGold', n);
    };
    Game_Medals.prototype.onUseItem = function (itemId) {
        if (itemId <= 0) {
            return;
        }
        this._updateParam('item' + itemId, 1);
        this._updateParam('item', 1);
    };
    Game_Medals.prototype.onBaisyun = function (actorId) {
        this._updateParam('baisyun' + actorId, 1);
        this._updateParam('baisyunAll', 1);
    };
    Game_Medals.prototype.onShota = function (count) {
        this._updateMaxParam('shota', count);
    };
    Game_Medals.prototype.onEncyclopedia = function (rate) {
        this._updateMaxParam('compEncyclopedia', rate);
    };
    Game_Medals.prototype.onDoutei = function (count) {
        this._updateMaxParam('doutei', count);
    };
    Game_Medals.prototype.onSyusanMan = function (actorId, manId, count) {
        var key = 'syusan' + actorId + '_' + manId;
        this._updateMaxParam(key, count);
    };
    Game_Medals.prototype.onSyusanKind = function (actorId, count) {
        this._updateMaxParam('syusanKind' + actorId, count);
    };
    Game_Medals.prototype.onSex = function (actorId, manId, count) {
        var key = 'sexCount' + actorId + '_' + manId;
        this._updateMaxParam(key, count);
    };
    Game_Medals.prototype.onBaisyunMan = function (actorId, manId, count) {
        var key = 'baisyunCount' + actorId + '_' + manId;
        this._updateMaxParam(key, count);
    };
    Game_Medals.prototype.onMilk = function (actorId, count) {
        this._updateMaxParam('milk' + actorId, count);
    };
    Game_Medals.prototype.onStageChange = function (stage) {
        this._updateMaxParam('stage', stage);
    };
    Game_Medals.prototype.onOtokonoko = function (n) {
        this._updateMaxParam('otokonoko', n);
    };
    Game_Medals.prototype.onRyoutou = function (n) {
        this._updateMaxParam('ryoutou', n);
    };
    Game_Medals.prototype.onFella = function (actorId) {
        this._updateParam('fella' + actorId, 1);
    };
    Game_Medals.prototype.onOverkill = function (overkill) {
        this._updateMaxParam('overkill', overkill);
    };
    Game_Medals.prototype._updateParam = function (name, plus) {
        if ($gameSwitches.value(999)) {
            // 回想中は称号獲得しない
            return;
        }
        var map = this._medalParamMap;
        map[name] = map[name] || 0;
        var current = map[name];
        map[name] += plus;
        if (plus > 0) {
            var medalId = this.findNext(name, current);
            if (medalId == MEDAL_NOT_FOUND) {
                return map[name];
            }
            var lowValue = this.findBeforeValue(name, current + plus);
            var nextParam = $medalParamManager.getParam(medalId);
            var totalValue = nextParam.value();
            this.onUpdate(medalId, totalValue, lowValue, current, plus);
            this.checkGet(name);
        }
        return map[name];
    };
    Game_Medals.prototype.onUpdate = function (medalId, totalValue, lowValue, current, plus) {
        var progress = new MedalProgress(medalId);
        progress.setProgress(current, totalValue, lowValue, plus);
        $gameTemp.addMedalProgress(progress);
    };
    Game_Medals.prototype._updateMaxParam = function (name, newValue) {
        if ($gameSwitches.value(999)) {
            // 回想中は称号獲得しない
            return;
        }
        var map = this._medalParamMap;
        map[name] = map[name] || 0;
        var before = map[name];
        if (map[name] > newValue) {
            return map[name];
        }
        if (before == newValue) {
            return;
        }
        map[name] = newValue;
        var medalId = this.findNext(name, before);
        var nextParam = $medalParamManager.getParam(medalId);
        if (!nextParam) {
            return;
        }
        var totalValue = nextParam.value();
        this.onUpdate(medalId, totalValue, 0, before, newValue - before);
        this.checkGet(name);
        return map[name];
    };
    Game_Medals.prototype.findNext = function (name, value) {
        var min = 9999;
        var medalId = MEDAL_NOT_FOUND;
        for (var _i = 0, _a = $medalParamManager.allList(); _i < _a.length; _i++) {
            var param = _a[_i];
            if (param.condition() != name) {
                continue;
            }
            if (param.value() > value) {
                if (min > param.value()) {
                    min = param.value();
                    medalId = param.id();
                }
            }
        }
        return medalId;
    };
    Game_Medals.prototype.onBreak = function () {
        this._updateParam('break', 1);
    };
    Game_Medals.prototype.onKill = function () {
        this._updateParam('kill', 1);
    };
    Game_Medals.prototype.onNoDamage = function () {
        this._updateParam('nodamage', 1);
    };
    Game_Medals.prototype.medalListByActorId = function (actorId) {
        var result = [];
        for (var key in this._medalMap) {
            var param = $medalParamManager.getParam(parseInt(key));
            if (!param) {
                console.error(key + 'の medalParam が見つかりません');
                continue;
            }
            if (param.actorId() == actorId) {
                result.push(param);
            }
        }
        return result;
    };
    return Game_Medals;
}());
var MedalProgress = /** @class */ (function () {
    function MedalProgress(armorId) {
        this._armorId = armorId;
    }
    MedalProgress.prototype.setProgress = function (before, total, lowValue, plus) {
        this._before = before;
        this._total = total;
        this._lowValue = lowValue;
        this._plus = plus;
    };
    MedalProgress.prototype.armorId = function () {
        return this._armorId;
    };
    MedalProgress.prototype.plus = function () {
        return this._plus;
    };
    MedalProgress.prototype.addPlus = function (n) {
        this._plus += n;
    };
    MedalProgress.prototype.total = function () {
        return this._total;
    };
    MedalProgress.prototype.before = function () {
        return this._before;
    };
    return MedalProgress;
}());
Game_Variables.prototype.value = function (variableId) {
    if (variableId >= ACTOR1_MEDAL_NAME_VAR && variableId <= ACTOR5_MEDAL_NAME_VAR) {
        return this._data[variableId];
    }
    return this._data[variableId] || 0;
};
