/*:ja
 * @target MZ
 * @author ル
 *
 * @command onShota
 * @text ショタとセックス
 * @arg actorId
 * @type number
 *
 * @command onSyusan
 * @text 出産
 * @arg actorId
 * @type number
 *
 * @command checkMilk
 * @text 母乳販売称号判定
 *
 * @command onBaisyun
 * @text 売春実行
 *
 * @command onEncyclopedia
 * @text 図鑑コンプ称号判定
 *
 * @command onSex
 * @text セックス回数判定
 * @arg actorId
 * @type number
 *
 * @command onOtokonoko
 * @text パティセックス回数判定
 *
 * @command checkFriendship
 * @text 友好度判定
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_MedalHelper';
    PluginManager.registerCommand(pluginName, 'onShota', function (args) {
        var actorId = parseInt(args.actorId);
        if (actorId != 2) {
            console.error('想定外のactorです');
            return;
        }
        var helper = new MedalHelper();
        $gameMedals.onShota(helper.shotaCount());
        $gameMedals.onDoutei(helper.douteiCount());
    });
    PluginManager.registerCommand(pluginName, 'onSyusan', function (args) {
        var actorId = parseInt(args.actorId);
        var helper = new MedalHelper();
        $gameMedals.onSyusanKind(actorId, helper.syusanKind(actorId));
        if (actorId == 2) {
            var goblinId = 144;
            var goblinCount = $gameActors.actor(actorId).babyHistory().syusanBabyListByMan(goblinId).length;
            $gameMedals.onSyusanMan(actorId, goblinId, goblinCount);
        }
        if (actorId == 1) {
            var goblinId = 150;
            var goblinCount = $gameActors.actor(actorId).babyHistory().syusanBabyListByMan(goblinId).length;
            $gameMedals.onSyusanMan(actorId, goblinId, goblinCount);
        }
    });
    PluginManager.registerCommand(pluginName, 'checkMilk', function (args) {
        var helper = new MedalHelper();
        $gameMedals.onMilk(1, helper.milkCount(1));
        $gameMedals.onMilk(2, helper.milkCount(2));
    });
    PluginManager.registerCommand(pluginName, 'onBaisyun', function (args) {
        var actorId = $gameSystem.baisyunActorId();
        var manId = $gameVariables.value(BAISYUN_MAN_ID);
        var helper = new MedalHelper();
        var count = helper.countBaisyun(actorId, manId) + 1;
        $gameMedals.onBaisyunMan(actorId, manId, count);
    });
    PluginManager.registerCommand(pluginName, 'onEncyclopedia', function (args) {
        var pictralBook = new PictralBook();
        var rate = pictralBook.collectionRate();
        $gameMedals.onEncyclopedia(rate);
    });
    PluginManager.registerCommand(pluginName, 'onSex', function (args) {
        var actorId = parseInt(args.actorId);
        if (actorId == 1) {
            var sanzokuId = 146;
            var count = $gameParty.dayResultHistory().countBaisyunOrDouseiMan(actorId, sanzokuId);
            $gameMedals.onSex(actorId, sanzokuId, count);
            var vagrantId = 151;
            var count2 = $gameParty.dayResultHistory().countBaisyunOrDouseiMan(actorId, vagrantId);
            $gameMedals.onSex(actorId, vagrantId, count2);
        }
        if (actorId == 2) {
            var vagrantId = 104;
            var count = $gameParty.dayResultHistory().countBaisyunOrDouseiMan(actorId, vagrantId);
            $gameMedals.onSex(actorId, vagrantId, count);
        }
    });
    PluginManager.registerCommand(pluginName, 'onOtokonoko', function (args) {
        var list = $gameParty.dayResultHistory().makeHistory(3);
        var n = 0;
        var n2 = 0;
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var h = list_1[_i];
            n += h.otokonoko();
            n2 += h.sexCount();
        }
        $gameMedals.onOtokonoko(n);
        var total = Math.min(5, n) + Math.min(5, n2);
        $gameMedals.onRyoutou(total);
    });
    PluginManager.registerCommand(pluginName, 'checkFriendship', function (args) {
        var f = $gameActors.actor(2).friendshipActor();
        var l_107 = f.friendshipLevel(107); // レックス
        var l_111 = f.friendshipLevel(111); // メイヴィス
        if (l_107.value() > 0) {
            $gameMedals.onFriehdshipLevelChange(l_107.value(), 2, 107);
        }
        if (l_111.value() > 0) {
            $gameMedals.onFriehdshipLevelChange(l_111.value(), 2, 111);
        }
    });
})(Nore || (Nore = {}));
var MedalHelper = /** @class */ (function () {
    function MedalHelper() {
    }
    MedalHelper.prototype.shotaCount = function () {
        var n = this.douteiCount();
        // レックス初回
        if ($gameSwitches.value(1025)) {
            n++;
        }
        return n;
    };
    MedalHelper.prototype.douteiCount = function () {
        var n = 0;
        // パティ初回
        if ($gameSwitches.value(1031)) {
            n++;
        }
        // ロアン初回
        if ($gameSwitches.value(1163)) {
            n++;
        }
        return n;
    };
    MedalHelper.prototype.syusanKind = function (actorId) {
        var map = {};
        var list = $gameActors.actor(actorId).babyHistory().babyList();
        for (var _i = 0, list_2 = list; _i < list_2.length; _i++) {
            var baby = list_2[_i];
            map[baby.fatherId()] = true;
        }
        var n = 0;
        for (var key in map) {
            n++;
        }
        return n;
    };
    MedalHelper.prototype.milkCount = function (actorId) {
        if (actorId == 1) {
            return $gameVariables.value(Nore.ROSALIE_TOTAL_SELL_MILK_VAR);
        }
        else if (actorId == 2) {
            return $gameVariables.value(Nore.SATSUKI_TOTAL_SELL_MILK_VAR);
        }
        else {
            console.error('不正な母乳販売者です:' + actorId);
            return 0;
        }
    };
    MedalHelper.prototype.countBaisyun = function (actorId, manId) {
        var list = $gameParty.dayResultHistory().makeHistory(actorId);
        var n = 0;
        for (var _i = 0, list_3 = list; _i < list_3.length; _i++) {
            var h = list_3[_i];
            if (h.manId() != manId) {
                continue;
            }
            if (h.isBaisyun()) {
                n++;
            }
        }
        return n;
    };
    return MedalHelper;
}());
