var MEDAL_INFO = {
    500: ['goblin', 1],
    501: ['baisyun2', 1],
    502: ['baisyun2', 5],
    511: ['fella2', 10],
    512: ['fella2', 20],
    521: ['victory', 10],
    531: ['break', 10],
    541: ['kill', 10],
    542: ['kill', 50],
    546: ['nodamage', 5],
    551: ['baisyun1', 1],
    552: ['baisyun1', 5],
    601: ['fella1', 10],
};
function findMedalValue(armor) {
    var list = MEDAL_INFO[armor.id];
    if (!list) {
        return 0;
    }
    return list[1];
}
var MedalUpdateInfo = /** @class */ (function () {
    function MedalUpdateInfo() {
        this.updateMap = {};
    }
    MedalUpdateInfo.prototype.onUpdate = function (medalId, name, before, plus, base) {
        if (name == 'step') {
            return false;
        }
        var next = this.findMedalNext(name, before);
        if (!next) {
            return false;
        }
        this.updateMap[name] = this.updateMap[name] || { medalId: medalId, name: name, before: 0, plus: 0, next: next, base: 0 };
        var info = this.updateMap[name];
        info.plus += plus;
        if (info.before === 0) {
            info.before = before;
            info.base = base;
        }
        return true;
    };
    MedalUpdateInfo.prototype.nextInfo = function () {
        var min;
        for (var key in this.updateMap) {
            var info = this.updateMap[key];
            if (!min || min.medalId > info.medalId) {
                min = info;
            }
            break;
        }
        if (!min) {
            return null;
        }
        delete this.updateMap[min.name];
        return min;
    };
    MedalUpdateInfo.prototype.findMedalNext = function (name, before) {
        var min = 999999;
        var found = false;
        for (var id in MEDAL_INFO) {
            var info = MEDAL_INFO[id];
            if (info[0] != name) {
                continue;
            }
            var value = info[1];
            if (value <= before) {
                continue;
            }
            if (min > value) {
                min = value;
                found = true;
            }
        }
        if (found) {
            return min;
        }
    };
    return MedalUpdateInfo;
}());
var $medalUpdate = new MedalUpdateInfo();
