var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Scene_Medal = /** @class */ (function (_super) {
    __extends(Scene_Medal, _super);
    function Scene_Medal() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_Medal.prototype.create = function () {
        this._actorId = $gameParty.menuActor().actorId();
        _super.prototype.create.call(this);
        this.createHelpWindow();
        this.createCategoryWindow();
        this.createMedalWindow();
    };
    Scene_Medal.prototype.createHelpWindow = function () {
        var rect = this.helpWindowRect();
        rect.y = 0;
        this._helpWindow = new Window_Help(rect);
        this.addWindow(this._helpWindow);
    };
    Scene_Medal.prototype.createCategoryWindow = function () {
        var y = this._helpWindow.height;
        var r = new Rectangle(0, y, Graphics.boxWidth, 80);
        this._categoryWindow = new Window_MedalCategory(r);
        this.addWindow(this._categoryWindow);
        this._categoryWindow.activate();
        this._categoryWindow.refresh();
        this._categoryWindow.setHandler('ok', this.onCategoryOk.bind(this));
        this._categoryWindow.setHandler('change', this.onCategoryChange.bind(this));
        this._categoryWindow.setHandler('cancel', this.popScene.bind(this));
        this._categoryWindow.select(0);
        this._categoryWindow.activate();
    };
    Scene_Medal.prototype.createMedalWindow = function () {
        var y = this._helpWindow.height + this._categoryWindow.height;
        var r = new Rectangle(0, y, Graphics.boxWidth, Graphics.boxHeight - y);
        var actorId = this._categoryWindow.selectedActorId();
        this._medalWindow = new Window_Medal(r, actorId);
        this.addWindow(this._medalWindow);
        this._medalWindow.deactivate();
        this._medalWindow.refresh();
        this._medalWindow.setHandler('change', this.onChange.bind(this));
        this._medalWindow.setHandler('cancel', this.onMedalCancel.bind(this));
        this._medalWindow.select(0);
    };
    Scene_Medal.prototype.onCategoryOk = function () {
        this._medalWindow.activate();
    };
    Scene_Medal.prototype.onMedalCancel = function () {
        this._categoryWindow.activate();
    };
    Scene_Medal.prototype.onCategoryChange = function () {
        var actorId = this._categoryWindow.selectedActorId();
        p('actorId:' + actorId);
        if (this._medalWindow) {
            this._medalWindow.setActorId(actorId);
        }
    };
    Scene_Medal.prototype.onChange = function () {
        var item = this._medalWindow.item();
        if (!item) {
            return;
        }
        this._helpWindow.setText(this.getMedalDescription(item));
    };
    Scene_Medal.prototype.getMedalDescription = function (armor) {
        var text = '';
        if (armor.meta['hint']) {
            var value = findMedalValue(armor);
            var name_1 = '';
            if (armor.meta['actor']) {
                var actorId = parseInt(armor.meta['actor']);
                if (actorId > 0) {
                    var actor = $gameActors.actor(actorId);
                    name_1 = actor.name();
                }
            }
            if (armor.meta['before']) {
                var before = Math.trunc(armor.meta['before']);
                if (!$gameMedals.hasMedal(before)) {
                    return '？？？';
                }
            }
            var hintText = armor.meta['hint'];
            if (ConfigManager.language == 'en' && armor.meta['hintEn']) {
                hintText = armor.meta['hintEn'];
            }
            text += '\\C[16]' + TextManager.medalCondition + ':\\C[0] ' + hintText.format(value, name_1) + '\n';
        }
        if (armor.meta['rewardCard']) {
            var skillId = parseInt(armor.meta['rewardCard']);
            var card = $dataSkills[skillId];
            text += '\\C[16]' + TextManager.medalEffect3 + ':\\C[0] ' + getItemName(card);
        }
        return text;
    };
    return Scene_Medal;
}(Scene_MenuBase));
var Window_MedalCategory = /** @class */ (function (_super) {
    __extends(Window_MedalCategory, _super);
    function Window_MedalCategory(r) {
        var _this = _super.call(this, r) || this;
        _this.select(0);
        return _this;
    }
    Window_MedalCategory.prototype.maxItems = function () {
        return this.actorIdList().length;
    };
    Window_MedalCategory.prototype.maxCols = function () {
        return this.maxItems();
    };
    Window_MedalCategory.prototype.drawItem = function (index) {
        this.contents.fontSize = 22;
        var rect = this.itemRect(index);
        var yOffset = 7;
        var actorId = this.actorIdList()[index];
        if (actorId < 0) {
            this.drawText('ALL', rect.x, rect.y + yOffset, rect.width, 'center');
        }
        else if (actorId == 0) {
            this.drawText('COMMON', rect.x, rect.y + yOffset, rect.width, 'center');
        }
        else {
            var actor = $gameActors.actor(actorId);
            var iconIndex = actor.iconIndex();
            this.drawIcon(iconIndex, rect.x, rect.y + 2);
            this.drawText(actor.name(), rect.x + 32, rect.y + yOffset, rect.width, 'left');
        }
    };
    Window_MedalCategory.prototype.actorIdList = function () {
        return [-1, 0, 2, 1, 3, 4]; //, EVENT_OFF, EVENT_ON];
    };
    Window_MedalCategory.prototype.selectedActorId = function () {
        return this.actorIdList()[this.index()];
    };
    Window_MedalCategory.prototype.selectActor = function (actorId) {
        var index = this.actorIdList().indexOf(actorId);
        this.select(index);
    };
    return Window_MedalCategory;
}(Window_Selectable));
var Window_Medal = /** @class */ (function (_super) {
    __extends(Window_Medal, _super);
    function Window_Medal(r, actorId) {
        var _this = _super.call(this, r) || this;
        _this._armorList = [];
        _this._actorId = actorId;
        return _this;
    }
    Window_Medal.prototype.refresh = function () {
        this.makeItems();
        _super.prototype.refresh.call(this);
    };
    Window_Medal.prototype.setActorId = function (actorId) {
        this._actorId = actorId;
        this.refresh();
    };
    Window_Medal.prototype.makeItems = function () {
        this._armorList = $gameMedals.armorList(this._actorId);
    };
    Window_Medal.prototype.maxItems = function () {
        return this._armorList.length;
    };
    Window_Medal.prototype.maxCols = function () {
        return 2;
    };
    Window_Medal.prototype.lineHeight = function () {
        return 48;
    };
    Window_Medal.prototype.drawItem = function (index) {
        var item = this._armorList[index];
        if (item) {
            var rect = this.itemRect(index);
            rect.width -= 20;
            var enabled = this.isEnabled(item);
            this.changePaintOpacity(enabled);
            this.contents.fontSize = 28;
            var offsetX = 36;
            var iconIndex = $gameMedals.actorIconIndex(item);
            if (iconIndex) {
                this.drawIcon(iconIndex, rect.x + 6, rect.y + 4);
            }
            if (enabled) {
                this.drawItemName(item, rect.x + 4 + offsetX, rect.y, rect.width);
            }
            else {
                this.drawItemName2(item, rect.x + offsetX, rect.y);
                this.drawProgress(item, rect.x + offsetX + rect.width - 70, rect.y, enabled);
            }
            this.changePaintOpacity(true);
        }
    };
    Window_Medal.prototype.isEnabled = function (item) {
        return $gameMedals.hasMedal(item.id);
    };
    Window_Medal.prototype.item = function () {
        return this._armorList[this.index()];
    };
    Window_Medal.prototype.drawItemName2 = function (item, x, y) {
        var width = 382;
        if (item) {
            var iconBoxWidth = this.lineHeight();
            var padding = (iconBoxWidth - Window_Base._iconWidth) / 2;
            this.resetTextColor();
            this.drawIcon(item.iconIndex, x + 4, y + 4);
            //this.drawIcon2(item, x, y, width)
            var name = '';
            for (var i = 0; i < item.name.length; i++) {
                name += '？';
            }
            this.drawText(name, x + iconBoxWidth - 8, y, width - iconBoxWidth);
        }
    };
    Window_Medal.prototype.drawProgress = function (item, x, y, enabled) {
        var progress = $gameMedals.getProgress(item.id);
        var color1 = ColorManager.hpGaugeColor1();
        var color2 = ColorManager.hpGaugeColor2();
        if (progress >= 100) {
            color1 = color2 = ColorManager.textColor(24);
        }
        this.changePaintOpacity(true);
        this.drawGauge(x - 120, y + 16, 120, progress / 100, color1, color2);
        this.contents.fontSize = 20;
        this.changePaintOpacity(enabled);
        this.drawText('' + progress + '%', x, y, 50, 'right');
    };
    Window_Medal.prototype.drawGauge = function (x, y, width, rate, color1, color2) {
        var fillW = Math.floor((width - 2) * rate);
        var height = 14;
        var fillH = height - 2;
        var color0 = '#111111';
        var color3 = '#BBBBBB';
        this.contents.fillRect(x, y, width, height, color3);
        this.contents.fillRect(x + 1, y + 1, width - 2, fillH, color0);
        this.contents.gradientFillRect(x + 1, y + 1, fillW, fillH, color1, color2);
    };
    ;
    return Window_Medal;
}(Window_Selectable));
var Sprite_MedalProgressSet = /** @class */ (function (_super) {
    __extends(Sprite_MedalProgressSet, _super);
    function Sprite_MedalProgressSet() {
        var _this = _super.call(this) || this;
        _this._list = [];
        _this.x = 300;
        _this.y = 10;
        return _this;
    }
    Sprite_MedalProgressSet.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateNewProgress();
        this.updateRemoveProgress();
    };
    Sprite_MedalProgressSet.prototype.updateNewProgress = function () {
        var list = $gameTemp.medalProgressList();
        $gameTemp.clearMedalProgress();
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var pro = list_1[_i];
            this.addMedalProgress(pro);
        }
    };
    Sprite_MedalProgressSet.prototype.addMedalProgress = function (progress) {
        var param = $medalParamManager.getParam(progress.armorId());
        if (!param) {
            console.error(progress.armorId() + 'のMEDAL_PARAM が見つかりません');
            return;
        }
        if (param.condition() == MedalCondition.initial) {
            return;
        }
        if (param.id() == 0) {
            return;
        }
        var s = new Sprite_MedalProgress(progress);
        s.y = this._list.length * 36;
        this._list.push(s);
        this.addChild(s);
    };
    Sprite_MedalProgressSet.prototype.updateRemoveProgress = function () {
        var removeList = null;
        for (var _i = 0, _a = this._list; _i < _a.length; _i++) {
            var pr = _a[_i];
            if (pr.isFinished()) {
                removeList = removeList || [];
                removeList.push(pr);
            }
        }
        if (!removeList) {
            return;
        }
        for (var _b = 0, removeList_1 = removeList; _b < removeList_1.length; _b++) {
            var pr = removeList_1[_b];
            this.removeChild(pr);
            var index = this._list.indexOf(pr);
            this._list.splice(index, 1);
        }
    };
    return Sprite_MedalProgressSet;
}(Sprite));
var Sprite_MedalProgress = /** @class */ (function (_super) {
    __extends(Sprite_MedalProgress, _super);
    function Sprite_MedalProgress(progress) {
        var _this = _super.call(this) || this;
        if ($gameSystem.isEroEvent()) {
            _this.x += 440;
        }
        _this._progress = progress;
        _this.bitmap = new Bitmap(600, 60);
        var param = $medalParamManager.getParam(progress.armorId());
        _this._label = param.conditionText();
        _this._name = param.name();
        _this._actorId = param.actorId();
        _this._startRate = progress.before() / progress.total();
        _this._endRate = Math.min(1, (progress.before() + progress.plus()) / progress.total());
        _this._frameCount = 0;
        _this.refresh();
        return _this;
    }
    Sprite_MedalProgress.prototype.isFinished = function () {
        return this._finished;
    };
    Sprite_MedalProgress.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this._fadeOut) {
            this.updateFade();
            return;
        }
        if (this._frameCount == this.maxFrameCount()) {
            this._fadeOut = true;
            this._fadeWait = 60;
            this.refresh();
            return;
        }
        this._frameCount++;
        this.refresh();
    };
    Sprite_MedalProgress.prototype.updateFade = function () {
        if (this._fadeWait > 0) {
            this._fadeWait--;
            return;
        }
        this.alpha -= 0.03;
        if (this.alpha <= 0.1) {
            this._finished = true;
        }
    };
    Sprite_MedalProgress.prototype.maxFrameCount = function () {
        return 60;
    };
    Sprite_MedalProgress.prototype.refresh = function () {
        this.bitmap.clear();
        this.drawActorIcon();
        this.drawLabel(34);
        this.drawGauge(144 + 34);
    };
    Sprite_MedalProgress.prototype.drawActorIcon = function () {
        if (this._actorId <= 0) {
            return;
        }
        var iconIndex = $gameActors.actor(this._actorId).iconIndex();
        if (iconIndex < 0) {
            return;
        }
        this.drawIcon(iconIndex, 0, 0);
    };
    Sprite_MedalProgress.prototype.drawLabel = function (x) {
        this.bitmap.drawText(this._label, x, 0, 140 + this.labelOffset(), 32);
    };
    Sprite_MedalProgress.prototype.labelOffset = function () {
        if (ConfigManager.isEn()) {
            return 65;
        }
        return 0;
    };
    Sprite_MedalProgress.prototype.drawGauge = function (x) {
        var xx = x + this.labelOffset();
        var yy = 10;
        var ww = 100;
        var hh = 12;
        var rateW = this._endRate - this._startRate;
        var rate = this._startRate + rateW * (this._frameCount / this.maxFrameCount());
        var v = (ww - 2) * rate;
        this.bitmap.fillRect(xx - 1, yy - 1, ww + 2, hh + 2, '#FFFFFF');
        this.bitmap.fillRect(xx, yy, ww, hh, '#000000');
        var color = '#EEAA33';
        if (rate == 1) {
            color = '#FFFFCC';
            this.playMedalSe();
            var xx_1 = 275;
            if (ConfigManager.isEn()) {
                xx_1 += 70;
            }
            this.bitmap.drawText(TextManager.obtainMedal2.format(this._name), xx_1 + 10, -2, 250, 32);
        }
        this.bitmap.fillRect(xx + 1, yy + 1, v, hh - 2, color);
    };
    Sprite_MedalProgress.prototype.playMedalSe = function () {
        AudioManager.playSe({ name: 'Chime2', volume: 85, pitch: 100, pan: 0 });
    };
    return Sprite_MedalProgress;
}(Sprite));
