var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Scene_Menu2 = /** @class */ (function (_super) {
    __extends(Scene_Menu2, _super);
    function Scene_Menu2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_Menu2.prototype.createMaterialWindow = function () {
        this._materialWindow = new Window_MenuMaterial();
        this.addWindow(this._materialWindow);
    };
    Scene_Menu2.prototype.createGoldWindow = function () {
        var rect = this.goldWindowRect();
        this._goldWindow = new Window_Gold2(rect);
        this.addWindow(this._goldWindow);
    };
    Scene_Menu2.prototype.createCommandWindow = function () {
        this.createMaterialWindow();
        var rect = this.commandWindowRect();
        var commandWindow = new Window_MenuCommand2(rect);
        commandWindow.setHandler("item", this.commandItem.bind(this));
        commandWindow.setHandler("pictralBook", this.commandPictralBook.bind(this));
        commandWindow.setHandler("dousei", this.commandPersonal.bind(this));
        commandWindow.setHandler("kigae", this.commandPersonal.bind(this));
        commandWindow.setHandler("skill", this.commandPersonal.bind(this));
        commandWindow.setHandler("equip", this.commandPersonal.bind(this));
        commandWindow.setHandler("status", this.commandPersonal.bind(this));
        commandWindow.setHandler("deckEdit", this.commandPersonal.bind(this));
        commandWindow.setHandler("masekiEdit", this.commandPersonal.bind(this));
        commandWindow.setHandler("options", this.commandOptions.bind(this));
        commandWindow.setHandler("save", this.commandSave.bind(this));
        commandWindow.setHandler("gameEnd", this.commandGameEnd.bind(this));
        commandWindow.setHandler("cancel", this.popScene.bind(this));
        commandWindow.setHandler("medal", this.commandMedal.bind(this));
        this.addWindow(commandWindow);
        this._commandWindow = commandWindow;
    };
    Scene_Menu2.prototype.commandWindowRect = function () {
        var ww = this.mainCommandWidth();
        var wh = this.mainAreaHeight() - this.goldWindowRect().height - this._materialWindow.height;
        var wx = this.isRightInputMode() ? Graphics.boxWidth - ww : 0;
        var wy = this.mainAreaTop();
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_Menu2.prototype.start = function () {
        _super.prototype.start.call(this);
        if ($gameTemp.menuIndex() >= 0) {
            this._commandWindow.select($gameTemp.menuIndex());
            this._commandWindow.deactivate();
            this.commandPersonal();
        }
    };
    Scene_Menu2.prototype.onPersonalOk = function () {
        $gameTemp.setMenuIndex(this._commandWindow.index());
        switch (this._commandWindow.currentSymbol()) {
            case "equip":
                SceneManager.push(Scene_Equip2);
                return;
            case "medal":
                SceneManager.push(Scene_Medal);
                return;
            case "deckEdit":
                if (this.canEditBaisyunDeck()) {
                    SceneManager.push(Scene_BaisyunDeck);
                }
                else {
                    SoundManager.playBuzzer();
                    this._statusWindow.activate();
                }
                return;
            case "status":
                SceneManager.push(Nore.Scene_EroStatus);
                return;
            case "kigae":
                SceneManager.push(Nore.Scene_Kigae);
                return;
            case "dousei":
                SceneManager.push(Scene_Dousei);
                return;
            case "masekiEdit":
                if (this.canEditBaisyunDeck()) {
                    SceneManager.push(Scene_BaisyunMaseki);
                }
                else {
                    SoundManager.playBuzzer();
                    this._statusWindow.activate();
                }
                return;
        }
        _super.prototype.onPersonalOk.call(this);
    };
    Scene_Menu2.prototype.canEditBaisyunDeck = function () {
        var index = this._statusWindow.index();
        var actor = $gameParty.allMembers()[index];
        if (!actor) {
            return;
        }
        var swId = 240 + actor.actorId();
        return $gameSwitches.value(swId);
    };
    Scene_Menu2.prototype.commandPictralBook = function () {
        SceneManager.push(Scene_PictralBook);
    };
    Scene_Menu2.prototype.commandMedal = function () {
        SceneManager.push(Scene_Medal);
    };
    Scene_Menu2.prototype.commandPersonal = function () {
        this._statusWindow.setFormationMode(false);
        this._statusWindow.selectLast();
        if (this._statusWindow.index() < 0) {
            this._statusWindow.select(0);
        }
        this._statusWindow.activate();
        this._statusWindow.setHandler("ok", this.onPersonalOk.bind(this));
        this._statusWindow.setHandler("cancel", this.onPersonalCancel.bind(this));
    };
    Scene_Menu2.prototype.commandItem = function () {
        SceneManager.push(Scene_Item2);
    };
    Scene_Menu2.prototype.popScene = function () {
        _super.prototype.popScene.call(this);
        $gameTemp.clearMenuIndex();
    };
    Scene_Menu2.prototype.terminate = function () {
        if (this._statusWindow.index() < 0) {
            $gameTemp.clearMenuIndex();
        }
        _super.prototype.terminate.call(this);
    };
    return Scene_Menu2;
}(Scene_Menu));
var Window_MenuCommand2 = /** @class */ (function (_super) {
    __extends(Window_MenuCommand2, _super);
    function Window_MenuCommand2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_MenuCommand2.prototype.addMainCommands = function () {
        var enabled = this.areMainCommandsEnabled();
        if (this.needsCommand("item")) {
            this.addCommand(TextManager._item, "item");
        }
        if (this.needsCommand("equip")) {
            this.addCommand(TextManager._equip, "equip", enabled);
        }
        if (this.needsCommand("status")) {
            this.addCommand(TextManager._status, "status", enabled);
        }
    };
    Window_MenuCommand2.prototype.addOriginalCommands = function () {
        _super.prototype.addOriginalCommands.call(this);
        this.addCommand(TextManager.kigae, "kigae", $gameSystem.isKigaeOpen());
        this.addCommand(TextManager.dousei, "dousei", this.canDounsei());
        this.addCommand(TextManager.pictralBook, "pictralBook", true);
        //this.addCommand(TextManager.medal, "medal", true);
        this.addCommand(TextManager.deckEdit, "deckEdit", $gameSwitches.value(208));
        this.addCommand(TextManager.masekiEdit, "masekiEdit", $gameSwitches.value(237));
    };
    Window_MenuCommand2.prototype.canDounsei = function () {
        if (!$gameSystem.isDouseiOpen()) {
            return false;
        }
        if ($gameParty.inBaisyun()) {
            return false;
        }
        if ($gameParty.inDungeon()) {
            return false;
        }
        return true;
    };
    Window_MenuCommand2.prototype.addFormationCommand = function () {
    };
    Window_MenuCommand2.prototype.addOptionsCommand = function () {
        if (this.needsCommand("options")) {
            var enabled = this.isOptionsEnabled();
            this.addCommand(TextManager._options, "options", enabled);
        }
    };
    Window_MenuCommand2.prototype.addSaveCommand = function () {
        if (this.needsCommand("save")) {
            var enabled = this.isSaveEnabled();
            this.addCommand(TextManager._save, "save", enabled);
            //this.addCommand(TextManager.load, "load", true);
        }
    };
    Window_MenuCommand2.prototype.addGameEndCommand = function () {
        var enabled = this.isGameEndEnabled();
        this.addCommand(TextManager._gameEnd, "gameEnd", enabled);
    };
    return Window_MenuCommand2;
}(Window_MenuCommand));
Game_Interpreter.prototype.command351 = function () {
    if (!$gameParty.inBattle()) {
        SceneManager.push(Scene_Menu2);
        Window_MenuCommand.initCommandPosition();
    }
    return true;
};
