var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Scene_Menu.prototype.createStatusWindow = function () {
    var rect = this.statusWindowRect();
    this._statusWindow = new Window_MenuStatus2(rect);
    this.addWindow(this._statusWindow);
};
var Window_MenuStatus2 = /** @class */ (function (_super) {
    __extends(Window_MenuStatus2, _super);
    function Window_MenuStatus2(r) {
        var _this = _super.call(this, r) || this;
        _this._actorLayer = new Sprite();
        _this.addChild(_this._actorLayer);
        return _this;
    }
    Window_MenuStatus2.prototype.maxCols = function () {
        return 3;
    };
    Window_MenuStatus2.prototype.refresh = function () {
        if (this._actorLayer) {
            this._actorLayer.removeChildren();
        }
        _super.prototype.refresh.call(this);
    };
    Window_MenuStatus2.prototype.itemHeight = function () {
        return 714;
    };
    Window_MenuStatus2.prototype.drawItemStatus = function (index) {
        var actor = this.actor(index);
        var rect = this.itemRect(index);
        var x = rect.x;
        var y = 530;
        this.drawActorSimpleStatus(actor, x, y);
    };
    Window_MenuStatus2.prototype.drawActorSimpleStatus = function (actor, x, y) {
        var lineHeight = this.lineHeight();
        var x2 = x + 220;
        var x3 = x2 + 180;
        this.drawActorName(actor, x, y);
        this.drawActorNickname(actor, x, 0, 270);
        this.drawActorLevel(actor, x + 130, y);
        this.drawActorClass(actor, x2, y, 150);
        this.placeBasicGauges(actor, x + 10, y + lineHeight);
        this.drawActorEroStatus(actor, x + 20, y + 72);
        this.drawDousei(actor, x + 20, y + 148, 270);
    };
    Window_MenuStatus2.prototype.placeBasicGauges = function (actor, x, y) {
        this.placeGauge(actor, "hp", x, y);
    };
    Window_MenuStatus2.prototype.drawActorName = function (actor, x, y, width) {
        width = width || 168;
        this.contents.fontSize = 22;
        this.changeTextColor(ColorManager.hpColor(actor));
        this.drawText(actor.name(), x + 10, y, width);
    };
    Window_MenuStatus2.prototype.drawActorClass = function (actor, x, y, width) {
        width = width || 168;
        this.contents.fontSize = 18;
        this.resetTextColor();
        this.drawText(getItemName(actor.currentClass()), x, y, width);
    };
    Window_MenuStatus2.prototype.drawDousei = function (actor, x, y, w) {
        if (!$gameSystem.isDouseiOpen()) {
            return;
        }
        this.drawText(TextManager.douseiMan, x, y, w);
        var name = this.douseiName(actor);
        this.drawText(name, x, y, w, 'right');
    };
    Window_MenuStatus2.prototype.douseiName = function (actor) {
        if (actor.dousei().manId() == 0) {
            return $gameActors.actor(97).name();
        }
        return actor.dousei().manName();
    };
    Window_MenuStatus2.prototype.drawActorEroStatus = function (actor, x, y) {
        this.contents.fontSize = 18;
        var w = 270;
        this.drawBaisyunLv(actor, x, y, w);
        this.drawBaisyunFame(actor, x, y + 22, w);
        this.drawSemen(actor, x, y + 22 * 2, w);
    };
    Window_MenuStatus2.prototype.drawBaisyunLv = function (actor, x, y, w) {
        var level = actor.baisyunLevel().level();
        var yy = y;
        this.drawText(TextManager.baisyunLv, x, yy, 200);
        this.drawText(level + '', x, yy, w, 'right');
    };
    Window_MenuStatus2.prototype.drawBaisyunFame = function (actor, x, y, w) {
        var baisyunHistory = actor.baisyunHistory();
        var fame = baisyunHistory.calcFame();
        var yy = y;
        this.drawText(TextManager.fame, x, yy, 200);
        this.drawText(fame + '', x, yy, w, 'right');
    };
    Window_MenuStatus2.prototype.drawSemen = function (actor, x, y, w) {
        var n = 0;
        var historyList = $gameParty.dayResultHistory().makeHistory(actor.actorId());
        for (var _i = 0, historyList_1 = historyList; _i < historyList_1.length; _i++) {
            var h = historyList_1[_i];
            if (h.manId() == actor.actorId()) {
                continue;
            }
            n += h.seiekiValue();
        }
        this.drawText(TextManager.gainSemen, x, y, 100);
        this.drawText('%1ml'.format(n), x, y, w, 'right');
    };
    Window_MenuStatus2.prototype.drawActorLevel = function (actor, x, y) {
        this.contents.fontSize = 22;
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(TextManager.levelA, x, y, 48);
        this.resetTextColor();
        this.drawText(actor.level, x + 16, y, 36, "right");
    };
    Window_MenuStatus2.prototype.drawItemImage = function (index) {
        if (!this._actorLayer) {
            return;
        }
        var actor = this.actor(index);
        var rect = this.itemRect(index);
        var xx = Nore.Tachie.getTachieOffsetX(actor.actorId());
        rect.x += 10;
        rect.y -= 30;
        rect.height = 560;
        var faceId = actor.getDefaultFaceId();
        var hoppe = actor.getAcceHoppeId();
        var namida = actor.getNamidaAcceId();
        var s = this.drawTachieActor(actor, this._actorLayer, rect.x - 110 + xx, -10, rect, faceId, 0.85, hoppe, namida);
    };
    return Window_MenuStatus2;
}(Window_MenuStatus));
var Window_MenuMaterial = /** @class */ (function (_super) {
    __extends(Window_MenuMaterial, _super);
    function Window_MenuMaterial() {
        var _this = this;
        var r = new Rectangle(1030, 558, 244, 164);
        _this = _super.call(this, r) || this;
        _this.drawMaterialPower();
        return _this;
    }
    Window_MenuMaterial.prototype.drawMaterialPower = function () {
        this.changeTextColor(ColorManager.normalColor());
        var xx = 38;
        var yy = -2;
        this.contents.fontSize = 22;
        var partyList = $gameParty.materialList();
        for (var i = 0; i < partyList.length; i++) {
            var icon = $gameParty.materialIcon(i);
            this.drawIcon(icon, xx, yy);
            this.drawNumber(partyList[i], xx, yy - 8, 132, 'right', 7);
            //this.drawText(partyList[i], xx, yy - 1, 120, 'right')
            yy += 28;
        }
    };
    return Window_MenuMaterial;
}(Window_Base));
var Window_Gold2 = /** @class */ (function (_super) {
    __extends(Window_Gold2, _super);
    function Window_Gold2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_Gold2.prototype.refresh = function () {
        var rect = this.itemLineRect(0);
        this.contents.clear();
        this._windowContentsSprite.removeChildren();
        this.drawIcon2x(188, 14, 5);
        this.drawIcon(254, 172, 8);
        this.drawNumber(this.value(), 10, 0, 180, 'right', 16);
    };
    ;
    return Window_Gold2;
}(Window_Gold));
