/*:ja
 * @target MZ
 * @author ル
 *
 * @command gainMilk2
 * @text サツキの母乳獲得

 * @command gainMilk1
 * @text ロザリーの母乳獲得
 *
 * @command setMilkEventToVar197
 * @text 乳搾りイベントを決定
 * @arg actorId
 * @type number
 *
 * @command nextDay
 * @text 次の日へ
 *
 * @command sellMilk
 * @text 母乳を販売する
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Milk';
    Nore.SATSUKI_TOTAL_SELL_MILK_VAR = 188;
    Nore.ROSALIE_TOTAL_SELL_MILK_VAR = 189;
    Nore.SATSUKI_MILK_VAR = 191;
    Nore.ROSALIE_MILK_VAR = 192;
    Nore.SATSUKI_TOTAL_MILK_VAR = 194;
    Nore.ROSALIE_TOTAL_MILK_VAR = 195;
    Nore.MILK_NAME_VAR = 196;
    var MILK_EVENT_ID = 197;
    Nore.MILK_SHOP_ID = 198;
    Nore.MILK_SHOP_REWARD_ID = 199;
    Nore.SATSUKI_MILK_END_SW = 347;
    Nore.ROSALIE_MILK_END_SW = 348;
    PluginManager.registerCommand(pluginName, 'gainMilk2', function (args) {
        if ($gameVariables.value(Nore.SATSUKI_TOTAL_MILK_VAR) > 0) {
            Nore.incrementVar(Nore.SATSUKI_MILK_VAR);
        }
        Nore.incrementVar(Nore.SATSUKI_TOTAL_MILK_VAR);
        var name = getItemName($dataItems[71]);
        $gameVariables.setValue(Nore.MILK_NAME_VAR, name);
        $gameSwitches.setValue(Nore.SATSUKI_MILK_END_SW, true);
    });
    PluginManager.registerCommand(pluginName, 'gainMilk1', function (args) {
        if ($gameVariables.value(Nore.ROSALIE_TOTAL_MILK_VAR) > 0) {
            Nore.incrementVar(Nore.ROSALIE_MILK_VAR);
        }
        Nore.incrementVar(Nore.ROSALIE_TOTAL_MILK_VAR);
        var name = getItemName($dataItems[72]);
        $gameVariables.setValue(Nore.MILK_NAME_VAR, name);
        $gameSwitches.setValue(Nore.ROSALIE_MILK_END_SW, true);
    });
    PluginManager.registerCommand(pluginName, 'setMilkEventToVar197', function (args) {
        var actorId = parseInt(args.actorId);
        var id = $milkManager.choiseMilkEventId(actorId);
        $gameVariables.setValue(MILK_EVENT_ID, id);
    });
    PluginManager.registerCommand(pluginName, 'nextDay', function (args) {
        $milkManager.nextDay();
    });
    PluginManager.registerCommand(pluginName, 'sellMilk', function (args) {
        $milkManager.sellMilk();
    });
})(Nore || (Nore = {}));
var MilkEventId;
(function (MilkEventId) {
    MilkEventId[MilkEventId["finished"] = 0] = "finished";
    MilkEventId[MilkEventId["no1"] = 1] = "no1";
    MilkEventId[MilkEventId["no2"] = 2] = "no2";
    MilkEventId[MilkEventId["no3"] = 3] = "no3";
})(MilkEventId || (MilkEventId = {}));
var MilkManager = /** @class */ (function () {
    function MilkManager() {
    }
    MilkManager.prototype.choiseMilkEventId = function (actorId) {
        switch (actorId) {
            case 1: return this.choiseMilkEventId1();
            case 2: return this.choiseMilkEventId2();
        }
        console.error('不正な actorId です:' + actorId);
        return MilkEventId.finished;
    };
    MilkManager.prototype.choiseMilkEventId1 = function () {
        if ($gameSwitches.value(Nore.ROSALIE_MILK_END_SW)) {
            return MilkEventId.finished;
        }
        var count = $gameVariables.value(Nore.ROSALIE_TOTAL_MILK_VAR);
        if (count <= 4) {
            return MilkEventId.no1;
        }
        if (count <= 9) {
            return MilkEventId.no2;
        }
        return MilkEventId.no3;
    };
    MilkManager.prototype.choiseMilkEventId2 = function () {
        if ($gameSwitches.value(Nore.SATSUKI_MILK_END_SW)) {
            return MilkEventId.finished;
        }
        var count = $gameVariables.value(Nore.SATSUKI_TOTAL_MILK_VAR);
        if (count <= 4) {
            return MilkEventId.no1;
        }
        if (count <= 9) {
            return MilkEventId.no2;
        }
        return MilkEventId.no3;
    };
    MilkManager.prototype.nextDay = function () {
        var n = $gameVariables.value(Nore.MILK_SHOP_ID);
        var satsukiSell = $gameVariables.value(Nore.SATSUKI_MILK_VAR);
        if (satsukiSell > 0) {
            Nore.incrementVar(Nore.SATSUKI_TOTAL_SELL_MILK_VAR);
        }
        n += satsukiSell;
        var rosalieSell = $gameVariables.value(Nore.ROSALIE_MILK_VAR);
        if (rosalieSell > 0) {
            Nore.incrementVar(Nore.ROSALIE_TOTAL_SELL_MILK_VAR);
        }
        n += rosalieSell;
        $gameVariables.setValue(Nore.MILK_SHOP_ID, n);
        $gameVariables.setValue(Nore.SATSUKI_MILK_VAR, 0);
        $gameVariables.setValue(Nore.ROSALIE_MILK_VAR, 0);
    };
    MilkManager.prototype.sellMilk = function () {
        var n = $gameVariables.value(Nore.MILK_SHOP_ID);
        var price = 25;
        var total = n * price;
        $gameParty.gainGold(total);
        $gameVariables.setValue(Nore.MILK_SHOP_REWARD_ID, total);
        $gameVariables.setValue(Nore.MILK_SHOP_ID, 0);
    };
    return MilkManager;
}());
var $milkManager;
(function (Nore) {
    var _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _DataManager_createGameObjects.call(this);
        $milkManager = new MilkManager();
    };
})(Nore || (Nore = {}));
