/*:ja
 * @target MZ
 * @author ル
 *
 * @command damage
 * @text 妊娠ダメージ
 * @des 妊娠ダメージ
 * @arg value
 * @type number
 *
 *
 * @command ninshin
 * @text 妊娠させる
 * @arg actorId
 * @type number
 * @arg commonId
 * @type number
 * @arg dayOffset
 * @type number
 * @min -1
 *
 * @command runNinshinMobScenario
 * @text 妊娠時のモブテキストを再生
 * @arg actorId
 * @type number
 * @arg manIdVar
 * @type number
 *
 * @command initialize
 * @text 初期化（回想用）
 * @arg actorId
 * @type number
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Ninshin';
    PluginManager.registerCommand(pluginName, 'ninshin', function (args) {
        var actorId = parseInt(args.actorId);
        var commonId = parseInt(args.commonId);
        var dayOffset = parseInt(args.dayOffset);
        var actor = $gameActors.actor(actorId);
        var map = ERO_MAP[commonId];
        var param = new EroParam(map);
        actor.upNinshinDamage(100, param.manId(), commonId, false);
        actor.babyHistory().lastBaby().changeDay(dayOffset);
        actor.babyHistory().lastBaby().saveCos();
    });
    PluginManager.registerCommand(pluginName, 'damage', function (args) {
        if (!$gameTemp.eroEventCommonId) {
            return;
        }
        var actor = $gameActors.actor($gameTemp.eroEventActorId);
        if (!actor) {
            console.error('$gameTemp.eroEventActorId が不正です' + $gameTemp.eroEventActorId);
            return;
        }
        var value = parseInt(args.value);
        $gameTemp.eroEventDamageIndex += value;
        var ninshinTotal = $gameTemp.ninshinTotal;
        var map = ERO_MAP[$gameTemp.eroEventCommonId];
        var param = new EroParam(map);
        var commonId = $gameTemp.eroEventCommonId;
        if ($gameTemp.ninshinTotal == $gameTemp.eroEventDamageIndex) {
            actor.upNinshinDamage($gameTemp.eroEventDamageRemain, param.manId(), commonId, false);
        }
        else {
            var d = Math.floor(param.calcNinshinDamage() * value / ninshinTotal);
            actor.upNinshinDamage(d, param.manId(), commonId, false);
            $gameTemp.eroEventDamageRemain -= d;
        }
    });
    PluginManager.registerCommand(pluginName, 'runNinshinMobScenario', function (args) {
        var actorId = parseInt(args.actorId);
        var manIdVar = parseInt(args.manIdVar);
        var manId = $gameVariables.value(manIdVar);
        var scenario = ninshinMobScenrario(actorId, manId);
        var list = $dataScenario[scenario];
        if (!list) {
            throw new Error('id:' + scenario + ' のデータが見つかりません');
        }
        console.log("Scenario \u30B3\u30DE\u30F3\u30C9\u5B9F\u884C: ".concat(scenario));
        this.setupChild(list, this._eventId);
    });
    function ninshinMobScenrario(actorId, manId) {
        var actor = $gameActors.actor(actorId);
        var name = actor.nameJp();
        //サツキ_妊娠_モブ・みすぼらしい男初回_01
        var times = actor.babyHistory().countNinshinPerFather(manId);
        var postText = times === 1 ? '初回' : '2回目以降';
        if (actor.friendshipActor().friendship(manId).isMax()) {
            postText = '好感度MAX';
        }
        var man = $gameActors.actor(manId);
        var manName = man.nameJp();
        var scenario = '%1_妊娠_モブ・%2%3_01'.format(name, manName, postText).normalize('NFC');
        if ($dataScenario[scenario]) {
            return scenario;
        }
        p(scenario + ' が存在しません');
        return '%1_妊娠_モブ%2_01'.format(name, postText).normalize('NFC');
    }
    PluginManager.registerCommand(pluginName, 'initialize', function (args) {
        var actorId = parseInt(args.actorId);
        var actor = $gameActors.actor(actorId);
        actor._babyHistory = new BabyHistory(actorId);
        actor._friendship = new FriendshipActor(actorId);
        actor.setBote(0);
        actor._ninshinDamage = 0;
    });
})(Nore || (Nore = {}));
