var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 *
 *
 * @command show
 * @text 妊娠ダメージバー表示
 * @des 妊娠ダメージバー表示
 * @arg commonId
 * @type number
 *
 * @command showBaisyun
 * @text 売春用妊娠ダメージバー表示
 * @des 売春用妊娠ダメージバー表示
 * @arg commonId
 * @type number
 *
 * @command hide
 * @text 妊娠ダメージバー非表示
 * @des 妊娠ダメージバー非表示
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_NinshinUi';
    PluginManager.registerCommand(pluginName, 'show', function (args) {
        var commonId = parseInt(args.commonId);
        var map = ERO_MAP[commonId];
        if (!map) {
            console.error("'".concat(commonId, "\u306ESEIEKI_MAP\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093"));
        }
        var param = new EroParam(map);
        var actor = $gameActors.actor(param.actorId());
        if (actor.isBote()) {
            return;
        }
        $gameTemp.onEroStart(commonId, param);
        p('妊娠ダメージ トータル:' + param.calcNinshinDamage());
    });
    PluginManager.registerCommand(pluginName, 'showBaisyun', function (args) {
        var commonId = parseInt(args.commonId);
        var map = ERO_MAP[commonId];
        if (!map) {
            console.error("'".concat(commonId, "\u306ESEIEKI_MAP\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093"));
        }
        var param = new EroParam(map);
        var newParam = JsonEx.makeDeepCopy(param);
        newParam.changeActorId($gameSystem.baisyunActorId());
        var actor = $gameActors.actor(newParam.actorId());
        if (actor.isBote()) {
            return;
        }
        var baisyunManId = $gameVariables.value(BAISYUN_MAN_ID);
        newParam.changeManId(baisyunManId);
        $gameTemp.onEroStart(commonId, newParam);
        p('妊娠ダメージ トータル:' + newParam.calcNinshinDamage());
    });
    PluginManager.registerCommand(pluginName, 'hide', function (args) {
        $gameTemp.onEroEnd();
    });
})(Nore || (Nore = {}));
var Sprite_NinshinBar = /** @class */ (function (_super) {
    __extends(Sprite_NinshinBar, _super);
    function Sprite_NinshinBar() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._actorId = 0;
        _this._lastActorNinshin = 0;
        _this._ninshinRate = -1;
        return _this;
    }
    Sprite_NinshinBar.prototype.initialize = function () {
        _super.prototype.initialize.call(this);
        this.x = 10;
        this.y = -18;
    };
    Sprite_NinshinBar.prototype.actor = function () {
        return $gameActors.actor(this._actorId);
    };
    Sprite_NinshinBar.prototype.setActorId = function (actorId) {
        this._actorId = actorId;
        this.visible = this._actorId > 0;
        this.setNinshinRate(this.getNinshinRate());
    };
    Sprite_NinshinBar.prototype.setNinshinRate = function (n) {
        this._ninshinRate = n;
        this._lastActorNinshin = this._ninshinRate;
        this.redraw();
    };
    Sprite_NinshinBar.prototype.createBitmap = function () {
        this.bitmap = new Bitmap(1006, 78);
        this.bitmap.fontSize = 24;
    };
    Sprite_NinshinBar.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateActor();
        if (!this.visible) {
            return;
        }
        if (this._lastActorNinshin != this.getNinshinRate()) {
            this.redraw();
        }
    };
    Sprite_NinshinBar.prototype.updateActor = function () {
        if (this._actorId == $gameTemp.eroEventActorId) {
            return;
        }
        this.setActorId($gameTemp.eroEventActorId);
    };
    Sprite_NinshinBar.prototype.getNinshinRate = function () {
        var actor = this.actor();
        if (!actor) {
            return 0;
        }
        return actor.ninshinDamage();
    };
    Sprite_NinshinBar.prototype.redraw = function () {
        if (!this.bitmap) {
            this.createBitmap();
        }
        this.destroyAndRemoveChildren();
        this.bitmap.clear();
        var ninshinRate = this.getNinshinRate();
        if (Math.abs(ninshinRate - this._lastActorNinshin) < 1) {
            this._lastActorNinshin = ninshinRate;
        }
        else {
            this._lastActorNinshin += 0.5;
        }
        var x = 258;
        var y = 33;
        var width = 459;
        var height = 21;
        var hpGaugeColor1 = ColorManager.textColor(20);
        var hpGaugeColor2 = ColorManager.textColor(21);
        if (this._lastActorNinshin >= 100) {
            var hpGaugeColor1 = ColorManager.textColor(27);
            var hpGaugeColor2 = ColorManager.textColor(27);
        }
        var fillW = Math.floor((100 - this._lastActorNinshin) * width / 100);
        var ninshin = ImageManager.loadSystem('ninshin');
        if (ConfigManager.en) {
            this.bitmap.blt(ninshin, 0, 164, 760, 50, 116, 20);
        }
        else {
            this.bitmap.blt(ninshin, 0, 0, 660, 50, 116, 20);
        }
        if (fillW > 0) {
            var offset = 0;
            if (ConfigManager.en) {
                offset = 92;
            }
            this.bitmap.gradientFillRect(x + 1 + offset, y + 1, fillW - 2, height - 2, hpGaugeColor1, hpGaugeColor2);
        }
        var xx = 60;
        var yy = 18;
        if (this._lastActorNinshin >= 100) {
            this.bitmap.blt(ninshin, 0, 110, 70, 50, xx, yy);
        }
        else {
            this.bitmap.blt(ninshin, 0, 60, 70, 50, xx, yy);
        }
        var num = Math.max(0, Math.floor(100 - this._lastActorNinshin)) + '/' + 100;
        this.drawNumber(num, ConfigManager.en ? 707 : 618, 4, 100, 'right', 8);
    };
    return Sprite_NinshinBar;
}(Sprite));
