var LANGUAGE_LIST = [
    'jp',
    'en',
    //   'ch',
];
Scene_Options.prototype.optionsWindowRect = function () {
    var n = Math.min(this.maxCommands(), this.maxVisibleCommands());
    var ww = 560;
    var wh = this.calcWindowHeight(n, true);
    var wx = (Graphics.boxWidth - ww) / 2;
    var wy = (Graphics.boxHeight - wh) / 2;
    return new Rectangle(wx, wy, ww, wh);
};
Window_Options.prototype.volumeOffset = function () {
    return 2;
};
ConfigManager.showSikyu = true;
ConfigManager.rightClickSkip = true;
ConfigManager.battleFast = true;
ConfigManager.gameActive = false;
ConfigManager.skipKey = true;
ConfigManager.windowAlpha = 96;
ConfigManager.autoSpeed = 1;
ConfigManager.autoTimeEvent = true;
ConfigManager.openRecollection = false;
ConfigManager.simpleMenu = false;
ConfigManager.outerTransparentEnabled = false;
ConfigManager.alchemyEffect = true;
ConfigManager.isJp = function () {
    return ConfigManager.language == 'jp';
};
ConfigManager.isEn = function () {
    return ConfigManager.language == 'en';
};
Window_Options.prototype.addGeneralOptions = function () {
    this.addCommand(TextManager._alwaysDash, "alwaysDash");
    this.addCommand(TextManager.showSikyu, "showSikyu");
    //this.addCommand(TextManager.commandRemember, "commandRemember");
    //this.addCommand(TextManager._touchUI, "touchUI");
    //this.addCommand(TextManager.battleFast, "battleFast");
    this.addCommand(TextManager.language, "language");
    this.addCommand(TextManager.windowAlpha, "windowAlpha");
    this.addCommand(TextManager.rightClickSkip, "rightClickSkip");
    this.addCommand(TextManager.font, "font");
    this.addCommand(TextManager.skipKey, "skipKey");
    this.addCommand(TextManager.autoSpeed, "autoSpeed");
    //this.addCommand(TextManager.outerTransparentEnabled, "outerTransparentEnabled");
    this.addCommand(TextManager.alchemyEffect, "alchemyEffect");
    //this.addCommand(TextManager.gameActive, "gameActive");
};
Window_Options.prototype.addVolumeOptions = function () {
    this.addCommand(TextManager._bgmVolume, "bgmVolume");
    //this.addCommand(TextManager._bgsVolume, "bgsVolume");
    this.addCommand(TextManager._meVolume, "meVolume");
    this.addCommand(TextManager._seVolume, "seVolume");
    this.addCommand('OK', "ok");
    //this.addCommand(TextManager._voiceVolume, "voiceVolume");
};
Window_Options.prototype.isVolumeSymbol = function (symbol) {
    if (symbol.includes('Alpha')) {
        return true;
    }
    return symbol.includes("Volume");
};
var _ConfigManager_makeData = ConfigManager.makeData;
ConfigManager.makeData = function () {
    var config = _ConfigManager_makeData.call(this);
    config.voiceVolume = this.voiceVolume;
    config.language = this.language;
    config.showSikyu = this.showSikyu;
    config.confirmEnter = this.confirmEnter;
    config.windowAlpha = this.windowAlpha;
    config.skipKey = this.skipKey;
    config.rightClickSkip = this.rightClickSkip;
    config.battleFast = this.battleFast;
    config.gameActive = this.gameActive;
    config.autoSpeed = this.autoSpeed;
    config.autoTimeEvent = this.autoTimeEvent;
    config.openRecollection = this.openRecollection;
    config.simpleMenu = this.simpleMenu;
    config.font = this.font;
    config.outerTransparentEnabled = this.outerTransparentEnabled;
    config.alchemyEffect = this.alchemyEffect;
    return config;
};
var _ConfigManager_applyData = ConfigManager.applyData;
ConfigManager.applyData = function (config) {
    _ConfigManager_applyData.call(this, config);
    this.bgsVolume = this.readVolume(config, "bgmVolume");
    this.voiceVolume = this.readVolume(config, "voiceVolume");
    this.windowAlpha = this.readVolume(config, "windowAlpha");
    this.language = this.readLanguage(config, "language");
    this.showSikyu = this.readFlag(config, "showSikyu", true);
    this.skipKey = this.readFlag(config, "skipKey", true);
    this.rightClickSkip = this.readFlag(config, "rightClickSkip", true);
    this.confirmEnter = this.readFlag(config, "confirmEnter", true);
    this.battleFast = this.readFlag(config, "battleFast", true);
    this.gameActive = this.readFlag(config, "gameActive", true);
    this.autoSpeed = this.readAutoSpeed(config, "autoSpeed");
    this.autoTimeEvent = this.readFlag(config, "autoTimeEvent");
    this.openRecollection = this.readFlag(config, "openRecollection");
    this.simpleMenu = this.readFlag(config, "simpleMenu");
    this.outerTransparentEnabled = this.readFlag(config, "outerTransparentEnabled");
    this.alchemyEffect = this.readFlag(config, "alchemyEffect");
    if (this.alchemyEffect === undefined) {
        this.alchemyEffect = true;
    }
};
ConfigManager.readLanguage = function (config, name) {
    if (name in config) {
        return config[name];
    }
    else {
        return 'jp';
    }
};
ConfigManager.readAutoSpeed = function (config, name) {
    if (name in config) {
        return Number(config[name]).clamp(0, 4);
    }
    else {
        return 1;
    }
};
Object.defineProperty(ConfigManager, "voiceVolume", {
    get: function () {
        return AudioManager._voiceVolume;
    },
    set: function (value) {
        AudioManager._voiceVolume = value;
    },
    configurable: true
});
Scene_Options.prototype.maxCommands = function () {
    // Increase this value when adding option items.
    return 13;
};
Scene_Options.prototype.maxVisibleCommands = function () {
    return 13;
};
var _Scene_Options_prototype_createOptionsWindow = Scene_Options.prototype.createOptionsWindow;
Scene_Options.prototype.createOptionsWindow = function () {
    _Scene_Options_prototype_createOptionsWindow.call(this);
    this._optionsWindow.setHandler("language", this.onLanguage.bind(this));
    this._optionsWindow.setHandler("font", this.onFont.bind(this));
    //this._optionsWindow.setHandler("autoSpeed", this.onAutoSpeed.bind(this));
};
Scene_Options.prototype.onFont = function () {
    this._optionsWindow.resetFontSettings();
    this._optionsWindow.refresh();
};
Scene_Options.prototype.onLanguage = function () {
    switch (ConfigManager.language) {
        case 'en':
            initVocabEn();
            break;
        case 'jp':
            initVocabJp();
            break;
        case 'ch':
            //initVocabCh();
            break;
    }
    this._optionsWindow.makeCommandList();
    this._optionsWindow.refresh();
};
Window_Options.prototype.changeValue = function (symbol, value) {
    var lastValue = this.getConfigValue(symbol);
    if (lastValue !== value) {
        this.setConfigValue(symbol, value);
        this.redrawItem(this.findSymbol(symbol));
        this.playCursorSound();
        if (symbol == 'language') {
            ConfigManager.language = value;
            this.callHandler('language');
        }
        if (symbol == 'font') {
            ConfigManager.font = value;
            this.callHandler('font');
        }
    }
};
var _Window_Options_prototype_drawItem = Window_Options.prototype.drawItem;
Window_Options.prototype.drawItem = function (index) {
    var title = this.commandName(index);
    if (title != 'OK') {
        _Window_Options_prototype_drawItem.call(this, index);
        return;
    }
    var rect = this.itemLineRect(index);
    this.resetTextColor();
    this.changePaintOpacity(this.isCommandEnabled(index));
    this.drawText(title, rect.x, rect.y, rect.width, "center");
};
Window_Options.prototype.statusText = function (index) {
    var symbol = this.commandSymbol(index);
    var value = this.getConfigValue(symbol);
    if (this.isFontSymbol(symbol)) {
        return this.fontText(value);
    }
    else if (this.isSkipKeySymbol(symbol)) {
        return this.skipStatusText(value);
    }
    else if (this.isAutoSpeedSymbol(symbol)) {
        return this.autoSpeedText(value);
    }
    else if (this.isLanguageSymbol(symbol)) {
        return this.languageStatusText(value);
    }
    else if (this.isVolumeSymbol(symbol)) {
        return this.volumeStatusText(value);
    }
    else {
        return this.booleanStatusText(value);
    }
};
Window_Options.prototype.isFontSymbol = function (symbol) {
    return symbol == "font";
};
Window_Options.prototype.fontText = function (value) {
    if (value) {
        return 'M+ 1m';
    }
    else {
        return '源暎ラテミン';
    }
};
Window_Options.prototype.skipStatusText = function (value) {
    if (value) {
        return 'ctrl';
    }
    else {
        return 'shift';
    }
};
Window_Options.prototype.autoSpeedText = function (value) {
    switch (value) {
        case 0: return TextManager.autoSpeed1;
        case 1: return TextManager.autoSpeed2;
        case 2: return TextManager.autoSpeed3;
        case 3: return TextManager.autoSpeed4;
        case 4: return TextManager.autoSpeed5;
    }
};
Window_Options.prototype.languageStatusText = function (value) {
    switch (value) {
        case 'en': return "En(Partial)";
        case 'jp': return "Japanese";
        case 'ch': return "中国語";
    }
    return '';
};
Window_Options.prototype.isSimpleMenuSymbol = function (symbol) {
    return symbol == "simpleMenu";
};
Window_Options.prototype.isSkipKeySymbol = function (symbol) {
    return symbol == "skipKey";
};
Window_Options.prototype.isAutoSpeedSymbol = function (symbol) {
    return symbol == "autoSpeed";
};
Window_Options.prototype.isLanguageSymbol = function (symbol) {
    return symbol == "language";
};
Window_Options.prototype.cursorRight = function () {
    var index = this.index();
    var symbol = this.commandSymbol(index);
    if (this.isLanguageSymbol(symbol)) {
        this.changeLanguage(symbol, true);
    }
    else if (this.isAutoSpeedSymbol(symbol)) {
        this.changeAutoSpeed(symbol, true);
    }
    else if (this.isVolumeSymbol(symbol)) {
        this.changeVolume(symbol, true, false);
    }
    else {
        this.changeValue(symbol, true);
    }
};
Window_Options.prototype.changeLanguage = function (symbol, forward) {
    var lastValue = this.getConfigValue(symbol);
    var index = LANGUAGE_LIST.indexOf(lastValue);
    if (forward) {
        index++;
    }
    else {
        index--;
    }
    if (index >= LANGUAGE_LIST.length) {
        this.changeValue(symbol, LANGUAGE_LIST[0]);
    }
    else if (index < 0) {
        this.changeValue(symbol, LANGUAGE_LIST[LANGUAGE_LIST.length - 1]);
    }
    else {
        this.changeValue(symbol, LANGUAGE_LIST[index]);
    }
};
Window_Options.prototype.changeAutoSpeed = function (symbol, forward) {
    var lastValue = this.getConfigValue(symbol);
    if (forward) {
        if (lastValue == 4) {
            this.changeValue(symbol, 0);
        }
        else {
            this.changeValue(symbol, lastValue + 1);
        }
    }
    else {
        if (lastValue == 0) {
            this.changeValue(symbol, 4);
        }
        else {
            this.changeValue(symbol, lastValue - 1);
        }
    }
};
Window_Options.prototype.processOk = function () {
    var index = this.index();
    var symbol = this.commandSymbol(index);
    if (symbol == 'ok') {
        this.processCancel();
    }
    else if (this.isAutoSpeedSymbol(symbol)) {
        this.changeAutoSpeed(symbol, true);
    }
    else if (this.isLanguageSymbol(symbol)) {
        this.changeLanguage(symbol, true);
    }
    else if (this.isVolumeSymbol(symbol)) {
        this.changeVolume(symbol, true, true);
    }
    else {
        this.changeValue(symbol, !this.getConfigValue(symbol));
    }
};
var _Window_Options_prototype_processCancel = Window_Options.prototype.processCancel;
Window_Options.prototype.processCancel = function () {
    var index = this.index();
    var symbol = this.commandSymbol(index);
    if (symbol.includes('Volume')) {
        this.cursorLeft();
    }
    else {
        _Window_Options_prototype_processCancel.call(this);
    }
};
Window_Options.prototype.cursorLeft = function () {
    var index = this.index();
    var symbol = this.commandSymbol(index);
    if (this.isLanguageSymbol(symbol)) {
        this.changeLanguage(symbol, false);
    }
    else if (this.isAutoSpeedSymbol(symbol)) {
        this.changeAutoSpeed(symbol, false);
    }
    else if (this.isVolumeSymbol(symbol)) {
        this.changeVolume(symbol, false, false);
    }
    else {
        this.changeValue(symbol, false);
    }
};
ConfigManager.readVolume = function (config, name) {
    if (name in config) {
        return Number(config[name]).clamp(0, 100);
    }
    else {
        return 20;
    }
};
ConfigManager.language = 'jp';
SceneManager.isGameActive = function () {
    // [Note] We use "window.top" to support an iframe.
    try {
        if (ConfigManager.gameActive) {
            return true;
        }
        return window.top.document.hasFocus();
    }
    catch (e) {
        // SecurityError
        return true;
    }
};
Window_Options.prototype.volumeStatusText = function (value) {
    return value + "％";
};
