var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 *
 * @command checkNewRecipe
 * @text 新規レシピ確認
 * @des 新規レシピ確認
 *
 * @command nextDay
 * @text 次の日へ
 *
 *
 * @command recover30
 * @text HP３０％回復
 *
 * @command setVarNinshinName
 * @text 妊娠している人の名前を変数に入れる
 *
 * @command gainMaterial
 * @text マテリアルを獲得
 * @arg value
 * @type number
 *
 * @command clearNewEquipFlag
 * @text 新装備フラグを解除
 *
 *
 */
var RECOVER_CIV_CRYSTAL = 50;
var NO_ITEM_VAR = 133;
var FAN_UNIT = 10;
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Party';
    PluginManager.registerCommand(pluginName, 'checkNewRecipe', function (args) {
        $gameParty.recheckNewRecipe();
    });
    PluginManager.registerCommand(pluginName, 'nextDay', function (args) {
        $gameParty.nextDay();
    });
    PluginManager.registerCommand(pluginName, 'recover30', function (args) {
        for (var _i = 0, _a = $gameParty.battleMembers(); _i < _a.length; _i++) {
            var m = _a[_i];
            m.gainHp(Math.round(m.mhp * 0.3));
        }
    });
    PluginManager.registerCommand(pluginName, 'setVarNinshinName', function (args) {
        $gameParty.setVarNinshinActorName();
    });
    PluginManager.registerCommand(pluginName, 'gainMaterial', function (args) {
        var value = parseInt(args.value);
        $gameParty.gainMaterialPower(MaterialType.wood, value);
        $gameParty.gainMaterialPower(MaterialType.flame, value);
        $gameParty.gainMaterialPower(MaterialType.stone, value);
        $gameParty.gainMaterialPower(MaterialType.water, value);
        $gameParty.gainMaterialPower(MaterialType.seieki, value);
    });
    PluginManager.registerCommand(pluginName, 'clearNewEquipFlag', function (args) {
        $gameParty.clearNewEquipGet();
    });
})(Nore || (Nore = {}));
var SIROHATA_ID = 17;
var BAKUDAN_ID = 19;
var SUISIDE_ID = 21;
var BATTLE_COS_ID = 1;
var CAPTIVE_COS_ID = 2;
var TEMP_COS_ID = 3;
var CRYSTAL_VAR = 68;
var GachaTicket = /** @class */ (function () {
    function GachaTicket(actorId) {
        this._actorId = actorId;
    }
    GachaTicket.prototype.actorId = function () {
        return this._actorId;
    };
    return GachaTicket;
}());
var SlgScenatio = /** @class */ (function () {
    function SlgScenatio(_scenario, _id) {
        this._scenario = _scenario;
        this._id = _id;
    }
    SlgScenatio.prototype.scenario = function () {
        return this._scenario;
    };
    SlgScenatio.prototype.id = function () {
        return this._id;
    };
    return SlgScenatio;
}());
var FriendshipBonusType;
(function (FriendshipBonusType) {
    FriendshipBonusType["hpFlame"] = "hpFlame";
    FriendshipBonusType["atkFlame"] = "atkFlame";
    FriendshipBonusType["hpWater"] = "hpWater";
    FriendshipBonusType["atkWater"] = "atkWater";
    FriendshipBonusType["hpWood"] = "hpWood";
    FriendshipBonusType["atkWood"] = "atkWood";
})(FriendshipBonusType || (FriendshipBonusType = {}));
Game_Unit.prototype.updateTpb = function (preBattle) {
    for (var _i = 0, _a = this.members(); _i < _a.length; _i++) {
        var member = _a[_i];
        member.updateTpb(preBattle);
    }
};
Game_Battler.prototype.updateTpb = function (preBattle) {
    if (this.canMove()) {
        this.updateTpbChargeTime(preBattle);
        this.updateTpbCastTime();
        this.updateTpbAutoBattle();
    }
    if (this.isAlive()) {
        this.updateTpbIdleTime();
    }
};
var MaterialType;
(function (MaterialType) {
    MaterialType[MaterialType["flame"] = 0] = "flame";
    MaterialType[MaterialType["water"] = 1] = "water";
    MaterialType[MaterialType["wood"] = 2] = "wood";
    MaterialType[MaterialType["stone"] = 3] = "stone";
    MaterialType[MaterialType["seieki"] = 4] = "seieki";
})(MaterialType || (MaterialType = {}));
var Game_NoreParty = /** @class */ (function (_super) {
    __extends(Game_NoreParty, _super);
    function Game_NoreParty() {
        var _this = _super.call(this) || this;
        _this._scenarioList = [];
        _this._commonEventList = [];
        _this._upGoldValue = 0;
        _this._menuActorId = 2;
        _this._materialList = [0, 0, 0, 0, 0];
        _this._itemGotMap = {};
        _this._dayResultHistory = new DayResultHistory();
        _this._newEquipGet = false;
        _this._alchemyManager = new AlchemyManager();
        _this._user = new Game_User();
        _this._newRecipeList = [];
        _this._getMaterialIdMap = {};
        _this._learnRecipeMap = {};
        _this._masekiActorSet = new MasekiActorSet();
        return _this;
    }
    Game_NoreParty.prototype.friendshipBonus = function (type) {
        this._friendshipBonus = this._friendshipBonus || {};
        if (this._friendshipBonus[type]) {
            return this._friendshipBonus[type];
        }
        return 0;
    };
    Game_NoreParty.prototype.upFriendshipBonus = function (type, value) {
        this._friendshipBonus = this._friendshipBonus || {};
        if (!this._friendshipBonus[type]) {
            this._friendshipBonus[type] = 0;
        }
        this._friendshipBonus[type] += value;
    };
    Game_NoreParty.prototype.friendshipBonusRate = function (type) {
        switch (type) {
            case FriendshipBonusType.hpFlame:
            case FriendshipBonusType.hpWater:
            case FriendshipBonusType.hpWood:
                return 3;
        }
        return 1;
    };
    Game_NoreParty.prototype.setMenuActorId = function (actorId) {
        this._menuActorId = actorId;
    };
    Game_NoreParty.prototype.menuActor = function () {
        var actor = $gameActors.actor(this._menuActorId);
        if (!actor) {
            return $gameActors.actor(2);
        }
        return actor;
    };
    Game_NoreParty.prototype.menuActorId = function () {
        if (this._menuActorId) {
            return this._menuActorId;
        }
        return 2;
    };
    Game_NoreParty.prototype.isDirty = function () {
        return this._dirty;
    };
    Game_NoreParty.prototype.setDirty = function () {
        this._dirty = true;
    };
    Game_NoreParty.prototype.clearDirty = function () {
        this._dirty = false;
    };
    Game_NoreParty.prototype.gainAlchemyItem = function (item, amount) {
        _super.prototype.gainItem.call(this, item, amount, false);
        if (amount > 0) {
            if (DataManager.isWeapon(item)) {
                //p('_newEquipGet')
                this._newEquipGet = true;
            }
            else if (DataManager.isArmor(item)) {
                var armor = item;
                if (armor.id != 201 && armor.id != 202) {
                    //p('_newEquipGet')
                    this._newEquipGet = true;
                }
            }
        }
    };
    Game_NoreParty.prototype.clearNewEquipGet = function () {
        this._newEquipGet = false;
    };
    Game_NoreParty.prototype.isNewEquipGet = function () {
        return this._newEquipGet;
    };
    Game_NoreParty.prototype.saveCostume = function (slotId) {
        for (var i = 1; i <= 24; i++) {
            var a = $gameActors.actor(i);
            a.saveCostume(slotId);
        }
    };
    Game_NoreParty.prototype.restoreCostume = function (slotId) {
        for (var i = 1; i <= 24; i++) {
            var a = $gameActors.actor(i);
            a.restoreCostume(slotId, true);
        }
    };
    Game_NoreParty.prototype.isLayeredCharacterEnabledMap = function (mapId) {
        return true;
    };
    Game_NoreParty.prototype.gainGold = function (amount) {
        if (amount > 0) {
            this._upGoldValue += amount;
        }
        _super.prototype.gainGold.call(this, amount);
        this._dirty = true;
    };
    Game_NoreParty.prototype.getActorIdList = function () {
        var result = [2, 3];
        if ($gameSystem.stage() >= 1) {
            result.push(1);
        }
        return result;
    };
    Game_NoreParty.prototype.members = function () {
        var r = [];
        for (var _i = 0, _a = this.getActorIdList(); _i < _a.length; _i++) {
            var id = _a[_i];
            r.push($gameActors.actor(id));
        }
        return r;
    };
    Game_NoreParty.prototype.outerAlphaMembers = function () {
        var r = [];
        for (var _i = 0, _a = [1, 2, 3, 4, 5]; _i < _a.length; _i++) {
            var id = _a[_i];
            r.push($gameActors.actor(id));
        }
        return r;
    };
    Game_NoreParty.prototype.makeMenuActorPrevious = function () {
        if (this.isNpcMenu()) {
            this.makeMenuActorPreviousNpc();
            return;
        }
        var actorId = this.menuActor().actorId();
        var actorIdList = this.getActorIdList();
        var index = actorIdList.indexOf(actorId);
        if (index < 0) {
            this.setMenuActorId(actorIdList[0]);
        }
        else if (index == 0) {
            this.setMenuActorId(actorIdList[actorIdList.length - 1]);
        }
        else {
            this.setMenuActorId(actorIdList[index - 1]);
        }
    };
    Game_NoreParty.prototype.makeMenuActorNext = function () {
        if (this.isNpcMenu()) {
            this.makeMenuActorNextNpc();
            return;
        }
        var actorId = this.menuActor().actorId();
        var actorIdList = this.getActorIdList();
        var index = actorIdList.indexOf(actorId);
        if (index < 0) {
            this.setMenuActorId(actorIdList[0]);
        }
        else if (index == actorIdList.length - 1) {
            this.setMenuActorId(actorIdList[0]);
        }
        else {
            this.setMenuActorId(actorIdList[index + 1]);
        }
    };
    Game_NoreParty.prototype.isNpcMenu = function () {
        var actorId = this.menuActor().actorId();
        return actorId >= 4;
    };
    Game_NoreParty.prototype.makeMenuActorNextNpc = function () {
        if (!$gameSwitches.value(Nore.JAN_BAISYUN_SW)) {
            return;
        }
        if (this.menuActor().actorId() == 4) {
            this.setMenuActorId(35);
        }
        else {
            this.setMenuActorId(4);
        }
    };
    Game_NoreParty.prototype.makeMenuActorPreviousNpc = function () {
        this.makeMenuActorNextNpc();
    };
    Game_NoreParty.prototype.alchemyManager = function () {
        return this._alchemyManager;
    };
    Game_NoreParty.prototype.inBaisyun = function () {
        return this._baisyun;
    };
    Game_NoreParty.prototype.startBaisyun = function () {
        this._baisyun = true;
    };
    Game_NoreParty.prototype.endBaisyun = function () {
        this._baisyun = false;
    };
    Game_NoreParty.prototype.inDungeon = function () {
        return this._dungeon;
    };
    Game_NoreParty.prototype.startDungeon = function () {
        this._dungeon = true;
        this._user.onDungeonStart();
    };
    Game_NoreParty.prototype.endDungeon = function () {
        this._dungeon = false;
    };
    Game_NoreParty.prototype.oVoctory = function () {
    };
    Game_NoreParty.prototype.onKill = function () {
    };
    Game_NoreParty.prototype.alchemyLevel = function () {
        return this.alchemyActor().level;
    };
    Game_NoreParty.prototype.alchemyActor = function () {
        return $gameActors.actor(100);
    };
    Game_NoreParty.prototype.mostDamageTarget = function () {
        var max = this.aliveMembers()[0];
        var maxDamage = max.mhp - max.hp;
        for (var _i = 0, _a = this.aliveMembers(); _i < _a.length; _i++) {
            var a = _a[_i];
            var actor = a;
            var damage = actor.mhp - a.hp;
            if (damage > maxDamage) {
                maxDamage = damage;
                max = actor;
            }
        }
        return max;
    };
    Game_NoreParty.prototype.minHpTarget = function () {
        var min = this.aliveMembers()[0];
        for (var _i = 0, _a = this.aliveMembers(); _i < _a.length; _i++) {
            var a = _a[_i];
            if (a.hp < min.hp) {
                min = a;
            }
        }
        return min;
    };
    Game_NoreParty.prototype.maxHpTarget = function () {
        var max = this.aliveMembers()[0];
        for (var _i = 0, _a = this.aliveMembers(); _i < _a.length; _i++) {
            var a = _a[_i];
            if (a.hp > max.hp) {
                max = a;
            }
        }
        return max;
    };
    Game_NoreParty.prototype.gainMaterialPower = function (type, n) {
        this._materialList[type] += n;
    };
    Game_NoreParty.prototype.loseMaterialPower = function (type, n) {
        if (this._materialList[type] < n) {
            console.error('マテリアルを減らせません');
            return;
        }
        if (this._materialList[type] < n) {
            console.error('マテリアルが足りません' + type + ' ' + n);
            return;
        }
        this._materialList[type] -= n;
    };
    Game_NoreParty.prototype.materialList = function () {
        this._materialList = this._materialList || [0, 0, 0, 0, 0];
        return this._materialList;
    };
    Game_NoreParty.prototype.materialIcon = function (index) {
        switch (index) {
            case 0: return 240;
            case 1: return 243; //756;
            case 2: return 548;
            case 3: return 1002;
            case 4: return 490;
        }
    };
    Game_NoreParty.prototype.randomFrontTarget = function () {
        return _super.prototype.randomTarget.call(this);
    };
    Game_NoreParty.prototype.user = function () {
        return this._user;
    };
    Game_NoreParty.prototype.userActor = function () {
        return this._userActor;
    };
    Game_NoreParty.prototype.onBattleStart = function (advantageous) {
        _super.prototype.onBattleStart.call(this, advantageous);
        this._userActor = new Game_UserActor(this.userActorId());
        this._userActor.onBattleStart(advantageous);
    };
    Game_NoreParty.prototype.userActorId = function () {
        return 98;
    };
    Game_NoreParty.prototype.onTurnStart = function () {
        this._user.onTurnStart();
    };
    Game_NoreParty.prototype.onBattleEnd = function () {
        this._user.cooldown(0);
        _super.prototype.onBattleEnd.call(this);
        this._userActor = null;
    };
    Game_NoreParty.prototype.makeEquipActions = function () {
        for (var _i = 0, _a = this.battleMembers(); _i < _a.length; _i++) {
            var a = _a[_i];
            a.makeEquipActions();
        }
    };
    Game_NoreParty.prototype.nextNewRecipe = function () {
        if (this._newRecipeList.length > 0) {
            return this._newRecipeList.shift();
        }
        return -1;
    };
    Game_NoreParty.prototype.onGotMaterialItem = function (itemId) {
        var isNewItem = this.gainNewItem(itemId);
        if (isNewItem) {
            this.checkNewRecipe(itemId);
        }
    };
    Game_NoreParty.prototype.gainNewItem = function (itemId) {
        if (this._getMaterialIdMap[itemId]) {
            return false;
        }
        this._getMaterialIdMap[itemId] = true;
        return true;
    };
    Game_NoreParty.prototype.isNewItem = function (itemId) {
        if (this._getMaterialIdMap[itemId]) {
            return false;
        }
        return true;
    };
    Game_NoreParty.prototype.isLearnRecipe = function (id) {
        return this._learnRecipeMap[id] != null;
    };
    Game_NoreParty.prototype.learnRecipe = function (id, skipNewRecipe) {
        if (skipNewRecipe === void 0) { skipNewRecipe = false; }
        if (this._learnRecipeMap[id]) {
            return false;
        }
        this._learnRecipeMap[id] = true;
        if (skipNewRecipe) {
            return true;
            ;
        }
        this._newRecipeList.push(id);
        return true;
        ;
    };
    Game_NoreParty.prototype.isNewRecipe = function (id) {
        return this._newRecipeList.indexOf(id) >= 0;
    };
    Game_NoreParty.prototype.hasNewRecipe = function () {
        return this._newRecipeList.length > 0;
    };
    Game_NoreParty.prototype.onTurnEnd = function () {
        for (var _i = 0, _a = this.aliveMembers(); _i < _a.length; _i++) {
            var b = _a[_i];
            b.onTurnEnd();
        }
    };
    Game_NoreParty.prototype.itemHasNewRecipe = function (itemId) {
        if (!this.isNewItem(itemId)) {
            return false;
        }
        for (var key in RECIPE_MAP) {
            var param = RECIPE_MAP[key];
            if (param[this.recipeItemIndex()] == itemId) {
                return true;
            }
        }
        return false;
    };
    Game_NoreParty.prototype.recipeItemIndex = function () {
        return 6;
    };
    Game_NoreParty.prototype.numItems = function (item, includeEquip) {
        if (includeEquip === void 0) { includeEquip = false; }
        var n = _super.prototype.numItems.call(this, item);
        if (includeEquip) {
            if (!DataManager.isItem(item)) {
                var equip = item;
                for (var _i = 0, _a = this.members(); _i < _a.length; _i++) {
                    var a = _a[_i];
                    n += a.actorEquip().numItems(equip);
                }
            }
        }
        return n;
    };
    Game_NoreParty.prototype.addItemHistory = function (itemId) {
        this._itemGotMap[itemId] = this._itemGotMap[itemId] || 0;
        this._itemGotMap[itemId]++;
    };
    Game_NoreParty.prototype.isGotItem = function (itemId) {
        return this._itemGotMap[itemId] > 0;
    };
    Game_NoreParty.prototype.checkNewRecipe = function (id) {
        for (var key in RECIPE_MAP) {
            var param = RECIPE_MAP[key];
            if (param[1] > 0) {
                if (!$gameSwitches.value(param[1])) {
                    // 習得swがOFF
                    continue;
                }
            }
            if (param[this.recipeItemIndex()] == id) {
                var recipeId = parseInt(key);
                if (!this._learnRecipeMap[recipeId]) {
                    this.learnRecipe(recipeId);
                }
            }
        }
    };
    Game_NoreParty.prototype.recheckNewRecipe = function () {
        for (var key in this._itemGotMap) {
            var itemId = parseInt(key);
            this.checkNewRecipe(itemId);
        }
    };
    Game_NoreParty.prototype.masekiActorSet = function () {
        return this._masekiActorSet;
    };
    /**
     *
     * @deprecated
     */
    Game_NoreParty.prototype.addSeiekiList = function (type, actorId, list) {
        console.error('このメソッドは使われていません');
        if (!this._daySeieki) {
            this._daySeieki = new DaySeieki();
        }
        this._daySeieki.addSeiekiList(type, actorId, list);
        this.dayResultList().addSeiekiList(actorId, type, list);
    };
    Game_NoreParty.prototype.addDayResult = function (type, actorId, commonId, seieki, friendship, ranshi) {
        console.error('このメソッドは使われていません');
        this.dayResultList().addDayResult(actorId, type, commonId, seieki, friendship, ranshi);
    };
    Game_NoreParty.prototype.addSeiekiResultAndGainSeieki = function (seiekiResult) {
        if (!seiekiResult) {
            p('seiekiResult が null のため登録しませんでした');
            return;
        }
        this.findDayResultList(seiekiResult.day()).addSeiekiResult(seiekiResult);
        if (seiekiResult.isGainSeieki()) {
            this.gainMaterialPower(MaterialType.seieki, seiekiResult.seieki().value());
        }
    };
    Game_NoreParty.prototype.isSeiekiEmpty = function () {
        if (!this._daySeieki) {
            return true;
        }
        return this._daySeieki.isEmpty();
    };
    Game_NoreParty.prototype.nextDay = function () {
        this._daySeieki = new DaySeieki();
        this._dayResultHistory.nextDay();
        this.clearBaisyunGoldList();
        this.clearSikyuSeieki();
    };
    Game_NoreParty.prototype.clearSikyuSeieki = function () {
        for (var i = 1; i <= 5; i++) {
            var actor = $gameActors.actor(i);
            actor.sikyu().clear();
        }
    };
    Game_NoreParty.prototype.dayResultHistory = function () {
        return this._dayResultHistory;
    };
    Game_NoreParty.prototype.baisyunGoldList = function () {
        if (!this._dayBaisyunGoldList) {
            return [];
        }
        return this._dayBaisyunGoldList;
    };
    Game_NoreParty.prototype.addBaisyunGold = function (n) {
        if (!this._dayBaisyunGoldList) {
            this._dayBaisyunGoldList = [];
        }
        this._dayBaisyunGoldList.push(n);
        this.gainGold(n);
    };
    Game_NoreParty.prototype.clearBaisyunGoldList = function () {
        this._dayBaisyunGoldList = [];
    };
    Game_NoreParty.prototype.dayResultList = function () {
        p('このメソッドは使わない予定');
        return this._dayResultHistory.currentList();
    };
    Game_NoreParty.prototype.currentDayResultList = function () {
        return this._dayResultHistory.currentList();
    };
    Game_NoreParty.prototype.findDayResultList = function (day) {
        return this._dayResultHistory.findDayResultList(day);
    };
    Game_NoreParty.prototype.seiekiSetList = function () {
        if (!this._daySeieki) {
            return [];
        }
        return this._daySeieki.seiekiSetList();
    };
    Game_NoreParty.prototype.ninshinActorExists = function () {
        for (var _i = 0, _a = this.members(); _i < _a.length; _i++) {
            var a = _a[_i];
            if (a.isNinshin() && a.isBote()) {
                return true;
            }
        }
        return false;
    };
    Game_NoreParty.prototype.setVarNinshinActorName = function () {
        for (var _i = 0, _a = this.members(); _i < _a.length; _i++) {
            var a = _a[_i];
            if (a.isNinshin() && a.isBote()) {
                a.babyHistory().updateActorNameVar();
                return;
            }
        }
    };
    Game_NoreParty.prototype.bakudanUp = function () {
        return this.countSpecial(EquipSpecial.bakudanUp);
    };
    Game_NoreParty.prototype.magicUp = function () {
        return this.countSpecial(EquipSpecial.magicUp);
    };
    Game_NoreParty.prototype.countSpecial = function (s) {
        var n = 0;
        for (var _i = 0, _a = this.battleMembers(); _i < _a.length; _i++) {
            var a = _a[_i];
            n += a.countSpecial(s);
        }
        return n;
    };
    Game_NoreParty.prototype.loseGold = function (n) {
        if (n > 0) {
            $gameMedals.onLoseGold(n);
        }
        _super.prototype.loseGold.call(this, n);
    };
    return Game_NoreParty;
}(Game_Party));
var MilkSet = /** @class */ (function () {
    function MilkSet() {
        this._map = {};
    }
    MilkSet.prototype.push = function (milk) {
        if (this._map[milk.id]) {
            this._map[milk.id].num++;
        }
        else {
            this._map[milk.id] = new Milk(milk);
        }
    };
    MilkSet.prototype.makeList = function () {
        var array = [];
        for (var key in this._map) {
            var milk = this._map[key];
            array.push(milk);
        }
        array = array.sort(function (a, b) {
            return a.id() - b.id();
        });
        return array;
    };
    return MilkSet;
}());
var Milk = /** @class */ (function () {
    function Milk(item) {
        this._item = item;
        this.num = 1;
    }
    Milk.prototype.id = function () {
        return this._item.id;
    };
    Milk.prototype.item = function () {
        return this._item;
    };
    return Milk;
}());
