var PictralBookItem = /** @class */ (function () {
    function PictralBookItem(rank, item, enabled) {
        this._rank = rank;
        this._item = item;
        this._enabled = enabled;
    }
    PictralBookItem.prototype.item = function () {
        return this._item;
    };
    PictralBookItem.prototype.itemId = function () {
        return this.item().id;
    };
    PictralBookItem.prototype.iconIndex = function () {
        return this.item().iconIndex;
    };
    PictralBookItem.prototype.isEnabled = function () {
        return this._enabled;
    };
    PictralBookItem.prototype.sortValue = function () {
        if (DataManager.isItem(this._item)) {
            return this._rank * 10000 + this._item.id;
        }
        if (DataManager.isWeapon(this._item)) {
            return this._rank * 10000 + 1000 + this._item.id;
        }
        return this._rank * 10000 + 2000 + this._item.id;
    };
    return PictralBookItem;
}());
var PictralBook = /** @class */ (function () {
    function PictralBook() {
        this._itemList = [];
        this.parseDungeonItem();
        this.parseRecipeItem();
        this.sort();
    }
    PictralBook.prototype.sort = function () {
        this._itemList = this._itemList.sort(function (a, b) {
            return a.sortValue() - b.sortValue();
        });
    };
    PictralBook.prototype.parseDungeonItem = function () {
        var history = $gameSystem.alchemyHistory();
        for (var _i = 0, _a = getAllDungeonItemList(); _i < _a.length; _i++) {
            var dungeonItem = _a[_i];
            if (!dungeonItem.isCollection()) {
                continue;
            }
            var rank = dungeonItem.dungeonId();
            var itemId = dungeonItem.itemId();
            var rpgItem = $dataItems[itemId];
            var enabled = $gameParty.isGotItem(itemId) || this.isSpecialItemGot(rpgItem) || history.isItemMade(rpgItem);
            var item = new PictralBookItem(rank, rpgItem, enabled);
            this._itemList.push(item);
        }
    };
    PictralBook.prototype.parseRecipeItem = function () {
        var history = $gameSystem.alchemyHistory();
        for (var _i = 0, _a = $recipeManager.makeRecipeListForPictralBook(); _i < _a.length; _i++) {
            var recipeItem = _a[_i];
            if (recipeItem.isCard()) {
                continue;
            }
            if (!recipeItem.isCollection()) {
                continue;
            }
            var destItem = recipeItem.destItem();
            if (this.itemExists(destItem)) {
                continue;
            }
            var rank = recipeItem.level();
            var enabled = history.isRecipeMade(recipeItem.id());
            var item = new PictralBookItem(rank, destItem, enabled);
            this._itemList.push(item);
        }
    };
    PictralBook.prototype.itemExists = function (item) {
        for (var _i = 0, _a = this._itemList; _i < _a.length; _i++) {
            var pb = _a[_i];
            if (pb.item() == item) {
                return true;
            }
        }
        return false;
    };
    PictralBook.prototype.isSpecialItemGot = function (item) {
        if (item.id == 18) {
            // 魔法のロープ
            return $gameSwitches.value(218);
        }
        if (item.id == 214) {
            // 愚者の金
            return $gameSwitches.value(219);
        }
        if (item.id == 197) {
            // 白紙の学術書
            return $gameSwitches.value(217);
        }
        if (item.id == 206) {
            // しあわせのタネ
            return $gameSwitches.value(353);
        }
        return false;
    };
    PictralBook.prototype.itemList = function () {
        return this._itemList;
    };
    PictralBook.prototype.collectionRate = function () {
        var total = 0;
        var gotNum = 0;
        for (var _i = 0, _a = this._itemList; _i < _a.length; _i++) {
            var item = _a[_i];
            total++;
            if (item.isEnabled()) {
                gotNum++;
            }
        }
        var rate = Math.round(gotNum * 100 / total);
        if (rate == 100 && gotNum < total) {
            return 99;
        }
        return rate;
    };
    return PictralBook;
}());
