var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command show
 * @text 図鑑を表示
 *
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_PictorialBookUi';
    PluginManager.registerCommand(pluginName, 'show', function (args) {
        SceneManager.push(Scene_PictralBook);
    });
})(Nore || (Nore = {}));
var PICTRAL_BOOK_Y = 100;
var Scene_PictralBook = /** @class */ (function (_super) {
    __extends(Scene_PictralBook, _super);
    function Scene_PictralBook() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_PictralBook.prototype.create = function () {
        _super.prototype.create.call(this);
        this.createHelpWindow();
        this.createPictralBook();
        this.createPictralBookWindow();
        this.createNameSprite();
        this.createTitleSprite();
    };
    Scene_PictralBook.prototype.createBackground = function () {
    };
    Scene_PictralBook.prototype.start = function () {
        _super.prototype.start.call(this);
        this.onChange();
    };
    Scene_PictralBook.prototype.createTitleSprite = function () {
        this._titleSprite = new PictoralBookTitleSprite(this._pictralBook);
        this.addChild(this._titleSprite);
    };
    Scene_PictralBook.prototype.createNameSprite = function () {
        this._nameSprite = new Sprite_AlchemyResultName(true);
        this._nameSprite.x = 841;
        this._nameSprite.y = PICTRAL_BOOK_Y - 19;
        this.addChild(this._nameSprite);
    };
    Scene_PictralBook.prototype.createPictralBook = function () {
        this._pictralBook = new PictralBook();
    };
    Scene_PictralBook.prototype.createPictralBookWindow = function () {
        this._pictralBookWindow = new Window_PictralBook();
        this._pictralBookWindow.setHandler('cancel', this.onCancel.bind(this));
        this._pictralBookWindow.setHandler('change', this.onChange.bind(this));
        this._pictralBookWindow.setup(this._pictralBook);
        this.addChild(this._pictralBookWindow);
        this._pictralBookWindow.select(0);
        this._pictralBookWindow.activate();
    };
    Scene_PictralBook.prototype.onChange = function () {
        if (!this._nameSprite) {
            return;
        }
        var item = this._pictralBookWindow.selectedItem();
        p(item.item().name + ' ' + item.itemId());
        if (!item.isEnabled()) {
            this._helpWindow.hide();
            this._nameSprite.hide();
            return;
        }
        var baseItem = item.item();
        this._helpWindow.show();
        this._helpWindow.setItem(baseItem);
        this._nameSprite.showResult(baseItem);
    };
    Scene_PictralBook.prototype.onCancel = function () {
        this.popScene();
    };
    Scene_PictralBook.prototype.createHelpWindow = function () {
        var rect = this.helpWindowRect();
        this._helpWindow = new Window_EquipHelp(rect);
        this._helpWindow._equipHelpSprite.hideName();
        this.addWindow(this._helpWindow);
    };
    Scene_PictralBook.prototype.helpWindowRect = function () {
        var wx = 866;
        //const wy = this.helpAreaTop();
        var wy = PICTRAL_BOOK_Y;
        var ww = 400;
        var wh = 400;
        return new Rectangle(wx, wy, ww, wh);
    };
    return Scene_PictralBook;
}(Scene_MenuBase));
var Window_ItemHelp = /** @class */ (function (_super) {
    __extends(Window_ItemHelp, _super);
    function Window_ItemHelp(r) {
        var _this = _super.call(this, r) || this;
        _this._equipHelpSprite = new Sprite_EquipHelp();
        _this.addChild(_this._equipHelpSprite);
        _this._equipHelpSprite.x = 10;
        _this._equipHelpSprite.y = 6;
        return _this;
    }
    Window_ItemHelp.prototype.baseTextRect = function () {
        var rect = new Rectangle(20, 0, this.innerWidth - 80, this.innerHeight);
        rect.pad(-this.itemPadding(), 0);
        return rect;
    };
    Window_ItemHelp.prototype.clear = function () {
        this.contents.clear();
        this._equipHelpSprite.clear();
    };
    Window_ItemHelp.prototype.setItem = function (item, actor, slot) {
        if (slot && slot.isLock(actor.level)) {
            this._equipHelpSprite.clear();
            var text = TextManager.slotLv.format(slot.needLevel());
            this.drawText(text, 20, 10, 200);
        }
        else {
            this._equipHelpSprite.setItem(item);
        }
    };
    return Window_ItemHelp;
}(Window_Base));
var Window_PictralBook = /** @class */ (function (_super) {
    __extends(Window_PictralBook, _super);
    function Window_PictralBook() {
        var r = new Rectangle(5, PICTRAL_BOOK_Y, Graphics.width - 10 * 2 - 406, Graphics.height - 152);
        return _super.call(this, r) || this;
    }
    Window_PictralBook.prototype.setup = function (pictralBook) {
        this._pictralBook = pictralBook;
        this._data = this._pictralBook.itemList();
        this.refresh();
    };
    Window_PictralBook.prototype.maxCols = function () {
        return 15;
    };
    Window_PictralBook.prototype.maxItems = function () {
        if (this._data) {
            return this._data.length;
        }
        return 0;
    };
    Window_PictralBook.prototype.drawItem = function (index) {
        var tempBitmap = new Bitmap(32, 32);
        var item = this._data[index];
        var rect = this.itemRect(index);
        if (item.isEnabled()) {
            this.drawIcon(item.iconIndex(), rect.x + 5, rect.y + 2);
        }
        else {
            this.drawBlackIcon2(item.iconIndex(), rect.x + 5, rect.y + 2, tempBitmap);
        }
    };
    Window_PictralBook.prototype.drawBlackIcon2 = function (iconIndex, dx, dy, tempBitmap) {
        var bitmap = ImageManager.loadSystem("IconSet");
        var pw = ImageManager.iconWidth;
        var ph = ImageManager.iconHeight;
        var sx = (iconIndex % 16) * pw;
        var sy = Math.floor(iconIndex / 16) * ph;
        var imageData = bitmap.context.getImageData(sx, sy, 32, 32);
        var data = imageData.data;
        for (var i = 0; i < data.length; i += 4) {
            data[i] = 109;
            data[i + 1] = 121;
            data[i + 2] = 129;
        }
        tempBitmap.clear();
        var bImageData = tempBitmap.context.getImageData(0, 0, 32, 32);
        bImageData.data.set(data);
        tempBitmap.context.putImageData(imageData, 0, 0);
        this.contents.blt(tempBitmap, 0, 0, pw, ph, dx, dy);
    };
    Window_PictralBook.prototype.selectedItem = function () {
        return this._data[this.index()];
    };
    return Window_PictralBook;
}(Window_Selectable));
var PictoralBookTitleSprite = /** @class */ (function (_super) {
    __extends(PictoralBookTitleSprite, _super);
    function PictoralBookTitleSprite(pictralBook) {
        var _this = _super.call(this) || this;
        _this.bitmap = ImageManager.loadSystem('alchemy_ui');
        var offsetY = ConfigManager.isJp() ? 0 : 100;
        _this.setFrame(0, 700 + offsetY, 450, 100);
        var rate = pictralBook.collectionRate();
        _this.drawNumber(rate, 210, 13, 100, 'right', 16);
        return _this;
    }
    return PictoralBookTitleSprite;
}(Sprite));
