var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Game_CharacterBase.prototype.rotation = function () {
    return 0;
};
Game_Event.prototype.rotation = function () {
    if (!this.page()) {
        return 0;
    }
    var list = this.page().list;
    if (list.length == 0) {
        return 0;
    }
    var firstEvent = list[0];
    if (firstEvent.code != 108) {
        return 0;
    }
    if (firstEvent.parameters[0] == 'rotation') {
        return 90 * (Math.PI / 180);
    }
    return 0;
};
var _Game_Event_screenX = Game_Event.prototype.screenX;
Game_Event.prototype.screenX = function () {
    if (this.rotation() > 0) {
        return _Game_Event_screenX.call(this) - 20;
    }
    return _Game_Event_screenX.call(this);
};
var _Game_Event_screenY = Game_Event.prototype.screenY;
Game_Event.prototype.screenY = function () {
    if (this.rotation() > 0) {
        return _Game_Event_screenY.call(this) - 20;
    }
    return _Game_Event_screenY.call(this);
};
var Game_Player2 = /** @class */ (function (_super) {
    __extends(Game_Player2, _super);
    function Game_Player2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Game_Player2.prototype.initMembers = function () {
        _super.prototype.initMembers.call(this);
        this._baisyunFollowers = new Game_BaisyunFollowers();
        this._normalFollowers = this._followers;
    };
    Game_Player2.prototype.mainActorId = function () {
        if ($gameParty.inBaisyun()) {
            return $gameSystem.baisyun().actorId();
        }
        if ($gameVariables.value(30)) {
            return $gameVariables.value(30);
        }
        //if ($gameSwitches.value(162)) {
        // サツキ同棲H
        if ($gameSystem.isDouseiOpen()) {
            if ($gameSystem.isNight()) {
                if (this.isInFloor2()) {
                    this.reserveGinaActorScenario();
                    return 6;
                }
            }
        }
        //}
        return 2;
    };
    Game_Player2.prototype.isInFloor2 = function () {
        return $gameVariables.value(72) == DestType.floor2;
    };
    Game_Player2.prototype.reserveGinaActorScenario = function () {
        if ($gameSwitches.value(166)) {
            return;
        }
        $gameSwitches.setValue(166, true);
        $commonEvent.reserveCommonEvent(380, CommonIdType.normal);
    };
    Game_Player2.prototype.mainActor = function () {
        return $gameActors.actor(this.mainActorId());
    };
    Game_Player2.prototype.screenY = function () {
        var y = _super.prototype.screenY.call(this);
        return y + $gameVariables.value(89);
    };
    Game_Player2.prototype.startBaisyun = function () {
        this._followers = this._baisyunFollowers;
        this._baisyunFollowers.setup();
        this._followers.gather();
        for (var i = 0; i < 10; i++) {
            this._followers.updateMove();
        }
        this.refresh();
    };
    Game_Player2.prototype.endBaisyun = function () {
        this._followers = this._normalFollowers;
    };
    Game_Player2.prototype.canMove = function () {
        if ($gameTemp.isBusy()) {
            return false;
        }
        return _super.prototype.canMove.call(this);
    };
    Game_Player2.prototype.startMapEvent = function (x, y, triggers, normal) {
        if (!$gameMap.isEventRunning()) {
            for (var _i = 0, _a = $gameMap.eventsXy(x, y); _i < _a.length; _i++) {
                var event_1 = _a[_i];
                if (event_1.event && event_1.event().meta['manId']) {
                    var manId = parseInt(event_1.event().meta['manId']);
                    if (!this.isBaisyunConditionMatch(manId)) {
                        continue;
                    }
                }
                if (event_1.isTriggerIn(triggers) &&
                    event_1.isNormalPriority() === normal) {
                    event_1.start();
                }
            }
        }
    };
    Game_Player2.prototype.isBaisyunConditionMatch = function (manId) {
        if ($gameSwitches.value(51)) {
            return this.isBaisyunConditionMatchNinshin(manId);
        }
        if (!$gameParty.inBaisyun()) {
            return false;
        }
        if ($gameSystem.isRecollection()) {
            return true;
        }
        var actorId = $gameSystem.baisyunActorId();
        var param = $baisyunManParamManager.findManParam(actorId, manId);
        if (!param) {
            return false;
        }
        var fame = $gameActors.actor(actorId).baisyunHistory().calcFame();
        return new BaisyunStatusMan(actorId, param, null).isEnabled(fame);
    };
    Game_Player2.prototype.isBaisyunConditionMatchNinshin = function (manId) {
        if ($gameSwitches.value(999)) {
            return true;
        }
        var actorId = $gameSystem.baisyunActorId();
        var param = $baisyunManParamManager.findManParam(actorId, manId);
        if (!param) {
            return false;
        }
        var fame = $gameActors.actor(actorId).baisyunHistory().calcFame();
        return new BaisyunStatusMan(actorId, param, null).isEnabled(fame);
    };
    Game_Player2.prototype.isCollidedWithEvents = function (x, y) {
        var events = $gameMap.eventsXyNt(x, y);
        for (var _i = 0, events_1 = events; _i < events_1.length; _i++) {
            var event_2 = events_1[_i];
            if (event_2.event && event_2.event().meta['manId']) {
                var manId = parseInt(event_2.event().meta['manId']);
                if (!this.isBaisyunConditionMatch(manId)) {
                    continue;
                }
            }
            if (event_2.isNormalPriority()) {
                return true;
            }
        }
        return false;
        //return events.some(event => event.isNormalPriority());
    };
    Game_Player2.prototype.canEncounter = function () {
        return false;
    };
    return Game_Player2;
}(Game_Player));
Game_Map.prototype.displayX = function () {
    var x = this._displayX;
    if (false) {
        return x - 10;
    }
    return x;
};
