var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command reco
 * @text 回想登録
 * @des 回想登録
 * @arg id
 * @type number
 * @text id
 * @desc id
 *
 * @command openRecollection
 * @text 回想全解放
 *
 * @command closeRecollection
 * @text 回想全解放を元に戻す
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Recollection';
    PluginManager.registerCommand(pluginName, 'reco', function (args) {
        var switchId = parseInt(args.id);
        if ($gameSystem.isRecollection()) {
            p('回想中なので回想登録しませんでした: ' + switchId);
            return;
        }
        p('回想登録:' + switchId);
        var info = DataManager._globalInfo;
        if (!info) {
            p('失敗');
            return;
        }
        info[99] = info[99] || {};
        if (info[99][switchId]) {
            return;
        }
        info[99][switchId] = true;
    });
    PluginManager.registerCommand(pluginName, 'openRecollection', function (args) {
        ConfigManager.openRecollection = true;
        ConfigManager.save();
    });
    PluginManager.registerCommand(pluginName, 'closeRecollection', function (args) {
        ConfigManager.openRecollection = false;
        ConfigManager.save();
    });
})(Nore || (Nore = {}));
var $noreRecoActorId = -2;
var $recoListIndex = -1;
var $recoListScrollY = -1;
var SANDBOX_MAP_ID = 6;
var OTHER_H = 98;
var EVENT = 99;
var Scene_Recollection = /** @class */ (function (_super) {
    __extends(Scene_Recollection, _super);
    function Scene_Recollection() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_Recollection.prototype.create = function () {
        _super.prototype.create.call(this);
        this.createCommandWindow();
    };
    Scene_Recollection.prototype.start = function () {
        _super.prototype.start.call(this);
        this.playBgm();
        this._recListWindow.refresh();
    };
    Scene_Recollection.prototype.playBgm = function () {
        var bgm = {
            "name": "LNEW_BGM14_Sad1",
            "pan": 0,
            "pitch": 100,
            "volume": 50
        };
        AudioManager.playBgm(bgm);
    };
    Scene_Recollection.prototype.createCommandWindow = function () {
        this._recListWindow = new Window_RecList2(-4, 58, Graphics.width, Graphics.height - 62);
        this._recListWindow.visible = true;
        this._recListWindow.deactivate();
        this._recListWindow.setHandler('ok', this.commandDoRecMode.bind(this));
        this._recListWindow.setHandler('cancel', this.onCancelList.bind(this));
        this._recListWindow.setHandler('activate', this.onOk.bind(this));
        this.addChild(this._recListWindow);
        this._recoActorWindow = new Window_RecoActor();
        this._recoActorWindow.refresh();
        this.addChild(this._recoActorWindow);
        this._recListWindow.deactivate();
        this._recoActorWindow.activate();
        this._recoActorWindow.setHandler('change', this.onChange.bind(this));
        this._recoActorWindow.setHandler('cancel', this.onActorCancel.bind(this));
        this._recoActorWindow.setHandler('ok', this.onOk.bind(this));
        this._recListWindow.setParentCommandWindow(this._recoActorWindow);
        this.selectInitialActor();
    };
    Scene_Recollection.prototype.onActorCancel = function () {
        SceneManager.goto(Nore.Scene_Title2);
    };
    Scene_Recollection.prototype.selectInitialActor = function () {
        if ($noreRecoActorId >= -1) {
            this._recoActorWindow.selectActor($noreRecoActorId);
            this._recoActorWindow.deactivate();
            this.onOk();
        }
    };
    Scene_Recollection.prototype.onChange = function () {
        var actorId = this._recoActorWindow.selectedActorId();
        this._recListWindow.setActorId(actorId);
    };
    Scene_Recollection.prototype.onOk = function () {
        this._recoActorWindow.deactivate();
        var actorId = this._recoActorWindow.selectedActorId();
        $noreRecoActorId = actorId;
        this._recListWindow.activate();
    };
    Scene_Recollection.prototype.onCancelList = function () {
        this._recoActorWindow.activate();
    };
    Scene_Recollection.prototype.commandDoRecMode = function () {
        var info = this._recListWindow.selectedInfo();
        $recoListIndex = this._recListWindow.index();
        $recoListScrollY = this._recListWindow.scrollY();
        $gameTemp.ignoreFiles = {};
        $gameTemp.eroBack = null;
        if (this._recListWindow.isVisible(info)) {
            // 回想モードの場合
            DataManager.setupNewGame();
            $gamePlayer.setTransparent(true);
            this.fadeOutAll();
            //$dataSystem.optTransparent = false;
            var commonEventId = info.commonId;
            p('回想実行:' + commonEventId);
            $gameTemp.reserveCommonEvent(commonEventId);
            $gamePlayer.reserveTransfer(SANDBOX_MAP_ID, 0, 0, 0);
            $gameSwitches.setValue(999, true);
            sessionStorage.setItem('noreCommonEventId', commonEventId);
            sessionStorage.setItem('norePlayerMap', SANDBOX_MAP_ID);
            SceneManager.push(Scene_Map2);
        }
        else {
            SoundManager.playBuzzer();
            this._recListWindow.activate();
        }
        this._recListWindow.refresh();
    };
    return Scene_Recollection;
}(Scene_Base));
var Window_Recollection = /** @class */ (function (_super) {
    __extends(Window_Recollection, _super);
    function Window_Recollection() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_Recollection.prototype.itemHeight = function () {
        return 228;
    };
    ;
    return Window_Recollection;
}(Window_Selectable));
var Window_RecoActor = /** @class */ (function (_super) {
    __extends(Window_RecoActor, _super);
    function Window_RecoActor() {
        var _this = this;
        var r = new Rectangle(-4, -4, 904, 68);
        _this = _super.call(this, r) || this;
        _this.select(0);
        return _this;
    }
    Window_RecoActor.prototype.maxItems = function () {
        return this.actorIdList().length;
    };
    Window_RecoActor.prototype.maxCols = function () {
        return this.maxItems();
    };
    Window_RecoActor.prototype.drawItem = function (index) {
        this.contents.fontSize = 22;
        var rect = this.itemRect(index);
        var yOffset = 2;
        var actorId = this.actorIdList()[index];
        if (actorId < 0) {
            this.drawText('ALL', rect.x, rect.y + yOffset, rect.width, 'center');
        }
        else if (actorId == OTHER_H) {
            this.drawText('OTHER', rect.x, rect.y + yOffset, rect.width, 'center');
        }
        else if (actorId == 6) {
            this.drawText('EVENT', rect.x, rect.y + yOffset, rect.width, 'center');
        }
        else if (actorId == 5) {
            this.drawText('OTHER H', rect.x, rect.y + yOffset, rect.width, 'center');
        }
        else {
            var actor = $gameActors.actor(actorId);
            var iconIndex = actor.iconIndex();
            this.drawIcon(iconIndex, rect.x + 10, rect.y + 2);
            this.drawText(actor.name(), rect.x + 42, rect.y + yOffset, rect.width, 'left');
        }
    };
    Window_RecoActor.prototype.actorIdList = function () {
        return [-1, 2, 1, 3, 5, 6]; //, EVENT_OFF, EVENT_ON];
    };
    Window_RecoActor.prototype.selectedActorId = function () {
        return this.actorIdList()[this.index()];
    };
    Window_RecoActor.prototype.selectActor = function (actorId) {
        var index = this.actorIdList().indexOf(actorId);
        this.select(index);
    };
    Window_RecoActor.prototype.isEventOn = function () {
        return $gameTemp.recoEventOn;
    };
    return Window_RecoActor;
}(Window_Selectable));
var RecoInfo = /** @class */ (function () {
    function RecoInfo() {
    }
    return RecoInfo;
}());
var Window_RecList2 = /** @class */ (function (_super) {
    __extends(Window_RecList2, _super);
    function Window_RecList2(x, y, width, height) {
        var _this = _super.call(this, new Rectangle(x, y, width, height)) || this;
        _this.select(0);
        _this.get_global_variables();
        _this.loadThumbnailList();
        _this._actorId = -1;
        _this.refresh();
        _this.autoSelect();
        return _this;
    }
    Window_RecList2.prototype.autoSelect = function () {
        if ($recoListIndex >= 0) {
            this.select($recoListIndex);
        }
        if ($recoListScrollY > 0) {
            this.scrollTo(0, $recoListScrollY);
        }
    };
    Window_RecList2.prototype.loadThumbnailList = function () {
        var infos = recollectionList;
        for (var i = 0; i < infos.length; i++) {
            var info = infos[i];
            if (this.isVisible(info)) {
                var bmpName = info.thumbnail;
                var bmp = ImageManager.loadEro(bmpName);
            }
        }
        ImageManager.loadEro('never_watch_picture');
    };
    Window_RecList2.prototype.isVisible = function (info) {
        if (this.isShowAll()) {
            return true;
        }
        if (this.isSwOk(info)) {
            return true;
        }
        if (Nore.isOmakeRecollection(info.switchId)) {
            return true;
        }
        return false;
    };
    Window_RecList2.prototype.isSwOk = function (info) {
        if (this._global_variables["switches"][info.switchId]) {
            return true;
        }
    };
    Window_RecList2.prototype.standardPadding = function () {
        return 4;
    };
    Window_RecList2.prototype.makeData = function () {
        this._data = [];
        for (var _i = 0, recollectionList_1 = recollectionList; _i < recollectionList_1.length; _i++) {
            var info = recollectionList_1[_i];
            if (this.isInclude(info)) {
                this._data.push(info);
            }
        }
    };
    Window_RecList2.prototype.isInclude = function (data) {
        if (this._actorId < 0) {
            return true;
        }
        /*else if (! $gameTemp.recoEventOn) {
            if (data.event) {
                return false;
            }
        }*/
        if (this._actorId == data.actorId) {
            return true;
        }
        return false;
    };
    Window_RecList2.prototype.refresh = function () {
        this._windowContentsSprite.removeChildren();
        this.makeData();
        _super.prototype.refresh.call(this);
    };
    Window_RecList2.prototype.maxItems = function () {
        return this._data.length;
    };
    Window_RecList2.prototype.itemHeight = function () {
        return 238;
    };
    Window_RecList2.prototype.maxCols = function () {
        return 4;
    };
    Window_RecList2.prototype.setActorId = function (actorId) {
        if (this._actorId == actorId) {
            return;
        }
        this._actorId = actorId;
        this.refresh();
        if (this.index() >= this.maxItems()) {
            this.scrollTo(0, 0);
            this.select(0);
        }
    };
    Window_RecList2.prototype.colSpacing = function () {
        return 0;
    };
    Window_RecList2.prototype.maxPageRows = function () {
        var pageHeight = this.height; // - this.padding * 2;
        return Math.floor(pageHeight / this.itemHeight());
    };
    Window_RecList2.prototype.itemRect = function (index) {
        var maxCols = this.maxCols();
        var itemWidth = this.itemWidth();
        var itemHeight = this.itemHeight();
        var colSpacing = this.colSpacing();
        var rowSpacing = this.rowSpacing();
        var col = index % maxCols;
        var row = Math.floor(index / maxCols);
        var x = col * itemWidth + colSpacing / 2 - this.scrollBaseX();
        var y = row * itemHeight + rowSpacing / 2 - this.scrollBaseY();
        var width = itemWidth - colSpacing + 2;
        var height = itemHeight - rowSpacing;
        return new Rectangle(x, y, width, height);
    };
    Window_RecList2.prototype.drawItem = function (index) {
        var reco = this._data[index];
        var rect = this.itemRect(index);
        var text_height = 0;
        this.contents.fontSize = 20;
        if (this.isVisible(reco)) {
            this.changeTextColor(ColorManager.normalColor());
            var title = reco.title;
            if (ConfigManager.language == 'en' && reco.titleEn) {
                title = reco.titleEn;
            }
            this.contents.fontSize = 17;
            this.contents.drawText(title, rect.x + 4, rect.y + this.itemHeight() - 48, this.itemWidth(), 32, 'center');
        }
        else {
            this.contents.fontSize = 18;
            //this.contents.drawText('未閲覧', rect.x + 4, rect.y + 4, this.itemWidth(), 32, 'center');
            this.changeTextColor(ColorManager.textColor(7));
        }
        if (reco.hint) {
            this.contents.fontSize = 14;
            var hint = reco.hint;
            var yy = 5;
            var hints = hint.split('\n');
            if (!this.isSwOk(reco)) {
                this.contents.textColor = ColorManager.disableColor();
            }
            if (hints.length > 1) {
                this.contents.drawText(hints[0], rect.x + 4, rect.y + this.itemHeight() - 62 + yy, this.itemWidth(), 32, 'center');
                this.contents.drawText(hints[1], rect.x + 4, rect.y + this.itemHeight() - 38 + yy, this.itemWidth(), 32, 'center');
            }
            else {
                this.contents.drawText(hint, rect.x + 4, rect.y + this.itemHeight() - 36 + yy, this.itemWidth(), 32, 'center');
            }
        }
        text_height = 32;
        // CGセットのスイッチ番号が、全てのセーブデータを走査した後にTrueであればピクチャ表示
        if (this.isVisible(reco)) {
            this.drawRecollection(reco.thumbnail, 0, 0, 300, 188, rect.x - 10, rect.y - 5 + text_height);
        }
        else {
            this.drawRecollection('never_watch_picture', 0, 0, 300, 188, rect.x - 10, rect.y - 5 + text_height);
        }
    };
    Window_RecList2.prototype.drawRecollection = function (bmpName, x, y, width, height, dx, dy) {
        var bitmap = ImageManager.loadEro(bmpName);
        if (!bitmap.isReady()) {
            return;
        }
        this.contents.blt(bitmap, x, y, bitmap.width, bitmap.height, dx + 18, dy - 20, width, height);
    };
    Window_RecList2.prototype.get_global_variables = function () {
        this._global_variables = {
            "switches": {}
        };
        var info = DataManager._globalInfo;
        //p(info)
        info[99] = info[99] || {};
        var rec_cg_max = recollectionList.length;
        for (var j = 0; j < rec_cg_max; j++) {
            var cg = recollectionList[j];
            if (info[99][cg.switchId]) {
                this._global_variables["switches"][cg.switchId] = true;
            }
        }
    };
    Window_RecList2.prototype.isShowAll = function () {
        //return false;
        if (Nore.isTaikenban()) {
            return false;
        }
        return ConfigManager.openRecollection;
    };
    Window_RecList2.prototype.selectedInfo = function () {
        return this._data[this.index()];
    };
    Window_RecList2.prototype.select = function (index) {
        _super.prototype.select.call(this, index);
    };
    return Window_RecList2;
}(Window_Selectable));
