var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 *
 * @command show
 * @text 右の立ち絵を表示する
 *
 * @command hide
 * @text 右の立ち絵を消す
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_RightTachie';
    PluginManager.registerCommand(pluginName, 'show', function (args) {
        $gameSwitches.setValue(2, true);
    });
    PluginManager.registerCommand(pluginName, 'hide', function (args) {
        $gameSwitches.setValue(2, false);
    });
})(Nore || (Nore = {}));
var Sprite_RightTachie = /** @class */ (function (_super) {
    __extends(Sprite_RightTachie, _super);
    function Sprite_RightTachie() {
        var _this = _super.call(this) || this;
        _this._offsetX = 130;
        _this.x = Graphics.width - RIGHT_WIDTH + _this._offsetX;
        _this.y = 400;
        _this.createLayers();
        _this.createSikyu();
        _this.drawTachieImage(true);
        _this.createButton();
        _this.updateButtonVisible();
        return _this;
    }
    Sprite_RightTachie.prototype.createLayers = function () {
        this._actorLayer = new Sprite();
        this.addChild(this._actorLayer);
        this._sikyuLayer = new Sprite();
        this.addChild(this._sikyuLayer);
    };
    Sprite_RightTachie.prototype.refresh = function () {
        this._sikyuSprite.refresh();
    };
    Sprite_RightTachie.prototype.createSikyu = function () {
        this._sikyuSprite = new Sprite_SikyuTachie();
        this._sikyuLayer.addChild(this._sikyuSprite);
        this._sikyuSprite.x = -this._offsetX;
        this._sikyuSprite.y = 650 - 400;
    };
    Sprite_RightTachie.prototype.createButton = function () {
        $gameTemp.baisyunStatusButton = false;
        this._statusButton = new Sprite_OverableButton("av", true);
        this._statusButton.x = -100;
        this._statusButton.y = 200;
        this._sikyuLayer.addChild(this._statusButton);
        this._statusButton.setClickHandler(this.onStatus.bind(this));
    };
    Sprite_RightTachie.prototype.onStatus = function () {
        SoundManager.playOk();
        $gameParty.setMenuActorId($gameSystem.baisyunActorId());
        $gameTemp.baisyunStatusButton = true;
        SceneManager.push(Nore.Scene_EroStatus);
    };
    Sprite_RightTachie.prototype.actor = function () {
        return $gameActors.actor($gameSystem.baisyunActorId());
    };
    Sprite_RightTachie.prototype.drawTachieImage = function (isInitial) {
        var baisyun = $gameSystem.baisyun();
        if (!baisyun) {
            return;
        }
        var x = -80 - this._offsetX + this.actorOffsetX($gameSystem.baisyunActorId());
        var a = this.actor();
        var y = 0 - 430 + this.poseOffsetY(a.actorId(), a.poseId);
        this._actorLayer.removeChildren();
        var actor = JsonEx.makeDeepCopy(a);
        if ($gameParty.inBattle()) {
            this.drawBattleTachie(x, y, actor, baisyun);
        }
        else {
            this.drawNormalTachie(isInitial, x, y, actor, baisyun);
        }
        a.clearCacheChanged();
    };
    Sprite_RightTachie.prototype.drawBattleTachie = function (x, y, actor, baisyun) {
        actor.setHoppeId(baisyun.hoppeId());
        this._lastFaceId = baisyun.faceId();
        if (actor.actorId() == 3) {
            if (baisyun.isBokki()) {
                actor.addAcce(1012);
            }
            else {
                actor.addAcce(1011);
            }
            if (baisyun.isSyasei()) {
                actor.addAcce(1013);
            }
            if (baisyun.isAfterSyasei()) {
                actor.addAcce(1014);
            }
        }
        this.drawTachieActor(actor, this._actorLayer, x, y, null, this._lastFaceId, 1, baisyun.hoppeId());
    };
    Sprite_RightTachie.prototype.drawNormalTachie = function (isInitial, x, y, actor, baisyun) {
        var a = this.actor();
        if (isInitial) {
            a.setFaceId(a.getDefaultFaceId());
            this._lastFaceId = a.faceId;
            this.drawTachieActor(actor, this._actorLayer, x, y, null, this._lastFaceId, 1, actor.getAcceHoppeId());
        }
        else {
            this._lastFaceId = a.faceId;
            this.drawTachieActor(actor, this._actorLayer, x, y, null, this._lastFaceId, 1, actor.hoppeId);
        }
    };
    Sprite_RightTachie.prototype.actorOffsetX = function (actorId) {
        switch (actorId) {
            case 1: return -50;
        }
        return 0;
    };
    Sprite_RightTachie.prototype.poseOffsetY = function (actorId, poseId) {
        switch (actorId) {
            case 2: return this.poseOffsetY2(poseId) + 10;
        }
        return 0;
    };
    Sprite_RightTachie.prototype.poseOffsetY2 = function (poseId) {
        switch (poseId) {
            case 2: return 50;
        }
        return 0;
    };
    Sprite_RightTachie.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateButtonVisible();
        this.updateVisible();
        if (this.isChanged()) {
            this.drawTachieImage(false);
        }
    };
    Sprite_RightTachie.prototype.isChanged = function () {
        var baisyun = $gameSystem.baisyun();
        if (baisyun) {
            if ($gameParty.inBattle()) {
                if (baisyun.isDirtyTachie()) {
                    baisyun.clearDirtyTachie();
                    return true;
                }
                if (this._lastFaceId != baisyun.faceId()) {
                    return true;
                }
            }
            else {
                var a = this.actor();
                if (a.faceId != this._lastFaceId) {
                    return true;
                }
            }
        }
        if (this.actor().isCacheChanged()) {
            return true;
        }
        return false;
    };
    Sprite_RightTachie.prototype.updateVisible = function () {
        if ($gameSwitches.value(26)) {
            this.updateVisibleInEroEvent();
        }
        else {
            this._actorLayer.visible = true;
            this.visible = $gameSystem.isShowRightTachie();
        }
    };
    Sprite_RightTachie.prototype.updateVisibleInEroEvent = function () {
        this._statusButton.visible = false;
        if ($gameSwitches.value(27)) {
            this.visible = true;
            this._actorLayer.visible = true;
        }
        else {
            if ($gameSwitches.value(29)) {
                this.visible = true;
                this._actorLayer.visible = false;
                this._sikyuSprite.visible = true;
            }
            else {
                this.visible = false;
                this._actorLayer.visible = true;
            }
        }
    };
    Sprite_RightTachie.prototype.updateButtonVisible = function () {
        this._statusButton.visible = true;
        if (!$gameParty.inBaisyun()) {
            this._statusButton.visible = false;
            return;
        }
        if (!$gameSwitches.value(368)) {
            // ステータス画面の説明終わってない
            this._statusButton.visible = false;
            return;
        }
        if ($gameMap.isAnyEventStarting()) {
            this._statusButton.visible = false;
            return;
        }
        if (SceneManager._scene instanceof Scene_Map2) {
            if ($gameMap._interpreter.isRunning()) {
                this._statusButton.visible = false;
            }
        }
        else {
            this._statusButton.visible = false;
        }
    };
    return Sprite_RightTachie;
}(Sprite));
