var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Nore;
(function (Nore) {
    var Window_SavefileList2 = /** @class */ (function (_super) {
        __extends(Window_SavefileList2, _super);
        function Window_SavefileList2() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._latestList = [];
            return _this;
        }
        Window_SavefileList2.prototype.setMode = function (mode, autosave) {
            this.makeLatestFileList();
            _super.prototype.setMode.call(this, mode, autosave);
        };
        Window_SavefileList2.prototype.makeLatestFileList = function () {
            this._latestList = [];
            var globalInfo = DataManager._globalInfo;
            if (!globalInfo) {
                return;
            }
            for (var i = 1; i < 100; i++) {
                var saveInfo = globalInfo[i];
                if (saveInfo) {
                    this._latestList.push(saveInfo);
                }
            }
            this._latestList = this._latestList.sort(function (a, b) {
                return b.timestamp - a.timestamp;
            });
            //p(this._latestList)
        };
        Window_SavefileList2.prototype.maxCols = function () {
            return 4;
        };
        Window_SavefileList2.prototype.drawItem = function (index) {
            var savefileId = this.indexToSavefileId(index);
            var info = DataManager.savefileInfo(savefileId);
            var rect = this.itemRectWithPadding(index);
            this.resetTextColor();
            this.changePaintOpacity(this.isEnabled(savefileId));
            this.contents.fontSize = 20;
            var yy = rect.y;
            this.drawTitle(savefileId, rect.x, yy);
            this.changeTextColor(ColorManager.normalColor());
            if (info) {
                var lineHeight = this.lineHeight();
                this.drawNew(info, rect.x + 80, yy);
                var marginY = 5;
                this.drawStage(info, rect.x + 232, yy);
                this.drawDay(info, rect.x + 2, yy + lineHeight + marginY);
                this.drawCurrentAction(info, rect.x + 120, yy + lineHeight + marginY);
                this.contents.fontSize = 18;
                this.drawDifficulty(info, rect.x + 4 + 104, yy + lineHeight * 2 + 8);
                //this.drawGold(info, rect.x + 4 + 104, yy + lineHeight * 2 + 8);
                this.drawTime(info, rect.x + 102, yy + lineHeight * 3 + 8);
                //this.drawContents(info, rect);
                this.drawPlaytime(info, rect.x + 4, yy + lineHeight * 2 + 8, rect.width);
                this.drawStar(info, rect.x, yy + lineHeight * 2 + 12, rect.width);
            }
        };
        Window_SavefileList2.prototype.paint = function () {
            this._windowContentsSprite.removeChildren();
            _super.prototype.paint.call(this);
        };
        Window_SavefileList2.prototype.lineHeight = function () {
            return 28;
        };
        Window_SavefileList2.prototype.indexToSavefileId = function (index) {
            return index;
        };
        Window_SavefileList2.prototype.drawContents = function (info, rect) {
            var bottom = rect.y + rect.height;
            this.drawPartyCharacters(info, rect.x + 20, bottom - 8);
            var lineHeight = this.lineHeight();
            var y2 = bottom - lineHeight - 4;
            if (y2 >= lineHeight) {
            }
        };
        Window_SavefileList2.prototype.drawPartyCharacters = function (info, x, y) {
            /*if (info.fileList) {
                let characterX = x + 5;
                for (const data of info.fileList) {
                    //let pp = new Sprite_Player($gamePlayer)
                    this.drawCharacter(data, 0, characterX, y);
                }
            }*/
        };
        Window_SavefileList2.prototype.drawTitle = function (savefileId, x, y) {
            this.changeTextColor(ColorManager.systemColor());
            if (savefileId === 0) {
                this.drawText(TextManager._autosave, x, y, 180);
            }
            else {
                this.drawText(TextManager._file, x, y, 180);
                this.changeTextColor(ColorManager.crisisColor());
                this.drawText(savefileId, x, y, ConfigManager.language == 'jp' ? 112 : 70, 'right');
            }
        };
        Window_SavefileList2.prototype.drawNew = function (info, x, y) {
            if (ConfigManager.language != 'jp') {
                x -= 40;
            }
            var index = this._latestList.indexOf(info);
            if (index < 0) {
                return;
            }
            if (index > 4) {
                return;
            }
            this.changeTextColor(ColorManager.textColor(17));
            this.drawText(TextManager.saveLatest.format(index + 1), x, y, 130, 'right');
            this.changeTextColor(ColorManager.textColor(0));
        };
        Window_SavefileList2.prototype.drawCurrentAction = function (info, x, y) {
            this.changeTextColor(ColorManager.systemColor());
            var w = 170;
            if (ConfigManager.isEn()) {
                x += 50;
                w -= 50;
            }
            if (info.baisyunActorId > 0) {
                var actor = $gameActors.actor(info.baisyunActorId);
                this.drawText(TextManager.saveBaisyun.format(actor.name()), x, y, w, 'right');
            }
            else {
                var mapName = this.getMapName(info.mapId);
                this.drawText(mapName, x, y, w, 'right');
            }
        };
        Window_SavefileList2.prototype.getMapName = function (mapId) {
            switch (mapId) {
                case 75:
                case 137:
                    return TextManager.babyRoom;
                case 18:
                case 8:
                case 9:
                case 21:
                case 23:
                case 27:
                case 28:
                case 30:
                case 31:
                case 94:
                case 95:
                case 96:
                    return TextManager.goblinDwellings;
                case 34:
                case 35:
                case 35:
                case 36:
                case 37:
                case 38:
                case 39:
                case 56:
                case 101:
                    return TextManager.chinpoko;
                case 40:
                case 41:
                case 42:
                case 43:
                case 44:
                case 45:
                case 12:
                case 49:
                case 50:
                case 58:
                    return TextManager.volcano;
                case 53:
                case 54:
                case 59:
                case 60:
                case 61:
                case 62:
                case 63:
                case 107:
                case 123:
                case 127:
                case 128:
                case 129:
                    return TextManager.murasame;
                case 23:
                case 65:
                case 66:
                case 68:
                case 69:
                case 67:
                case 71:
                case 72:
                case 73:
                case 118:
                    return TextManager.grave;
                case 13:
                case 78:
                case 86:
                    return TextManager.atelier;
            }
            return '';
        };
        Window_SavefileList2.prototype.drawStage = function (info, x, y) {
            if (ConfigManager.language != 'jp') {
                x -= 40;
            }
            var stageStr = ConfigManager.language == 'jp' ? hankaku2Zenkaku(info.stage) : info.stage;
            var stage = TextManager.chapter.format(stageStr);
            if (info.stage == 0) {
                stage = TextManager.prologue;
            }
            this.changeTextColor(ColorManager.textColor(14));
            this.drawText(stage, x, y, 200, 'left');
            this.changeTextColor(ColorManager.normalColor());
        };
        Window_SavefileList2.prototype.drawDay = function (info, x, y) {
            if (info.days == 0) {
                this.drawText(TextManager.prologue, x + 0, y, 124, 'right');
                return;
            }
            this.drawText(TextManager.saveDay.format(info.days), x + 0, y, 64, 'right');
            this.drawTimeIcon(info.night, x + 79, y - 2);
        };
        Window_SavefileList2.prototype.drawTimeIcon = function (night, x, y) {
            var image = this.timeImage(night);
            this.contents.blt(image, 0, 0, image.width, image.height, x, y, image.width - 20, image.height - 20);
        };
        Window_SavefileList2.prototype.timeImage = function (night) {
            if (night) {
                return ImageManager.loadSystem('weather04_02');
            }
            else {
                return ImageManager.loadSystem('weather01_03');
            }
        };
        Window_SavefileList2.prototype.drawDifficulty = function (info, x, y) {
            this.changeTextColor(ColorManager.normalColor());
            var text = 'Normal';
            if (info.difficulty == Difficulty.EASY) {
                text = 'Easy';
            }
            if (info.difficulty == Difficulty.STORY) {
                text = 'Story';
            }
            this.drawText(text, x + 0, y, 98, 'right');
        };
        Window_SavefileList2.prototype.drawGold = function (info, x, y) {
            this.changeTextColor(ColorManager.normalColor());
            this.drawIcon(Icon.gold, x, y);
            this.drawText(info.gold + 'Ｇ', x + 0, y, 98, 'right');
        };
        Window_SavefileList2.prototype.drawStar = function (info, x, y) {
            var actorIds = [2, 1, 3];
            if (info.stage == 0) {
                actorIds = [2, 3];
            }
            this.changeTextColor(ColorManager.normalColor());
            this.contents.fontSize = 16;
            this.drawText('★', x - 4, y + 32, 38, 'left');
            var xx = x + 7;
            this.changeTextColor(ColorManager.normalColor());
            for (var _i = 0, actorIds_1 = actorIds; _i < actorIds_1.length; _i++) {
                var id = actorIds_1[_i];
                var icon = $gameActors.actor(id).iconIndex();
                this.drawIcon(icon, xx, y);
                this.drawActorStar(info['actorStar' + id], xx, y + 32);
                xx += 34;
            }
        };
        Window_SavefileList2.prototype.drawActorStar = function (star, x, y) {
            if (star === undefined) {
                return;
            }
            this.contents.fontSize = 16;
            this.drawText(star, x - 2, y, 38, 'center');
        };
        Window_SavefileList2.prototype.drawTime = function (info, x, y) {
            this.changeTextColor(ColorManager.normalColor());
            //this.drawText('LV ' + info.level, x - 70, y, 190, 'right');
            var time = new Date(info.timestamp);
            var mm = (time.getMonth() + 1).padZero(2);
            var d = time.getDate().padZero(2);
            var h = time.getHours().padZero(2);
            var m = time.getMinutes().padZero(2);
            var s = time.getSeconds().padZero(2);
            var str = '%1/%2/%3 %4:%5:%6'.format(time.getFullYear(), mm, d, h, m, s);
            this.drawText(str, x - 152, y, 340, 'right');
        };
        Window_SavefileList2.prototype.drawSp = function (info, x, y) {
            if (info.skillPoint) {
                var text = TextManager.spSave.format(info.skillPoint);
                this.drawText(text, x, y, 180, 'left');
            }
        };
        Window_SavefileList2.prototype.selectSavefile = function (savefileId) {
            var index = Math.max(0, this.savefileIdToIndex(savefileId));
            this.select(index);
            this.setTopRow(Math.floor(index / 4) - 2);
        };
        Window_SavefileList2.prototype.savefileIdToIndex = function (savefileId) {
            return savefileId;
        };
        ;
        return Window_SavefileList2;
    }(Window_SavefileList));
    Nore.Window_SavefileList2 = Window_SavefileList2;
    DataManager.maxSavefiles = function () {
        return 96;
    };
    Scene_File.prototype.createListWindow = function () {
        var rect = this.listWindowRect();
        this._listWindow = new Window_SavefileList2(rect);
        this._listWindow.setHandler("ok", this.onSavefileOk.bind(this));
        this._listWindow.setHandler("cancel", this.onCancel.bind(this));
        //this._listWindow.setHandler("change", this.onChange.bind(this));
        this._listWindow.setMode(this.mode(), this.needsAutosave());
        this._listWindow.selectSavefile(this.firstSavefileId());
        //this._listWindow.refresh();
        this.addWindow(this._listWindow);
    };
    Scene_File.prototype.onCancel = function () {
        this.popScene();
    };
    Scene_File.prototype.buttonY = function () {
        return 0;
    };
    var _DataManager_makeSavefileInfo = DataManager.makeSavefileInfo;
    DataManager.makeSavefileInfo = function () {
        var info = _DataManager_makeSavefileInfo.call(this);
        info.stage = $gameSystem.stage();
        info.gold = $gameParty.gold();
        info.days = $gameSystem.day();
        info.morning = $gameSystem.isMorning();
        info.night = $gameSystem.isNight();
        info.difficulty = $gameSystem.difficulty();
        info.mapId = $gameMap.mapId();
        info.baisyunActorId = 0;
        for (var i = 1; i <= 3; i++) {
            info['actorStar' + i] = $gameActors.actor(i).baisyunHistory().calcFame();
        }
        if ($gameParty.inBaisyun()) {
            info.baisyunActorId = $gameSystem.baisyunActorId();
        }
        return info;
    };
    DataManager.removeInvalidGlobalInfo = function () {
        var globalInfo = this._globalInfo;
        for (var _i = 0, globalInfo_1 = globalInfo; _i < globalInfo_1.length; _i++) {
            var info = globalInfo_1[_i];
            var savefileId = globalInfo.indexOf(info);
            if (savefileId >= 90) {
                return;
            }
            if (!this.savefileExists(savefileId)) {
                delete globalInfo[savefileId];
            }
        }
    };
    DataManager.isAnySavefileExists = function () {
        for (var i = 0; i < 99; i++) {
            if (this._globalInfo[i]) {
                return true;
            }
        }
        return false;
    };
    DataManager.latestSavefileId = function () {
        var globalInfo = this._globalInfo;
        var validInfo = globalInfo.slice(1).filter(function (x) { return x; });
        var list = [];
        for (var _i = 0, validInfo_1 = validInfo; _i < validInfo_1.length; _i++) {
            var x = validInfo_1[_i];
            if (isNaN(x.timestamp)) {
                continue;
            }
            list.push(x);
        }
        var latest = Math.max.apply(Math, list.map(function (x) { return x.timestamp; }));
        var index = globalInfo.findIndex(function (x) { return x && x.timestamp === latest; });
        return index > 0 ? index : 0;
    };
    Scene_Save.prototype.helpWindowText = function () {
        return TextManager._saveMessage;
    };
    Scene_Load.prototype.helpWindowText = function () {
        return TextManager._loadMessage;
    };
})(Nore || (Nore = {}));
DataManager.loadSavefileImages = function (info) {
    /*
    if (info.characters && Symbol.iterator in info.characters) {
        for (const character of info.characters) {
            ImageManager.loadCharacter(character[0]);
        }
    }
    if (info.faces && Symbol.iterator in info.faces) {
        for (const face of info.faces) {
            ImageManager.loadFace(face[0]);
        }
    }
    */
};
