/*:ja
 * @target MZ
 * @author ル
 *
 * @command sikyuToSeieki
 * @text 子宮クリア
 *
 *
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Seieki';
    PluginManager.registerCommand(pluginName, 'sikyuToSeieki', function (args) {
        var actorIdList = $gameParty.getActorIdList();
        for (var _i = 0, actorIdList_1 = actorIdList; _i < actorIdList_1.length; _i++) {
            var actorId = actorIdList_1[_i];
            var actor = $gameActors.actor(actorId);
            if (actor.sikyu().isEmpty()) {
                continue;
            }
            actor.sikyu().clear();
        }
    });
})(Nore || (Nore = {}));
var SeiekiType;
(function (SeiekiType) {
    SeiekiType["baisyun"] = "baisyun";
    SeiekiType["dousei"] = "dousei";
    SeiekiType["event"] = "event";
    SeiekiType["syusan"] = "syusan";
})(SeiekiType || (SeiekiType = {}));
var Seieki = /** @class */ (function () {
    function Seieki(manId, condom, sotodashi, count) {
        if (count === void 0) { count = 0; }
        this._manId = manId;
        this._count = count;
        this._condom = condom;
        this._sotodashi = sotodashi;
        if (sotodashi) {
            this._condom = false;
        }
        this.decideValue();
    }
    Seieki.prototype.manId = function () {
        return this._manId;
    };
    Seieki.prototype.itemId = function () {
        var man = $baisyunManParamManager.findManParamByManId(this._manId);
        return man.seiekiId();
    };
    Seieki.prototype.count = function () {
        return this._count;
    };
    Seieki.prototype.item = function () {
        return $dataItems[this.itemId()];
    };
    Seieki.prototype.isCondom = function () {
        return this._condom;
    };
    Seieki.prototype.isSotodashi = function () {
        return this._sotodashi;
    };
    Seieki.prototype.isNakadashi = function () {
        return !this.isCondom() && !this.isSotodashi();
    };
    Seieki.prototype.value = function () {
        return this._value;
    };
    Seieki.prototype.decideValue = function () {
        if (this._count == 0) {
            this._value = 0;
            return;
        }
        var random = Math.randomInt(3);
        this._value = this.calcValueBySexCount() + random;
    };
    Seieki.prototype.calcValueBySexCount = function () {
        var value = this.seiekiValue();
        switch (this._count) {
            case 0:
                console.error('不正な回数です');
                return 0;
            case 1: return value;
            case 2: return Math.round(value * 1.5);
            case 3: return Math.round(value * 2);
            case 4: return Math.round(value * 2.3);
            default:
                return Math.round(value * 2.3) + Math.round(value * 0.3 * (this._count - 4));
        }
    };
    Seieki.prototype.seiekiValue = function () {
        var man = $baisyunManParamManager.findManParamByManId(this._manId);
        if (!man) {
            return 10;
        }
        return man.seiekiValue();
    };
    Seieki.prototype.nakadashiCount = function () {
        if (!this.isNakadashi()) {
            return 0;
        }
        return this._count;
    };
    Seieki.prototype.nakadashiValue = function () {
        if (!this.isNakadashi()) {
            return 0;
        }
        return this._value;
    };
    Seieki.prototype.notNakadashiValue = function () {
        if (this.isNakadashi()) {
            return 0;
        }
        return this._value;
    };
    return Seieki;
}());
var Window_SeiekiChange = /** @class */ (function (_super) {
    __extends(Window_SeiekiChange, _super);
    function Window_SeiekiChange() {
        var _this = this;
        var r = new Rectangle(800, 160, 300, 130);
        _this = _super.call(this, r) || this;
        _this.refresh();
        return _this;
    }
    Window_SeiekiChange.prototype.refresh = function () {
        this.contents.clear();
        var get = 0;
        for (var _i = 0, _a = $gameTemp.seiekiList; _i < _a.length; _i++) {
            var s = _a[_i];
            get += s.value();
        }
        var yy = 55;
        this.drawText('本日の獲得結果', 0, 0, 300, 'center');
        var before = $gameParty.materialList()[4];
        this.drawIcon(490, 10, yy);
        this.drawText(before + get, 10, yy, 100, 'right');
        this.drawText('(+ ' + get + ')', 110, yy, 100, 'right');
    };
    return Window_SeiekiChange;
}(Window_Base));
var Window_BaisyunGoldResult = /** @class */ (function (_super) {
    __extends(Window_BaisyunGoldResult, _super);
    function Window_BaisyunGoldResult() {
        var _this = this;
        var r = new Rectangle(800, 300, 300, 130);
        _this = _super.call(this, r) || this;
        _this.refresh();
        return _this;
    }
    Window_BaisyunGoldResult.prototype.refresh = function () {
        this.contents.clear();
        var yy = 55;
        this.drawText('本日の売春結果', 0, 0, 300, 'center');
        var total = this.totalGold();
        if (total == 0) {
            this.hide();
            return;
        }
        var before = $gameParty.gold() - total;
        this.drawIcon(Icon.gold, 10, yy);
        this.drawText($gameParty.gold(), 10, yy, 100, 'right');
        //this.drawText('→', 110, yy, 100, 'left');
        this.drawText('(+ ' + total + ')', 110, yy, 100, 'right');
    };
    Window_BaisyunGoldResult.prototype.totalGold = function () {
        var n = 0;
        for (var _i = 0, _a = $gameParty.baisyunGoldList(); _i < _a.length; _i++) {
            var g = _a[_i];
            n += g;
        }
        return n;
    };
    return Window_BaisyunGoldResult;
}(Window_Base));
var Window_SeiekiResult = /** @class */ (function (_super) {
    __extends(Window_SeiekiResult, _super);
    function Window_SeiekiResult() {
        var _this = this;
        var list = $gameTemp.seiekiList || [];
        var r = new Rectangle(250, 160, 540, 12 * 2 + Math.max(list.length, 3) * 120);
        _this = _super.call(this, r) || this;
        _this._list = list.sort(function (a, b) {
            return a.sortValue() - b.sortValue();
        });
        _this.refresh();
        return _this;
    }
    Window_SeiekiResult.prototype.maxItems = function () {
        if (!this._list) {
            return 0;
        }
        return this._list.length;
    };
    Window_SeiekiResult.prototype.itemHeight = function () {
        return 120;
    };
    Window_SeiekiResult.prototype.drawItem = function (index) {
        var set = this._list[index];
        var r = this.itemRect(index);
        this.contents.fontSize = 14;
        var actor = $gameActors.actor(set.actorId());
        var typeName = set.typeName();
        this.drawText(actor.name() + ' ' + typeName, r.x, r.y - 10, r.width, 'left');
        this.contents.fontSize = 22;
        var yy = 20;
        for (var _i = 0, _a = set.seiekiList(); _i < _a.length; _i++) {
            var s = _a[_i];
            var item = $dataItems[s.itemId()];
            var yyy = r.y + yy;
            this.drawItemName(item, r.x, yyy, r.width);
            this.drawText(s.count() + '発', r.x, yyy, r.width - 120, 'right');
            this.drawText('+' + s.value(), r.x, yyy, r.width - 50, 'right');
            this.drawIcon(490, r.width - 40, yyy);
            yy += 32;
        }
    };
    return Window_SeiekiResult;
}(Window_Selectable));
var SeiekiSet = /** @class */ (function () {
    function SeiekiSet(type, actorId, seiekiList) {
        this._type = type;
        this._actorId = actorId;
        this._seiekiList = seiekiList;
    }
    SeiekiSet.prototype.actorId = function () {
        return this._actorId;
    };
    SeiekiSet.prototype.seiekiList = function () {
        return this._seiekiList;
    };
    SeiekiSet.prototype.value = function () {
        var n = 0;
        for (var _i = 0, _a = this._seiekiList; _i < _a.length; _i++) {
            var s = _a[_i];
            n += s.value();
        }
        return n;
    };
    SeiekiSet.prototype.sortValue = function () {
        if (this._type == SeiekiType.baisyun) {
            return 0;
        }
        return this._actorId;
    };
    SeiekiSet.prototype.typeName = function () {
        switch (this._type) {
            case SeiekiType.baisyun:
                return TextManager.seiekiBaisyun;
            case SeiekiType.dousei:
                return TextManager.seiekiDousei;
            case SeiekiType.event:
                return TextManager.seiekiEvent;
            case SeiekiType.syusan:
                return TextManager.seiekiSyusan;
            default:
                console.error('不正な精液タイプです:' + this._type);
                return '';
        }
    };
    SeiekiSet.prototype.clear = function () {
        this._seiekiList = [];
    };
    SeiekiSet.prototype.addSeieki = function (seieki) {
        this._seiekiList.push(seieki);
    };
    return SeiekiSet;
}());
var DaySeieki = /** @class */ (function () {
    function DaySeieki() {
        this._seiekiSetList = [];
    }
    DaySeieki.prototype.addSeiekiList = function (type, actorId, list) {
        if (list.length == 0) {
            return;
        }
        var set = new SeiekiSet(type, actorId, list);
        this._seiekiSetList.push(set);
    };
    DaySeieki.prototype.isEmpty = function () {
        return this._seiekiSetList.length == 0;
    };
    DaySeieki.prototype.seiekiSetList = function () {
        return this._seiekiSetList;
    };
    return DaySeieki;
}());
