/*:ja
 * @target MZ
 * @author ル
 *
 * @command nextDay
 * @text 次の日へ
 * @des 次の日へ
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Shop';
    PluginManager.registerCommand(pluginName, 'nextDay', function (args) {
        $gameSystem.shopStock().onNextDay();
    });
    function shopPrice(itemId) {
        var param = DUNGEON_ITEM_MAP[itemId];
        if (!param) {
            return $dataItems[itemId].price;
        }
        if (param[1] == 'shop') {
            return calcShopItemPrice(param[2]);
        }
        if (param[1] == 'event') {
            return -1;
        }
        if (param[1] == 'alchemy') {
            return -1;
        }
        return calcDungeonItemPrice(param);
    }
    Nore.shopPrice = shopPrice;
    function sellingPrice(item) {
        if (DataManager.isItem(item)) {
            return Math.floor(shopPrice(item.id) / 2);
        }
        if (isCantCellItem(item)) {
            return -1;
        }
        var isWeapon = DataManager.isWeapon(item);
        var recipeId = findRecipeId(item.id, isWeapon);
        if (recipeId < 0) {
            console.error(item);
            console.error(item.id + ' のレシピが見つかりません');
            return -1;
        }
        var rank = RECIPE_MAP[recipeId][0];
        return sellingPriceByRank(rank);
    }
    Nore.sellingPrice = sellingPrice;
    function isCantCellItem(item) {
        if (DataManager.isArmor(item)) {
            switch (item.id) {
                case 201: // おまもり
                case 202: // おまもり
                    return true;
            }
        }
        return false;
    }
    function sellingPriceByRank(rank) {
        switch (rank) {
            case 0: return 10;
            case 1: return 20;
            case 2: return 30;
            case 3: return 50;
            case 4: return 60;
            case 5: return 70;
            case 6: return 80;
            case 7: return 90;
            case 8: return 100;
            case 9: return 120;
            case 10: return 140;
        }
        return -1;
    }
    function findRecipeId(itemId, isWeapon) {
        var recipeItemId = itemId + (isWeapon ? 1000 : 2000);
        for (var key in RECIPE_MAP) {
            var array = RECIPE_MAP[key];
            if (array[5] == recipeItemId) {
                return parseInt(key);
            }
        }
        return -1;
    }
    Nore.findRecipeId = findRecipeId;
    function calcShopItemPrice(dungeonId) {
        switch (dungeonId) {
            case 1: return 50;
            case 2: return 70;
            case 3: return 85;
            case 4: return 100;
            case 5: return 120;
        }
        console.error('不正なダンジョンIDです:' + dungeonId);
    }
    function calcDungeonItemPrice(param) {
        var dungeonId = param[2];
        switch (dungeonId) {
            case 0: return -1;
            case 1: return 35;
            case 2: return 50;
            case 3: return 65;
            case 4: return 80;
            case 5: return 90;
        }
        console.error('不正なダンジョンIDです:' + dungeonId + ' ' + param[0]);
    }
    function isShopOnlyItemId(itemId) {
        var name = $dataItems[itemId].name;
        return isShopOnly(name);
    }
    Nore.isShopOnlyItemId = isShopOnlyItemId;
    function isShopOnly(name) {
        for (var key in DUNGEON_ITEM_MAP) {
            var param = DUNGEON_ITEM_MAP[key];
            if (param[0] == name) {
                return param[1] == 'shop';
            }
        }
        return false;
    }
    Nore.isShopOnly = isShopOnly;
})(Nore || (Nore = {}));
// Shop Processing
Game_Interpreter.prototype.command302 = function (params) {
    if (!$gameParty.inBattle()) {
        var goods = [params];
        while (this.nextEventCode() === 605) {
            this._index++;
            goods.push(this.currentCommand().parameters);
        }
        SceneManager.push(Scene_Shop2);
        SceneManager.prepareNextScene(goods, params[4]);
    }
    return true;
};
var Stock = /** @class */ (function () {
    function Stock(itemId, remain) {
        this._itemId = itemId;
        this._remain = remain;
    }
    Stock.prototype.itemId = function () {
        return this._itemId;
    };
    Stock.prototype.onNextDay = function () {
        if (this._remain > 0) {
            this._remain--;
            /*if (this._remain == 0) {
                $gameSwitches.setValue(NEW_ITEM_SW, true);
            }*/
        }
    };
    Stock.prototype.remain = function () {
        return this._remain;
    };
    Stock.prototype.makeGoods = function () {
        return [0, this._itemId, 1, this.price()];
    };
    Stock.prototype.price = function () {
        return Nore.shopPrice(this._itemId);
    };
    return Stock;
}());
var ShopStock = /** @class */ (function () {
    function ShopStock() {
        this._stockList = [];
        this.initStocks();
    }
    ShopStock.prototype.addStock = function (itemId) {
        for (var _i = 0, _a = this._stockList; _i < _a.length; _i++) {
            var s = _a[_i];
            if (s.itemId() == itemId) {
                return;
            }
        }
        this._stockList.push(new Stock(itemId, this.initialRemain()));
    };
    ShopStock.prototype.initialRemain = function () {
        return 2;
    };
    ShopStock.prototype.onNextDay = function () {
        for (var _i = 0, _a = this._stockList; _i < _a.length; _i++) {
            var s = _a[_i];
            s.onNextDay();
        }
    };
    ShopStock.prototype.initStocks = function () {
        var initials = [113, 114, 115];
        for (var _i = 0, initials_1 = initials; _i < initials_1.length; _i++) {
            var itemId = initials_1[_i];
            this._stockList.push(new Stock(itemId, 0));
        }
    };
    ShopStock.prototype.makeGoods = function () {
        var result = [];
        for (var _i = 0, _a = this.stageStockList(); _i < _a.length; _i++) {
            var s = _a[_i];
            result.push(s.makeGoods());
        }
        for (var _b = 0, _c = this._stockList; _b < _c.length; _b++) {
            var s = _c[_b];
            if (s.remain() == 0) {
                if (s.price() > 0) {
                    result.push(s.makeGoods());
                }
            }
        }
        return result;
    };
    ShopStock.prototype.stageStockList = function () {
        var idList = [];
        var stage = $gameSystem.stage();
        if (stage >= 5) {
            idList.push(193);
            idList.push(194);
            idList.push(195);
        }
        if (stage >= 4) {
            idList.push(173);
            idList.push(174);
            idList.push(175);
        }
        if (stage >= 3) {
            idList.push(153);
            idList.push(154);
            idList.push(155);
        }
        if (stage >= 2) {
            idList.push(133);
            idList.push(134);
            idList.push(135);
        }
        var result = [];
        for (var _i = 0, idList_1 = idList; _i < idList_1.length; _i++) {
            var itemId = idList_1[_i];
            result.push(new Stock(itemId, 0));
        }
        return result;
    };
    return ShopStock;
}());
