var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var NEW_ITEM_SW = 232;
var Scene_Shop2 = /** @class */ (function (_super) {
    __extends(Scene_Shop2, _super);
    function Scene_Shop2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_Shop2.prototype.prepare = function (goods, purchaseOnly) {
        $gameSwitches.setValue(NEW_ITEM_SW, false);
        if (goods.length == 1) {
            this._goods = goods.concat($gameSystem.shopStock().makeGoods());
        }
        else {
            this._goods = goods;
        }
        this._purchaseOnly = purchaseOnly;
        this._item = null;
    };
    Scene_Shop2.prototype.categoryWindowRect = function () {
        var r = _super.prototype.categoryWindowRect.call(this);
        r.width -= 400;
        return r;
    };
    Scene_Shop2.prototype.createHelpWindow = function () {
        var rect = this.helpWindowRect();
        this._helpWindow = new Window_EquipHelp(rect);
        this.addWindow(this._helpWindow);
    };
    Scene_Shop2.prototype.helpWindowRect = function () {
        var wx = 870;
        var wy = this.mainAreaTop() + this.calcWindowHeight(1, true) * 2;
        var ww = 400;
        var wh = 400;
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_Shop2.prototype.createBuyWindow = function () {
        var rect = this.buyWindowRect();
        this._buyWindow = new Window_ShopBuy2(rect);
        this._buyWindow.setupGoods(this._goods);
        this._buyWindow.setHelpWindow(this._helpWindow);
        this._buyWindow.setStatusWindow(this._statusWindow);
        this._buyWindow.hide();
        this._buyWindow.setHandler("ok", this.onBuyOk.bind(this));
        this._buyWindow.setHandler("cancel", this.onBuyCancel.bind(this));
        this.addWindow(this._buyWindow);
    };
    Scene_Shop2.prototype.buyWindowRect = function () {
        var r = _super.prototype.buyWindowRect.call(this);
        r.width -= 50;
        return r;
    };
    Scene_Shop2.prototype.doBuy = function (number) {
        var item = this._item;
        $gameParty.addItemHistory(item.id);
        $gameParty.onGotMaterialItem(item.id);
        _super.prototype.doBuy.call(this, number);
    };
    Scene_Shop2.prototype.createSellWindow = function () {
        var rect = this.sellWindowRect();
        this._sellWindow = new Window_ShopSell2(rect);
        this._sellWindow.setHelpWindow(this._helpWindow);
        this._sellWindow.hide();
        this._sellWindow.setHandler("ok", this.onSellOk.bind(this));
        this._sellWindow.setHandler("cancel", this.onSellCancel.bind(this));
        this._categoryWindow.setItemWindow(this._sellWindow);
        this.addWindow(this._sellWindow);
        if (!this._categoryWindow.needsSelection()) {
            this._sellWindow.y -= this._categoryWindow.height;
            this._sellWindow.height += this._categoryWindow.height;
        }
    };
    Scene_Shop2.prototype.numberWindowRect = function () {
        var wx = 0;
        var wy = this._dummyWindow.y;
        var ww = Graphics.boxWidth - 400;
        var wh = this._dummyWindow.height;
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_Shop2.prototype.sellWindowRect = function () {
        var r = _super.prototype.sellWindowRect.call(this);
        r.width -= 400;
        r.height += 100;
        return r;
    };
    Scene_Shop2.prototype.statusWindowRect = function () {
        var ww = this.statusWidth();
        var wh = this._dummyWindow.height;
        var wx = Graphics.boxWidth - ww;
        var wy = this._dummyWindow.y;
        return new Rectangle(wx, wy + 800, ww, wh);
    };
    Scene_Shop2.prototype.dummyWindowRect = function () {
        var wx = 0;
        var wy = this._commandWindow.y + this._commandWindow.height;
        var ww = Graphics.boxWidth;
        var wh = this.mainAreaHeight() - this._commandWindow.height + 100;
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_Shop2.prototype.sellingPrice = function () {
        return Nore.sellingPrice(this._item);
    };
    return Scene_Shop2;
}(Scene_Shop));
var Window_ShopBuy2 = /** @class */ (function (_super) {
    __extends(Window_ShopBuy2, _super);
    function Window_ShopBuy2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_ShopBuy2.prototype.drawItem = function (index) {
        var item = this.itemAt(index);
        var rect = this.itemLineRect(index);
        this.changePaintOpacity(this.isEnabled(item));
        this.drawNewRecipe(item, rect);
        this.changeTextColor(ColorManager.normalColor());
        this.contents.fontSize = 22;
        var nameWidth = rect.width - 400;
        this.drawItemName(item, rect.x + 130, rect.y, nameWidth);
        this.drawItemRank(item, rect.x + 400, rect.y);
        this.drawItemPartyStock(item, rect);
        this.drawShopOnlyText(item, rect);
        this.drawItemPrice(item, rect);
        this.changePaintOpacity(true);
    };
    Window_ShopBuy2.prototype.drawItemRank = function (item, x, y) {
        var dungeon = parseInt(item.meta['dungeon']);
        if (isNaN(dungeon)) {
            console.error('dungeon が設定されていません:' + item.id);
            return;
        }
        this.changeTextColor(ColorManager.crisisColor());
        this.contents.fontSize = 18;
        this.drawText('RANK', x, y, 410, 'left');
        var interval = 20;
        for (var i = 0; i < dungeon; i++) {
            this.contents.fontSize = 16;
            this.drawText('★', x + 58 + i * interval, y, 410, 'left');
        }
    };
    Window_ShopBuy2.prototype.drawShopOnlyText = function (item, rect) {
        this.contents.fontSize = 14;
        var shopOnly = Nore.isShopOnly(item.name);
        if (!shopOnly) {
            return;
        }
        this.changeTextColor(ColorManager.crisisColor());
        this.drawText('Shop only', rect.x + 166, rect.y - 17, 280, 'left');
    };
    Window_ShopBuy2.prototype.drawNewRecipe = function (item, rect) {
        this.contents.fontSize = 16;
        if (!$gameParty.itemHasNewRecipe(item.id)) {
            return;
        }
        this.changeTextColor(ColorManager.crisisColor());
        this.drawText(TextManager.shopNewRecipe, rect.x, rect.y, 130);
    };
    Window_ShopBuy2.prototype.drawItemPartyStock = function (item, rect) {
        this.changeTextColor(ColorManager.systemColor());
        var n = $gameParty.numItems(item, false);
        this.contents.fontSize = 22;
        this.drawText(TextManager.shopQuantity.format(n), rect.x + 570, rect.y, 130);
    };
    Window_ShopBuy2.prototype.drawItemPrice = function (item, rect) {
        var price = this.price(item);
        var priceWidth = this.priceWidth();
        var priceX = rect.x + rect.width - priceWidth;
        this.changeTextColor(ColorManager.normalColor());
        this.contents.fontSize = 22;
        this.drawText(price + 'Ｇ', priceX, rect.y, priceWidth, "right");
    };
    return Window_ShopBuy2;
}(Window_ShopBuy));
var Window_ShopSell2 = /** @class */ (function (_super) {
    __extends(Window_ShopSell2, _super);
    function Window_ShopSell2() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isEnabled = function (item) {
            return item && Nore.sellingPrice(item) > 0;
        };
        return _this;
    }
    Window_ShopSell2.prototype.includes = function (item) {
        switch (this._category) {
            case "item":
                return DataManager.isItem(item) && item.itypeId === 1;
            case "weapon":
                return DataManager.isWeapon(item);
            case "armor":
                if (!DataManager.isArmor(item)) {
                    return false;
                }
                var armor = item;
                return this.includesArmor(armor);
            case "keyItem":
                return DataManager.isItem(item) && item.itypeId === 2;
            default:
                return false;
        }
    };
    Window_ShopSell2.prototype.includesArmor = function (armor) {
        if ($gameMedals.isMedal(armor)) {
            return false;
        }
        return true;
    };
    return Window_ShopSell2;
}(Window_ShopSell));
Window_ShopCommand.prototype.makeCommandList = function () {
    this.addCommand(TextManager._buy, "buy");
    this.addCommand(TextManager._sell, "sell", !this._purchaseOnly);
    this.addCommand(TextManager._cancel, "cancel");
};
Window_ItemCategory.prototype.makeCommandList = function () {
    if (this.needsCommand("item")) {
        this.addCommand(TextManager._item, "item");
    }
    if (this.needsCommand("weapon")) {
        this.addCommand(TextManager.equipWeapon, "weapon");
    }
    if (this.needsCommand("armor")) {
        this.addCommand(TextManager._armor, "armor");
    }
    if (this.needsCommand("keyItem")) {
        this.addCommand(TextManager._keyItem, "keyItem");
    }
};
