var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var SYASEI_VAR = 54;
var Sprite_SikyuTachie = /** @class */ (function (_super) {
    __extends(Sprite_SikyuTachie, _super);
    function Sprite_SikyuTachie() {
        var _this = _super.call(this) || this;
        _this.bitmap = new Bitmap(RIGHT_WIDTH, 150);
        _this.createSikyuSprite();
        _this.createRanshiSprite();
        _this.createNumberSprite();
        return _this;
    }
    Sprite_SikyuTachie.prototype.createSikyuSprite = function () {
        this._sikyuSprite = new Sprite_Sikyu($gameSystem.baisyunActorId());
        this.addChild(this._sikyuSprite);
    };
    Sprite_SikyuTachie.prototype.createRanshiSprite = function () {
        this._ranshiSprite = new Sprite_SikyuRanshi($gameSystem.baisyunActorId());
        this.addChild(this._ranshiSprite);
        this._ranshiSprite.x = 222;
        this._ranshiSprite.y = 74;
    };
    Sprite_SikyuTachie.prototype.createNumberSprite = function () {
        this._numberSprite = new Sprite();
        this.addChild(this._numberSprite);
    };
    Sprite_SikyuTachie.prototype.refresh = function () {
        this.bitmap.clear();
        this.bitmap.fontFace = $gameSystem.mainFontFace();
        this._numberSprite.removeChildren();
        this.drawBg();
        this.drawBaisyun(8);
        this.drawCondom(114);
    };
    Sprite_SikyuTachie.prototype.drawBg = function () {
        if (SceneManager._scene instanceof Scene_Baisyun) {
            return;
        }
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        this.bitmap.blt(bitmap, 350, 700, 350, 150, 0, 0);
    };
    Sprite_SikyuTachie.prototype.drawCondom = function (y) {
        var x = 170;
        var num = this.actor().sikyu().condomCount();
        for (var i = 0; i < num; i++) {
            this.drawIcon(Icon.condom2, x, y);
            x += 32;
        }
        var num2 = this.actor().sikyu().sotodashiCount();
        for (var i = 0; i < num2; i++) {
            this.drawIcon(Icon.sotodashi, x, y);
            x += 32;
        }
    };
    Sprite_SikyuTachie.prototype.drawBaisyun = function (y) {
        this.bitmap.fontSize = 20;
        var baisyun = $gameSystem.baisyun();
        if (!baisyun) {
            return;
        }
        var x = 162;
        this.drawHp(x, y, baisyun);
        this.drawLevel(x, y + 28, baisyun);
        this.drawExp(x, y + 28 + 10, baisyun);
        this.drawNinshin(x, y + 28 + 26, baisyun);
        this.drawRemainTurn(x, y + 76, baisyun);
    };
    Sprite_SikyuTachie.prototype.drawNinshin = function (x, y, baisyun) {
        if (this.actor().actorId() == 3) {
            return;
        }
        this.bitmap.fontSize = 20;
        this.bitmap.drawText(TextManager.baisyunOvum, x, y, 130, 32);
    };
    Sprite_SikyuTachie.prototype.drawRemainTurn = function (x, y, baisyun) {
        this._lastTurn = baisyun.remainTurn();
        this.bitmap.fontSize = 16;
        var text;
        if (this._lastTurn > 0) {
            text = TextManager.baisyunRemainTurn.format(this._lastTurn);
        }
        else {
            text = TextManager.baisyunRemainTurn0;
        }
        this.bitmap.drawText(text, x, y, 200, 36, 'left');
    };
    Sprite_SikyuTachie.prototype.drawLevel = function (x, y, baisyun) {
        this.bitmap.textColor = ColorManager.systemColor();
        this.drawUiLabel(1, 160, y);
        //this.bitmap.drawText('LV', x, y, 130, 32);
        this.bitmap.textColor = ColorManager.normalColor();
        var actor = baisyun.actor();
        var level = actor.baisyunLevel().level();
        this._numberSprite.drawNumber(level, x + 10, y - 10, 44, 'right', 1);
        //this.bitmap.drawText(level + '', x + 30, y, 130, 32);
    };
    Sprite_SikyuTachie.prototype.drawHp = function (x, y, baisyun) {
        if (!baisyun) {
            return;
        }
        this._lastHp = baisyun.hp();
        this.drawUiLabel(0, 160, y);
        this.bitmap.textColor = ColorManager.normalColor();
        var gaugeLeft = x + 58;
        var gaugeW = 110;
        var actor = baisyun.actor();
        var player = actor.baisyunPlayer();
        this.drawGaugeRect(gaugeLeft, y + 10, gaugeW, 15, baisyun.hpRate());
        this._numberSprite.drawNumber(this._lastHp, x + 10, y - 10, 44, 'right', 1);
        //this.bitmap.drawText(this._lastHp + '', x + 30, y, 130, 32);
        //this.bitmap.drawText(this._lastHp + '/' + baisyun.maxHp(), gaugeLeft + 10, y, 130, 32);
    };
    Sprite_SikyuTachie.prototype.drawUiLabel = function (index, x, y) {
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        var w = 50;
        var h = 30;
        var xx = 350 + w * index;
        this.bitmap.blt(bitmap, xx, 0, w, h, x, y + 6);
    };
    Sprite_SikyuTachie.prototype.drawExp = function (x, y, baisyun) {
        if (!baisyun) {
            return;
        }
        var actor = baisyun.actor();
        var baisyunLevel = actor.baisyunLevel();
        var gaugeLeft = x + 58;
        var gaugeW = 110;
        this.drawExpGaugeRect(gaugeLeft, y, gaugeW, 12, baisyunLevel.expRate());
        this.bitmap.fontSize = 14;
        this.bitmap.textColor = ColorManager.normalColor();
        if (baisyunLevel.isMaxLevel()) {
            this.bitmap.drawText('MAX', x + 96, y - 10, 130, 32);
        }
    };
    Sprite_SikyuTachie.prototype.drawGaugeRect = function (x, y, width, height, rate) {
        var fillW = Math.floor((width - 2) * rate);
        var fillH = height - 2;
        var color0 = this.gaugeBackColor();
        var color1 = ColorManager.hpGaugeColor1();
        var color2 = ColorManager.hpGaugeColor2();
        this.bitmap.fillRect(x, y, width, height, color0);
        this.bitmap.gradientFillRect(x + 1, y + 1, fillW, fillH, color1, color2);
    };
    Sprite_SikyuTachie.prototype.drawExpGaugeRect = function (x, y, width, height, rate) {
        var fillW = Math.floor((width - 2) * rate);
        var fillH = height - 2;
        var color0 = this.gaugeBackColor();
        var color1 = ColorManager.mpGaugeColor1();
        var color2 = ColorManager.mpGaugeColor2();
        this.bitmap.fillRect(x, y, width, height, color0);
        this.bitmap.gradientFillRect(x + 1, y + 1, fillW, fillH, color1, color2);
    };
    Sprite_SikyuTachie.prototype.gaugeRate = function (player) {
        return player.hp() / player.maxHp();
    };
    Sprite_SikyuTachie.prototype.gaugeBackColor = function () {
        return '#000000';
    };
    Sprite_SikyuTachie.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_SikyuTachie.prototype.actor = function () {
        return $gameActors.actor($gameSystem.baisyunActorId());
    };
    Sprite_SikyuTachie.prototype.isChanged = function () {
        if (!this.visible) {
            return false;
        }
        var baisyun = $gameSystem.baisyun();
        if (baisyun) {
            if (this._lastTurn != baisyun.remainTurn()) {
                return true;
            }
            if (this._lastHp != baisyun.hp()) {
                return true;
            }
        }
        return false; //this._lastPercent != this.actor().sikyu().percent();
    };
    return Sprite_SikyuTachie;
}(Sprite));
var Sprite_Sikyu = /** @class */ (function (_super) {
    __extends(Sprite_Sikyu, _super);
    function Sprite_Sikyu(actorId) {
        var _this = _super.call(this) || this;
        _this._actorId = actorId;
        _this.refresh();
        return _this;
    }
    Sprite_Sikyu.prototype.refresh = function () {
        this.drawSikyu();
    };
    Sprite_Sikyu.prototype.drawSikyu = function () {
        this.removeChildren();
        this._lastPercent = this.actor().sikyu().percent();
        this._lastFrame = this.sikyuChinpoFrame();
        this._lastSyasei = this.isSyasei();
        var f = this._lastFrame;
        if ($gameTemp.notUseCondom) {
            this.addSprite(f, 1);
        }
        else {
            this.addSprite(f, 2);
        }
        if (this._lastPercent >= 1) {
            this.addSprite(f, 3);
        }
        if (this._lastPercent >= 50) {
            this.addSprite(f, 4);
        }
        if (this._lastPercent >= 75) {
            this.addSprite(f, 5);
        }
        if (this._lastPercent >= 100) {
            this.addSprite(f, 6);
        }
        if ($gameTemp.notUseCondom && this.isSyasei() && f == 9) {
            this.addSprite(f, 9);
        }
        /*let fileName
        if (this._lastPercent >= 40) {
            fileName = '3';
        }
        else if (this._lastPercent >= 20) {
            fileName = '2';
        }
        if (sprite) {
            sprite.x = -20
            sprite.y = 0
            this.addChild(sprite);
        }*/
    };
    Sprite_Sikyu.prototype.addSprite = function (frame, index) {
        var sprite = this.getFile(frame, index);
        if (sprite) {
            sprite.x = -30;
            sprite.y = 0;
            this.addChild(sprite);
        }
    };
    Sprite_Sikyu.prototype.actor = function () {
        return $gameActors.actor($gameSystem.baisyunActorId());
    };
    Sprite_Sikyu.prototype.getFile = function (frame, index) {
        var sikyuId = 1;
        if (this._actorId == 3) {
            sikyuId = 2;
        }
        if (sikyuId == 2 && index >= 4) {
            return null;
        }
        var file = '0sikyu_%1'.format(sikyuId) + '0' + frame + '_' + index.padZero(2);
        var texture = PIXI.utils.TextureCache[file + '.png'];
        if (!texture) {
            console.error('ファイルが見つかりません' + file);
            return null;
        }
        var s = new PIXI.Sprite(texture);
        var scale = this.sikyuScale();
        s.scale.x = scale;
        s.scale.y = scale;
        return s;
    };
    Sprite_Sikyu.prototype.destroy = function (options) {
        this.removeChildren();
        _super.prototype.destroy.call(this);
    };
    Sprite_Sikyu.prototype.sikyuScale = function () {
        return 0.5;
    };
    Sprite_Sikyu.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_Sikyu.prototype.isChanged = function () {
        if (!this.visible) {
            return false;
        }
        if (this._lastFrame != this.sikyuChinpoFrame()) {
            return true;
        }
        if (this._lastSyasei != this.isSyasei()) {
            return true;
        }
        return this._lastPercent != this.actor().sikyu().percent();
    };
    Sprite_Sikyu.prototype.sikyuChinpoFrame = function () {
        return $gameVariables.value(53);
    };
    Sprite_Sikyu.prototype.isSyasei = function () {
        return $gameVariables.value(SYASEI_VAR) > 0;
    };
    return Sprite_Sikyu;
}(Sprite));
var Sprite_SikyuRanshi = /** @class */ (function (_super) {
    __extends(Sprite_SikyuRanshi, _super);
    function Sprite_SikyuRanshi(actorId) {
        var _this = _super.call(this) || this;
        _this._actorId = actorId;
        _this._lastNinshinDamage = _this.ninshinDamage();
        _this.bitmap = new Bitmap(150, 20);
        _this.refresh();
        return _this;
    }
    Sprite_SikyuRanshi.prototype.ninshinDamage = function () {
        return $gameActors.actor(this._actorId).ninshinDamage();
    };
    Sprite_SikyuRanshi.prototype.refresh = function () {
        this.updateVisible();
        this.drawNinshinGauge();
    };
    Sprite_SikyuRanshi.prototype.drawNinshinGauge = function () {
        this._lastNinshinDamage = this.ninshinDamage();
        var rate = (100 - this._lastNinshinDamage) / 100;
        this.bitmap.clear();
        this.drawGaugeRect(0, 0, 110, 10, rate);
    };
    Sprite_SikyuRanshi.prototype.updateVisible = function () {
        this.visible = this._actorId != 3;
    };
    Sprite_SikyuRanshi.prototype.drawGaugeRect = function (x, y, width, height, rate) {
        var fillW = Math.floor((width - 2) * rate);
        var fillH = height - 2;
        var color0 = this.gaugeBackColor();
        var color1 = ColorManager.hpGaugeColor1();
        var color2 = ColorManager.hpGaugeColor2();
        this.bitmap.fillRect(x, y, width, height, color0);
        this.bitmap.gradientFillRect(x + 1, y + 1, fillW, fillH, color1, color2);
    };
    Sprite_SikyuRanshi.prototype.gaugeBackColor = function () {
        return '#000000';
    };
    Sprite_SikyuRanshi.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_SikyuRanshi.prototype.isChanged = function () {
        return this._lastNinshinDamage != this.ninshinDamage();
    };
    return Sprite_SikyuRanshi;
}(Sprite));
