/*:ja
 * @target MZ
 */
var Nore;
(function (Nore) {
    Sprite_Clickable.prototype.changeTextColor = function (color) {
        this.bitmap.textColor = color;
    };
    Sprite_Gauge.prototype.bitmapWidth = function () {
        return 228;
    };
    var _Sprite_Gauge_prototype_currentValue = Sprite_Gauge.prototype.currentValue;
    Sprite_Gauge.prototype.currentValue = function () {
        if (this._battler) {
            switch (this._statusType) {
                case 'fame':
                    return $gamePlayer.mainActor().fame;
                case 'frustration':
                    return $gamePlayer.mainActor().zasetsu;
            }
        }
        return _Sprite_Gauge_prototype_currentValue.call(this);
    };
    var _Sprite_Gauge_prototype_currentMaxValue = Sprite_Gauge.prototype.currentMaxValue;
    Sprite_Gauge.prototype.currentMaxValue = function () {
        if (this._battler) {
            switch (this._statusType) {
                case 'fame':
                    return $gamePlayer.mainActor().maxFame;
                case 'frustration':
                    return $gamePlayer.mainActor().maxZasetsu;
            }
        }
        return _Sprite_Gauge_prototype_currentMaxValue.call(this);
    };
    var Sprite_Gauge_prototype_label = Sprite_Gauge.prototype.label;
    Sprite_Gauge.prototype.label = function () {
        switch (this._statusType) {
            case 'fame':
                return TextManager.fame;
            case 'frustration':
                return TextManager.frustration;
        }
        return Sprite_Gauge_prototype_label.call(this);
    };
    Sprite_Gauge.prototype.gaugeX = function () {
        return this._statusType === "time" ? 0 : 100;
    };
    function getSystemBaseTexture(name) {
        var baseTexture = PIXI.utils.BaseTextureCache['system/' + name];
        if (!baseTexture) {
            var bitmap = ImageManager.loadSystem(name);
            if (!bitmap.isReady()) {
                return;
            }
            baseTexture = new PIXI.BaseTexture(bitmap._image);
            baseTexture.resource.url = 'system/' + name;
            PIXI.utils.BaseTextureCache['system/' + name] = baseTexture;
        }
        return baseTexture;
    }
    Nore.getSystemBaseTexture = getSystemBaseTexture;
    var _Window_prototype_createContentsBackSprite = Window.prototype._createContentsBackSprite;
    Window.prototype._createContentsBackSprite = function () {
        _Window_prototype_createContentsBackSprite.call(this);
        this._windowContentsBackSprite2 = new Sprite();
        this._clientArea.addChild(this._windowContentsBackSprite2);
    };
    var Window_prototype__createContentsSprite = Window.prototype._createContentsSprite;
    Window.prototype._createContentsSprite = function () {
        this._windowContentsBackSprite = new Sprite();
        this._clientArea.addChild(this._windowContentsBackSprite);
        Window_prototype__createContentsSprite.call(this);
        this._windowContentsSprite = new Sprite();
        this._windowContentsSprite.x = -12;
        this._windowContentsSprite.y = -12;
        this._clientArea.addChild(this._windowContentsSprite);
    };
    Spriteset_Base.prototype.isAnimationPlaying = function () {
        if (this._animationSprites.length == 0) {
            return false;
        }
        for (var _i = 0, _a = this._animationSprites; _i < _a.length; _i++) {
            var anime = _a[_i];
            if (anime.isPlayingBattle()) {
                return true;
            }
            else {
            }
        }
        return false;
        return this._animationSprites.length > 0;
    };
    Sprite_AnimationMV.prototype.isPlayingBattle = function () {
        if (this._battleDuration > 0) {
            return this._battleDuration > this._frameIndex;
        }
        return this.isPlaying();
    };
    Sprite_Animation.prototype.isPlayingBattle = function () {
        if (this._battleDuration > 0) {
            return this._battleDuration > this._frameIndex;
        }
        return this._playing;
    };
    Window_Base.prototype.drawGoldImg = function (x, y) {
        var baseTexture = Nore.getSystemBaseTexture('gold');
        var texture = new PIXI.Texture(baseTexture);
        var sprite = new PIXI.Sprite(texture);
        sprite.x = x;
        sprite.y = y;
        this._windowContentsSprite.addChild(sprite);
    };
    Window_Base.prototype.drawItemName = function (item, x, y, width) {
        if (item) {
            var iconY = y + (this.lineHeight() - ImageManager.iconHeight) / 2;
            var textMargin = ImageManager.iconWidth + 4;
            var itemWidth = Math.max(0, width - textMargin);
            this.resetTextColor();
            this.drawIcon(item.iconIndex, x, iconY);
            this.drawText(getItemName(item), x + textMargin, y, itemWidth);
        }
    };
    Window_Base.prototype.drawStatusLabel = function (x, y, index, parent) {
        if (parent === void 0) { parent = null; }
        var baseTexture = Nore.getSystemBaseTexture('status_label');
        var rect = new Rectangle(0, index * 32, 32 * 5, 32);
        if (ConfigManager.language != 'jp') {
            rect.x = 10 * 32;
        }
        var texture = new PIXI.Texture(baseTexture, rect);
        var sprite = new PIXI.Sprite(texture);
        sprite.x = x + 10;
        sprite.y = y + 10;
        if (parent) {
            parent.addChild(sprite);
        }
        else {
            this._windowContentsSprite.addChild(sprite);
        }
    };
})(Nore || (Nore = {}));
var Rank;
(function (Rank) {
    Rank[Rank["H"] = 0] = "H";
    Rank[Rank["G"] = 1] = "G";
    Rank[Rank["F"] = 2] = "F";
    Rank[Rank["E"] = 3] = "E";
    Rank[Rank["D"] = 4] = "D";
    Rank[Rank["C"] = 5] = "C";
    Rank[Rank["B"] = 6] = "B";
    Rank[Rank["A"] = 7] = "A";
    Rank[Rank["S"] = 8] = "S";
    Rank[Rank["MAX"] = 9] = "MAX";
})(Rank || (Rank = {}));
Sprite_Damage.prototype.setup = function (target) {
    var result = target.result();
    if (result.missed || result.evaded) {
        this._colorType = 0;
        this.createMiss();
    }
    else if (result.shieldDamage() > 0) {
        this._colorType = result.shieldDamage() >= 0 ? 0 : 1;
        this.createDigits(result.shieldDamage() + result.hpDamage);
    }
    else if (result.hpAffected) {
        this._colorType = result.hpDamage >= 0 ? 0 : 1;
        this.createDigits(result.hpDamage);
    }
    else if (target.isAlive() && result.mpDamage !== 0) {
        this._colorType = result.mpDamage >= 0 ? 2 : 3;
        this.createDigits(result.mpDamage);
    }
    if (result.critical) {
        this.setupCriticalEffect();
    }
};
