var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command show
 * @text
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_StageSelect';
    PluginManager.registerCommand(pluginName, 'show', function (args) {
        SceneManager.push(Scene_StageSelect);
    });
})(Nore || (Nore = {}));
var PLACE_ID_VAR = 8;
var FLOOR_ID_VAR = 9;
var AUTO_DUNGEON_SW = 34;
var PlaceId;
(function (PlaceId) {
    PlaceId[PlaceId["town"] = 0] = "town";
    PlaceId[PlaceId["stage1"] = 1] = "stage1";
    PlaceId[PlaceId["stage2"] = 2] = "stage2";
    PlaceId[PlaceId["stage3"] = 3] = "stage3";
    PlaceId[PlaceId["stage4"] = 4] = "stage4";
    PlaceId[PlaceId["stage5"] = 5] = "stage5";
    PlaceId[PlaceId["ending"] = 10] = "ending";
})(PlaceId || (PlaceId = {}));
var Scene_StageSelect = /** @class */ (function (_super) {
    __extends(Scene_StageSelect, _super);
    function Scene_StageSelect() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_StageSelect.prototype.create = function () {
        _super.prototype.create.call(this);
        this.createPictures();
        this.createStageWindow();
        this.createCollectionWindow();
        this.createFloorWindow();
        this.createCharacter();
        this.showMapPicture();
        this.createWindowLayer();
        this.createAllWindows();
        this.createFadeSprite();
        this.createConfirmWindow();
        this.startInitialScenario();
    };
    Scene_StageSelect.prototype.startInitialScenario = function () {
        if (!$gameSwitches.value(261)) {
            return;
        }
        if ($gameSwitches.value(233)) {
            return;
        }
        $gameSwitches.setValue(233, true);
        this._stageWindow.deactivate();
        this.playScenario('簡易探索説明_01');
    };
    Scene_StageSelect.prototype.finishScenario = function () {
        this._stageWindow.activate();
        //this._kigaeSlotWindow.activate();
    };
    Scene_StageSelect.prototype.createFadeSprite = function () {
        this._fadeSprite = new ScreenSprite();
        this.addChild(this._fadeSprite);
    };
    Scene_StageSelect.prototype.createConfirmWindow = function () {
        this._confirmWindow = new Nore.Window_Confirm();
        this._confirmWindow.setTexts(['', 'よろしいですか？']);
        this._confirmWindow.setHandler('ok', this.onConfirmOk.bind(this));
        this._confirmWindow.setHandler('cancel', this.onConfirmCancel.bind(this));
        this._confirmWindow.deactivate();
        this.addChild(this._confirmWindow);
        this._confirmWindow.hide();
    };
    Scene_StageSelect.prototype.showMapPicture = function () {
        $gameScreen.showPicture(1, 'map', 0, 0, 0, 110, 110, 255, 0);
    };
    Scene_StageSelect.prototype.terminate = function () {
        _super.prototype.terminate.call(this);
        $gameScreen.erasePicture(1);
    };
    Scene_StageSelect.prototype.createPictures = function () {
        var width = Graphics.width;
        var height = Graphics.height;
        var x = (Graphics.width - width) / 2;
        var y = (Graphics.height - height) / 2;
        this._pictureContainer = new Sprite();
        this._pictureContainer.setFrame(x, y, width, height);
        for (var i = 0; i <= $gameScreen.maxPictures(); i++) {
            this._pictureContainer.addChild(new Sprite_Picture(i));
        }
        this.addChild(this._pictureContainer);
    };
    Scene_StageSelect.prototype.createStageWindow = function () {
        this._stageWindow = new Window_StageSelect();
        this._stageWindow.setHandler('change', this.onChange.bind(this));
        this._stageWindow.setHandler('cancel', this.onCancel.bind(this));
        this._stageWindow.setHandler('ok', this.onOk.bind(this));
        this.addChild(this._stageWindow);
    };
    Scene_StageSelect.prototype.createCollectionWindow = function () {
        this._collectionWindow = new Window_MaterialCollection();
        this.addChild(this._collectionWindow);
    };
    Scene_StageSelect.prototype.createFloorWindow = function () {
        this._floorWindow = new Window_FloorSelect();
        this._floorWindow.setHandler('change', this.onFloorChange.bind(this));
        this._floorWindow.setHandler('cancel', this.onFloorCancel.bind(this));
        this._floorWindow.setHandler('ok', this.onFloorOk.bind(this));
        this.addChild(this._floorWindow);
        this._floorWindow.hide();
    };
    Scene_StageSelect.prototype.createCharacter = function () {
        this._char = new Game_StageChar();
        var cos = new CharacterCostume(2);
        this._charSprite = new Sprite_ActorCharacter(this._char, cos);
        this.addChild(this._charSprite);
    };
    Scene_StageSelect.prototype.start = function () {
        _super.prototype.start.call(this);
        this.onChange();
    };
    Scene_StageSelect.prototype.onChange = function () {
        var symbol = this._stageWindow.currentSymbol();
        this._collectionWindow.setSymbol(symbol);
        this.updateCharacterPosition(symbol);
    };
    Scene_StageSelect.prototype.updateCharacterPosition = function (symbol) {
        switch (symbol) {
            case 'stage1':
                this._char.setScreenPos(520, 400);
                break;
            case 'stage2':
                this._char.setScreenPos(640, 380);
                break;
            case 'stage3':
                this._char.setScreenPos(1040, 340);
                break;
            case 'stage4':
                this._char.setScreenPos(940, 540);
                break;
            case 'stage5':
                this._char.setScreenPos(380, 690);
                break;
            case 'cancel':
                this._char.setScreenPos(574, 550);
                break;
        }
    };
    Scene_StageSelect.prototype.onFloorChange = function () {
    };
    Scene_StageSelect.prototype.onFloorCancel = function () {
        this._floorWindow.hide();
        this._stageWindow.activate();
    };
    Scene_StageSelect.prototype.onCancel = function () {
        this.setWarpTarget(PlaceId.town, -1, false);
        this.popScene();
    };
    Scene_StageSelect.prototype.onFloorOk = function () {
        var floor = this._floorWindow.currentSymbol();
        if (this.isEnding(floor)) {
            this._confirmWindow.setTexts([TextManager.worldShowEnding, TextManager.worldConfirm]);
        }
        else if (this.isLastBattle(floor)) {
            this._confirmWindow.setTexts([TextManager.worldLastBattle, TextManager.worldConfirm]);
        }
        else if (floor.contains('auto')) {
            this.setUpAutoSearch();
        }
        else {
            this.setUpNormalSearch();
        }
        this._confirmWindow.select(0);
        this._confirmWindow.activate();
        this._confirmWindow.show();
    };
    Scene_StageSelect.prototype.setUpAutoSearch = function () {
        var texts;
        if (ConfigManager.isJp()) {
            texts = [TextManager.worldAuto, TextManager.worldConfirm];
        }
        else {
            texts = [TextManager.worldAuto];
        }
        this._confirmWindow.setTexts(texts);
    };
    Scene_StageSelect.prototype.setUpNormalSearch = function () {
        var texts;
        if (ConfigManager.isJp()) {
            texts = [TextManager.worldGo, TextManager.worldConfirm];
        }
        else {
            texts = [TextManager.worldGo];
        }
        this._confirmWindow.setTexts(texts);
    };
    Scene_StageSelect.prototype.isEnding = function (floor) {
        return floor == 'ending';
    };
    Scene_StageSelect.prototype.isLastBattle = function (floor) {
        if (!$gameSwitches.value(429)) {
            return false;
        }
        if (floor != '10f') {
            return false;
        }
        if (this._stageWindow.currentSymbol() != 'stage5') {
            return false;
        }
        return true;
    };
    Scene_StageSelect.prototype.onConfirmOk = function () {
        this._confirmWindow.hide();
        var stage = this._stageWindow.currentSymbol();
        var floor = this._floorWindow.currentSymbol();
        switch (stage) {
            case 'stage1':
                this.decideWarpTarget1(floor);
                break;
            case 'stage2':
                this.decideWarpTarget2(floor);
                break;
            case 'stage3':
                this.decideWarpTarget3(floor);
                break;
            case 'stage4':
                this.decideWarpTarget4(floor);
                break;
            case 'stage5':
                this.decideWarpTarget5(floor);
                break;
            case 'cancel':
                this.setWarpTarget(PlaceId.town, -1, false);
                break;
        }
        $gameScreen.startFadeOut(20);
    };
    Scene_StageSelect.prototype.decideWarpTarget1 = function (floor) {
        switch (floor) {
            case '1f':
                this.setWarpTarget(PlaceId.stage1, 1, false);
                return;
            case '5f':
                this.setWarpTarget(PlaceId.stage1, 5, false);
                return;
            case '10f':
                this.setWarpTarget(PlaceId.stage1, 10, false);
                return;
            case '1f_auto':
                this.setWarpTarget(PlaceId.stage1, 5, true);
                return;
            default:
                console.error('不正なワープ先です:' + floor);
        }
    };
    Scene_StageSelect.prototype.decideWarpTarget2 = function (floor) {
        switch (floor) {
            case '1f':
                this.setWarpTarget(PlaceId.stage2, 1, false);
                return;
            case '5f':
                this.setWarpTarget(PlaceId.stage2, 5, false);
                return;
            case '10f':
                this.setWarpTarget(PlaceId.stage2, 10, false);
                return;
            case '1f_auto':
                this.setWarpTarget(PlaceId.stage2, 5, true);
                return;
            default:
                console.error('不正なワープ先です:' + floor);
        }
    };
    Scene_StageSelect.prototype.decideWarpTarget3 = function (floor) {
        switch (floor) {
            case '1f':
                this.setWarpTarget(PlaceId.stage3, 1, false);
                return;
            case '5f':
                this.setWarpTarget(PlaceId.stage3, 5, false);
                return;
            case '10f':
                this.setWarpTarget(PlaceId.stage3, 10, false);
                return;
            case '1f_auto':
                this.setWarpTarget(PlaceId.stage3, 5, true);
                return;
            default:
                console.error('不正なワープ先です:' + floor);
        }
    };
    Scene_StageSelect.prototype.decideWarpTarget4 = function (floor) {
        switch (floor) {
            case '1f':
                this.setWarpTarget(PlaceId.stage4, 1, false);
                return;
            case '5f':
                this.setWarpTarget(PlaceId.stage4, 5, false);
                return;
            case '10f':
                this.setWarpTarget(PlaceId.stage4, 10, false);
                return;
            case '1f_auto':
                this.setWarpTarget(PlaceId.stage4, 5, true);
                return;
            default:
                console.error('不正なワープ先です:' + floor);
        }
    };
    Scene_StageSelect.prototype.decideWarpTarget5 = function (floor) {
        switch (floor) {
            case '1f':
                this.setWarpTarget(PlaceId.stage5, 1, false);
                return;
            case '5f':
                this.setWarpTarget(PlaceId.stage5, 5, false);
                return;
            case '10f':
                this.setWarpTarget(PlaceId.stage5, 10, false);
                return;
            case '1f_auto':
                this.setWarpTarget(PlaceId.stage5, 5, true);
                return;
            case 'ending':
                this.setWarpTarget(PlaceId.ending, 1, false);
                return;
            default:
                console.error('不正なワープ先です:' + floor);
        }
    };
    Scene_StageSelect.prototype.onConfirmCancel = function () {
        this._confirmWindow.deactivate();
        this._confirmWindow.hide();
        this._floorWindow.activate();
    };
    Scene_StageSelect.prototype.onOk = function () {
        var symbol = this._stageWindow.currentSymbol();
        this._floorWindow.setSymbol(symbol);
        this._floorWindow.select(0);
        this._floorWindow.activate();
    };
    Scene_StageSelect.prototype.setWarpTarget = function (placeId, floorId, isAuto) {
        $gameVariables.setValue(PLACE_ID_VAR, placeId);
        $gameVariables.setValue(FLOOR_ID_VAR, floorId);
        $gameSwitches.setValue(AUTO_DUNGEON_SW, isAuto);
    };
    Scene_StageSelect.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateChar();
        this.updateFade();
    };
    Scene_StageSelect.prototype.updateChar = function () {
        if (this._char) {
            this._char.update();
        }
    };
    Scene_StageSelect.prototype.updateFade = function () {
        if (this._finished) {
            return;
        }
        $gameScreen.update();
        this._fadeSprite.opacity = 255 - $gameScreen.brightness();
        if (this._fadeSprite.opacity >= 255) {
            this._finished = true;
            this.popScene();
        }
    };
    return Scene_StageSelect;
}(Nore.Scene_Talk));
var Game_StageChar = /** @class */ (function (_super) {
    __extends(Game_StageChar, _super);
    function Game_StageChar() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Game_StageChar.prototype.characterName = function () {
        return 'MS_Msheet';
    };
    Game_StageChar.prototype.characterIndex = function () {
        return 0;
    };
    Game_StageChar.prototype.hasStepAnime = function () {
        return true;
    };
    Game_StageChar.prototype.screenX = function () {
        return this._screenX;
    };
    Game_StageChar.prototype.screenY = function () {
        return this._screenY;
    };
    Game_StageChar.prototype.setScreenPos = function (x, y) {
        this._screenX = x;
        this._screenY = y;
    };
    return Game_StageChar;
}(Game_Character));
var Window_StageSelect = /** @class */ (function (_super) {
    __extends(Window_StageSelect, _super);
    function Window_StageSelect() {
        var _this = this;
        var h = 90 + $gameSystem.stage() * 54;
        var r = new Rectangle(50, 50, 440, h);
        _this = _super.call(this, r) || this;
        _this.makeCommandList();
        _this.refresh();
        return _this;
    }
    Window_StageSelect.prototype.makeCommandList = function () {
        for (var i = 5; i >= 1; i--) {
            if ($gameSystem.stage() >= i) {
                this.addCommand(i, 'stage' + i, true);
            }
        }
        this.addCommand(10, 'cancel', true);
    };
    Window_StageSelect.prototype.lineHeight = function () {
        return 48;
    };
    Window_StageSelect.prototype.makeItemCommand = function (itemId) {
        return getItemName($dataItems[itemId]);
    };
    Window_StageSelect.prototype.drawItem = function (index) {
        var rect = this.itemLineRect(index);
        var itemId = parseInt(this._list[index].name);
        var item = $dataItems[itemId];
        this.changePaintOpacity(this.isCommandEnabled(index));
        this.drawIconBig(item.iconIndex, rect.x, rect.y);
        this.drawDungeonName(item, rect);
        this.drawRank(item, rect);
    };
    Window_StageSelect.prototype.drawDungeonName = function (item, rect) {
        this.resetTextColor();
        this.contents.fontSize = 22;
        this.drawText(this.makeItemCommand(item.id), rect.x + 48, rect.y, 200, this.itemTextAlign());
    };
    Window_StageSelect.prototype.drawRank = function (item, rect) {
        var rank = parseInt(item.meta['rank']);
        if (isNaN(rank)) {
            return;
        }
        this.changeTextColor(ColorManager.crisisColor());
        this.contents.fontSize = 18;
        var interval = 19;
        this.drawText('RANK', rect.x + 242, rect.y, 410, 'left');
        for (var i = 0; i < rank; i++) {
            this.drawText('★', rect.x + 302 + i * interval, rect.y, 410, 'left');
        }
    };
    return Window_StageSelect;
}(Window_Command));
var Window_FloorSelect = /** @class */ (function (_super) {
    __extends(Window_FloorSelect, _super);
    function Window_FloorSelect() {
        var h = $gameSystem.stage() == 5 ? 246 : 200;
        var r = new Rectangle(250, 50, 300, h);
        return _super.call(this, r) || this;
    }
    Window_FloorSelect.prototype.resetFontSettings = function () {
        this.contents.fontFace = $gameSystem.mainFontFace();
        this.contents.fontSize = 20;
        this.resetTextColor();
    };
    Window_FloorSelect.prototype.setSymbol = function (symbol) {
        this._symbol = symbol;
        if (this._symbol == 'cancel') {
            this.hide();
            return;
        }
        this.refresh();
        this.show();
    };
    Window_FloorSelect.prototype.makeCommandList = function () {
        if (this._symbol == 'stage1') {
            this.makeCommandDugeon1();
        }
        if (this._symbol == 'stage2') {
            this.makeCommandDugeon2();
        }
        if (this._symbol == 'stage3') {
            this.makeCommandDugeon3();
        }
        if (this._symbol == 'stage4') {
            this.makeCommandDugeon4();
        }
        if (this._symbol == 'stage5') {
            this.makeCommandDugeon5();
        }
    };
    Window_FloorSelect.prototype.makeCommandDugeon1 = function () {
        if ($gameSwitches.value(262)) {
            this.addCommand(TextManager.worldGo9F, '10f', true);
        }
        if ($gameSwitches.value(261)) {
            this.addCommand(TextManager.worldGo5F, '5f', true);
        }
        this.addCommand(TextManager.worldGo1F, '1f', true);
        if ($gameSwitches.value(261)) {
            this.addCommand(TextManager.worldGoQuickly, '1f_auto', true);
        }
    };
    Window_FloorSelect.prototype.makeCommandDugeon2 = function () {
        if ($gameSwitches.value(264)) {
            this.addCommand(TextManager.worldGo9F, '10f', true);
        }
        if ($gameSwitches.value(263)) {
            this.addCommand(TextManager.worldGo5F, '5f', true);
        }
        this.addCommand(TextManager.worldGo1F, '1f', true);
        if ($gameSwitches.value(263)) {
            this.addCommand(TextManager.worldGoQuickly, '1f_auto', true);
        }
    };
    Window_FloorSelect.prototype.makeCommandDugeon3 = function () {
        if ($gameSwitches.value(266)) {
            this.addCommand(TextManager.worldGo9F, '10f', true);
        }
        if ($gameSwitches.value(265)) {
            this.addCommand(TextManager.worldGo5F, '5f', true);
        }
        this.addCommand(TextManager.worldGo1F, '1f', true);
        if ($gameSwitches.value(265)) {
            this.addCommand(TextManager.worldGoQuickly, '1f_auto', true);
        }
    };
    Window_FloorSelect.prototype.makeCommandDugeon4 = function () {
        if ($gameSwitches.value(268)) {
            this.addCommand(TextManager.worldGo9F, '10f', true);
        }
        if ($gameSwitches.value(267)) {
            this.addCommand(TextManager.worldGo5F, '5f', true);
        }
        this.addCommand(TextManager.worldGo1F, '1f', true);
        if ($gameSwitches.value(267)) {
            this.addCommand(TextManager.worldGoQuickly, '1f_auto', true);
        }
    };
    Window_FloorSelect.prototype.makeCommandDugeon5 = function () {
        if ($gameSwitches.value(429)) {
            if (DataManager._globalInfo && DataManager._globalInfo[99] && DataManager._globalInfo[99][999]) {
                this.addCommand(TextManager.worldEnding, 'ending', true);
            }
            this.addCommand(TextManager.worldLastBattle2, '10f', true);
        }
        else if ($gameSwitches.value(270)) {
            this.addCommand(TextManager.worldGo9F, '10f', true);
        }
        if ($gameSwitches.value(269)) {
            this.addCommand(TextManager.worldGo5F, '5f', true);
        }
        this.addCommand(TextManager.worldGo1F, '1f', true);
        if ($gameSwitches.value(269)) {
            this.addCommand(TextManager.worldGoQuickly, '1f_auto', true);
        }
    };
    return Window_FloorSelect;
}(Window_Command));
var Window_MaterialCollection = /** @class */ (function (_super) {
    __extends(Window_MaterialCollection, _super);
    function Window_MaterialCollection() {
        var r = new Rectangle(490, 50, 260, 240);
        return _super.call(this, r) || this;
    }
    Window_MaterialCollection.prototype.setSymbol = function (symbol) {
        this._symbol = symbol;
        if (this._symbol == 'cancel') {
            this.hide();
            return;
        }
        this.updateDungeonId();
        this.refresh();
        this.show();
    };
    Window_MaterialCollection.prototype.updateDungeonId = function () {
        switch (this._symbol) {
            case 'stage1':
                this._dungeonId = 1;
                break;
            case 'stage2':
                this._dungeonId = 2;
                break;
            case 'stage3':
                this._dungeonId = 3;
                break;
            case 'stage4':
                this._dungeonId = 4;
                break;
            case 'stage5':
                this._dungeonId = 5;
                break;
            default:
                console.error('不正なダンジョンIDです' + this._symbol);
        }
    };
    Window_MaterialCollection.prototype.refresh = function () {
        this.contents.clear();
        this.drawLabel();
        this.drawTitleIcon();
        this.drawMaterialIconList();
    };
    Window_MaterialCollection.prototype.drawMaterialIconList = function () {
        var list = getDungeonItemList(this._dungeonId);
        var xMap = new Map([
            [RoomType.flame, 0],
            [RoomType.water, 0],
            [RoomType.wood, 0],
            [RoomType.metal, 0],
        ]);
        var yMap = new Map([
            [RoomType.flame, 0],
            [RoomType.water, 1],
            [RoomType.wood, 2],
            [RoomType.metal, 3],
        ]);
        var x = 90;
        var intervalX = 34;
        for (var i = 0; i < list.length; i++) {
            var param = list[i];
            var item = param.item();
            var xIndex = xMap.get(param.roomType());
            var xx = xIndex * intervalX + x;
            xMap.set(param.roomType(), xIndex + 1);
            var yIndex = yMap.get(param.roomType());
            this.changePaintOpacity($gameParty.isGotItem(item.id));
            this.drawIcon(item.iconIndex, xx, this.calcY(yIndex));
        }
    };
    Window_MaterialCollection.prototype.drawLabel = function () {
        this.contents.fontSize = 20;
        this.changePaintOpacity(true);
        this.drawText(TextManager.worldMaterial, 0, 0, 240, 'center');
    };
    Window_MaterialCollection.prototype.drawTitleIcon = function () {
        for (var i = 0; i < 4; i++) {
            var icon = $gameParty.materialIcon(i);
            this.drawIcon(icon, 30, this.calcY(i));
            this.drawLine(i + 1, '#BBBBFFAA', -2);
        }
    };
    Window_MaterialCollection.prototype.drawLine = function (index, color, y) {
        this.contents.fillRect(10, this.calcY(index) + y, 214, 1, color);
    };
    Window_MaterialCollection.prototype.translucentOpacity = function () {
        return 60;
    };
    Window_MaterialCollection.prototype.calcY = function (index) {
        var y = index * this.lineHeight() + 50;
        return y;
    };
    return Window_MaterialCollection;
}(Window_Base));
