/*:ja
 * @target MZ
 * @author ル
 *
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var TaneoyaId;
(function (TaneoyaId) {
    TaneoyaId[TaneoyaId["none"] = 0] = "none";
    TaneoyaId[TaneoyaId["banzoku"] = 1] = "banzoku";
    TaneoyaId[TaneoyaId["chosyuhei"] = 2] = "chosyuhei";
    TaneoyaId[TaneoyaId["goblin"] = 3] = "goblin";
    TaneoyaId[TaneoyaId["vagrant"] = 4] = "vagrant";
    TaneoyaId[TaneoyaId["minister"] = 5] = "minister";
    TaneoyaId[TaneoyaId["bar"] = 6] = "bar";
    TaneoyaId[TaneoyaId["charles"] = 7] = "charles";
    TaneoyaId[TaneoyaId["gray"] = 8] = "gray";
    TaneoyaId[TaneoyaId["loli"] = 9] = "loli";
    TaneoyaId[TaneoyaId["oliver"] = 21] = "oliver";
})(TaneoyaId || (TaneoyaId = {}));
var Time;
(function (Time) {
    Time["morning"] = "morning";
    Time["afternoon"] = "afternoon";
    Time["night"] = "night";
})(Time || (Time = {}));
var PARAM_RANK = [50, 100, 200, 320, 500];
var CostumeSaver = /** @class */ (function () {
    function CostumeSaver(actorId, faceId) {
        if (faceId === void 0) { faceId = 0; }
        this._faceId = 0;
        this._hoppeId = 0;
        this._acceHoppeId = 0;
        this._namidaId = 0;
        this._namidaAcce = 0;
        this._hairId = 0;
        this._boteId = 0;
        this._lastTroopId = 0;
        this._medalId = 0;
        this._hightlight = Hightlight.normal;
        if (actorId < 0) {
            this._actorId = actorId;
            this._acceMap = {};
            return;
        }
        this.saveCostume(actorId, faceId);
    }
    CostumeSaver.prototype.isNull = function () {
        return this._actorId < 0;
    };
    CostumeSaver.prototype.saveCostume = function (actorId, faceId) {
        var actor = $gameActors.actor(actorId);
        this.saveCostumeActor(actor, faceId);
    };
    CostumeSaver.prototype.saveCostumeActor = function (actor, faceId) {
        this._actorId = actor.actorId();
        this._outerId = actor.outerId;
        this._outerTopId = actor.outerTopId;
        this._outerBottomId = actor.outerBottomId;
        this._armId = actor.armId;
        this._legId = actor.legId;
        this._innerTopId = actor.innerTopId;
        this._innerBottomId = actor.innerBottomId;
        this._poseId = actor.poseId;
        this._boteId = actor.boteId;
        this._hoppeId = actor.hoppeId;
        this._acceHoppeId = actor._acceHoppeId;
        this._namidaId = actor.namidaId;
        this._namidaAcce = actor.getNamidaAcceId();
        this._hightlight = actor.hightlight();
        this._hairId = actor.hairId();
        this._takeOffTop = actor._takeOffTop;
        this._takeOffBottom = actor._takeOffBottom;
        this._takeOffInnerTop = actor._takeOffInnerTop;
        this._takeOffInnerBottom = actor._takeOffInnerBottom;
        this._medalId = actor.currentMedalId();
        this._acceMap = JsonEx.makeDeepCopy(actor.acceMap);
        this.saveFace(faceId, actor.hoppeId);
    };
    CostumeSaver.prototype.restoreCostume = function (argActor, includeAcce) {
        if (includeAcce === void 0) { includeAcce = true; }
        var actor = argActor || $gameActors.actor(this._actorId);
        actor.setOuterId(this._outerId);
        actor.setOuterTopId(this._outerTopId);
        actor.setOuterBottomId(this._outerBottomId);
        actor.setArmId(this._armId);
        actor._legId = this._legId;
        actor._innerTopId = this._innerTopId;
        actor._innerBottomId = this._innerBottomId;
        actor.setHoppeId(this._hoppeId);
        actor.setAcceHoppeId(this._acceHoppeId);
        actor.setPoseId(this._poseId);
        actor.setNamidaId(this._namidaId);
        actor.setHightlight(this._hightlight);
        actor.setNamidaAcce(this._namidaAcce);
        actor.setHairId(this._hairId);
        actor._takeOffTop = this._takeOffTop;
        actor._takeOffBottom = this._takeOffBottom;
        actor._takeOffInnerTop = this._takeOffInnerTop;
        actor._takeOffInnerBottom = this._takeOffInnerBottom;
        if (includeAcce) {
            var list = this.fixedAcceList(actor.acceMap);
            actor.acceMap = JsonEx.makeDeepCopy(this._acceMap);
            for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
                var armorId = list_1[_i];
                actor.acceMap[armorId] = true;
            }
            if (this._faceId > 0) {
                actor.setDefaultFaceId(this._faceId);
            }
        }
        actor.setCacheChanged();
    };
    CostumeSaver.prototype.fixedAcceList = function (acceMap) {
        var result = [];
        for (var key in acceMap) {
            if (acceMap[key]) {
                var armor = $dataArmors[key];
                if (armor.meta['lock']) {
                    result.push(key);
                }
            }
        }
        return result;
    };
    CostumeSaver.prototype.saveFace = function (faceId, hoppeId) {
        this._faceId = faceId;
        this._hoppeId = hoppeId;
    };
    CostumeSaver.prototype.boteId = function () {
        return this._boteId || 0;
    };
    CostumeSaver.prototype.faceId = function () {
        return this._faceId || 1;
    };
    CostumeSaver.prototype.hoppeId = function () {
        return this._hoppeId || 0;
    };
    CostumeSaver.prototype.setFaceId = function (f) {
        this._faceId = f;
    };
    CostumeSaver.prototype.setHoppeId = function (h) {
        this._hoppeId = h;
    };
    CostumeSaver.prototype.setPoseId = function (h) {
        this._poseId = h;
    };
    CostumeSaver.prototype.poseId = function () {
        return this._poseId;
    };
    CostumeSaver.prototype.medalId = function () {
        return this._medalId;
    };
    CostumeSaver.prototype.setInnerBottomId = function (id) {
        this._innerBottomId = id;
    };
    CostumeSaver.prototype.setInnerTopId = function (id) {
        this._innerTopId = id;
    };
    CostumeSaver.prototype.setAcceId = function (acceId) {
        var armor = $dataArmors[acceId];
        var group = parseInt(armor.meta['group']);
        if (group > 0) {
            this.removeGroup(group, armor);
        }
    };
    CostumeSaver.prototype.removeGroup = function (groupId, newArmor) {
        var newId = newArmor.id;
        var isSet = this.hasAcce(newId);
        if (isSet && newArmor.meta['fixed']) {
            return;
        }
        var removeList = [];
        for (var i in this._acceMap) {
            if (!this._acceMap[i]) {
                continue;
            }
            var acceItem = $dataArmors[i];
            if (acceItem.meta['group']) {
                var group = parseInt(acceItem.meta['group']);
                if (group == groupId) {
                    removeList.push(i);
                }
            }
        }
        for (var _i = 0, removeList_1 = removeList; _i < removeList_1.length; _i++) {
            var i = removeList_1[_i];
            delete this._acceMap[i];
        }
        if (!isSet) {
            this._acceMap[newId] = true;
        }
    };
    CostumeSaver.prototype.outerId = function () {
        return this._outerId;
    };
    CostumeSaver.prototype.setOuterId = function (id) {
        this._outerId = id;
    };
    CostumeSaver.prototype.innerBottomId = function () {
        return this._innerBottomId;
    };
    CostumeSaver.prototype.innerTopId = function () {
        return this._innerTopId;
    };
    CostumeSaver.prototype.legId = function () {
        return this._legId;
    };
    CostumeSaver.prototype.hasAcce = function (acceId) {
        return this._acceMap[acceId];
    };
    CostumeSaver.prototype.isKuroChikubi = function () {
        if (this._acceMap[1097]) {
            return true;
        }
        if (this._acceMap[1098]) {
            return false;
        }
        if (this._boteId == 2) {
            return true;
        }
        return false;
    };
    CostumeSaver.prototype.actorId = function () {
        return this._actorId;
    };
    CostumeSaver.prototype.hairId = function () {
        return this._hairId;
    };
    return CostumeSaver;
}());
var CharacterCostume = /** @class */ (function (_super) {
    __extends(CharacterCostume, _super);
    function CharacterCostume() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CharacterCostume.prototype.outerId = function () {
        return $gameActors.actor(this._actorId).outerId;
    };
    CharacterCostume.prototype.innerBottomId = function () {
        return $gameActors.actor(this._actorId).innerBottomId;
    };
    CharacterCostume.prototype.innerTopId = function () {
        return $gameActors.actor(this._actorId).innerTopId;
    };
    CharacterCostume.prototype.legId = function () {
        return $gameActors.actor(this._actorId).legId;
    };
    CharacterCostume.prototype.hoppeId = function () {
        return $gameActors.actor(this._actorId).getAcceHoppeId();
    };
    CharacterCostume.prototype.hairId = function () {
        return $gameActors.actor(this._actorId).hairId();
    };
    return CharacterCostume;
}(CostumeSaver));
var ScenarioEvent = /** @class */ (function () {
    function ScenarioEvent(file, ero, forEro) {
        this.file = file;
        this.ero = ero;
        this.forEro = forEro;
    }
    return ScenarioEvent;
}());
var ALPHA_INTERVAL = 0.04;
var ALPHA_INTERVAL2 = 0.1;
DataManager.setupNewGame = function () {
    this.createGameObjects();
    this.selectSavefileForNewGame();
    $gameParty.setupStartingMembers();
    $gamePlayer.setupForNewGame();
    $gameSystem.setupForNewGame();
    Graphics.frameCount = 0;
};
var Game_System2 = /** @class */ (function (_super) {
    __extends(Game_System2, _super);
    function Game_System2() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._tryCount = 0;
        _this._equipId = 0;
        _this._chokyoTime = 0;
        _this._manAlpha = 1;
        _this._outerAlpha = 1;
        _this._manAlphaOff = false;
        _this._baisyunActorId = 2;
        return _this;
    }
    Game_System2.prototype.initialize = function () {
        _super.prototype.initialize.call(this);
        this._nextId = 0;
        this._lastTroopId = 0;
        this._gameId = this.initGameId();
        this._baisyunManager = new BaisyunManager();
        this._alchemyHistory = new AlchemyHistory();
        this._world = new World();
        this._shopStock = new ShopStock();
    };
    Game_System2.prototype.setupForNewGame = function () {
        $gameSwitches.setValue(Nore.TAIKENBAN_SW, Nore.isTaikenban());
    };
    Game_System2.prototype.isAutosaveEnabled = function () {
        if (this.isRecollection()) {
            // 回想中
            return false;
        }
        if ($gameSwitches.value(44)) {
            // ボス戦
            return false;
        }
        if ($gameSwitches.value(992)) {
            // オートセーブ禁止
            return false;
        }
        if ($gameSystem.stage() == 0) {
            return false;
        }
        if ($gameParty.inBaisyun()) {
            return false;
        }
        if ($gameMap) {
            switch ($gameMap.mapId()) {
                case 1: return false;
            }
        }
        return _super.prototype.isAutosaveEnabled.call(this);
    };
    Game_System2.prototype.initGameId = function () {
        var d = new Date();
        var yy = d.getFullYear();
        var m = d.getMonth() + 1;
        var dd = d.getDay();
        var hh = d.getHours();
        var mm = d.getMinutes();
        var ss = d.getSeconds();
        return yy + '-' + m + '-' + dd + '_' + hh + '_' + mm + '_' + ss;
    };
    Game_System2.prototype.isEventReserved = function (actorId) {
        this._eventReservation = this._eventReservation || {};
        this._eventReservation[actorId] = this._eventReservation[actorId] || [];
        return this._eventReservation[actorId].length > 0;
    };
    Game_System2.prototype.isEroEventReserved = function (actorId) {
        this._eventReservation = this._eventReservation || {};
        this._eventReservation[actorId] = this._eventReservation[actorId] || [];
        if (this._eventReservation[actorId].length === 0) {
            return false;
        }
        return this._eventReservation[actorId][0].ero;
    };
    Game_System2.prototype.endEvent = function (file) {
        this._finishedEvents = this._finishedEvents || {};
        this._finishedEvents[file] = true;
    };
    Game_System2.prototype.restoreEvent = function (file) {
        this._finishedEvents = this._finishedEvents || {};
        //p('restore:' + file + ' ' + this._finishedEvents[file])
        this._finishedEvents[file] = false;
    };
    Game_System2.prototype.isEndEvent = function (file) {
        this._finishedEvents = this._finishedEvents || {};
        return this._finishedEvents[file];
    };
    Game_System2.prototype.getReservedActorEvent = function (actorId) {
        this._eventReservation = this._eventReservation || {};
        this._eventReservation[actorId] = this._eventReservation[actorId] || [];
        if (this._eventReservation[actorId][0]) {
            return this._eventReservation[actorId][0].file;
        }
        return null;
    };
    Game_System2.prototype.reserveActorEvent = function (actorId, scenarioId, ero, forEro) {
        if (this.isEndEvent(scenarioId)) {
            //p('end' + scenarioId)
            return;
        }
        this._eventReservation = this._eventReservation || {};
        this._eventReservation[actorId] = this._eventReservation[actorId] || [];
        this._eventReservation[actorId].push(new ScenarioEvent(scenarioId, ero, forEro));
    };
    Game_System2.prototype.clearReservedEvent = function () {
        this._eventReservation = {};
    };
    Game_System2.prototype.isRecollection = function () {
        return $gameSwitches.value(999);
    };
    Game_System2.prototype.isEroEvent = function () {
        if (this.isRecollection()) {
        }
        return $gameSwitches.value(26);
    };
    Game_System2.prototype.manAlpha = function () {
        return this._manAlpha;
    };
    Game_System2.prototype.upManAlpha = function () {
        if (this._manAlphaOff) {
            return;
        }
        this._manAlpha += ALPHA_INTERVAL;
        this._manAlpha = Math.min(1, this._manAlpha);
    };
    Game_System2.prototype.downManAlpha = function () {
        if (this._manAlphaOff) {
            return;
        }
        this._manAlpha -= ALPHA_INTERVAL;
        this._manAlpha = Math.max(0, this._manAlpha);
    };
    Game_System2.prototype.resetManAlpha = function () {
        this._manAlpha = 1;
    };
    Game_System2.prototype.offManAlpha = function () {
        this.resetManAlpha();
        this._manAlphaOff = true;
    };
    Game_System2.prototype.onManAlpha = function () {
        this._manAlphaOff = false;
    };
    Game_System2.prototype.outerAlpha = function () {
        return 1;
        /*if (ConfigManager.outerTransparentEnabled) {
            return this._outerAlpha;
        } else {
            return 1;
        }*/
    };
    Game_System2.prototype.upOuterAlpha = function () {
        this._outerAlpha += ALPHA_INTERVAL2;
        this._outerAlpha = Math.min(1, this._outerAlpha);
        this.onOuterAlphaChanged();
    };
    Game_System2.prototype.downOuterAlpha = function () {
        this._outerAlpha -= ALPHA_INTERVAL2;
        this._outerAlpha = Math.max(0, this._outerAlpha);
        this.onOuterAlphaChanged();
    };
    Game_System2.prototype.resetOuterAlpha = function () {
        this._outerAlpha = 1;
    };
    Game_System2.prototype.onOuterAlphaChanged = function () {
        for (var _i = 0, _a = $gameParty.outerAlphaMembers(); _i < _a.length; _i++) {
            var actor = _a[_i];
            actor.setCacheChanged();
        }
    };
    Game_System2.prototype.onAfterLoad = function () {
        _super.prototype.onAfterLoad.call(this);
        if (!$gameSwitches.value(996)) {
            this.resetOuterAlpha();
        }
        $gameSwitches.setValue(Nore.TAIKENBAN_SW, Nore.isTaikenban());
    };
    Game_System2.prototype.isCJK = function () {
        if (ConfigManager.language == 'en') {
            return false;
        }
        return _super.prototype.isCJK.call(this);
    };
    Game_System2.prototype.sarachiActorId = function () {
        return $gameVariables.value(128);
    };
    Game_System2.prototype.isEroAcceAllOpened = function () {
        return false;
    };
    Game_System2.prototype.currentPlace = function () {
        return $gameVariables.value(72);
    };
    Game_System2.prototype.difficulty = function () {
        return $gameVariables.value(5);
    };
    Game_System2.prototype.difficultyDamageRate = function () {
        if (this.difficulty() == Difficulty.easy) {
            return 10;
        }
        return 1;
    };
    Game_System2.prototype.difficultyBaisyun = function () {
        return $gameVariables.value(6);
    };
    Game_System2.prototype.isShowRightTachie = function () {
        return $gameSwitches.value(2);
    };
    Game_System2.prototype.isHard = function () {
        return false;
    };
    Game_System2.prototype.baisyunActorId = function () {
        return this._baisyunActorId;
    };
    Game_System2.prototype.baisyunActor = function () {
        return $gameActors.actor(this.baisyunActorId());
    };
    Game_System2.prototype.setBaisyunActorId = function (n) {
        this._baisyunActorId = n;
    };
    Game_System2.prototype.onBaisyunStart = function (actorId) {
        this._baisyunActorId = actorId;
        this._baisyunManager.onBaisyunStart(actorId);
        $gameParty.startBaisyun();
        $gamePlayer.startBaisyun();
    };
    Game_System2.prototype.onBaisyunEnd = function () {
        $gameParty.endBaisyun();
        $gamePlayer.endBaisyun();
    };
    Game_System2.prototype.baisyun = function () {
        return this._baisyunManager.currentBaisyun();
    };
    Game_System2.prototype.alchemyHistory = function () {
        return this._alchemyHistory;
    };
    Game_System2.prototype.offEventSwitch = function () {
        $gameSwitches.setValue(62, false);
    };
    Game_System2.prototype.onDungeonStart = function (dungeonId) {
        var dungeon = this._world.dungeon(dungeonId);
        dungeon.setup();
        this._basket = new Basket(dungeonId);
        $gameVariables.setValue(2, 0);
        $gameVariables.setValue(4, dungeonId);
        var firstRoom = dungeon.roomType(this.floor(), 0);
        this.setRoomType(firstRoom);
        this._dungeonId = dungeonId;
        this._lastTroopId = 0;
    };
    Game_System2.prototype.dungeonId = function () {
        return this._dungeonId;
    };
    Game_System2.prototype.basket = function () {
        return this._basket;
    };
    Game_System2.prototype.floor = function () {
        return $gameVariables.value(2);
    };
    Game_System2.prototype.nextFloor = function () {
        $gameVariables.setValue(2, this.floor() + 1);
    };
    Game_System2.prototype.roomType = function () {
        return this._roomType;
    };
    Game_System2.prototype.setRoomType = function (roomType) {
        this._roomType = roomType;
        for (var i = 291; i < 300; i++) {
            $gameSwitches.setValue(i, false);
        }
        $gameSwitches.setValue(291 + roomType, true);
    };
    Game_System2.prototype.setLastTroopId = function (n) {
        this._lastTroopId = n;
    };
    Game_System2.prototype.lastTroopId = function () {
        return this._lastTroopId;
    };
    Game_System2.prototype.stage = function () {
        return $gameVariables.value(1);
    };
    Game_System2.prototype.baisyunManager = function () {
        return this._baisyunManager;
    };
    Game_System2.prototype.isNight = function () {
        return $gameSwitches.value(3);
    };
    Game_System2.prototype.isMorning = function () {
        return $gameSwitches.value(4);
    };
    Game_System2.prototype.isAfternoon = function () {
        return $gameSwitches.value(5);
    };
    Game_System2.prototype.time = function () {
        if (this.isMorning()) {
            return Time.morning;
        }
        else if (this.isAfternoon()) {
            return Time.afternoon;
        }
        else {
            return Time.night;
        }
    };
    Game_System2.prototype.day = function () {
        return $gameVariables.value(3);
    };
    Game_System2.prototype.world = function () {
        return this._world;
    };
    Game_System2.prototype.shopStock = function () {
        return this._shopStock;
    };
    Game_System2.prototype.isWarpOpen = function () {
        return $gameSwitches.value(55);
    };
    Game_System2.prototype.isKigaeOpen = function () {
        return $gameSwitches.value(72);
    };
    Game_System2.prototype.isDouseiOpen = function () {
        return $gameSwitches.value(DOUSEI_OPEN_SW);
    };
    Game_System2.prototype.mainFontFace = function () {
        if (ConfigManager.font) {
            return _super.prototype.mainFontFace.call(this);
        }
        else {
            return 'latemin';
        }
    };
    Game_System2.prototype.timeSexType = function () {
        var time = Math.floor(Graphics.frameCount / 180);
        return Math.floor(time % 4);
    };
    return Game_System2;
}(Game_System));
