var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command setTaneoya
 * @text 種親を設定する
 * @arg actorId
 * @text actorId
 *
 * @command setSyusanCountVar17
 * @text 回想用。変数17番の出産回数を設定する
 * @arg actorId
 * @text actorId
 * @arg count
 * @text count
 *
 * @command clear
 * @text 回想用。初期化
 * @arg actorId
 * @text actorId
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Syusan';
    var SYUSAN_SATSUKI = 73;
    PluginManager.registerCommand(pluginName, 'setTaneoya', function (args) {
        var actorId = parseInt(args.actorId);
        var actor = $gameActors.actor(actorId);
        var baby = actor.babyHistory().lastBaby();
        var isPatty = baby.fatherId() == 3;
        $gameSwitches.setValue(121, isPatty);
        var isShinpu = baby.fatherId() == 32;
        var isSanzoku = baby.fatherId() == 38;
        $gameSwitches.setValue(122, isShinpu);
        $gameSwitches.setValue(123, isSanzoku);
        $gameSwitches.setValue(SYUSAN_SATSUKI, actorId == 2);
        $gameVariables.setValue(FATHER_ID_VAR, baby.fatherId());
        $gameVariables.setValue(BAISYUN_MAN_ID, baby.fatherId());
        $gameVariables.setValue(NINSHIN_ACOTR_NAME_VAR, baby.fatherId());
        $gameVariables.setValue(FATHER_NAME_VAR, baby.fatherName());
        $gameVariables.setValue(NAME_MAN_NAME_VAR_ID, baby.fatherName());
        $gameVariables.setValue(NINSHIN_COUNT_VAR, actor.babyHistory().countNinshin());
        $gameVariables.setValue(NINSHIN_COUNT_PER_FATHER_VAR, actor.babyHistory().countNinshinPerFather(baby.fatherId()));
    });
    PluginManager.registerCommand(pluginName, 'setSyusanCountVar17', function (args) {
        var actorId = parseInt(args.actorId);
        var actor = $gameActors.actor(actorId);
        var fatherId = $gameVariables.value(17);
        actor.babyHistory().ninshin(fatherId, 1);
        var baby = actor.babyHistory().lastBaby();
        baby.syusan();
    });
    PluginManager.registerCommand(pluginName, 'clear', function (args) {
        var actorId = parseInt(args.actorId);
        var actor = $gameActors.actor(actorId);
        actor.babyHistory().clear();
        actor.setBote(0);
    });
})(Nore || (Nore = {}));
var Sprite_SyusanMan = /** @class */ (function (_super) {
    __extends(Sprite_SyusanMan, _super);
    function Sprite_SyusanMan(manId, event) {
        var _this = _super.call(this, event) || this;
        _this._manId = manId;
        _this._medalLayer = new Sprite_CharacterMedal(manId, 0);
        _this.addChild(_this._medalLayer);
        return _this;
    }
    Sprite_SyusanMan.prototype.updateBitmap = function () {
        if (this.isImageChanged()) {
            this._tilesetId = $gameMap.tilesetId();
            this._tileId = this._character.tileId();
            this._characterName = this.characterName();
            this._characterIndex = this.characterIndex();
            if (this._tileId > 0) {
                this.setTileBitmap();
            }
            else {
                this.setCharacterBitmap();
            }
        }
    };
    Sprite_SyusanMan.prototype.characterName = function () {
        if (this._character.characterName().length == 0) {
            return '';
        }
        return this.actor().actor().characterName;
    };
    Sprite_SyusanMan.prototype.characterIndex = function () {
        if ($gameSwitches.value(462)) {
            return this.actor().actor().characterIndex + 4;
        }
        return this.actor().actor().characterIndex;
    };
    Sprite_SyusanMan.prototype.isImageChanged = function () {
        return (this._characterName !== this._character.characterName() ||
            this._characterIndex !== this.characterIndex());
    };
    Sprite_SyusanMan.prototype.actor = function () {
        return $gameActors.actor(this.actorId());
    };
    Sprite_SyusanMan.prototype.characterBlockX = function () {
        if (this._isBigCharacter) {
            return 0;
        }
        else {
            var index = this._characterIndex;
            return (index % 4) * 3;
        }
    };
    Sprite_SyusanMan.prototype.characterBlockY = function () {
        if (this._isBigCharacter) {
            return 0;
        }
        else {
            var index = this._characterIndex;
            return Math.floor(index / 4) * 4;
        }
    };
    Sprite_SyusanMan.prototype.actorId = function () {
        return this._manId;
    };
    return Sprite_SyusanMan;
}(Sprite_Character));
