var TextSplitter = /** @class */ (function () {
    function TextSplitter() {
        this._bitmap = new Bitmap(10, 10);
    }
    TextSplitter.prototype.split = function (texts, fontSize, width) {
        var results = [];
        this._bitmap.fontSize = fontSize;
        for (var _i = 0, texts_1 = texts; _i < texts_1.length; _i++) {
            var text = texts_1[_i];
            var t = '';
            for (var i = 0; i < text.length; i++) {
                var c = text[i];
                if (this._bitmap.measureTextWidth(t + c) >= width && !this.isNotNewLineChar(c)) {
                    results.push(t);
                    t = c;
                }
                else {
                    t += c;
                }
            }
            results.push(t);
            results.push('');
        }
        return results;
    };
    TextSplitter.prototype.isNotNewLineChar = function (c) {
        switch (c) {
            case '、':
            case '。':
            case '！':
            case '」':
            case '+':
            case ' ':
                return true;
        }
        return false;
    };
    return TextSplitter;
}());
var $textSplitter = new TextSplitter();
