var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var WarpDestination = /** @class */ (function () {
    function WarpDestination(type, enabled) {
        if (enabled === void 0) { enabled = true; }
        this._type = type;
        this._enabled = enabled;
    }
    WarpDestination.prototype.name = function () {
        return getDestinationName(this._type);
    };
    WarpDestination.prototype.type = function () {
        return this._type;
    };
    WarpDestination.prototype.iconIndex = function () {
        switch (this._type) {
            case DestType.alchemy:
                return 220;
            case DestType.exit:
                return 222;
            case DestType.satsuki:
                return 530;
            case DestType.patty:
                return 531;
            case DestType.rosalie:
                return 532;
            case DestType.baby:
                return 218;
            case DestType.baisyun:
                return 190;
        }
        return -1;
    };
    WarpDestination.prototype.enabled = function () {
        return this._enabled;
    };
    return WarpDestination;
}());
var Scene_Warp = /** @class */ (function (_super) {
    __extends(Scene_Warp, _super);
    function Scene_Warp() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_Warp.prototype.create = function () {
        _super.prototype.create.call(this);
        this.createWarpWindow();
        $gameSwitches.setValue(350, true);
    };
    Scene_Warp.prototype.createWarpWindow = function () {
        this._warpWindow = new Window_Warp();
        this.addChild(this._warpWindow);
        this._warpWindow.refresh();
        this._warpWindow.setHandler('ok', this.onOk.bind(this));
        this._warpWindow.setHandler('cancel', this.onCancel.bind(this));
    };
    Scene_Warp.prototype.onOk = function () {
        var item = this._warpWindow.selectedItem();
        var nextPlaceId = item.type();
        if ($gameSystem.currentPlace() == nextPlaceId) {
            this.onCancel();
            return;
        }
        $gameVariables.setValue(73, nextPlaceId);
        $gameTemp.reserveCommonEvent(38);
        SceneManager.pop();
    };
    Scene_Warp.prototype.onCancel = function () {
        $gameSwitches.setValue(20, true);
        SceneManager.pop();
    };
    Scene_Warp.prototype.createCancelButton = function () {
        this._cancelButton = new Sprite_Button2("cancel", true);
        this._cancelButton.x = 782;
        this._cancelButton.y = 42;
        this.addWindow(this._cancelButton);
    };
    ;
    return Scene_Warp;
}(Scene_MenuBase));
var Window_Warp = /** @class */ (function (_super) {
    __extends(Window_Warp, _super);
    function Window_Warp() {
        var _this = this;
        var h = 332;
        if ($gameSwitches.value(385)) {
            h += 52;
        }
        _this = _super.call(this, new Rectangle(430, 110, 424, h)) || this;
        _this._list = [];
        return _this;
    }
    Window_Warp.prototype.makeItemList = function () {
        this._list = [];
        if ($gameSwitches.value(367)) {
            this._list.push(new WarpDestination(DestType.alchemy));
        }
        if ($gameSystem.isNight()) {
            this._list.push(new WarpDestination(DestType.baisyun, this.canBaisyun()));
        }
        else {
            this._list.push(new WarpDestination(DestType.exit, $gameSwitches.value(102)));
        }
        this._list.push(new WarpDestination(DestType.floor2));
        this._list.push(new WarpDestination(DestType.floor1));
        this._list.push(new WarpDestination(DestType.underground));
        if ($gameSwitches.value(385)) {
            this._list.push(new WarpDestination(DestType.baby));
        }
    };
    Window_Warp.prototype.canBaisyun = function () {
        if (!$gameSwitches.value(102)) {
            // 出発可能でない
            return false;
        }
        if ($gameSwitches.value(246)) {
            // サツキHイベントした
            return false;
        }
        if ($gameSwitches.value(162)) {
            // サツキ同棲Hした
            return false;
        }
        return true;
    };
    Window_Warp.prototype.maxCols = function () {
        return 1;
    };
    Window_Warp.prototype.refresh = function () {
        this.makeItemList();
        _super.prototype.refresh.call(this);
        this.select(0);
        this.activate();
    };
    Window_Warp.prototype.maxItems = function () {
        return this._list.length;
    };
    Window_Warp.prototype.lineHeight = function () {
        return 52;
    };
    Window_Warp.prototype.drawItem = function (index) {
        var rect = this.itemRect(index);
        var item = this._list[index];
        if (this.isCurrentPlace(item.type())) {
            this.drawEquip(rect.y + 6);
        }
        this.changePaintOpacity(item.enabled());
        var offset = 40;
        this.contents.textColor = ColorManager.normalColor();
        if (item.type() == DestType.dousei) {
            this.drawDouseiIcon(rect, offset);
        }
        else {
            this.drawIcon2x(item.iconIndex(), rect.x + 16 + 6 + offset, rect.y + 5);
        }
        this.drawText(item.name(), rect.x + 82 + offset, rect.y, 240);
    };
    Window_Warp.prototype.isCurrentPlace = function (type) {
        if ($gameSystem.currentPlace() == type) {
            return true;
        }
        return false;
    };
    Window_Warp.prototype.drawEquip = function (y) {
        var baseTexture = this.getBaseTexture();
        var texture = new PIXI.Texture(baseTexture, new PIXI.Rectangle(0, 36, 40, 36));
        var sprite = new PIXI.Sprite(texture);
        sprite.x = 28;
        sprite.y = y + 12;
        this._windowContentsSprite.addChild(sprite);
    };
    Window_Warp.prototype.drawDouseiIcon = function (rect, offset) {
        var iconList = this.douseiIconIndexList();
        var x = rect.x + 6 + offset;
        var ww = 32;
        switch (iconList.length) {
            case 0: return;
            case 1:
                x += ww * 1.5;
                break;
            case 2:
                x += ww * 1;
                break;
            case 3:
                x += ww * 0.5;
                break;
        }
        for (var _i = 0, iconList_1 = iconList; _i < iconList_1.length; _i++) {
            var icon = iconList_1[_i];
            this.drawIcon(icon, x, rect.y + 14);
            x += 32;
        }
    };
    Window_Warp.prototype.douseiIconIndexList = function () {
        var result = [];
        var actorList = [9, 4, 13, 17];
        for (var _i = 0, actorList_1 = actorList; _i < actorList_1.length; _i++) {
            var actorId = actorList_1[_i];
            var actor = $gameActors.actor(actorId);
            if (actor.dousei().manId() > 0) {
                result.push(actor.iconIndex());
            }
        }
        return result;
    };
    Window_Warp.prototype.selectedId = function () {
        var item = this.selectedItem();
        return item.type();
    };
    Window_Warp.prototype.selectedItem = function () {
        return this._list[this.index()];
    };
    Window_Warp.prototype.isCurrentItemEnabled = function () {
        var item = this.selectedItem();
        return item && item.enabled();
    };
    Window_Warp.prototype.drawLock = function (x, y, isEnabled) {
        if (isEnabled === void 0) { isEnabled = true; }
        var baseTexture = this.getBaseTexture();
        var texture = new PIXI.Texture(baseTexture, new PIXI.Rectangle(0, 103, 40, 36));
        var sprite = new PIXI.Sprite(texture);
        sprite.x = x + 14;
        sprite.y = y + 14;
        if (!isEnabled) {
            sprite.alpha = 0.4;
        }
        this._windowContentsSprite.addChild(sprite);
    };
    Window_Warp.prototype.getBaseTexture = function () {
        var baseTexture = PIXI.utils.BaseTextureCache['system/skill_tree'];
        if (!baseTexture) {
            var bitmap = ImageManager.loadSystem('skill_tree');
            if (!bitmap.isReady()) {
                return;
            }
            baseTexture = new PIXI.BaseTexture(bitmap._image);
            baseTexture.resource.url = 'system/skill_tree';
            PIXI.utils.BaseTextureCache['system/skill_tree'] = baseTexture;
        }
        return baseTexture;
    };
    return Window_Warp;
}(Window_Selectable));
var DestType;
(function (DestType) {
    DestType[DestType["underground"] = 0] = "underground";
    DestType[DestType["floor1"] = 1] = "floor1";
    DestType[DestType["floor2"] = 2] = "floor2";
    DestType[DestType["rosalie"] = 3] = "rosalie";
    DestType[DestType["patty"] = 4] = "patty";
    DestType[DestType["baby"] = 5] = "baby";
    DestType[DestType["alchemy"] = 6] = "alchemy";
    DestType[DestType["exit"] = 7] = "exit";
    DestType[DestType["baisyun"] = 8] = "baisyun";
})(DestType || (DestType = {}));
var _Scene_Map_prototype_updateCallMenu = Scene_Map.prototype.updateCallMenu;
Scene_Map.prototype.updateCallMenu = function () {
    _Scene_Map_prototype_updateCallMenu.call(this);
    if (this.isMenuEnabled()) {
        if (this.isWarpCalled()) {
            this.warpCalling = true;
        }
        if (this.warpCalling && !$gamePlayer.isMoving()) {
            this.callWarp();
        }
    }
    else {
        this.warpCalling = false;
    }
};
Scene_Map.prototype.isWarpCalled = function () {
    if ($gameParty.inBaisyun()) {
        return false;
    }
    if ($gameParty.inDungeon()) {
        return false;
    }
    if (!$gameSystem.isWarpOpen()) {
        return false;
    }
    return Input.isTriggered("pageup") || Input.isTriggered("warp");
};
Scene_Map.prototype.callWarp = function () {
    Input.clear();
    SoundManager.playOk();
    SceneManager.push(Scene_Warp);
    Window_MenuCommand.initCommandPosition();
    $gameTemp.clearDestination();
    this._waitCount = 2;
};
