var Nore;
(function (Nore) {
    var webInfos = {};
    function exportWebpInfo() {
        var fs;
        var path;
        if (Utils.isNwjs()) {
            fs = require('fs');
            path = require('path');
        }
        var fileName = 'Nore_WebpFiles.js';
        var DATA_PATH = function () {
            var p = window.location.pathname.replace(/(\/www|)\/[^\/]*$/, '/img/ero/');
            if (p.match(/^\/([A-Z]\:)/)) {
                p = p.slice(1);
            }
            var result = decodeURIComponent(p);
            if (result[0] == '/') {
                return '.' + result;
            }
            return result;
        }();
        var OUTPUT_PATH = function () {
            var p = window.location.pathname.replace(/(\/www|)\/[^\/]*$/, '/js/plugins/' + fileName);
            if (p.match(/^\/([A-Z]\:)/)) {
                p = p.slice(1);
            }
            var result = decodeURIComponent(p);
            if (result[0] == '/') {
                return '.' + result;
            }
            return result;
        }();
        fs.readdir(DATA_PATH, function (err, files) {
            if (err) {
                console.error(err.message);
                return;
            }
            if (!files) {
                return;
            }
            try {
                for (var _i = 0, files_1 = files; _i < files_1.length; _i++) {
                    var file = files_1[_i];
                    var reg = /ero([0-9]+)_([0-9]+)_([0-9]+)\.json/;
                    var result = (reg.exec(file));
                    if (result) {
                        putWebp(result[1], result[2], result[3]);
                    }
                }
            }
            catch (e) {
                console.error(e);
            }
            writeWebpInfo();
            console.log('js ファイルを更新しました');
        });
        function writeWebpInfo() {
            var json = {};
            for (var key in webInfos) {
                var info = webInfos[key];
                json[key] = info.max;
            }
            fs.writeFileSync(OUTPUT_PATH, 'const WEBP_FILES = ' + JSON.stringify(json));
        }
        function putWebp(actorId, imageId, index) {
            var key = actorId + '_' + imageId;
            if (!webInfos[key]) {
                webInfos[key] = new WebpInfo(key);
            }
            var info = webInfos[key];
            info.putIndex(parseInt(index));
        }
    }
    Nore.exportWebpInfo = exportWebpInfo;
    var WebpInfo = /** @class */ (function () {
        function WebpInfo(imageId) {
            this.imageId = imageId;
            this.max = 0;
        }
        WebpInfo.prototype.putIndex = function (index) {
            if (this.max < index) {
                this.max = index;
            }
        };
        return WebpInfo;
    }());
})(Nore || (Nore = {}));
