/*:ja
 * @target MZ
 * @author ル
 *
 * @command run
 * @text 覗き見イベント
 * @arg actorId
 * @type number
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Zina';
    PluginManager.registerCommand(pluginName, 'run', function (args) {
        var actorId = parseInt(args.actorId);
        var event = new ZinaEvent(actorId);
        var scenario = event.scenario();
        if (!scenario) {
            return;
        }
        var list = $dataScenario[scenario];
        if (!list) {
            throw new Error('id:' + scenario + ' のデータが見つかりません');
        }
        console.log("Scenario \u30B3\u30DE\u30F3\u30C9\u5B9F\u884C: ".concat(scenario));
        $gameTemp.clearDestination();
        this.setupChild(list, this._eventId);
    });
})(Nore || (Nore = {}));
var DOUSEI_BOTE_SW = 85;
var DOUSEI_BOTE_MAN_SW = 76;
var DOUSEI_MAX_MAN_SW = 77;
var RECO_DOUSEI_VAR = 80;
var ZinaEvent = /** @class */ (function () {
    function ZinaEvent(actorId) {
        this._actorId = actorId;
        $gameSwitches.setValue(DOUSEI_BOTE_SW, false);
    }
    ZinaEvent.prototype.scenario = function () {
        var dousei = this.dousei();
        if (dousei.manId() == 0) {
            return this.emptyScenario();
        }
        $gameVariables.setValue(NAME_MAN_NAME_VAR_ID, dousei.manName());
        $gameVariables.setValue(NAME_MAN_VAR_ID, dousei.manId());
        $gameSwitches.setValue(DOUSEI_BOTE_SW, this.isBote());
        if (!dousei.isStartDouseiSex()) {
            return this.notSexScenario();
        }
        $gameSwitches.setValue(DOUSEI_MAX_MAN_SW, this.isMax());
        return this.sexScenario();
    };
    ZinaEvent.prototype.isMax = function () {
        switch ($gameVariables.value(RECO_DOUSEI_VAR)) {
            case 3: return true;
            case 5: return false;
            case 6: return true;
        }
        var actor = $gameActors.actor(this._actorId);
        return actor.friendshipActor().friendshipLevel(this.dousei().manId()).isMax();
    };
    ZinaEvent.prototype.isBote = function () {
        switch ($gameVariables.value(RECO_DOUSEI_VAR)) {
            case 4: return true;
            case 5: return true;
            case 6: return true;
        }
        return $gameActors.actor(this._actorId).boteId > 0;
    };
    ZinaEvent.prototype.emptyScenario = function () {
        switch (this._actorId) {
            case 1: return '覗き見_ロザリー_なし_01';
            case 2: return '覗き見_サツキ_なし_01';
            case 3: return '覗き見_パティ_なし_01';
        }
    };
    ZinaEvent.prototype.notSexScenario = function () {
        var temp = this.notSexTemplate();
        var name = $gameActors.actor(this.dousei().manId()).nameJp();
        var scenario1 = temp.format(name);
        p(scenario1);
        if ($dataScenario[scenario1]) {
            return scenario1;
        }
        p(scenario1 + ' は存在しません');
        var general = '汎用';
        return temp.format(general);
    };
    ZinaEvent.prototype.notSexTemplate = function () {
        switch (this._actorId) {
            case 1: return '覗き見_ロザリー_同棲中_%1_01';
            case 2: return '覗き見_サツキ_同棲中_%1_01';
            case 3: return '覗き見_パティ_同棲中_%1_01';
        }
    };
    ZinaEvent.prototype.sexScenario = function () {
        var boteScenario = this.sexBoteScenario();
        if (boteScenario) {
            return boteScenario;
        }
        var maxScenario = this.sexMaxScenario();
        if (maxScenario) {
            return maxScenario;
        }
        var temp = this.sexTemplate();
        var name = $gameActors.actor(this.dousei().manId()).nameJp();
        var scenario1 = temp.format(name);
        p(scenario1);
        if ($dataScenario[scenario1]) {
            return scenario1;
        }
        p(scenario1 + ' は存在しません');
        var general = '汎用';
        return temp.format(general);
    };
    ZinaEvent.prototype.isFatherIsDouseiMan = function () {
        switch ($gameVariables.value(RECO_DOUSEI_VAR)) {
            case 1:
            case 2:
            case 3:
            case 4:
                return false;
            case 5: return true;
            case 6: return true;
        }
        var actor = $gameActors.actor(this._actorId);
        var baby = actor.babyHistory().lastBaby();
        return baby.fatherId() == this.dousei().manId();
    };
    ZinaEvent.prototype.sexBoteScenario = function () {
        if (!this.isBote()) {
            return null;
        }
        $gameSwitches.setValue(DOUSEI_BOTE_MAN_SW, true);
        if (!this.isFatherIsDouseiMan()) {
            // 種親が別の人
            p('種親が別の人です');
            $gameSwitches.setValue(DOUSEI_BOTE_MAN_SW, false);
            //return null;
        }
        var temp = this.sexBoteTemplate();
        var name = $gameActors.actor(this.dousei().manId()).nameJp();
        var scenario1 = temp.format(name);
        p(scenario1);
        if ($dataScenario[scenario1]) {
            return scenario1;
        }
        return null;
    };
    ZinaEvent.prototype.sexMaxScenario = function () {
        var isMax = this.isMax();
        if (!isMax) {
            return null;
        }
        var temp = this.sexMaxTemplate();
        var name = $gameActors.actor(this.dousei().manId()).nameJp();
        var scenario1 = temp.format(name);
        p(scenario1);
        if ($dataScenario[scenario1]) {
            return scenario1;
        }
        return null;
    };
    ZinaEvent.prototype.sexTemplate = function () {
        switch (this._actorId) {
            case 1: return '覗き見_ロザリー_H中_%1_01';
            case 2: return '覗き見_サツキ_H中_%1_01';
            case 3: return '覗き見_パティ_H中_%1_01';
        }
    };
    ZinaEvent.prototype.sexBoteTemplate = function () {
        switch (this._actorId) {
            case 1: return '覗き見_ロザリー_H中_%1_bote_01';
            case 2: return '覗き見_サツキ_H中_%1_bote_01';
            case 3: return '覗き見_パティ_H中_%1_bote_01';
        }
    };
    ZinaEvent.prototype.sexMaxTemplate = function () {
        switch (this._actorId) {
            case 1: return '覗き見_ロザリー_H中_%1_max_01';
            case 2: return '覗き見_サツキ_H中_%1_max_01';
            case 3: return '覗き見_パティ_H中_%1_max_01';
        }
    };
    ZinaEvent.prototype.dousei = function () {
        return $gameActors.actor(this._actorId).dousei();
    };
    return ZinaEvent;
}());
