// FasterBattle.js Ver.1.0.0
// MIT License (C) 2023 あわやまたな
// http://opensource.org/licenses/mit-license.php

/*:
* @target MZ MV
* @plugindesc 戦闘を高速化します。
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/article/498870606.html
* @help 戦闘スピードが若干早くなります。
* たぶん既存のものより控えめです。
*
* [更新履歴]
* 2023/04/03：Ver.1.0.0　公開
*
*/

'use strict';

{

	const useMZ = Utils.RPGMAKER_NAME === "MZ";

	//-----------------------------------------------------------------------------
	// Spriteset_Battle

	if (useMZ) {
		Spriteset_Battle.prototype.animationBaseDelay = function() {
			return $gameSystem.isSideView() ? Spriteset_Base.prototype.animationBaseDelay.call(this) : 0;
		};

		const _Spriteset_Battle_animationNextDelay = Spriteset_Battle.prototype.animationNextDelay;
		Spriteset_Battle.prototype.animationNextDelay = function() {
			const delay = _Spriteset_Battle_animationNextDelay.call(this);
			return BattleManager._logWindow.isFastForward() ? Math.floor(delay / 3) : delay;
		};
	}

	const _Spriteset_Battle_isEffecting = Spriteset_Battle.prototype.isEffecting;
	Spriteset_Battle.prototype.isEffecting = function() {
		return BattleManager._logWindow.isFastForward() ? false : _Spriteset_Battle_isEffecting.call(this);
	};

	const _Spriteset_Battle_isAnyoneMoving = Spriteset_Battle.prototype.isAnyoneMoving;
	Spriteset_Battle.prototype.isAnyoneMoving = function() {
		return BattleManager._logWindow.isFastForward() ? false : _Spriteset_Battle_isAnyoneMoving.call(this);
	};

	Spriteset_Battle.prototype.isBusy = function() {
		return BattleManager._logWindow.isFastForward() ? false : this.isAnimationPlaying();
	};

	//-----------------------------------------------------------------------------
	// Window_BattleLog

	Window_BattleLog.prototype.messageSpeed = function() {
		return 10;
	};

	if (!useMZ) {
		const _Window_BattleLog_animationBaseDelay = Window_BattleLog.prototype.animationBaseDelay;
		Window_BattleLog.prototype.animationBaseDelay = function() {
			return $gameSystem.isSideView() ? _Window_BattleLog_animationBaseDelay.call(this) : 0;
		};

		const _Window_BattleLog_animationNextDelay = Window_BattleLog.prototype.animationNextDelay;
		Window_BattleLog.prototype.animationNextDelay = function() {
			const delay = _Window_BattleLog_animationNextDelay.call(this)
			return this.isFastForward() ? Math.floor(delay / 3) : delay;
		};
	}

}