//=============================================================================
// RPGツクールMZ ステータス下限撤廃プラグイン
//=============================================================================

/*:
 * @target MZ
 * @plugindesc ステータスの下限を撤廃し、負の値を設定できるプラグインです。

 *
 * @help RPGツクールMZ ステータス下限撤廃プラグイン
 * 
 * このプラグインにプラグインパラメータはありません。
 *
 * このプラグインを有効にすると、アクターおよびエネミーの
 * ステータスの下限が撤廃され負の値を指定できるようになります。
 * ただし、データベース上では直接負の値を指定することはできません。
 * イベントコマンドやスクリプトを使用して負の値を指定できます。
 * 
 * 
 *
 * 注意事項:
 * - 負のステータスはバフによって数値が下がるため、感覚的な矛盾が発生します。
 * - HPを負の値に設定するのは不具合の原因となります。
 *
 *
 *このプラグインはbasu様にご提供いただいたコードをJSファイル化したものです。
 */

(() => {
    // ここにプラグインの実装を追加します

    Game_BattlerBase.prototype.paramBasePlus = function (paramId) {
        return this.paramBase(paramId) + this.paramPlus(paramId);
    };

    Game_BattlerBase.prototype.param = function (paramId) {
        const value = this.paramBasePlus(paramId) * this.paramRate(paramId) * this.paramBuffRate(paramId);
        const maxValue = this.paramMax(paramId);
        return Math.round(value.clamp(value, maxValue));
    };
})();

