/*:
 * @target MZ
 * @plugindesc 能力の強化と弱体化がターン終了時に解除されるようにします。
 * @author RinG(アリンジ)
 *
 * @help
 * 攻撃力や防御力等が強化・弱体化された場合、
 * 本来はアクターが行動終了した直後に解除される仕様になっています。
 * このプラグインを導入すると、これらがターン終了時に解除されるように変更されます。
 * 
 * 【導入方法】
 * 本プラグインを入れるだけです。
 * プラグインパラメータ・プラグインコマンドはありません。
 * 
 * 【利用規約】
 * 利用規約はありません。
 * 商用利用・改変・再配布等ご自由にお使いいただけます。
 * 利用報告等も必要ありません。
 * 
 * このプラグインによって発生したいかなる状況にも責任は負いません。
 * 修正依頼等のサポートも一切受け付けておりません。
 * 
 * 【制作者】
 * RinG（アリンジ）Twitter:RinG_dorane
 * コードを考案したのは制作者では無く、ツクマテの質問に回答してくれた有志の方になります。
 * https://tm.lucky-duet.com/viewtopic.php?f=99&t=12973
 */

(() => {
    "use strict";
  
    Game_Battler.prototype.onAllActionsEnd = function() {
        this.clearResult();
        this.removeStatesAuto(1);
        //this.removeBuffsAuto();
    };
    
    Game_Battler.prototype.onTurnEnd = function() {
        this.clearResult();
        this.regenerateAll();
        this.updateStateTurns();
        this.updateBuffTurns();
        this.removeStatesAuto(2);
        this.removeBuffsAuto();
    };
  
  })();