/* ------------------------------------------------------
 * Copyright (c) 2023 udon
 * Released under the MIT license
 * http://opensource.org/licenses/mit-license.php
 * ------------------------------------------------------*/
/*:
@target MZ
@author udon
@plugindesc
ver.1.0.0
戦闘中のキャラクタースピード変化の影響を、ただちに行動順に反映します。

@help
キャラクタースピードのバフ/デバフによる行動順の変化をただちに反映します。
攻撃力や防御力のバフ/デバフはただちに反映されるため、スピードの変化をその仕様に合わせるプラグインです。

タイムプログレス戦闘を採用する場合には、このプラグインは邪魔になると思います。
その際はプラグインの設定を解除してください。

## ツクールバージョン ##
RPGツクールMZ Version 1.6.1 で動作確認。

## 最終更新日 ##
2023/07/01

## 備考 ##
不具合報告や要望は以下まで連絡いただけると助かります。
https://twitter.com/udon2481
*/

var Imported = Imported || {};
Imported["VblImmediateReorder"] = 1.0;

(() => {
    "use strict";

    const vblBattleManagerUpdateTurn = BattleManager.updateTurn;
    BattleManager.updateTurn = function (timeActive) {
        this.orderActionBattlers();
        vblBattleManagerUpdateTurn.call(this, timeActive);
    };

    // 行動順を更新
    BattleManager.orderActionBattlers = function () {
        for (const battler of this._actionBattlers) {
            battler.makeSpeed();
        }
        this._actionBattlers.sort((a, b) => b.speed() - a.speed());
    };
})();
