//=============================================================================
// VisuStella MZ - Battle Core
// VisuMZ_1_BattleCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_BattleCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.BattleCore = VisuMZ.BattleCore || {};
VisuMZ.BattleCore.version = 1.52;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.52] [BattleCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Battle_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Battle Core plugin revamps the battle engine provided by RPG Maker MZ to
 * become more flexible, streamlined, and support a variety of features. The
 * updated battle engine allows for custom Action Sequences, battle layout
 * styles, and a lot of control over the battle mechanics, too.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Action Sequence Plugin Commands to give you full control over what happens
 *   during the course of a skill or item.
 * * Animated Sideview Battler support for enemies!
 * * Auto Battle options for party-wide and actor-only instances.
 * * Base Troop Events to quickly streamline events for all Troop events.
 * * Battle Command control to let you change which commands appear for actors.
 * * Battle Layout styles to change the way the battle scene looks.
 * * Casting animation support for skills.
 * * Critical Hit control over the success rate formula and damage multipliers.
 * * Custom target scopes added for skills and items.
 * * Damage formula control, including Damage Styles.
 * * Damage caps, both hard caps and soft caps.
 * * Damage traits such Armor Penetration/Reduction to bypass defenses.
 * * Elements & Status Menu Core support for traits.
 * * Multitude of JavaScript notetags and global Plugin Parameters to let you
 *   make a variety of effects across various instances during battle.
 * * Party Command window can be skipped/disabled entirely.
 * * Weather effects now show in battle.
 * * Streamlined Battle Log to remove redundant information and improve the
 *   flow of battle.
 * * Visual HP Gauges can be displayed above the heads of actors and/or enemies
 *   with a possible requirement for enemies to be defeated at least once first
 *   in order for them to show.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin will overwrite some core parts of the RPG Maker MZ base code in
 * order to ensure the Battle Core plugin will work at full capacity. The
 * following are explanations of what has been changed.
 *
 * ---
 *
 * Action Sequences
 *
 * - Action sequences are now done either entirely by the Battle Log Window or
 * through common events if the <Custom Action Sequence> notetag is used.
 * In RPG Maker MZ by default, Action Sequences would be a mixture of using the
 * Battle Log Window, the Battle Manager, and the Battle Scene, making it hard
 * to fully grab control of the situation.
 *
 * ---
 *
 * Action Speed
 *
 * - Action speeds determine the turn order in the default battle system. The
 * AGI of a battle unit is also taken into consideration. However, the random
 * variance applied to the action speed system makes the turn order extremely
 * chaotic and hard for the player to determine. Thus, the random variance
 * aspect of it has been turned off. This can be reenabled by default through
 * Plugin Parameters => Mechanics Settings => Allow Random Speed?
 *
 * ---
 *
 * Animated Sideview Battler Support For Enemies
 *
 * - Enemies can now use Sideview Actor sprites for themselves! They will
 * behave like actors and can even carry their own set of weapons for physical
 * attacks. These must be set up using notetags. More information can be found
 * in the notetag section.
 *
 * - As the sprites are normally used for actors, some changes have been made
 * to Sprite_Actor to be able to support both actors and enemies. These changes
 * should have minimal impact on other plugins.
 *
 * ---
 *
 * Battle Sprite Updates
 *
 * - A lot of functions in Sprite_Battler, Sprite_Actor, and Sprite_Enemy have
 * been overwritten to make the new Action Sequence system added by this plugin
 * possible. These changes make it possible for the sprites to move anywhere on
 * the screen, jump, float, change visibility, and more.
 *
 * ---
 *
 * Change Battle Back in Battle
 * 
 * - By default, the Change Battle Back event command does not work in battle.
 * Any settings made to it will only reflect in the following battle. Now, if
 * the battle back event command is used during battle, it will reflect upon
 * any new changes immediately.
 *
 * ---
 *
 * Critical Hit - LUK Influence
 *
 * - The LUK Buffs now affect the critical hit rate based off how the formula
 * is now calculated. Each stack of a LUK Buff will double the critical hit
 * rate and compound upon that. That means a x1 LUK Buff stack will raise it by
 * x2, a x2 LUK Buff stack will raise the critical hit rate by x4, a x3 LUK
 * Buff Stack will raise the critical hit rate stack by x8, and so on.
 *
 * - LUK also plays a role in how much damage is dealt with critical hits. The
 * default critical hit multiplier has been reduced from x3 to x2. However, a
 * percentage of LUK will added on (based off the user's CRI rate) onto the
 * finalized critical damage. If the user's CRI rate is 4%, then 4% of the user
 * LUK value will also be added onto the damage.
 *
 * - This change can be altered through Plugin Parameters => Damage Settings =>
 * Critical Hits => JS: Rate Formula and JS: Damage Formula.
 *
 * ---
 * 
 * Damage Popups
 * 
 * - Damage popups are now formatted with + and - to determine healing and
 * damage. MP Damage will also include "MP" at the back. This is to make it
 * clearer what each colored variant of the damage popup means as well as help
 * color blind players read the on-screen data properly.
 * 
 * - Damage popups have also been rewritten to show all changed aspects instead
 * of just one. Previously with RPG Maker MZ, if an action would deal both HP
 * and MP damage, only one of them would show. Now, everything is separated and
 * both HP and MP changes will at a time.
 * 
 * ---
 * 
 * Dual Wielding
 * 
 * - Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 * animations at once, with the combined ATK of each weapon. It's confusing to
 * look at and does not portray the nature of "Dual Wielding".
 * 
 * - Dual Wielding, or in the case of users adding in third and fourth weapons,
 * Multi Wielding is now changed. Each weapon is displayed individually, each
 * producing its own attack animation, showing each weapon type, and applying
 * only that weapon's ATK, Traits, and related effects. It is no longer a
 * combined effect to display everything at once like RPG Maker MZ default.
 * 
 * - If an actor has multiple weapon slots but some of them are unequipped,
 * then the action will treat the attack as a single attack. There will be no
 * barehanded attack to add on top of it. This is to match RPG Maker MZ's
 * decision to omit a second animation if the same scenario is applied.
 * 
 * ---
 *
 * Force Action
 *
 * - Previously, Forced Actions would interrupt the middle of an event to
 * perform an action. However, with the addition of more flexible Action
 * Sequences, the pre-existing Force Action system would not be able to exist
 * and would require being remade.
 *
 * - Forced Actions now are instead, added to a separate queue from the action
 * battler list. Whenever an action and/or common event is completed, then if
 * there's a Forced Action battler queued, then the Forced Action battler will
 * have its turn. This is the cleanest method available and avoids the most
 * conflicts possible.
 *
 * - This means if you planned to make cinematic sequences with Forced Actions,
 * you will need to account for the queued Force Actions. However, in the case
 * of battle cinematics, we would highly recommend that you use the newly added
 * Action Sequence Plugin Commands instead as those give you more control than
 * any Force Action ever could.
 *
 * ---
 *
 * Random Scope
 *
 * - The skill and item targeting scopes for Random Enemy, 2 Random Enemies,
 * 3 Random Enemies, 4 Random Enemies will now ignore TGR and utilize true
 * randomness.
 *
 * ---
 *
 * Spriteset_Battle Update
 *
 * - The spriteset now has extra containers to separate battlers (actors and
 * enemies), animations, and damage. This is to make actors and enemy battler
 * sprites more efficient to sort (if enabled), so that animations won't
 * interfere with and cover damage sprites, and to make sure damage sprites are
 * unaffected by screen tints in order to ensure the player will always have a
 * clear read on the information relaying sprites.
 *
 * ---
 * 
 * TPB/ATB Active Battle Actor Shifting
 * 
 * - Pressing cancel on the Actor Command Window no longer switches between
 * actors with a full TPB/ATB gauge before reaching the Party Command Window.
 * This is to accomplish a couple of things: 1) reduce the number of button
 * presses to reach the Party Command Window and 2) to prevent motion resets
 * and disrupting action sequences. If this feature is vital to your battle
 * system, we recommend that you do not use this plugin or any of the Battle
 * Core-required plugins.
 * 
 * ---
 *
 * Weather Displayed in Battle
 *
 * - Previously, weather has not been displayed in battle. This means that any
 * weather effects placed on the map do not transfer over to battle and causes
 * a huge disconnect for players. The Battle Core plugin will add weather
 * effects to match the map's weather conditions. Any changes made to weather
 * through event commands midway through battle will also be reflected.
 *
 * ---
 *
 * ============================================================================
 * Base Troops
 * ============================================================================
 *
 * Base Troops can be found, declared, and modified in the Plugin Parameters =>
 * Mechanics Settings => Base Troop ID's. All of the listed Troop ID's here
 * will have their page events replicated and placed under all other troops
 * found in the database.
 *
 * ---
 *
 * This means that if you have an event that runs on Turn 1 of a Base Troop,
 * then for every troop out there, that same event will also run on Turn 1,
 * as well. This is useful for those who wish to customize their battle system
 * further and to reduce the amount of work needed to copy/paste said event
 * pages into every database troop object manually.
 *
 * ---
 *
 * ============================================================================
 * Damage Styles
 * ============================================================================
 *
 * Damage Styles are a new feature added through the Battle Core plugin. When
 * using certain Battle Styles, you can completely ignore typing in the whole
 * damage formula inside the damage formula input box, and instead, insert
 * either a power amount or a multiplier depending on the Damage Style. The
 * plugin will then automatically calculate damage using that value factoring
 * in ATK, DEF, MAT, MDF values.
 *
 * ---
 *
 * Here is a list of the Damage Styles that come with this plugin by default.
 * You can add in your own and even edit them to your liking.
 * Or just remove them if you want.
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Style          Use Formula As   PH/MA Disparity   Stat Scale   Damage Scale
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Standard       Formula          No                Varies       Varies
 * ArmorScaling   Formula          No                Varies       Varies
 * CT             Multiplier       Yes               Low          Normal
 * D4             Multiplier       No                High         Normal
 * DQ             Multiplier       No                Low          Low
 * FF7            Power            Yes               Low          High
 * FF8            Power            Yes               Medium       Normal
 * FF9            Power            Yes               Low          Normal
 * FF10           Power            Yes               Medium       High
 * MK             Multiplier       No                Medium       Low
 * MOBA           Multiplier       No                Medium       Normal
 * PKMN           Power            No                Low          Normal
 *
 * Use the above chart to figure out which Damage Style best fits your game,
 * if you plan on using them.
 *
 * The 'Standard' style is the same as the 'Manual' formula input, except that
 * it allows for the support of <Armor Penetration> and <Armor Reduction>
 * notetags.
 *
 * The 'Armor Scaling' style allows you to type in the base damage calculation
 * without the need to type in any defending modifiers.
 *
 * NOTE: While these are based off the damage formulas found in other games,
 * not all of them are exact replicas. Many of them are adapted for use in
 * RPG Maker MZ since not all RPG's use the same set of parameters and not all
 * external multipliers function the same way as RPG Maker MZ.
 * 
 * ---
 *
 * Style:
 * - This is what the Damage Style is.
 *
 * Use Formula As:
 * - This is what you insert into the formula box.
 * - Formula: Type in the formula for the action just as you would normally.
 * - Multiplier: Type in the multiplier for the action.
 *     Use float values. This means 250% is typed out as 2.50
 * - Power: Type in the power constant for the action.
 *     Use whole numbers. Type in something like 16 for a power constant.
 * 
 * PH/MA Disparity:
 * - Is there a disparity between how Physical Attacks and Magical Attacks
 *   are calculated?
 * - If yes, then physical attacks and magical attacks will have different
 *   formulas used.
 * - If no, then physical attacks and magical attacks will share similar
 *   formulas for how they're calculated.
 *
 * Stat Scale:
 * - How much should stats scale throughout the game?
 * - Low: Keep them under 100 for the best results.
 * - Medium: Numbers work from low to mid 400's for best results.
 * - High: The numbers really shine once they're higher.
 *
 * Damage Scale:
 * - How much does damage vary depending on small parameter changes?
 * - Low: Very little increase from parameter changes.
 * - Normal: Damage scales close to proportionally with parameter changes.
 * - High: Damage can boost itself drastically with parameter changes.
 *
 * ---
 *
 * To determine what kind of parameters are used for the Damage Styles, they
 * will depend on two things: the action's 'Hit Type' (ie Physical Attack,
 * Magical Attack, and Certain Hit) and the action's 'Damage Type' (ie. Damage,
 * Recovery, or Drain).
 *
 * Certain Hit tends to use whichever value is higher: ATK or MAT, and then
 * ignores the target's defense values. Use Certain Hits for 'True Damage'.
 *
 * Use the chart below to figure out everything else:
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Hit Type      Damage Type   Attacker Parameter   Defender Parameter
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Physical      Damage        ATK                  DEF
 * Magical       Damage        MAT                  MDF
 * Certain Hit   Damage        Larger (ATK, MAT)    -Ignores-
 * Physical      Recover       DEF                  -Ignores-
 * Magical       Recover       MDF                  -Ignores-
 * Certain Hit   Recover       Larger (ATK, MAT)    -Ignores-
 * Physical      Drain         ATK                  DEF
 * Magical       Drain         MAT                  MDF
 * Certain Hit   Drain         Larger (ATK, MAT)    -Ignores-
 *
 * These can be modified within the Plugin Parameters in the individual
 * Damage Styles themselves.
 *
 * ---
 *
 * Skills and Items can use different Damage Styles from the setting you've
 * selected in the Plugin Parameters. They can be altered to have different
 * Damage Styles through the usage of a notetag:
 *
 * <Damage Style: name>
 *
 * This will use whichever style is found in the Plugin Parameters.
 *
 * If "Manual" is used, then no style will be used and all calculations will be
 * made strictly based off the formula found inside the formula box.
 *
 * ---
 *
 * ============================================================================
 * VisuStella MZ Compatibility
 * ============================================================================
 *
 * While this plugin is compatible with the majority of the VisuStella MZ
 * plugin library, it is not compatible with specific plugins or specific
 * features. This section will highlight the main plugins/features that will
 * not be compatible with this plugin or put focus on how the make certain
 * features compatible.
 *
 * ---
 * 
 * VisuMZ_1_BattleCore
 * 
 * When using Action Sequences, Boost effects for damage, turn extensions,
 * analyze, etc. will not occur for anything other than the Action Sequence:
 * "MECH: Action Effect" in order to maintain controlled effects. However, if
 * you do want to apply bonuses for Boosts, utilize "MECH: Boost Store Data" to
 * store inside a variable how many times Boosts were used. This can be used
 * however which way you want it to as long as it is manageable through events
 * and Common Events.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 * 
 * === HP Gauge-Related Notetags ===
 * 
 * The following notetags allow you to set whether or not HP Gauges can be
 * displayed by enemies regardless of Plugin Parameter settings.
 * 
 * ---
 *
 * <Show HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always show the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * - This does not bypass disabling enemy HP Gauges as a whole.
 * 
 * ---
 *
 * <Hide HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always hide the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * 
 * ---
 * 
 * <Battle UI Offset: +x, +y>
 * <Battle UI Offset: -x, -y>
 * 
 * <Battle UI Offset X: +x>
 * <Battle UI Offset X: -x>
 * 
 * <Battle UI Offset Y: +y>
 * <Battle UI Offset Y: -y>
 * 
 * - Used for: Actor and Enemy Notetags
 * - Adjusts the offset of HP Gauges and State Icons above the heads of actors
 *   and enemies.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 *
 * === Animation-Related Notetags ===
 *
 * The following notetags allow you to set animations to play at certain
 * instances and/or conditions.
 *
 * ---
 *
 * <Slip Animation: x>
 *
 * - Requires VisuMZ_0_CoreEngine!
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - During the phase at which the user regenerates HP, MP, or TP, this
 *   animation will play as long as the user is alive and visible.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Cast Animation: x>
 *
 * - Used for: Skill Notetags
 * - Plays a battle animation at the start of the skill.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Attack Animation: x>
 *
 * - Used for: Enemy Notetags
 * - Gives an enemy an attack animation to play for its basic attack.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * === Battleback-Related Notetags ===
 *
 * You can apply these notetags to have some control over the battlebacks that
 * appear in different regions of the map for random or touch encounters.
 *
 * ---
 *
 * <Region x Battleback1: filename>
 * <Region x Battleback2: filename>
 * 
 * - Used for: Map Notetags
 * - If the player starts a battle while standing on 'x' region, then the
 *   'filename' battleback will be used.
 * - Replace 'x' with a number representing the region ID you wish to use.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Castle1.png' will be only inserted
 *   as 'Castle1' without the '.png' at the end.
 * - *NOTE: This will override any specified battleback settings.
 *
 * ---
 *
 * === Battle Command-Related Notetags ===
 *
 * You can use notetags to change how the battle commands of playable
 * characters appear in battle as well as whether or not they can be used.
 *
 * ---
 *
 * <Seal Attack>
 * <Seal Guard>
 * <Seal Item>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Prevents specific battle commands from being able to be used.
 *
 * ---
 *
 * <Battle Commands>
 *  Attack
 *  Skills
 *  SType: x
 *  SType: name
 *  All Skills
 *  Skill: x
 *  Skill: name
 *  Guard
 *  Item
 *  Party
 *  Escape
 *  Auto Battle
 *  Combat Log
 *  Talk
 *  Weapon Swap
 * </Battle Commands>
 *
 * - Used for: Class Notetags
 * - Changes which commands appear in the Actor Command Window in battle.
 *   If this notetag is not used, then the default commands determined in
 *   Plugin Parameters => Actor Command Window => Command List will be used.
 * - Add/remove/modify entries as needed.
 *
 * - Attack 
 *   - Adds the basic attack command.
 * 
 * - Skills
 *   - Displays all the skill types available to the actor.
 * 
 * - SType: x
 * - Stype: name
 *   - Adds in a specific skill type.
 *   - Replace 'x' with the ID of the skill type.
 *   - Replace 'name' with the name of the skill type (without text codes).
 *
 * - All Skills
 *   - Adds all usable battle skills as individual actions.
 * 
 * - Skill: x
 * - Skill: name
 *   - Adds in a specific skill as a usable action.
 *   - Replace 'x' with the ID of the skill.
 *   - Replace 'name' with the name of the skill.
 * 
 * - Guard
 *   - Adds the basic guard command.
 * 
 * - Item
 *   - Adds the basic item command.
 *
 * - Party
 *   - Requires VisuMZ_2_PartySystem.
 *   - Allows this actor to switch out with a different party member.
 * 
 * - Escape
 *   - Adds the escape command.
 * 
 * - Auto Battle
 *   - Adds the auto battle command.
 * 
 * - Combat Log
 *   - Requires VisuMZ_4_CombatLog.
 *   - Opens up the combat log.
 * 
 * - Talk
 *   - Requires VisuMZ_3_BattleCmdTalk!
 *   - Shows talk command if applicable.
 * 
 * - Weapon Swap
 *   - Requires VisuMZ_2_WeaponSwapSystem.
 *   - Swaps the current weapon.
 *
 * Example:
 *
 * <Battle Commands>
 *  Attack
 *  Skill: Heal
 *  Skills
 *  Guard
 *  Item
 *  Escape
 * </Battle Commands>
 *
 * ---
 *
 * <Command Text: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill name text that appears to something else.
 * - Replace 'x' with the skill's name you want to shown in the Actor Battle
 *   Command window.
 * - Recommended Usage: Shorten skill names that are otherwise too big to fit
 *   inside of the Actor Battle Command window.
 *
 * ---
 *
 * <Command Icon: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill icon that appears to something else.
 * - Replace 'x' with the ID of icon you want shown in the Actor Battle Command
 *   window to represent the skill.
 * 
 * ---
 * 
 * <Command Require Learn>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   learned the skill.
 * - Learning the skill is a requirement. Acquiring the skill through traits
 *   does not count as learning the skill.
 * 
 * ---
 * 
 * <Command Require Access>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   access to the skill.
 * - Having access to the skill can come through either learning the skill or
 *   temporarily acquiring it through trait objects.
 * 
 * ---
 * 
 * <Command Show Switch: x>
 * 
 * <Command Show All Switches: x,x,x>
 * <Command Show Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be hidden until all
 *   switches are ON. Then, it would be shown.
 * - If 'Any' notetag variant is used, item will be shown if any of the
 *   switches are ON. Otherwise, it would be hidden.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Command Hide Switch: x>
 * 
 * <Command Hide All Switches: x,x,x>
 * <Command Hide Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be shown until all
 *   switches are ON. Then, it would be hidden.
 * - If 'Any' notetag variant is used, item will be hidden if any of the
 *   switches are ON. Otherwise, it would be shown.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Battle Portrait: filename>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" Battle Layout.
 * - Sets the battle portrait image for the actor to 'filename'.
 * - Replace 'filename' with a picture found within your game project's
 *   img/pictures/ folder. Filenames are case sensitive. Leave out the filename
 *   extension from the notetag.
 * - This will override any menu images used for battle only.
 * 
 * ---
 * 
 * <Battle Portrait Offset: +x, +y>
 * <Battle Portrait Offset: -x, -y>
 * 
 * <Battle Portrait Offset X: +x>
 * <Battle Portrait Offset X: -x>
 * 
 * <Battle Portrait Offset Y: +y>
 * <Battle Portrait Offset Y: -y>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" and "Border" Battle Layouts.
 * - Offsets the X and Y coordinates for the battle portrait.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 * 
 * === JavaScript Notetag: Battle Command-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine if skill-based battle commands are visible or hidden.
 * 
 * ---
 * 
 * <JS Command Visible>
 *  code
 *  code
 *  visible = code;
 * </JS Command Visible>
 * 
 * - Used for: Skill Notetags
 * - The 'visible' variable is the final returned variable to determine the
 *   skill's visibility in the Battle Command Window.
 * - Replace 'code' with JavaScript code to determine the skill's visibility in
 *   the Battle Command Window.
 * - The 'user' variable represents the user who will perform the skill.
 * - The 'skill' variable represents the skill to be used.
 * 
 * ---
 *
 * === Targeting-Related Notetags ===
 *
 * The following notetags are related to the targeting aspect of skills and
 * items and may adjust the scope of how certain skills/items work.
 *
 * ---
 *
 * <Always Hit>
 *
 * <Always Hit Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - Causes the action to always hit or to always have a hit rate of exactly
 *   the marked x%.
 * - Replace 'x' with a number value representing the hit success percentage.
 *
 * ---
 *
 * <Repeat Hits: x>
 *
 * - Used for: Skill, Item Notetags
 * - Changes the number of hits the action will produce.
 * - Replace 'x' with a number value representing the number of hits to incur.
 *
 * ---
 *
 * <Target: x Random Any>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets can be both actors and enemies.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Enemies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets are only enemies.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Allies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets are only actors.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: All Allies But User>
 *
 * - Used for: Skill, Item Notetags
 * - Targets all allies with the exception of the user.
 *
 * ---
 *
 * === JavaScript Notetag: Targeting-Related ===
 *
 * ---
 * 
 * <JS Targets>
 *  code
 *  code
 *  targets = [code];
 * </JS Targets>
 *
 * - Used for: Skill, Item Notetags
 * - The 'targets' variable is an array that is returned to be used as a
 *   container for all the valid action targets.
 * - The 'targets' variable will include the original set of targets determined
 *   by the skill/item's original scale.
 * - If you wish to clear it out, simply do 'targets = []' first.
 * - Replace 'code' with JavaScript code to determine valid targets.
 *
 * ---
 *
 * === Damage-Related Notetags ===
 *
 * ---
 *
 * <Damage Style: name>
 *
 * - Used for: Skill, Item Notetags
 * - Replace 'name' with a Damage Style name to change the way calculations are
 *   made using the damage formula input box.
 * - Names can be found in Plugin Parameters => Damage Settings => Style List
 *
 * ---
 *
 * <Armor Reduction: x>
 * <Armor Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Armor Penetration: x>
 * <Armor Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Magic Reduction: x>
 * <Magic Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Magic Penetration: x>
 * <Magic Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Bypass Damage Cap>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage capped.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage capped.
 *
 * ---
 *
 * <Damage Cap: x>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will declare the hard damage cap to
 *   be the 'x' value.
 * - If used on trait objects, this will raise the affect unit's hard damage
 *   cap to 'x' value. If another trait object has a higher value, use that
 *   value instead.
 *
 * ---
 *
 * <Bypass Soft Damage Cap>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage scaled downward to the soft cap.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage scaled downward to the soft cap.
 *
 * ---
 *
 * <Soft Damage Cap: +x%>
 * <Soft Damage Cap: -x%>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will increase/decrease the action's
 *   soft cap by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 * - If used on trait objects, this will raise the affect unit's soft damage
 *   limit by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 *
 * ---
 *
 * <Unblockable>
 *
 * - Used for: Skill, Item Notetags
 * - Using "Guard" against this skill will not reduce any damage.
 *
 * ---
 *
 * === Critical-Related Notetags ===
 *
 * The following notetags affect skill and item critical hit rates and the
 * critical damage multiplier.
 *
 * ---
 *
 * <Always Critical>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always land a critical hit regardless of the
 *   user's CRI parameter value.
 *
 * ---
 *
 * <Set Critical Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always have a x% change to land a critical hit
 *   regardless of user's CRI parameter value.
 * - Replace 'x' with a percerntage value representing the success rate.
 *
 * ---
 *
 * <Modify Critical Rate: x%>
 * <Modify Critical Rate: +x%>
 * <Modify Critical Rate: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - Modifies the user's CRI parameter calculation for this skill/item.
 * - The 'x%' notetag variant will multiply the user's CRI parameter value
 *   for this skill/item.
 * - The '+x%' and '-x%' notetag variants will incremenetally increase/decrease
 *   the user's CRI parameter value for this skill/item.
 *
 * ---
 *
 * <Modify Critical Multiplier: x%>
 * <Modify Critical Multiplier: +x%>
 * <Modify Critical Multiplier: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the damage multiplier when a critical hit lands.
 * - The 'x%' notetag variant multiply the multiplier to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the multiplier with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * <Modify Critical Bonus Damage: x%>
 * <Modify Critical Bonus Damage: +x%>
 * <Modify Critical Bonus Damage: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the bonus damage added when a critical hit lands.
 * - The 'x%' notetag variant multiply the damage to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the bonus damage with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * === JavaScript Notetags: Critical-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine how critical hit-related aspects are calculated.
 *
 * ---
 *
 * <JS Critical Rate>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate>
 *
 * - Used for: Skill, Item Notetags
 * - The 'rate' variable is the final returned amount to determine the
 *   critical hit success rate.
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the critical hit success rate.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Critical Damage>
 *  code
 *  code
 *  multiplier = code;
 *  bonusDamage = code;
 * </JS Critical Damage>
 *
 * - Used for: Skill, Item Notetags
 * - The 'multiplier' variable is returned later and used as the damage
 *   multiplier used to amplify the critical damage amount.
 * - The 'bonusDamage' variable is returned later and used as extra added
 *   damage for the critical damage amount.
 * - Replace 'code' with JavaScript code to determine how the 'multiplier' and
 *   'bonusDamage' variables are calculated.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * === Action Sequence-Related Notetags ===
 *
 * Action Sequences allow you full control over how a skill and/or item plays
 * through its course. These notetags give you control over various aspects of
 * those Action Sequences. More information is found in the Action Sequences
 * help section.
 *
 * ---
 *
 * <Custom Action Sequence>
 *
 * - Used for: Skill, Item Notetags
 * - Removes all automated Action Sequence parts from the skill.
 * - Everything Action Sequence-related will be done by Common Events.
 * - Insert Common Event(s) into the skill/item's effects list to make use of
 *   the Custom Action Sequences.
 * - This will prevent common events from loading in the Item Scene and Skill
 *   Scene when used outside of battle.
 *
 * ---
 * 
 * <Auto Action Sequence>
 * 
 * - Used for: Skill, Item Notetags
 * - If the Action Sequence Plugin Parameter "Auto Notetag" is enabled, this
 *   plugin will prevent custom action sequences from happening for the skill
 *   or item, and instead, use an Automatic Action Sequence instead.
 * - Ignore this if you have "Auto Notetag" disabled or set to false.
 * 
 * ---
 * 
 * <Common Event: name>
 *
 * - Used for: Skill, Item Notetags
 * - Battle only: calls forth a Common Event of a matching name.
 * - Replace 'name' with the name of a Common Event to call from when this
 *   skill/item is used in battle.
 *   - Remove any \I[x] in the name.
 * - Insert multiple notetags to call multiple Common Events in succession.
 * - This will occur after any Common Event Trait Effects for the skill/item's
 *   database entry.
 * - This is primarily used for users who are reorganizing around their Common
 *   Events and would still like to have their skills/items perform the correct
 *   Action Sequences in case the ID's are different.
 * 
 * ---
 *
 * <Display Icon: x>
 * <Display Text: string>
 *
 * - Used for: Skill, Item Notetags
 * - When displaying the skill/item name in the Action Sequence, determine the
 *   icon and/or text displayed.
 * - Replace 'x' with a number value representing the icon ID to be displayed.
 * - Replace 'string' with a text value representing the displayed name.
 *
 * ---
 * 
 * <Common Event Key: name>
 * <Common Event Keys: name, name, name>
 * 
 * <Common Event Keys>
 *  key
 *  key
 *  key
 * </Common Event Keys>
 * 
 * - Used for: Skill, Item Notetags
 * - Will generate Common Events for the skill/item with a corresponding key.
 * - Replace 'name' with the name of the Common Event's key that you want to
 *   reference. That key will be converted into a Common Event effect for the
 *   skill/item and be treated as an action sequence.
 *   - The notetag variants that use multiple keys will have the keys added in
 *     the order they are listed.
 *   - If keys do not reference any Common Events, no Common Events will be
 *     added for that key.
 * - To mark a Common Event with a key, insert inside a Common Event's name the
 *   [ and ] brackets around the text that will be used as the Common Event's
 *   key text.
 *   - For example, if Common Event's name is "Penta Slash [PENTA]", then the
 *     key used is "PENTA" without the quotes.
 *   - This key could then be referenced by <Common Event Key: PENTA> notetag.
 *   - Do not use commas (,) inside the key text as it will be automatically
 *     removed for the sake of consistency.
 * - This feature is made for make the process of sharing Action Sequences to
 *   become easier without needing to line up Common Event ID's.
 * 
 * ---
 *
 * === Animated Sideview Battler-Related Notetags ===
 *
 * Enemies can use Animated Sideview Actor graphics thanks to this plugin.
 * These notetags give you control over that aspect. Some of these also affect
 * actors in addition to enemies.
 *
 * ---
 *
 * <Sideview Battler: filename>
 *
 * <Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Replaces the enemy's battler graphic with an animated Sideview Actor
 *   graphic found in the img/sv_actors/ folder.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Sideview Battlers>
 *
 * ---
 *
 * <Sideview Anchor: x, y>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets the sprite anchor positions for the sideview sprite.
 * - Replace 'x' and 'y' with numbers depicting where the anchors should be for
 *   the sideview sprite.
 * - By default, the x and y anchors are 0.5 and 1.0.
 *
 * ---
 * 
 * <Sideview Home Offset: +x, +y>
 * <Sideview Home Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, State Notetags
 * - Offsets the sideview actor sprite's home position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * - This notetag will not work if you remove it from the JavaScript code in
 *   Plugin Parameters > Actor > JS:  Home Position
 * 
 * ---
 * 
 * <Sideview Weapon Offset: +x, +y>
 * <Sideview Weapon Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy State Notetags
 * - Offsets the sideview weapon sprite's position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * 
 * ---
 *
 * <Sideview Show Shadow>
 * <Sideview Hide Shadow>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets it so the sideview battler's shadow will be visible or hidden.
 *
 * ---
 * 
 * <Sideview Shadow Scale: x%>
 * <Sideview Shadow Scale: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - This affects both the X and Y scale.
 * 
 * ---
 * 
 * <Sideview Shadow Scale X: x%>
 * <Sideview Shadow Scale X: x.y>
 * 
 * <Sideview Shadow Scale Y: x%>
 * <Sideview Shadow Scale Y: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - These affect their respective X and Y scales separately.
 * 
 * ---
 *
 * <Sideview Collapse>
 * <Sideview No Collapse>
 *
 * - Used for: Enemy Notetags
 * - Either shows the collapse graphic or does not show the collapse graphic.
 * - Collapse graphic means the enemy will 'fade away' once it's defeated.
 * - No collapse graphic means the enemy's corpse will remain on the screen.
 *
 * ---
 *
 * <Sideview Idle Motion: name>
 *
 * <Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Changes the default idle motion for the enemy.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Idle Motions>
 *  walk: 25
 *  wait: 50
 *  guard
 *  victory
 *  abnormal
 * </Sideview Idle Motions>
 *
 * ---
 *
 * <Sideview Size: width, height>
 *
 * - Used for: Enemy Notetags
 * - When using a sideview battler, its width and height will default to the
 *   setting made in Plugin Parameters => Enemy Settings => Size: Width/Height.
 * - This notetag lets you change that value to something else.
 * - Replace 'width' and 'height' with numbers representing how many pixels
 *   wide/tall the sprite will be treated as.
 *
 * ---
 *
 * <Sideview Weapon: weapontype>
 *
 * <Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Give your sideview enemies weapons to use.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Sideview Weapons>
 *
 * ---
 *
 * <traitname Sideview Battler: filename>
 *
 * <traitname Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </traitname Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have a unique appearance.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Male Sideview Battlers>
 *
 * <Female Sideview Battlers>
 *  Actor1_2: 25
 *  Actor1_4: 10
 *  Actor1_6
 *  Actor1_8
 * </Female Sideview Battlers>
 *
 * ---
 *
 * <traitname Sideview Idle Motion: name>
 *
 * <traitname Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </traitname Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique idle motions.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Jolly Sideview Idle Motions>
 *  wait: 25
 *  victory: 10
 *  walk
 * </Jolly Sideview Idle Motions>
 *
 * <Serious Sideview Idle Motions>
 *  walk: 25
 *  guard: 10
 *  wait
 * </Jolly Sideview Idle Motions>
 *
 * ---
 *
 * <traitname Sideview Weapon: weapontype>
 *
 * <traitname Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </traitname Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique weapons.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Male Sideview Weapons>
 *
 * <Female Sideview Weapons>
 *  Dagger: 25
 *  Spear: 25
 *  Cane
 * </Female Sideview Weapons>
 *
 * ---
 *
 * === Enemy-Related Notetags ===
 *
 * ---
 *
 * <Battler Sprite Cannot Move>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to move, jump, and/or float due to
 *   Action Sequences. Useful for rooted enemies.
 *
 * ---
 * 
 * <Battler Sprite Grounded>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to jumping and/or floating due to
 *   Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * ---
 *
 * <Swap Enemies>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Swap Enemies>
 *
 * - Used for: Enemy Notetags
 * - Causes this enemy database object to function as a randomizer for any of
 *   the listed enemies inside the notetag. When the enemy is loaded into the
 *   battle scene, the enemy is immediately replaced with one of the enemies
 *   listed. The randomization is based off the 'weight' given to each of the
 *   enemy 'names'.
 * - Replace 'name' with the database enemy of the enemy you wish to replace
 *   the enemy with.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Swap Enemies>
 *  Bat: 50
 *  Slime: 25
 *  Orc
 *  Minotaur
 * </Swap Enemies>
 *
 * ---
 *
 * === JavaScript Notetags: Mechanics-Related ===
 *
 * These JavaScript notetags allow you to run code at specific instances during
 * battle provided that the unit has that code associated with them in a trait
 * object (actor, class, weapon, armor, enemy, or state). How you use these is
 * entirely up to you and will depend on your ability to understand the code
 * used and driven for each case.
 *
 * ---
 *
 * <JS Pre-Start Battle>
 *  code
 *  code
 *  code
 * </JS Pre-Start Battle>
 *
 * <JS Post-Start Battle>
 *  code
 *  code
 *  code
 * </JS Post-Start Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of battle aimed at the function:
 *   BattleManager.startBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Turn>
 *  code
 *  code
 *  code
 * </JS Pre-Start Turn>
 *
 * <JS Post-Start Turn>
 *  code
 *  code
 *  code
 * </JS Post-Start Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of a turn aimed at the function:
 *   BattleManager.startTurn()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Action>
 *  code
 *  code
 *  code
 * </JS Pre-Start Action>
 *
 * <JS Post-Start Action>
 *  code
 *  code
 *  code
 * </JS Post-Start Action>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action aimed at the function:
 *   BattleManager.startAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Apply>
 *  code
 *  code
 *  code
 * </JS Pre-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Apply as User>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as User>
 *
 * <JS Pre-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Damage>
 *  code
 *  code
 *  code
 * </JS Pre-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Damage as User>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as User>
 *
 * <JS Pre-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Damage>
 *  code
 *  code
 *  code
 * </JS Post-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Damage as User>
 *  code
 *  code
 *  code
 * </JS Post-Damage as User>
 *
 * <JS Post-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Post-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Apply>
 *  code
 *  code
 *  code
 * </JS Post-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Apply as User>
 *  code
 *  code
 *  code
 * </JS Post-Apply as User>
 *
 * <JS Post-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Post-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 *
 * ---
 *
 * <JS Pre-End Action>
 *  code
 *  code
 *  code
 * </JS Pre-End Action>
 *
 * <JS Post-End Action>
 *  code
 *  code
 *  code
 * </JS Post-End Action>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action aimed at the function:
 *   BattleManager.endAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Turn>
 *  code
 *  code
 *  code
 * </JS Pre-End Turn>
 *
 * <JS Post-End Turn>
 *  code
 *  code
 *  code
 * </JS Post-End Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of a turn aimed at the function:
 *   Game_Battler.prototype.onTurnEnd()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Regenerate>
 *  code
 *  code
 *  code
 * </JS Pre-Regenerate>
 *
 * <JS Post-Regenerate>
 *  code
 *  code
 *  code
 * </JS Post-Regenerate>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a unit regenerates HP/MP aimed at the function:
 *   Game_Battler.prototype.regenerateAll()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Victory>
 *  code
 *  code
 *  code
 * </JS Battle Victory>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is won aimed at the function:
 *   BattleManager.processVictory()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Success>
 *  code
 *  code
 *  code
 * </JS Escape Success>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping succeeds aimed at the function:
 *   BattleManager.onEscapeSuccess()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Failure>
 *  code
 *  code
 *  code
 * </JS Escape Failure>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping fails aimed at the function:
 *   BattleManager.onEscapeFailure()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Defeat>
 *  code
 *  code
 *  code
 * </JS Battle Defeat>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is lost aimed at the function:
 *   BattleManager.processDefeat()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Battle>
 *  code
 *  code
 *  code
 * </JS Pre-End Battle>
 *
 * <JS Post-End Battle>
 *  code
 *  code
 *  code
 * </JS Post-End Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when the battle is over aimed at the function:
 *   BattleManager.endBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 * 
 * === Battle Layout-Related Notetags ===
 * 
 * These tags will change the battle layout for a troop regardless of how the
 * plugin parameters are set up normally. Insert these tags in either the
 * noteboxes of maps or the names of troops for them to take effect. If both
 * are present for a specific battle, then priority goes to the setting found
 * in the troop name.
 * 
 * ---
 * 
 * <Layout: type>
 * <Battle Layout: type>
 * 
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Changes the battle layout style used for this specific map or battle.
 * - Replace 'type' with 'default', 'list', 'xp', 'portrait', or 'border'.
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 * 
 * ---
 *
 * ============================================================================
 * Action Sequence - Plugin Commands
 * ============================================================================
 *
 * Skills and items, when used in battle, have a pre-determined series of
 * actions to display to the player as a means of representing what's going on
 * with the action. For some game devs, this may not be enough and they would
 * like to get more involved with the actions themselves.
 *
 * Action Sequences, added through this plugin, enable this. To give a skill or
 * item a Custom Action Sequence, a couple of steps must be followed:
 *
 * ---
 *
 * 1. Insert the <Custom Action Sequence> notetag into the skill or item's
 *    notebox (or else this would not work as intended).
 * 2. Give that skill/item a Common Event through the Effects box. The selected
 *    Common Event will contain all the Action Sequence data.
 * 3. Create the Common Event with Action Sequence Plugin Commands and/or event
 *    commands to make the skill/item do what you want it to do.
 *
 * ---
 *
 * The Plugin Commands added through the Battle Core plugin focus entirely on
 * Action Sequences. However, despite the fact that they're made for skills and
 * items, some of these Action Sequence Plugin Commands can still be used for
 * regular Troop events and Common Events.
 *
 * ---
 *
 * === Action Sequence - Action Sets ===
 *
 * Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * ---
 *
 * ACSET: Setup Action Set
 * - The generic start to most actions.
 *
 *   Display Action:
 *   Immortal: On:
 *   Battle Step:
 *   Wait For Movement:
 *   Cast Animation:
 *   Wait For Animation:
 *   - Use this part of the action sequence?
 *
 * ---
 *
 * ACSET: All Targets Action Set
 * - Affects all targets simultaneously performing the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 * 
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait For Animation:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Each Target Action Set
 * - Goes through each target one by one to perform the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 *
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait Count:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Finish Action
 * - The generic ending to most actions.
 *
 *   Wait For New Line:
 *   Wait For Effects:
 *   Clear Battle Log:
 *   Home Reset:
 *   Wait For Movement:
 *   - Use this part of the action sequence?
 *
 * ---
 * 
 * === Action Sequences - Angle ===
 * 
 * These action sequences allow you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * ANGLE: Change Angle
 * - Changes the camera angle.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Angle:
 *   - Change the camera angle to this many degrees.
 *
 *   Duration:
 *   - Duration in frames to change camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Reset Angle
 * - Reset any angle settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Wait For Angle
 * - Waits for angle changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Animations ===
 *
 * These Action Sequences are related to the 'Animations' that can be found in
 * the Animations tab of the Database.
 *
 * ---
 *
 * ANIM: Action Animation
 * - Plays the animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation
 * - Plays the animation associated with the user's weapon.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation 2+
 * - Plays the animation associated with the user's other weapons.
 * - Plays nothing if there is no other weapon equipped.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Slot:
 *   - Which weapon slot to get this data from?
 *   - Main-hand weapon is weapon slot 1.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Cast Animation
 * - Plays the cast animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Change Battle Portrait
 * - Changes the battle portrait of the actor (if it's an actor).
 * - Can be used outside of battle/action sequences.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *   - Valid units can only be actors.
 *
 *   Filename:
 *   - Select the file to change the actor's portrait to.
 * 
 * ---
 *
 * ANIM: Play at Coordinate
 * - Plays an animation on the screen at a specific x, y coordinate.
 * - Requires VisuMZ_0_CoreEngine!
 * 
 *   Animation ID:
 *   - Plays this animation.
 * 
 *   Coordinates:
 * 
 *     X:
 *     Y:
 *     - X/Y coordinate used for the animation.
 *       You may use JavaScript code.
 * 
 *   Mirror Animation?:
 *   - Mirror the animation?
 * 
 *   Mute Animation?:
 *   - Mute the animation?
 * 
 *   Wait for Completion?:
 *   - Wait the animation to finish before continuing?
 *
 * ---
 *
 * ANIM: Show Animation
 * - Plays the a specific animation on unit(s).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Animation ID:
 *   - Select which animation to play on unit(s).
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Wait For Animation
 * - Causes the interpreter to wait for any animation(s) to finish.
 *
 * ---
 *
 * === Action Sequences - Battle Log ===
 *
 * These Action Sequences are related to the Battle Log Window, the window
 * found at the top of the battle screen.
 *
 * ---
 *
 * BTLOG: Add Text
 * - Adds a new line of text into the Battle Log.
 *
 *   Text:
 *   - Add this text into the Battle Log.
 *   - Text codes allowed.
 * 
 *   Copy to Combat Log?:
 *   - Copies text to the Combat Log.
 *   - Requires VisuMZ_4_CombatLog
 * 
 *     Combat Log Icon:
 *     - What icon would you like to bind to this entry?
 *     - Requires VisuMZ_4_CombatLog
 *
 * ---
 *
 * BTLOG: Clear Battle Log
 * - Clears all the text in the Battle Log.
 *
 * ---
 *
 * BTLOG: Display Action
 * - plays the current action in the Battle Log.
 *
 * ---
 *
 * BTLOG: Pop Base Line
 * - Removes the Battle Log's last added base line and  all text up to its
 *   former location.
 *
 * ---
 *
 * BTLOG: Push Base Line
 * - Adds a new base line to where the Battle Log currently is at.
 *
 * ---
 *
 * BTLOG: Refresh Battle Log
 * - Refreshes the Battle Log.
 *
 * ---
 *
 * BTLOG: UI Show/Hide
 * - Shows or hides the Battle UI (including the Battle Log).
 *
 *   Show/Hide?:
 *   - Shows/hides the Battle UI.
 *
 * ---
 *
 * BTLOG: Wait For Battle Log
 * - Causes the interpreter to wait for the Battle Log to finish.
 *
 * ---
 *
 * BTLOG: Wait For New Line
 * - Causes the interpreter to wait for a new line in the Battle Log.
 *
 * ---
 *
 * === Action Sequences - Camera ===
 *
 * These Action Sequences are battle camera-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * CAMERA: Clamp ON/OFF
 * - Turns battle camera clamping on/off.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Setting:
 *   - Turns camera clamping on/off.
 *
 * ---
 *
 * CAMERA: Focus Point
 * - Focus the battle camera on a certain point in the screen.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   X Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Y Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Focus Target(s)
 * - Focus the battle camera on certain battler target(s).
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Targets:
 *   - Select unit(s) to focus the battle camera on.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Offset
 * - Offset the battle camera from the focus target.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Offset X:
 *   - How much to offset the camera X by.
 *   - Negative: left. Positive: right.
 *
 *   Offset Y:
 *   - How much to offset the camera Y by.
 *   - Negative: up. Positive: down.
 *
 *   Duration:
 *   - Duration in frames for offset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Reset
 * - Reset the battle camera settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Reset Focus?:
 *   - Reset the focus point?
 *
 *   Reset Offset?:
 *   - Reset the camera offset?
 *
 *   Duration:
 *   - Duration in frames for reset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Wait For Camera
 * - Waits for camera changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Dragonbones ===
 *
 * These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * ---
 *
 * DB: Dragonbones Animation
 * - Causes the unit(s) to play a Dragonbones motion animation.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Motion Animation:
 *   - What is the name of the Dragonbones motion animation you wish to play?
 *
 * ---
 *
 * DB: Dragonbones Time Scale
 * - Causes the unit(s) to change their Dragonbones time scale.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Time Scale:
 *   - Change the value of the Dragonbones time scale to this.
 *
 * ---
 *
 * === Action Sequences - Elements ===
 *
 * These Action Sequences can change up the element(s) used for the action's
 * damage calculation midway through an action.
 *
 * They also require the VisuMZ_1_ElementStatusCore plugin to be present in
 * order for them to work.
 *
 * ---
 *
 * ELE: Add Elements
 * - Adds element(s) to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to add onto the action.
 *   - Insert multiple element ID's to add multiple at once.
 *
 * ---
 *
 * ELE: Clear Element Changes
 * - Clears all element changes made through Action Sequences.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 *
 * ELE: Force Elements
 * - Forces only specific element(s) when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to force in the action.
 *   - Insert multiple element ID's to force multiple at once.
 *
 * ---
 *
 * ELE: Null Element
 * - Forces no element to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 * 
 * === Action Sequences - Horror Effects ===
 * 
 * These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 * 
 * ---
 *
 * HORROR: Clear All Filters
 * - Clear all Horror Effects filters on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove Horror Effects for.
 *
 * ---
 *
 * HORROR: Glitch Create
 * - Creates the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Glitch Slices:
 *   - Glitch slices to be used with the target.
 *
 *   Glitch Offset:
 *   - Default offset value.
 *
 *   Glitch Animated?:
 *   - Animate the glitch effect?
 *
 *   Glitch Frequency:
 *   - If animated, how frequent to make the glitch effect?
 *   - Lower = often     Higher = rarer
 *
 *   Glitch Strength:
 *   - If animated, how strong is the glitch effect?
 *   - Lower = weaker     Higher = stronger
 *
 * ---
 *
 * HORROR: Glitch Remove
 * - Removes the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: Noise Create
 * - Creates the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Noise Rate:
 *   - Noise rate to be used with the target.
 *
 *   Noise Animated:
 *   - Animate the noise for the target?
 *
 * ---
 *
 * HORROR: Noise Remove
 * - Removes the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: TV Create
 * - Creates the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   TV Line Thickness:
 *   - Default TV line thickness
 *   - Lower = thinner     Higher = thicker
 *
 *   TV Corner Size:
 *   - Default TV line corner size
 *   - Lower = smaller     Higher = bigger
 *
 *   TV Animated:
 *   - Animate the TV?
 *
 *   TV Speed:
 *   - Speed used to animate the TV if animated
 *   - Lower = slower     Higher = faster
 *
 * ---
 *
 * HORROR: TV Remove
 * - Removes the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 * 
 * === Action Sequences - Impact ===
 * 
 * These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * ---
 *
 * IMPACT: Color Break
 * - Breaks the colors on the screen before reassembling.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Intensity:
 *   - What is the intensity of the color break effect?
 *
 *   Duration:
 *   - What is the duration of the color break effect?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Blur Screen
 * - Creates a motion blur on the whole screen.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Blur Target(s)
 * - Creates a motion blur on selected target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion blur effects for.
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Trail Create
 * - Creates a motion trail effect for the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion trail effects for.
 *
 *   Delay:
 *   - How many frames to delay by when creating a motion trail?
 *   - The higher the delay, the less motion trails there are.
 *
 *   Duration:
 *   - How many frames should the motion trail last?
 *   - What do you want to be its duration?
 *
 *   Hue:
 *   - What do you want to be the hue for the motion trail?
 *
 *   Starting Opacity:
 *   - What starting opacity value do you want for the motion trail?
 *   - Opacity values decrease over time.
 *
 *   Tone:
 *   - What tone do you want for the motion trail?
 *   - Format: [Red, Green, Blue, Gray]
 *
 * ---
 *
 * IMPACT: Motion Trail Remove
 * - Removes the motion trail effect from the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to clear motion trail effects for.
 *
 * ---
 *
 * IMPACT: Shockwave at Point
 * - Creates a shockwave at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to create a shockwave at?
 *   - You can use JavaScript code.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Each Target(s)
 * - Creates a shockwave at each of the target(s) location(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Target(s) Center
 * - Creates a shockwave from the center of the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Zoom Blur at Point
 * - Creates a zoom blur at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to focus the zoom at?
 *   - You can use JavaScript code.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Target(s) Center
 * - Creates a zoom blur at the center of targets.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a zoom blur from.
 *
 *   Target Location:
 *   - Select which part target group to start a zoom blur from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the zoom blur X/Y point by.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * === Action Sequences - Mechanics ===
 *
 * These Action Sequences are related to various mechanics related to the
 * battle system.
 *
 * ---
 *
 * MECH: Action Effect
 * - Causes the unit(s) to take damage/healing from action and incurs any
 *   changes made such as buffs and states.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 * ---
 *
 * MECH: Add Buff/Debuff
 * - Adds buff(s)/debuff(s) to unit(s). 
 * - Determine which parameters are affected and their durations.
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s) and/or debuff(s).
 *
 *   Buff Parameters:
 *   - Select which parameter(s) to buff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Debuff Parameters:
 *   - Select which parameter(s) to debuff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Turns:
 *   - Number of turns to set the parameter(s) buffs to.
 *   - You may use JavaScript code.
 *
 * ---
 *
 * MECH: Add State
 * - Adds state(s) to unit(s).
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s).
 *
 *   States:
 *   - Select which state ID(s) to add to unit(s).
 *   - Insert multiple state ID's to add multiple at once.
 *
 * ---
 * 
 * MECH: Analyze Weakness
 * - Reveal elemental weakness(es) from target(s).
 * - Requires VisuMZ_3_WeaknessDisplay!
 * 
 *   Targets:
 *   - Select unit(s) to reveal elemental weaknesses for.
 * 
 *   Reveal:
 *   - How many elemental weaknesses do you wish to reveal?
 *   - You may use JavaScript code.
 * 
 * ---
 *
 * MECH: Armor Penetration
 * - Adds an extra layer of defensive penetration/reduction.
 * - You may use JavaScript code for any of these.
 *
 *   Armor/Magic Penetration:
 *
 *     Rate:
 *     - Penetrates an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Penetrates a flat amount of armor by this value.
 *
 *   Armor/Magic Reduction:
 *
 *     Rate:
 *     - Reduces an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Reduces a flat amount of armor by this value.
 *
 * ---
 * 
 * MECH: ATB Gauge
 * - Alters the ATB/TPB Gauges.
 * - Requires VisuMZ_2_BattleSystemATB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Charging:
 *   
 *     Charge Rate:
 *     - Changes made to the ATB Gauge if it is currently charging.
 * 
 *   Casting:
 *   
 *     Cast Rate:
 *     - Changes made to the ATB Gauge if it is currently casting.
 *   
 *     Interrupt?:
 *     - Interrupt the ATB Gauge if it is currently casting?
 * 
 * ---
 * 
 * MECH: Boost Points Change
 * - Changes Boost Points for target(s).
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Boost Points for.
 * 
 *   Alter Boost Points By:
 *   - Alters the unit(s) Boost Points.
 *   - Positive for gaining points. Negative for losing points.
 * 
 * ---
 * 
 * MECH: Boost Store Data
 * - Stores the number of Boosts used this action inside a variable.
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Variable ID:
 *   - Which variable do you want to store the data inside?
 * 
 * ---
 * 
 * MECH: Break Shield Change
 * - Changes Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Break Shields for.
 * 
 *   Alter Break Shields By:
 *   - Alters the unit(s) Break Shields.
 *   - Positive for gaining shields. Negative for losing shields.
 * 
 * ---
 * 
 * MECH: Break Shield Reset
 * - Resets Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to reset the Break Shields for.
 * 
 * ---
 * 
 * MECH: BTB Brave Points
 * - Alters the target(s) Brave Points to an exact value.
 * - Requires VisuMZ_2_BattleSystemBTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Alter Brave Points By:
 *   - Alters the target(s) Brave Points.
 *   - Positive for gaining BP.
 *   - Negative for losing BP.
 * 
 * ---
 *
 * MECH: Collapse
 * - Causes the unit(s) to perform its collapse animation if the unit(s)
 *   has died.
 *
 *   Targets:
 *   - Select unit(s) to process a death collapse.
 *
 *   Force Death:
 *   - Force death even if the unit has not reached 0 HP?
 *   - This will remove immortality.
 *
 *   Wait For Effect?:
 *   - Wait for the collapse effect to complete before performing next command?
 *
 * ---
 * 
 * MECH: CTB Order
 * - Alters the CTB Turn Order.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Turn Order for.
 * 
 *   Change Order By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: CTB Speed
 * - Alters the CTB Speed.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Speed for.
 * 
 *   Charge Rate:
 *   - Changes made to the CTB Speed if it is currently charging.
 * 
 *   Cast Rate:
 *   - Changes made to the CTB Speed if it is currently casting.
 * 
 * ---
 * 
 * MECH: Custom Damage Formula
 * - Changes the current action's damage formula to custom.
 * - This will assume the MANUAL damage style.
 * 
 *   Formula:
 *   - Changes the current action's damage formula to custom.
 *   - Use 'default' to revert the damage formula.
 * 
 * ---
 *
 * MECH: Damage Popup
 * - Causes the unit(s) to display the current state of damage received
 *   or healed.
 *
 *   Targets:
 *   - Select unit(s) to prompt a damage popup.
 *
 * ---
 *
 * MECH: Dead Label Jump
 * - If the active battler is dead, jump to a specific label in the
 *   common event.
 *
 *   Jump To Label:
 *   - If the active battler is dead, jump to this specific label in the
 *     common event.
 *
 * ---
 *
 * MECH: Enemy Escape
 * - Causes the enemy unit(s) to escape.
 *
 *   Targets:
 *   - Select unit(s) to escape.
 *
 * ---
 *
 * MECH: ETB Energy Count
 * - Alters the subject team's available Energy Count.
 * - Requires VisuMZ_2_BattleSystemETB!
 *
 *   Energy Count:
 *   - Alters the subject team's available Energy Count.
 *   - Positive for gaining energy. Negative for losing energy.
 *
 * ---
 *
 * MECH: FTB Action Count
 * - Alters the subject team's available Action Count.
 * - Requires VisuMZ_2_BattleSystemFTB!
 *
 *   Action Count:
 *   - Alters the subject team's available Action Count.
 *   - Positive for gaining actions. Negative for losing actions.
 *
 * ---
 *
 * MECH: HP, MP, TP
 * - Alters the HP, MP, and TP values for unit(s).
 * - Positive values for healing. Negative values for damage.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 *   HP, MP, TP:
 *
 *     Rate:
 *     - Changes made to the parameter based on rate.
 *     - Positive values for healing. Negative values for damage.
 *
 *     Flat:
 *     - Flat changes made to the parameter.
 *     - Positive values for healing. Negative values for damage.
 *
 *   Damage Popup?:
 *   - Display a damage popup after?
 *
 * ---
 *
 * MECH: Immortal
 * - Changes the immortal flag of targets. If immortal flag is removed and a
 *   unit would die, collapse that unit.
 *
 *   Targets:
 *   - Alter the immortal flag of these groups. If immortal flag is removed and
 *     a unit would die, collapse that unit.
 *
 *   Immortal:
 *   - Turn immortal flag for unit(s) on/off?
 *
 * ---
 *
 * MECH: Multipliers
 * - Changes the multipliers for the current action.
 * - You may use JavaScript code for any of these.
 *
 *   Critical Hit%:
 *
 *     Rate:
 *     - Affects chance to land a critical hit by this multiplier.
 *
 *     Flat:
 *     - Affects chance to land a critical hit by this flat bonus.
 *
 *   Critical Damage
 *
 *     Rate:
 *     - Affects critical damage by this multiplier.
 *
 *     Flat:
 *     - Affects critical damage by this flat bonus.
 *
 *   Damage/Healing
 *
 *     Rate:
 *     - Sets the damage/healing multiplier for current action.
 *
 *     Flat:
 *     - Sets the damage/healing bonus for current action.
 *
 *   Hit Rate
 *
 *     Rate:
 *     - Affects chance to connect attack by this multiplier.
 *
 *     Flat:
 *     - Affects chance to connect attack by this flat bonus.
 *
 * ---
 * 
 * MECH: Once Parallel
 * - Plays a Common Event parallel to the battle event once without repeating
 *   itself when done.
 * 
 *   Common Event ID:
 *   - The ID of the parallel Common Event to play.
 *   - Does NOT repeat itself when finished.
 *   - When exiting battle scene, all Once Parallels are cleared.
 *   - Once Parallels are not retained upon reentering the scene.
 *   - Once Parallels are not stored in memory and cannot be saved.
 * 
 * ---
 * 
 * MECH: OTB Order
 * - Alters the OTB Turn Order. Best used with single targets.
 * - Requires VisuMZ_2_BattleSystemOTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the OTB Turn Order for.
 * 
 *   Current Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Next Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Follow Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: PTB Alter Cost
 * - Alters the action's cost settings.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Override?:
 *   - Overrides any 'permanent' settings for Changeability?
 * 
 *   Alter Changeability:
 *   - Allow the cost type and value to be changeable?
 * 
 *   Alter Cost Type:
 *   - Change the cost type to this scenario.
 *   - Use 'Unchanged' for no changes.
 * 
 *   Alter Cost Value:
 *   - What is the default action cost for this scenario?
 * 
 *   Priority:
 *   - What is this scenario's priority? Scenario outcomes with equal or lower
 *     priorities cannot override types and costs.
 * 
 * ---
 * 
 * MECH: PTB Conversion
 * - Converts full actions into half actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Conversion Count:
 *   - Converts full actions into half actions.
 *   - If not enough, consume half actions.
 * 
 * ---
 * 
 * MECH: PTB Full/Half Action(s)
 * - Alters the subject team's available Full/Half Actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Full Actions:
 *   - Alters the subject team's available Full Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 *   Half Actions:
 *   - Alters the subject team's available Half Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 * ---
 *
 * MECH: Remove Buff/Debuff
 * - Removes buff(s)/debuff(s) from unit(s). 
 * - Determine which parameters are removed.
 *
 *   Targets:
 *   - Select unit(s) to have the buff(s) and/or debuff(s) removed.
 *
 *   Buff Parameters:
 *   - Select which buffed parameter(s) to remove.
 *
 *   Debuff Parameters:
 *   - Select which debuffed parameter(s) to remove.
 *
 * ---
 *
 * MECH: Remove State
 * - Remove state(s) from unit(s).
 *
 *   Targets:
 *   - Select unit(s) to have states removed from.
 *
 *   States:
 *   - Select which state ID(s) to remove from unit(s).
 *   - Insert multiple state ID's to remove multiple at once.
 *
 * ---
 * 
 * MECH: STB Exploit Effect
 * - Utilize the STB Exploitation mechanics!
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Target(s) Exploited?:
 *   - Exploit the below targets?
 * 
 *     Targets:
 *     - Select unit(s) to become exploited.
 * 
 *     Force Exploitation:
 *     - Force the exploited status?
 * 
 *   User Exploiter?:
 *   - Allow the user to become the exploiter?
 * 
 *     Force Exploitation:
 *     - Force the exploiter status?
 * 
 * ---
 * 
 * MECH: STB Extra Action
 * - Adds an extra action for the currently active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Extra Actions:
 *   - How many extra actions should the active battler gain?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: STB Remove Excess Actions
 * - Removes excess actions from the active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Remove Actions:
 *   - How many actions to remove from the active battler?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: Swap Weapon
 * - Causes the unit(s) to swap their weapon for another.
 * - Requires VisuMZ_2_WeaponSwapSystem!
 * 
 *   Targets:
 *   - Select unit(s) to swap weapons for.
 * 
 *   Weapon Type ID:
 *   - Which weapon type to swap to?
 *   - This is NOT the weapon's ID.
 *   - It's the weapon TYPE.
 * 
 * ---
 * 
 * MECH: Text Popup
 * - Causes the unit(s) to display a text popup.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Text:
 *   - What text do you wish to display?
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 * 
 * MECH: Variable Popup
 * - Causes the unit(s) to display a popup using the data stored inside
 *   a variable.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Variable:
 *   - Get data from which variable to display as a popup?
 * 
 *   Digit Grouping:
 *   - Use digit grouping to separate numbers?
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 *
 * MECH: Wait For Effect
 * - Waits for the effects to complete before performing next command.
 *
 * ---
 *
 * === Action Sequences - Motion ===
 *
 * These Action Sequences allow you the ability to control the motions of
 * sideview sprites.
 *
 * ---
 * 
 * MOTION: Clear Freeze Frame
 * - Clears any freeze frames from the unit(s).
 * 
 *   Targets:
 *   - Select which unit(s) to clear freeze frames for.
 * 
 * ---
 * 
 * MOTION: Freeze Motion Frame
 * - Forces a freeze frame instantly at the selected motion.
 * - Automatically clears with a new motion.
 * 
 *   Targets:
 *   - Select which unit(s) to freeze motions for.
 * 
 *   Motion Type:
 *   - Freeze this motion for the unit(s).
 * 
 *   Frame Index:
 *   - Which frame do you want to freeze the motion on?
 *   - Frame index values start at 0.
 * 
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 * 
 * ---
 *
 * MOTION: Motion Type
 * - Causes the unit(s) to play the selected motion.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 *   Motion Type:
 *   - Play this motion for the unit(s).
 *
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 *
 * ---
 *
 * MOTION: Perform Action
 * - Causes the unit(s) to play the proper motion based on the current action.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 * ---
 *
 * MOTION: Refresh Motion
 * - Cancels any set motions unit(s) has to do and use their most natural
 *   motion at the moment.
 *
 *   Targets:
 *   - Select which unit(s) to refresh their motion state.
 *
 * ---
 *
 * MOTION: Wait By Motion Frame
 * - Creates a wait equal to the number of motion frames passing.
 * - Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 *   Motion Frames to Wait?:
 *   - Each "frame" is equal to the value found in 
 *     Plugin Parameters => Actors => Motion Speed
 *
 * ---
 *
 * === Action Sequences - Movement ===
 *
 * These Action Sequences allow you the ability to control the sprites of
 * actors and enemies in battle.
 *
 * ---
 *
 * MOVE: Battle Step
 * - Causes the unit(s) to move forward past their home position to prepare
 *   for action.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home By Distance
 * - Change unit(s)'s home position by a distance from their current home
 *   position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     change by.
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To Point
 * - Change home position(s) to a target point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to change home position to.
 *
 *     Target Location:
 *     - Select which part target group to change home position to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Face Direction
 * - Causes the unit(s) to face forward or backward.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Direction:
 *   - Select which direction to face.
 *
 * ---
 *
 * MOVE: Face Point
 * - Causes the unit(s) to face a point on the screen.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Face Away From?:
 *   - Face away from the point instead?
 *
 * ---
 *
 * MOVE: Face Target(s)
 * - Causes the unit(s) to face other targets on the screen.
 * - Sideview-only!
 *
 *   Targets (facing):
 *   - Select which unit(s) to change direction.
 *
 *   Targets (destination):
 *   - Select which unit(s) for the turning unit(s) to face.
 *
 *   Face Away From?:
 *   - Face away from the unit(s) instead?
 *
 * ---
 *
 * MOVE: Float
 * - Causes the unit(s) to float above the ground.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make float.
 *
 *   Desired Height:
 *   - Vertical distance to float upward.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total float amount.
 *
 *   Float Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Float?:
 *   - Wait for floating to complete before performing next command?
 *
 * ---
 *
 * MOVE: Home Reset
 * - Causes the unit(s) to move back to their home position(s) and face back to
 *   their original direction(s).
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Jump
 * - Causes the unit(s) to jump into the air.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make jump.
 *
 *   Desired Height:
 *   - Max jump height to go above the ground
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total jump amount.
 *
 *   Wait For Jump?:
 *   - Wait for jumping to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move Distance
 * - Moves unit(s) by a distance from their current position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     move unit(s).
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Point
 * - Moves unit(s) to a designated point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to move.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to move to.
 *
 *     Target Location:
 *     - Select which part target group to move to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Opacity
 * - Causes the unit(s) to change opacity.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change opacity.
 *
 *   Desired Opacity:
 *   - Change to this opacity value.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for opacity change.
 *
 *   Opacity Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Opacity?:
 *   - Wait for opacity changes to complete before performing next command?
 *
 * ---
 *
 * MOVE: Scale/Grow/Shrink
 * - Causes the unit(s) to scale, grow, or shrink?.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change the scale of.
 *
 *   Scale X:
 *   Scale Y:
 *   - What target scale value do you want?
 *   - 1.0 is normal size.
 *
 *   Duration:
 *   - Duration in frames to scale for.
 *
 *   Scale Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Scale?:
 *   - Wait for scaling to complete before performing next command?
 *
 * ---
 *
 * MOVE: Skew/Distort
 * - Causes the unit(s) to skew.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to skew.
 *
 *   Skew X:
 *   Skew Y:
 *   - What variance to skew?
 *   - Use small values for the best results.
 *
 *   Duration:
 *   - Duration in frames to skew for.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew to complete before performing next command?
 *
 * ---
 *
 * MOVE: Spin/Rotate
 * - Causes the unit(s) to spin.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to spin.
 *
 *   Angle:
 *   - How many degrees to spin?
 *
 *   Duration:
 *   - Duration in frames to spin for.
 *
 *   Spin Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 * 
 *   Revert Angle on Finish:
 *   - Upon finishing the spin, revert the angle back to 0.
 *
 *   Wait For Spin?:
 *   - Wait for spin to complete before performing next command?
 *
 * ---
 *
 * MOVE: Wait For Float
 * - Waits for floating to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Jump
 * - Waits for jumping to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Movement
 * - Waits for movement to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Opacity
 * - Waits for opacity changes to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Scale
 * - Waits for scaling to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Skew
 * - Waits for skewing to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Spin
 * - Waits for spinning to complete before performing next command.
 *
 * ---
 * 
 * === Action Sequences - Projectiles ===
 * 
 * Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * ---
 *
 * PROJECTILE: Animation
 * - Create an animation projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Animation ID:
 *     - Determine which animation to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the project's trajectory arc in pixels.
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 * ---
 *
 * PROJECTILE: Icon
 * - Create an icon projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Icon:
 *     - Determine which icon to use as a projectile.
 *       - You may use JavaScript code.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the project's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 * ---
 *
 * PROJECTILE: Picture
 * - Create a picture projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Picture Filename:
 *     - Determine which picture to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the project's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 * ---
 * 
 * === Action Sequences - Skew ===
 * 
 * These action sequences allow you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * SKEW: Change Skew
 * - Changes the camera skew.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Skew X:
 *   - Change the camera skew X to this value.
 *
 *   Skew Y:
 *   - Change the camera skew Y to this value.
 *
 *   Duration:
 *   - Duration in frames to change camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Reset Skew
 * - Reset any skew settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Wait For Skew
 * - Waits for skew changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Target ===
 *
 * If using a manual target by target Action Sequence, these commands will give
 * you full control over its usage.
 *
 * ---
 *
 * TARGET: Current Index
 * - Sets the current index to this value.
 * - Then decide to jump to a label (optional).
 *
 *   Set Index To:
 *   - Sets current targeting index to this value.
 *   - 0 is the starting index of a target group.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Next Target
 * - Moves index forward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Previous Target
 * - Moves index backward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Random Target
 * - Sets index randomly to determine new currernt target.
 * - Then decide to jump to a label (optional).
 *
 *   Force Random?:
 *   - Index cannot be its previous index amount after random.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * === Action Sequences - Weapon ===
 *
 * Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * ---
 *
 * WEAPON: Clear Weapon Slot
 * - Clears the active weapon slot (making others valid again).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to clear the active weapon slot for.
 *
 * ---
 *
 * WEAPON: Next Weapon Slot
 * - Goes to next active weapon slot (making others invalid).
 * - If next slot is weaponless, don't label jump.
 *
 *   Targets:
 *   - Select unit(s) to change the next active weapon slot for.
 *
 * ---
 *
 * WEAPON: Set Weapon Slot
 * - Sets the active weapon slot (making others invalid).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to change the active weapon slot for.
 *
 *   Weapon Slot ID:
 *   - Select weapon slot to make active (making others invalid).
 *   - Use 0 to clear and normalize. You may use JavaScript code.
 *
 * ---
 *
 * === Action Sequences - Zoom ===
 *
 * These Action Sequences are zoom-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ZOOM: Change Scale
 * - Changes the zoom scale.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Scale:
 *   - The zoom scale to change to.
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Reset Zoom
 * - Reset any zoom settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Wait For Zoom
 * - Waits for zoom changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Auto Battle Settings
 * ============================================================================
 *
 * These Plugin Parameter settings allow you to change the aspects added by
 * this plugin that support Auto Battle and the Auto Battle commands.
 *
 * Auto Battle commands can be added to the Party Command Window and/or Actor
 * Command Window. The one used by the Party Command Window will cause the
 * whole party to enter an Auto Battle state until stopped by a button input.
 * The command used by the Actor Command Window, however, will cause the actor
 * to select an action based off the Auto Battle A.I. once for the current turn
 * instead.
 *
 * ---
 *
 * Battle Display
 * 
 *   Message:
 *   - Message that's displayed when Auto Battle is on.
 *     Text codes allowed. %1 - OK button, %2 - Cancel button
 * 
 *   OK Button:
 *   - Text used to represent the OK button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Cancel Button:
 *   - Text used to represent the Cancel button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Background Type:
 *   - Select background type for Auto Battle window.
 *     - 0 - Window
 *     - 1 - Dim
 *     - 2 - Transparent
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the Auto Battle options to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Startup Name:
 *   - Command name of the option.
 * 
 *   Style Name:
 *   - Command name of the option.
 * 
 *   OFF:
 *   - Text displayed when Auto Battle Style is OFF.
 * 
 *   ON:
 *   - Text displayed when Auto Battle Style is ON.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Damage Settings
 * ============================================================================
 *
 * These Plugin Parameters add a variety of things to how damage is handled in
 * battle. These range from hard damage caps to soft damage caps to how damage
 * popups appear, how the formulas for various aspects are handled and more.
 *
 * Damage Styles are also a feature added through this plugin. More information
 * can be found in the help section above labeled 'Damage Styles'.
 *
 * ---
 *
 * Damage Styles
 * 
 *   Default Style:
 *   - Which Damage Style do you want to set as default?
 *   - Use 'Manual' to not use any styles at all.
 *     - The 'Manual' style will not support <Armor Penetration> notetags.
 *     - The 'Manual' style will not support <Armor Reduction> notetags.
 * 
 *   Style List:
 *   - A list of the damage styles available.
 *   - These are used to calculate base damage.
 * 
 *     Name:
 *     - Name of this Damage Style.
 *     -Used for notetags and such.
 * 
 *     JS: Formula:
 *     - The base formula for this Damage Style.
 * 
 *     Items & Equips Core:
 * 
 *       HP Damage:
 *       MP Damage:
 *       HP Recovery:
 *       MP Recovery:
 *       HP Drain:
 *       MP Drain:
 *       - Vocabulary used for this data entry.
 * 
 *       JS: Damage Display:
 *       - Code used the data displayed for this category.
 *
 * ---
 *
 * Damage Cap
 * 
 *   Enable Damage Cap?:
 *   - Put a maximum hard damage cap on how far damage can go?
 *   - This can be broken through the usage of notetags.
 * 
 *   Default Hard Cap:
 *   - The default hard damage cap used before applying damage.
 * 
 *   Enable Soft Cap?:
 *   - Soft caps ease in the damage values leading up to the  hard damage cap.
 *   - Requires hard Damage Cap enabled.
 * 
 *     Base Soft Cap Rate:
 *     - The default soft damage cap used before applying damage.
 * 
 *     Soft Scale Constant:
 *     - The default soft damage cap used before applying damage.
 *
 * ---
 *
 * Popups
 * 
 *   Popup Duration:
 *   - Adjusts how many frames a popup stays visible.
 * 
 *   Newest Popups Bottom:
 *   - Puts the newest popups at the bottom.
 * 
 *   Offset X:
 *   Offset Y:
 *   - Sets how much to offset the sprites by horizontally/vertically.
 * 
 *   Shift X:
 *   Shift Y:
 *   - Sets how much to shift the sprites by horizontally/vertically.
 * 
 *   Shift Y:
 * 
 *   Critical Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Critical Duration:
 *   - Adjusts how many frames a the flash lasts.
 *
 * ---
 *
 * Formulas
 * 
 *   JS: Overall Formula:
 *   - The overall formula used when calculating damage.
 * 
 *   JS: Variance Formula:
 *   - The formula used when damage variance.
 * 
 *   JS: Guard Formula:
 *   - The formula used when damage is guarded.
 *
 * ---
 *
 * Critical Hits
 * 
 *   JS: Rate Formula:
 *   - The formula used to calculate Critical Hit Rates.
 * 
 *   JS: Damage Formula:
 *   - The formula used to calculate Critical Hit Damage modification.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Mechanics Settings
 * ============================================================================
 *
 * Some of the base settings for the various mechanics found in the battle
 * system can be altered here in these Plugin Parameters. Most of these will
 * involve JavaScript code and require you to have to good understanding of
 * how the RPG Maker MZ code works before tampering with it.
 *
 * ---
 *
 * Action Speed
 * 
 *   Allow Random Speed?:
 *   - Allow speed to be randomized base off the user's AGI?
 * 
 *   JS: Calculate:
 *   - Code used to calculate action speed.
 *
 * ---
 *
 * Base Troop
 * 
 *   Base Troop ID's:
 *   - Select the Troop ID(s) to duplicate page events from for all
 *     other troops.
 *   - More information can be found in the dedicated Help section above.
 *
 * ---
 * 
 * Common Events (on Map)
 * 
 *   Pre-Battle Event:
 *   Post-Battle Event:
 *   Victory Event:
 *   Defeat Event:
 *   Escape Success Event:
 *   Escape Fail Event:
 *   - Queued Common Event to run upon meeting the condition.
 *   - Use to 0 to not run any Common Event at all.
 *   - "Post-Battle Event" will always run regardless.
 *   - If any events are running before the battle, they will continue running
 *     to the end first before the queued Common Events will run.
 *   - These common events only run on the map scene. They're not meant to run
 *     in the battle scene.
 *   - If the "Defeat Event" has a common event attached to it, then random
 *     encounters will be changed to allow defeat without being sent to the
 *     Game Over scene. Instead, the game will send the player to the map scene
 *     where the Defeat Event will run.
 *
 * ---
 *
 * Escape
 * 
 *   JS: Calc Escape Ratio:
 *   - Code used to calculate the escape success ratio.
 * 
 *   JS: Calc Escape Raise:
 *   - Code used to calculate how much the escape success ratio raises upon
 *     each failure.
 * 
 * ---
 * 
 * Switches
 * 
 *   Switch: Critical:
 *   - Turns switch ON if the action performs a critical hit.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit lands a critical
 *     hit, then the switch will remain ON for the rest of the action.
 * 
 *   Switch: Miss/Evade:
 *   - Turns switch ON if the action misses/is evaded.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit fails to land,
 *     then the switch will remain ON for the rest of the action.
 * 
 * ---
 * 
 * Variables
 * 
 *   Variable: Damage:
 *   - Variable records target damage during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of damage done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 *   Variable: Healing:
 *   - Variable records target healing during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of healing done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 * ---
 *
 * JS: Battle-Related
 * 
 *   JS: Pre-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Battle Victory:
 *   - Target function: BattleManager.processVictory()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Success:
 *   - Target function: BattleManager.onEscapeSuccess()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Failure:
 *   - Target function: BattleManager.onEscapeFailure()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Battle Defeat:
 *   - Target function: BattleManager.processDefeat()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Turn-Related
 * 
 *   JS: Pre-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Action-Related
 * 
 *   JS: Pre-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Post-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Action:
 *   - Target function: BattleManager.endAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Action:
 *   - DescriTarget function: BattleManager.endAction()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Layout Settings
 * ============================================================================
 *
 * The Battle Layout Settings Plugin Parameter gives you control over the look,
 * style, and appearance of certain UI elements. These range from the way the
 * Battle Status Window presents its information to the way certain windows
 * like the Party Command Window and Actor Command Window appear.
 *
 * ---
 *
 * Battle Layout Style
 * - The style used for the battle layout.
 * 
 *   Default:
 *   - Shows actor faces in Battle Status.
 * 
 *   List:
 *   - Lists actors in Battle Status.
 * 
 *   XP:
 *   - Shows actor battlers in a stretched Battle Status.
 * 
 *   Portrait:
 *   - Shows portraits in a stretched Battle Status.
 * 
 *   Border:
 *   - Displays windows around the screen border.
 *
 * ---
 *
 * List Style
 * 
 *   Show Faces:
 *   - Shows faces in List Style?
 * 
 *   Command Window Width:
 *   - Determine the window width for the Party and Actor Command Windows.
 *   - Affects Default and List Battle Layout styles.
 *
 * ---
 *
 * XP Style
 * 
 *   Command Lines:
 *   - Number of action lines in the Actor Command Window for the XP Style.
 * 
 *   Sprite Height:
 *   - Default sprite height used when if the sprite's height has not been
 *     determined yet.
 * 
 *   Sprite Base Location:
 *   - Determine where the sprite is located on the Battle Status Window.
 *     - Above Name - Sprite is located above the name.
 *     - Bottom - Sprite is located at the bottom of the window.
 *     - Centered - Sprite is centered in the window.
 *     - Top - Sprite is located at the top of the window.
 *
 * ---
 *
 * Portrait Style
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait instead of a face.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Border Style
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait at the edge of the screen.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Skill & Item Windows
 * 
 *   Middle Layout:
 *   - Shows the Skill & Item Windows in mid-screen?
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 *
 * ---
 * 
 * Status Window Elements
 * 
 *   Battler Name:
 *   Gauge 1 (HP):
 *   Gauge 2 (MP):
 *   Gauge 3 (TP):
 *   State Icon:
 *   TPB/ATB Gauge:
 * 
 *     Offset: X/Y:
 *     - Offset this Battle Status Window element's X/Y.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Window Skin:
 * 
 *     Filename:
 *     - Filename used for the Battle Status Window skin.
 *     - Leave this empty to use the default window skin.
 * 
 *     Hide Window Skin?:
 *     - Hide the window skin for the Battle Status Window?
 * 
 *   Selectable Background:
 * 
 *     Hide Selectable BG?:
 *     - Show/Hide the selectable background box for the Battle Status Window?
 * 
 *   Attachments:
 * 
 *     Back Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the back of the Battle
 *         Status Window. Leave empty for none.
 * 
 *       Offset: X/Y:
 *       - Offset this Battle Status Window element's X/Y.
 *       - For X: Negative goes left. Positive goes right.
 *       - For Y: Negative goes up. Positive goes down.
 * 
 *     Front Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the front of the Battle
 *         Status Window. Leave empty for none.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Log Settings
 * ============================================================================
 *
 * These Plugin Parameters give you control over how the Battle Log Window, the
 * window shown at the top of the screen in the battle layout, appears, its
 * various properties, and which text will be displayed.
 *
 * The majority of the text has been disabled by default with this plugin to
 * make the flow of battle progress faster.
 *
 * ---
 *
 * General
 * 
 *   Back Color:
 *   - Use #rrggbb for a hex color.
 * 
 *   Max Lines:
 *   - Maximum number of lines to be displayed.
 * 
 *   Message Wait:
 *   - Number of frames for a usual message wait.
 * 
 *   Text Align:
 *   - Text alignment for the Window_BattleLog.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for the battle log.
 *
 * ---
 *
 * Start Turn
 * 
 *   Show Start Turn?:
 *   - Display turn changes at the start of the turn?
 * 
 *   Start Turn Message:
 *   - Message displayed at turn start.
 *   - %1 - Turn Count
 * 
 *   Start Turn Wait:
 *   - Number of frames to wait after a turn started.
 *
 * ---
 *
 * Display Action
 * 
 *   Show Centered Action?:
 *   - Display a centered text of the action name?
 * 
 *   Show Skill Message 1?:
 *   - Display the 1st skill message?
 * 
 *   Show Skill Message 2?:
 *   - Display the 2nd skill message?
 * 
 *   Show Item Message?:
 *   - Display the item use message?
 *
 * ---
 *
 * Action Changes
 * 
 *   Show Counter?:
 *   - Display counter text?
 * 
 *   Show Reflect?:
 *   - Display magic reflection text?
 * 
 *   Show Substitute?:
 *   - Display substitute text?
 *
 * ---
 *
 * Action Results
 * 
 *   Show No Effect?:
 *   - Display no effect text?
 * 
 *   Show Critical?:
 *   - Display critical text?
 * 
 *   Show Miss/Evasion?:
 *   - Display miss/evasion text?
 * 
 *   Show HP Damage?:
 *   - Display HP Damage text?
 * 
 *   Show MP Damage?:
 *   - Display MP Damage text?
 * 
 *   Show TP Damage?:
 *   - Display TP Damage text?
 *
 * ---
 *
 * Display States
 * 
 *   Show Added States?:
 *   - Display added states text?
 * 
 *   Show Removed States?:
 *   - Display removed states text?
 * 
 *   Show Current States?:
 *   - Display the currently affected state text?
 * 
 *   Show Added Buffs?:
 *   - Display added buffs text?
 * 
 *   Show Added Debuffs?:
 *   - Display added debuffs text?
 * 
 *   Show Removed Buffs?:
 *   - Display removed de/buffs text?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battleback Scaling Settings
 * ============================================================================
 *
 * By default, the battlebacks in RPG Maker MZ scale as if the screen size is
 * a static 816x624 resolution, which isn't always the case. These settings
 * here allow you to dictate how you want the battlebacks to scale for the
 * whole game. These settings CANNOT be changed midgame or per battle.
 *
 * ---
 *
 * Settings
 * 
 *   Default Style:
 *   - The default scaling style used for battlebacks.
 *   - MZ (MZ's default style)
 *   - 1:1 (No Scaling)
 *   - Scale To Fit (Scale to screen size)
 *   - Scale Down (Scale Downward if Larger than Screen)
 *   - Scale Up (Scale Upward if Smaller than Screen)
 * 
 *   JS: 1:1:
 *   JS: Scale To Fit:
 *   JS: Scale Down:
 *   JS: Scale Up:
 *   JS: 1:1:
 *   JS: 1:1:
 *   - This code gives you control over the scaling for this style.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Party Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you control over how the Party Command Window
 * operates in the battle scene. You can turn disable it from appearing or make
 * it so that it doesn't 
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Party Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Party Command Window.
 * 
 *   Fight Icon:
 *   - The icon used for the Fight command.
 * 
 *   Add Auto Battle?:
 *   - Add the "Auto Battle" command to the Command Window?
 * 
 *     Auto Battle Icon:
 *     - The icon used for the Auto Battle command.
 * 
 *     Auto Battle Text:
 *     - The text used for the Auto Battle command.
 * 
 *   Add Options?:
 *   - Add the "Options" command to the Command Window?
 * 
 *     Options Icon:
 *     - The icon used for the Options command.
 * 
 *     Active TPB Message:
 *     - Message that will be displayed when selecting options during the
 *       middle of an action.
 * 
 *   Escape Icon:
 *   - The icon used for the Escape command.
 *
 * ---
 *
 * Access
 * 
 *   Skip Party Command:
 *   - DTB: Skip Party Command selection on turn start.
 *   - TPB: Skip Party Command selection at battle start.
 * 
 *   Disable Party Command:
 *   - Disable the Party Command Window entirely?
 *
 * ---
 *
 * Help Window
 * 
 *   Fight:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 * 
 *   Options:
 *   - Text displayed when selecting the Options command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you to change various aspects regarding the
 * Actor Command Window and how it operates in the battle scene. This ranges
 * from how it appears to the default battle commands given to all players
 * without a custom <Battle Commands> notetag.
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Actor Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Actor Command Window.
 * 
 *   Item Icon:
 *   - The icon used for the Item command.
 * 
 *   Normal SType Icon:
 *   - Icon used for normal skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * 
 *   Magic SType Icon:
 *   - Icon used for magic skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 *
 * ---
 *
 * Battle Commands
 * 
 *   Command List:
 *   - List of battle commands that appear by default if the <Battle Commands>
 *     notetag isn't present.
 *
 *     - Attack 
 *       - Adds the basic attack command.
 * 
 *     - Skills
 *       - Displays all the skill types available to the actor.
 * 
 *     - SType: x
 *     - Stype: name
 *       - Adds in a specific skill type.
 *       - Replace 'x' with the ID of the skill type.
 *       - Replace 'name' with the name of the skill type (without text codes).
 *
 *     - All Skills
 *       - Adds all usable battle skills as individual actions.
 * 
 *     - Skill: x
 *     - Skill: name
 *       - Adds in a specific skill as a usable action.
 *       - Replace 'x' with the ID of the skill.
 *       - Replace 'name' with the name of the skill.
 * 
 *     - Guard
 *       - Adds the basic guard command.
 * 
 *     - Item
 *       - Adds the basic item command.
 * 
 *     - Escape
 *       - Adds the escape command.
 * 
 *     - Auto Battle
 *       - Adds the auto battle command.
 * 
 *     - Party
 *       - Requires VisuMZ_2_PartySystem!
 *       - Switches out the current actor for another.
 * 
 *     - Combat Log
 *       - Requires VisuMZ_4_CombatLog!
 *       - Shows combat log.
 * 
 *     - Talk
 *       - Requires VisuMZ_3_BattleCmdTalk!
 *       - Shows talk command if applicable.
 * 
 *     - Weapon Swap
 *       - Requires VisuMZ_2_WeaponSwapSystem!
 *       - Swaps current weapon for next one.
 * 
 *   Show Command Costs:
 *   - If a battle command has a resource cost, show it?
 *
 * ---
 *
 * Help Window
 * 
 *   Skill Types:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Items:
 *   - Text displayed when selecting the item command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how the sideview battlers behave for
 * the actor sprites. Some of these settings are shared with enemies if they
 * use sideview battler graphics.
 *
 * ---
 *
 * Flinch
 * 
 *   Flinch Distance X:
 *   - The normal X distance when flinching.
 * 
 *   Flinch Distance Y:
 *   - The normal Y distance when flinching.
 * 
 *   Flinch Duration:
 *   - The number of frames for a flinch to complete.
 *
 * ---
 *
 * Sideview Battlers
 * 
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 * 
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 * 
 *   Chant Style:
 *   - What determines the chant motion?
 *   - Hit type or skill type?
 * 
 *   Offset X:
 *   - Offsets X position where actor is positioned.
 *   - Negative values go left. Positive values go right.
 * 
 *   Offset Y:
 *   - Offsets Y position where actor is positioned.
 *   - Negative values go up. Positive values go down.
 * 
 *   Motion Speed:
 *   - The number of frames in between each motion.
 * 
 *   Priority: Active:
 *   - Place the active actor on top of actor and enemy sprites.
 * 
 *   Priority: Actors:
 *   - Prioritize actors over enemies when placing sprites on top of each other
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 * 
 *   JS: Home Position:
 *   - Code used to calculate the home position of actors.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Enemy Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how enemies appear visually in the
 * battle scene. Some of these settings will override the settings used for
 * actors if used as sideview battlers. Other settings include changing up the
 * default attack animation for enemies, how the enemy select window functions,
 * and more.
 *
 * ---
 *
 * Visual
 * 
 *   Attack Animation:
 *   - Default attack animation used for enemies.
 *   - Use <Attack Animation: x> for custom animations.
 * 
 *   Emerge Text:
 *   - Show or hide the 'Enemy emerges!' text at the start of battle.
 * 
 *   Offset X:
 *   - Offsets X position where enemy is positioned.
 *   - Negative values go left. Positive values go right.
 * 
 *   Offset Y:
 *   - Offsets Y position where enemy is positioned.
 *   - Negative values go up. Positive values go down.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 *
 * ---
 *
 * Select Window
 * 
 *   Any: Last Selected:
 *   - Prioritize last selected enemy over front view or sideview settings?
 * 
 *   FV: Right Priority:
 *   - If using frontview, auto select the enemy furthest right.
 * 
 *   SV: Right Priority:
 *   - If using sideview, auto select the enemy furthest right.
 * 
 * ---
 * 
 * Name:
 * 
 *   Legacy Option:
 *   - Use the legacy version (window) or new version (sprite).
 *   - WARNING: Legacy version is no longer supported for bugs.
 *   - Not all settings available here in the Plugin Parameters will be
 *     available to the legacy version (ie Always Visible and Attach States).
 * 
 *   Font Size:
 *   - Font size used for enemy names.
 * 
 *   Name Position:
 * 
 *     Offset X:
 *     Offset Y:
 *     - Offset the enemy name's position by this much.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name: Attach States:
 *   - Attach the enemy's state icon to the enemy name?
 * 
 *     Attach: Offset X:
 *     Attach: Offset Y:
 *     - How much to offset the attached icon's X/Y position by?
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name Visibility:
 * 
 *     Always Hidden:
 *     - Determines if the enemy name will always be visible.
 *     - Highest priority.
 * 
 *     Always Visible:
 *     - Determines if the enemy name will always be visible.
 *     - Medium priority.
 * 
 *     By Selection?:
 *     - Determines the conditions for enemy name visibility.
 *     - Lowest priority.
 *
 * ---
 *
 * Sideview Battlers
 * 
 *   Allow Collapse:
 *   - Causes defeated enemies with SV Battler graphics to "fade away"
 *     when defeated?
 * 
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Motion: Idle:
 *   - Sets default idle animation used by Sideview Battlers.
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Size: Width:
 *   - Default width for enemies that use Sideview Battlers.
 * 
 *   Size: Height:
 *   - Default height for enemies that use Sideview Battlers.
 * 
 *   Weapon Type:
 *   - Sets default weapon type used by Sideview Battlers.
 *   - Use 0 for Bare Hands.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: HP Gauge Settings
 * ============================================================================
 *
 * Settings that adjust the visual HP Gauge displayed in battle.
 *
 * ---
 *
 * Show Gauges For
 * 
 *   Actors:
 *   - Show HP Gauges over the actor sprites' heads?
 *   - Requires SV Actors to be visible.
 * 
 *   Enemies:
 *   - Show HP Gauges over the enemy sprites' heads?
 *   - Can be bypassed with <Hide HP Gauge> notetag.
 * 
 *     Requires Defeat?:
 *     - Requires defeating the enemy once to show HP Gauge?
 *     - Can be bypassed with <Show HP Gauge> notetag.
 * 
 *       Battle Test Bypass?:
 *       - Bypass the defeat requirement in battle test?
 *
 * ---
 *
 * Settings
 * 
 *   Anchor X:
 *   Anchor Y:
 *   - Where do you want the HP Gauge sprite's anchor X/Y to be?
 *     Use values between 0 and 1 to be safe.
 * 
 *   Scale:
 *   - How large/small do you want the HP Gauge to be scaled?
 * 
 *   Offset X:
 *   Offset Y:
 *   - How many pixels to offset the HP Gauge's X/Y by?
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the 'Show HP Gauge' option to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Option Name:
 *   - Command name of the option.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Action Sequence Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters allow you to decide if you want automatic
 * Action Sequences to be used for physical attacks, the default casting
 * animations used, how counters and reflects appear visually, and what the
 * default stepping distances are.
 *
 * ---
 *
 * Automatic Sequences
 * 
 *   Melee Single Target:
 *   - Allow this auto sequence for physical, single target actions?
 * 
 *   Melee Multi Target:
 *   - Allow this auto sequence for physical, multi-target actions?
 *
 * ---
 * 
 * Quality of Life
 * 
 *   Auto Notetag:
 *   - Automatically apply the <Custom Action Sequence> notetag effect to any
 *     item or skill that has a Common Event?
 *   - Any item or skill without a Common Event attached to it will use the
 *     Automatic Action Sequences instead.
 *   - The <Auto Action Sequence> notetag will disable this effect for that
 *     particular skill or item.
 * 
 * ---
 *
 * Cast Animations
 * 
 *   Certain Hit:
 *   - Cast animation for Certain Hit skills.
 * 
 *   Physical:
 *   - Cast animation for Physical skills.
 * 
 *   Magical:
 *   - Cast animation for Magical skills.
 *
 * ---
 *
 * Counter/Reflect
 * 
 *   Counter Back:
 *   - Play back the attack animation used?
 * 
 *   Reflect Animation:
 *   - Animation played when an action is reflected.
 * 
 *   Reflect Back:
 *   - Play back the attack animation used?
 *
 * ---
 *
 * Stepping
 * 
 *   Melee Distance:
 *   - Minimum distance in pixels for Movement Action Sequences.
 * 
 *   Step Distance X:
 *   - The normal X distance when stepping forward.
 * 
 *   Step Distance Y:
 *   - The normal Y distance when stepping forward.
 * 
 *   Step Duration:
 *   - The number of frames for a stepping action to complete.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.52: December 16, 2021
 * * Compatibility Update!
 * ** RPG Maker MZ 1.4.0 compatibility update!
 * *** MV Animations played on screen level will now show up properly in the
 *     center of the screen.
 * 
 * Version 1.51: December 9, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence Plugin Commands added by Arisu:
 * *** MOVE: Change Home By Distance
 * *** MOVE: Change Home To Point
 * *** MOVE: Change Home To Target(s)
 * **** These Plugin Commands allow you to adjust the home position of
 *      battlers in sideview battle.
 * **** This is sideview only!
 * **** This does NOT work with front view!
 * **** For those wondering, going to the options screen, party screen, etc.
 *      won't reset the home positions like regular movement changes do.
 * **** Merry Christmas, Harold-gang!
 * 
 * Version 1.50: November 4, 2021
 * * Bug Fixes!
 * ** <Seal Attack> and <Seal Guard> should no longer be bypassed by
 *    auto-battle status. Fix made by Yanfly.
 * 
 * Version 1.49: October 28, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Action Sequence: MOTION: Freeze Motion Frame will now only show weapons
 *    when using a motion that is named either "attack", "thrust", "swing", or
 *    "missile". Update made by Irina.
 * ** Fail safe added to prevent Scene_Battle going into unsupported scenes
 *    like Scene_Equip and Scene_Skill. Update made by Olivia.
 * * New Feature!
 * ** New Action Sequence Plugin Command added by Arisu and sponsored by Anon:
 * *** MECH: Once Parallel
 * **** Plays a Common Event parallel to the battle event once without
 *      repeating itself when done.
 * **** When exiting battle scene, all Once Parallels are cleared.
 * **** Once Parallels are not retained upon reentering the scene.
 * **** Once Parallels are not stored in memory and cannot be saved.
 * 
 * Version 1.48: October 21, 2021
 * * Feature Update!
 * ** Animations are now played on top of battlers in the Front View XP Battle
 *    Layout appearance. Update made by Irina.
 * ** Battle Log, if decided to be shown, now updates faster. Update by Irina.
 * ** Default Critical Damage Bonus increase is now updated to account for
 *    HP Healing and MP Recovery. To update this, create a new project, with
 *    the newest version of Battle Core installed. Copy over the Plugin
 *    Parameters for the Damage Settings > Critical Hits > JS: Damage Formula
 *    to your own project's version. Update made by Irina.
 * 
 * Version 1.47: October 14, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Feature Update!
 * ** Back attachment sprites are now automatically updated with sprite
 *    battlers to be shifted towards the very back.
 * 
 * Version 1.46: September 23, 2021
 * * Bug Fixes!
 * ** Fixed problem with skills and items without action sequences preventing
 *    actions from occurring. Fix made by Yanfly.
 * 
 * Version 1.45: September 17, 2021
 * * Bug Fixes!
 * ** <JS Pre-End Action> and <JS Post-End Action> effects now have multiple
 *    checks to make sure that they don't launch multiple times when a battler
 *    without actions has a turn after one that does. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence notetags added by Yanfly and Arisu:
 * *** <Common Event Key: name>
 * *** <Common Event Keys: name, name, name>
 * *** <Common Event Keys>
 *      key
 *      key
 *      key
 *     </Common Event Keys>
 * **** Will generate Common Events for the skill/item with a corresponding
 *      key.
 * **** More information will be explained inside of the help file.
 * **** This feature is made for make the process of sharing Action Sequences
 *      to become easier without needing to line up Common Event ID's.
 * 
 * Version 1.44: August 20, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Irina and sponsored by Anon.
 * *** "ANIM: Play at Coordinate"
 * **** Plays an animation on the screen at a specific x, y coordinate even if
 *      there is no sprite attached.
 * **** Requires VisuMZ_0_CoreEngine!
 * 
 * Version 1.43: July 23, 2021
 * * Feature Update!
 * ** Immortality now works different with instant death mechanics. Skill
 *    effects that apply instant death or attack states that apply instant
 *    death will now trigger a flag instead of cancelling immortality. The
 *    flag will remain until immortality is manually cancelled via Action
 *    Sequence and then proc the death effect. This way, animations can remain
 *    to the end with instant death mechanics in mind. This does not affect
 *    script calls.
 * 
 * Version 1.42: July 16, 2021
 * * Bug Fixes!
 * ** Added another fail safe for empty common events used for pre-battle
 *    common events. Fix made by Olivia.
 * 
 * Version 1.41: July 2, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Added entries to <Battle Command> notetags and Plugin Parameters for
 *    "Party", "Combat Log", and "Weapon Swap" which weren't updated before.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * * New Features!
 * ** New Action Sequence added by Arisu:
 * *** MECH: Enemy Escape
 * **** Causes the enemy unit(s) to escape.
 * 
 * Version 1.40: June 25, 2021
 * * Bug Fixes!
 * ** Transformations from static enemies to and from animated SV enemies
 *    should no longer show both sprites. Fix made by Irina.
 * * Compatibility Update
 * ** Compatibility update with RPG Maker MZ 1.3.0+.
 * 
 * Version 1.39: June 18, 2021
 * * Bug Fixes!
 * ** MOVE: Home Reset should no longer trigger an end action function and
 *    cause plugins such as "Boost Action" to malfunction. Fix made by Olivia.
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <Battle Layout: x> Troop Name tags can now work with comment tags. Update
 *    made by Irina.
 * ** Random encounter lists are now better shuffled for more variety with how
 *    the RNG seed works. Update made by Arisu.
 * 
 * Version 1.38: June 11, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Location calculations will now be based off the a battler's base position
 *    in order for animations, popups, and other aspects to line up properly
 *    when scaled. Update made by Irina.
 * ** Plugin Parameters for Enemy Battler Settings > Name have been rearranged
 *    for better organization. Update by Olivia.
 * * New Features!
 * ** New Notetags added by Olivia and sponsored by NSG:
 * *** <Sideview Shadow Scale X: x%>
 * *** <Sideview Shadow Scale X: x.y>
 * *** <Sideview Shadow Scale Y: x%>
 * *** <Sideview Shadow Scale Y: x.y>
 * **** These new notetags allow you to adjust the X and Y scale of the SV
 *      shadow sprite separately.
 * ** New Plugin Parameters added by Olivia and sponsored by NSG:
 * *** Enemy Battler Settings > Name > Name Visibility > Always Hidden
 * *** Enemy Battler Settings > Name > Name Visibility > By Selection?
 * **** Choose to have the names always hidden or by selection.
 * **** These are adjusted on a priority list.
 * 
 * Version 1.37: May 21, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia.
 * *** <Command Require Learn>
 * *** <Command Require Access>
 * **** These two commands determine the visibility of a battle command by
 *      whether or not the skill has been learned or accessible.
 * * Feature Update!
 * ** For those using TPB, each battler's regeneration phase will no longer
 *    tick multiple times in a single frame to prevent irregularities. Update
 *    made by Olivia.
 * 
 * Version 1.36: May 14, 2021
 * * Bug Fixes!
 * ** Reversed an HP/MP regeneration bug that was incorrectly reported for TPB.
 *    Fix made by Olivia.
 * * Documentation Update
 * ** Added "TPB/ATB Active Battle Actor Shifting" to Major Changes section:
 * *** This change has been active since the start of this plugin. It was not
 *     documented until now.
 * *** Pressing cancel on the Actor Command Window no longer switches between
 *     actors with a full TPB/ATB gauge before reaching the Party Command
 *     Window. This is to accomplish a couple of things: 1) reduce the number
 *     of button presses to reach the Party Command Window and 2) to prevent
 *     motion resets and disrupting action sequences. If this feature is vital
 *     to your battle system, we recommend that you do not use this plugin or
 *     any of the Battle Core-required plugins.
 * ** Feature Updates
 * *** Distortion sprite Y calculations will now be rounded upward for better
 *     visuals and prevent odd pixelation effects. Update made by Irina.
 * 
 * Version 1.35: May 7, 2021
 * * Bug Fixes!
 * ** Pre-Battle Common Events without a wait command at the end should no
 *    longer lock up by coincidentally pressing the menu key at the same time.
 *    Fix made by Olivia.
 * * Feature Update!
 * ** Added an extra check for TPB-based battle systems to not run turn end
 *    functions when it's not actually the actual turn end timing. Update made
 *    by Olivia.
 * ** "Damage Styles" plugin parameters are now moved to the top of the
 *    Damage Settings category. This should make it easier to acknowledge the
 *    existence of and not have it be an unknown entity. Update made by Irina.
 * 
 * Version 1.34: April 23, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Uses a better algorithm for determining shadow positioning. Update made
 *    by Olivia.
 * * New Features!
 * ** New additions made for Projectile action sequences.
 * ** "Start Location" and "Goal Location" now have "Target Location" parameter
 *    to determine which part of the target's body to send the projectile from
 *    or towards. Added by Olivia.
 * ** Requires VisuMZ_1_BattleCore version 1.34 to have affect.
 * 
 * Version 1.33: April 9, 2021
 * * Bug Fixes!
 * ** Skill costs should now be displayed on battle commands again. Bug fix
 *    made by Olivia.
 * ** Pre-Battle Common Events should no longer cause stalling when used with
 *    specific event commands. Bug fix made by Olivia.
 * * Compatibility Update!
 * ** Added "Weapon Swap" to the list of battle commands that can be added.
 * * Documentation Update!
 * ** Added "Weapon Swap" and "Combat Log" to the list of <Battle Commands> in
 *    the notetags section.
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia:
 * *** <Sideview Shadow Scale: x%> and <Sideview Shadow Scale: x.y>
 * **** Used for: Actor, Enemy Notetags
 * **** Adjusts the scaling size of the sideview battler's shadow.
 * 
 * Version 1.32: April 2, 2021
 * * Feature Update!
 * ** Sideview battler sprites when using front view will now factor in the
 *    window padding and appear properly centered to their focus point. Update
 *    made by Olivia.
 * 
 * Version 1.31: March 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Added "VisuStella MZ Compatibility" section for detailed compatibility
 *    explanations with the VisuMZ_3_BoostAction plugin.
 * 
 * Version 1.30: March 19, 2021
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <JS Targets> is now updated to include the default set of targets
 *    selected by the skill/item's original scope. Update made by Yanfly.
 * *** If you wish to clear it out, simply do 'targets = []' first.
 * 
 * Version 1.29: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Enemy Battler Settings > Name > Legacy Option
 * **** Use the legacy version (window) or new version (sprite).
 * **** WARNING: Legacy version is no longer supported for bugs.
 * **** Not all settings available here in the Plugin Parameters will be
 *      available to the legacy version (ie Always Visible and Attach States).
 * 
 * Version 1.28: March 5, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Plugin Parameters > Actor Command > Show Command Costs
 * **** If you don't want to show skill costs for your commands in the Actor
 *      Command Window, you can now hide them.
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battle Layout Settings > Status Window Elements
 * *** Battle Layout Settings > Status Window Elements > Battler Name
 * *** Battle Layout Settings > Status Window Elements > Gauge 1 (HP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 2 (MP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 3 (TP)
 * *** Battle Layout Settings > Status Window Elements > State Icon
 * *** Battle Layout Settings > Status Window Elements > TPB/ATB Gauge
 * **** These new Plugin Parameters allow you to offset the positions of the
 *      various Battle Status Window elements. Their base positions will be
 *      calculated by the Battle Layout used and then offset from there.
 * *** Battle Layout Settings > Status Window Elements > Window Skin
 * **** These settings allow you to set a specific window skin for the
 *      Battle Status Window or hide it from view completely.
 * *** Battle Layout Settings > Status Window Elements > Selectable Background
 * **** This option allows you to hide the black box that comes with the
 *      majority of selectable elements found in RPG Maker MZ in case it does
 *      not fit with how you want the Battle Status Window to look.
 * *** Battle Layout Settings > Status Window Elements > Back Attachment
 * *** Battle Layout Settings > Status Window Elements > Front Attachment
 * **** These settings allow you to attach images to the back/front of the
 *      Battle Status Window from the img/system/ folder.
 * **** You may offset X and Y positions for them as well.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > Enemy Settings > Name: Always Visible
 * **** Determines if the enemy name will always be visible.
 * *** Plugin Parameters > Enemy Settings > Name: Attach States
 * **** Attach the enemy's state icon to the enemy name?
 * *** Plugin Parameters > Enemy Settings > Attach: Offset X/Y
 * **** Offset the attached state icon's position.
 * * Feature Update!
 * ** Switched drawing enemy names on the screen from window to sprite to
 *    reduce lag and for better screen positioning accuracy especially during
 *    screen zooming. Update by Olivia.
 * 
 * Version 1.27: February 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Critical
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Miss/Evade
 * **** Turns Switches ON if the action performs a critical hit, misses, or is
 *      evaded at any point.
 * **** Switch reverts to OFF whenever an action starts.
 * **** If multiple targets/hits are struck, as long as one hit respectively
 *      lands a critical hit, fails to land, then the switch will remain ON for
 *      the rest of the action.
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Damage
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Healing
 * **** Variable records target damage/healing during action.
 * **** Variable reverts to 0 whenever an action starts.
 * **** If multiple targets/hits are struck, the variable will record the total
 *      amount of damage/healing done for the remainder of the action (unless
 *      manually reseting to 0 during an Action Sequence).
 * 
 * Version 1.26: February 19, 2021
 * * Bug Fixes!
 * ** Battles with branching event paths found within a conditional branch or
 *    choice tree will no longer be skipped over. Fix made by Arisu.
 * * Compatibility Update
 * ** Returning to the battle scene from the options scene in a Tpb-base battle
 *    system now links the current actor. Update by Irina.
 * 
 * Version 1.25: February 5, 2021
 * * Compatibility Update
 * ** Added compatibility update with VisuStella MZ Skills and States Core's
 *    Plugin Parameter > State Settings > Action End Update
 * * Feature Update!
 * ** <Common Event: name> notetag no longer requires <Custom Action Sequence>
 *    notetag if the Plugin Parameter: Auto Notetag is enabled.
 * 
 * Version 1.24: January 29, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** MOVE: Move To Point and MOVE: Move To Target(s) Action Sequences'
 *    "Offset Adjustment" normal setting will now factor in Offset X and
 *    Offset Y positions unlike before where it cancels them. Update by Irina.
 * * New Features!
 * ** New notetag added by Arisu:
 * *** <Common Event: name>
 * **** Battle only: calls forth a Common Event of a matching name.
 * **** This is primarily used for users who are reorganizing around their
 *      Common Events and would still like to have their skills/items perform
 *      the correct Action Sequences in case the ID's are different.
 * 
 * Version 1.23: January 22, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** ACSET: All Targets Action Set and ACSET: Each Target Action Set updated
 * *** New parameter added: Dual/Multi Wield?
 * **** Add times struck based on weapon quantity equipped?
 * * New Features!
 * ** Dual Wielding now functions differently. Made by Olivia.
 * *** Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 *     animations at once, with the combined ATK of each weapon. It's confusing
 *     to look at and does not portray the nature of "Dual Wielding".
 * *** Dual Wielding, or in the case of users adding in third and fourth
 *     weapons, Multi Wielding is now changed. Each weapon is displayed
 *     individually, each producing its own attack animation, showing each
 *     weapon type, and applying only that weapon's ATK, Traits, and related
 *     effects. It is no longer a combined effect to display everything at once
 *     like RPG Maker MZ default.
 * *** If an actor has multiple weapon slots but some of them are unequipped,
 *     then the action will treat the attack as a single attack. There will be
 *     no barehanded attack to add on top of it. This is to match RPG Maker
 *     MZ's decision to omit a second animation if the same scenario is
 *     applied.
 * ** New Action Sequence Plugin Commands added by Yanfly
 * *** ANIM: Attack Animation 2+
 * **** Plays the animation associated with the user's 2nd weapon.
 *      Plays nothing if there is no 2nd weapon equipped.
 * ** New Action Sequence Plugin Commands added by Olivia
 * *** WEAPON: Clear Weapon Slot
 * *** WEAPON: Next Weapon Slot
 * *** WEAPON: Set Weapon Slot
 * **** These are Action Sequence Plugin Commands for devs who want finer
 *      control over Dual/Multi Wielding weapons.
 * 
 * Version 1.22: January 15, 2021
 * * Compatibility Update
 * ** Compatibility with "All Skills" Actor Command should now work with the
 *    Skills & States Core hide skill notetags.
 * 
 * Version 1.21: January 8, 2021
 * * Bug Fixes!
 * ** "MOVE: Home Reset" Plugin Command Action Sequence should work properly.
 *    Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Notetag snuck in by Arisu
 * *** <Auto Action Sequence>
 * **** Used for those who have the "Auto Notetag" Plugin Parameter enabled and
 *      just want to use an automatic Action Sequence instead.
 * ** New Plugin Parameter snuck in by Arisu!
 * *** Plugin Parameters > Action Sequences > Quality of Life > Auto Notetag
 * **** Automatically apply the <Custom Action Sequence> notetag effect to any
 *      item or skill that has a Common Event?
 * **** Any item or skill without a Common Event attached to it will use the
 *      Automatic Action Sequences instead.
 * **** The <Auto Action Sequence> notetag will disable this effect for that
 *      particular skill or item.
 * ** Arisu, you're going to be responsible for any bugs these may cause.
 * *** Bring it!!!!
 * **** And handling any bug report emails that are sent because this was
 *      turned on by accident.
 * ***** Please read the documentation, guys!
 * 
 * Version 1.20: January 1, 2021
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors that have received damage
 *    will return back to place after flinching. Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New notetags added by Yanfly:
 * *** <Battle Portrait Offset: +x, +y>
 * *** <Battle Portrait Offset X: +x>
 * *** <Battle Portrait Offset Y: +y>
 * **** This is used with the "Portrait" and "Border" Battle Layouts.
 * **** Offsets the X and Y coordinates for the battle portrait.
 * 
 * Version 1.19: December 25, 2020
 * * Bug Fixes!
 * ** Removing a state from a Sideview Enemy during the middle of their a non-
 *    looping motion will no longer reset their motion to neutral.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for updated feature(s)!
 * * Feature Update!
 * ** Action Sequence "PROJECTILE: Icon" now supports code for the "Icon"
 *    parameter. Update made by Yanfly.
 * 
 * Version 1.18: December 18, 2020
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors will no longer step back
 *    after an enemy's action is finished. Fix made by Yanfly and Shiro.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** Action Sequence "BTLOG: Add Text" is updated for the convenience of a new
 *    option to quickly copy the displayed text to the VisuStella MZ Combat Log
 *    if that plugin is installed. Added by Yanfly.
 * 
 * Version 1.17: December 11, 2020
 * * Bug Fixes!
 * ** Common Events in TPB Active that cause forced actions will no longer
 *    cause currently inputting actors that match the forced action battler to
 *    crash the game. Fix made by Yanfly and Shiro.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * Feature Update!
 * ** Action Sequence Impact Action Sequences "Shockwave from Each Target(s)",
 *    "Shockwave from Target(s) Center", and "Zoom Blur at Target(s) Center"
 *    now have "Offset X" and "Offset Y" plugin parameters. Added by Yanfly.
 * ** Action Sequence "MOVE: Move To Target(s)" is now changed so that if the
 *    "Melee Distance" value is set to 0, battlers will no longer stand a half
 *    body distance away. Added by Yanfly.
 * 
 * Version 1.16: December 4, 2020
 * * Bug Fixes!
 * ** Bug fixes made for the RPG Maker MZ base code. If a battler has no
 *    actions, then their action speed will not be Infinity. Fix by Olivia.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.15: November 29, 2020
 * * Bug Fixes!
 * ** Completely replacing the whole party at once will no longer cause the
 *    battle system to crash. Fix made by Olivia.
 * ** Pre-Battle Common Events will no longer cancel out any win/lose branches.
 *    Fix made by Arisu.
 * * Feature Update!
 * ** Custom Action Sequences will no longer close the Actor Command Input
 *    window unless absolutely necessary (like for Show Message events) during
 *    Active TPB/ATB. Change made by Arisu.
 * 
 * Version 1.14: November 22, 2020
 * * Feature Update!
 * ** Natural Miss and Evasion motions now have flinch distance.
 *    Added by Yanfly.
 * 
 * Version 1.13: November 15, 2020
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.12: November 8, 2020
 * * Bug Fixes!
 * ** Failsafes added to prevent common events from running if they're empty.
 *    Fix made by Irina.
 * ** Skip Party Command will now work properly with TPB-based battle systems.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** In preparation for upcoming VisuStella MZ plugins.
 * 
 * Version 1.11: November 1, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added clarity for the Plugin Parameters for the Common Events settings
 *    found in the mechanics section. The common events are only meant to run
 *    in the map scene and not for the battle scene. Update made by Irina.
 * * Feature Update!
 * ** The Plugin Parameter for Mechanics, Common Events (on Map), Defeat Event
 *    now has updated functionality. If this has a common event attached to it,
 *    then losing to random encounters will no longer send the player to the
 *    Game Over scene, but instead, send the player back to the map scene,
 *    where the Defeat Common Event will run. Update made by Irina.
 * 
 * Version 1.10: October 25, 2020
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Action Sequence Plugin Command added by Olivia:
 * *** MECH: Custom Damage Formula
 * **** Changes the current action's damage formula to custom.
 *      This will assume the MANUAL damage style.
 * ** New Notetag added by Irina:
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battleback Scaling Settings
 * **** These settings allow you to adjust how battlebacks scale to the screen
 *      in the game.
 * *** <Battler Sprite Grounded>
 * **** Prevents the enemy from being able to jumping and/or floating due to
 *      Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * Version 1.09: October 18, 2020
 * * Bug Fixes!
 * ** Exiting out of the Options menu scene or Party menu scene will no longer
 *    cause party members to reset their starting position. Fix made by Arisu
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * ** There was a documentation error with <JS Pre-Regenerate> and
 *    <JS Post-Regenerate>. Fix made by Yanfly.
 * *** Before, these were written as <JS Pre-Regenerate Turn> and
 *     <JS Post-Regenerate Turn>. The "Turn" part of the notetag has been
 *     removed in the documentation.
 * * Feature Update!
 * ** Damage sprites on actors are now centered relative to the actor's anchor.
 *    Change made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Command added by Yanfly:
 * *** MECH: Variable Popup
 * **** Causes the unit(s) to display a popup using the data stored inside
 *      a variable.
 * 
 * Version 1.08: October 11, 2020
 * * Bug Fixes!
 * ** Dead party members at the start of battle no longer start offscreen.
 *    Fix made by Arisu.
 * ** Removed party members from battle no longer count as moving battlers.
 *    Fix made by Yanfly.
 * ** Using specific motions should now have the weapons showing and not
 *    showing properly. Fix made by Yanfly.
 * 
 * Version 1.07: October 4, 2020
 * * Bug Fixes!
 * ** Adding and removing actors will now refresh the battle status display.
 *    Fix made by Irina.
 * ** Adding new states that would change the affected battler's state motion
 *    will automatically refresh the battler's motion. Fix made by Irina.
 * ** Boss Collapse animation fixed and will sink into the ground.
 *    Fix made by Irina.
 * ** Failsafes added for certain animation types. Fix made by Yanfly.
 * ** Freeze Motion for thrust, swing, and missile animations will now show the
 *    weapons properly. Fix made by Yanfly.
 * ** The Guard command will no longer display the costs of the Attack command.
 *    Fix made by Irina.
 * * Documentation Update!
 * ** Updated help file for newly added plugin parameters.
 * * Feature Updates!
 * ** When using the Change Battleback event command in battle, the game client
 *    will wait until both battlebacks are loaded before changing the both of
 *    them so that the appearance is synched together. Change made by Yanfly.
 * * New Features!
 * ** New plugin parameters added by Irina!
 * *** Plugin Parameters > Actor Battler Settings > Chant Style
 * **** What determines the chant motion? Hit type or skill type?
 * 
 * Version 1.06: September 27, 2020
 * * Bug Fixes!
 * ** Enemy Battler Plugin Parameter "Shadow Visible" should now work again.
 *    Fix made by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins. Added by Yanfly.
 * * Documentation Update!
 * ** Updated the help file for all the new plugin parameters.
 * * Feature Update!
 * ** Action Sequence "MECH: HP, MP, TP" will now automatically collapse an
 *    enemy if it has been killed by the effect.
 * ** All battle systems for front view will now have damage popups appear
 *    in front of the status window instead of just the Portrait battle layout.
 *    Update made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Commands from Irina!
 * *** MOTION: Clear Freeze Frame
 * *** MOTION: Freeze Motion Frame
 * **** You can freeze a battler's sprite's motion with a specific frame.
 * ** New notetags for Maps and name tags for Troops added by Yanfly!
 * *** <Battle Layout: type> to change the battle layout style used for
 *     specific maps and/or troops.
 * ** New plugin parameters added by Yanfly!
 * *** Plugin Parameters > Battle Layout Settings > Command Window Width
 * **** This plugin parameter lets you adjust the window width for Party and
 *      Actor Command windows in the Default and List Battle Layout styles.
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset X
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset Y
 * **** These plugin parameters allow you to offset the position of the enemy
 *      name positions on the screen by a specific amount.
 * 
 * Version 1.05: September 20, 2020
 * * Bug Fixes!
 * ** Actors now use their casting or charging animations again during TPB/ATB.
 *    Fix made by Yanfly.
 * ** Defeat requirement for enemies will no longer crash the game if turned on
 *    after creating
 * ** Escaping animation no longer has actors stay in place. Fixed by Yanfly.
 * ** Failsafes added for newly added weapon types that have not been adjusted
 *    in the Database > System 2 tab. Fixed by Irina.
 * ** Shadows now appear under the actor sprites. Fix made by Yanfly.
 * ** Victory during TPB will no longer cancel the victory animations of
 *    actors that will have their turn after. Fixed by Yanfly.
 * * Documentation Update!
 * ** All Anchor Plugin Parameter descriptions now state to use values between
 *    0 and 1 to be safe. Update made by Yanfly.
 * * Feature Update!
 * ** During Active TPB / ATB, canceling out of the actor command window will
 *    go directly into the party window without having to sort through all of
 *    the available active actors.
 * ** Going from the Party Command Window's Fight command will immediately
 *    return back to the actor command window that was canceled from.
 * * New Features!
 * ** Action Sequence Plugin Command "MOVE: Spin/Rotate" has been updated.
 * *** A new parameter has been added: "Revert Angle on Finish"
 * *** Added by Yanfly.
 * ** New plugin parameters have been added to Damage Settings.
 * *** Appear Position: Selects where you want popups to appear relative to the
 *     battler. Head, Center, Base. Added by Yanfly.
 * *** Offset X: Sets how much to offset the sprites by vertically.
 *     Added by Yanfly.
 * *** Offset Y: Sets how much to offset the sprites by horizontally.
 *     Added by Yanfly.
 * ** New plugin parameters have been added to Actor Battler Settings.
 * *** Priority: Active - Place the active actor on top of actor and
 *     enemy sprites. Added by Yanfly.
 * *** Priority: Actors - Prioritize actors over enemies when placing 
 *     sprites on top of each other. Added by Yanfly.
 * 
 * Version 1.04: September 13, 2020
 * * Bug Fixes!
 * ** Active Battler Sprites now remain on top and won't be hidden behind
 *    other sprites for better visual clarity. Fix made by Arisu.
 * ** Collapsing battlers will now show the dead motion properly. Fix made by
 *    Olivia.
 * ** Dead battlers can no longer be given immortality. Fix made by Olivia.
 * ** Going into the Options menu with no battleback set will no longer set a
 *    battle snapshot.
 * ** HP Gauges for Sideview Enemies are no longer flipped! Fix made by Yanfly.
 * ** Moving a dead battler would no longer reset their animation. Fix made by
 *    Olivia.
 * ** Pre-Battle Common Events now work with events instead of just random
 *    encounters. Fix made by Yanfly.
 * ** Sideview Enemy shadows no longer twitch. Fix made by Irina.
 * * Documentation Updates!
 * ** Added further explanations for Anchor X and Anchor Y plugin parameters.
 *    This is because there's a lot of confusion for users who aren't familiar
 *    with how sprites work. Added by Irina.
 * ** <Magic Reduction: x> notetag updated to say magical damage instead of
 *    physical damage. Fix made by Yanfly.
 * * New Features!
 * ** Additional Action Sequence Plugin Commands have been added in preparation
 *    of upcoming plugins! Additions made by Irina.
 * *** Action Sequences - Angle (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Camera (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Skew (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Zoom (for VisuMZ_3_ActSeqCamera)
 * ** Additional Action Sequence Plugin Commands have been made available now
 *    and added to Battle Core! Additions made by Irina.
 * *** MOVE: Scale/Grow/Shrink
 * *** MOVE: Skew/Distort
 * *** MOVE: Spin/Rotate
 * *** MOVE: Wait For Scale
 * *** MOVE: Wait For Skew
 * *** MOVE: Wait For Spin
 * ** Plugin Parameters Additions. Additions made by Irina.
 * *** Plugin Params > Actor Battler Settings > Offset X
 * *** Plugin Params > Actor Battler Settings > Offset Y
 * *** Plugin Params > Actor Battler Settings > Smooth Image
 * *** Plugin Params > Enemy Battler Settings > Offset X
 * *** Plugin Params > Enemy Battler Settings > Offset Y
 * *** Plugin Params > Enemy Battler Settings > Smooth Image
 * 
 * Version 1.03: September 6, 2020
 * * Bug Fixes!
 * ** Animated Battlers will refresh their motions from the death motion once
 *    they're revived instead of waiting for their next input phase. Fix made
 *    by Yanfly.
 * ** Battle Log speed sometimes went by too fast for certain enabled messages.
 *    Wait timers are now added to them, like state results, buff results, and
 *    debuff results. Fix made by Yanfly.
 * ** Boss Collapse animation now works properly. Fix made by Yanfly.
 * ** Freeze fix for TPB (Wait) if multiple actors get a turn at the same time.
 *    Fix made by Olivia.
 * ** Pressing cancel on a target window after selecting a single skill no
 *    longer causes the status window to twitch.
 * ** Sideview Enemies had a split frame of being visible if they were to start
 *    off hidden in battle. Fix made by Shaz.
 * * Compatibility Update:
 * ** Battle Core's Sprite_Damage.setup() function is now separated fro the
 *    default to allow for better compatibility. Made by Yanfly.
 * * Documentation Update:
 * ** Inserted more information for "Damage Popups" under "Major Changes"
 * * New Features!
 * ** <Magic Penetration: x>, <Magic Penetration: x%> notetags added.
 * ** <Magic Reduction: x>, <Magic Reduction: x%> notetags added.
 * ** <Battle UI Offset: +x, +y>, <Battle UI Offset X: +x>, and
 *    <Battle UI Offset Y: +y> notetags added for adjusting the positions of
 *    HP Gauges and State Icons.
 * *** Notetags added by Yanfly.
 * 
 * Version 1.02: August 30, 2020
 * * Bug Fixes!
 * ** Failsafes added for parsing battle targets. Fix made by Yanfly.
 * ** Immortality is no longer ignored by skills/items with the Normal Attack
 *    state effect. Fix made by Yanfly.
 * ** Miss and Evasion sound effects work again! Fix made by Yanfly.
 * ** Selecting "Escape" from the Actor Command Window will now have the
 *    Inputting Battler show its escape motion. Fix made by Yanfly.
 * ** Wait for Movement now applies to SV Enemies. Fix made by Yanfly.
 * * New Features!
 * ** Plugin Command "ACSET: Finish Action" now has an option to turn off the
 *    Immortality of targets. Feature added by Yanfly.
 * * Optimization Update
 * ** Uses less resources when making checks for Pre-Battle Battle Start events
 * 
 * Version 1.01: August 23, 2020
 * * Bug Fixes!
 * ** Plugin Parameters > Damage Settings > Damage Formats are now fixed.
 *    Fix made by Olivia.
 * ** TPB Battle System with Disable Party Command fixed. Fix made by Olivia.
 * ** States now show in list format if faces are disabled. Fix made by Yanfly.
 * ** The default damage styles were missing the 'v' variable to allow for
 *    variable data input. These are back now. Fix made by Yanfly.
 * *** Users updating from version 1.00 will need to fix this problem by either
 *     removing the plugin from the Plugin Manager list and reinstalling it, or
 *     going to Plugin Parameters > Damage Settings > Style List > the style
 *     you want, and adding "const v = $gameVariables._data;" to JS: Formula
 * * New Notetags Added:
 * ** <Command Show Switch: x> added by Olivia
 * ** <Command Show All Switches: x,x,x> added by Olivia
 * ** <Command Show Any Switches: x,x,x> added by Olivia
 * ** <Command Hide Switch: x> added by Olivia
 * ** <Command Hide All Switches: x,x,x> added by Olivia
 * ** <Command Hide Any Switches: x,x,x> added by Olivia
 * ** <JS Command Visible> added by Olivia
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceStart
 * @text -
 * @desc The following are Action Sequences commands/sets.
 * These Plugin Commands only work in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSet
 * @text Action Sequence - Action Sets
 * @desc Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_SetupAction
 * @text ACSET: Setup Action Set
 * @desc The generic start to most actions.
 * 
 * @arg DisplayAction:eval
 * @text Display Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: On
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionStart:eval
 * @text Battle Step
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg CastAnimation:eval
 * @text Cast Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_WholeActionSet
 * @text ACSET: All Targets Action Set
 * @desc Affects all targets simultaneously performing the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_TargetActionSet
 * @text ACSET: Each Target Action Set
 * @desc Goes through each target one by one to perform the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount1:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount2:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed * 2
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_FinishAction
 * @text ACSET: Finish Action
 * @desc The generic ending to most actions.
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForNewLine:eval
 * @text Wait For New Line
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effects
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ClearBattleLog:eval
 * @text Clear Battle Log
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEnd:eval
 * @text Home Reset
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAngle
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAngle
 * @text Action Sequences - Angle
 * @desc Allows you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeAngle
 * @text ANGLE: Change Angle
 * @desc Changes the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc Change the camera angle to this many degrees.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_Reset
 * @text ANGLE: Reset Angle
 * @desc Reset any angle settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_WaitForAngle
 * @text ANGLE: Wait For Angle
 * @desc Waits for angle changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAnimation
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAnimation
 * @text Action Sequences - Animations
 * @desc These Action Sequences are related to the 'Animations' that
 * can be found in the Animations tab of the Database.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ActionAnimation
 * @text ANIM: Action Animation
 * @desc Plays the animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation
 * @text ANIM: Attack Animation
 * @desc Plays the animation associated with the user's 1st weapon.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation2
 * @text ANIM: Attack Animation 2+
 * @desc Plays the animation associated with the user's other weapons.
 * Plays nothing if there is no other weapon equipped.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Slot:eval
 * @text Slot
 * @desc Which weapon slot to get this data from?
 * Main-hand weapon is weapon slot 1.
 * @default 2
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_CastAnimation
 * @text ANIM: Cast Animation
 * @desc Plays the cast animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ChangeBattlePortrait
 * @text ANIM: Change Battle Portrait
 * @desc Changes the battle portrait of the actor (if it's an actor).
 * Can be used outside of battle/action sequences.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to change the portraits for.
 * Valid units can only be actors.
 * @default ["user"]
 * 
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/pictures/
 * @desc Select the file to change the actor's portrait to.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_PlayAtCoordinate
 * @text ANIM: Play at Coordinate
 * @desc Plays an animation on the screen at a specific x, y coordinate.
 * Requires VisuMZ_0_CoreEngine!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Animation
 * @type animation
 * @desc Plays this animation.
 * @default 1
 * 
 * @arg Coordinates
 *
 * @arg pointX:eval
 * @text X
 * @parent Coordinates
 * @desc X coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 *
 * @arg pointY:eval
 * @text Y
 * @parent Coordinates
 * @desc Y coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 *
 * @arg Mirror:eval
 * @text Mirror Animation?
 * @parent Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute Animation?
 * @parent Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the animation?
 * @default false
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion?
 * @parent Animation
 * @type boolean
 * @on Wait
 * @off Normal
 * @desc Wait the animation to finish before continuing?
 * @default false
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ShowAnimation
 * @text ANIM: Show Animation
 * @desc Plays the a specific animation on unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Select which animation to play on unit(s).
 * @default 1
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_WaitForAnimation
 * @text ANIM: Wait For Animation
 * @desc Causes the interpreter to wait for any animation(s) to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceBattleLog
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakBattleLog
 * @text Action Sequences - Battle Log
 * @desc These Action Sequences are related to the Battle Log Window,
 * the window found at the top of the battle screen.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_AddText
 * @text BTLOG: Add Text
 * @desc Adds a new line of text into the Battle Log.
 * 
 * @arg Text:str
 * @text Text
 * @desc Add this text into the Battle Log.
 * Text codes allowed.
 * @default Insert text here.
 * 
 * @arg CopyCombatLog:eval
 * @text Copy to Combat Log?
 * @type boolean
 * @on Copy Text
 * @off Don't Copy
 * @desc Copies text to the Combat Log.
 * Requires VisuMZ_4_CombatLog
 * @default true
 *
 * @arg CombatLogIcon:num
 * @text Combat Log Icon
 * @parent CopyCombatLog:eval
 * @desc What icon would you like to bind to this entry?
 * Requires VisuMZ_4_CombatLog
 * @default 87
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Clear
 * @text BTLOG: Clear Battle Log
 * @desc Clears all the text in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_DisplayAction
 * @text BTLOG: Display Action
 * @desc Displays the current action in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PopBaseLine
 * @text BTLOG: Pop Base Line
 * @desc Removes the Battle Log's last added base line and 
 * all text up to its former location.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PushBaseLine
 * @text BTLOG: Push Base Line
 * @desc Adds a new base line to where the Battle Log currently is at.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Refresh
 * @text BTLOG: Refresh Battle Log
 * @desc Refreshes the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_UI
 * @text BTLOG: UI Show/Hide
 * @desc Shows or hides the Battle UI (including the Battle Log).
 * 
 * @arg ShowHide:eval
 * @text Show/Hide?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows/hides the Battle UI.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForBattleLog
 * @text BTLOG: Wait For Battle Log
 * @desc Causes the interpreter to wait for the Battle Log to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForNewLine
 * @text BTLOG: Wait For New Line
 * @desc Causes the interpreter to wait for a new line in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCamera
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCamera
 * @text Action Sequences - Camera
 * @desc Allows you to have control over the camera.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Clamp
 * @text CAMERA: Clamp ON/OFF
 * @desc Turns battle camera clamping on/off.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Setting:eval
 * @text ON/OFF
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Turns camera clamping on/off.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusPoint
 * @text CAMERA: Focus Point
 * @desc Focus the battle camera on a certain point in the screen.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg FocusX:eval
 * @text X Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg FocusY:eval
 * @text Y Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusTarget
 * @text CAMERA: Focus Target(s)
 * @desc Focus the battle camera on certain battler target(s).
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to focus the battle camera on.
 * @default ["user"]
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Offset
 * @text CAMERA: Offset
 * @desc Offset the battle camera from the focus target.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @desc How much to offset the camera X by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @desc How much to offset the camera Y by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for offset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Reset
 * @text CAMERA: Reset
 * @desc Reset the battle camera settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg ResetFocus:eval
 * @text Reset Focus?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the focus point?
 * @default true
 * 
 * @arg ResetOffset:eval
 * @text Reset Offset?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the camera offset?
 * @default true
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for reset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_WaitForCamera
 * @text CAMERA: Wait For Camera
 * @desc Waits for camera to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 *
 * @command ActionSequenceSpaceDragonbones
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreaDragonbones
 * @text Action Sequences - Dragonbones
 * @desc These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesMotionAni
 * @text DB: Dragonbones Animation
 * @desc Causes the unit(s) to play a Dragonbones motion animation.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg MotionAni:str
 * @text Motion Animation
 * @desc What is the name of the Dragonbones motion animation you wish to play?
 * @default attack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesTimeScale
 * @text DB: Dragonbones Time Scale
 * @desc Causes the unit(s) to change their Dragonbones time scale.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg TimeScale:num
 * @text Time Scale
 * @desc Change the value of the Dragonbones time scale to this.
 * @default 1.0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceElements
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakElements
 * @text Action Sequences - Elements
 * @desc These Action Sequences are related to elements.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_AddElements
 * @text ELE: Add Elements
 * @desc Adds element(s) to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to add onto the action.
 * Insert multiple element ID's to add multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_Clear
 * @text ELE: Clear Element Changes
 * @desc Clears all element changes made through Action Sequences.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_ForceElements
 * @text ELE: Force Elements
 * @desc Forces only specific element(s) when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to force in the action.
 * Insert multiple element ID's to force multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_NullElements
 * @text ELE: Null Element
 * @desc Forces no element to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceHorror
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakHorror
 * @text Action Sequences - Horror Effects
 * @desc These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_Clear
 * @text HORROR: Clear All Filters
 * @desc Clear all Horror Effects filters on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove Horror Effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchCreate
 * @text HORROR: Glitch Create
 * @desc Creates the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg slices:num
 * @text Glitch Slices
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Glitch slices to be used with the target.
 * @default 10
 *
 * @arg offset:num
 * @text Glitch Offset
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Default offset value.
 * @default 100
 *
 * @arg animated:eval
 * @text Glitch Animated?
 * @parent FilterGlitch
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the glitch effect?
 * @default true
 *
 * @arg aniFrequency:num
 * @text Glitch Frequency
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how frequent to make the glitch effect?
 * Lower = often     Higher = rarer
 * @default 300
 *
 * @arg aniStrength:num
 * @text Glitch Strength
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how strong is the glitch effect?
 * Lower = weaker     Higher = stronger
 * @default 30
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchRemove
 * @text HORROR: Glitch Remove
 * @desc Removes the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseCreate
 * @text HORROR: Noise Create
 * @desc Creates the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg noise:num
 * @text Noise Rate
 * @parent FilterNoise
 * @desc Noise rate to be used with the target.
 * @default 0.3
 *
 * @arg animated:eval
 * @text Noise Animated
 * @parent FilterNoise
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the noise for the target?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseRemove
 * @text HORROR: Noise Remove
 * @desc Removes the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVCreate
 * @text HORROR: TV Create
 * @desc Creates the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg lineWidth:num
 * @text TV Line Thickness
 * @parent FilterTV
 * @type number
 * @min 1
 * @desc Default TV line thickness
 * Lower = thinner     Higher = thicker
 * @default 5
 *
 * @arg vignetting:num
 * @text TV Corner Size
 * @parent FilterTV
 * @desc Default TV line corner size
 * Lower = smaller     Higher = bigger
 * @default 0.3
 *
 * @arg animated:eval
 * @text TV Animated
 * @parent FilterTV
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the TV?
 * @default true
 *
 * @arg aniSpeed:num
 * @text TV Speed
 * @parent FilterTV
 * @desc Speed used to animate the TV if animated
 * Lower = slower     Higher = faster
 * @default 0.25
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVRemove
 * @text HORROR: TV Remove
 * @desc Removes the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceImpact
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakImpact
 * @text Action Sequences - Impact
 * @desc These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ColorBreak
 * @text IMPACT: Color Break
 * @desc Breaks the colors on the screen before reassembling.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Intensity:eval
 * @text Intensity
 * @desc What is the intensity of the color break effect?
 * @default 60
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the color break effect?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutBack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurScreen
 * @text IMPACT: Motion Blur Screen
 * @desc Creates a motion blur on the whole screen.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.1
 *
 * @arg Duration:num
 * @text Duration
 * @type Number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurTarget
 * @text IMPACT: Motion Blur Target(s)
 * @desc Creates a motion blur on selected target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion blur effects for.
 * @default ["user"]
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.5
 *
 * @arg Duration:num
 * @text Duration
 * @type Number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailCreate
 * @text IMPACT: Motion Trail Create
 * @desc Creates a motion trail effect for the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion trail effects for.
 * @default ["user"]
 *
 * @arg delay:num
 * @text Delay
 * @type Number
 * @min 1
 * @desc How many frames to delay by when creating a motion trail?
 * The higher the delay, the less after images there are.
 * @default 1
 *
 * @arg duration:num
 * @text Duration
 * @type Number
 * @min 1
 * @desc How many frames should the motion trail last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg hue:num
 * @text Hue
 * @type Number
 * @min 0
 * @max 255
 * @desc What do you want to be the hue for the motion trail?
 * @default 0
 *
 * @arg opacityStart:num
 * @text Starting Opacity
 * @type Number
 * @min 0
 * @max 255
 * @desc What starting opacity value do you want for the motion
 * trail? Opacity values decrease over time.
 * @default 200
 *
 * @arg tone:eval
 * @text Tone
 * @desc What tone do you want for the motion trail?
 * Format: [Red, Green, Blue, Gray]
 * @default [0, 0, 0, 0]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailRemove
 * @text IMPACT: Motion Trail Remove
 * @desc Removes the motion trail effect from the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to clear motion trail effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwavePoint
 * @text IMPACT: Shockwave at Point
 * @desc Creates a shockwave at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveEachTargets
 * @text IMPACT: Shockwave from Each Target(s)
 * @desc Creates a shockwave at each of the target(s) location(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveCenterTargets
 * @text IMPACT: Shockwave from Target(s) Center
 * @desc Creates a shockwave from the center of the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurPoint
 * @text IMPACT: Zoom Blur at Point
 * @desc Creates a zoom blur at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurTargetCenter
 * @text IMPACT: Zoom Blur at Target(s) Center
 * @desc Creates a zoom blur at the center of targets.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a zoom blur from.
 * @default ["user"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a zoom blur from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMechanics
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMechanics
 * @text Action Sequences - Mechanics
 * @desc These Action Sequences are related to various mechanics
 * related to the battle system.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActionEffect
 * @text MECH: Action Effect
 * @desc Causes the unit(s) to take damage/healing from action and
 * incurs any changes made such as buffs and states.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddBuffDebuff
 * @text MECH: Add Buff/Debuff
 * @desc Adds buff(s)/debuff(s) to unit(s). 
 * Determine which parameters are affected and their durations.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s) and/or debuff(s).
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to buff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["ATK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to debuff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["DEF"]
 * 
 * @arg Turns:eval
 * @text Turns
 * @desc Number of turns to set the parameter(s) buffs to.
 * You may use JavaScript code.
 * @default 5
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddState
 * @text MECH: Add State
 * @desc Adds state(s) to unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s).
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to add to unit(s).
 * Insert multiple state ID's to add multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AnalyzeWeakness
 * @text MECH: Analyze Weakness
 * @desc Reveal elemental weakness(es) from target(s).
 * Requires VisuMZ_3_WeaknessDisplay!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reveal elemental weaknesses for.
 * @default ["all targets"]
 * 
 * @arg Reveal:eval
 * @text Reveal
 * @desc How many elemental weaknesses do you wish to reveal?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ArmorPenetration
 * @text MECH: Armor Penetration
 * @desc Adds an extra layer of defensive penetration/reduction.
 * You may use JavaScript code for any of these.
 *
 * @arg ArmorPenetration
 * @text Armor/Magic Penetration
 * 
 * @arg ArPenRate:eval
 * @text Rate
 * @parent ArmorPenetration
 * @desc Penetrates an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArPenFlat:eval
 * @text Flat
 * @parent ArmorPenetration
 * @desc Penetrates a flat amount of armor by this value.
 * @default 0
 *
 * @arg ArmorReduction
 * @text Armor/Magic Reduction
 * 
 * @arg ArRedRate:eval
 * @text Rate
 * @parent ArmorReduction
 * @desc Reduces an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArRedFlat:eval
 * @text Flat
 * @parent ArmorReduction
 * @desc Reduces a flat amount of armor by this value.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AtbGauge
 * @text MECH: ATB Gauge
 * @desc Alters the ATB/TPB Gauges.
 * Requires VisuMZ_2_BattleSystemATB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 *
 * @arg Charging
 * 
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the ATB Gauge if it is currently charging.
 * @default -0.00
 * 
 * @arg Casting
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the ATB Gauge if it is currently casting.
 * @default -0.00
 * 
 * @arg Interrupt:eval
 * @text Interrupt?
 * @parent Casting
 * @type boolean
 * @on Interrupt
 * @off Don't Interrupt
 * @desc Interrupt the ATB Gauge if it is currently casting?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsChange
 * @text MECH: Boost Points Change
 * @desc Changes Boost Points for target(s).
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Boost Points for.
 * @default ["user"]
 * 
 * @arg BoostPoints:eval
 * @text Alter Boost Points By
 * @desc Alters the unit(s) Boost Points.
 * Positive for gaining points. Negative for losing points.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsStoreData
 * @text MECH: Boost Store Data
 * @desc Stores the number of Boosts used this action inside a variable.
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg VariableID:num
 * @text Variable ID
 * @type variable
 * @desc Which variable do you want to store the data inside?
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldChange
 * @text MECH: Break Shield Change
 * @desc Changes Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Break Shields for.
 * @default ["all targets"]
 * 
 * @arg BreakShields:eval
 * @text Alter Break Shields By
 * @desc Alters the unit(s) Break Shields.
 * Positive for gaining shields. Negative for losing shields.
 * @default -1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldReset
 * @text MECH: Break Shield Reset
 * @desc Resets Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reset the Break Shields for.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BtbGain
 * @text MECH: BTB Brave Points
 * @desc Alters the target(s) Brave Points to an exact value.
 * Requires VisuMZ_2_BattleSystemBTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 * 
 * @arg BravePoints:eval
 * @text Alter Brave Points By
 * @desc Alters the target(s) Brave Points.
 * Positive for gaining BP. Negative for losing BP.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Collapse
 * @text MECH: Collapse
 * @desc Causes the unit(s) to perform its collapse animation
 * if the unit(s) has died.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to process a death collapse.
 * @default ["all targets"]
 * 
 * @arg ForceDeath:eval
 * @text Force Death
 * @type boolean
 * @on On
 * @off Off
 * @desc Force death even if the unit has not reached 0 HP?
 * This will remove immortality.
 * @default false
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effect?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for the collapse effect to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbOrder
 * @text MECH: CTB Order
 * @desc Alters the CTB Turn Order.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg ChangeOrderBy:eval
 * @text Change Order By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbSpeed
 * @text MECH: CTB Speed
 * @desc Alters the CTB Speed.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Speed for.
 * @default ["all targets"]
 *
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the CTB Speed if it is currently charging.
 * @default -0.00
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the CTB Speed if it is currently casting.
 * @default -0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CustomDmgFormula
 * @text MECH: Custom Damage Formula
 * @desc Changes the current action's damage formula to custom.
 * This will assume the MANUAL damage style.
 * 
 * @arg Formula:str
 * @text Formula
 * @desc Changes the current action's damage formula to custom.
 * Use 'default' to revert the damage formula.
 * @default default
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DamagePopup
 * @text MECH: Damage Popup
 * @desc Causes the unit(s) to display the current state of
 * damage received or healed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a damage popup.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DeathBreak
 * @text MECH: Dead Label Jump
 * @desc If the active battler is dead, jump to a specific label in the common event.
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If the active battler is dead, jump to this specific label in the common event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EnemyEscape
 * @text MECH: Enemy Escape
 * @desc Causes the enemy unit(s) to escape.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to escape.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EtbAction
 * @text MECH: ETB Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Requires VisuMZ_2_BattleSystemETB!
 * 
 * @arg ActionCount:eval
 * @text Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Positive for gaining energy. Negative for losing energy.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_FtbAction
 * @text MECH: FTB Action Count
 * @desc Alters the subject team's available Action Count.
 * Requires VisuMZ_2_BattleSystemFTB!
 * 
 * @arg ActionCount:eval
 * @text Action Count
 * @desc Alters the subject team's available Action Count.
 * Positive for gaining actions. Negative for losing actions.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_HpMpTp
 * @text MECH: HP, MP, TP
 * @desc Alters the HP, MP, and TP values for unit(s).
 * Positive values for healing. Negative values for damage.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["user"]
 *
 * @arg HP
 * 
 * @arg HP_Rate:eval
 * @text HP Rate
 * @parent HP
 * @desc Changes made to HP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg HP_Flat:eval
 * @text HP Flat
 * @parent HP
 * @desc Flat changes made to HP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg MP
 * 
 * @arg MP_Rate:eval
 * @text MP Rate
 * @parent MP
 * @desc Changes made to MP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg MP_Flat:eval
 * @text MP Flat
 * @parent MP
 * @desc Flat changes made to MP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 *
 * @arg TP
 * 
 * @arg TP_Rate:eval
 * @text TP Rate
 * @parent TP
 * @desc Changes made to TP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg TP_Flat:eval
 * @text TP Flat
 * @parent TP
 * @desc Flat changes made to TP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg ShowPopup:eval
 * @text Damage Popup?
 * @type boolean
 * @on On
 * @off Off
 * @desc Display a damage popup after?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Immortal
 * @text MECH: Immortal
 * @desc Changes the immortal flag of targets. If immortal flag is
 * removed and a unit would die, collapse that unit.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Alter the immortal flag of these groups. If immortal flag
 * is removed and a unit would die, collapse that unit.
 * @default ["user","all targets"]
 * 
 * @arg Immortal:eval
 * @text Immortal
 * @type boolean
 * @on On
 * @off Off
 * @desc Turn immortal flag for unit(s) on/off?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Multipliers
 * @text MECH: Multipliers
 * @desc Changes the multipliers for the current action.
 * You may use JavaScript code for any of these.
 *
 * @arg CriticalHit
 * @text Critical Hit%
 * 
 * @arg CriticalHitRate:eval
 * @text Rate
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalHitFlat:eval
 * @text Flat
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this flat bonus.
 * @default +0.00
 *
 * @arg CriticalDmg
 * @text Critical Damage
 * 
 * @arg CriticalDmgRate:eval
 * @text Rate
 * @parent CriticalDmg
 * @desc Affects critical damage by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalDmgFlat:eval
 * @text Flat
 * @parent CriticalDmg
 * @desc Affects critical damage by this flat bonus.
 * @default +0.00
 *
 * @arg Damage
 * @text Damage/Healing
 * 
 * @arg DamageRate:eval
 * @text Rate
 * @parent Damage
 * @desc Sets the damage/healing multiplier for current action.
 * @default 1.00
 * 
 * @arg DamageFlat:eval
 * @text Flat
 * @parent Damage
 * @desc Sets the damage/healing bonus for current action.
 * @default +0.00
 *
 * @arg HitRate
 * @text Hit Rate
 * 
 * @arg HitRate:eval
 * @text Rate
 * @parent HitRate
 * @desc Affects chance to connect attack by this multiplier.
 * @default 1.00
 * 
 * @arg HitFlat:eval
 * @text Flat
 * @parent HitRate
 * @desc Affects chance to connect attack by this flat bonus.
 * @default +0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OnceParallel
 * @text MECH: Once Parallel
 * @desc Plays a Common Event parallel to the battle event once
 * without repeating itself when done.
 *
 * @arg CommonEventID:num
 * @text Common Event ID
 * @type common_event
 * @desc The ID of the parallel Common Event to play.
 * Does NOT repeat itself when finished.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OtbOrder
 * @text MECH: OTB Order
 * @desc Alters the OTB Turn Order. Best used with single targets.
 * Requires VisuMZ_2_BattleSystemOTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the OTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg CurrentTurn:eval
 * @text Current Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @arg NextTurn:eval
 * @text Next Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @arg FollowTurn:eval
 * @text Follow Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbAlterCost
 * @text MECH: PTB Alter Cost
 * @desc Alters the action's cost settings.
 * Requires VisuMZ_2_BattleSystemPTB!
 *
 * @arg Override:eval
 * @text Override?
 * @type boolean
 * @on Override Permanent
 * @off Require Temporary
 * @desc Overrides any 'permanent' settings for Changeability?
 * @default false
 *
 * @arg alterChange:str
 * @text Alter Changeability
 * @type select
 * @option Unchanged - Cost type is unchanged after this effect
 * @value unchanged
 * @option Permanent - Cost type can no longer be changed after
 * @value permanent
 * @option Temporary - Cost type can still be changed after
 * @value temporary
 * @desc Allow the cost type and value to be changeable?
 * @default unchanged
 *
 * @arg alterType:str
 * @text Alter Cost Type
 * @type select
 * @option Unchanged - No changes are made
 * @value unchanged
 * @option Consume - Removes half, otherwise consumes full
 * @value consume
 * @option Convert - Converts full => half, otherwise consumes half
 * @value convert
 * @option Compress - Consumes half, otherwise converts full => half
 * @value compress
 * @desc Change the cost type to this scenario.
 * Use 'Unchanged' for no changes.
 * @default convert
 *
 * @arg alterCost:eval
 * @text Alter Cost Value
 * @desc What is the default action cost for this scenario?
 * @default +0
 *
 * @arg alterPriority:eval
 * @text Priority
 * @desc What is this scenario's priority? Scenario outcomes with
 * equal or lower priorities cannot override types and costs.
 * @default 50
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbConvert
 * @text MECH: PTB Conversion
 * @desc Converts full actions into half actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg ConvertCount:eval
 * @text Conversion Count
 * @desc Converts full actions into half actions.
 * If not enough, consume half actions.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbFullHalfAction
 * @text MECH: PTB Full/Half Action(s)
 * @desc Alters the subject team's available Full/Half Actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg FullActions:eval
 * @text Full Actions
 * @desc Alters the subject team's available Full Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 * 
 * @arg HalfActions:eval
 * @text Half Actions
 * @desc Alters the subject team's available Half Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveBuffDebuff
 * @text MECH: Remove Buff/Debuff
 * @desc Removes buff(s)/debuff(s) from unit(s). 
 * Determine which parameters are removed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have the buff(s) and/or debuff(s) removed.
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which buffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which debuffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveState
 * @text MECH: Remove State
 * @desc Remove state(s) from unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have states removed from.
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to remove from unit(s).
 * Insert multiple state ID's to remove multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExploit
 * @text MECH: STB Exploit Effect
 * @desc Utilize the STB Exploitation mechanics!
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Exploited:eval
 * @text Target(s) Exploited?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Exploit the below targets?
 * @default true
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to become exploited.
 * @default ["all targets"]
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploited status?
 * @default false
 * 
 * @arg Exploiter:eval
 * @text User Exploiter?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Allow the user to become the exploiter?
 * @default true
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploiter status?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExtraAction
 * @text MECH: STB Extra Action
 * @desc Adds an extra action for the currently active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Extra Actions
 * @parent Charging
 * @desc How many extra actions should the active battler gain?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbRemoveExcessActions
 * @text MECH: STB Remove Excess Actions
 * @desc Removes excess actions from the active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Remove Actions
 * @parent Charging
 * @desc How many actions to remove from the active battler?
 * You may use JavaScript code.
 * @default 99
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_SwapWeapon
 * @text MECH: Swap Weapon
 * @desc Causes the unit(s) to swap their weapon for another.
 * Requires VisuMZ_2_WeaponSwapSystem!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to swap weapons for.
 * @default ["user"]
 * 
 * @arg WeaponTypeID:eval
 * @text Weapon Type ID
 * @desc Which weapon type to swap to?
 * This is NOT the weapon's ID. It's the weapon TYPE.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_TextPopup
 * @text MECH: Text Popup
 * @desc Causes the unit(s) to display a text popup.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Text:str
 * @text Text
 * @desc What text do you wish to display?
 * @default Text
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Text:str
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type Number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_VariablePopup
 * @text MECH: Variable Popup
 * @desc Causes the unit(s) to display a popup using the data
 * stored inside a variable.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Variable:num
 * @text Variable ID
 * @type variable
 * @desc Get data from which variable to display as a popup?
 * @default 1
 * 
 * @arg DigitGrouping:eval
 * @text Digit Grouping
 * @parent Variable:num
 * @type boolean
 * @on Group Digits
 * @off Don't Group
 * @desc Use digit grouping to separate numbers?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Variable:num
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [0, 0, 0, 0]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type Number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_WaitForEffect
 * @text MECH: Wait For Effect
 * @desc Waits for the effects to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMotion
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMotion
 * @text Action Sequences - Motion
 * @desc These Action Sequences allow you the ability to control
 * the motions of sideview sprites.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_ClearFreezeFrame
 * @text MOTION: Clear Freeze Frame
 * @desc Clears any freeze frames from the unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to clear freeze frames for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_FreezeMotionFrame
 * @text MOTION: Freeze Motion Frame
 * @desc Forces a freeze frame instantly at the selected motion.
 * Automatically clears with a new motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to freeze motions for.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Freeze this motion for the unit(s).
 * @default attack
 * 
 * @arg Frame:num
 * @text Frame Index
 * @desc Which frame do you want to freeze the motion on?
 * Frame index values start at 0.
 * @default 2
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_MotionType
 * @text MOTION: Motion Type
 * @desc Causes the unit(s) to play the selected motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default attack
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_PerformAction
 * @text MOTION: Perform Action
 * @desc Causes the unit(s) to play the proper motion based
 * on the current action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_RefreshMotion
 * @text MOTION: Refresh Motion
 * @desc Cancels any set motions unit(s) has to do and use
 * their most natural motion at the moment.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to refresh their motion state.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_WaitMotionFrame
 * @text MOTION: Wait By Motion Frame
 * @desc Creates a wait equal to the number of motion frames passing.
 * Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 * @arg MotionFrameWait:num
 * @text Motion Frames to Wait?
 * @type number
 * @min 1
 * @desc Each "frame" is equal to the value found in
 * Plugin Parameters => Actors => Motion Speed
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMovement
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMovement
 * @text Action Sequences - Movement
 * @desc These Action Sequences allow you the ability to control
 * the sprites of actors and enemies in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_BattleStep
 * @text MOVE: Battle Step
 * @desc Causes the unit(s) to move forward past their home position
 * to prepare for action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveBy
 * @text MOVE: Change Home By Distance
 * @desc Change unit(s)'s home position by a distance from their
 * current home position(s). Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to change by.
 * @default horz
 * 
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to change home by.
 * You may use JavaScript code.
 * @default 48
 * 
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToPoint
 * @text MOVE: Change Home To Point
 * @desc Change home position(s) to a target point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 * 
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default center
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToTarget
 * @text MOVE: Change Home To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position to.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to change home position to.
 * @default front base
 * 
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceDirection
 * @text MOVE: Face Direction
 * @desc Causes the unit(s) to face forward or backward.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Direction:str
 * @text Direction
 * @type combo
 * @option forward
 * @option backward
 * @option random
 * @desc Select which direction to face.
 * @default forward
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FacePoint
 * @text MOVE: Face Point
 * @desc Causes the unit(s) to face a point on the screen.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Point:str
 * @text Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the point instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceTarget
 * @text MOVE: Face Target(s)
 * @desc Causes the unit(s) to face other targets on the screen.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (facing)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for the turning unit(s) to face.
 * @default ["current target"]
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the unit(s) instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Float
 * @text MOVE: Float
 * @desc Causes the unit(s) to float above the ground.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make float.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Vertical distance to float upward.
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total float amount.
 * @default 12
 *
 * @arg EasingType:str
 * @text Float Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForFloat:eval
 * @text Wait For Float?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for floating to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeReset
 * @text MOVE: Home Reset
 * @desc Causes the unit(s) to move back to their home position(s)
 * and face back to their original direction(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["alive battlers"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Jump
 * @text MOVE: Jump
 * @desc Causes the unit(s) to jump into the air.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make jump.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Max jump height to go above the ground
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total jump amount.
 * @default 12
 * 
 * @arg WaitForJump:eval
 * @text Wait For Jump?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for jumping to complete before performing next command?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveBy
 * @text MOVE: Move Distance
 * @desc Moves unit(s) by a distance from their current position(s).
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to move unit(s).
 * @default horz
 * 
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to move.
 * You may use JavaScript code.
 * @default 48
 * 
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToPoint
 * @text MOVE: Move To Point
 * @desc Moves unit(s) to a designated point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToTarget
 * @text MOVE: Move To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move to.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to move to.
 * @default front base
 * 
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Opacity
 * @text MOVE: Opacity
 * @desc Causes the unit(s) to change opacity.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change opacity.
 * @default ["user"]
 * 
 * @arg Opacity:eval
 * @text Desired Opacity
 * @desc Change to this opacity value.
 * You may use JavaScript code.
 * @default 255
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for opacity change.
 * @default 12
 *
 * @arg EasingType:str
 * @text Opacity Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForOpacity:eval
 * @text Wait For Opacity?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for opacity changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Scale
 * @text MOVE: Scale/Grow/Shrink
 * @desc Causes the unit(s) to scale, grow, or shrink?.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change the scale of.
 * @default ["user"]
 * 
 * @arg ScaleX:eval
 * @text Scale X
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg ScaleY:eval
 * @text Scale Y
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to scale for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Scale Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForScale:eval
 * @text Wait For Scale?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for scaling to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Skew
 * @text MOVE: Skew/Distort
 * @desc Causes the unit(s) to skew.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to skew.
 * @default ["user"]
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc X variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Y variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to skew for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Spin
 * @text MOVE: Spin/Rotate
 * @desc Causes the unit(s) to spin.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to spin.
 * @default ["user"]
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc How many degrees to spin?
 * @default 360
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to spin for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Spin Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg RevertAngle:eval
 * @text Revert Angle on Finish
 * @type boolean
 * @on Revert
 * @off Don't
 * @desc Revert angle after spinning?
 * @default true
 * 
 * @arg WaitForSpin:eval
 * @text Wait For Spin?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for spin to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForFloat
 * @text MOVE: Wait For Float
 * @desc Waits for floating to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForJump
 * @text MOVE: Wait For Jump
 * @desc Waits for jumping to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForMovement
 * @text MOVE: Wait For Movement
 * @desc Waits for movement to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForOpacity
 * @text MOVE: Wait For Opacity
 * @desc Waits for opacity changes to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForScale
 * @text MOVE: Wait For Scale
 * @desc Waits for scaling to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSkew
 * @text MOVE: Wait For Skew
 * @desc Waits for skewing to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSpin
 * @text MOVE: Wait For Spin
 * @desc Waits for spinning to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceProjectile
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakProjectile
 * @text Action Sequences - Projectiles
 * @desc Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Animation
 * @text PROJECTILE: Animation
 * @desc Create an animation projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Settings
 * @type animation
 * @desc Determine which animation to use as a projectile.
 * @default 77
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExAni>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","EasingType:str":"Linear","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Icon
 * @text PROJECTILE: Icon
 * @desc Create an icon projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Icon:eval
 * @text Icon Index
 * @parent Settings
 * @desc Determine which icon to use as a projectile.
 * You may use JavaScript code.
 * @default 118
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Picture
 * @text PROJECTILE: Picture
 * @desc Create a picture projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Picture:str
 * @text Picture Filename
 * @parent Settings
 * @type file
 * @dir img/pictures/
 * @desc Determine which picture to use as a projectile.
 * @default Untitled
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceSkew
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSkew
 * @text Action Sequences - Skew
 * @desc Allows you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeSkew
 * @text SKEW: Change Skew
 * @desc Changes the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc Change the camera skew X to this value.
 * @default 0
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Change the camera skew Y to this value.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_Reset
 * @text SKEW: Reset Skew
 * @desc Reset any skew settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_WaitForSkew
 * @text SKEW: Wait For Skew
 * @desc Waits for skew changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceTarget
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakTarget
 * @text Action Sequences - Target
 * @desc If using a manual target by target Action Sequence,
 * these commands will give you full control over its usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_CurrentIndex
 * @text TARGET: Current Index
 * @desc Sets the current index to this value.
 * Then decide to jump to a label (optional).
 * 
 * @arg Index:eval
 * @text Set Index To
 * @desc Sets current targeting index to this value.
 * 0 is the starting index of a target group.
 * @default 0
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_NextTarget
 * @text TARGET: Next Target
 * @desc Moves index forward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_PrevTarget
 * @text TARGET: Previous Target
 * @desc Moves index backward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_RandTarget
 * @text TARGET: Random Target
 * @desc Sets index randomly to determine new currernt target.
 * Then decide to jump to a label (optional).
 * 
 * @arg ForceRandom:eval
 * @text Force Random?
 * @type boolean
 * @on On
 * @off Off
 * @desc Index cannot be its previous index amount after random.
 * @default false
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceWeapon
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakWeapon
 * @text Action Sequences - Weapon
 * @desc Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_ClearActiveWeapon
 * @text WEAPON: Clear Weapon Slot
 * @desc Clears the active weapon slot (making others valid again).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to clear the active weapon slot for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_NextActiveWeapon
 * @text WEAPON: Next Weapon Slot
 * @desc Goes to next active weapon slot (making others invalid).
 * If next slot is weaponless, don't label jump.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the next active weapon slot for.
 * @default ["user"]
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a weapon is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_SetActiveWeapon
 * @text WEAPON: Set Weapon Slot
 * @desc Sets the active weapon slot (making others invalid).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the active weapon slot for.
 * @default ["user"]
 * 
 * @arg SlotID:eval
 * @text Weapon Slot ID
 * @desc Select weapon slot to make active (making others invalid).
 * Use 0 to clear and normalize. You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceZoom
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakZoom
 * @text Action Sequences - Zoom
 * @desc Allows you to have control over the screen zoom.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Scale
 * @text ZOOM: Change Scale
 * @desc Changes the zoom scale.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Scale:eval
 * @text Scale
 * @desc The zoom scale to change to.
 * @default 1.0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Reset
 * @text ZOOM: Reset Zoom
 * @desc Reset any zoom settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_WaitForZoom
 * @text ZOOM: Wait For Zoom
 * @desc Waits for zoom to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceEnd
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param AutoBattle:struct
 * @text Auto Battle Settings
 * @type struct<AutoBattle>
 * @desc Settings pertaining to Auto Battle.
 * @default {"BattleDisplay":"","AutoBattleMsg:str":"Press %1 or %2 to stop Auto Battle","AutoBattleOK:str":"OK","AutoBattleCancel:str":"Cancel","AutoBattleBgType:num":"1","AutoBattleRect:func":"\"const width = Graphics.width;\\nconst height = this.calcWindowHeight(1, false);\\nconst x = 0;\\nconst y = (Graphics.height - height) / 2;\\nreturn new Rectangle(x, y, width, height);\"","Options":"","AddOption:eval":"true","AdjustRect:eval":"true","StartName:str":"Auto Battle Start","StyleName:str":"Auto Battle Style","StyleOFF:str":"Attack","StyleON:str":"Skills"}
 *
 * @param Damage:struct
 * @text Damage Settings
 * @type struct<Damage>
 * @desc Settings pertaining to damage calculations.
 * @default {"DamageStyles":"","DefaultDamageStyle:str":"Standard","DamageStyleList:arraystruct":"[\"{\\\"Name:str\\\":\\\"Standard\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"Armor Scaling\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"CT\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\\\\\nvalue = attackStat * 4;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"D4\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nlet stat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n    armor = 0;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n    armor = 0;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"DQ\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Get Primary Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Check for Recovery\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    let value = stat * multiplier * sign;\\\\\\\\n    return isNaN(value) ? 0 : value;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = 0;\\\\\\\\nif (stat < ((2 + armor) / 2)) {\\\\\\\\n    // Plink Damage\\\\\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\\\\\n    value = baseline / 3;\\\\\\\\n} else {\\\\\\\\n    // Normal Damage\\\\\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\\\\\n    value = baseline / 2;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF7\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare base Damage\\\\\\\\nlet baseDamage = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = 6 * (a.mat + level);\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.def + level);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.mdf + level);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Final Damage\\\\\\\\nlet value = baseDamage;\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    value += 22 * power;\\\\\\\\n} else {\\\\\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF8\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Damage\\\\\\\\nlet Value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\\\\\n    value *= power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.mat + power;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\\\\\n    value *= power / 256;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = (power + a.def) * power / 2;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = (power + a.mdf) * power / 2;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF9\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Main Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Base Damage\\\\\\\\nlet baseDamage = power;\\\\\\\\nif (this.isPhysical()) {\\\\\\\\n    baseDamage += stat;\\\\\\\\n}\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    baseDamage -= armor;\\\\\\\\n    baseDamage = Math.max(1, baseDamage);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Bonus Damage\\\\\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\\\\\n\\\\\\\\n// Declare Final Damage\\\\\\\\nlet value = baseDamage * bonusDamage * sign;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF10\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Create Damage Offense Value\\\\\\\\nlet value = power;\\\\\\\\n\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.def + power) / 2);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.mdf + power) / 2);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Damage Defense Value\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\\\\\n    armor = Math.max(armor, 1);\\\\\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\\\\\n} else if (this.isRecover()) {\\\\\\\\n    value *= -1;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MK\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nconst denominator = Math.max(200 + armor, 1);\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.atk / denominator;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.mat / denominator;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.def / 200;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.mdf / 200;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MOBA\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Value\\\\\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\\\\\n\\\\\\\\n// Apply Attacker's Offense Parameter\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value *= a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value *= a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"PKMN\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\"]","Cap":"","EnableDamageCap:eval":"false","DefaultHardCap:num":"9999","EnableSoftCap:eval":"false","DefaultSoftCap:num":"0.80","DefaultSoftScaler:num":"0.1275","Popups":"","PopupDuration:num":"128","NewPopupBottom:eval":"true","PopupPosition:str":"base","PopupOffsetX:num":"0","PopupOffsetY:num":"0","PopupShiftX:num":"8","PopupShiftY:num":"-28","hpDamageFmt:str":"-%1","hpHealingFmt:str":"+%1","mpDamageFmt:str":"-%1 %2","mpHealingFmt:str":"+%1 %2","CriticalColor:eval":"[255, 0, 0, 160]","CriticalDuration:num":"128","Formulas":"","OverallFormulaJS:func":"\"// Declare Constants\\nconst target = arguments[0];\\nconst critical = arguments[1];\\nconst item = this.item();\\n\\n// Get Base Damage\\nconst baseValue = this.evalDamageFormula(target);\\n\\n// Calculate Element Modifiers\\nlet value = baseValue * this.calcElementRate(target);\\n\\n// Calculate Physical and Magical Modifiers\\nif (this.isPhysical()) {\\n    value *= target.pdr;\\n}\\nif (this.isMagical()) {\\n    value *= target.mdr;\\n}\\n\\n// Apply Healing Modifiers\\nif (baseValue < 0) {\\n    value *= target.rec;\\n}\\n\\n// Apply Critical Modifiers\\nif (critical) {\\n    value = this.applyCritical(value);\\n}\\n\\n// Apply Variance and Guard Modifiers\\nvalue = this.applyVariance(value, item.damage.variance);\\nvalue = this.applyGuard(value, target);\\n\\n// Finalize Damage\\nvalue = Math.round(value);\\nreturn value;\"","VarianceFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst variance = arguments[1];\\n\\n// Calculate Variance\\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\\n\\n// Return Damage\\nreturn damage >= 0 ? damage + v : damage - v;\"","GuardFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst target = arguments[1];\\n\\n// Return Damage Early\\nconst note = this.item().note;\\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\\nif (!target.isGuard()) return damage;\\nif (damage < 0) return damage;\\n\\n// Declare Guard Rate\\nlet guardRate = 0.5;\\nguardRate /= target.grd;\\n\\n// Return Damage\\nreturn damage * guardRate;\"","Critical":"","CriticalHitRateJS:func":"\"// Declare Constants\\nconst user = this.subject();\\nconst target = arguments[0];\\n\\n// Create Base Critical Rate\\nlet rate = this.subject().cri * (1 - target.cev);\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<ALWAYS CRITICAL>/i)) {\\n    return 1;\\n}\\nif (note.match(/<SET CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    return Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    rate *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    rate += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL RATE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL RATE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Apply LUK Buffs/Debuffs\\nconst lukStack = this.subject().buff(7);\\nrate *= 2 ** lukStack;\\n\\n// Return Rate\\nreturn rate;\"","CriticalHitMultiplier:func":"\"// Declare Constants\\nconst user = this.subject();\\nlet damage = arguments[0];\\nlet multiplier = 2.0;\\nlet bonusDamage = this.subject().luk * this.subject().cri;\\nif (this.isHpRecover() || this.isMpRecover()) {\\n    bonusDamage *= -1;\\n}\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\\\d+)([%％])>/i)) {\\n    multiplier = Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    multiplier += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\\\d+)([%％])>/i)) {\\n    bonusDamage *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL DAMAGE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL DAMAGE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Return Damage\\nreturn damage * multiplier + bonusDamage;\""}
 *
 * @param Mechanics:struct
 * @text Mechanics Settings
 * @type struct<Mechanics>
 * @desc Settings pertaining to various game mechanics.
 * @default {"ActionSpeed":"","AllowRandomSpeed:eval":"false","CalcActionSpeedJS:func":"\"// Declare Constants\\nconst agi = this.subject().agi;\\n\\n// Create Speed\\nlet speed = agi;\\nif (this.allowRandomSpeed()) {\\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\\n}\\nif (this.item()) {\\n    speed += this.item().speed;\\n}\\nif (this.isAttack()) {\\n    speed += this.subject().attackSpeed();\\n}\\n\\n// Return Speed\\nreturn speed;\"","BaseTroop":"","BaseTroopIDs:arraynum":"[\"1\"]","CommonEvents":"","BattleStartEvent:num":"0","BattleEndEvent:num":"0","VictoryEvent:num":"0","DefeatEvent:num":"0","EscapeSuccessEvent:num":"0","EscapeFailEvent:num":"0","Escape":"","CalcEscapeRatioJS:func":"\"// Calculate Escape Ratio\\nlet ratio = 0.5;\\nratio *= $gameParty.agility();\\nratio /= $gameTroop.agility();\\n\\n// Return Ratio\\nreturn ratio;\"","CalcEscapeRaiseJS:func":"\"// Calculate Escape Ratio\\nlet value = 0.1;\\nvalue += $gameParty.aliveMembers().length;\\n\\n// Return Value\\nreturn value;\"","BattleJS":"","PreStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleVictoryJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeSuccessJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeFailureJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleDefeatJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","TurnJS":"","PreStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","ActionJS":"","PreStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PreApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\""}
 *
 * @param CmdWindows
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleLayout:struct
 * @text Battle Layout Settings
 * @type struct<BattleLayout>
 * @desc Settings that adjust how the battle layout appears.
 * @default {"Style:str":"default","ListStyle":"","ShowFacesListStyle:eval":"true","CommandWidth:num":"192","XPStyle":"","XPActorCommandLines:num":"4","XPActorDefaultHeight:num":"64","XPSpriteYLocation:str":"name","PotraitStyle":"","ShowPortraits:eval":"true","PortraitScale:num":"0.5","BorderStyle":"","SkillItemBorderCols:num":"1","ShowPortraitsBorderStyle:eval":"true","PortraitScaleBorderStyle:num":"1.25","SkillItemWindows":"","SkillItemMiddleLayout:eval":"false","SkillItemStandardCols:num":"2"}
 *
 * @param BattleLog:struct
 * @text Battle Log Settings
 * @type struct<BattleLog>
 * @desc Settings that adjust how Window_BattleLog behaves.
 * @default {"General":"","BackColor:str":"#000000","MaxLines:num":"10","MessageWait:num":"16","TextAlign:str":"center","BattleLogRectJS:func":"\"const wx = 0;\\nconst wy = 0;\\nconst ww = Graphics.boxWidth;\\nconst wh = this.calcWindowHeight(10, false);\\nreturn new Rectangle(wx, wy, ww, wh);\"","StartTurn":"","StartTurnShow:eval":"true","StartTurnMsg:str":"Turn %1","StartTurnWait:num":"40","DisplayAction":"","ActionCenteredName:eval":"true","ActionSkillMsg1:eval":"false","ActionSkillMsg2:eval":"true","ActionItemMsg:eval":"false","ActionChanges":"","ShowCounter:eval":"true","ShowReflect:eval":"true","ShowSubstitute:eval":"true","ActionResults":"","ShowFailure:eval":"false","ShowCritical:eval":"false","ShowMissEvasion:eval":"false","ShowHpDmg:eval":"false","ShowMpDmg:eval":"false","ShowTpDmg:eval":"false","DisplayStates":"","ShowAddedState:eval":"false","ShowRemovedState:eval":"false","ShowCurrentState:eval":"false","ShowAddedBuff:eval":"false","ShowAddedDebuff:eval":"false","ShowRemovedBuff:eval":"false"}
 *
 * @param Battleback:struct
 * @text Battleback Scaling
 * @type struct<Battleback>
 * @desc Settings that adjust how battlebacks scale.
 * @default {"DefaultStyle:str":"MZ","jsOneForOne:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst scale = 1.0;\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = 0;\\nthis.y = 0;\"","jsScaleToFit:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = this.width / this.bitmap.width;\\nconst ratioY = this.height / this.bitmap.height;\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScaleDown:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScale Up:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\""}
 *
 * @param PartyCmd:struct
 * @text Party Command Window
 * @type struct<PartyCmd>
 * @desc Settings that alter the Party Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconFight:num":"76","CommandAddAutoBattle:eval":"true","CmdIconAutoBattle:num":"78","CmdTextAutoBattle:str":"Auto","CommandAddOptions:eval":"true","CmdIconOptions:num":"83","ActiveTpbOptionsMessage:str":"Options Menu queued after action is complete.","CmdIconEscape:num":"82","Access":"","SkipPartyCmd:eval":"true","DisablePartyCmd:eval":"false","HelpWindow":"","HelpFight:str":"Select actions to fight.","HelpAutoBattle:str":"Sets party to Auto Battle mode.","HelpOptions:str":"Opens up the Options Menu.","HelpEscape:str":"Attempt to escape the battle."}
 *
 * @param ActorCmd:struct
 * @text Actor Command Window
 * @type struct<ActorCmd>
 * @desc Settings that alter the Actor Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconItem:num":"176","IconStypeNorm:num":"78","IconStypeMagic:num":"79","BattleCmd":"","BattleCmdList:arraystr":"[\"attack\",\"skills\",\"guard\",\"item\",\"escape\"]","HelpWindow":"","HelpSkillType:str":"Opens up a list of skills under the \\C[16]%1\\C[0] category.","HelpItem:str":"Opens up a list of items that you can use.","HelpEscape:str":"Attempt to escape the battle.","HelpAutoBattle:str":"Automatically choose an action suitable for combat."}
 *
 * @param VisualBreak
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Actor:struct
 * @text Actor Battler Settings
 * @type struct<Actor>
 * @desc Settings that alter various properties for actors.
 * @default {"Flinch":"","FlinchDistanceX:num":"12","FlinchDistanceY:num":"0","FlinchDuration:num":"6","SvBattlers":"","AnchorX:num":"0.5","AnchorY:num":"1.0","ChantStyle:eval":"true","OffsetX:num":"0","OffsetY:num":"0","MotionSpeed:num":"12","PrioritySortActive:eval":"true","PrioritySortActors:eval":"false","Shadow:eval":"true","SmoothImage:eval":"true","HomePosJS:func":"\"// Declare Constants\\nconst sprite = this;\\nconst actor = this._actor;\\nconst index = arguments[0];\\n\\n// Make Calculations\\nlet x = Math.round((Graphics.width / 2) + 192)\\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\\nx += index * 32;\\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\\ny += index * 48;\\n\\n// Home Position Offsets\\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\\\+\\\\-]\\\\d+),[ ]([\\\\+\\\\-]\\\\d+)>/i;\\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\\nx = xOffsets.reduce((r, offset) => r + offset, x);\\ny = yOffsets.reduce((r, offset) => r + offset, y);\\n\\n// Set Home Position\\nthis.setHome(x, y);\""}
 *
 * @param Enemy:struct
 * @text Enemy Battler Settings
 * @type struct<Enemy>
 * @desc Settings that alter various properties for enemies.
 * @default {"Visual":"","AttackAnimation:num":"1","EmergeText:eval":"false","OffsetX:num":"0","OffsetY:num":"0","SmoothImage:eval":"true","SelectWindow":"","FrontViewSelect:eval":"false","SideviewSelect:eval":"true","NameFontSize:num":"22","SvBattlers":"","AllowCollapse:eval":"false","AnchorX:num":"0.5","AnchorY:num":"1.0","MotionIdle:str":"walk","Shadow:eval":"true","Width:num":"64","Height:num":"64","WtypeId:num":"0"}
 *
 * @param HpGauge:struct
 * @text HP Gauge Settings
 * @type struct<HpGauge>
 * @desc Settings that adjust the visual HP Gauge displayed in battle.
 * @default {"Display":"","ShowActorGauge:eval":"false","ShowEnemyGauge:eval":"true","RequiresDefeat:eval":"false","BTestBypass:eval":"true","Settings":"","AnchorX:num":"0.5","AnchorY:num":"1.0","Scale:num":"0.5","OffsetX:num":"0","OffsetY:num":"-3","Options":"","AddHpGaugeOption:eval":"true","AdjustRect:eval":"true","Name:str":"Show HP Gauge"}
 *
 * @param ActionSequence:struct
 * @text Action Sequence Settings
 * @type struct<ActionSequence>
 * @desc Settings that adjust how certain Action Sequences work.
 * @default {"AutoSequences":"","AutoMeleeSolo:eval":"true","AutoMeleeAoE:eval":"true","CastAnimations":"","CastCertain:num":"120","CastPhysical:num":"52","CastMagical:num":"51","CounterReflection":"","CounterPlayback:eval":"true","ReflectAnimation:num":"53","ReflectPlayback:eval":"true","Stepping":"","MeleeDistance:num":"24","StepDistanceX:num":"48","StepDistanceY:num":"0","StepDuration:num":"12"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Auto Battle Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~AutoBattle:
 *
 * @param BattleDisplay
 * @text Battle Display
 *
 * @param AutoBattleMsg:str
 * @text Message
 * @parent BattleDisplay
 * @desc Message that's displayed when Auto Battle is on.
 * Text codes allowed. %1 - OK button, %2 - Cancel button
 * @default Press %1 or %2 to stop Auto Battle
 *
 * @param AutoBattleOK:str
 * @text OK Button
 * @parent BattleDisplay
 * @desc Text used to represent the OK button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default OK
 *
 * @param AutoBattleCancel:str
 * @text Cancel Button
 * @parent BattleDisplay
 * @desc Text used to represent the Cancel button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default Cancel
 *
 * @param AutoBattleBgType:num
 * @text Background Type
 * @parent BattleDisplay
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for Auto Battle window.
 * @default 1
 *
 * @param AutoBattleRect:func
 * @text JS: X, Y, W, H
 * @parent BattleDisplay
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = Graphics.width;\nconst height = this.calcWindowHeight(1, false);\nconst x = 0;\nconst y = (Graphics.height - height) / 2;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param Options
 *
 * @param AddOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the Auto Battle options to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param StartName:str
 * @text Startup Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Start
 *
 * @param StyleName:str
 * @text Style Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Style
 *
 * @param StyleOFF:str
 * @text OFF
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is OFF.
 * @default Attack
 *
 * @param StyleON:str
 * @text ON
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is ON.
 * @default Skills
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Damage:
 *
 * @param DamageStyles
 * @text Damage Styles
 *
 * @param DefaultDamageStyle:str
 * @text Default Style
 * @parent DamageStyles
 * @desc Which Damage Style do you want to set as default?
 * Use 'Manual' to not use any styles at all.
 * @default Standard
 *
 * @param DamageStyleList:arraystruct
 * @text Style List
 * @parent DamageStyles
 * @type struct<DamageStyle>[]
 * @desc A list of the damage styles available.
 * These are used to calculate base damage.
 * @default ["{\"Name:str\":\"Standard\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"Armor Scaling\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"CT\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\nvalue = attackStat * 4;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"D4\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nlet stat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n    armor = 0;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n    armor = 0;\\\\n}\\\\n\\\\n// Calculate Damage \\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"DQ\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\n}\\\\n\\\\n// Get Primary Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Check for Recovery\\\\nif (this.isRecover()) {\\\\n    let value = stat * multiplier * sign;\\\\n    return isNaN(value) ? 0 : value;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = 0;\\\\nif (stat < ((2 + armor) / 2)) {\\\\n    // Plink Damage\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\n    value = baseline / 3;\\\\n} else {\\\\n    // Normal Damage\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\n    value = baseline / 2;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF7\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare base Damage\\\\nlet baseDamage = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = 6 * (a.mat + level);\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.def + level);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.mdf + level);\\\\n}\\\\n\\\\n// Calculate Final Damage\\\\nlet value = baseDamage;\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isRecover()) {\\\\n    value += 22 * power;\\\\n} else {\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF8\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Damage\\\\nlet Value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\n    value *= power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.mat + power;\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\n    value *= power / 256;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = (power + a.def) * power / 2;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = (power + a.mdf) * power / 2;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF9\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Declare Main Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Declare Base Damage\\\\nlet baseDamage = power;\\\\nif (this.isPhysical()) {\\\\n    baseDamage += stat;\\\\n}\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    baseDamage -= armor;\\\\n    baseDamage = Math.max(1, baseDamage);\\\\n}\\\\n\\\\n// Declare Bonus Damage\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\n\\\\n// Declare Final Damage\\\\nlet value = baseDamage * bonusDamage * sign;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF10\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Create Damage Offense Value\\\\nlet value = power;\\\\n\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = power * ((a.def + power) / 2);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = power * ((a.mdf + power) / 2);\\\\n}\\\\n\\\\n// Apply Damage Defense Value\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\n    armor = Math.max(armor, 1);\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\n} else if (this.isRecover()) {\\\\n    value *= -1;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MK\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nconst denominator = Math.max(200 + armor, 1);\\\\n\\\\n// Calculate Damage \\\\nlet value = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.atk / denominator;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.mat / denominator;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = 200 * a.def / 200;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = 200 * a.mdf / 200;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MOBA\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Value\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\n\\\\n// Apply Attacker's Offense Parameter\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value *= a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value *= a.mdf;\\\\n}\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"PKMN\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}"]
 *
 * @param Cap
 * @text Damage Cap
 *
 * @param EnableDamageCap:eval
 * @text Enable Damage Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Put a maximum hard damage cap on how far damage can go?
 * This can be broken through the usage of notetags.
 * @default false
 *
 * @param DefaultHardCap:num
 * @text Default Hard Cap
 * @parent EnableDamageCap:eval
 * @type number
 * @min 1
 * @desc The default hard damage cap used before applying damage.
 * @default 9999
 *
 * @param EnableSoftCap:eval
 * @text Enable Soft Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Soft caps ease in the damage values leading up to the 
 * hard damage cap. Requires hard Damage Cap enabled.
 * @default false
 *
 * @param DefaultSoftCap:num
 * @text Base Soft Cap Rate
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.80
 *
 * @param DefaultSoftScaler:num
 * @text Soft Scale Constant
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.1275
 *
 * @param Popups
 *
 * @param PopupDuration:num
 * @text Popup Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a popup stays visible.
 * @default 128
 *
 * @param NewPopupBottom:eval
 * @text Newest Popups Bottom
 * @parent Popups
 * @type boolean
 * @on Bottom
 * @off Top
 * @desc Puts the newest popups at the bottom.
 * @default true
 *
 * @param PopupPosition:str
 * @text Appear Position
 * @parent Popups
 * @type select
 * @option Head - At the top of the battler.
 * @value head
 * @option Center - At the center of the battler.
 * @value center
 * @option Base - At the foot of the battler.
 * @value base
 * @desc Selects where you want popups to appear relative to the battler.
 * @default base
 *
 * @param PopupOffsetX:num
 * @text Offset X
 * @parent Popups
 * @desc Sets how much to offset the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param PopupOffsetY:num
 * @text Offset Y
 * @parent Popups
 * @desc Sets how much to offset the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param PopupShiftX:num
 * @text Shift X
 * @parent Popups
 * @desc Sets how much to shift the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 8
 *
 * @param PopupShiftY:num
 * @text Shift Y
 * @parent Popups
 * @desc Sets how much to shift the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default -28
 *
 * @param hpDamageFmt:str
 * @text HP Damage Format
 * @parent Popups
 * @desc Determines HP damage format for popup.
 * %1 - Value, %2 - HP Text
 * @default -%1
 *
 * @param hpHealingFmt:str
 * @text HP Healing Format
 * @parent Popups
 * @desc Determines HP healing format for popup.
 * %1 - Value, %2 - HP Text
 * @default +%1
 *
 * @param mpDamageFmt:str
 * @text MP Damage Format
 * @parent Popups
 * @desc Determines MP damage format for popup.
 * %1 - Value, %2 - MP Text
 * @default -%1 %2
 *
 * @param mpHealingFmt:str
 * @text MP Healing Format
 * @parent Popups
 * @desc Determines MP healing format for popup.
 * %1 - Value, %2 - MP Text
 * @default +%1 %2
 *
 * @param CriticalColor:eval
 * @text Critical Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 *
 * @param CriticalDuration:num
 * @text Critical Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a the flash lasts.
 * @default 128
 *
 * @param Formulas
 *
 * @param OverallFormulaJS:func
 * @text JS: Overall Formula
 * @parent Formulas
 * @type note
 * @desc The overall formula used when calculating damage.
 * @default "// Declare Constants\nconst target = arguments[0];\nconst critical = arguments[1];\nconst item = this.item();\n\n// Get Base Damage\nconst baseValue = this.evalDamageFormula(target);\n\n// Calculate Element Modifiers\nlet value = baseValue * this.calcElementRate(target);\n\n// Calculate Physical and Magical Modifiers\nif (this.isPhysical()) {\n    value *= target.pdr;\n}\nif (this.isMagical()) {\n    value *= target.mdr;\n}\n\n// Apply Healing Modifiers\nif (baseValue < 0) {\n    value *= target.rec;\n}\n\n// Apply Critical Modifiers\nif (critical) {\n    value = this.applyCritical(value);\n}\n\n// Apply Variance and Guard Modifiers\nvalue = this.applyVariance(value, item.damage.variance);\nvalue = this.applyGuard(value, target);\n\n// Finalize Damage\nvalue = Math.round(value);\nreturn value;"
 *
 * @param VarianceFormulaJS:func
 * @text JS: Variance Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage variance.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst variance = arguments[1];\n\n// Calculate Variance\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\n\n// Return Damage\nreturn damage >= 0 ? damage + v : damage - v;"
 *
 * @param GuardFormulaJS:func
 * @text JS: Guard Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage is guarded.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst target = arguments[1];\n\n// Return Damage Early\nconst note = this.item().note;\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\nif (!target.isGuard()) return damage;\nif (damage < 0) return damage;\n\n// Declare Guard Rate\nlet guardRate = 0.5;\nguardRate /= target.grd;\n\n// Return Damage\nreturn damage * guardRate;"
 *
 * @param Critical
 * @text Critical Hits
 *
 * @param CriticalHitRateJS:func
 * @text JS: Rate Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Rates.
 * @default "// Declare Constants\nconst user = this.subject();\nconst target = arguments[0];\n\n// Create Base Critical Rate\nlet rate = this.subject().cri * (1 - target.cev);\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<ALWAYS CRITICAL>/i)) {\n    return 1;\n}\nif (note.match(/<SET CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    return Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    rate *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    rate += Number(RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL RATE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL RATE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Apply LUK Buffs/Debuffs\nconst lukStack = this.subject().buff(7);\nrate *= 2 ** lukStack;\n\n// Return Rate\nreturn rate;"
 *
 * @param CriticalHitMultiplier:func
 * @text JS: Damage Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Damage modification.
 * @default "// Declare Constants\nconst user = this.subject();\nlet damage = arguments[0];\nlet multiplier = 2.0;\nlet bonusDamage = this.subject().luk * this.subject().cri;\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\d+)([%％])>/i)) {\n    multiplier = Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    multiplier += Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\d+)([%％])>/i)) {\n    bonusDamage *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL DAMAGE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL DAMAGE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Return Damage\nreturn damage * multiplier + bonusDamage;"
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Formula Style
 * ----------------------------------------------------------------------------
 */
/*~struct~DamageStyle:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Damage Style.
 * Used for notetags and such.
 * @default Untitled
 *
 * @param Formula:func
 * @text JS: Formula
 * @parent Name:str
 * @type note
 * @desc The base formula for this Damage Style.
 * @default "// Define Constants\nconst item = this.item();\nconst a = this.subject();\nconst b = target;\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\n\n// Create Damage Value\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\n\n// Return Value\nreturn isNaN(value) ? 0 : value;"
 *
 * @param ItemsEquipsCore
 * @text Items & Equips Core
 *
 * @param DamageType
 * @text Damage Label
 * @parent ItemsEquipsCore
 *
 * @param DamageType1:str
 * @text HP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType2:str
 * @text MP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType3:str
 * @text HP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType4:str
 * @text MP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType5:str
 * @text HP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageType6:str
 * @text MP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageDisplay:func
 * @text JS: Damage Display
 * @parent ItemsEquipsCore
 * @type note
 * @desc Code used the data displayed for this category.
 * @default "// Define Constants\nconst item = this._item;\nconst formula = item.damage.formula;\nconst a = this._tempActorA;\nconst b = this._tempActorB;\nconst user = a;\nconst target = b;\n\n// Return Value\ntry {\n    const value = Math.max(eval(formula), 0);\n    return '%1%'.format(Math.round(value * 100));\n} catch (e) {\n    if ($gameTemp.isPlaytest()) {\n        console.log('Damage Formula Error for %1'.format(this._item.name));\n    }\n    return '?????';\n}"
 *
 */
/* ----------------------------------------------------------------------------
 * Mechanics Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Mechanics:
 *
 * @param ActionSpeed
 * @text Action Speed
 *
 * @param AllowRandomSpeed:eval
 * @text Allow Random Speed?
 * @parent ActionSpeed
 * @type boolean
 * @on Allow
 * @off Disable
 * @desc Allow speed to be randomized base off the user's AGI?
 * @default false
 *
 * @param CalcActionSpeedJS:func
 * @text JS: Calculate
 * @parent ActionSpeed
 * @type note
 * @desc Code used to calculate action speed.
 * @default "// Declare Constants\nconst agi = this.subject().agi;\n\n// Create Speed\nlet speed = agi;\nif (this.allowRandomSpeed()) {\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\n}\nif (this.item()) {\n    speed += this.item().speed;\n}\nif (this.isAttack()) {\n    speed += this.subject().attackSpeed();\n}\n\n// Return Speed\nreturn speed;"
 *
 * @param BaseTroop
 * @text Base Troop
 *
 * @param BaseTroopIDs:arraynum
 * @text Base Troop ID's
 * @parent BaseTroop
 * @type troop[]
 * @desc Select the Troop ID(s) to duplicate page events from for all other troops.
 * @default ["1"]
 *
 * @param CommonEvents
 * @text Common Events (on Map)
 *
 * @param BattleStartEvent:num
 * @text Pre-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Common Event to run before each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param BattleEndEvent:num
 * @text Post-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run after each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param VictoryEvent:num
 * @text Victory Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon victory on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param DefeatEvent:num
 * @text Defeat Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon defeat on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeSuccessEvent:num
 * @text Escape Success Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape success on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeFailEvent:num
 * @text Escape Fail Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape failure on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param Escape
 *
 * @param CalcEscapeRatioJS:func
 * @text JS: Calc Escape Ratio
 * @parent Escape
 * @type note
 * @desc Code used to calculate the escape success ratio.
 * @default "// Calculate Escape Ratio\nlet ratio = 0.5;\nratio *= $gameParty.agility();\nratio /= $gameTroop.agility();\n\n// Return Ratio\nreturn ratio;"
 *
 * @param CalcEscapeRaiseJS:func
 * @text JS: Calc Escape Raise
 * @parent Escape
 * @type note
 * @desc Code used to calculate how much the escape success ratio raises upon each failure.
 * @default "// Calculate Escape Ratio\nlet value = 0.1;\nvalue += $gameParty.aliveMembers().length;\n\n// Return Value\nreturn value;"
 *
 * @param Switches
 *
 * @param SwitchCritical:num
 * @text Switch: Critical
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action performs a critical hit.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param SwitchMissEvade:num
 * @text Switch: Miss/Evade
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action misses/is evaded.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param Variables
 *
 * @param VariableDmg:num
 * @text Variable: Damage
 * @parent Variables
 * @type variable
 * @desc Variable records target damage during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param VariableHeal:num
 * @text Variable: Healing
 * @parent Variables
 * @type variable
 * @desc Variable records target healing during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param BattleJS
 * @text JS: Battle-Related
 * 
 * @param PreStartBattleJS:func
 * @text JS: Pre-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartBattleJS:func
 * @text JS: Post-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleVictoryJS:func
 * @text JS: Battle Victory
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processVictory()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeSuccessJS:func
 * @text JS: Escape Success
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeSuccess()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeFailureJS:func
 * @text JS: Escape Failure
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeFailure()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleDefeatJS:func
 * @text JS: Battle Defeat
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processDefeat()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param PreEndBattleJS:func
 * @text JS: Pre-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndBattleJS:func
 * @text JS: Post-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param TurnJS
 * @text JS: Turn-Related
 *
 * @param PreStartTurnJS:func
 * @text JS: Pre-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartTurnJS:func
 * @text JS: Post-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreEndTurnJS:func
 * @text JS: Pre-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndTurnJS:func
 * @text JS: Post-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreRegenerateJS:func
 * @text JS: Pre-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostRegenerateJS:func
 * @text JS: Post-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param ActionJS
 * @text JS: Action-Related
 *
 * @param PreStartActionJS:func
 * @text JS: Pre-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostStartActionJS:func
 * @text JS: Post-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PreApplyJS:func
 * @text JS: Pre-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreDamageJS:func
 * @text JS: Pre-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostDamageJS:func
 * @text JS: Post-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostApplyJS:func
 * @text JS: Post-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreEndActionJS:func
 * @text JS: Pre-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostEndActionJS:func
 * @text JS: Post-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Layout Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLayout:
 *
 * @param Style:str
 * @text Battle Layout Style
 * @type select
 * @option Default - Shows actor faces in Battle Status.
 * @value default
 * @option List - Lists actors in Battle Status.
 * @value list
 * @option XP - Shows actor battlers in a stretched Battle Status.
 * @value xp
 * @option Portrait - Shows portraits in a stretched Battle Status.
 * @value portrait
 * @option Border - Displays windows around the screen border.
 * @value border
 * @option Sideview Battle UI - Requires VisuMZ_3_SideviewBattleUI
 * @value sideview_ui
 * @desc The style used for the battle layout.
 * @default default
 *
 * @param ListStyle
 * @text List Style
 * @parent Style:str
 *
 * @param ShowFacesListStyle:eval
 * @text Show Faces
 * @parent ListStyle
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows faces in List Style?
 * @default true
 *
 * @param CommandWidth:num
 * @text Command Window Width
 * @parent ListStyle
 * @type number
 * @min 1
 * @desc Determine the window width for the Party and Actor Command
 * Windows. Affects Default and List Battle Layout styles.
 * @default 192
 *
 * @param XPStyle
 * @text XP Style
 * @parent Style:str
 *
 * @param XPActorCommandLines:num
 * @text Command Lines
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Number of action lines in the Actor Command Window for the XP Style.
 * @default 4
 *
 * @param XPActorDefaultHeight:num
 * @text Sprite Height
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Default sprite height used when if the sprite's height has not been determined yet.
 * @default 64
 *
 * @param XPSpriteYLocation:str
 * @text Sprite Base Location
 * @parent XPStyle
 * @type select
 * @option Above Name - Sprite is located above the name.
 * @value name
 * @option Bottom - Sprite is located at the bottom of the window.
 * @value bottom
 * @option Centered - Sprite is centered in the window.
 * @value center
 * @option Top - Sprite is located at the top of the window.
 * @value top
 * @desc Determine where the sprite is located on the Battle Status Window.
 * @default name
 *
 * @param PotraitStyle
 * @text Portrait Style
 * @parent Style:str
 *
 * @param ShowPortraits:eval
 * @text Show Portraits?
 * @parent PotraitStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait instead of a face.
 * @default true
 *
 * @param PortraitScale:num
 * @text Portrait Scaling
 * @parent PotraitStyle
 * @desc If portraits are used, scale them by this much.
 * @default 0.5
 *
 * @param BorderStyle
 * @text Border Style
 * @parent Style:str
 *
 * @param SkillItemBorderCols:num
 * @text Columns
 * @parent BorderStyle
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 1
 *
 * @param ShowPortraitsBorderStyle:eval
 * @text Show Portraits?
 * @parent BorderStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait at the edge of the screen.
 * @default true
 *
 * @param PortraitScaleBorderStyle:num
 * @text Portrait Scaling
 * @parent BorderStyle
 * @desc If portraits are used, scale them by this much.
 * @default 1.0
 *
 * @param SkillItemWindows
 * @text Skill & Item Windows
 *
 * @param SkillItemMiddleLayout:eval
 * @text Middle Layout
 * @parent SkillItemWindows
 * @type boolean
 * @on Middle
 * @off Bottom
 * @desc Shows the Skill & Item Windows in mid-screen?
 * @default false
 *
 * @param SkillItemStandardCols:num
 * @text Columns
 * @parent SkillItemWindows
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 2
 *
 * @param StatusWindow
 * @text Status Window Elements
 *
 * @param StatusWindowName
 * @text Battler Name
 * @parent StatusWindow
 *
 * @param NameOffsetX:num
 * @text Offset: X
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param NameOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowHpGauge
 * @text Gauge 1 (HP)
 * @parent StatusWindow
 *
 * @param HpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param HpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowMpGauge
 * @text Gauge 2 (MP)
 * @parent StatusWindow
 *
 * @param MpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param MpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpGauge
 * @text Gauge 3 (TP)
 * @parent StatusWindow
 *
 * @param TpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowStateIcon
 * @text State Icon
 * @parent StatusWindow
 *
 * @param StateIconOffsetX:num
 * @text Offset: X
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StateIconOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpbGauge
 * @text TPB/ATB Gauge
 * @parent StatusWindow
 *
 * @param TpbGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpbGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowSkin
 * @text Window Skin
 * @parent StatusWindow
 *
 * @param StatusWindowSkinFilename:str
 * @text Filename
 * @parent StatusWindowSkin
 * @type file
 * @dir img/system/
 * @desc Filename used for the Battle Status Window skin.
 * Leave this empty to use the default window skin.
 * @default 
 *
 * @param StatusWindowSkinHide:eval
 * @text Hide Window Skin?
 * @parent StatusWindowSkin
 * @type boolean
 * @on No Window Skin
 * @off Default Skin
 * @desc Show/Hide the window skin for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowSelectBack
 * @text Selectable Background
 * @parent StatusWindow
 *
 * @param StatusWindowSelectableBackHide:eval
 * @text Hide Selectable BG?
 * @parent StatusWindowSelectBack
 * @type boolean
 * @on No Selectable BG
 * @off Default Selectable BG
 * @desc Show/Hide the selectable background box for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowAttachments
 * @text Attachments
 * @parent StatusWindow
 *
 * @param StatusWindowBackAttachment
 * @text Back Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentBack:str
 * @text Filename
 * @parent StatusWindowBackAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the back of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentBackOffsetX:num
 * @text Offset: X
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentBackOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowFrontAttachment
 * @text Front Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentFront:str
 * @text Filename
 * @parent StatusWindowFrontAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the front of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentFrontOffsetX:num
 * @text Offset: X
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentFrontOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Log Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLog:
 *
 * @param General
 *
 * @param BackColor:str
 * @text Back Color
 * @parent General
 * @desc Use #rrggbb for a hex color.
 * @default #000000
 *
 * @param MaxLines:num
 * @text Max Lines
 * @parent General
 * @type number
 * @min 1
 * @desc Maximum number of lines to be displayed.
 * @default 10
 *
 * @param MessageWait:num
 * @text Message Wait
 * @parent General
 * @type number
 * @min 1
 * @desc Number of frames for a usual message wait.
 * @default 16
 *
 * @param TextAlign:str
 * @text Text Align
 * @parent General
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Window_BattleLog.
 * @default center
 *
 * @param BattleLogRectJS:func
 * @text JS: X, Y, W, H
 * @parent General
 * @type note
 * @desc Code used to determine the dimensions for the battle log.
 * @default "const wx = 0;\nconst wy = 0;\nconst ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(10, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param StartTurn
 * @text Start Turn
 *
 * @param StartTurnShow:eval
 * @text Show Start Turn?
 * @parent StartTurn
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display turn changes at the start of the turn?
 * @default false
 *
 * @param StartTurnMsg:str
 * @text Start Turn Message
 * @parent StartTurn
 * @desc Message displayed at turn start.
 * %1 - Turn Count
 * @default Turn %1
 *
 * @param StartTurnWait:num
 * @text Start Turn Wait
 * @parent StartTurn
 * @type number
 * @min 1
 * @desc Number of frames to wait after a turn started.
 * @default 40
 *
 * @param DisplayAction
 * @text Display Action
 *
 * @param ActionCenteredName:eval
 * @text Show Centered Action?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display a centered text of the action name?
 * @default true
 *
 * @param ActionSkillMsg1:eval
 * @text Show Skill Message 1?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 1st skill message?
 * @default false
 *
 * @param ActionSkillMsg2:eval
 * @text Show Skill Message 2?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 2nd skill message?
 * @default true
 *
 * @param ActionItemMsg:eval
 * @text Show Item Message?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the item use message?
 * @default false
 *
 * @param ActionChanges
 * @text Action Changes
 *
 * @param ShowCounter:eval
 * @text Show Counter?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display counter text?
 * @default true
 *
 * @param ShowReflect:eval
 * @text Show Reflect?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display magic reflection text?
 * @default true
 *
 * @param ShowSubstitute:eval
 * @text Show Substitute?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display substitute text?
 * @default true
 *
 * @param ActionResults
 * @text Action Results
 *
 * @param ShowFailure:eval
 * @text Show No Effect?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display no effect text?
 * @default false
 *
 * @param ShowCritical:eval
 * @text Show Critical?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display critical text?
 * @default false
 *
 * @param ShowMissEvasion:eval
 * @text Show Miss/Evasion?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display miss/evasion text?
 * @default false
 *
 * @param ShowHpDmg:eval
 * @text Show HP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display HP Damage text?
 * @default false
 *
 * @param ShowMpDmg:eval
 * @text Show MP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display MP Damage text?
 * @default false
 *
 * @param ShowTpDmg:eval
 * @text Show TP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display TP Damage text?
 * @default false
 *
 * @param DisplayStates
 * @text Display States
 *
 * @param ShowAddedState:eval
 * @text Show Added States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added states text?
 * @default false
 *
 * @param ShowRemovedState:eval
 * @text Show Removed States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed states text?
 * @default false
 *
 * @param ShowCurrentState:eval
 * @text Show Current States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the currently affected state text?
 * @default false
 *
 * @param ShowAddedBuff:eval
 * @text Show Added Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added buffs text?
 * @default false
 *
 * @param ShowAddedDebuff:eval
 * @text Show Added Debuffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added debuffs text?
 * @default false
 *
 * @param ShowRemovedBuff:eval
 * @text Show Removed Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed de/buffs text?
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Battleback Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Battleback:
 *
 * @param DefaultStyle:str
 * @text Default Style
 * @type select
 * @option MZ (MZ's default style)
 * @value MZ
 * @option 1:1 (No Scaling)
 * @value 1:1
 * @option Scale To Fit (Scale to screen size)
 * @value ScaleToFit
 * @option Scale Down (Scale Downward if Larger than Screen)
 * @value ScaleDown
 * @option Scale Up (Scale Upward if Smaller than Screen)
 * @value ScaleUp
 * @desc The default scaling style used for battlebacks.
 * @default MZ
 *
 * @param jsOneForOne:func
 * @text JS: 1:1
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst scale = 1.0;\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = 0;\nthis.y = 0;"
 *
 * @param jsScaleToFit:func
 * @text JS: Scale To Fit
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = this.width / this.bitmap.width;\nconst ratioY = this.height / this.bitmap.height;\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleDown:func
 * @text JS: Scale Down
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScale Up:func
 * @text JS: Scale Up
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 */
/* ----------------------------------------------------------------------------
 * Party Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~PartyCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Party Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Party Command Window.
 * @default left
 *
 * @param CmdIconFight:num
 * @text Fight Icon
 * @parent Cmd
 * @desc The icon used for the Fight command.
 * @default 76
 *
 * @param CommandAddAutoBattle:eval
 * @text Add Auto Battle?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Auto Battle" command to the Command Window?
 * @default true
 *
 * @param CmdIconAutoBattle:num
 * @text Auto Battle Icon
 * @parent CommandAddAutoBattle:eval
 * @desc The icon used for the Auto Battle command.
 * @default 78
 *
 * @param CmdTextAutoBattle:str
 * @text Auto Battle Text
 * @parent CommandAddAutoBattle:eval
 * @desc The text used for the Auto Battle command.
 * @default Auto
 *
 * @param CommandAddOptions:eval
 * @text Add Options?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Options" command to the Command Window?
 * @default true
 *
 * @param CmdIconOptions:num
 * @text Options Icon
 * @parent CommandAddOptions:eval
 * @desc The icon used for the Options command.
 * @default 83
 *
 * @param ActiveTpbOptionsMessage:str
 * @text Active TPB Message
 * @parent CommandAddOptions:eval
 * @desc Message that will be displayed when selecting options during the middle of an action.
 * @default Options Menu queued after action is complete.
 *
 * @param CmdIconEscape:num
 * @text Escape Icon
 * @parent Cmd
 * @desc The icon used for the Escape command.
 * @default 82
 *
 * @param Access
 *
 * @param SkipPartyCmd:eval
 * @text Skip Party Command
 * @parent Access
 * @type boolean
 * @on Skip
 * @off Don't
 * @desc DTB: Skip Party Command selection on turn start.
 * TPB: Skip Party Command selection at battle start.
 * @default true
 *
 * @param DisablePartyCmd:eval
 * @text Disable Party Command
 * @parent Access
 * @type boolean
 * @on Disable
 * @off Don't
 * @desc Disable the Party Command Window entirely?
 * @default false
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpFight:str
 * @text Fight
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Select actions to fight.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Sets party to Auto Battle mode.
 *
 * @param HelpOptions:str
 * @text Options
 * @parent HelpWindow
 * @desc Text displayed when selecting the Options command.
 * @default Opens up the Options Menu.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActorCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Actor Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Actor Command Window.
 * @default left
 *
 * @param CmdIconItem:num
 * @text Item Icon
 * @parent Cmd
 * @desc The icon used for the Item command.
 * @default 176
 *
 * @param IconStypeNorm:num
 * @text Normal SType Icon
 * @parent Cmd
 * @desc Icon used for normal skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 78
 *
 * @param IconStypeMagic:num
 * @text Magic SType Icon
 * @parent Cmd
 * @desc Icon used for magic skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 79
 *
 * @param BattleCmd
 * @text Battle Commands
 *
 * @param BattleCmdList:arraystr
 * @text Command List
 * @parent BattleCmd
 * @type combo[]
 * @option attack
 * @option skills
 * @option guard
 * @option item
 * @option party
 * @option escape
 * @option auto battle
 * @option stypes
 * @option stype: x
 * @option stype: name
 * @option all skills
 * @option skill: x
 * @option skill: name
 * @option combat log
 * @option talk
 * @option weapon swap
 * @desc List of battle commands that appear by default
 * if the <Battle Commands> notetag isn't present.
 * @default ["attack","skills","guard","party","item"]
 *
 * @param ShowCosts:eval
 * @text Show Command Costs
 * @parent BattleCmd
 * @type boolean
 * @on Show Costs
 * @off Hide Costs
 * @desc If a battle command has a resource cost, show it?
 * @default true
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpSkillType:str
 * @text Skill Types
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Opens up a list of skills under the \C[16]%1\C[0] category.
 *
 * @param HelpItem:str
 * @text Items
 * @parent HelpWindow
 * @desc Text displayed when selecting the item command.
 * @default Opens up a list of items that you can use.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Automatically choose an action suitable for combat.
 *
 * @param HelpParty:str
 * @text Party
 * @parent HelpWindow
 * @desc Text displayed when selecting the Party command.
 * Requires 
 * @default Automatically choose an action suitable for combat.
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Actor:
 *
 * @param Flinch
 *
 * @param FlinchDistanceX:num
 * @text Flinch Distance X
 * @parent Flinch
 * @desc The normal X distance when flinching.
 * @default 12
 *
 * @param FlinchDistanceY:num
 * @text Flinch Distance Y
 * @parent Flinch
 * @desc The normal Y distance when flinching.
 * @default 0
 *
 * @param FlinchDuration:num
 * @text Flinch Duration
 * @parent Flinch
 * @desc The number of frames for a flinch to complete.
 * @default 6
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param ChantStyle:eval
 * @text Chant Style
 * @parent SvBattlers
 * @type boolean
 * @on Magical Hit Type
 * @off Magical Skill Type
 * @desc What determines the chant motion?
 * Hit type or skill type?
 * @default true
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent SvBattlers
 * @desc Offsets X position where actor is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent SvBattlers
 * @desc Offsets Y position where actor is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param MotionSpeed:num
 * @text Motion Speed
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc The number of frames in between each motion.
 * @default 12
 *
 * @param PrioritySortActive:eval
 * @text Priority: Active
 * @parent SvBattlers
 * @type boolean
 * @on Active Actor over All Else
 * @off Active Actor is Sorted Normally
 * @desc Place the active actor on top of actor and enemy sprites.
 * @default false
 *
 * @param PrioritySortActors:eval
 * @text Priority: Actors
 * @parent SvBattlers
 * @type boolean
 * @on Actors over Enemies
 * @off Sort by Y Position
 * @desc Prioritize actors over enemies when placing sprites on top
 * of each other.
 * @default true
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent SvBattlers
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default false
 *
 * @param HomePosJS:func
 * @text JS: Home Position
 * @parent SvBattlers
 * @type note
 * @desc Code used to calculate the home position of actors.
 * @default "// Declare Constants\nconst sprite = this;\nconst actor = this._actor;\nconst index = arguments[0];\n\n// Make Calculations\nlet x = Math.round((Graphics.width / 2) + 192)\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\nx += index * 32;\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\ny += index * 48;\n\n// Home Position Offsets\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\+\\-]\\d+),[ ]([\\+\\-]\\d+)>/i;\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\nx = xOffsets.reduce((r, offset) => r + offset, x);\ny = yOffsets.reduce((r, offset) => r + offset, y);\n\n// Set Home Position\nthis.setHome(x, y);"
 *
 */
/* ----------------------------------------------------------------------------
 * Enemy Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Enemy:
 *
 * @param Visual
 *
 * @param AttackAnimation:num
 * @text Attack Animation
 * @parent Visual
 * @type animation
 * @desc Default attack animation used for enemies.
 * Use <Attack Animation: x> for custom animations.
 * @default 1
 *
 * @param EmergeText:eval
 * @text Emerge Text
 * @parent Visual
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide the 'Enemy emerges!' text at the start of battle.
 * @default false
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent Visual
 * @desc Offsets X position where enemy is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent Visual
 * @desc Offsets Y position where enemy is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent Visual
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default true
 *
 * @param SelectWindow
 * @text Select Window
 *
 * @param LastSelected:eval
 * @text Any: Last Selected
 * @parent SelectWindow
 * @type boolean
 * @on Last Selected
 * @off FV/SV Priority
 * @desc Prioritize last selected enemy over front view or sideview settings?
 * @default true
 *
 * @param FrontViewSelect:eval
 * @text FV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using frontview, auto select the enemy furthest right.
 * @default false
 *
 * @param SideviewSelect:eval
 * @text SV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using sideview, auto select the enemy furthest right.
 * @default true
 * 
 * @param Name
 *
 * @param NameLegacy:eval
 * @text Legacy Option
 * @parent Name
 * @type boolean
 * @on Legacy Version
 * @off New Version (Sprite)
 * @desc Use the legacy version (window) or new version (sprite).
 * WARNING: Legacy version is no longer supported for bugs.
 * @default false
 *
 * @param NameFontSize:num
 * @text Font Size
 * @parent Name
 * @desc Font size used for enemy names.
 * @default 22
 * 
 * @param NamePosition
 * @text Name Position
 * @parent Name
 *
 * @param NameOffsetX:num
 * @text Offset X
 * @parent NamePosition
 * @desc Offset the enemy name's X position by this much.
 * Negative goes left. Positive goes right.
 * @default 0
 *
 * @param NameOffsetY:num
 * @text Offset Y
 * @parent NamePosition
 * @desc Offset the enemy name's Y position by this much.
 * Negative goes up. Positive goes down.
 * @default 0
 *
 * @param NameAttachStateIcon:eval
 * @text Attach States
 * @parent Name
 * @type boolean
 * @on Attach
 * @off Normal Position
 * @desc Attach the enemy's state icon to the enemy name?
 * @default false
 *
 * @param AttachStateOffsetX:num
 * @text Attach: Offset X
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's X position by?
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param AttachStateOffsetY:num
 * @text Attach: Offset Y
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's Y position by?
 * Negative goes up. Positive goes down.
 * @default +0
 * 
 * @param NameVisibility
 * @text Name Visibility
 * @parent Name
 *
 * @param NameAlwaysHidden:eval
 * @text Always Hidden
 * @parent NameVisibility
 * @type boolean
 * @on Always Hidden
 * @off No Priority
 * @desc Determines if the enemy name will always be visible.
 * Highest priority.
 * @default false
 *
 * @param NameAlwaysVisible:eval
 * @text Always Visible
 * @parent NameVisibility
 * @type boolean
 * @on Always Visible
 * @off Hide when Unselected
 * @desc Determines if the enemy name will always be visible.
 * Medium priority.
 * @default false
 *
 * @param NameAlwaysSelectOnly:eval
 * @text By Selection?
 * @parent NameVisibility
 * @type boolean
 * @on Visible when Selected
 * @off Visible when Targeting
 * @desc Determines the conditions for enemy name visibility.
 * Lowest priority.
 * @default false
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AllowCollapse:eval
 * @text Allow Collapse
 * @parent SvBattlers
 * @type boolean
 * @on Allow
 * @off Don't
 * @desc Causes defeated enemies with SV Battler graphics
 * to "fade away" when defeated?
 * @default false
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param MotionIdle:str
 * @text Motion: Idle
 * @parent SvBattlers
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Sets default idle animation used by Sideview Battlers.
 * @default walk
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param Width:num
 * @text Size: Width
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default width for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param Height:num
 * @text Size: Height
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default height for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param WtypeId:num
 * @text Weapon Type
 * @parent SvBattlers
 * @type number
 * @min 0
 * @desc Sets default weapon type used by Sideview Battlers.
 * Use 0 for Bare Hands.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * HP Gauge Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~HpGauge:
 *
 * @param Display
 * @text Show Gauges For
 *
 * @param ShowActorGauge:eval
 * @text Actors
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the actor sprites' heads?
 * Requires SV Actors to be visible.
 * @default true
 *
 * @param ShowEnemyGauge:eval
 * @text Enemies
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the enemy sprites' heads?
 * Can be bypassed with <Hide HP Gauge> notetag.
 * @default true
 *
 * @param RequiresDefeat:eval
 * @text Requires Defeat?
 * @parent ShowEnemyGauge:eval
 * @type boolean
 * @on Require Defeat First
 * @off No Requirement
 * @desc Requires defeating the enemy once to show HP Gauge?
 * Can be bypassed with <Show HP Gauge> notetag.
 * @default true
 *
 * @param BTestBypass:eval
 * @text Battle Test Bypass?
 * @parent RequiresDefeat:eval
 * @type boolean
 * @on Bypass
 * @off Don't Bypass
 * @desc Bypass the defeat requirement in battle test?
 * @default true
 *
 * @param Settings
 *
 * @param AnchorX:num
 * @text Anchor X
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor X to be?
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor Y
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor Y to be?
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param Scale:num
 * @text Scale
 * @parent Settings
 * @desc How large/small do you want the HP Gauge to be scaled?
 * @default 0.5
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's X by?
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's Y by?
 * @default -3
 *
 * @param Options
 * @text Options
 *
 * @param AddHpGaugeOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Show HP Gauge' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @parent Options
 * @desc Command name of the option.
 * @default Show HP Gauge
 *
 */
/* ----------------------------------------------------------------------------
 * Action Sequence Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActionSequence:
 *
 * @param AutoSequences
 * @text Automatic Sequences
 *
 * @param AutoMeleeSolo:eval
 * @text Melee Single Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, single target actions?
 * @default true
 *
 * @param AutoMeleeAoE:eval
 * @text Melee Multi Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, multi-target actions?
 * @default true
 *
 * @param QoL
 * @text Quality of Life
 *
 * @param AutoNotetag:eval
 * @text Auto Notetag
 * @parent QoL
 * @type boolean
 * @on Automatic
 * @off Manual
 * @desc Automatically apply the <Custom Action Sequence> notetag
 * effect to any item or skill that has a Common Event?
 * @default false
 *
 * @param CastAnimations
 * @text Cast Animations
 *
 * @param CastCertain:num
 * @text Certain Hit
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Certain Hit skills.
 * @default 120
 *
 * @param CastPhysical:num
 * @text Physical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Physical skills.
 * @default 52
 *
 * @param CastMagical:num
 * @text Magical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Magical skills.
 * @default 51
 *
 * @param CounterReflection
 * @text Counter/Reflect
 *
 * @param CounterPlayback:eval
 * @text Counter Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param ReflectAnimation:num
 * @text Reflect Animation
 * @parent CounterReflection
 * @type animation
 * @desc Animation played when an action is reflected.
 * @default 53
 *
 * @param ReflectPlayback:eval
 * @text Reflect Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param Stepping
 *
 * @param MeleeDistance:num
 * @text Melee Distance
 * @parent Stepping
 * @desc Minimum distance in pixels for Movement Action Sequences.
 * @default 24
 *
 * @param StepDistanceX:num
 * @text Step Distance X
 * @parent Stepping
 * @desc The normal X distance when stepping forward.
 * @default 48
 *
 * @param StepDistanceY:num
 * @text Step Distance Y
 * @parent Stepping
 * @desc The normal Y distance when stepping forward.
 * @default 0
 *
 * @param StepDuration:num
 * @text Step Duration
 * @parent Stepping
 * @desc The number of frames for a stepping action to complete.
 * @default 12
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Start Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileStart:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Start from battler target(s)
 * @value target
 * @option Point - Start from a point on the screen
 * @value point
 * @desc Select where the projectile should start from.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to start the projectile from.
 * @default ["user"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Create one projectile at the center of the targets?
 * Or create a projectile for each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile from.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Goal Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileGoal:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Goal is battler target(s)
 * @value target
 * @option Point - Goal is a point on the screen
 * @value point
 * @desc Select where the projectile should go to.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for projectile to go to.
 * @default ["all targets"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Set goal in the center of targets?
 * Or create a projectile to go to each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile at.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Animation Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExAni:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the project's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExtra:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the project's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param BlendMode:num
 * @text Blend Mode
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the projectile?
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Hue:eval
 * @text Hue
 * @parent Settings
 * @desc Adjust the hue of the projectile.
 * Insert a number between 0 and 360.
 * @default 0
 * 
 * @param Scale:eval
 * @text Scale
 * @parent Settings
 * @desc Adjust the size scaling of the projectile.
 * Use decimals for exact control.
 * @default 1.0
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 *
 */
//=============================================================================

const _0xa8cad7=_0xfe26;(function(_0x3f9e8e,_0x3b91c5){const _0x447dab=_0xfe26,_0x46c51a=_0x3f9e8e();while(!![]){try{const _0x51f98c=parseInt(_0x447dab(0x4d5))/0x1+parseInt(_0x447dab(0xa36))/0x2+-parseInt(_0x447dab(0x267))/0x3*(parseInt(_0x447dab(0x29a))/0x4)+parseInt(_0x447dab(0x4f0))/0x5+-parseInt(_0x447dab(0x18d))/0x6+-parseInt(_0x447dab(0x6a6))/0x7+-parseInt(_0x447dab(0x219))/0x8*(-parseInt(_0x447dab(0x195))/0x9);if(_0x51f98c===_0x3b91c5)break;else _0x46c51a['push'](_0x46c51a['shift']());}catch(_0x26332d){_0x46c51a['push'](_0x46c51a['shift']());}}}(_0x4175,0x8b599));var label=_0xa8cad7(0x8a9),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0xa8cad7(0x1d2)](function(_0x12bc61){const _0x381db2=_0xa8cad7;return _0x12bc61[_0x381db2(0x56a)]&&_0x12bc61[_0x381db2(0xb55)][_0x381db2(0x220)]('['+label+']');})[0x0];VisuMZ[label][_0xa8cad7(0xb57)]=VisuMZ[label][_0xa8cad7(0xb57)]||{},VisuMZ[_0xa8cad7(0x17f)]=function(_0x63649d,_0x16bd75){const _0x2ec139=_0xa8cad7;for(const _0x22ac96 in _0x16bd75){if(_0x2ec139(0x54b)===_0x2ec139(0x8c7))return _0x39d6d1[_0x2ec139(0x8a9)][_0x2ec139(0xb57)][_0x2ec139(0x56f)]['SkillItemBorderCols'];else{if(_0x22ac96[_0x2ec139(0x21d)](/(.*):(.*)/i)){const _0x4a66bd=String(RegExp['$1']),_0xf47e=String(RegExp['$2'])[_0x2ec139(0x41c)]()[_0x2ec139(0xb45)]();let _0x146b87,_0x591401,_0x132a53;switch(_0xf47e){case'NUM':_0x146b87=_0x16bd75[_0x22ac96]!==''?Number(_0x16bd75[_0x22ac96]):0x0;break;case _0x2ec139(0x2b4):_0x591401=_0x16bd75[_0x22ac96]!==''?JSON[_0x2ec139(0x707)](_0x16bd75[_0x22ac96]):[],_0x146b87=_0x591401[_0x2ec139(0x369)](_0x4883b1=>Number(_0x4883b1));break;case'EVAL':_0x146b87=_0x16bd75[_0x22ac96]!==''?eval(_0x16bd75[_0x22ac96]):null;break;case _0x2ec139(0xb72):_0x591401=_0x16bd75[_0x22ac96]!==''?JSON['parse'](_0x16bd75[_0x22ac96]):[],_0x146b87=_0x591401[_0x2ec139(0x369)](_0x6f3abc=>eval(_0x6f3abc));break;case _0x2ec139(0x45c):_0x146b87=_0x16bd75[_0x22ac96]!==''?JSON[_0x2ec139(0x707)](_0x16bd75[_0x22ac96]):'';break;case _0x2ec139(0x166):_0x591401=_0x16bd75[_0x22ac96]!==''?JSON['parse'](_0x16bd75[_0x22ac96]):[],_0x146b87=_0x591401[_0x2ec139(0x369)](_0x4870ad=>JSON[_0x2ec139(0x707)](_0x4870ad));break;case _0x2ec139(0xb12):_0x146b87=_0x16bd75[_0x22ac96]!==''?new Function(JSON[_0x2ec139(0x707)](_0x16bd75[_0x22ac96])):new Function(_0x2ec139(0x461));break;case _0x2ec139(0x5f8):_0x591401=_0x16bd75[_0x22ac96]!==''?JSON[_0x2ec139(0x707)](_0x16bd75[_0x22ac96]):[],_0x146b87=_0x591401['map'](_0x109796=>new Function(JSON[_0x2ec139(0x707)](_0x109796)));break;case _0x2ec139(0x7cd):_0x146b87=_0x16bd75[_0x22ac96]!==''?String(_0x16bd75[_0x22ac96]):'';break;case _0x2ec139(0x52a):_0x591401=_0x16bd75[_0x22ac96]!==''?JSON[_0x2ec139(0x707)](_0x16bd75[_0x22ac96]):[],_0x146b87=_0x591401[_0x2ec139(0x369)](_0x600fff=>String(_0x600fff));break;case _0x2ec139(0x406):_0x132a53=_0x16bd75[_0x22ac96]!==''?JSON[_0x2ec139(0x707)](_0x16bd75[_0x22ac96]):{},_0x63649d[_0x4a66bd]={},VisuMZ[_0x2ec139(0x17f)](_0x63649d[_0x4a66bd],_0x132a53);continue;case _0x2ec139(0xa5e):_0x591401=_0x16bd75[_0x22ac96]!==''?JSON[_0x2ec139(0x707)](_0x16bd75[_0x22ac96]):[],_0x146b87=_0x591401['map'](_0x2c60af=>VisuMZ[_0x2ec139(0x17f)]({},JSON[_0x2ec139(0x707)](_0x2c60af)));break;default:continue;}_0x63649d[_0x4a66bd]=_0x146b87;}}}return _0x63649d;},(_0xc802a5=>{const _0x2660eb=_0xa8cad7,_0x546b03=_0xc802a5[_0x2660eb(0x9a6)];for(const _0x5dfc0c of dependencies){if(!Imported[_0x5dfc0c]){alert(_0x2660eb(0x3cd)[_0x2660eb(0x69b)](_0x546b03,_0x5dfc0c)),SceneManager[_0x2660eb(0xb4c)]();break;}}const _0x231606=_0xc802a5[_0x2660eb(0xb55)];if(_0x231606[_0x2660eb(0x21d)](/\[Version[ ](.*?)\]/i)){const _0x18c45b=Number(RegExp['$1']);_0x18c45b!==VisuMZ[label]['version']&&(_0x2660eb(0x9eb)!==_0x2660eb(0x240)?(alert(_0x2660eb(0x26e)['format'](_0x546b03,_0x18c45b)),SceneManager[_0x2660eb(0xb4c)]()):_0x2c283f[_0x2660eb(0x7b4)]=[]);}if(_0x231606[_0x2660eb(0x21d)](/\[Tier[ ](\d+)\]/i)){const _0x4f05f6=Number(RegExp['$1']);if(_0x4f05f6<tier)alert(_0x2660eb(0xb3f)['format'](_0x546b03,_0x4f05f6,tier)),SceneManager[_0x2660eb(0xb4c)]();else{if(_0x2660eb(0x7f4)===_0x2660eb(0x975)){if(this[_0x2660eb(0x124)][_0x2660eb(0x5f1)](_0x586322=>_0x586322[_0x2660eb(0x191)]()&&_0x586322['isMagicSkill']()))return!![];}else tier=Math[_0x2660eb(0x743)](_0x4f05f6,tier);}}VisuMZ[_0x2660eb(0x17f)](VisuMZ[label][_0x2660eb(0xb57)],_0xc802a5['parameters']);})(pluginData),VisuMZ[_0xa8cad7(0x449)]=function(_0xcccf1f){const _0x374e60=_0xa8cad7;let _0x55474a=[];for(const _0x1830c1 of _0xcccf1f){_0x55474a=_0x55474a[_0x374e60(0xaff)](VisuMZ[_0x374e60(0x5b8)](_0x1830c1));}return _0x55474a[_0x374e60(0x1d2)](_0x1fe0fd=>_0x1fe0fd);},VisuMZ[_0xa8cad7(0x5b8)]=function(_0x5e0b90){const _0x280372=_0xa8cad7,_0x34e422=BattleManager[_0x280372(0x27f)]()[_0x280372(0x1d2)](_0x516989=>_0x516989&&_0x516989[_0x280372(0x8b7)]()),_0x111ce9=BattleManager[_0x280372(0x4d4)],_0x3d3062=BattleManager[_0x280372(0x123)],_0x199d58=BattleManager[_0x280372(0x257)]?BattleManager[_0x280372(0x257)][_0x280372(0x91f)](0x0):_0x34e422;_0x5e0b90=_0x5e0b90['toLowerCase']()['trim']();if(_0x5e0b90===_0x280372(0x733)){if(_0x280372(0x9b8)!==_0x280372(0x9b8)){if(!_0x459e88[_0x280372(0xa9e)](_0x340eba))return!![];}else return[_0x111ce9];}else{if(_0x5e0b90===_0x280372(0x7e3))return[_0x3d3062];else{if(_0x5e0b90===_0x280372(0x40f)){if(_0x3d3062){const _0x556cd9=_0x199d58[_0x280372(0x153)](_0x3d3062);return _0x556cd9>=0x0?[_0x199d58[_0x556cd9-0x1]||_0x3d3062]:[_0x3d3062];}}else{if(_0x5e0b90==='text\x20target'){if(_0x280372(0x39e)===_0x280372(0x306))_0x8000c4['skew']['x']=this[_0x280372(0x59f)](_0xd5596f[_0x280372(0x57a)]['x'],this['_targetSkewX'],_0x2bc485,_0x1d898f,_0x51d829),_0x549d45[_0x280372(0x57a)]['y']=this[_0x280372(0x59f)](_0x418366[_0x280372(0x57a)]['y'],this[_0x280372(0x4dd)],_0x2177a3,_0x263914,_0x4e4e2c);else{if(_0x3d3062){if(_0x280372(0x7ef)===_0x280372(0x985)){const _0x4621e5=_0x23c266['BattleCore']['Settings']['BattleLog'];_0x4621e5[_0x280372(0x7e6)]&&this[_0x280372(0x6c0)](_0x280372(0xa27),_0x280372(0x54c)[_0x280372(0x69b)](_0x1cf84a['battleDisplayText'](_0x14fe0c)));if(_0x7a472c[_0x280372(0x12c)](_0x13c1fa)){if(_0x4621e5['ActionSkillMsg1'])this[_0x280372(0x522)](_0xeacbd[_0x280372(0x479)],_0x205576,_0xd9b6e);if(_0x4621e5[_0x280372(0xb4f)])this[_0x280372(0x522)](_0xbe1328['message2'],_0x1abdb6,_0x33633a);}else{if(_0x4621e5[_0x280372(0x473)])this[_0x280372(0x522)](_0x36e5b8[_0x280372(0x8c1)],_0x30a6ac,_0x2b3aa7);}}else{const _0x186745=_0x199d58['indexOf'](_0x3d3062);return _0x186745>=0x0?[_0x199d58[_0x186745+0x1]||_0x3d3062]:[_0x3d3062];}}}}else{if(_0x5e0b90==='all\x20targets'){if(_0x280372(0x963)===_0x280372(0x963))return _0x199d58;else{if(!this[_0x280372(0x959)])return![];if(this['_homeDuration']>0x0)return!![];return _0x45b30a[_0x280372(0x8a9)][_0x280372(0x88f)][_0x280372(0x9b5)](this);}}else{if(_0x5e0b90===_0x280372(0x42c))return[_0x111ce9][_0x280372(0xaff)](_0x199d58);else{if(_0x5e0b90===_0x280372(0x93f)){if('wxYjY'===_0x280372(0x1e1))_0xb12b99=_0x4005cd[_0x280372(0xac0)]()[_0x280372(0xab8)],_0x543cfa=_0x58e594[_0x280372(0xac0)]()['_homeY'];else return _0x34e422[_0x280372(0x1d2)](_0x416507=>_0x416507!==_0x111ce9&&!_0x199d58['includes'](_0x416507)&&_0x416507[_0x280372(0xabb)]());}}}}}}}if(_0x111ce9){if(_0x280372(0x460)===_0x280372(0x460)){if(_0x5e0b90===_0x280372(0x79d)){if(_0x280372(0x6ed)===_0x280372(0x339)){const _0x142d9c=_0x2e46be['_scene'][_0x280372(0x7aa)]();this['move'](_0x142d9c['x'],_0x142d9c['y'],_0x142d9c[_0x280372(0x960)],_0x142d9c[_0x280372(0xa97)]),this[_0x280372(0x931)](),this[_0x280372(0x882)](0x0);}else return _0x111ce9[_0x280372(0x996)]()[_0x280372(0x209)]();}else{if(_0x5e0b90===_0x280372(0x268))return _0x111ce9['friendsUnit']()[_0x280372(0x209)]()[_0x280372(0x1d2)](_0x3bf1d2=>_0x3bf1d2!==_0x111ce9);else{if(_0x5e0b90==='alive\x20friends\x20not\x20target')return _0x111ce9['friendsUnit']()[_0x280372(0x209)]()['filter'](_0x1e536a=>_0x1e536a!==_0x3d3062);else{if(_0x5e0b90===_0x280372(0x4cd))return _0x111ce9[_0x280372(0x996)]()[_0x280372(0xa1d)]();else{if(_0x5e0b90[_0x280372(0x21d)](/FRIEND INDEX (\d+)/i)){if(_0x280372(0x90c)===_0x280372(0x786))return![];else{const _0x500b6c=Number(RegExp['$1']);return[_0x111ce9[_0x280372(0x996)]()[_0x280372(0x563)]()[_0x500b6c]];}}}}}}if(_0x5e0b90===_0x280372(0xa52))return _0x111ce9[_0x280372(0xac9)]()[_0x280372(0x209)]();else{if(_0x5e0b90===_0x280372(0xa09))return _0x111ce9[_0x280372(0xac9)]()['aliveMembers']()[_0x280372(0x1d2)](_0x5e649b=>_0x5e649b!==_0x3d3062);else{if(_0x5e0b90===_0x280372(0x778))return _0x111ce9['opponentsUnit']()[_0x280372(0xa1d)]();else{if(_0x5e0b90[_0x280372(0x21d)](/OPPONENT INDEX (\d+)/i)){if(_0x280372(0x5bd)!=='jiisp'){const _0x46c737=Number(RegExp['$1']);return[_0x111ce9[_0x280372(0xac9)]()[_0x280372(0x563)]()[_0x46c737]];}else{this[_0x280372(0x69d)]=new _0x22d94f();for(let _0x3e9122=0x0;_0x3e9122<0x9;_0x3e9122++){this[_0x280372(0x69d)][_0x280372(0x9ac)](new _0x95422a());}this[_0x280372(0x818)][_0x280372(0x9ac)](this[_0x280372(0x69d)]);}}}}}}else this[_0x280372(0x818)]=new _0x5caa3b(),this[_0x280372(0x818)]['filters']=[new _0x36d7ee[(_0x280372(0x6ba))][(_0x280372(0x887))]()],this[_0x280372(0x818)][_0x280372(0x99a)]=new _0x3c974a(),this[_0x280372(0x818)][_0x280372(0x277)](this[_0x280372(0x651)],this[_0x280372(0x651)]),this[_0x280372(0x9ac)](this[_0x280372(0x818)]);}if(_0x5e0b90===_0x280372(0x27b)){if(_0x280372(0xa4d)===_0x280372(0xa4d))return $gameParty[_0x280372(0x209)]();else _0x301c81['BattleCore']['Game_Action_setGuard'][_0x280372(0x9b5)](this);}else{if(_0x5e0b90===_0x280372(0x25a)){if(_0x280372(0x2c1)!=='kqLOp')return $gameParty[_0x280372(0x209)]()['filter'](_0x16b2f7=>_0x16b2f7!==_0x111ce9);else _0x49d9f9[_0x280372(0xa60)][_0x280372(0x70f)]['call'](this),this[_0x280372(0x9f6)]()&&this['hasSvBattler']()&&this[_0x280372(0x300)](_0x280372(0x11d)),_0x22194e[_0x280372(0x9e1)]();}else{if(_0x5e0b90===_0x280372(0x301))return $gameParty[_0x280372(0x209)]()[_0x280372(0x1d2)](_0x587214=>_0x587214!==_0x3d3062);else{if(_0x5e0b90===_0x280372(0xa8d))return $gameParty[_0x280372(0xa1d)]();else{if(_0x5e0b90[_0x280372(0x21d)](/ACTOR INDEX (\d+)/i)){if(_0x280372(0x6f5)===_0x280372(0x6f5)){const _0x13691f=Number(RegExp['$1']);return[$gameParty['members']()[_0x13691f]];}else{if(!_0x3a6420[_0x280372(0x45f)]())return;if(!_0x5eff57[_0x280372(0x9e4)])return;_0x54dc8f[_0x280372(0x17f)](_0x2e76e9,_0x47797d);const _0x29dcce=_0x5aa72b[_0x280372(0x933)](),_0x2836cf=_0x41cf2a['WaitForProjectile'];if(!_0x29dcce)return;const _0xa16f8d=_0x17b46b['_spriteset'];if(!_0xa16f8d)return;_0xa16f8d['createActionSequenceProjectile'](_0x4aca4e);if(_0x2836cf)_0x29dcce[_0x280372(0x1e7)]('battleProjectiles');}}else{if(_0x5e0b90[_0x280372(0x21d)](/ACTOR ID (\d+)/i)){if(_0x280372(0x552)===_0x280372(0x552)){const _0x138b59=Number(RegExp['$1']);return[$gameActors['actor'](_0x138b59)];}else _0x3c8146[_0x280372(0xa60)][_0x280372(0x32a)]['call'](this),this[_0x280372(0xa4c)]=0x0,this[_0x280372(0x40a)]=null,this[_0x280372(0xa5c)]['x']=0.5,this[_0x280372(0xa5c)]['y']=0x0;}}}}}}if(_0x5e0b90===_0x280372(0x9ec)){if(_0x280372(0x830)!==_0x280372(0x96a))return $gameTroop[_0x280372(0x209)]();else{if(!_0x54cbc3[_0x280372(0x8a9)][_0x280372(0xb57)][_0x280372(0x8d5)]['NameLegacy'])return;this[_0x280372(0x493)]=new _0x3956b1(),this[_0x280372(0x493)]['x']=this[_0x280372(0x954)]['x'],this[_0x280372(0x493)]['y']=this['_windowLayer']['y'];const _0x24f766=this['children']['indexOf'](this[_0x280372(0x954)]);this['addChildAt'](this[_0x280372(0x493)],_0x24f766);for(let _0x566bbe=0x0;_0x566bbe<0x8;_0x566bbe++){const _0x3eba1c=new _0x39e99a(_0x566bbe);this[_0x280372(0x493)]['addChild'](_0x3eba1c);}}}else{if(_0x5e0b90==='alive\x20enemies\x20not\x20user')return $gameTroop[_0x280372(0x209)]()[_0x280372(0x1d2)](_0x5f3590=>_0x5f3590!==_0x111ce9);else{if(_0x5e0b90===_0x280372(0x446))return $gameTroop[_0x280372(0x209)]()[_0x280372(0x1d2)](_0x5b7159=>_0x5b7159!==_0x3d3062);else{if(_0x5e0b90===_0x280372(0xb60))return $gameTroop[_0x280372(0xa1d)]();else{if(_0x5e0b90[_0x280372(0x21d)](/ENEMY INDEX (\d+)/i)){const _0x3febec=Number(RegExp['$1']);return[$gameTroop['members']()[_0x3febec]];}else{if(_0x5e0b90[_0x280372(0x21d)](/ENEMY ID (\d+)/i)){const _0x4411ac=Number(RegExp['$1']);return $gameTroop[_0x280372(0x209)]()[_0x280372(0x1d2)](_0x2d214e=>_0x2d214e[_0x280372(0x956)]()===_0x4411ac);}}}}}}if(_0x5e0b90==='alive\x20battlers'){if(_0x280372(0x251)!=='cHHkF')return _0x34e422['filter'](_0x437f9c=>_0x437f9c[_0x280372(0xab1)]());else _0x751062[_0x280372(0x8a9)][_0x280372(0x3c0)][_0x280372(0x9b5)](this,_0x572de5,_0x4c79c5),this['callNextMethod']();}else{if(_0x5e0b90===_0x280372(0x77b)){if(_0x280372(0x49e)!==_0x280372(0x28f))return _0x34e422['filter'](_0x461aca=>_0x461aca['isAlive']()&&_0x461aca!==_0x111ce9);else this[_0x280372(0x982)](_0x4d3aba,_0x2e01c7,_0x37d0df);}else{if(_0x5e0b90==='alive\x20battlers\x20not\x20target'){if(_0x280372(0x81f)==='qeUKe')_0x29aa94[_0x280372(0x8a9)][_0x280372(0x292)][_0x280372(0x9b5)](this,_0x38d22b);else return _0x34e422[_0x280372(0x1d2)](_0x486dd6=>_0x486dd6[_0x280372(0xab1)]()&&_0x486dd6!==_0x3d3062);}else{if(_0x5e0b90==='dead\x20battlers'){if(_0x280372(0x289)!==_0x280372(0x289)){if(_0x3302a7[_0x280372(0x902)]()&&!_0x848d75['isSideView']())return;const _0x541c43=_0x5e92c9['battler']();if(_0x541c43&&_0x335853[_0x280372(0x902)]())this[_0x280372(0x4ee)][_0x280372(0x9ac)](_0x541c43);}else return _0x34e422[_0x280372(0x1d2)](_0x1aa373=>_0x1aa373[_0x280372(0xb06)]());}}}}return[];},PluginManager['registerCommand'](pluginData['name'],'ActSeq_Set_SetupAction',_0x1af621=>{const _0x558802=_0xa8cad7;if(!SceneManager[_0x558802(0x45f)]())return;VisuMZ[_0x558802(0x17f)](_0x1af621,_0x1af621);const _0x475823=$gameTemp[_0x558802(0x933)](),_0x2924e3=BattleManager[_0x558802(0x95a)],_0x381278=BattleManager[_0x558802(0x4d4)],_0x8189e6=BattleManager[_0x558802(0x257)]?BattleManager[_0x558802(0x257)][_0x558802(0x91f)](0x0):[],_0x5f48d4=BattleManager['_logWindow'];if(!_0x475823||!_0x2924e3||!_0x381278)return;if(!_0x2924e3[_0x558802(0x191)]())return;if(_0x1af621[_0x558802(0x937)])_0x5f48d4['displayAction'](_0x381278,_0x2924e3[_0x558802(0x191)]());_0x1af621[_0x558802(0x8f0)]&&(_0x558802(0x2f7)!==_0x558802(0x2f7)?this[_0x558802(0x367)]():_0x5f48d4[_0x558802(0x6c0)](_0x558802(0x20f),_0x381278,_0x8189e6,!![]));if(_0x1af621[_0x558802(0x175)])_0x5f48d4[_0x558802(0x6c0)](_0x558802(0x6d3),_0x381278,_0x2924e3);if(_0x1af621[_0x558802(0x46c)])_0x5f48d4[_0x558802(0x6c0)](_0x558802(0x33f));if(_0x1af621[_0x558802(0xb8e)])_0x5f48d4[_0x558802(0x6c0)](_0x558802(0x835),_0x381278,_0x2924e3);if(_0x1af621[_0x558802(0x42b)])_0x5f48d4[_0x558802(0x6c0)](_0x558802(0x11f));_0x475823[_0x558802(0x1e7)]('battlelog');}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Set_WholeActionSet',_0xcff2c0=>{const _0x194c5b=_0xa8cad7;if(!SceneManager[_0x194c5b(0x45f)]())return;VisuMZ[_0x194c5b(0x17f)](_0xcff2c0,_0xcff2c0);const _0x320f2f=$gameTemp[_0x194c5b(0x933)](),_0x2a50bc=BattleManager['_action'],_0x1b74b0=BattleManager[_0x194c5b(0x4d4)],_0x4cffcd=BattleManager[_0x194c5b(0x257)]?BattleManager[_0x194c5b(0x257)][_0x194c5b(0x91f)](0x0):[],_0x2f5d3d=BattleManager[_0x194c5b(0x896)],_0x1e869d=_0xcff2c0[_0x194c5b(0x489)]??![];if(!_0x320f2f||!_0x2a50bc||!_0x1b74b0)return;if(!_0x2a50bc[_0x194c5b(0x191)]())return;let _0x412e32=_0x1e869d?_0x2f5d3d['getDualWieldTimes'](_0x1b74b0):0x1;for(let _0x301cd3=0x0;_0x301cd3<_0x412e32;_0x301cd3++){if('RXVHZ'!=='yhhMO'){_0x1e869d&&_0x1b74b0[_0x194c5b(0x902)]()&&(_0x194c5b(0x6b9)===_0x194c5b(0x6b9)?_0x2f5d3d[_0x194c5b(0x6c0)](_0x194c5b(0x375),_0x1b74b0,_0x301cd3):_0x4e6a26[_0x194c5b(0x37e)]());if(_0xcff2c0['PerformAction'])_0x2f5d3d[_0x194c5b(0x6c0)](_0x194c5b(0x1d7),_0x1b74b0,_0x2a50bc);if(_0xcff2c0[_0x194c5b(0x203)]>0x0)_0x2f5d3d[_0x194c5b(0x6c0)](_0x194c5b(0x366),_0xcff2c0[_0x194c5b(0x203)]);if(_0xcff2c0[_0x194c5b(0x5f5)])_0x2f5d3d[_0x194c5b(0x6c0)](_0x194c5b(0xb1f),_0x1b74b0,_0x4cffcd,_0x2a50bc[_0x194c5b(0x191)]()[_0x194c5b(0x94c)]);if(_0xcff2c0['WaitForAnimation'])_0x2f5d3d['push'](_0x194c5b(0x11f));for(const _0x45b6a0 of _0x4cffcd){if(!_0x45b6a0)continue;if(_0xcff2c0[_0x194c5b(0xb6d)])_0x2f5d3d['push'](_0x194c5b(0x15c),_0x1b74b0,_0x45b6a0);}}else{if(!_0x284ab9[_0x194c5b(0x45f)]())return null;if(!_0x21b707['_scene'][_0x194c5b(0x726)])return null;return _0x4b78dd[_0x194c5b(0x26b)][_0x194c5b(0x726)][_0x194c5b(0x474)](this);}}_0x1e869d&&_0x1b74b0['isActor']()&&_0x2f5d3d[_0x194c5b(0x6c0)](_0x194c5b(0x256),_0x1b74b0);if(_0xcff2c0[_0x194c5b(0x8f0)])_0x2f5d3d[_0x194c5b(0x6c0)](_0x194c5b(0x20f),_0x1b74b0,_0x4cffcd,![]);_0x320f2f[_0x194c5b(0x1e7)]('battlelog');}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x48e),_0x332b1c=>{const _0x1d9470=_0xa8cad7;if(!SceneManager[_0x1d9470(0x45f)]())return;VisuMZ[_0x1d9470(0x17f)](_0x332b1c,_0x332b1c);const _0x5ddb09=$gameTemp[_0x1d9470(0x933)](),_0x1d1351=BattleManager[_0x1d9470(0x95a)],_0x270319=BattleManager[_0x1d9470(0x4d4)],_0xd5dc10=BattleManager['_allTargets']?BattleManager[_0x1d9470(0x257)][_0x1d9470(0x91f)](0x0):[],_0x15521b=BattleManager[_0x1d9470(0x896)],_0x6e074d=_0x332b1c['DualWield']??![];if(!_0x5ddb09||!_0x1d1351||!_0x270319)return;if(!_0x1d1351[_0x1d9470(0x191)]())return;let _0x5a54db=_0x6e074d?_0x15521b[_0x1d9470(0xa41)](_0x270319):0x1;for(let _0xb83f9d=0x0;_0xb83f9d<_0x5a54db;_0xb83f9d++){for(const _0x4c912b of _0xd5dc10){if('iRmUp'!==_0x1d9470(0x64a)){if(!_0x4c912b)continue;_0x6e074d&&_0x270319[_0x1d9470(0x902)]()&&_0x15521b['push']('setActiveWeaponSet',_0x270319,_0xb83f9d);if(_0x332b1c[_0x1d9470(0x37a)])_0x15521b['push'](_0x1d9470(0x1d7),_0x270319,_0x1d1351);if(_0x332b1c['WaitCount1']>0x0)_0x15521b[_0x1d9470(0x6c0)](_0x1d9470(0x366),_0x332b1c[_0x1d9470(0x825)]);if(_0x332b1c[_0x1d9470(0x5f5)])_0x15521b[_0x1d9470(0x6c0)](_0x1d9470(0xb1f),_0x270319,[_0x4c912b],_0x1d1351[_0x1d9470(0x191)]()[_0x1d9470(0x94c)]);if(_0x332b1c[_0x1d9470(0x7bc)]>0x0)_0x15521b[_0x1d9470(0x6c0)](_0x1d9470(0x366),_0x332b1c[_0x1d9470(0x7bc)]);if(_0x332b1c[_0x1d9470(0xb6d)])_0x15521b[_0x1d9470(0x6c0)](_0x1d9470(0x15c),_0x270319,_0x4c912b);}else this[_0x1d9470(0x828)](_0x1d9470(0x18e));}}if(_0x6e074d&&_0x270319[_0x1d9470(0x902)]()){if(_0x1d9470(0x263)==='oINed')_0x15521b[_0x1d9470(0x6c0)](_0x1d9470(0x256),_0x270319);else{if(!_0xb68220[_0x1d9470(0x45f)]())return;if(!_0x4a2a8e['VisuMZ_1_ElementStatusCore'])return;const _0x3ee3dc=_0x1fc860[_0x1d9470(0x95a)];if(!_0x3ee3dc)return;_0x3ee3dc[_0x1d9470(0xb76)]();}}if(_0x332b1c[_0x1d9470(0x8f0)])_0x15521b[_0x1d9470(0x6c0)]('applyImmortal',_0x270319,_0xd5dc10,![]);_0x5ddb09['setWaitMode'](_0x1d9470(0x3b9));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x98b),_0x1198fd=>{const _0x428b9d=_0xa8cad7;if(!SceneManager[_0x428b9d(0x45f)]())return;VisuMZ[_0x428b9d(0x17f)](_0x1198fd,_0x1198fd);const _0x5e4bc1=$gameTemp[_0x428b9d(0x933)](),_0x51b245=BattleManager[_0x428b9d(0x95a)],_0x418489=BattleManager[_0x428b9d(0x4d4)],_0x262ffa=BattleManager['_allTargets']?BattleManager[_0x428b9d(0x257)]['slice'](0x0):[],_0x2db27c=BattleManager['_logWindow'];if(!_0x5e4bc1||!_0x51b245||!_0x418489)return;if(!_0x51b245[_0x428b9d(0x191)]())return;if(_0x1198fd[_0x428b9d(0x8f0)])_0x2db27c[_0x428b9d(0x6c0)]('applyImmortal',_0x418489,_0x262ffa,![]);if(_0x1198fd['WaitForNewLine'])_0x2db27c[_0x428b9d(0x6c0)](_0x428b9d(0x47c));if(_0x1198fd['WaitForEffect'])_0x2db27c[_0x428b9d(0x6c0)](_0x428b9d(0x9fd));if(_0x1198fd[_0x428b9d(0xb1d)])_0x2db27c[_0x428b9d(0x6c0)](_0x428b9d(0x711));if(_0x1198fd[_0x428b9d(0x8aa)])_0x2db27c['push'](_0x428b9d(0xb3e),_0x418489);if(_0x1198fd[_0x428b9d(0x46c)])_0x2db27c['push']('waitForMovement');_0x5e4bc1['setWaitMode'](_0x428b9d(0x3b9));}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x71d),_0x372954=>{const _0x4faafa=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x4faafa(0x1d1)])return;VisuMZ[_0x4faafa(0x17f)](_0x372954,_0x372954);const _0x3ab703=$gameTemp['getLastPluginCommandInterpreter'](),_0x4248fd=_0x372954[_0x4faafa(0xa51)];if(!_0x3ab703)return;$gameScreen[_0x4faafa(0x3c3)](_0x372954[_0x4faafa(0xac5)],_0x372954[_0x4faafa(0x37b)],_0x372954['EasingType']);if(_0x4248fd)_0x3ab703[_0x4faafa(0x1e7)](_0x4faafa(0xab3));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x7b6),_0x13501c=>{const _0x48ef35=_0xa8cad7;if(!SceneManager[_0x48ef35(0x45f)]())return;if(!Imported[_0x48ef35(0x1d1)])return;VisuMZ[_0x48ef35(0x17f)](_0x13501c,_0x13501c);const _0x2dfff7=$gameTemp[_0x48ef35(0x933)](),_0x4c9024=_0x13501c[_0x48ef35(0xa51)];if(!_0x2dfff7)return;$gameScreen[_0x48ef35(0x3c3)](0x0,_0x13501c[_0x48ef35(0x37b)],_0x13501c[_0x48ef35(0xabf)]);if(_0x4c9024)_0x2dfff7['setWaitMode']('battleAngle');}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x218),_0x472b0d=>{const _0x1424f3=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;const _0x6e3367=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x6e3367)return;_0x6e3367[_0x1424f3(0x1e7)]('battleAngle');}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x1c7),_0x339d44=>{const _0x2452bc=_0xa8cad7;if(!SceneManager[_0x2452bc(0x45f)]())return;VisuMZ[_0x2452bc(0x17f)](_0x339d44,_0x339d44);const _0xbf8d68=$gameTemp['getLastPluginCommandInterpreter'](),_0x2f46ef=BattleManager[_0x2452bc(0x95a)],_0xa990d6=BattleManager[_0x2452bc(0x4d4)],_0x38562e=VisuMZ[_0x2452bc(0x449)](_0x339d44[_0x2452bc(0x171)]),_0x144d9e=_0x339d44['Mirror'],_0x167718=BattleManager['_logWindow'];if(!_0xbf8d68||!_0x2f46ef||!_0xa990d6)return;if(!_0x2f46ef[_0x2452bc(0x191)]())return;let _0x309f78=_0x2f46ef[_0x2452bc(0x191)]()['animationId'];if(_0x309f78<0x0)_0x309f78=_0xa990d6['attackAnimationId1']();$gameTemp[_0x2452bc(0xb16)](_0x38562e,_0x309f78,_0x144d9e),_0x339d44[_0x2452bc(0x42b)]&&(_0x2452bc(0x280)==='yhGCW'?(_0x5d4f35['BattleCore'][_0x2452bc(0x155)][_0x2452bc(0x9b5)](this),this['updateWeather']()):_0xbf8d68[_0x2452bc(0x1e7)]('battleAnimation'));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x687),_0x44badd=>{const _0x52968d=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x52968d(0x17f)](_0x44badd,_0x44badd);const _0x5a1e45=$gameTemp['getLastPluginCommandInterpreter'](),_0x11d44f=BattleManager[_0x52968d(0x4d4)],_0x50afe0=VisuMZ['CreateActionSequenceTargets'](_0x44badd['Targets']),_0xb58934=_0x44badd[_0x52968d(0x2c6)],_0x1d8610=BattleManager[_0x52968d(0x896)];if(!_0x5a1e45||!_0x11d44f)return;const _0x28edd3=_0x11d44f['attackAnimationId1']();$gameTemp[_0x52968d(0xb16)](_0x50afe0,_0x28edd3,_0xb58934),_0x44badd[_0x52968d(0x42b)]&&_0x5a1e45[_0x52968d(0x1e7)](_0x52968d(0x607));}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],'ActSeq_Animation_AttackAnimation2',_0x209ee0=>{const _0x150611=_0xa8cad7;if(!SceneManager[_0x150611(0x45f)]())return;VisuMZ[_0x150611(0x17f)](_0x209ee0,_0x209ee0);const _0x8e4336=_0x1b5436['attackAnimationIdSlot'](_0x209ee0[_0x150611(0x383)]);if(_0x8e4336<=0x0)return;const _0x374757=$gameTemp[_0x150611(0x933)](),_0x1b5436=BattleManager[_0x150611(0x4d4)],_0x3bf41f=VisuMZ[_0x150611(0x449)](_0x209ee0['Targets']),_0x3fea55=_0x209ee0[_0x150611(0x2c6)],_0x487d3a=BattleManager[_0x150611(0x896)];if(!_0x374757||!_0x1b5436)return;$gameTemp[_0x150611(0xb16)](_0x3bf41f,_0x8e4336,_0x3fea55),_0x209ee0['WaitForAnimation']&&_0x374757[_0x150611(0x1e7)]('battleAnimation');}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x96f),_0x494de7=>{const _0x2552f3=_0xa8cad7;if(!SceneManager[_0x2552f3(0x45f)]())return;VisuMZ[_0x2552f3(0x17f)](_0x494de7,_0x494de7);const _0x34b3b8=$gameTemp[_0x2552f3(0x933)](),_0x10baf7=BattleManager[_0x2552f3(0x95a)],_0x2e1163=_0x494de7[_0x2552f3(0x2c6)],_0x26d8ff=VisuMZ[_0x2552f3(0x449)](_0x494de7[_0x2552f3(0x171)]);if(!_0x34b3b8||!_0x10baf7)return;if(!_0x10baf7[_0x2552f3(0x191)]())return;for(const _0x3c2155 of _0x26d8ff){if(_0x2552f3(0x275)!==_0x2552f3(0x275))_0x1a231f[_0x2552f3(0x8a9)][_0x2552f3(0x264)][_0x2552f3(0x9b5)](this,_0x10ab49,_0x14603b),this[_0x2552f3(0xa8a)]();else{if(!_0x3c2155)continue;_0x3c2155[_0x2552f3(0x835)](_0x10baf7,_0x2e1163);}}if(_0x494de7[_0x2552f3(0x42b)])_0x34b3b8[_0x2552f3(0x1e7)]('battleAnimation');}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x597),_0x4599af=>{const _0x24ede3=_0xa8cad7;VisuMZ[_0x24ede3(0x17f)](_0x4599af,_0x4599af);const _0x2e07b4=$gameTemp[_0x24ede3(0x933)](),_0x51f311=VisuMZ['CreateActionSequenceTargets'](_0x4599af['Targets']),_0x35128b=_0x4599af['Filename'];if(!_0x35128b)return;for(const _0xf2c6ec of _0x51f311){if('Dkbvp'!==_0x24ede3(0xa03))return _0x588b8b[_0x24ede3(0x8a9)][_0x24ede3(0x955)][_0x24ede3(0x9b5)](this);else{if(!_0xf2c6ec)continue;if(!_0xf2c6ec[_0x24ede3(0x902)]())continue;_0xf2c6ec[_0x24ede3(0x9db)](_0x35128b);}}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x8ad),_0x268b11=>{const _0x4db260=_0xa8cad7;if(!SceneManager['_scene'])return;if(!SceneManager[_0x4db260(0x26b)]['_spriteset'])return;if(!Imported['VisuMZ_0_CoreEngine'])return;VisuMZ[_0x4db260(0x17f)](_0x268b11,_0x268b11);const _0x581a2d=$gameTemp[_0x4db260(0x933)](),_0x5c161a=Math[_0x4db260(0x2cb)](_0x268b11[_0x4db260(0x8e9)]),_0x271c6c=Math[_0x4db260(0x2cb)](_0x268b11['pointY']);$gameTemp[_0x4db260(0x450)](_0x5c161a,_0x271c6c,_0x268b11[_0x4db260(0x8b2)],_0x268b11[_0x4db260(0x2c6)],_0x268b11['Mute']);if(_0x268b11[_0x4db260(0x1ab)]&&_0x581a2d){if(_0x4db260(0x48a)==='bmSlm')SceneManager['_scene']['_spriteset'][_0x4db260(0x491)](),_0x581a2d['setWaitMode'](_0x4db260(0x607));else return _0x4fd529['BattleCore']['Settings']['PartyCmd']['DisablePartyCmd'];}}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Animation_ShowAnimation',_0x17d527=>{const _0x3c328e=_0xa8cad7;if(!SceneManager[_0x3c328e(0x45f)]())return;VisuMZ[_0x3c328e(0x17f)](_0x17d527,_0x17d527);const _0x39e14a=$gameTemp[_0x3c328e(0x933)](),_0x4da974=VisuMZ['CreateActionSequenceTargets'](_0x17d527['Targets']),_0x4fa19c=_0x17d527[_0x3c328e(0x8b2)],_0x59f53c=_0x17d527['Mirror'];if(!_0x39e14a)return;$gameTemp[_0x3c328e(0xb16)](_0x4da974,_0x4fa19c,_0x59f53c);if(_0x17d527[_0x3c328e(0x42b)])_0x39e14a[_0x3c328e(0x1e7)](_0x3c328e(0x607));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x8a0),_0x17b7c3=>{const _0x571a19=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;const _0xc4126f=$gameTemp[_0x571a19(0x933)]();if(!_0xc4126f)return;_0xc4126f[_0x571a19(0x1e7)](_0x571a19(0x607));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x246),_0x39159b=>{const _0x4c0819=_0xa8cad7;if(!SceneManager[_0x4c0819(0x45f)]())return;VisuMZ[_0x4c0819(0x17f)](_0x39159b,_0x39159b);const _0x4b34da=BattleManager[_0x4c0819(0x896)],_0x57fcea=_0x39159b[_0x4c0819(0x97f)]&&Imported['VisuMZ_4_CombatLog'];_0x4b34da[_0x4c0819(0xa27)](_0x39159b[_0x4c0819(0x71c)]),_0x57fcea&&Imported['VisuMZ_4_CombatLog']&&$gameSystem[_0x4c0819(0x8db)](_0x39159b[_0x4c0819(0x71c)]||'',_0x39159b[_0x4c0819(0xb18)]||0x0);}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x27a),_0x27166b=>{const _0x4bc435=_0xa8cad7;if(!SceneManager[_0x4bc435(0x45f)]())return;const _0x540511=BattleManager[_0x4bc435(0x896)];_0x540511[_0x4bc435(0x711)]();}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x3aa),_0x2f0a32=>{const _0x279e38=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;const _0x26e9cf=$gameTemp['getLastPluginCommandInterpreter'](),_0x569546=BattleManager[_0x279e38(0x95a)],_0xad64ec=BattleManager[_0x279e38(0x4d4)],_0x5d9762=BattleManager[_0x279e38(0x896)];if(!_0x26e9cf||!_0x569546||!_0xad64ec)return;if(!_0x569546['item']())return;_0x5d9762[_0x279e38(0x788)](_0xad64ec,_0x569546[_0x279e38(0x191)]()),_0x26e9cf['setWaitMode']('battlelog');}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_BattleLog_PopBaseLine',_0x12c791=>{const _0x4b888f=_0xa8cad7;if(!SceneManager[_0x4b888f(0x45f)]())return;const _0x1b3e0a=BattleManager['_logWindow'];_0x1b3e0a[_0x4b888f(0xaf5)]();}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x39f),_0x51333e=>{const _0x468027=_0xa8cad7;if(!SceneManager[_0x468027(0x45f)]())return;const _0x24d955=BattleManager['_logWindow'];_0x24d955[_0x468027(0x9e6)]();}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x68d),_0x21b64c=>{const _0x485059=_0xa8cad7;if(!SceneManager[_0x485059(0x45f)]())return;const _0x24993e=BattleManager['_logWindow'];_0x24993e[_0x485059(0x8ff)]();}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x453),_0x561591=>{const _0x45e3f7=_0xa8cad7;if(!SceneManager[_0x45e3f7(0x45f)]())return;VisuMZ[_0x45e3f7(0x17f)](_0x561591,_0x561591),SceneManager[_0x45e3f7(0x26b)][_0x45e3f7(0x439)](_0x561591[_0x45e3f7(0x724)]);}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],'ActSeq_BattleLog_WaitForBattleLog',_0x54e4c2=>{const _0x2c7a46=_0xa8cad7;if(!SceneManager[_0x2c7a46(0x45f)]())return;const _0x591440=$gameTemp[_0x2c7a46(0x933)]();_0x591440[_0x2c7a46(0x1e7)]('battlelog');}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x533),_0xebd453=>{const _0x1a8bd6=_0xa8cad7;if(!SceneManager[_0x1a8bd6(0x45f)]())return;const _0x58771a=$gameTemp[_0x1a8bd6(0x933)](),_0x2e7a8c=BattleManager['_logWindow'];_0x2e7a8c[_0x1a8bd6(0x47c)](),_0x58771a[_0x1a8bd6(0x1e7)](_0x1a8bd6(0x3b9));}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0xae4),_0x41917b=>{const _0x4ccb82=_0xa8cad7;if(!SceneManager[_0x4ccb82(0x45f)]())return;if(!Imported[_0x4ccb82(0x1d1)])return;VisuMZ[_0x4ccb82(0x17f)](_0x41917b,_0x41917b);const _0x414d21=$gameScreen[_0x4ccb82(0x4bb)]();_0x414d21[_0x4ccb82(0x92c)]=_0x41917b[_0x4ccb82(0x3de)];}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0xb21),_0x13ea66=>{const _0x4baab8=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x4baab8(0x1d1)])return;VisuMZ[_0x4baab8(0x17f)](_0x13ea66,_0x13ea66);const _0x313e1e=$gameTemp[_0x4baab8(0x933)](),_0x2db4f1=_0x13ea66['WaitForCamera'];$gameScreen[_0x4baab8(0x654)](_0x13ea66[_0x4baab8(0x37d)],_0x13ea66['FocusY'],_0x13ea66[_0x4baab8(0x37b)],_0x13ea66[_0x4baab8(0xabf)]);if(_0x2db4f1)_0x313e1e[_0x4baab8(0x1e7)](_0x4baab8(0x7f9));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x2d3),_0x442f34=>{const _0x127285=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x127285(0x1d1)])return;VisuMZ[_0x127285(0x17f)](_0x442f34,_0x442f34);const _0x3c81c3=$gameTemp['getLastPluginCommandInterpreter'](),_0x35f8b9=VisuMZ[_0x127285(0x449)](_0x442f34['Targets']),_0x5b2044=_0x442f34[_0x127285(0x6e9)];$gameScreen['setBattleCameraTargets'](_0x35f8b9,_0x442f34[_0x127285(0x37b)],_0x442f34[_0x127285(0xabf)]);if(_0x5b2044)_0x3c81c3[_0x127285(0x1e7)](_0x127285(0x7f9));}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x744),_0x4a5b37=>{const _0x1248d8=_0xa8cad7;if(!SceneManager[_0x1248d8(0x45f)]())return;if(!Imported[_0x1248d8(0x1d1)])return;VisuMZ[_0x1248d8(0x17f)](_0x4a5b37,_0x4a5b37);const _0xdb39d7=$gameTemp['getLastPluginCommandInterpreter'](),_0x2f98a3=_0x4a5b37['WaitForCamera'];$gameScreen[_0x1248d8(0x468)](_0x4a5b37[_0x1248d8(0x131)],_0x4a5b37[_0x1248d8(0x944)],_0x4a5b37['Duration'],_0x4a5b37[_0x1248d8(0xabf)]);if(_0x2f98a3)_0xdb39d7[_0x1248d8(0x1e7)](_0x1248d8(0x7f9));}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x7ad),_0x1d480f=>{const _0x9935ac=_0xa8cad7;if(!SceneManager[_0x9935ac(0x45f)]())return;if(!Imported[_0x9935ac(0x1d1)])return;VisuMZ[_0x9935ac(0x17f)](_0x1d480f,_0x1d480f);const _0x318e3d=$gameTemp['getLastPluginCommandInterpreter'](),_0x7c1b7d=_0x1d480f[_0x9935ac(0x794)],_0xe83aa7=_0x1d480f[_0x9935ac(0xb97)],_0x5f0c28=_0x1d480f[_0x9935ac(0x6e9)];if(_0x7c1b7d){if('jQeXf'==='jQeXf'){const _0x10ad9c=Math['round'](Graphics[_0x9935ac(0x960)]/0x2),_0x3a4a3e=Math[_0x9935ac(0x2cb)](Graphics[_0x9935ac(0xa97)]/0x2);$gameScreen[_0x9935ac(0x654)](_0x10ad9c,_0x3a4a3e,_0x1d480f['Duration'],_0x1d480f[_0x9935ac(0xabf)]);}else{if(!_0x34f3a7[_0x9935ac(0xb98)]())return![];if(!_0x5a8574[_0x9935ac(0x947)]())return![];if(!_0x5b1abb[_0x9935ac(0x417)]())return![];return _0x1a6e5b[_0x9935ac(0x8a9)][_0x9935ac(0xb57)][_0x9935ac(0x19d)][_0x9935ac(0x45d)];}}_0xe83aa7&&(_0x9935ac(0x648)===_0x9935ac(0x648)?$gameScreen[_0x9935ac(0x468)](0x0,0x0,_0x1d480f[_0x9935ac(0x37b)],_0x1d480f[_0x9935ac(0xabf)]):this['_mainSprite'][_0x9935ac(0x379)]['smooth']=this[_0x9935ac(0x959)][_0x9935ac(0x2ea)]());if(_0x5f0c28)_0x318e3d[_0x9935ac(0x1e7)]('battleCamera');}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Camera_WaitForCamera',_0x5de940=>{const _0x4f7221=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;const _0x4c7f67=$gameTemp[_0x4f7221(0x933)]();if(!_0x4c7f67)return;_0x4c7f67['setWaitMode']('battleCamera');}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x7cc),_0x4f6832=>{const _0x4b3c0c=_0xa8cad7;if(!SceneManager[_0x4b3c0c(0x45f)]())return;if(!Imported['VisuMZ_2_DragonbonesUnion'])return;VisuMZ[_0x4b3c0c(0x17f)](_0x4f6832,_0x4f6832);const _0x2e498b=VisuMZ['CreateActionSequenceTargets'](_0x4f6832[_0x4b3c0c(0x171)]),_0x204082=_0x4f6832[_0x4b3c0c(0x941)][_0x4b3c0c(0x341)]()[_0x4b3c0c(0xb45)]();for(const _0x3b32a8 of _0x2e498b){if(!_0x3b32a8)continue;_0x3b32a8['requestDragonbonesAnimation'](_0x204082);}}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x797),_0x4d3e4d=>{const _0x3487ae=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_2_DragonbonesUnion'])return;VisuMZ['ConvertParams'](_0x4d3e4d,_0x4d3e4d);const _0x255d85=VisuMZ['CreateActionSequenceTargets'](_0x4d3e4d[_0x3487ae(0x171)]),_0x1ae230=_0x4d3e4d[_0x3487ae(0x1d6)];for(const _0x661921 of _0x255d85){if(!_0x661921)continue;_0x661921['dragonbonesData']()[_0x3487ae(0x4d8)]=_0x1ae230;}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x640),_0x204968=>{const _0x3a3118=_0xa8cad7;if(!SceneManager[_0x3a3118(0x45f)]())return;if(!Imported[_0x3a3118(0x4f4)])return;VisuMZ[_0x3a3118(0x17f)](_0x204968,_0x204968);const _0x50883e=BattleManager['_action'],_0x106abd=_0x204968[_0x3a3118(0x194)];if(!_0x50883e)return;_0x50883e[_0x3a3118(0x796)]=_0x106abd;}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x317),_0x5623aa=>{const _0x5cb537=_0xa8cad7;if(!SceneManager[_0x5cb537(0x45f)]())return;if(!Imported[_0x5cb537(0x4f4)])return;const _0x3791de=BattleManager[_0x5cb537(0x95a)];if(!_0x3791de)return;_0x3791de[_0x5cb537(0xb76)]();}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x64c),_0x587d12=>{const _0x496d0a=_0xa8cad7;if(!SceneManager[_0x496d0a(0x45f)]())return;if(!Imported['VisuMZ_1_ElementStatusCore'])return;VisuMZ['ConvertParams'](_0x587d12,_0x587d12);const _0x1c3539=BattleManager['_action'],_0x2aa1b5=_0x587d12[_0x496d0a(0x194)];if(!_0x1c3539)return;_0x1c3539[_0x496d0a(0x5e6)]=_0x2aa1b5;}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x993),_0x38c76c=>{const _0x268fa3=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x268fa3(0x4f4)])return;const _0x16060c=BattleManager[_0x268fa3(0x95a)];if(!_0x16060c)return;_0x16060c[_0x268fa3(0x4f5)]=!![];}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x445),_0x1359d6=>{const _0xea29fd=_0xa8cad7;if(!Imported[_0xea29fd(0x118)])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0xea29fd(0x17f)](_0x1359d6,_0x1359d6);const _0x3dc14d=VisuMZ[_0xea29fd(0x449)](_0x1359d6['Targets']);for(const _0x173e9d of _0x3dc14d){if(!_0x173e9d)continue;_0x173e9d[_0xea29fd(0xab9)](_0xea29fd(0x5df)),_0x173e9d['removeHorrorEffect'](_0xea29fd(0x688)),_0x173e9d['removeHorrorEffect']('tv'),_0x173e9d[_0xea29fd(0xabd)]();}$gamePlayer[_0xea29fd(0x8ff)]();}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0xb6c),_0x51f966=>{const _0xdda4c=_0xa8cad7;if(!Imported[_0xdda4c(0x118)])return;if(!SceneManager[_0xdda4c(0x45f)]())return;VisuMZ[_0xdda4c(0x17f)](_0x51f966,_0x51f966);const _0x591922=VisuMZ[_0xdda4c(0x449)](_0x51f966[_0xdda4c(0x171)]),_0xc66f98=_0xdda4c(0x688);_0x51f966[_0xdda4c(0x52e)]=Math[_0xdda4c(0x412)](_0x51f966[_0xdda4c(0x331)]/0x2),_0x51f966[_0xdda4c(0x826)]=_0x51f966[_0xdda4c(0x331)],_0x51f966[_0xdda4c(0x3bc)]=!![];for(const _0xc5bf75 of _0x591922){if(_0xdda4c(0x64b)==='xLfVs'){if(!_0xc5bf75)continue;_0xc5bf75[_0xdda4c(0x67b)](_0xc66f98,_0x51f966);}else return _0x15a90f[_0xdda4c(0x5be)]-_0x27f7d0['spriteId'];}$gamePlayer['refresh']();}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x2ed),_0x4cd87b=>{const _0x283062=_0xa8cad7;if(!Imported[_0x283062(0x118)])return;if(!SceneManager[_0x283062(0x45f)]())return;VisuMZ[_0x283062(0x17f)](_0x4cd87b,_0x4cd87b);const _0x12c3b8=VisuMZ[_0x283062(0x449)](_0x4cd87b[_0x283062(0x171)]);for(const _0x4f98f8 of _0x12c3b8){if(!_0x4f98f8)continue;_0x4f98f8[_0x283062(0xab9)](_0x283062(0x688));}$gamePlayer['refresh']();}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x229),_0x52195f=>{const _0x2cedac=_0xa8cad7;if(!Imported['VisuMZ_2_HorrorEffects'])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x2cedac(0x17f)](_0x52195f,_0x52195f);const _0x26193a=VisuMZ[_0x2cedac(0x449)](_0x52195f['Targets']),_0x220fae=_0x2cedac(0x5df);for(const _0x2bc6fd of _0x26193a){if(!_0x2bc6fd)continue;_0x2bc6fd['setHorrorEffectSettings'](_0x220fae,_0x52195f);}$gamePlayer[_0x2cedac(0x8ff)]();}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Horror_NoiseRemove',_0x40e220=>{const _0x4b1f6c=_0xa8cad7;if(!Imported[_0x4b1f6c(0x118)])return;if(!SceneManager[_0x4b1f6c(0x45f)]())return;VisuMZ[_0x4b1f6c(0x17f)](_0x40e220,_0x40e220);const _0x15addb=VisuMZ[_0x4b1f6c(0x449)](_0x40e220[_0x4b1f6c(0x171)]);for(const _0x411d16 of _0x15addb){if(!_0x411d16)continue;_0x411d16['removeHorrorEffect'](_0x4b1f6c(0x5df));}$gamePlayer['refresh']();}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x5a3),_0x4891c9=>{const _0x11ba70=_0xa8cad7;if(!Imported[_0x11ba70(0x118)])return;if(!SceneManager[_0x11ba70(0x45f)]())return;VisuMZ[_0x11ba70(0x17f)](_0x4891c9,_0x4891c9);const _0x19608b=VisuMZ[_0x11ba70(0x449)](_0x4891c9[_0x11ba70(0x171)]),_0x24af7a='tv';for(const _0x526295 of _0x19608b){if('NEIfB'===_0x11ba70(0x642)){if(!_0x548065[_0x11ba70(0x91a)])return;if(this[_0x11ba70(0xa17)]===_0x3cb209)return;const _0x4bc0a1=_0x6895d9[_0x11ba70(0x8a9)][_0x11ba70(0xb57)]['HpGauge'],_0x5f2743=new _0x53d5f2();_0x5f2743['anchor']['x']=_0x4bc0a1[_0x11ba70(0x784)],_0x5f2743[_0x11ba70(0xa5c)]['y']=_0x4bc0a1[_0x11ba70(0x637)],_0x5f2743['scale']['x']=_0x5f2743['scale']['y']=_0x4bc0a1[_0x11ba70(0x8d9)],this[_0x11ba70(0x161)]=_0x5f2743,this[_0x11ba70(0x9ac)](this['_hpGaugeSprite']);}else{if(!_0x526295)continue;_0x526295[_0x11ba70(0x67b)](_0x24af7a,_0x4891c9);}}$gamePlayer['refresh']();}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x60e),_0x5541ea=>{const _0x5c16ca=_0xa8cad7;if(!Imported[_0x5c16ca(0x118)])return;if(!SceneManager[_0x5c16ca(0x45f)]())return;VisuMZ[_0x5c16ca(0x17f)](_0x5541ea,_0x5541ea);const _0x523bd7=VisuMZ[_0x5c16ca(0x449)](_0x5541ea['Targets']);for(const _0x3f94b8 of _0x523bd7){if(!_0x3f94b8)continue;_0x3f94b8['removeHorrorEffect']('tv');}$gamePlayer[_0x5c16ca(0x8ff)]();}),PluginManager['registerCommand'](pluginData['name'],_0xa8cad7(0x5d3),_0x4e0a0d=>{const _0x40f3f7=_0xa8cad7;if(!SceneManager[_0x40f3f7(0x45f)]())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x37cb25=SceneManager['_scene'][_0x40f3f7(0x726)];if(!_0x37cb25)return;VisuMZ['ConvertParams'](_0x4e0a0d,_0x4e0a0d);const _0x4e7fe6=_0x4e0a0d[_0x40f3f7(0xa62)]||0x1,_0x3e8b64=_0x4e0a0d['Duration']||0x1,_0x1190af=_0x4e0a0d[_0x40f3f7(0xabf)]||_0x40f3f7(0x9bc);_0x37cb25[_0x40f3f7(0x262)](_0x4e7fe6,_0x3e8b64,_0x1190af);}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x7f0),_0x1e7352=>{const _0x3b42b2=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x3b42b2(0x119)])return;const _0x3e84f7=SceneManager['_scene'][_0x3b42b2(0x726)];if(!_0x3e84f7)return;VisuMZ[_0x3b42b2(0x17f)](_0x1e7352,_0x1e7352);const _0x70655f=Number(_0x1e7352['Angle'])||0x0,_0x2085f3=Number(_0x1e7352[_0x3b42b2(0x16b)]),_0xc818d5=_0x1e7352[_0x3b42b2(0x37b)]||0x1,_0x10ef79=_0x1e7352['EasingType']||_0x3b42b2(0x9bc);_0x3e84f7[_0x3b42b2(0x53c)](_0x70655f,_0x2085f3,_0xc818d5,_0x10ef79);}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Impact_MotionBlurTarget',_0x5b23f1=>{const _0x53734c=_0xa8cad7;if(!SceneManager[_0x53734c(0x45f)]())return;if(!Imported[_0x53734c(0x119)])return;const _0x5087e0=SceneManager['_scene'][_0x53734c(0x726)];if(!_0x5087e0)return;VisuMZ[_0x53734c(0x17f)](_0x5b23f1,_0x5b23f1);const _0x49bcef=Number(_0x5b23f1[_0x53734c(0xac5)])||0x0,_0x541064=Number(_0x5b23f1[_0x53734c(0x16b)]),_0x7e2fd5=_0x5b23f1[_0x53734c(0x37b)]||0x1,_0x293689=_0x5b23f1['EasingType']||_0x53734c(0x9bc),_0x1cceb1=VisuMZ[_0x53734c(0x449)](_0x5b23f1[_0x53734c(0x171)]);for(const _0x1df26a of _0x1cceb1){if(_0x53734c(0xa12)==='QuQpS'){if(!_0x1df26a)continue;if(!_0x1df26a['battler']())continue;_0x1df26a[_0x53734c(0xac0)]()[_0x53734c(0x53c)](_0x49bcef,_0x541064,_0x7e2fd5,_0x293689);}else{const _0x30e832=_0x1cab3e[_0x53734c(0x8a9)][_0x53734c(0xb57)][_0x53734c(0x19d)],_0x1d675c=_0x30e832[_0x53734c(0x3b3)],_0x5732f8=_0x30e832[_0x53734c(0x95f)],_0x5e32cd=_0x30e832['StepDuration'];this[_0x53734c(0x655)](-_0x1d675c,-_0x5732f8,_0x5e32cd);}}}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x496),_0xea88c=>{const _0x2b7f6a=_0xa8cad7;if(!SceneManager[_0x2b7f6a(0x45f)]())return;if(!Imported[_0x2b7f6a(0x119)])return;VisuMZ[_0x2b7f6a(0x17f)](_0xea88c,_0xea88c);const _0x123f87={'delay':_0xea88c[_0x2b7f6a(0x5c6)],'duration':_0xea88c['duration'],'hue':_0xea88c[_0x2b7f6a(0x893)],'opacityStart':_0xea88c[_0x2b7f6a(0x67d)],'tone':_0xea88c[_0x2b7f6a(0x3d1)],'visible':!![]},_0xafa275=VisuMZ[_0x2b7f6a(0x449)](_0xea88c[_0x2b7f6a(0x171)]);for(const _0x3eeea1 of _0xafa275){if(_0x2b7f6a(0x21b)===_0x2b7f6a(0x21b)){if(!_0x3eeea1)continue;_0x3eeea1['setBattlerMotionTrailData'](_0x123f87);}else{this[_0x2b7f6a(0x82f)](0x0,0x0,0x0,0x0);return;}}}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x7f8),_0x1b4ec5=>{const _0x466887=_0xa8cad7;if(!SceneManager[_0x466887(0x45f)]())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;VisuMZ[_0x466887(0x17f)](_0x1b4ec5,_0x1b4ec5);const _0x16083f=VisuMZ['CreateActionSequenceTargets'](_0x1b4ec5['Targets']);for(const _0x17412d of _0x16083f){if(!_0x17412d)continue;_0x17412d[_0x466887(0x5aa)]();}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x465),_0x46f993=>{const _0x496b50=_0xa8cad7;if(!Imported[_0x496b50(0x119)])return;const _0x44c6a4=SceneManager[_0x496b50(0x26b)][_0x496b50(0x726)];if(!_0x44c6a4)return;VisuMZ[_0x496b50(0x17f)](_0x46f993,_0x46f993);const _0x43480c=_0x46f993['X']||0x0,_0x223018=_0x46f993['Y']||0x0,_0x13897f=_0x46f993[_0x496b50(0x279)]||0x0,_0x4750dd=_0x46f993[_0x496b50(0x962)]||0x0,_0x221a51=_0x46f993['Duration']||0x1;_0x44c6a4[_0x496b50(0x84a)](_0x43480c,_0x223018,_0x13897f,_0x4750dd,_0x221a51);}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_Impact_ShockwaveEachTargets',_0x1af794=>{const _0x3dd7fc=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x2ab3bc=SceneManager[_0x3dd7fc(0x26b)][_0x3dd7fc(0x726)];if(!_0x2ab3bc)return;VisuMZ['ConvertParams'](_0x1af794,_0x1af794);const _0x252415=VisuMZ['CreateActionSequenceTargets'](_0x1af794[_0x3dd7fc(0x171)]),_0x370997=_0x1af794[_0x3dd7fc(0x427)],_0x25a880=_0x1af794[_0x3dd7fc(0x131)]||0x0,_0x5b0f33=_0x1af794[_0x3dd7fc(0x944)]||0x0,_0x400753=_0x1af794['Amp']||0x0,_0x5daec4=_0x1af794[_0x3dd7fc(0x962)]||0x0,_0xba10a2=_0x1af794[_0x3dd7fc(0x37b)]||0x1;for(const _0x17c1d0 of _0x252415){if(!_0x17c1d0)continue;if(!_0x17c1d0[_0x3dd7fc(0xac0)]())continue;const _0x34c33e=_0x17c1d0[_0x3dd7fc(0xac0)]();let _0x32d954=_0x34c33e['_baseX'],_0x29fe76=_0x34c33e[_0x3dd7fc(0x98c)];_0x32d954+=(Graphics[_0x3dd7fc(0x960)]-Graphics[_0x3dd7fc(0x719)])/0x2,_0x29fe76+=(Graphics[_0x3dd7fc(0xa97)]-Graphics[_0x3dd7fc(0x9ef)])/0x2;if(_0x370997[_0x3dd7fc(0x21d)](/front/i))_0x32d954+=(_0x17c1d0[_0x3dd7fc(0x31f)]()?0x1:-0x1)*_0x34c33e[_0x3dd7fc(0x8da)]()/0x2;else _0x370997['match'](/back/i)&&(_0x32d954+=(_0x17c1d0[_0x3dd7fc(0x31f)]()?-0x1:0x1)*_0x34c33e[_0x3dd7fc(0x8da)]()/0x2);if(_0x370997[_0x3dd7fc(0x21d)](/head/i))_0x29fe76-=_0x34c33e[_0x3dd7fc(0x3ae)]();else _0x370997[_0x3dd7fc(0x21d)](/center/i)&&(_0x29fe76-=_0x34c33e[_0x3dd7fc(0x3ae)]()/0x2);_0x32d954+=_0x25a880,_0x29fe76+=_0x5b0f33,_0x2ab3bc[_0x3dd7fc(0x84a)](_0x32d954,_0x29fe76,_0x400753,_0x5daec4,_0xba10a2);}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x2c0),_0x156da8=>{const _0x2f5b13=_0xa8cad7;if(!SceneManager[_0x2f5b13(0x45f)]())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x3b8749=SceneManager[_0x2f5b13(0x26b)][_0x2f5b13(0x726)];if(!_0x3b8749)return;VisuMZ[_0x2f5b13(0x17f)](_0x156da8,_0x156da8);const _0x1bcb28=VisuMZ[_0x2f5b13(0x449)](_0x156da8[_0x2f5b13(0x171)]),_0x3cd9ec=_0x156da8[_0x2f5b13(0x427)],_0x4bc361=_0x156da8[_0x2f5b13(0x131)]||0x0,_0x3cfc73=_0x156da8[_0x2f5b13(0x944)]||0x0,_0x217f46=_0x156da8[_0x2f5b13(0x279)]||0x0,_0x5331d6=_0x156da8[_0x2f5b13(0x962)]||0x0,_0x408e0c=_0x156da8[_0x2f5b13(0x37b)]||0x1,_0xc8ccf2=Math[_0x2f5b13(0x5b1)](..._0x1bcb28[_0x2f5b13(0x369)](_0xb44af=>_0xb44af[_0x2f5b13(0xac0)]()['_baseX']-_0xb44af[_0x2f5b13(0xac0)]()['mainSpriteWidth']()/0x2)),_0x512f61=Math[_0x2f5b13(0x743)](..._0x1bcb28['map'](_0x5c31de=>_0x5c31de[_0x2f5b13(0xac0)]()[_0x2f5b13(0x7c5)]+_0x5c31de[_0x2f5b13(0xac0)]()[_0x2f5b13(0x8da)]()/0x2)),_0x5ac488=Math['min'](..._0x1bcb28[_0x2f5b13(0x369)](_0x372268=>_0x372268['battler']()['_baseY']-_0x372268[_0x2f5b13(0xac0)]()[_0x2f5b13(0x3ae)]())),_0x4a74a4=Math['max'](..._0x1bcb28[_0x2f5b13(0x369)](_0xaf1b71=>_0xaf1b71['battler']()[_0x2f5b13(0x98c)])),_0xb2629f=_0x1bcb28[_0x2f5b13(0x1d2)](_0x775c23=>_0x775c23[_0x2f5b13(0x902)]())[_0x2f5b13(0x19c)],_0x37cab3=_0x1bcb28[_0x2f5b13(0x1d2)](_0x203484=>_0x203484[_0x2f5b13(0x31f)]())[_0x2f5b13(0x19c)];let _0x426faa=0x0,_0x3fa6b3=0x0;if(_0x3cd9ec[_0x2f5b13(0x21d)](/front/i)){if(_0x2f5b13(0x62a)!==_0x2f5b13(0x62a)){if(this[_0x2f5b13(0x6ab)]===_0x2f5b13(0x137))this[_0x2f5b13(0x659)]();else this['_phase']===_0x2f5b13(0x714)?this[_0x2f5b13(0x74c)]():_0x44d3d5[_0x2f5b13(0x8a9)]['BattleManager_updatePhase'][_0x2f5b13(0x9b5)](this,_0x353adc);}else _0x426faa=_0xb2629f>=_0x37cab3?_0xc8ccf2:_0x512f61;}else{if(_0x3cd9ec['match'](/middle/i))_0x426faa=(_0xc8ccf2+_0x512f61)/0x2,melee=-0x1;else{if(_0x3cd9ec['match'](/back/i)){if(_0x2f5b13(0x1c0)!==_0x2f5b13(0x51d))_0x426faa=_0xb2629f>=_0x37cab3?_0x512f61:_0xc8ccf2;else{const _0x37bd4c=_0x1849f1['indexOf'](_0x5f197f[_0x2f5b13(0x41c)]()[_0x2f5b13(0xb45)]());_0x37bd4c>=0x0&&_0x37bd4c<=0x7&&_0x1c9956['isDebuffAffected'](_0x37bd4c)&&_0x346a07[_0x2f5b13(0x298)](_0x37bd4c);}}}}if(_0x3cd9ec[_0x2f5b13(0x21d)](/head/i))_0x3fa6b3=_0x5ac488;else{if(_0x3cd9ec[_0x2f5b13(0x21d)](/center/i))_0x2f5b13(0x656)!==_0x2f5b13(0x1f8)?_0x3fa6b3=(_0x5ac488+_0x4a74a4)/0x2:_0x17b720[_0x2f5b13(0x379)]=_0x8819c;else _0x3cd9ec[_0x2f5b13(0x21d)](/base/i)&&(_0x3fa6b3=_0x4a74a4);}_0x426faa+=(Graphics[_0x2f5b13(0x960)]-Graphics[_0x2f5b13(0x719)])/0x2,_0x3fa6b3+=(Graphics['height']-Graphics[_0x2f5b13(0x9ef)])/0x2,_0x426faa+=_0x4bc361,_0x3fa6b3+=_0x3cfc73,_0x3b8749[_0x2f5b13(0x84a)](_0x426faa,_0x3fa6b3,_0x217f46,_0x5331d6,_0x408e0c);}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0xa31),_0x57ef5f=>{const _0x2f5c38=_0xa8cad7;if(!Imported[_0x2f5c38(0x119)])return;const _0x258338=SceneManager[_0x2f5c38(0x26b)]['_spriteset'];if(!_0x258338)return;VisuMZ['ConvertParams'](_0x57ef5f,_0x57ef5f);const _0x1cbc97=_0x57ef5f['X']||0x0,_0x5e5a02=_0x57ef5f['Y']||0x0,_0x1a99e6=_0x57ef5f[_0x2f5c38(0x63c)]||0x0,_0x37f899=_0x57ef5f[_0x2f5c38(0x1c4)]||0x0,_0x1e88fa=_0x57ef5f['Duration']||0x1,_0x78e460=_0x57ef5f[_0x2f5c38(0xabf)]||_0x2f5c38(0x9bc);_0x258338['setupZoomBlurImpactFilter'](_0x1a99e6,_0x1cbc97,_0x5e5a02,_0x37f899,_0x1e88fa,_0x78e460);}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x99c),_0x1a4d44=>{const _0xb4b0f6=_0xa8cad7;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x8695f5=SceneManager[_0xb4b0f6(0x26b)][_0xb4b0f6(0x726)];if(!_0x8695f5)return;VisuMZ[_0xb4b0f6(0x17f)](_0x1a4d44,_0x1a4d44);const _0x5b5f0c=VisuMZ['CreateActionSequenceTargets'](_0x1a4d44[_0xb4b0f6(0x171)]),_0x3fa8c8=_0x1a4d44[_0xb4b0f6(0x427)],_0x44451d=_0x1a4d44['OffsetX']||0x0,_0x2be863=_0x1a4d44[_0xb4b0f6(0x944)]||0x0,_0xb629c6=_0x1a4d44[_0xb4b0f6(0x63c)]||0x0,_0x3e770c=_0x1a4d44[_0xb4b0f6(0x1c4)]||0x0,_0x3185db=_0x1a4d44['Duration']||0x1,_0x56a7ef=_0x1a4d44[_0xb4b0f6(0xabf)]||_0xb4b0f6(0x9bc),_0xea612d=Math[_0xb4b0f6(0x5b1)](..._0x5b5f0c[_0xb4b0f6(0x369)](_0x454b28=>_0x454b28[_0xb4b0f6(0xac0)]()['_baseX']-_0x454b28['battler']()['mainSpriteWidth']()/0x2)),_0x327101=Math[_0xb4b0f6(0x743)](..._0x5b5f0c['map'](_0x4d96b3=>_0x4d96b3['battler']()[_0xb4b0f6(0x7c5)]+_0x4d96b3[_0xb4b0f6(0xac0)]()[_0xb4b0f6(0x8da)]()/0x2)),_0x20f010=Math[_0xb4b0f6(0x5b1)](..._0x5b5f0c[_0xb4b0f6(0x369)](_0x2457d5=>_0x2457d5['battler']()[_0xb4b0f6(0x98c)]-_0x2457d5[_0xb4b0f6(0xac0)]()[_0xb4b0f6(0x3ae)]())),_0xcdc36=Math['max'](..._0x5b5f0c[_0xb4b0f6(0x369)](_0x47e305=>_0x47e305[_0xb4b0f6(0xac0)]()[_0xb4b0f6(0x98c)])),_0x47dcf1=_0x5b5f0c['filter'](_0x674491=>_0x674491[_0xb4b0f6(0x902)]())[_0xb4b0f6(0x19c)],_0x287852=_0x5b5f0c[_0xb4b0f6(0x1d2)](_0x27ff18=>_0x27ff18[_0xb4b0f6(0x31f)]())[_0xb4b0f6(0x19c)];let _0x2d40f3=0x0,_0x2db068=0x0;if(_0x3fa8c8[_0xb4b0f6(0x21d)](/front/i)){if('olqJF'!==_0xb4b0f6(0x196))_0x2d40f3=_0x47dcf1>=_0x287852?_0xea612d:_0x327101;else{let _0x329d41=0x1;return _0x329d41*=this[_0xb4b0f6(0x42d)],_0x329d41*=this[_0xb4b0f6(0x494)],_0x329d41;}}else{if(_0x3fa8c8[_0xb4b0f6(0x21d)](/middle/i))_0x2d40f3=(_0xea612d+_0x327101)/0x2,melee=-0x1;else{if(_0x3fa8c8[_0xb4b0f6(0x21d)](/back/i)){if(_0xb4b0f6(0xa23)!==_0xb4b0f6(0x6da))_0x2d40f3=_0x47dcf1>=_0x287852?_0x327101:_0xea612d;else{const _0xb92836=this[_0xb4b0f6(0xb86)]['shift'](),_0x289ad1=_0xb92836[0x0];return _0x289ad1[_0xb4b0f6(0x124)]=_0x289ad1[_0xb4b0f6(0x124)]||[],_0x289ad1[_0xb4b0f6(0x124)][0x0]=_0xb92836[0x1],_0x289ad1;}}}}if(_0x3fa8c8[_0xb4b0f6(0x21d)](/head/i))_0x2db068=_0x20f010;else{if(_0x3fa8c8[_0xb4b0f6(0x21d)](/center/i))_0x2db068=(_0x20f010+_0xcdc36)/0x2;else{if(_0x3fa8c8[_0xb4b0f6(0x21d)](/base/i)){if(_0xb4b0f6(0x51e)===_0xb4b0f6(0x51e))_0x2db068=_0xcdc36;else{_0x9f58cf=_0x4628a3||0x1,_0x36d825--;const _0x36a723=this['weapons'](),_0x3a366e=_0x36a723[_0x2078f5]?_0x36a723[_0x1f596b][_0xb4b0f6(0x90a)]:0x0;return _0x2cde32['attackMotions'][_0x3a366e];}}}}_0x2d40f3+=(Graphics[_0xb4b0f6(0x960)]-Graphics[_0xb4b0f6(0x719)])/0x2,_0x2db068+=(Graphics[_0xb4b0f6(0xa97)]-Graphics[_0xb4b0f6(0x9ef)])/0x2,_0x2d40f3+=_0x44451d,_0x2db068+=_0x2be863,_0x8695f5[_0xb4b0f6(0xa28)](_0xb629c6,_0x2d40f3,_0x2db068,_0x3e770c,_0x3185db,_0x56a7ef);}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Mechanics_ActionEffect',_0x49e045=>{const _0x4fe7e5=_0xa8cad7;if(!SceneManager[_0x4fe7e5(0x45f)]())return;VisuMZ[_0x4fe7e5(0x17f)](_0x49e045,_0x49e045);const _0x571e79=$gameTemp['getLastPluginCommandInterpreter'](),_0x288666=BattleManager[_0x4fe7e5(0x95a)],_0x29da9a=BattleManager[_0x4fe7e5(0x4d4)],_0x1277e7=BattleManager[_0x4fe7e5(0x896)];if(!_0x571e79||!_0x288666||!_0x29da9a)return;if(!_0x288666['item']())return;const _0x450f4=VisuMZ[_0x4fe7e5(0x449)](_0x49e045[_0x4fe7e5(0x171)]);for(const _0x2f0a01 of _0x450f4){if(!_0x2f0a01)continue;_0x1277e7[_0x4fe7e5(0x6c0)](_0x4fe7e5(0x15c),_0x29da9a,_0x2f0a01);}_0x571e79[_0x4fe7e5(0x1e7)]('battlelog');}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x484),_0xa14c57=>{const _0x14c97e=_0xa8cad7;if(!SceneManager[_0x14c97e(0x45f)]())return;VisuMZ[_0x14c97e(0x17f)](_0xa14c57,_0xa14c57);const _0x220c54=['MAXHP',_0x14c97e(0x1b7),_0x14c97e(0xb2b),_0x14c97e(0x4dc),'MAT','MDF',_0x14c97e(0x6db),_0x14c97e(0x748)],_0x59173a=_0xa14c57[_0x14c97e(0xa05)],_0x304dcb=_0xa14c57[_0x14c97e(0x94e)],_0x10af8b=_0xa14c57[_0x14c97e(0x4ad)],_0x169479=VisuMZ[_0x14c97e(0x449)](_0xa14c57['Targets']);for(const _0x13e327 of _0x169479){if(!_0x13e327)continue;for(const _0x209077 of _0x59173a){if(_0x14c97e(0x41f)!==_0x14c97e(0x739)){const _0x91808f=_0x220c54[_0x14c97e(0x153)](_0x209077[_0x14c97e(0x41c)]()['trim']());_0x91808f>=0x0&&_0x91808f<=0x7&&_0x13e327['addBuff'](_0x91808f,_0x10af8b);}else _0x1ba07d=_0x5a2d98[_0x14c97e(0x1d2)]((_0x49b9f5,_0x2853a0,_0x1c992e)=>_0x1c992e[_0x14c97e(0x153)](_0x49b9f5)===_0x2853a0),_0x3f58af[_0x14c97e(0x45f)]()&&_0x3e8d08[_0x14c97e(0xb26)]()&&(_0x36e907=!_0x5d0728),_0x1efb7e['BattleCore'][_0x14c97e(0x454)]['call'](this,_0x2c1f21,_0x5de75f,_0x237a83),_0x473b3b['isSceneBattle']()&&_0x184cc4[_0x14c97e(0x726)][_0x14c97e(0x8f7)]();}for(const _0x2bbccf of _0x304dcb){const _0xd2f2b=_0x220c54[_0x14c97e(0x153)](_0x2bbccf[_0x14c97e(0x41c)]()[_0x14c97e(0xb45)]());_0xd2f2b>=0x0&&_0xd2f2b<=0x7&&(_0x14c97e(0x6cc)===_0x14c97e(0x1ed)?_0x20880a[_0x14c97e(0x6c0)](_0x14c97e(0x375),_0x4b0cc6,_0x192c6c):_0x13e327[_0x14c97e(0x988)](_0xd2f2b,_0x10af8b));}}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0xb0f),_0x2565f8=>{const _0x4f79e4=_0xa8cad7;if(!SceneManager[_0x4f79e4(0x45f)]())return;VisuMZ[_0x4f79e4(0x17f)](_0x2565f8,_0x2565f8);const _0x4987b4=_0x2565f8[_0x4f79e4(0x2a3)],_0x42f9c9=VisuMZ['CreateActionSequenceTargets'](_0x2565f8['Targets']);for(const _0x5c3b5f of _0x42f9c9){if(!_0x5c3b5f)continue;for(const _0x45a3eb of _0x4987b4){if(_0x4f79e4(0x252)!==_0x4f79e4(0x252)){const _0x444fb9=this[_0x4f79e4(0x1cc)]();['xp',_0x4f79e4(0x33b),_0x4f79e4(0xb48)]['includes'](_0x444fb9)&&this['_actorCommandWindow']['close'](),(_0x444fb9===_0x4f79e4(0xb48)||this['isSkillItemWindowsMiddle']())&&(this['_skillWindow'][_0x4f79e4(0x19b)](),this[_0x4f79e4(0xac8)][_0x4f79e4(0x19b)]());}else _0x5c3b5f[_0x4f79e4(0x567)](_0x45a3eb);}}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x3bd),_0x126351=>{const _0x21a52c=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x21a52c(0x17f)](_0x126351,_0x126351);const _0x3b88de=BattleManager[_0x21a52c(0x95a)],_0x31f077={'arPenRate':_0x126351[_0x21a52c(0x6b7)],'arPenFlat':_0x126351[_0x21a52c(0x720)],'arRedRate':_0x126351[_0x21a52c(0x60b)],'arRedFlat':_0x126351[_0x21a52c(0x86f)]};_0x3b88de['_armorPenetration']=_0x31f077;}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x88e),_0x13ff89=>{const _0x46d200=_0xa8cad7;if(!SceneManager[_0x46d200(0x45f)]())return;if(!Imported[_0x46d200(0x737)])return;VisuMZ['ConvertParams'](_0x13ff89,_0x13ff89);const _0x2be271=VisuMZ['CreateActionSequenceTargets'](_0x13ff89[_0x46d200(0x171)]),_0x1995ce=_0x13ff89[_0x46d200(0x8f4)]||0x1;for(const _0x4d4d0b of _0x2be271){if(!_0x4d4d0b)continue;if(!_0x4d4d0b[_0x46d200(0x31f)]())continue;_0x4d4d0b[_0x46d200(0x3f5)](_0x1995ce);}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Mechanics_AtbGauge',_0x1c35a9=>{const _0x2e5c81=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x2e5c81(0xb62)])return;if(!BattleManager[_0x2e5c81(0x377)]())return;VisuMZ[_0x2e5c81(0x17f)](_0x1c35a9,_0x1c35a9);const _0x4ce524=VisuMZ[_0x2e5c81(0x449)](_0x1c35a9[_0x2e5c81(0x171)]),_0x31ec2f=_0x1c35a9[_0x2e5c81(0x7a7)],_0x50259a=_0x1c35a9['ChargeRate'],_0x5cd0c9=_0x1c35a9[_0x2e5c81(0x929)];for(const _0x16d74c of _0x4ce524){if(!_0x16d74c)continue;if(_0x16d74c[_0x2e5c81(0x13c)]())_0x16d74c[_0x2e5c81(0x6f6)](_0x31ec2f);else{if(_0x16d74c['isAtbCastingState']()){_0x16d74c['changeAtbCastTime'](_0x50259a);if(_0x5cd0c9)_0x16d74c['atbInterrupt']();}}}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x4fd),_0x2e34c1=>{const _0x2a0f04=_0xa8cad7;if(!SceneManager[_0x2a0f04(0x45f)]())return;if(!Imported['VisuMZ_3_BoostAction'])return;VisuMZ[_0x2a0f04(0x17f)](_0x2e34c1,_0x2e34c1);const _0x514b56=VisuMZ[_0x2a0f04(0x449)](_0x2e34c1[_0x2a0f04(0x171)]),_0xe85088=_0x2e34c1[_0x2a0f04(0x7c4)];for(const _0x35dd19 of _0x514b56){if(!_0x35dd19)continue;_0x35dd19['gainStoredBoostPoints'](_0xe85088);}}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0xb77),_0x2e1471=>{const _0x2548cd=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x2548cd(0xaa6)])return;if(!BattleManager['_subject'])return;VisuMZ[_0x2548cd(0x17f)](_0x2e1471,_0x2e1471);const _0x26eb78=_0x2e1471[_0x2548cd(0x32f)];$gameVariables[_0x2548cd(0x200)](_0x26eb78,BattleManager['_subject'][_0x2548cd(0x2d5)]());}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Mechanics_BreakShieldChange',_0x3206d2=>{const _0x565ace=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x565ace(0x9de)])return;VisuMZ['ConvertParams'](_0x3206d2,_0x3206d2);const _0x358db1=VisuMZ[_0x565ace(0x449)](_0x3206d2[_0x565ace(0x171)]),_0xba447c=_0x3206d2['BreakShields'];for(const _0x3d8231 of _0x358db1){if(!_0x3d8231)continue;if(_0x3d8231[_0x565ace(0x715)]())continue;if(!_0x3d8231[_0x565ace(0x24b)]())continue;_0x3d8231[_0x565ace(0x58d)](_0xba447c);}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x791),_0x308c96=>{const _0x1065d1=_0xa8cad7;if(!SceneManager[_0x1065d1(0x45f)]())return;if(!Imported['VisuMZ_4_BreakShields'])return;VisuMZ[_0x1065d1(0x17f)](_0x308c96,_0x308c96);const _0xc9582a=VisuMZ[_0x1065d1(0x449)](_0x308c96[_0x1065d1(0x171)]);for(const _0x50e6e3 of _0xc9582a){if(!_0x50e6e3)continue;if(_0x50e6e3[_0x1065d1(0x715)]())continue;if(!_0x50e6e3[_0x1065d1(0x24b)]())continue;_0x50e6e3['resetBreakShield']();}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x7d9),_0x51fcac=>{const _0x165dbd=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x165dbd(0x4c0)])return;if(!BattleManager[_0x165dbd(0x3d3)]())return;VisuMZ[_0x165dbd(0x17f)](_0x51fcac,_0x51fcac);const _0x23b2ae=VisuMZ[_0x165dbd(0x449)](_0x51fcac[_0x165dbd(0x171)]),_0x3ed60e=_0x51fcac[_0x165dbd(0x141)];for(const _0x587330 of _0x23b2ae){if(!_0x587330)continue;_0x587330[_0x165dbd(0x296)](_0x3ed60e);}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x66b),_0x218a9e=>{const _0x4cb999=_0xa8cad7;if(!SceneManager[_0x4cb999(0x45f)]())return;VisuMZ[_0x4cb999(0x17f)](_0x218a9e,_0x218a9e);const _0x58011e=$gameTemp[_0x4cb999(0x933)](),_0x3c83e8=BattleManager[_0x4cb999(0x95a)],_0x5f301e=BattleManager[_0x4cb999(0x4d4)];if(!_0x58011e||!_0x3c83e8||!_0x5f301e)return;if(!_0x3c83e8[_0x4cb999(0x191)]())return;const _0x212ced=VisuMZ[_0x4cb999(0x449)](_0x218a9e[_0x4cb999(0x171)]);for(const _0x3ddc16 of _0x212ced){if('mnDqF'==='wshwe')return _0x3afa66(_0x26734b['$1']);else{if(!_0x3ddc16)continue;_0x218a9e[_0x4cb999(0x2d9)]&&(_0x3ddc16[_0x4cb999(0x760)](),_0x3ddc16['addState'](_0x3ddc16[_0x4cb999(0x2a2)]())),_0x3ddc16[_0x4cb999(0x89b)]()&&_0x3ddc16[_0x4cb999(0x506)]();}}_0x58011e[_0x4cb999(0x1e7)](_0x4cb999(0x348));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x33c),_0xbe8741=>{const _0x392709=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x392709(0x456)])return;if(!BattleManager[_0x392709(0x78e)]())return;VisuMZ[_0x392709(0x17f)](_0xbe8741,_0xbe8741);const _0x295ce9=VisuMZ[_0x392709(0x449)](_0xbe8741['Targets']),_0x188778=_0xbe8741[_0x392709(0x1a7)];for(const _0xb0356e of _0x295ce9){if(!_0xb0356e)continue;_0xb0356e[_0x392709(0xa01)](_0x188778);}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x230),_0x1fff84=>{const _0x5a533c=_0xa8cad7;if(!SceneManager[_0x5a533c(0x45f)]())return;if(!Imported[_0x5a533c(0x456)])return;if(!BattleManager['isCTB']())return;VisuMZ[_0x5a533c(0x17f)](_0x1fff84,_0x1fff84);const _0x5f3e3f=VisuMZ[_0x5a533c(0x449)](_0x1fff84[_0x5a533c(0x171)]),_0x1dd08a=_0x1fff84[_0x5a533c(0x7a7)],_0x4ed094=_0x1fff84['ChargeRate'];for(const _0x3b4525 of _0x5f3e3f){if(!_0x3b4525)continue;if(_0x3b4525['_tpbState']==='charging')_0x3b4525['changeCtbChargeTime'](_0x1dd08a);else _0x3b4525[_0x5a533c(0x16e)]===_0x5a533c(0x6e4)&&_0x3b4525['changeCtbCastTime'](_0x4ed094);}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Mechanics_CustomDmgFormula',_0x5c9b5a=>{const _0x341af8=_0xa8cad7;if(!SceneManager[_0x341af8(0x45f)]())return;VisuMZ[_0x341af8(0x17f)](_0x5c9b5a,_0x5c9b5a);const _0x46dd1c=BattleManager[_0x341af8(0x95a)];if(!_0x46dd1c)return;let _0x2a46ec=_0x5c9b5a[_0x341af8(0x770)];_0x46dd1c[_0x341af8(0x56d)](_0x2a46ec);}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x9f5),_0x1f566d=>{const _0x5694b9=_0xa8cad7;if(!SceneManager[_0x5694b9(0x45f)]())return;VisuMZ[_0x5694b9(0x17f)](_0x1f566d,_0x1f566d);const _0x43c959=VisuMZ[_0x5694b9(0x449)](_0x1f566d['Targets']);for(const _0x118d3e of _0x43c959){if(!_0x118d3e)continue;if(_0x118d3e['shouldPopupDamage']())_0x118d3e[_0x5694b9(0x7f2)]();}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x368),_0x11f1ec=>{const _0x1a8c7b=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x1a8c7b(0x17f)](_0x11f1ec,_0x11f1ec);const _0x36a896=$gameTemp[_0x1a8c7b(0x933)](),_0x29a09c=BattleManager[_0x1a8c7b(0x4d4)],_0x40509b=_0x11f1ec[_0x1a8c7b(0x30a)];if(!_0x36a896)return;if(!_0x29a09c)return;if(_0x29a09c&&_0x29a09c[_0x1a8c7b(0xb06)]()&&_0x40509b[_0x1a8c7b(0x41c)]()['trim']()!=='UNTITLED'){if(_0x1a8c7b(0x56e)!==_0x1a8c7b(0x56e))return _0x512d21[_0x1a8c7b(0x996)]()[_0x1a8c7b(0x209)]()['filter'](_0x497903=>_0x497903!==_0x17884a);else _0x36a896['command119']([_0x40509b]);}}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Mechanics_EnemyEscape',_0xbcf24b=>{const _0x35f4d5=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0xbcf24b,_0xbcf24b);const _0x158ff3=VisuMZ[_0x35f4d5(0x449)](_0xbcf24b[_0x35f4d5(0x171)]);for(const _0x45298f of _0x158ff3){if(!_0x45298f)continue;if(!_0x45298f[_0x35f4d5(0x31f)]())continue;_0x45298f[_0x35f4d5(0x1ce)]();}}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Mechanics_EtbAction',_0x13a0b1=>{const _0x10f79b=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x10f79b(0xa66)])return;if(!BattleManager[_0x10f79b(0x2ce)]())return;VisuMZ[_0x10f79b(0x17f)](_0x13a0b1,_0x13a0b1);const _0x341234=_0x13a0b1[_0x10f79b(0x82b)];BattleManager['_subject']&&BattleManager[_0x10f79b(0x4d4)][_0x10f79b(0x996)]()[_0x10f79b(0x430)](_0x341234);}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x66d),_0x1e8268=>{const _0x3a443e=_0xa8cad7;if(!SceneManager[_0x3a443e(0x45f)]())return;if(!Imported[_0x3a443e(0x15e)])return;if(!BattleManager[_0x3a443e(0x73e)]())return;VisuMZ[_0x3a443e(0x17f)](_0x1e8268,_0x1e8268);const _0x47e4bd=_0x1e8268[_0x3a443e(0x82b)];BattleManager[_0x3a443e(0x4d4)]&&(_0x3a443e(0x816)!==_0x3a443e(0x816)?this[_0x3a443e(0x43c)]=this[_0x3a443e(0x43c)]||[]:BattleManager[_0x3a443e(0x4d4)]['friendsUnit']()['gainCurrentActionsFTB'](_0x47e4bd));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x86c),_0x49b843=>{const _0x43d460=_0xa8cad7;if(!SceneManager[_0x43d460(0x45f)]())return;VisuMZ['ConvertParams'](_0x49b843,_0x49b843);const _0x5c1274=VisuMZ[_0x43d460(0x449)](_0x49b843[_0x43d460(0x171)]),_0x170c68=_0x49b843[_0x43d460(0x890)],_0x5b6022=_0x49b843[_0x43d460(0x462)],_0x455a52=_0x49b843[_0x43d460(0x458)],_0xc8c28f=_0x49b843['MP_Flat'],_0x3f9d2c=_0x49b843[_0x43d460(0x641)],_0x3e523b=_0x49b843['TP_Flat'],_0x540309=_0x49b843['ShowPopup'];for(const _0x881029 of _0x5c1274){if(!_0x881029)continue;const _0x32420c=_0x881029['isAlive'](),_0x52d2e2=Math[_0x43d460(0x2cb)](_0x170c68*_0x881029[_0x43d460(0x827)]+_0x5b6022),_0x51fa76=Math[_0x43d460(0x2cb)](_0x455a52*_0x881029[_0x43d460(0x9e0)]+_0xc8c28f),_0x94e66c=Math[_0x43d460(0x2cb)](_0x3f9d2c*_0x881029[_0x43d460(0x37c)]()+_0x3e523b);if(_0x52d2e2!==0x0)_0x881029[_0x43d460(0x481)](_0x52d2e2);if(_0x51fa76!==0x0)_0x881029['gainMp'](_0x51fa76);if(_0x94e66c!==0x0)_0x881029[_0x43d460(0xa14)](_0x94e66c);if(_0x540309)_0x881029['startDamagePopup']();if(_0x32420c&&_0x881029['isDead']()){if(_0x43d460(0x44e)===_0x43d460(0x44e))_0x881029[_0x43d460(0x506)]();else return this['_immortal'];}}}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0xaf7),_0x4b5704=>{const _0x620410=_0xa8cad7;if(!SceneManager[_0x620410(0x45f)]())return;VisuMZ['ConvertParams'](_0x4b5704,_0x4b5704);const _0x269f63=VisuMZ[_0x620410(0x449)](_0x4b5704[_0x620410(0x171)]);for(const _0x228b6e of _0x269f63){if(!_0x228b6e)continue;_0x228b6e[_0x620410(0xa0b)](_0x4b5704['Immortal']);}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x99b),_0x5906b7=>{const _0x2a1176=_0xa8cad7;if(!SceneManager[_0x2a1176(0x45f)]())return;VisuMZ[_0x2a1176(0x17f)](_0x5906b7,_0x5906b7);const _0x13f726=BattleManager[_0x2a1176(0x95a)],_0x618d15={'criticalHitRate':_0x5906b7[_0x2a1176(0x5bf)],'criticalHitFlat':_0x5906b7[_0x2a1176(0x965)],'criticalDmgRate':_0x5906b7[_0x2a1176(0xb14)],'criticalDmgFlat':_0x5906b7[_0x2a1176(0x3d2)],'damageRate':_0x5906b7['DamageRate'],'damageFlat':_0x5906b7[_0x2a1176(0x38f)],'hitRate':_0x5906b7['HitRate'],'hitFlat':_0x5906b7[_0x2a1176(0x359)]};_0x13f726[_0x2a1176(0x9f4)]=_0x618d15;}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x211),_0x20c65c=>{const _0x5a6bdc=_0xa8cad7;if(!SceneManager[_0x5a6bdc(0x45f)]())return;VisuMZ['ConvertParams'](_0x20c65c,_0x20c65c);const _0x112b89=_0x20c65c[_0x5a6bdc(0x881)];SceneManager[_0x5a6bdc(0x26b)]['playOnceParallelInterpreter'](_0x112b89);}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x46f),_0x107f49=>{const _0x53a4b7=_0xa8cad7;if(!SceneManager[_0x53a4b7(0x45f)]())return;if(!Imported[_0x53a4b7(0x26a)])return;if(!BattleManager[_0x53a4b7(0x74b)]())return;VisuMZ['ConvertParams'](_0x107f49,_0x107f49);const _0x33757c=VisuMZ[_0x53a4b7(0x449)](_0x107f49[_0x53a4b7(0x171)]);for(const _0x628eef of _0x33757c){if(_0x53a4b7(0x254)===_0x53a4b7(0x47b))_0x1b3362[_0x53a4b7(0x610)](_0x53de4f);else{if(!_0x628eef)continue;let _0x71433d=_0x107f49['CurrentTurn'],_0x41c8f6=_0x107f49[_0x53a4b7(0x2ae)],_0x52bbef=_0x107f49[_0x53a4b7(0xb8f)];if(BattleManager[_0x53a4b7(0xa53)][_0x53a4b7(0x220)](_0x628eef)){if(_0x53a4b7(0x58a)===_0x53a4b7(0x500)){const _0x329487=_0x506bbd[_0x53a4b7(0x153)](_0x2d0a52);return _0x329487>=0x0?[_0x1513b0[_0x329487+0x1]||_0x3de42d]:[_0x497410];}else _0x71433d+=_0x52bbef;}else{if(_0x53a4b7(0x2fe)!==_0x53a4b7(0x4e4))_0x41c8f6+=_0x52bbef;else{let _0x27b95b=_0x3cc9ee[_0x53a4b7(0x927)][_0x2fc069];if(!_0x27b95b)return;let _0x337e43=_0x27b95b;const _0x5c0a8f=this['commandStyle']();if(_0x5c0a8f==='text')_0x337e43=_0x337e43['replace'](/\x1I\[(\d+)\]/gi,''),_0x337e43=_0x337e43[_0x53a4b7(0x536)](/\\I\[(\d+)\]/gi,'');else{if(!_0x27b95b[_0x53a4b7(0x21d)](/\\I\[(\d+)\]/i)){const _0x17ce6f=_0x227816[_0x53a4b7(0xb36)]?_0x445561[_0x53a4b7(0x37f)][_0x53a4b7(0xb57)]['Skills']:_0x3f5739[_0x53a4b7(0x8a9)][_0x53a4b7(0xb57)]['ActorCmd'],_0x3b47cb=_0x3db83b['magicSkills'][_0x53a4b7(0x220)](_0x87e7f0),_0x53a2c4=_0x3b47cb?_0x17ce6f[_0x53a4b7(0x53d)]:_0x17ce6f[_0x53a4b7(0x71b)];_0x337e43='\x5cI[%1]%2'[_0x53a4b7(0x69b)](_0x53a2c4,_0x27b95b);}}this[_0x53a4b7(0x87d)](_0x337e43,_0x53a4b7(0x7e1),!![],_0x153bb4);}}BattleManager[_0x53a4b7(0x57d)](_0x628eef,-_0x71433d,![]),BattleManager[_0x53a4b7(0x57d)](_0x628eef,-_0x41c8f6,!![]);}}}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x30f),_0x4af748=>{const _0x4be618=_0xa8cad7;if(!SceneManager[_0x4be618(0x45f)]())return;if(!Imported['VisuMZ_2_BattleSystemPTB'])return;if(!BattleManager[_0x4be618(0x4f8)]())return;VisuMZ[_0x4be618(0x17f)](_0x4af748,_0x4af748);const _0x320413=BattleManager[_0x4be618(0x4d4)][_0x4be618(0x996)](),_0x4c6a9f=_0x4af748['Override'],_0x5aafe6=_0x4af748[_0x4be618(0x608)]||_0x4be618(0x604),_0x288ba9=_0x4af748[_0x4be618(0x6fb)]||_0x4be618(0x604),_0x1b3693=_0x4af748[_0x4be618(0x5d5)]||0x0,_0x1de59e=_0x4af748[_0x4be618(0x41d)]||0x0;if(_0x320413['canAlterActionCostPTB']()||_0x4c6a9f){if('MweLN'!==_0x4be618(0x6d1))_0x4c6a9f&&(_0x320413[_0x4be618(0x381)]=_0x320413[_0x4be618(0x381)]||{},_0x320413[_0x4be618(0x381)][_0x4be618(0x96e)]=0x0),_0x320413['alterActionCostPTB'](_0x5aafe6,_0x288ba9,_0x1b3693,_0x1de59e);else return _0x3d8673['prototype'][_0x4be618(0x558)]['call'](this);}}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Mechanics_PtbConvert',_0x15eb4f=>{const _0x5d7452=_0xa8cad7;if(!SceneManager[_0x5d7452(0x45f)]())return;if(!Imported[_0x5d7452(0xa6c)])return;if(!BattleManager[_0x5d7452(0x4f8)]())return;VisuMZ[_0x5d7452(0x17f)](_0x15eb4f,_0x15eb4f);const _0x20b734=BattleManager[_0x5d7452(0x4d4)][_0x5d7452(0x996)]();let _0x31ffef=Math[_0x5d7452(0x743)](_0x15eb4f[_0x5d7452(0x632)],0x0),_0x207099=_0x20b734[_0x5d7452(0x6f4)](),_0x3d92e1=_0x20b734['getHalfActionsPTB']();while(_0x31ffef--){if(_0x207099<=0x0&&_0x3d92e1<=0x0)break;else _0x207099>0x0?(_0x207099--,_0x3d92e1++):_0x3d92e1--;}_0x20b734['setFullActionsPTB'](_0x207099),_0x20b734[_0x5d7452(0x346)](_0x3d92e1);}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0xadb),_0x2f783c=>{const _0x52648f=_0xa8cad7;if(!SceneManager[_0x52648f(0x45f)]())return;if(!Imported['VisuMZ_2_BattleSystemPTB'])return;if(!BattleManager['isPTB']())return;VisuMZ[_0x52648f(0x17f)](_0x2f783c,_0x2f783c);const _0x5a5471=BattleManager[_0x52648f(0x4d4)][_0x52648f(0x996)]();let _0x3be486=_0x2f783c[_0x52648f(0x9da)],_0x5c2e15=_0x2f783c[_0x52648f(0x8be)];_0x5a5471[_0x52648f(0x5a4)](_0x3be486),_0x5a5471['gainHalfActionsPTB'](_0x5c2e15);}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],'ActSeq_Mechanics_RemoveBuffDebuff',_0x2d983b=>{const _0x178698=_0xa8cad7;if(!SceneManager[_0x178698(0x45f)]())return;VisuMZ[_0x178698(0x17f)](_0x2d983b,_0x2d983b);const _0x37f1a6=[_0x178698(0x3ef),_0x178698(0x1b7),_0x178698(0xb2b),_0x178698(0x4dc),_0x178698(0x9a4),_0x178698(0x3b4),'AGI',_0x178698(0x748)],_0x46ee49=_0x2d983b[_0x178698(0xa05)],_0x45545b=_0x2d983b[_0x178698(0x94e)],_0x23b3ae=VisuMZ[_0x178698(0x449)](_0x2d983b[_0x178698(0x171)]);for(const _0x24a5c8 of _0x23b3ae){if(!_0x24a5c8)continue;for(const _0x3405e of _0x46ee49){const _0x28d696=_0x37f1a6[_0x178698(0x153)](_0x3405e[_0x178698(0x41c)]()[_0x178698(0xb45)]());if(_0x28d696>=0x0&&_0x28d696<=0x7&&_0x24a5c8[_0x178698(0x83a)](_0x28d696)){if(_0x178698(0x672)!=='HhWFR')_0x24a5c8[_0x178698(0x298)](_0x28d696);else{const _0x3e0804=_0x267706[_0x178698(0x8a9)]['Settings']['Mechanics'];_0x3e0804[_0x178698(0x8d3)]&&_0x431372[_0x178698(0x8a9)]['CheckMapBattleEventValid'](_0x3e0804[_0x178698(0x8d3)])&&_0x1f49b9[_0x178698(0xa71)](_0x3e0804[_0x178698(0x8d3)]);const _0x2959df=_0x178698(0x4ea)[_0x178698(0x69b)](_0x352135);_0x3e0804[_0x2959df]&&_0x395631[_0x178698(0x8a9)]['CheckMapBattleEventValid'](_0x3e0804[_0x2959df])&&_0x372ec7[_0x178698(0xa71)](_0x3e0804[_0x2959df]);}}}for(const _0xd5c1e0 of _0x45545b){if(_0x178698(0xb64)===_0x178698(0x399)){const _0x50b30c=_0x3d2ff4[_0x178698(0xac0)]();this[_0x178698(0x6c0)](_0x178698(0x9e3),[_0x128918],_0x1716d1,_0x5d41c1),this['push'](_0x178698(0x1fa),_0x152063,_0x50b30c['_homeX'],_0x50b30c['_homeY'],_0x2758ff,![],_0x178698(0x9bc)),this[_0x178698(0x6c0)](_0x178698(0x300),[_0x2aca77],_0x178698(0xa8e)),this[_0x178698(0x6c0)](_0x178698(0x33f)),this['push'](_0x178698(0x300),[_0x551968],_0x178698(0x18e));}else{const _0x12ba7c=_0x37f1a6[_0x178698(0x153)](_0xd5c1e0[_0x178698(0x41c)]()[_0x178698(0xb45)]());_0x12ba7c>=0x0&&_0x12ba7c<=0x7&&_0x24a5c8['isDebuffAffected'](_0x12ba7c)&&_0x24a5c8[_0x178698(0x298)](_0x12ba7c);}}}}),PluginManager['registerCommand'](pluginData['name'],_0xa8cad7(0x188),_0x2a7c45=>{const _0x313169=_0xa8cad7;if(!SceneManager[_0x313169(0x45f)]())return;VisuMZ['ConvertParams'](_0x2a7c45,_0x2a7c45);const _0x4b09e0=_0x2a7c45['States'],_0x27abdd=VisuMZ['CreateActionSequenceTargets'](_0x2a7c45['Targets']);for(const _0x4519ce of _0x27abdd){if(!_0x4519ce)continue;for(const _0x280eed of _0x4b09e0){if(_0x313169(0x6ad)===_0x313169(0x2fb)){this[_0x313169(0x883)](),this[_0x313169(0x629)](),this[_0x313169(0x689)](),this[_0x313169(0x89f)](),this[_0x313169(0x888)](),_0x529ec4[_0x313169(0x8a9)]['Sprite_Battler_updateMain'][_0x313169(0x9b5)](this);if(this[_0x313169(0xa17)]===_0x3ebd46)this['updateShadow']();}else _0x4519ce[_0x313169(0x610)](_0x280eed);}}}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x269),_0x5a680b=>{const _0x386fc0=_0xa8cad7;if(!SceneManager[_0x386fc0(0x45f)]())return;if(!Imported[_0x386fc0(0x8ac)])return;if(!BattleManager[_0x386fc0(0x1da)]())return;VisuMZ['ConvertParams'](_0x5a680b,_0x5a680b);const _0x9abff9=_0x5a680b['Exploited'],_0x5485dd=VisuMZ[_0x386fc0(0x449)](_0x5a680b[_0x386fc0(0x171)]),_0x29f181=_0x5a680b['ForceExploited'],_0x165f75=_0x5a680b['Exploiter'],_0x5c53f0=_0x5a680b[_0x386fc0(0x96b)],_0x463e58=BattleManager['_action'];if(_0x9abff9)for(const _0x56295e of _0x5485dd){if(!_0x56295e)continue;if(_0x56295e===user)continue;if(_0x29f181)_0x56295e[_0x386fc0(0x128)](![]);_0x56295e[_0x386fc0(0x585)](BattleManager[_0x386fc0(0x4d4)],_0x463e58);}if(_0x165f75&&BattleManager[_0x386fc0(0x4d4)]){if(_0x386fc0(0xad0)==='LoRAc'){if(_0x5c53f0)BattleManager[_0x386fc0(0x4d4)][_0x386fc0(0x128)](![]);const _0x2f3dd8=_0x5485dd[0x0];BattleManager[_0x386fc0(0x198)](_0x2f3dd8,_0x463e58);}else{this['_cacheTextWidth']=_0x456390;const _0x356eb6=this['name'](),_0x3976a4=this[_0x386fc0(0x9ad)](),_0x15f5f6=_0x373663[_0x386fc0(0xa60)][_0x386fc0(0x8c3)]();this['setupFont'](),this[_0x386fc0(0x379)][_0x386fc0(0x711)](),this[_0x386fc0(0x379)]['drawText'](_0x356eb6,0x0,0x0,_0x3976a4,_0x15f5f6,_0x386fc0(0x725));}}}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x51f),_0x5e8b0b=>{const _0x30e206=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x30e206(0x8ac)])return;if(!BattleManager['isSTB']())return;VisuMZ['ConvertParams'](_0x5e8b0b,_0x5e8b0b);const _0x91d251=_0x5e8b0b['Actions'];BattleManager[_0x30e206(0x4d4)]&&(_0x30e206(0x806)===_0x30e206(0x806)?BattleManager['_subject']['stbGainInstant'](_0x91d251):(_0x8d3175[_0x30e206(0x472)]||_0x13b25b[_0x30e206(0xae9)])&&_0x20036f[_0x30e206(0xa3c)]());}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x763),_0x3006e7=>{const _0xe1537d=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_2_BattleSystemSTB'])return;if(!BattleManager[_0xe1537d(0x1da)]())return;VisuMZ['ConvertParams'](_0x3006e7,_0x3006e7);let _0x3289ac=_0x3006e7['Actions'];if(BattleManager[_0xe1537d(0x4d4)]){BattleManager[_0xe1537d(0x4d4)][_0xe1537d(0x124)]=BattleManager[_0xe1537d(0x4d4)][_0xe1537d(0x124)]||[];while(_0x3289ac--){if('ojhhm'!==_0xe1537d(0x28b)){if(BattleManager[_0xe1537d(0x4d4)][_0xe1537d(0x124)][_0xe1537d(0x19c)]<=0x0)break;BattleManager[_0xe1537d(0x4d4)][_0xe1537d(0x124)][_0xe1537d(0x287)]();}else{if(this[_0xe1537d(0x4ec)]())_0x17ba1c[_0xe1537d(0x8a9)][_0xe1537d(0x2b7)][_0xe1537d(0x9b5)](this);}}}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x70a),_0x5c1964=>{const _0x5d3a6e=_0xa8cad7;if(!SceneManager[_0x5d3a6e(0x45f)]())return;if(!Imported['VisuMZ_2_WeaponSwapSystem'])return;VisuMZ[_0x5d3a6e(0x17f)](_0x5c1964,_0x5c1964);const _0x81b60d=VisuMZ['CreateActionSequenceTargets'](_0x5c1964['Targets']),_0x5ab362=_0x5c1964[_0x5d3a6e(0x9ff)];for(const _0x4a7a48 of _0x81b60d){if('nTMNV'!==_0x5d3a6e(0x98f)){if(!_0x4a7a48)continue;if(!_0x4a7a48[_0x5d3a6e(0x902)]())continue;_0x4a7a48[_0x5d3a6e(0x730)](_0x5ab362);}else _0x9d0589[_0x5d3a6e(0x8a9)]['Sprite_Weapon_loadBitmap'][_0x5d3a6e(0x9b5)](this),this['bitmap']&&(this[_0x5d3a6e(0x379)][_0x5d3a6e(0xb20)]=_0x378212[_0x5d3a6e(0x8a9)][_0x5d3a6e(0xb57)][_0x5d3a6e(0x3d8)][_0x5d3a6e(0x115)]);}}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Mechanics_TextPopup',_0x2b8c81=>{const _0x42dcb7=_0xa8cad7;if(!SceneManager[_0x42dcb7(0x45f)]())return;VisuMZ[_0x42dcb7(0x17f)](_0x2b8c81,_0x2b8c81);const _0x5ae84e=VisuMZ[_0x42dcb7(0x449)](_0x2b8c81['Targets']),_0x18ecab=_0x2b8c81[_0x42dcb7(0x71c)],_0x5a5ebd={'textColor':ColorManager[_0x42dcb7(0x7ff)](_0x2b8c81[_0x42dcb7(0xafd)]),'flashColor':_0x2b8c81['FlashColor'],'flashDuration':_0x2b8c81[_0x42dcb7(0x16a)]};for(const _0x489efe of _0x5ae84e){if(!_0x489efe)continue;_0x489efe[_0x42dcb7(0x6d2)](_0x18ecab,_0x5a5ebd);}}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x544),_0x226d69=>{const _0x49d7fe=_0xa8cad7;if(!SceneManager[_0x49d7fe(0x45f)]())return;VisuMZ[_0x49d7fe(0x17f)](_0x226d69,_0x226d69);const _0x45688a=VisuMZ[_0x49d7fe(0x449)](_0x226d69[_0x49d7fe(0x171)]);let _0xaa7232=$gameVariables['value'](_0x226d69[_0x49d7fe(0x693)]);Imported[_0x49d7fe(0x8a4)]&&_0x226d69['DigitGrouping']&&(_0xaa7232=VisuMZ[_0x49d7fe(0x179)](_0xaa7232));const _0x1ee54b=String(_0xaa7232),_0x5e59b6={'textColor':ColorManager[_0x49d7fe(0x7ff)](_0x226d69['TextColor']),'flashColor':_0x226d69['FlashColor'],'flashDuration':_0x226d69[_0x49d7fe(0x16a)]};for(const _0x174b0e of _0x45688a){if(!_0x174b0e)continue;_0x174b0e[_0x49d7fe(0x6d2)](_0x1ee54b,_0x5e59b6);}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x7cb),_0x5c93ee=>{const _0x7fe5fc=_0xa8cad7;if(!SceneManager[_0x7fe5fc(0x45f)]())return;const _0xf03d31=$gameTemp[_0x7fe5fc(0x933)]();if(!_0xf03d31)return;_0xf03d31[_0x7fe5fc(0x1e7)]('battleEffect');}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x79a),_0x3f3e1a=>{const _0x13c315=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x3f3e1a,_0x3f3e1a);const _0x9fca67=VisuMZ[_0x13c315(0x449)](_0x3f3e1a[_0x13c315(0x171)]);for(const _0x190843 of _0x9fca67){if('CeEBw'===_0x13c315(0x208)){if(!_0x190843)continue;_0x190843[_0x13c315(0x23c)]();}else _0x438d21[_0x13c315(0xa60)]['update'][_0x13c315(0x9b5)](this),this['enemy']()&&this[_0x13c315(0xac4)]()[_0x13c315(0x9a6)]()!==this[_0x13c315(0x530)]&&(this[_0x13c315(0x530)]=this['enemy']()['name'](),this[_0x13c315(0x8ff)]()),this[_0x13c315(0xae2)](),this[_0x13c315(0x14e)]();}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x5c9),_0x346ff8=>{const _0xb6fbeb=_0xa8cad7;if(!SceneManager[_0xb6fbeb(0x45f)]())return;VisuMZ[_0xb6fbeb(0x17f)](_0x346ff8,_0x346ff8);const _0x4df945=VisuMZ[_0xb6fbeb(0x449)](_0x346ff8[_0xb6fbeb(0x171)]),_0x27e147=_0x346ff8[_0xb6fbeb(0x727)][_0xb6fbeb(0x341)]()[_0xb6fbeb(0xb45)]();let _0x5d5989=_0x346ff8['ShowWeapon'];const _0x188d8c=_0x346ff8[_0xb6fbeb(0x476)];if(![_0xb6fbeb(0x995),_0xb6fbeb(0x5ca),_0xb6fbeb(0x918),_0xb6fbeb(0xb79)][_0xb6fbeb(0x220)](_0x27e147)){if(_0xb6fbeb(0x59b)!==_0xb6fbeb(0x59b)){const _0xac493c=this['battler']();_0xac493c&&(_0xac493c[_0xb6fbeb(0xa46)](_0x304488),[_0xb6fbeb(0x918),_0xb6fbeb(0x5ca),_0xb6fbeb(0xb79)][_0xb6fbeb(0x220)](_0x1c2078)&&this['performWeaponAnimation']());}else _0x5d5989=![];}for(const _0x13cc6a of _0x4df945){if(!_0x13cc6a)continue;_0x13cc6a['freezeMotion'](_0x27e147,_0x5d5989,_0x188d8c);}}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x32d),_0x303df9=>{const _0x5ed8e5=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x5ed8e5(0x17f)](_0x303df9,_0x303df9);const _0x40bbb7=VisuMZ[_0x5ed8e5(0x449)](_0x303df9[_0x5ed8e5(0x171)]),_0x3b64f8=_0x303df9[_0x5ed8e5(0x727)][_0x5ed8e5(0x341)]()[_0x5ed8e5(0xb45)](),_0x485c4d=_0x303df9['ShowWeapon'];for(const _0x19cb5f of _0x40bbb7){if(!_0x19cb5f)continue;if(_0x3b64f8['match'](/ATTACK[ ](\d+)/i))_0x19cb5f[_0x5ed8e5(0x97d)](Number(RegExp['$1']));else _0x3b64f8===_0x5ed8e5(0x995)?'YCezM'!==_0x5ed8e5(0x898)?(this[_0x5ed8e5(0x116)](),_0x339619[_0x5ed8e5(0x8a9)][_0x5ed8e5(0xa88)]['call'](this)):_0x19cb5f['performAttack']():_0x5ed8e5(0x3d6)==='Rfmfo'?_0x19cb5f[_0x5ed8e5(0x300)](_0x3b64f8):(this[_0x5ed8e5(0x75f)](_0x5ed8e5(0x7e4)),_0x4b7a06['_spriteset'][_0x5ed8e5(0x9c0)](),_0x2f3ccc[_0x5ed8e5(0x8a9)][_0x5ed8e5(0x686)][_0x5ed8e5(0x9b5)](this),this['processPostBattleCommonEvents'](_0x5ed8e5(0x92f)));if(!_0x485c4d)_0x19cb5f[_0x5ed8e5(0x3b8)](0x0);else{if(_0x485c4d&&['thrust',_0x5ed8e5(0x918),'missle'][_0x5ed8e5(0x220)](_0x3b64f8)){}}}}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Motion_PerformAction',_0xa789a7=>{const _0x38ecc1=_0xa8cad7;if(!SceneManager[_0x38ecc1(0x45f)]())return;VisuMZ[_0x38ecc1(0x17f)](_0xa789a7,_0xa789a7);const _0x34851e=BattleManager[_0x38ecc1(0x95a)];if(!_0x34851e)return;if(!_0x34851e['item']())return;const _0x513998=VisuMZ['CreateActionSequenceTargets'](_0xa789a7['Targets']);for(const _0x5ea4ca of _0x513998){if(!_0x5ea4ca)continue;_0x5ea4ca[_0x38ecc1(0x1d7)](_0x34851e);}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x36f),_0x45f142=>{const _0x55387b=_0xa8cad7;if(!SceneManager[_0x55387b(0x45f)]())return;VisuMZ[_0x55387b(0x17f)](_0x45f142,_0x45f142);const _0x14d099=VisuMZ[_0x55387b(0x449)](_0x45f142[_0x55387b(0x171)]);for(const _0x4e32f4 of _0x14d099){if(!_0x4e32f4)continue;if(!_0x4e32f4[_0x55387b(0xac0)]())continue;_0x4e32f4[_0x55387b(0xac0)]()[_0x55387b(0x117)]();}}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x670),_0x22db5f=>{const _0x55e532=_0xa8cad7;if(!SceneManager[_0x55e532(0x45f)]())return;VisuMZ['ConvertParams'](_0x22db5f,_0x22db5f);const _0x1508c0=$gameTemp[_0x55e532(0x933)](),_0x4b62d9=_0x22db5f[_0x55e532(0x675)]*Sprite_Battler[_0x55e532(0x837)];_0x1508c0['wait'](_0x4b62d9);}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Movement_BattleStep',_0x48fa13=>{const _0x1e1fa4=_0xa8cad7;if(!SceneManager[_0x1e1fa4(0x45f)]())return;VisuMZ['ConvertParams'](_0x48fa13,_0x48fa13);const _0x1def2f=$gameTemp[_0x1e1fa4(0x933)](),_0x4ac601=BattleManager[_0x1e1fa4(0x95a)];if(!_0x1def2f||!_0x4ac601)return;if(!_0x4ac601[_0x1e1fa4(0x191)]())return;const _0x2eaea1=VisuMZ[_0x1e1fa4(0x449)](_0x48fa13[_0x1e1fa4(0x171)]);for(const _0x52d4c4 of _0x2eaea1){if(!_0x52d4c4)continue;_0x52d4c4[_0x1e1fa4(0x6d3)](_0x4ac601);}if(_0x48fa13[_0x1e1fa4(0x46c)])_0x1def2f[_0x1e1fa4(0x1e7)](_0x1e1fa4(0xadc));}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x878),_0x28607b=>{const _0x56dc5b=_0xa8cad7;if(!SceneManager[_0x56dc5b(0x45f)]())return;if(!$gameSystem[_0x56dc5b(0x1d3)]())return;VisuMZ[_0x56dc5b(0x17f)](_0x28607b,_0x28607b);const _0x1d000c=$gameTemp[_0x56dc5b(0x933)](),_0x323395=VisuMZ[_0x56dc5b(0x449)](_0x28607b['Targets']),_0x544bd5=_0x28607b[_0x56dc5b(0x4ca)],_0xa655c9=_0x28607b['DistanceX'],_0x36ab5a=_0x28607b[_0x56dc5b(0x847)],_0x340381=_0x28607b[_0x56dc5b(0x37b)],_0x4261ee=_0x28607b['FaceDirection'],_0x3fe871=_0x28607b['EasingType'],_0x28127b=_0x28607b[_0x56dc5b(0x727)],_0x542514=_0x28607b['WaitForMovement'];if(!_0x1d000c)return;for(const _0x323bd1 of _0x323395){if(_0x56dc5b(0x63d)!==_0x56dc5b(0x63d)){if(this[_0x56dc5b(0x60c)]>0x0)this[_0x56dc5b(0x60c)]-=0x10;}else{if(!_0x323bd1)continue;let _0x41e6c0=_0xa655c9,_0x5a5b55=_0x36ab5a;if(_0x544bd5[_0x56dc5b(0x21d)](/horz/i))_0x41e6c0*=_0x323bd1[_0x56dc5b(0x902)]()?-0x1:0x1;if(_0x544bd5['match'](/vert/i))_0x5a5b55*=_0x323bd1[_0x56dc5b(0x902)]()?-0x1:0x1;_0x323bd1['moveBattlerHomeDistance'](_0x41e6c0,_0x5a5b55,_0x340381,_0x4261ee,_0x3fe871),_0x323bd1[_0x56dc5b(0x300)](_0x28127b);}}if(_0x542514)_0x1d000c[_0x56dc5b(0x1e7)]('battleMove');}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x28c),_0x341af0=>{const _0x4c3eb2=_0xa8cad7;if(!SceneManager[_0x4c3eb2(0x45f)]())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x4c3eb2(0x17f)](_0x341af0,_0x341af0);const _0x1f8a44=$gameTemp[_0x4c3eb2(0x933)](),_0x2374eb=VisuMZ[_0x4c3eb2(0x449)](_0x341af0['Targets']),_0x37d07b=_0x341af0['Destination'],_0x44df29=_0x341af0[_0x4c3eb2(0x8b6)],_0x224e7c=_0x341af0[_0x4c3eb2(0x131)],_0x48c4af=_0x341af0[_0x4c3eb2(0x944)],_0x1e4088=_0x341af0[_0x4c3eb2(0x37b)],_0x230a19=_0x341af0[_0x4c3eb2(0x302)],_0x28aa99=_0x341af0[_0x4c3eb2(0xabf)],_0x269854=_0x341af0['MotionType'],_0x2d45b9=_0x341af0[_0x4c3eb2(0x46c)];if(!_0x1f8a44)return;for(const _0x4e7930 of _0x2374eb){if(!_0x4e7930)continue;let _0x3fe282=_0x4e7930[_0x4c3eb2(0xac0)]()[_0x4c3eb2(0x7c5)],_0x34641c=_0x4e7930[_0x4c3eb2(0xac0)]()[_0x4c3eb2(0x98c)];if(_0x37d07b[_0x4c3eb2(0x21d)](/home/i))_0x3fe282=_0x4e7930[_0x4c3eb2(0xac0)]()[_0x4c3eb2(0xab8)],_0x34641c=_0x4e7930[_0x4c3eb2(0xac0)]()[_0x4c3eb2(0x4e0)];else{if(_0x37d07b[_0x4c3eb2(0x21d)](/center/i))_0x3fe282=Graphics[_0x4c3eb2(0x719)]/0x2,_0x34641c=Graphics[_0x4c3eb2(0x9ef)]/0x2;else _0x37d07b[_0x4c3eb2(0x21d)](/point (\d+), (\d+)/i)&&(_0x3fe282=Number(RegExp['$1']),_0x34641c=Number(RegExp['$2']));}if(_0x44df29[_0x4c3eb2(0x21d)](/none/i))_0x3fe282+=_0x224e7c,_0x34641c+=_0x48c4af;else{if(_0x44df29['match'](/horz/i)&&_0x44df29[_0x4c3eb2(0x21d)](/vert/i))'MINsT'===_0x4c3eb2(0x5d7)?(_0x3fe282+=_0x4e7930[_0x4c3eb2(0x902)]()?-_0x224e7c:_0x224e7c,_0x34641c+=_0x4e7930[_0x4c3eb2(0x902)]()?-_0x48c4af:_0x48c4af):this['requestMotion'](_0x4c3eb2(0x8de));else{if(_0x44df29[_0x4c3eb2(0x21d)](/horz/i))_0x3fe282+=_0x4e7930[_0x4c3eb2(0x902)]()?-_0x224e7c:_0x224e7c,_0x34641c+=_0x48c4af;else _0x44df29[_0x4c3eb2(0x21d)](/vert/i)&&(_0x3fe282+=_0x224e7c,_0x34641c+=_0x4e7930[_0x4c3eb2(0x902)]()?-_0x48c4af:_0x48c4af);}}_0x4e7930[_0x4c3eb2(0x3ed)](_0x3fe282,_0x34641c,_0x1e4088,_0x230a19,_0x28aa99,-0x1),_0x4e7930[_0x4c3eb2(0x300)](_0x269854);}if(_0x2d45b9)_0x1f8a44[_0x4c3eb2(0x1e7)](_0x4c3eb2(0xadc));}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x11e),_0x4d8f03=>{const _0x3cea67=_0xa8cad7;if(!SceneManager[_0x3cea67(0x45f)]())return;if(!$gameSystem[_0x3cea67(0x1d3)]())return;VisuMZ[_0x3cea67(0x17f)](_0x4d8f03,_0x4d8f03);const _0x2a2628=$gameTemp[_0x3cea67(0x933)](),_0x483f83=VisuMZ[_0x3cea67(0x449)](_0x4d8f03[_0x3cea67(0xa9f)]),_0x16eeca=VisuMZ[_0x3cea67(0x449)](_0x4d8f03['Targets2']),_0x55197e=_0x4d8f03['TargetLocation'];let _0x6b1e63=_0x4d8f03[_0x3cea67(0x8fb)];const _0x499227=_0x4d8f03[_0x3cea67(0x8b6)],_0xc9720b=_0x4d8f03['OffsetX'],_0xff2964=_0x4d8f03[_0x3cea67(0x944)],_0x5ecb74=_0x4d8f03[_0x3cea67(0x37b)],_0x176c36=_0x4d8f03[_0x3cea67(0x302)],_0x562d1a=_0x4d8f03[_0x3cea67(0xabf)],_0x463f1c=_0x4d8f03[_0x3cea67(0x727)],_0x2c4cb2=_0x4d8f03[_0x3cea67(0x46c)],_0x4e7744=Math[_0x3cea67(0x5b1)](..._0x16eeca['map'](_0x4f01c4=>_0x4f01c4['battler']()[_0x3cea67(0x7c5)]-_0x4f01c4[_0x3cea67(0xac0)]()[_0x3cea67(0x8da)]()/0x2)),_0x4d0c8a=Math[_0x3cea67(0x743)](..._0x16eeca['map'](_0x499dc8=>_0x499dc8[_0x3cea67(0xac0)]()[_0x3cea67(0x7c5)]+_0x499dc8['battler']()[_0x3cea67(0x8da)]()/0x2)),_0x31c642=Math['min'](..._0x16eeca['map'](_0x3837db=>_0x3837db[_0x3cea67(0xac0)]()[_0x3cea67(0x98c)]-_0x3837db[_0x3cea67(0xac0)]()[_0x3cea67(0x3ae)]())),_0x13984f=Math[_0x3cea67(0x743)](..._0x16eeca['map'](_0x3c0a96=>_0x3c0a96[_0x3cea67(0xac0)]()['_baseY'])),_0x1c8480=_0x16eeca[_0x3cea67(0x1d2)](_0x310e89=>_0x310e89[_0x3cea67(0x902)]())[_0x3cea67(0x19c)],_0x3cad69=_0x16eeca[_0x3cea67(0x1d2)](_0x462f63=>_0x462f63[_0x3cea67(0x31f)]())[_0x3cea67(0x19c)];let _0x4713d3=0x0,_0x5c786c=0x0;if(_0x55197e[_0x3cea67(0x21d)](/front/i))_0x4713d3=_0x1c8480>=_0x3cad69?_0x4e7744:_0x4d0c8a;else{if(_0x55197e[_0x3cea67(0x21d)](/middle/i)){if(_0x3cea67(0x24c)!==_0x3cea67(0x24c)){if(!this[_0x3cea67(0x191)]()['damage'][_0x3cea67(0x8cf)])return 0x0;let _0x50bce6=_0x5492ae[_0x3cea67(0x8a9)][_0x3cea67(0xb57)][_0x3cea67(0x741)][_0x3cea67(0xa87)][_0x3cea67(0x9b5)](this,_0x5a6fab);return _0x50bce6=this[_0x3cea67(0x9f4)][_0x3cea67(0xb47)]*_0x50bce6+this[_0x3cea67(0x9f4)][_0x3cea67(0x994)],_0x50bce6;}else _0x4713d3=(_0x4e7744+_0x4d0c8a)/0x2,_0x6b1e63=-0x1;}else{if(_0x55197e[_0x3cea67(0x21d)](/back/i)){if(_0x3cea67(0x83e)===_0x3cea67(0x5fc)){const _0x36031d=this[_0x3cea67(0x1cc)]();['xp',_0x3cea67(0x33b),_0x3cea67(0xb48)][_0x3cea67(0x220)](_0x36031d)&&this[_0x3cea67(0x9e9)]['open'](),this[_0x3cea67(0x934)]();}else _0x4713d3=_0x1c8480>=_0x3cad69?_0x4d0c8a:_0x4e7744;}}}if(_0x55197e[_0x3cea67(0x21d)](/head/i))_0x5c786c=_0x31c642;else{if(_0x55197e[_0x3cea67(0x21d)](/center/i))_0x5c786c=(_0x31c642+_0x13984f)/0x2;else _0x55197e[_0x3cea67(0x21d)](/base/i)&&('TgtzX'===_0x3cea67(0x712)?_0x5c786c=_0x13984f:_0x8cdf33=(_0x3ec2fa+_0xa48112)/0x2);}if(!_0x2a2628)return;for(const _0x16c9c2 of _0x483f83){if(!_0x16c9c2)continue;let _0x3e084f=_0x4713d3,_0x2c7726=_0x5c786c;if(_0x499227['match'](/none/i))_0x3e084f+=_0xc9720b,_0x2c7726+=_0xff2964;else{if(_0x499227[_0x3cea67(0x21d)](/horz/i)&&_0x499227[_0x3cea67(0x21d)](/vert/i))_0x3e084f+=_0x16c9c2[_0x3cea67(0x902)]()?-_0xc9720b:_0xc9720b,_0x2c7726+=_0x16c9c2[_0x3cea67(0x902)]()?-_0xff2964:_0xff2964;else{if(_0x499227['match'](/horz/i))_0x3e084f+=_0x16c9c2['isActor']()?-_0xc9720b:_0xc9720b,_0x2c7726+=_0xff2964;else _0x499227[_0x3cea67(0x21d)](/vert/i)&&(_0x3e084f+=_0xc9720b,_0x2c7726+=_0x16c9c2[_0x3cea67(0x902)]()?-_0xff2964:_0xff2964);}}_0x16c9c2[_0x3cea67(0x3ed)](_0x3e084f,_0x2c7726,_0x5ecb74,_0x176c36,_0x562d1a,_0x6b1e63),_0x16c9c2[_0x3cea67(0x300)](_0x463f1c);}if(_0x2c4cb2)_0x2a2628[_0x3cea67(0x1e7)](_0x3cea67(0xadc));}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x2f2),_0x17fecc=>{const _0x1b06cb=_0xa8cad7;if(!SceneManager[_0x1b06cb(0x45f)]())return;if(!$gameSystem[_0x1b06cb(0x1d3)]())return;VisuMZ[_0x1b06cb(0x17f)](_0x17fecc,_0x17fecc);const _0x371ea7=VisuMZ[_0x1b06cb(0x449)](_0x17fecc[_0x1b06cb(0x171)]);let _0x348f77=_0x17fecc[_0x1b06cb(0x5b3)][_0x1b06cb(0x21d)](/back/i);for(const _0x2dfccb of _0x371ea7){if('duzqE'==='dbPTO'){if(_0xed4703[_0x1b06cb(0xb41)]&&!_0x2fa2c3[_0x1b06cb(0x38d)])return this[_0x1b06cb(0x429)]();else{return _0x3da2f2['BattleCore'][_0x1b06cb(0xb90)][_0x1b06cb(0x9b5)](this);;}}else{if(!_0x2dfccb)continue;if(_0x17fecc[_0x1b06cb(0x5b3)][_0x1b06cb(0x21d)](/rand/i))_0x348f77=Math['randomInt'](0x2);_0x2dfccb[_0x1b06cb(0x7a0)](!!_0x348f77);}}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x402),_0x2427a1=>{const _0x3b4328=_0xa8cad7;if(!SceneManager[_0x3b4328(0x45f)]())return;if(!$gameSystem[_0x3b4328(0x1d3)]())return;VisuMZ[_0x3b4328(0x17f)](_0x2427a1,_0x2427a1);const _0x4beaed=VisuMZ[_0x3b4328(0x449)](_0x2427a1['Targets']);let _0x584485=_0x2427a1[_0x3b4328(0x62e)];const _0x5d5cd0=_0x2427a1[_0x3b4328(0x590)];for(const _0x7b4396 of _0x4beaed){if(!_0x7b4396)continue;let _0x916398=_0x7b4396[_0x3b4328(0xac0)]()[_0x3b4328(0x7c5)],_0x428421=_0x7b4396[_0x3b4328(0xac0)]()[_0x3b4328(0x98c)];if(_0x584485[_0x3b4328(0x21d)](/home/i))_0x916398=_0x7b4396[_0x3b4328(0xac0)]()[_0x3b4328(0xab8)],_0x428421=_0x7b4396['battler']()[_0x3b4328(0x4e0)];else{if(_0x584485[_0x3b4328(0x21d)](/center/i))_0x3b4328(0x603)==='dPavD'?(_0x916398=Graphics['boxWidth']/0x2,_0x428421=Graphics[_0x3b4328(0x9ef)]/0x2):(_0x5963bc+=_0x3ef84d[_0x3b4328(0x902)]()?-_0x5742c9:_0x1e1656,_0x33961f+=_0x2b43f5[_0x3b4328(0x902)]()?-_0x236e4b:_0xfeee38);else _0x584485[_0x3b4328(0x21d)](/point (\d+), (\d+)/i)&&(_0x916398=Number(RegExp['$1']),_0x428421=Number(RegExp['$2']));}_0x7b4396[_0x3b4328(0x6f3)](Math[_0x3b4328(0x2cb)](_0x916398),Math[_0x3b4328(0x2cb)](_0x428421),!!_0x5d5cd0);}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x5e9),_0x1b2045=>{const _0x1e33ec=_0xa8cad7;if(!SceneManager[_0x1e33ec(0x45f)]())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x1e33ec(0x17f)](_0x1b2045,_0x1b2045);const _0x33aa45=VisuMZ[_0x1e33ec(0x449)](_0x1b2045[_0x1e33ec(0xa9f)]),_0x58cd84=VisuMZ[_0x1e33ec(0x449)](_0x1b2045['Targets2']),_0x1edcb9=_0x58cd84[_0x1e33ec(0x369)](_0x5dbc48=>_0x5dbc48&&_0x5dbc48[_0x1e33ec(0xac0)]()?_0x5dbc48[_0x1e33ec(0xac0)]()[_0x1e33ec(0x7c5)]:0x0)/(_0x58cd84['length']||0x1),_0x5bee3e=_0x58cd84['map'](_0x377c53=>_0x377c53&&_0x377c53[_0x1e33ec(0xac0)]()?_0x377c53['battler']()['_baseY']:0x0)/(_0x58cd84['length']||0x1),_0x4063e1=_0x1b2045['FaceAway'];for(const _0x387c82 of _0x33aa45){if(!_0x387c82)continue;_0x387c82['setBattlerFacePoint'](Math['round'](_0x1edcb9),Math['round'](_0x5bee3e),!!_0x4063e1);}}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x2b0),_0x20ff42=>{const _0x30debd=_0xa8cad7;if(!SceneManager[_0x30debd(0x45f)]())return;VisuMZ[_0x30debd(0x17f)](_0x20ff42,_0x20ff42);const _0x2c9ba9=$gameTemp[_0x30debd(0x933)](),_0x180f6d=VisuMZ[_0x30debd(0x449)](_0x20ff42[_0x30debd(0x171)]),_0x2cfb57=_0x20ff42['Height'],_0x183538=_0x20ff42[_0x30debd(0x37b)],_0x29b133=_0x20ff42['EasingType'],_0x5c18db=_0x20ff42['WaitForFloat'];if(!_0x2c9ba9)return;for(const _0x22b2b1 of _0x180f6d){if(!_0x22b2b1)continue;_0x22b2b1['floatBattler'](_0x2cfb57,_0x183538,_0x29b133);}if(_0x5c18db)_0x2c9ba9[_0x30debd(0x1e7)](_0x30debd(0x436));}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],'ActSeq_Movement_HomeReset',_0x440ed2=>{const _0x1969eb=_0xa8cad7;if(!SceneManager[_0x1969eb(0x45f)]())return;VisuMZ['ConvertParams'](_0x440ed2,_0x440ed2);const _0x2ab133=$gameTemp[_0x1969eb(0x933)]();if(!_0x2ab133)return;const _0x30e256=VisuMZ['CreateActionSequenceTargets'](_0x440ed2[_0x1969eb(0x171)]);for(const _0x2061ac of _0x30e256){if(_0x1969eb(0x54e)===_0x1969eb(0x54e)){if(!_0x2061ac)continue;_0x2061ac[_0x1969eb(0x428)]();}else _0x3676a1['_scene']['_statusWindow'][_0x1969eb(0x57c)](_0x417f9f,this[_0x1969eb(0x959)]);}if(BattleManager[_0x1969eb(0x4d4)]){if(_0x1969eb(0x562)!==_0x1969eb(0xaed))BattleManager['_subject'][_0x1969eb(0xb3e)]();else{const _0x27402b=this[_0x1969eb(0x4d4)][_0x1969eb(0xae6)](),_0x4a3025=this['_subject'];_0x27402b&&_0x27402b[_0x1969eb(0x222)]()===_0x4a3025&&_0x27402b[_0x1969eb(0xa95)](_0x1969eb(0x979)),_0x3ccc2d[_0x1969eb(0x8a9)][_0x1969eb(0xab6)]['call'](this),_0x27402b&&_0x27402b[_0x1969eb(0x222)]()===_0x4a3025&&_0x27402b[_0x1969eb(0xa95)]('PostStartActionJS');}}if(_0x440ed2['WaitForMovement'])_0x2ab133[_0x1969eb(0x1e7)](_0x1969eb(0xadc));}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x67f),_0x53ba47=>{const _0x734257=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x53ba47,_0x53ba47);const _0xbf49a4=$gameTemp[_0x734257(0x933)](),_0x2d89e4=VisuMZ['CreateActionSequenceTargets'](_0x53ba47[_0x734257(0x171)]),_0x3af656=_0x53ba47[_0x734257(0xa47)],_0x25f8a3=_0x53ba47[_0x734257(0x37b)],_0x4283d5=_0x53ba47[_0x734257(0xa7b)];if(!_0xbf49a4)return;for(const _0x2b5dd4 of _0x2d89e4){if(_0x734257(0xadd)!==_0x734257(0x636)){if(!_0x2b5dd4)continue;_0x2b5dd4['jumpBattler'](_0x3af656,_0x25f8a3);}else this[_0x734257(0x389)]();}if(_0x4283d5)_0xbf49a4[_0x734257(0x1e7)](_0x734257(0x3ee));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Movement_MoveBy',_0x5edbf2=>{const _0x4ec4c5=_0xa8cad7;if(!SceneManager[_0x4ec4c5(0x45f)]())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x4ec4c5(0x17f)](_0x5edbf2,_0x5edbf2);const _0x16d680=$gameTemp[_0x4ec4c5(0x933)](),_0x1607b5=VisuMZ['CreateActionSequenceTargets'](_0x5edbf2['Targets']),_0x76f9e=_0x5edbf2[_0x4ec4c5(0x4ca)],_0x4492b7=_0x5edbf2['DistanceX'],_0x5830bb=_0x5edbf2[_0x4ec4c5(0x847)],_0x401379=_0x5edbf2[_0x4ec4c5(0x37b)],_0x466699=_0x5edbf2[_0x4ec4c5(0x302)],_0x254e7b=_0x5edbf2[_0x4ec4c5(0xabf)],_0x4cb1e3=_0x5edbf2[_0x4ec4c5(0x727)],_0x5d0c5e=_0x5edbf2['WaitForMovement'];if(!_0x16d680)return;for(const _0x32c46b of _0x1607b5){if(_0x4ec4c5(0x2f3)!==_0x4ec4c5(0x2f3))_0x23feb1[_0x4ec4c5(0x8a9)]['Sprite_Actor_update'][_0x4ec4c5(0x9b5)](this),this[_0x4ec4c5(0xa48)]&&(this[_0x4ec4c5(0x92b)](),this['updateStyleOpacity']());else{if(!_0x32c46b)continue;let _0x4c2068=_0x4492b7,_0x53a756=_0x5830bb;if(_0x76f9e[_0x4ec4c5(0x21d)](/horz/i))_0x4c2068*=_0x32c46b['isActor']()?-0x1:0x1;if(_0x76f9e[_0x4ec4c5(0x21d)](/vert/i))_0x53a756*=_0x32c46b['isActor']()?-0x1:0x1;_0x32c46b[_0x4ec4c5(0x75b)](_0x4c2068,_0x53a756,_0x401379,_0x466699,_0x254e7b),_0x32c46b[_0x4ec4c5(0x300)](_0x4cb1e3);}}if(_0x5d0c5e)_0x16d680[_0x4ec4c5(0x1e7)](_0x4ec4c5(0xadc));}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x2e2),_0x25e503=>{const _0x5645e7=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x5645e7(0x17f)](_0x25e503,_0x25e503);const _0x263bbb=$gameTemp[_0x5645e7(0x933)](),_0x1116b1=VisuMZ['CreateActionSequenceTargets'](_0x25e503[_0x5645e7(0x171)]),_0x103ea2=_0x25e503[_0x5645e7(0x750)],_0xfefcfb=_0x25e503[_0x5645e7(0x8b6)],_0x224940=_0x25e503[_0x5645e7(0x131)],_0x5baf77=_0x25e503[_0x5645e7(0x944)],_0x4fa942=_0x25e503[_0x5645e7(0x37b)],_0x5d5918=_0x25e503[_0x5645e7(0x302)],_0xe4b60e=_0x25e503[_0x5645e7(0xabf)],_0x594e4b=_0x25e503[_0x5645e7(0x727)],_0x44c927=_0x25e503[_0x5645e7(0x46c)];if(!_0x263bbb)return;for(const _0x1d1ca7 of _0x1116b1){if(!_0x1d1ca7)continue;let _0x4ad262=_0x1d1ca7['battler']()[_0x5645e7(0x7c5)],_0x22fbf8=_0x1d1ca7[_0x5645e7(0xac0)]()[_0x5645e7(0x98c)];if(_0x103ea2[_0x5645e7(0x21d)](/home/i)){if(_0x5645e7(0xb2f)==='yPydl')_0x4ad262=_0x1d1ca7[_0x5645e7(0xac0)]()[_0x5645e7(0xab8)],_0x22fbf8=_0x1d1ca7['battler']()['_homeY'];else return _0x1a8f76[_0x5645e7(0x8a9)]['Settings'][_0x5645e7(0x327)][_0x5645e7(0xa92)];}else{if(_0x103ea2[_0x5645e7(0x21d)](/center/i))_0x4ad262=Graphics[_0x5645e7(0x719)]/0x2,_0x22fbf8=Graphics[_0x5645e7(0x9ef)]/0x2;else _0x103ea2[_0x5645e7(0x21d)](/point (\d+), (\d+)/i)&&(_0x4ad262=Number(RegExp['$1']),_0x22fbf8=Number(RegExp['$2']));}if(_0xfefcfb[_0x5645e7(0x21d)](/none/i))_0x4ad262+=_0x224940,_0x22fbf8+=_0x5baf77;else{if(_0xfefcfb['match'](/horz/i)&&_0xfefcfb[_0x5645e7(0x21d)](/vert/i))_0x5645e7(0xaa3)==='Dnzvl'?(_0x4ad262+=_0x1d1ca7[_0x5645e7(0x902)]()?-_0x224940:_0x224940,_0x22fbf8+=_0x1d1ca7[_0x5645e7(0x902)]()?-_0x5baf77:_0x5baf77):this['drawGauge']();else{if(_0xfefcfb[_0x5645e7(0x21d)](/horz/i)){if(_0x5645e7(0x3af)!=='DFxNB'){if(!this[_0x5645e7(0x815)]()&&this!==_0x52057d[_0x5645e7(0x4d4)]){if(this[_0x5645e7(0xac0)]())this[_0x5645e7(0xac0)]()[_0x5645e7(0x117)]();}this[_0x5645e7(0x23c)]();return;}else _0x4ad262+=_0x1d1ca7['isActor']()?-_0x224940:_0x224940,_0x22fbf8+=_0x5baf77;}else _0xfefcfb[_0x5645e7(0x21d)](/vert/i)&&(_0x4ad262+=_0x224940,_0x22fbf8+=_0x1d1ca7[_0x5645e7(0x902)]()?-_0x5baf77:_0x5baf77);}}_0x1d1ca7[_0x5645e7(0xb81)](_0x4ad262,_0x22fbf8,_0x4fa942,_0x5d5918,_0xe4b60e,-0x1),_0x1d1ca7['requestMotion'](_0x594e4b);}if(_0x44c927)_0x263bbb[_0x5645e7(0x1e7)](_0x5645e7(0xadc));}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],'ActSeq_Movement_MoveToTarget',_0x3e3fbc=>{const _0x4e50f4=_0xa8cad7;if(!SceneManager[_0x4e50f4(0x45f)]())return;if(!$gameSystem[_0x4e50f4(0x1d3)]())return;VisuMZ['ConvertParams'](_0x3e3fbc,_0x3e3fbc);const _0x17e22b=$gameTemp[_0x4e50f4(0x933)](),_0x327749=VisuMZ[_0x4e50f4(0x449)](_0x3e3fbc[_0x4e50f4(0xa9f)]),_0x1697e8=VisuMZ['CreateActionSequenceTargets'](_0x3e3fbc['Targets2']),_0xf235ca=_0x3e3fbc[_0x4e50f4(0x427)];let _0x3ee0dd=_0x3e3fbc['MeleeDistance'];const _0x336539=_0x3e3fbc[_0x4e50f4(0x8b6)],_0xe4f1be=_0x3e3fbc[_0x4e50f4(0x131)],_0x45a22c=_0x3e3fbc[_0x4e50f4(0x944)],_0x5771c4=_0x3e3fbc[_0x4e50f4(0x37b)],_0x51bfb6=_0x3e3fbc[_0x4e50f4(0x302)],_0x2aadb3=_0x3e3fbc[_0x4e50f4(0xabf)],_0x33e73f=_0x3e3fbc[_0x4e50f4(0x727)],_0x3efc5a=_0x3e3fbc[_0x4e50f4(0x46c)],_0x4d27a8=Math[_0x4e50f4(0x5b1)](..._0x1697e8[_0x4e50f4(0x369)](_0x5d7ebe=>_0x5d7ebe[_0x4e50f4(0xac0)]()['_baseX']-_0x5d7ebe['battler']()[_0x4e50f4(0x8da)]()/0x2)),_0x15cca9=Math['max'](..._0x1697e8[_0x4e50f4(0x369)](_0x7c5006=>_0x7c5006[_0x4e50f4(0xac0)]()[_0x4e50f4(0x7c5)]+_0x7c5006['battler']()['mainSpriteWidth']()/0x2)),_0x55494a=Math[_0x4e50f4(0x5b1)](..._0x1697e8[_0x4e50f4(0x369)](_0x593df2=>_0x593df2['battler']()[_0x4e50f4(0x98c)]-_0x593df2[_0x4e50f4(0xac0)]()['mainSpriteHeight']())),_0x5b7039=Math['max'](..._0x1697e8[_0x4e50f4(0x369)](_0x8d6600=>_0x8d6600['battler']()[_0x4e50f4(0x98c)])),_0x3d1bd7=_0x1697e8['filter'](_0x4b0d59=>_0x4b0d59[_0x4e50f4(0x902)]())[_0x4e50f4(0x19c)],_0x3bd7f0=_0x1697e8[_0x4e50f4(0x1d2)](_0x41102e=>_0x41102e[_0x4e50f4(0x31f)]())[_0x4e50f4(0x19c)];let _0x49124f=0x0,_0x25fedd=0x0;if(_0xf235ca[_0x4e50f4(0x21d)](/front/i)){if(_0x4e50f4(0x23d)!==_0x4e50f4(0x197))_0x49124f=_0x3d1bd7>=_0x3bd7f0?_0x4d27a8:_0x15cca9;else{const _0x3cf3b6=_0x1102b6[_0x4e50f4(0x8a9)][_0x4e50f4(0xb57)][_0x4e50f4(0x8d5)];let _0x329438=![];_0x312433['isSideView']()?_0x329438=_0x3cf3b6[_0x4e50f4(0x1b0)]:_0x329438=_0x3cf3b6[_0x4e50f4(0x47f)],this[_0x4e50f4(0x5eb)](_0x329438?this['maxItems']()-0x1:0x0);}}else{if(_0xf235ca[_0x4e50f4(0x21d)](/middle/i))_0x4e50f4(0x639)!==_0x4e50f4(0x764)?(_0x49124f=(_0x4d27a8+_0x15cca9)/0x2,_0x3ee0dd=-0x1):_0xf921eb[_0x4e50f4(0xa95)](_0x4e50f4(0x979));else _0xf235ca['match'](/back/i)&&(_0x49124f=_0x3d1bd7>=_0x3bd7f0?_0x15cca9:_0x4d27a8);}if(_0xf235ca['match'](/head/i))_0x25fedd=_0x55494a;else{if(_0xf235ca['match'](/center/i)){if(_0x4e50f4(0x587)===_0x4e50f4(0xacf))return this[_0x4e50f4(0x418)]()[_0x4e50f4(0x9a6)]!=='';else _0x25fedd=(_0x55494a+_0x5b7039)/0x2;}else _0xf235ca[_0x4e50f4(0x21d)](/base/i)&&(_0x25fedd=_0x5b7039);}if(!_0x17e22b)return;for(const _0x1d96d5 of _0x327749){if(!_0x1d96d5)continue;let _0xe4d5a=_0x49124f,_0x5f26a1=_0x25fedd;if(_0x336539['match'](/none/i))'woaJP'===_0x4e50f4(0x5a0)?(_0xe4d5a+=_0xe4f1be,_0x5f26a1+=_0x45a22c):(this['unshift'](_0x4e50f4(0x8f6)),_0x3c3df9['invokeAction'](_0x417a94,_0x5a2056),this[_0x4e50f4(0xa8a)]());else{if(_0x336539['match'](/horz/i)&&_0x336539['match'](/vert/i))_0xe4d5a+=_0x1d96d5[_0x4e50f4(0x902)]()?-_0xe4f1be:_0xe4f1be,_0x5f26a1+=_0x1d96d5[_0x4e50f4(0x902)]()?-_0x45a22c:_0x45a22c;else{if(_0x336539[_0x4e50f4(0x21d)](/horz/i))_0xe4d5a+=_0x1d96d5[_0x4e50f4(0x902)]()?-_0xe4f1be:_0xe4f1be,_0x5f26a1+=_0x45a22c;else _0x336539[_0x4e50f4(0x21d)](/vert/i)&&(_0xe4d5a+=_0xe4f1be,_0x5f26a1+=_0x1d96d5[_0x4e50f4(0x902)]()?-_0x45a22c:_0x45a22c);}}_0x1d96d5['moveBattlerToPoint'](_0xe4d5a,_0x5f26a1,_0x5771c4,_0x51bfb6,_0x2aadb3,_0x3ee0dd),_0x1d96d5['requestMotion'](_0x33e73f);}if(_0x3efc5a)_0x17e22b[_0x4e50f4(0x1e7)]('battleMove');}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x233),_0x213826=>{const _0x599518=_0xa8cad7;if(!SceneManager[_0x599518(0x45f)]())return;VisuMZ[_0x599518(0x17f)](_0x213826,_0x213826);const _0x2d12d3=$gameTemp['getLastPluginCommandInterpreter'](),_0x5e9140=VisuMZ[_0x599518(0x449)](_0x213826[_0x599518(0x171)]),_0x56910a=_0x213826['Opacity'],_0x1fe450=_0x213826[_0x599518(0x37b)],_0x1bc79f=_0x213826['EasingType'],_0x6406e8=_0x213826['WaitForOpacity'];if(!_0x2d12d3)return;for(const _0x5cd50a of _0x5e9140){if(_0x599518(0x499)!==_0x599518(0x9c1)){if(!_0x5cd50a)continue;_0x5cd50a[_0x599518(0x4de)](_0x56910a,_0x1fe450,_0x1bc79f);}else this[_0x599518(0x75f)](_0x599518(0x431)),_0x566f73['BattleCore'][_0x599518(0x2d7)]['call'](this),this[_0x599518(0x75f)](_0x599518(0x207));}if(_0x6406e8)_0x2d12d3[_0x599518(0x1e7)](_0x599518(0x337));}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x4da),_0x2dd6f4=>{const _0x4195a3=_0xa8cad7;if(!SceneManager[_0x4195a3(0x45f)]())return;VisuMZ[_0x4195a3(0x17f)](_0x2dd6f4,_0x2dd6f4);const _0x578061=$gameTemp[_0x4195a3(0x933)](),_0x5d4a1a=VisuMZ['CreateActionSequenceTargets'](_0x2dd6f4['Targets']),_0x4aefd4=_0x2dd6f4['ScaleX'],_0x2cc63e=_0x2dd6f4['ScaleY'],_0x37f498=_0x2dd6f4[_0x4195a3(0x37b)],_0x326a15=_0x2dd6f4['EasingType'],_0x44ec8a=_0x2dd6f4[_0x4195a3(0xb58)];if(!_0x578061)return;for(const _0x542857 of _0x5d4a1a){if(!_0x542857)continue;_0x542857['growBattler'](_0x4aefd4,_0x2cc63e,_0x37f498,_0x326a15);}if(_0x44ec8a)_0x578061[_0x4195a3(0x1e7)](_0x4195a3(0x6c8));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Movement_Skew',_0x25de5a=>{const _0x5cdcad=_0xa8cad7;if(!SceneManager[_0x5cdcad(0x45f)]())return;VisuMZ[_0x5cdcad(0x17f)](_0x25de5a,_0x25de5a);const _0x2a5251=$gameTemp[_0x5cdcad(0x933)](),_0x43fcbf=VisuMZ['CreateActionSequenceTargets'](_0x25de5a[_0x5cdcad(0x171)]),_0x1daeee=_0x25de5a[_0x5cdcad(0xa59)],_0x3a4404=_0x25de5a[_0x5cdcad(0x22f)],_0x3787ec=_0x25de5a[_0x5cdcad(0x37b)],_0x271bb8=_0x25de5a[_0x5cdcad(0xabf)],_0x247d08=_0x25de5a[_0x5cdcad(0x97b)];if(!_0x2a5251)return;for(const _0x38b734 of _0x43fcbf){if(!_0x38b734)continue;_0x38b734[_0x5cdcad(0x433)](_0x1daeee,_0x3a4404,_0x3787ec,_0x271bb8);}if(_0x247d08)_0x2a5251['setWaitMode'](_0x5cdcad(0x34d));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x3dc),_0x18bb8a=>{const _0x26a2a1=_0xa8cad7;if(!SceneManager[_0x26a2a1(0x45f)]())return;VisuMZ[_0x26a2a1(0x17f)](_0x18bb8a,_0x18bb8a);const _0x212af1=$gameTemp[_0x26a2a1(0x933)](),_0x16b767=VisuMZ[_0x26a2a1(0x449)](_0x18bb8a[_0x26a2a1(0x171)]),_0x452aa8=_0x18bb8a[_0x26a2a1(0xac5)],_0x19ccf5=_0x18bb8a['Duration'],_0x41a318=_0x18bb8a[_0x26a2a1(0xabf)],_0x3562e6=_0x18bb8a['RevertAngle'],_0x35417c=_0x18bb8a['WaitForSpin'];if(!_0x212af1)return;for(const _0x128967 of _0x16b767){if(_0x26a2a1(0x4a6)!==_0x26a2a1(0x785)){if(!_0x128967)continue;_0x128967[_0x26a2a1(0x444)](_0x452aa8,_0x19ccf5,_0x41a318,_0x3562e6);}else this[_0x26a2a1(0x248)]();}if(_0x35417c)_0x212af1['setWaitMode']('battleSpin');}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x4b5),_0x35bf20=>{const _0x49a8a2=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;const _0xde7f1d=$gameTemp[_0x49a8a2(0x933)]();if(!_0xde7f1d)return;_0xde7f1d['setWaitMode'](_0x49a8a2(0x436));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x619),_0x18c165=>{if(!SceneManager['isSceneBattle']())return;const _0x59ec33=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x59ec33)return;_0x59ec33['setWaitMode']('battleJump');}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0xaac),_0x1343f5=>{const _0x33df04=_0xa8cad7;if(!SceneManager[_0x33df04(0x45f)]())return;const _0x2833ee=$gameTemp[_0x33df04(0x933)]();if(!_0x2833ee)return;_0x2833ee[_0x33df04(0x1e7)](_0x33df04(0xadc));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x1f2),_0x228e48=>{const _0x43f3a8=_0xa8cad7;if(!SceneManager[_0x43f3a8(0x45f)]())return;const _0x17c025=$gameTemp[_0x43f3a8(0x933)]();if(!_0x17c025)return;_0x17c025[_0x43f3a8(0x1e7)](_0x43f3a8(0x337));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x793),_0x3c5d33=>{const _0xc124=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;const _0x85a255=$gameTemp[_0xc124(0x933)]();if(!_0x85a255)return;_0x85a255[_0xc124(0x1e7)]('battleGrow');}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],'ActSeq_Movement_WaitForSkew',_0x1ed593=>{const _0x332b45=_0xa8cad7;if(!SceneManager[_0x332b45(0x45f)]())return;const _0x5513c6=$gameTemp[_0x332b45(0x933)]();if(!_0x5513c6)return;_0x5513c6[_0x332b45(0x1e7)](_0x332b45(0x34d));}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x24d),_0x37cffa=>{const _0x9a6964=_0xa8cad7;if(!SceneManager[_0x9a6964(0x45f)]())return;const _0x12bc09=$gameTemp[_0x9a6964(0x933)]();if(!_0x12bc09)return;_0x12bc09['setWaitMode'](_0x9a6964(0x74d));}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],'ActSeq_Projectile_Animation',_0x2f1ad8=>{const _0x3f00fe=_0xa8cad7;if(!SceneManager[_0x3f00fe(0x45f)]())return;if(!Imported['VisuMZ_3_ActSeqProjectiles'])return;VisuMZ[_0x3f00fe(0x17f)](_0x2f1ad8,_0x2f1ad8);const _0x5b2ac6=$gameTemp[_0x3f00fe(0x933)](),_0x290aa5=_0x2f1ad8[_0x3f00fe(0x81d)];if(!_0x5b2ac6)return;const _0x2288b2=BattleManager['_spriteset'];if(!_0x2288b2)return;_0x2288b2['createActionSequenceProjectile'](_0x2f1ad8);if(_0x290aa5)_0x5b2ac6['setWaitMode'](_0x3f00fe(0xa20));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x1e5),_0x4d0dd1=>{const _0x1960e4=_0xa8cad7;if(!SceneManager[_0x1960e4(0x45f)]())return;if(!Imported[_0x1960e4(0x9e4)])return;VisuMZ[_0x1960e4(0x17f)](_0x4d0dd1,_0x4d0dd1);const _0x1e6030=$gameTemp[_0x1960e4(0x933)](),_0x4ab9d0=_0x4d0dd1[_0x1960e4(0x81d)];if(!_0x1e6030)return;const _0x5eca37=BattleManager[_0x1960e4(0x726)];if(!_0x5eca37)return;_0x5eca37['createActionSequenceProjectile'](_0x4d0dd1);if(_0x4ab9d0)_0x1e6030[_0x1960e4(0x1e7)](_0x1960e4(0xa20));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0xb27),_0x4a9f11=>{const _0x4e0699=_0xa8cad7;if(!SceneManager[_0x4e0699(0x45f)]())return;if(!Imported[_0x4e0699(0x9e4)])return;VisuMZ[_0x4e0699(0x17f)](_0x4a9f11,_0x4a9f11);const _0x5c0e93=$gameTemp['getLastPluginCommandInterpreter'](),_0x127ecf=_0x4a9f11[_0x4e0699(0x81d)];if(!_0x5c0e93)return;const _0x3e49ff=BattleManager[_0x4e0699(0x726)];if(!_0x3e49ff)return;_0x3e49ff['createActionSequenceProjectile'](_0x4a9f11);if(_0x127ecf)_0x5c0e93[_0x4e0699(0x1e7)](_0x4e0699(0xa20));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0xa34),_0x1c6040=>{const _0x5db4ce=_0xa8cad7;if(!SceneManager[_0x5db4ce(0x45f)]())return;if(!Imported[_0x5db4ce(0x1d1)])return;VisuMZ[_0x5db4ce(0x17f)](_0x1c6040,_0x1c6040);const _0x54240e=$gameTemp[_0x5db4ce(0x933)](),_0x33c073=_0x1c6040[_0x5db4ce(0x97b)];if(!_0x54240e)return;$gameScreen[_0x5db4ce(0x5ae)](_0x1c6040['SkewX'],_0x1c6040[_0x5db4ce(0x22f)],_0x1c6040[_0x5db4ce(0x37b)],_0x1c6040['EasingType']);if(_0x33c073)_0x54240e[_0x5db4ce(0x1e7)]('battleSkew');}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x322),_0x48b5f8=>{const _0x247981=_0xa8cad7;if(!SceneManager[_0x247981(0x45f)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ['ConvertParams'](_0x48b5f8,_0x48b5f8);const _0x3fbef7=$gameTemp['getLastPluginCommandInterpreter'](),_0x4d7b05=_0x48b5f8[_0x247981(0x97b)];if(!_0x3fbef7)return;$gameScreen[_0x247981(0x5ae)](0x0,0x0,_0x48b5f8[_0x247981(0x37b)],_0x48b5f8[_0x247981(0xabf)]);if(_0x4d7b05)_0x3fbef7[_0x247981(0x1e7)](_0x247981(0x67a));}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Skew_WaitForSkew',_0x57bed5=>{const _0x39ebac=_0xa8cad7;if(!SceneManager[_0x39ebac(0x45f)]())return;if(!Imported[_0x39ebac(0x1d1)])return;const _0x208192=$gameTemp[_0x39ebac(0x933)]();if(!_0x208192)return;_0x208192[_0x39ebac(0x1e7)](_0x39ebac(0x67a));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0xa65),_0x4f2a7f=>{const _0xfc286b=_0xa8cad7;if(!SceneManager[_0xfc286b(0x45f)]())return;VisuMZ[_0xfc286b(0x17f)](_0x4f2a7f,_0x4f2a7f);const _0x324fb4=$gameTemp['getLastPluginCommandInterpreter'](),_0x5a492c=_0x4f2a7f[_0xfc286b(0x4a8)],_0x106929=_0x4f2a7f[_0xfc286b(0x30a)];if(!_0x324fb4)return;BattleManager[_0xfc286b(0x4e3)]=_0x5a492c,BattleManager[_0xfc286b(0x123)]=BattleManager['_allTargets']?BattleManager[_0xfc286b(0x257)][BattleManager['_targetIndex']]||null:null;if(BattleManager[_0xfc286b(0x123)]&&_0x106929[_0xfc286b(0x41c)]()['trim']()!==_0xfc286b(0x76c)){if(_0xfc286b(0xb40)!=='NsHNt')return _0x4d0c90['getInputButtonString'](_0xfc286b(0xb3a));else _0x324fb4[_0xfc286b(0x86b)]([_0x106929]);}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Target_NextTarget',_0xe3857f=>{const _0x57b88a=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0xe3857f,_0xe3857f);const _0x3e7dab=$gameTemp['getLastPluginCommandInterpreter'](),_0x159be4=_0xe3857f[_0x57b88a(0x30a)];if(!_0x3e7dab)return;BattleManager[_0x57b88a(0x4e3)]++,BattleManager[_0x57b88a(0x123)]=BattleManager['_allTargets'][BattleManager[_0x57b88a(0x4e3)]]||null,BattleManager[_0x57b88a(0x123)]&&_0x159be4[_0x57b88a(0x41c)]()[_0x57b88a(0xb45)]()!==_0x57b88a(0x76c)&&_0x3e7dab[_0x57b88a(0x86b)]([_0x159be4]);}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x441),_0x570662=>{const _0x415923=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x415923(0x17f)](_0x570662,_0x570662);const _0x56592c=$gameTemp[_0x415923(0x933)](),_0x1c3232=_0x570662[_0x415923(0x30a)];if(!_0x56592c)return;BattleManager['_targetIndex']--,BattleManager[_0x415923(0x123)]=BattleManager[_0x415923(0x257)][BattleManager[_0x415923(0x4e3)]]||null,BattleManager['_target']&&_0x1c3232[_0x415923(0x41c)]()[_0x415923(0xb45)]()!==_0x415923(0x76c)&&_0x56592c[_0x415923(0x86b)]([_0x1c3232]);}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x2dc),_0x5c139b=>{const _0x57e3af=_0xa8cad7;if(!SceneManager[_0x57e3af(0x45f)]())return;VisuMZ['ConvertParams'](_0x5c139b,_0x5c139b);const _0x5b3711=$gameTemp['getLastPluginCommandInterpreter'](),_0x5aa127=_0x5c139b['ForceRandom'],_0x5e4c91=_0x5c139b[_0x57e3af(0x30a)];if(!_0x5b3711)return;const _0x5190c3=BattleManager[_0x57e3af(0x4e3)];for(;;){if('dQCoG'!==_0x57e3af(0x85f)){BattleManager[_0x57e3af(0x4e3)]=Math[_0x57e3af(0xa4a)](BattleManager[_0x57e3af(0x257)][_0x57e3af(0x19c)]);if(!_0x5aa127)break;if(BattleManager['_targetIndex']!==_0x5190c3)break;if(BattleManager[_0x57e3af(0x257)][_0x57e3af(0x19c)]<=0x1){BattleManager[_0x57e3af(0x4e3)]=0x0;break;}}else{_0x3707df[_0x57e3af(0x21d)](_0x36f390);const _0x3b3f94=_0x9985b3(_0x1a10c9['$1'])[_0x57e3af(0x136)](',')[_0x57e3af(0x369)](_0x27b46f=>_0x2a1a3e(_0x27b46f)[_0x57e3af(0x41c)]()[_0x57e3af(0xb45)]());_0x398d3e=_0x37b505['concat'](_0x3b3f94);}}BattleManager[_0x57e3af(0x123)]=BattleManager[_0x57e3af(0x257)][BattleManager[_0x57e3af(0x4e3)]]||null,BattleManager[_0x57e3af(0x123)]&&_0x5e4c91['toUpperCase']()[_0x57e3af(0xb45)]()!==_0x57e3af(0x76c)&&_0x5b3711[_0x57e3af(0x86b)]([_0x5e4c91]);}),PluginManager['registerCommand'](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x9c2),_0x133ecc=>{const _0x4e2a88=_0xa8cad7;if(!SceneManager[_0x4e2a88(0x45f)]())return;VisuMZ[_0x4e2a88(0x17f)](_0x133ecc,_0x133ecc);const _0x3d076f=VisuMZ[_0x4e2a88(0x449)](_0x133ecc[_0x4e2a88(0x171)]);for(const _0xd73626 of _0x3d076f){if(!_0xd73626)continue;if(!_0xd73626['isActor']())continue;_0xd73626['clearActiveWeaponSlot']();}}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Weapon_NextActiveWeapon',_0x4cca4b=>{const _0x1635fc=_0xa8cad7;if(!SceneManager[_0x1635fc(0x45f)]())return;VisuMZ[_0x1635fc(0x17f)](_0x4cca4b,_0x4cca4b);const _0x4802ad=$gameTemp[_0x1635fc(0x933)]();let _0x1bc398=![];const _0x437cb6=_0x4cca4b[_0x1635fc(0x30a)],_0x30c1e4=VisuMZ[_0x1635fc(0x449)](_0x4cca4b[_0x1635fc(0x171)]);for(const _0x19fc15 of _0x30c1e4){if(!_0x19fc15)continue;if(!_0x19fc15['isActor']())continue;_0x19fc15[_0x1635fc(0x20e)](),_0x19fc15[_0x1635fc(0x7ca)]()[_0x1635fc(0x19c)]>0x0?_0x1635fc(0x59a)===_0x1635fc(0x5a2)?_0xcc26e2[_0x1635fc(0x298)](_0x562b77):_0x1bc398=!![]:_0x19fc15['clearActiveWeaponSlot']();}_0x1bc398&&_0x437cb6['toUpperCase']()[_0x1635fc(0xb45)]()!==_0x1635fc(0x76c)&&_0x4802ad[_0x1635fc(0x86b)]([_0x437cb6]);}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],'ActSeq_Weapon_SetActiveWeapon',_0x579257=>{const _0x32385a=_0xa8cad7;if(!SceneManager[_0x32385a(0x45f)]())return;VisuMZ[_0x32385a(0x17f)](_0x579257,_0x579257);let _0x3b3396=_0x579257[_0x32385a(0x8a7)];_0x3b3396--,_0x3b3396=Math['max'](_0x3b3396,0x0);const _0x3d61f2=VisuMZ[_0x32385a(0x449)](_0x579257[_0x32385a(0x171)]);for(const _0x51bd97 of _0x3d61f2){if(!_0x51bd97)continue;if(!_0x51bd97[_0x32385a(0x902)]())continue;_0x51bd97[_0x32385a(0xaf0)](_0x3b3396);}}),PluginManager[_0xa8cad7(0x879)](pluginData['name'],_0xa8cad7(0x7c1),_0x21a08d=>{const _0x385811=_0xa8cad7;if(!SceneManager[_0x385811(0x45f)]())return;if(!Imported[_0x385811(0x1d1)])return;VisuMZ[_0x385811(0x17f)](_0x21a08d,_0x21a08d);const _0x476374=$gameTemp[_0x385811(0x933)](),_0x1961ee=_0x21a08d['WaitForZoom'];if(!_0x476374)return;$gameScreen[_0x385811(0x1c1)](_0x21a08d[_0x385811(0x8d9)],_0x21a08d[_0x385811(0x37b)],_0x21a08d['EasingType']);if(_0x1961ee)_0x476374['setWaitMode'](_0x385811(0x90f));}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0x953),_0x233613=>{const _0x8e290d=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x8e290d(0x1d1)])return;VisuMZ[_0x8e290d(0x17f)](_0x233613,_0x233613);const _0x54a822=$gameTemp[_0x8e290d(0x933)](),_0x3a3e92=_0x233613[_0x8e290d(0xb7c)];if(!_0x54a822)return;$gameScreen['setBattleZoom'](0x1,_0x233613[_0x8e290d(0x37b)],_0x233613[_0x8e290d(0xabf)]);if(_0x3a3e92)_0x54a822['setWaitMode']('battleZoom');}),PluginManager[_0xa8cad7(0x879)](pluginData[_0xa8cad7(0x9a6)],_0xa8cad7(0xa5b),_0x4dd609=>{const _0x11af67=_0xa8cad7;if(!SceneManager[_0x11af67(0x45f)]())return;if(!Imported[_0x11af67(0x1d1)])return;const _0x4c5219=$gameTemp[_0x11af67(0x933)]();if(!_0x4c5219)return;_0x4c5219[_0x11af67(0x1e7)]('battleZoom');}),VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x398)]=Scene_Boot[_0xa8cad7(0xa60)][_0xa8cad7(0x792)],Scene_Boot[_0xa8cad7(0xa60)][_0xa8cad7(0x792)]=function(){const _0x451bb9=_0xa8cad7;this['process_VisuMZ_BattleCore_Failsafes'](),this[_0x451bb9(0x214)](),this[_0x451bb9(0x9ce)](),this[_0x451bb9(0x9dd)](),VisuMZ[_0x451bb9(0x8a9)]['Scene_Boot_onDatabaseLoaded'][_0x451bb9(0x9b5)](this),this['process_VisuMZ_BattleCore_Notetags'](),this['process_VisuMZ_BattleCore_BaseTroops'](),this['process_VisuMZ_BattleCore_PreBattleCommonEvent'](),this[_0x451bb9(0x6d4)]();},Scene_Boot[_0xa8cad7(0xa60)][_0xa8cad7(0x718)]=function(){const _0x258650=_0xa8cad7;if(VisuMZ['ParseAllNotetags'])return;this[_0x258650(0x862)](),this[_0x258650(0x387)](),this[_0x258650(0x8c6)]();},Scene_Boot['prototype'][_0xa8cad7(0x6cd)]=function(){const _0x5de98f=_0xa8cad7,_0x36c4ff=$dataSystem[_0x5de98f(0x47e)][_0x5de98f(0x19c)];for(let _0x3699d6=0x0;_0x3699d6<_0x36c4ff;_0x3699d6++){if(_0x5de98f(0xa91)!==_0x5de98f(0x1a2)){const _0x532088=$dataSystem[_0x5de98f(0x394)][_0x3699d6];if(_0x532088)continue;$dataSystem[_0x5de98f(0x394)][_0x3699d6]=JsonEx[_0x5de98f(0x673)]($dataSystem[_0x5de98f(0x394)][0x0]);}else{const _0x501a7a=!!this['_freezeMotionData'];this[_0x5de98f(0x39d)]=_0x4bfc1b,_0x501a7a&&(this['requestMotionRefresh'](),this['clearFreezeMotionForWeapons']());}}},Scene_Boot['prototype'][_0xa8cad7(0x214)]=function(){const _0x507052=_0xa8cad7,_0x21b186=VisuMZ['BattleCore'][_0x507052(0xb57)];_0x21b186[_0x507052(0x741)][_0x507052(0x589)]===undefined&&(_0x21b186[_0x507052(0x741)][_0x507052(0x589)]=_0x507052(0x992));_0x21b186[_0x507052(0x3d8)][_0x507052(0x115)]===undefined&&(_0x21b186[_0x507052(0x3d8)][_0x507052(0x115)]=![]);_0x21b186[_0x507052(0x8d5)]['SmoothImage']===undefined&&(_0x507052(0x405)===_0x507052(0xa18)?this['opacity']=this[_0x507052(0x59f)](this[_0x507052(0xa4c)],this[_0x507052(0x392)],_0x5dae90,_0x26e43e,_0x1d4d33):_0x21b186['Enemy'][_0x507052(0x115)]=!![]);_0x21b186[_0x507052(0x3d8)][_0x507052(0xa56)]===undefined&&(_0x507052(0x2e9)!==_0x507052(0x569)?_0x21b186[_0x507052(0x3d8)]['PrioritySortActive']=![]:(this['isNonSubmenuCancel']()?(this[_0x507052(0x213)][_0x507052(0x518)](),this[_0x507052(0x63b)]['hide'](),this[_0x507052(0x9e9)]['activate']()):_0x1e7071[_0x507052(0x8a9)][_0x507052(0x803)][_0x507052(0x9b5)](this),this[_0x507052(0x844)]()));if(_0x21b186[_0x507052(0x3d8)][_0x507052(0x6ee)]===undefined){if(_0x507052(0x7de)===_0x507052(0x7de))_0x21b186[_0x507052(0x3d8)][_0x507052(0x6ee)]=!![];else{const _0x3074c1=this[_0x507052(0x840)];_0x3074c1&&(_0x3074c1[_0x507052(0x122)]['x']=this[_0x507052(0x3bf)](),_0x3074c1[_0x507052(0x122)]['y']=this['mainSpriteScaleY']());}}},VisuMZ[_0xa8cad7(0x8fc)]={},Scene_Boot[_0xa8cad7(0xa60)][_0xa8cad7(0x9ce)]=function(){const _0x5423f1=_0xa8cad7;for(const _0x3487f2 of VisuMZ['BattleCore'][_0x5423f1(0xb57)][_0x5423f1(0x741)][_0x5423f1(0x4e7)]){if(_0x5423f1(0xad8)==='IVqaN')return _0xdea0da[_0x5423f1(0x8a9)][_0x5423f1(0x600)]['call'](this);else{if(!_0x3487f2)continue;const _0xf71ae7=_0x3487f2[_0x5423f1(0x775)][_0x5423f1(0x41c)]()[_0x5423f1(0xb45)]();VisuMZ[_0x5423f1(0x8fc)][_0xf71ae7]=_0x3487f2;}}},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xa37)]={},Scene_Boot['prototype'][_0xa8cad7(0x9dd)]=function(){const _0x593dcb=_0xa8cad7,_0x27c06e=VisuMZ[_0x593dcb(0x8a9)][_0x593dcb(0xa37)],_0xe0b9df='<%1>\x5cs*([\x5cs\x5cS]*)\x5cs*<\x5c/%1>',_0x3c01ce=[[_0x593dcb(0x658),_0x593dcb(0x2a4)],[_0x593dcb(0x2e3),_0x593dcb(0x4b0)]],_0x5e0124=[[_0x593dcb(0x8d6),'JS\x20%1APPLY\x20%2'],['%1Damage%2JS',_0x593dcb(0x2f4)]],_0x28f66e=[['',''],['AsUser',_0x593dcb(0x4d6)],[_0x593dcb(0x8d8),_0x593dcb(0x49d)]];for(const _0x419060 of _0x5e0124){if('TaOti'===_0x593dcb(0x480))for(const _0x1d5d25 of _0x28f66e){for(const _0x37b9e5 of _0x3c01ce){const _0x2bf6f6=_0x419060[0x0]['format'](_0x37b9e5[0x0],_0x1d5d25[0x0]),_0xa0b6c9=_0x419060[0x1]['format'](_0x37b9e5[0x1],_0x1d5d25[0x1])['trim'](),_0x447e2b=new RegExp(_0xe0b9df[_0x593dcb(0x69b)](_0xa0b6c9),'i');_0x27c06e[_0x2bf6f6]=_0x447e2b;}}else _0x50c29a[_0x593dcb(0x8a9)][_0x593dcb(0xb49)]['call'](this,_0x27f5b3);}const _0x38a640=[[_0x593dcb(0x4d3),_0x593dcb(0x564)],[_0x593dcb(0x520),_0x593dcb(0x3cc)]];for(const _0x46663b of _0x38a640){for(const _0x5611cb of _0x3c01ce){if(_0x593dcb(0xb28)!==_0x593dcb(0xb28))this[_0x593dcb(0x4ee)][_0x593dcb(0x9ac)](_0xfd4058);else{const _0x1b2e94=_0x46663b[0x0][_0x593dcb(0x69b)](_0x5611cb[0x0]),_0x470259=_0x46663b[0x1][_0x593dcb(0x69b)](_0x5611cb[0x1]),_0x395a70=new RegExp(_0xe0b9df[_0x593dcb(0x69b)](_0x470259),'i');_0x27c06e[_0x1b2e94]=_0x395a70;}}}const _0x1a14cc=[[_0x593dcb(0xb7d),'JS\x20%1START\x20BATTLE'],[_0x593dcb(0x799),'JS\x20%1END\x20BATTLE'],[_0x593dcb(0x6a1),_0x593dcb(0x7ec)],[_0x593dcb(0x5d0),_0x593dcb(0x4c6)],[_0x593dcb(0x7e4),_0x593dcb(0x3fd)],[_0x593dcb(0x581),_0x593dcb(0x31d)],[_0x593dcb(0x3fa),_0x593dcb(0x74a)],[_0x593dcb(0x2ab),'JS\x20%1END\x20TURN'],[_0x593dcb(0x97c),_0x593dcb(0x67e)]];for(const _0x36051d of _0x1a14cc){for(const _0x30f08d of _0x3c01ce){const _0x52fd87=_0x36051d[0x0]['format'](_0x30f08d[0x0]),_0xe9d52b=_0x36051d[0x1][_0x593dcb(0x69b)](_0x30f08d[0x1]),_0xa10e8e=new RegExp(_0xe0b9df[_0x593dcb(0x69b)](_0xe9d52b),'i');_0x27c06e[_0x52fd87]=_0xa10e8e;}}},Scene_Boot[_0xa8cad7(0xa60)][_0xa8cad7(0x862)]=function(){const _0x29926e=_0xa8cad7,_0x47d905=$dataSkills[_0x29926e(0xaff)]($dataItems);for(const _0x46ceb6 of _0x47d905){if(_0x29926e(0x819)!==_0x29926e(0x819))_0x2f876c[_0x29926e(0x8a9)][_0x29926e(0x3a0)][_0x29926e(0x9b5)](this,_0x556b63),this[_0x29926e(0xa8a)]();else{if(!_0x46ceb6)continue;VisuMZ['BattleCore'][_0x29926e(0xab2)](_0x46ceb6);}}},Scene_Boot[_0xa8cad7(0xa60)]['process_VisuMZ_BattleCore_TraitObject_Notetags']=function(){const _0x230e43=_0xa8cad7,_0x587e1d=$dataActors['concat']($dataClasses,$dataWeapons,$dataArmors,$dataEnemies,$dataStates);for(const _0x1342d0 of _0x587e1d){if(!_0x1342d0)continue;VisuMZ[_0x230e43(0x8a9)][_0x230e43(0x477)](_0x1342d0);}},Scene_Boot[_0xa8cad7(0xa60)][_0xa8cad7(0x6b6)]=function(){const _0x2ca299=_0xa8cad7,_0x16de30=VisuMZ[_0x2ca299(0x8a9)]['Settings'][_0x2ca299(0x5e4)]['BaseTroopIDs'],_0x12c8f4=[];for(const _0x1eee09 of _0x16de30){if(_0x2ca299(0x5f9)!==_0x2ca299(0x5f9))this['_mainSprite'][_0x2ca299(0x379)][_0x2ca299(0xb20)]=this[_0x2ca299(0x959)][_0x2ca299(0x2ea)]();else{const _0xca0788=$dataTroops[_0x1eee09];if(_0xca0788)_0x12c8f4[_0x2ca299(0x6c0)](JsonEx[_0x2ca299(0x673)](_0xca0788));}}for(const _0x1e552d of $dataTroops){if(!_0x1e552d)continue;for(const _0x41e0ad of _0x12c8f4){if(_0x41e0ad['id']===_0x1e552d['id'])continue;_0x1e552d[_0x2ca299(0x342)]=_0x1e552d[_0x2ca299(0x342)][_0x2ca299(0xaff)](_0x41e0ad[_0x2ca299(0x342)]);}}},Scene_Boot[_0xa8cad7(0xa60)][_0xa8cad7(0x129)]=function(){const _0x43201c=_0xa8cad7,_0x5c1e2a=VisuMZ[_0x43201c(0x8a9)][_0x43201c(0xb57)]['Mechanics'];if(_0x5c1e2a[_0x43201c(0x1b4)]>0x0&&$dataCommonEvents[_0x5c1e2a[_0x43201c(0x1b4)]]){const _0x1e72b5=$dataCommonEvents[_0x5c1e2a[_0x43201c(0x1b4)]],_0x33e4cb=_0x1e72b5[_0x43201c(0x8cb)][_0x43201c(0x19c)]-0x2,_0x1daac2=_0x1e72b5[_0x43201c(0x8cb)][_0x33e4cb];if(_0x1daac2&&_0x1daac2[_0x43201c(0x325)]!==0xe6){const _0x289351={'code':0xe6,'indent':0x0,'parameters':[0x1]},_0x313ec8=_0x1e72b5[_0x43201c(0x8cb)]['pop']();_0x1e72b5[_0x43201c(0x8cb)][_0x43201c(0xa77)](_0x289351),_0x1e72b5[_0x43201c(0x8cb)][_0x43201c(0xa77)](_0x313ec8);}}},Scene_Boot[_0xa8cad7(0xa60)]['process_VisuMZ_BattleCore_CommonEventKeys']=function(){const _0x3117da=_0xa8cad7;VisuMZ[_0x3117da(0x8a9)][_0x3117da(0x5d1)](),VisuMZ[_0x3117da(0x8a9)][_0x3117da(0xb85)]($dataSkills),VisuMZ['BattleCore'][_0x3117da(0xb85)]($dataItems);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x5d1)]=function(){const _0x31feb6=_0xa8cad7;VisuMZ[_0x31feb6(0x8a9)][_0x31feb6(0x2b6)]={};for(const _0x2b0952 of $dataCommonEvents){if(!_0x2b0952)continue;if(_0x2b0952[_0x31feb6(0x9a6)][_0x31feb6(0x21d)](/\[(.*)\]/i)){let _0x5bcc21=String(RegExp['$1'])[_0x31feb6(0x536)](/,/g,'')[_0x31feb6(0x41c)]()[_0x31feb6(0xb45)]();VisuMZ[_0x31feb6(0x8a9)][_0x31feb6(0x2b6)][_0x5bcc21]=_0x2b0952['id'];}}},VisuMZ['BattleCore']['BindCommonEventKeysForGroup']=function(_0x2bfe02){const _0x5562b5=_0xa8cad7;for(const _0xa58654 of _0x2bfe02){if(!_0xa58654)continue;VisuMZ[_0x5562b5(0x8a9)][_0x5562b5(0x6d0)](_0xa58654);}},VisuMZ[_0xa8cad7(0x8a9)]['BindCommonEventKeysForObj']=function(_0x56bc30){const _0x5250a9=_0xa8cad7;if(!_0x56bc30)return;if(!_0x56bc30[_0x5250a9(0x9c6)])return;VisuMZ[_0x5250a9(0x8a9)][_0x5250a9(0x2b6)]=VisuMZ[_0x5250a9(0x8a9)][_0x5250a9(0x2b6)]||{};const _0x5bda7c=/<COMMON EVENT (?:KEY|KEYS):[ ](.*)>/gi,_0x721b78=/<COMMON EVENT (?:KEY|KEYS)>\s*([\s\S]*)\s*<\/COMMON EVENT (?:KEY|KEYS)>/i;let _0xc7603c=[];const _0x2f69f7=_0x56bc30['note'][_0x5250a9(0x21d)](_0x5bda7c);if(_0x2f69f7){if(_0x5250a9(0x488)!==_0x5250a9(0x488))_0x1674e6+=_0x3121cf;else{for(const _0xe9b0df of _0x2f69f7){_0xe9b0df[_0x5250a9(0x21d)](_0x5bda7c);const _0x314782=String(RegExp['$1'])[_0x5250a9(0x136)](',')[_0x5250a9(0x369)](_0x1841f0=>String(_0x1841f0)[_0x5250a9(0x41c)]()['trim']());_0xc7603c=_0xc7603c['concat'](_0x314782);}!_0x56bc30[_0x5250a9(0x74f)][_0x5250a9(0x21d)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x5250a9(0x95b)!==_0x5250a9(0x95b)?this[_0x5250a9(0x300)](_0x5250a9(0xb79)):_0x56bc30[_0x5250a9(0x74f)]+=_0x5250a9(0xaab));;}}if(_0x56bc30[_0x5250a9(0x74f)][_0x5250a9(0x21d)](_0x721b78)){const _0x549805=String(RegExp['$1'])[_0x5250a9(0x136)](/[\r\n]+/)[_0x5250a9(0x369)](_0x30d948=>String(_0x30d948)[_0x5250a9(0x41c)]()[_0x5250a9(0xb45)]());_0xc7603c=_0xc7603c[_0x5250a9(0xaff)](_0x549805);if(!_0x56bc30['note'][_0x5250a9(0x21d)](/<CUSTOM ACTION SEQUENCE>/i)){if(_0x5250a9(0x5a1)!==_0x5250a9(0x293))_0x56bc30['note']+=_0x5250a9(0xaab);else{const _0x1323c4=this[_0x5250a9(0x973)](_0x2519d1);if(_0x1323c4==='iconText')this[_0x5250a9(0x63f)](_0xa5934);else _0x1323c4===_0x5250a9(0x9f3)?this[_0x5250a9(0x86e)](_0x2767fb):_0x50b497[_0x5250a9(0xa60)]['drawItem'][_0x5250a9(0x9b5)](this,_0x55fdeb);this[_0x5250a9(0x147)](_0x31bdfe);}};}for(const _0x41bc48 of _0xc7603c){if(VisuMZ['BattleCore'][_0x5250a9(0x2b6)][_0x41bc48]){const _0x5822f2=VisuMZ[_0x5250a9(0x8a9)][_0x5250a9(0x2b6)][_0x41bc48],_0x4b9a03={'code':0x2c,'dataId':_0x5822f2,'value1':0x1,'value2':0x0};_0x56bc30['effects']['push'](_0x4b9a03);}}},Scene_Boot[_0xa8cad7(0xa60)][_0xa8cad7(0x8c6)]=function(){const _0x11098a=_0xa8cad7,_0x4e264c=$dataSkills['concat']($dataItems);for(const _0x79c17a of _0x4e264c){if(!_0x79c17a)continue;VisuMZ[_0x11098a(0x8a9)]['Parse_Notetags_Targets'](_0x79c17a);}},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x981)]=VisuMZ['ParseActorNotetags'],VisuMZ[_0xa8cad7(0x981)]=function(_0x3ebbd0){const _0x558658=_0xa8cad7;VisuMZ[_0x558658(0x8a9)][_0x558658(0x981)]&&VisuMZ['BattleCore'][_0x558658(0x981)][_0x558658(0x9b5)](this,_0x3ebbd0),VisuMZ[_0x558658(0x8a9)][_0x558658(0x477)](_0x3ebbd0);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x823)]=VisuMZ[_0xa8cad7(0x823)],VisuMZ[_0xa8cad7(0x823)]=function(_0x11c2a5){const _0x416330=_0xa8cad7;VisuMZ['BattleCore'][_0x416330(0x823)]&&('kpFKz'!==_0x416330(0x7b2)?(_0x5a8084=_0x3442fc[_0x416330(0x536)](/\x1I\[(\d+)\]/gi,''),_0x1835a3=_0x214a09[_0x416330(0x536)](/\\I\[(\d+)\]/gi,'')):VisuMZ['BattleCore']['ParseClassNotetags']['call'](this,_0x11c2a5)),VisuMZ[_0x416330(0x8a9)][_0x416330(0x477)](_0x11c2a5);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x170)]=VisuMZ[_0xa8cad7(0x170)],VisuMZ[_0xa8cad7(0x170)]=function(_0x39a396){const _0x4e607f=_0xa8cad7;VisuMZ['BattleCore'][_0x4e607f(0x170)]&&VisuMZ[_0x4e607f(0x8a9)][_0x4e607f(0x170)][_0x4e607f(0x9b5)](this,_0x39a396),VisuMZ[_0x4e607f(0x8a9)][_0x4e607f(0xab2)](_0x39a396),VisuMZ[_0x4e607f(0x8a9)][_0x4e607f(0x909)](_0x39a396);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x292)]=VisuMZ[_0xa8cad7(0x292)],VisuMZ[_0xa8cad7(0x292)]=function(_0xeb4774){const _0x192274=_0xa8cad7;VisuMZ[_0x192274(0x8a9)]['ParseItemNotetags']&&VisuMZ['BattleCore'][_0x192274(0x292)][_0x192274(0x9b5)](this,_0xeb4774),VisuMZ[_0x192274(0x8a9)][_0x192274(0xab2)](_0xeb4774),VisuMZ[_0x192274(0x8a9)]['Parse_Notetags_Targets'](_0xeb4774);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x51a)]=VisuMZ[_0xa8cad7(0x51a)],VisuMZ[_0xa8cad7(0x51a)]=function(_0x42c3ed){const _0x51dcc6=_0xa8cad7;if(VisuMZ['BattleCore']['ParseWeaponNotetags']){if(_0x51dcc6(0x38e)===_0x51dcc6(0x88c))return this[_0x51dcc6(0xae6)]()&&this[_0x51dcc6(0xae6)]()[_0x51dcc6(0x191)]()&&this[_0x51dcc6(0xae6)]()['isMagicSkill']();else VisuMZ[_0x51dcc6(0x8a9)]['ParseWeaponNotetags'][_0x51dcc6(0x9b5)](this,_0x42c3ed);}VisuMZ[_0x51dcc6(0x8a9)][_0x51dcc6(0x477)](_0x42c3ed);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xa40)]=VisuMZ[_0xa8cad7(0xa40)],VisuMZ['ParseArmorNotetags']=function(_0x194f7b){const _0x3eb957=_0xa8cad7;if(VisuMZ['BattleCore'][_0x3eb957(0xa40)]){if('uHage'!==_0x3eb957(0x857)){const _0x28d1ed=this['commandStyle'](),_0x569b86=_0x22f112[_0x3eb957(0x8a9)][_0x3eb957(0xb57)]['PartyCmd'][_0x3eb957(0x7a8)],_0x2c8de1=_0x28d1ed===_0x3eb957(0x8df)?_0x150aa6[_0x3eb957(0x2d8)]:_0x3eb957(0x71f)['format'](_0x569b86,_0xd9a1d[_0x3eb957(0x2d8)]),_0x85532f=this[_0x3eb957(0x809)]();this[_0x3eb957(0x87d)](_0x2c8de1,_0x3eb957(0x2d8),_0x85532f);}else VisuMZ[_0x3eb957(0x8a9)][_0x3eb957(0xa40)][_0x3eb957(0x9b5)](this,_0x194f7b);}VisuMZ[_0x3eb957(0x8a9)][_0x3eb957(0x477)](_0x194f7b);},VisuMZ['BattleCore'][_0xa8cad7(0xb7e)]=VisuMZ[_0xa8cad7(0xb7e)],VisuMZ[_0xa8cad7(0xb7e)]=function(_0x127fc9){const _0x996665=_0xa8cad7;VisuMZ['BattleCore']['ParseEnemyNotetags']&&(_0x996665(0x5c5)===_0x996665(0x146)?this[_0x996665(0x5ce)]():VisuMZ[_0x996665(0x8a9)][_0x996665(0xb7e)][_0x996665(0x9b5)](this,_0x127fc9)),VisuMZ[_0x996665(0x8a9)]['Parse_Notetags_TraitObjects'](_0x127fc9);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x900)]=VisuMZ[_0xa8cad7(0x900)],VisuMZ[_0xa8cad7(0x900)]=function(_0x599050){const _0x2b9601=_0xa8cad7;if(VisuMZ[_0x2b9601(0x8a9)]['ParseStateNotetags']){if(_0x2b9601(0xaa5)===_0x2b9601(0xaa5))VisuMZ[_0x2b9601(0x8a9)][_0x2b9601(0x900)]['call'](this,_0x599050);else{if(!_0x5af038['BattleCore'][_0x2b9601(0xb57)][_0x2b9601(0x3d8)][_0x2b9601(0xa56)])return;const _0x24ff31=_0x277f7f[_0x2b9601(0x4d4)];if(_0x24ff31){if(_0x24ff31['isActor']()&&!_0xbb5fd[_0x2b9601(0x1d3)]())return;const _0x1f4c11=_0x24ff31[_0x2b9601(0xac0)]();if(_0x1f4c11&&_0x24ff31[_0x2b9601(0x902)]())this['_battlerContainer'][_0x2b9601(0x9ac)](_0x1f4c11);}}}VisuMZ[_0x2b9601(0x8a9)][_0x2b9601(0x477)](_0x599050);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xab2)]=function(_0x1a67f4){const _0x528ab4=_0xa8cad7,_0x51a489=[_0x528ab4(0x697),'PostApplyJS','PreDamageJS',_0x528ab4(0x5ee),'PreStartActionJS',_0x528ab4(0x9c7),_0x528ab4(0x4ed),_0x528ab4(0x5c7)];for(const _0x6ee67d of _0x51a489){VisuMZ[_0x528ab4(0x8a9)][_0x528ab4(0x338)](_0x1a67f4,_0x6ee67d);}const _0x842dfa=_0x1a67f4[_0x528ab4(0x74f)];_0x842dfa[_0x528ab4(0x21d)](/<ALWAYS CRITICAL/i)&&(_0x1a67f4['damage'][_0x528ab4(0x8cf)]=!![]),_0x842dfa['match'](/<(?:REPEAT|REPEATS|REPEAT HITS):[ ](\d+)/i)&&(_0x1a67f4[_0x528ab4(0x9b1)]=Math[_0x528ab4(0x743)](0x1,Number(RegExp['$1']))),_0x842dfa['match'](/<TARGET:[ ](.*)>/i)&&(_0x1a67f4[_0x528ab4(0x912)]=String(RegExp['$1'])[_0x528ab4(0x41c)]()[_0x528ab4(0xb45)]());},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x477)]=function(_0xddc213){const _0x4caa6e=_0xa8cad7,_0xed9e29=[_0x4caa6e(0x59d),_0x4caa6e(0x83b),_0x4caa6e(0x810),_0x4caa6e(0x4bd),_0x4caa6e(0x1d5),_0x4caa6e(0x849),_0x4caa6e(0x97e),'PostDamageAsTargetJS',_0x4caa6e(0x979),_0x4caa6e(0x9c7),_0x4caa6e(0x4ed),_0x4caa6e(0x5c7),_0x4caa6e(0x7ee),_0x4caa6e(0x630),_0x4caa6e(0xb4e),'PostEndBattleJS',_0x4caa6e(0x6a1),_0x4caa6e(0x5d0),_0x4caa6e(0x7e4),'EscapeFailureJS','PreStartTurnJS',_0x4caa6e(0xada),_0x4caa6e(0x431),_0x4caa6e(0x207),_0x4caa6e(0x33e),'PostRegenerateJS'];for(const _0x5ecd7a of _0xed9e29){VisuMZ[_0x4caa6e(0x8a9)][_0x4caa6e(0x338)](_0xddc213,_0x5ecd7a);}},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x909)]=function(_0x501bc4){const _0x19353e=_0xa8cad7,_0x39b529=_0x501bc4[_0x19353e(0x74f)];if(_0x39b529[_0x19353e(0x21d)](/<JS TARGETS>\s*([\s\S]*)\s*<\/JS TARGETS>/i)){const _0x40b1f6=String(RegExp['$1']),_0x1143e4=VisuMZ[_0x19353e(0x8a9)]['createKeyJS'](_0x501bc4,_0x19353e(0x171));VisuMZ['BattleCore'][_0x19353e(0xa9c)](_0x40b1f6,_0x1143e4);}if(_0x39b529[_0x19353e(0x21d)](/<JS COMMAND (?:VISIBLE|SHOW|HIDE)>\s*([\s\S]*)\s*<\/JS COMMAND (?:VISIBLE|SHOW|HIDE)>/i)){const _0x3de210=String(RegExp['$1']),_0x67d148=VisuMZ[_0x19353e(0x8a9)][_0x19353e(0x50a)](_0x501bc4,_0x19353e(0x9d4));VisuMZ[_0x19353e(0x8a9)][_0x19353e(0x4e6)](_0x3de210,_0x67d148);}},VisuMZ[_0xa8cad7(0x8a9)]['JS']={},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x338)]=function(_0x58792c,_0x1118e1){const _0x786b3a=_0xa8cad7,_0x265aa9=_0x58792c[_0x786b3a(0x74f)];if(_0x265aa9['match'](VisuMZ[_0x786b3a(0x8a9)][_0x786b3a(0xa37)][_0x1118e1])){const _0xa7dc78=RegExp['$1'],_0x54d776=_0x786b3a(0x5f4)['format'](_0xa7dc78),_0x481321=VisuMZ[_0x786b3a(0x8a9)][_0x786b3a(0x50a)](_0x58792c,_0x1118e1);VisuMZ[_0x786b3a(0x8a9)]['JS'][_0x481321]=new Function(_0x54d776);}},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x50a)]=function(_0x3a297c,_0x39ab52){const _0x1d521c=_0xa8cad7;let _0x226ccb='';if($dataActors[_0x1d521c(0x220)](_0x3a297c))_0x226ccb=_0x1d521c(0xa7f)[_0x1d521c(0x69b)](_0x3a297c['id'],_0x39ab52);if($dataClasses[_0x1d521c(0x220)](_0x3a297c))_0x226ccb=_0x1d521c(0x7dd)[_0x1d521c(0x69b)](_0x3a297c['id'],_0x39ab52);if($dataSkills[_0x1d521c(0x220)](_0x3a297c))_0x226ccb=_0x1d521c(0x475)['format'](_0x3a297c['id'],_0x39ab52);if($dataItems[_0x1d521c(0x220)](_0x3a297c))_0x226ccb=_0x1d521c(0x945)['format'](_0x3a297c['id'],_0x39ab52);if($dataWeapons[_0x1d521c(0x220)](_0x3a297c))_0x226ccb='Weapon-%1-%2'[_0x1d521c(0x69b)](_0x3a297c['id'],_0x39ab52);if($dataArmors[_0x1d521c(0x220)](_0x3a297c))_0x226ccb=_0x1d521c(0x79f)[_0x1d521c(0x69b)](_0x3a297c['id'],_0x39ab52);if($dataEnemies['includes'](_0x3a297c))_0x226ccb=_0x1d521c(0x413)[_0x1d521c(0x69b)](_0x3a297c['id'],_0x39ab52);if($dataStates[_0x1d521c(0x220)](_0x3a297c))_0x226ccb=_0x1d521c(0x97a)[_0x1d521c(0x69b)](_0x3a297c['id'],_0x39ab52);return _0x226ccb;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xa9c)]=function(_0x12f72c,_0x29a9c3){const _0x20e26c=_0xa8cad7,_0x1edd35=_0x20e26c(0x7d3)[_0x20e26c(0x69b)](_0x12f72c);VisuMZ[_0x20e26c(0x8a9)]['JS'][_0x29a9c3]=new Function(_0x1edd35);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x4e6)]=function(_0x2c909a,_0x7d9b32){const _0x4b0bd2=_0xa8cad7,_0x28533e=_0x4b0bd2(0x7c7)['format'](_0x2c909a);VisuMZ['BattleCore']['JS'][_0x7d9b32]=new Function(_0x28533e);},TextManager['autoBattle']=VisuMZ[_0xa8cad7(0x8a9)]['Settings']['PartyCmd'][_0xa8cad7(0x3fc)],TextManager[_0xa8cad7(0x790)]=VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xb57)]['AutoBattle'][_0xa8cad7(0x752)],TextManager[_0xa8cad7(0x5d8)]=VisuMZ['BattleCore'][_0xa8cad7(0xb57)][_0xa8cad7(0xa3f)][_0xa8cad7(0x502)],TextManager[_0xa8cad7(0x91a)]=VisuMZ[_0xa8cad7(0x8a9)]['Settings'][_0xa8cad7(0xb2e)][_0xa8cad7(0x775)],ColorManager['getColor']=function(_0x321fe5){const _0x3c01e3=_0xa8cad7;return _0x321fe5=String(_0x321fe5),_0x321fe5[_0x3c01e3(0x21d)](/#(.*)/i)?_0x3c01e3(0x800)[_0x3c01e3(0x69b)](String(RegExp['$1'])):this['textColor'](Number(_0x321fe5));},DataManager[_0xa8cad7(0x852)]=function(_0x42d725){const _0x5cf39f=_0xa8cad7;if(_0x42d725[_0x5cf39f(0x74f)]['match'](/<DAMAGE STYLE:[ ](.*)>/i)){if(_0x5cf39f(0x26c)===_0x5cf39f(0x26c)){const _0x1c4295=String(RegExp['$1'])[_0x5cf39f(0x41c)]()[_0x5cf39f(0xb45)]();if(_0x1c4295===_0x5cf39f(0x4bf))return _0x5cf39f(0x4bf);if(VisuMZ[_0x5cf39f(0x8fc)][_0x1c4295])return _0x1c4295;}else this[_0x5cf39f(0x426)]=_0x5bfe02[_0x5cf39f(0xb4d)]>=0x0?0x2:0x3,this['createDigits'](_0x3c9caa[_0x5cf39f(0xb4d)]);}const _0x4599b3=VisuMZ[_0x5cf39f(0x8a9)][_0x5cf39f(0xb57)]['Damage'][_0x5cf39f(0x255)][_0x5cf39f(0x41c)]()[_0x5cf39f(0xb45)]();if(VisuMZ[_0x5cf39f(0x8fc)][_0x4599b3])return _0x4599b3;return _0x5cf39f(0x4bf);},DataManager[_0xa8cad7(0x820)]=function(_0x1df3c3){const _0x121302=_0xa8cad7;_0x1df3c3=_0x1df3c3['toUpperCase']()[_0x121302(0xb45)](),this['_stypeIDs']=this[_0x121302(0xa22)]||{};if(this['_stypeIDs'][_0x1df3c3])return this['_stypeIDs'][_0x1df3c3];for(let _0x3434d7=0x1;_0x3434d7<0x64;_0x3434d7++){if(!$dataSystem[_0x121302(0x927)][_0x3434d7])continue;let _0x2dc61c=$dataSystem['skillTypes'][_0x3434d7][_0x121302(0x41c)]()[_0x121302(0xb45)]();_0x2dc61c=_0x2dc61c[_0x121302(0x536)](/\x1I\[(\d+)\]/gi,''),_0x2dc61c=_0x2dc61c['replace'](/\\I\[(\d+)\]/gi,''),this['_stypeIDs'][_0x2dc61c]=_0x3434d7;}return this[_0x121302(0xa22)][_0x1df3c3]||0x0;},DataManager[_0xa8cad7(0x1a9)]=function(_0x53321c){const _0x4ff57d=_0xa8cad7;_0x53321c=_0x53321c[_0x4ff57d(0x41c)]()['trim'](),this[_0x4ff57d(0x78d)]=this[_0x4ff57d(0x78d)]||{};if(this[_0x4ff57d(0x78d)][_0x53321c])return this[_0x4ff57d(0x78d)][_0x53321c];for(const _0xe1cb48 of $dataSkills){if(!_0xe1cb48)continue;this['_skillIDs'][_0xe1cb48['name']['toUpperCase']()[_0x4ff57d(0xb45)]()]=_0xe1cb48['id'];}return this[_0x4ff57d(0x78d)][_0x53321c]||0x0;},DataManager[_0xa8cad7(0x15b)]=function(_0x596c9e){const _0xf4b93f=_0xa8cad7;_0x596c9e=_0x596c9e[_0xf4b93f(0x41c)]()['trim'](),this[_0xf4b93f(0x313)]=this['_enemyIDs']||{};if(this[_0xf4b93f(0x313)][_0x596c9e])return this[_0xf4b93f(0x313)][_0x596c9e];for(const _0x28c320 of $dataEnemies){if(!_0x28c320)continue;this[_0xf4b93f(0x313)][_0x28c320['name'][_0xf4b93f(0x41c)]()[_0xf4b93f(0xb45)]()]=_0x28c320['id'];}return this[_0xf4b93f(0x313)][_0x596c9e]||0x0;},DataManager[_0xa8cad7(0x4e5)]=function(_0x25cd22){const _0x450627=_0xa8cad7;_0x25cd22=_0x25cd22[_0x450627(0x41c)]()['trim'](),this[_0x450627(0x78f)]=this[_0x450627(0x78f)]||{};if(this['_wtypeIDs'][_0x25cd22])return this[_0x450627(0x78f)][_0x25cd22];for(let _0x1b52e7=0x1;_0x1b52e7<0x64;_0x1b52e7++){if('LacxC'===_0x450627(0x4f6)){if(!$dataSystem[_0x450627(0x47e)][_0x1b52e7])continue;let _0x38f702=$dataSystem[_0x450627(0x47e)][_0x1b52e7][_0x450627(0x41c)]()[_0x450627(0xb45)]();_0x38f702=_0x38f702[_0x450627(0x536)](/\x1I\[(\d+)\]/gi,''),_0x38f702=_0x38f702[_0x450627(0x536)](/\\I\[(\d+)\]/gi,''),this[_0x450627(0x78f)][_0x38f702]=_0x1b52e7;}else return _0x2855ee['BattleCore'][_0x450627(0x93b)][_0x450627(0x9b5)](this);}return this[_0x450627(0x78f)][_0x450627(0x6b3)]=0x0,this[_0x450627(0x78f)][_0x25cd22]||0x0;},DataManager[_0xa8cad7(0x657)]=function(_0x5ba277){const _0x1e51a5=_0xa8cad7,_0x2c7dee=_0x1e51a5(0x71f);let _0x4da6f9=_0x5ba277['iconIndex'],_0x5beff9=_0x5ba277['name'];const _0x33f94e=_0x5ba277[_0x1e51a5(0x74f)];return _0x33f94e[_0x1e51a5(0x21d)](/<DISPLAY ICON: (\d+)>/i)&&(_0x1e51a5(0x514)!=='lCYNi'?_0x2659a5=_0xb61f29['x']+_0x2d783d[_0x1e51a5(0x3dd)]+0x8:_0x4da6f9=Number(RegExp['$1'])),_0x33f94e[_0x1e51a5(0x21d)](/<DISPLAY TEXT: (.*)>/i)&&('pBURR'===_0x1e51a5(0x270)?_0x5beff9=String(RegExp['$1']):(_0x16a685=_0x4dd301[_0x1e51a5(0x719)]/0x2,_0x12d55a=_0x975b75[_0x1e51a5(0x9ef)]/0x2)),_0x2c7dee['format'](_0x4da6f9,_0x5beff9);},DataManager['battleCommandName']=function(_0x1977d8){const _0x59a23e=_0xa8cad7;if(_0x1977d8[_0x59a23e(0x74f)][_0x59a23e(0x21d)](/<COMMAND TEXT: (.*)>/i))return String(RegExp['$1']);else{if(_0x59a23e(0x504)!==_0x59a23e(0x504)){this[_0x59a23e(0x643)]=_0x1f6e88['flashColor']||[0x0,0x0,0x0,0x0],this[_0x59a23e(0x643)]=_0x5300f[_0x59a23e(0x673)](this[_0x59a23e(0x643)]),this[_0x59a23e(0x24a)]=_0x51eedb['flashDuration']||0x0;const _0x19cedb=this[_0x59a23e(0x1ea)](),_0x24e9b5=_0x3504c8['floor'](_0x19cedb*0x1e),_0x1e54b8=this[_0x59a23e(0x2f1)](_0x24e9b5,_0x19cedb);_0x1e54b8[_0x59a23e(0x379)][_0x59a23e(0x968)]=_0x4cbe0e[_0x59a23e(0x7ff)](_0x1a61b8['textColor']),_0x1e54b8[_0x59a23e(0x379)][_0x59a23e(0x3e4)](_0x38d6a0,0x0,0x0,_0x24e9b5,_0x19cedb,'center'),_0x1e54b8['dy']=0x0;}else return _0x1977d8[_0x59a23e(0x9a6)];}},DataManager[_0xa8cad7(0x2a5)]=function(_0x4de877){const _0x1e255d=_0xa8cad7;if(_0x4de877[_0x1e255d(0x74f)][_0x1e255d(0x21d)](/<COMMAND ICON: (\d+)>/i)){if(_0x1e255d(0x2eb)!==_0x1e255d(0x2cf))return Number(RegExp['$1']);else{const _0x3bb0ab=_0x13c138[_0x1e255d(0x1ad)]();_0x3bb0ab[_0x1e255d(0x1a6)](this[_0x1e255d(0x9e9)][_0x1e255d(0x9b6)]()),this[_0x1e255d(0x7d5)]();}}else return _0x4de877[_0x1e255d(0x356)];},DataManager[_0xa8cad7(0x957)]=function(_0xe9afad){const _0x2886ee=_0xa8cad7,_0x46fb4b=$dataEnemies[_0xe9afad];if(_0x46fb4b){if('YGHfp'===_0x2886ee(0x13a)){if(_0x46fb4b[_0x2886ee(0x74f)]['match'](/<SWAP ENEMIES>\s*([\s\S]*)\s*<\/SWAP ENEMIES>/i)){if(_0x2886ee(0x85d)===_0x2886ee(0x2e1))_0x1af1f5[_0x2886ee(0x8a9)]['Window_BattleLog_performReflection'][_0x2886ee(0x9b5)](this,_0x147275),this['callNextMethod']();else{const _0xe5d9e9=String(RegExp['$1'])[_0x2886ee(0x136)](/[\r\n]+/)[_0x2886ee(0xafb)](''),_0x4fa7f3=this['processRandomizedData'](_0xe5d9e9);_0xe9afad=this['getEnemyIdWithName'](_0x4fa7f3)||_0xe9afad,_0xe9afad=DataManager['swapEnemyIDs'](_0xe9afad);}}}else{if(!_0x5ec886[_0x2886ee(0x45f)]())return;_0x51d10c[_0x2886ee(0x17f)](_0x5f2a2a,_0x5aa10d);const _0x161fb9=_0x116e40[_0x2886ee(0x95a)],_0x4a0fdf={'criticalHitRate':_0x46c330[_0x2886ee(0x5bf)],'criticalHitFlat':_0x50a9a6[_0x2886ee(0x965)],'criticalDmgRate':_0x528c9a[_0x2886ee(0xb14)],'criticalDmgFlat':_0x11953b[_0x2886ee(0x3d2)],'damageRate':_0x204b5d[_0x2886ee(0xb6f)],'damageFlat':_0x3d2afd[_0x2886ee(0x38f)],'hitRate':_0x5255f4[_0x2886ee(0x5e8)],'hitFlat':_0xd12f67[_0x2886ee(0x359)]};_0x161fb9['_multipliers']=_0x4a0fdf;}}return _0xe9afad;},DataManager[_0xa8cad7(0xa33)]=function(_0x26a6bc){const _0x21d8b0=_0xa8cad7;let _0x1a0443=0x0;const _0xcf901f={};for(const _0x5a8cd0 of _0x26a6bc){if(_0x21d8b0(0x846)===_0x21d8b0(0x846)){if(_0x5a8cd0['match'](/(.*):[ ](\d+)/i)){if(_0x21d8b0(0x243)===_0x21d8b0(0x243)){const _0x11c7c7=String(RegExp['$1'])['trim'](),_0xc793f8=Number(RegExp['$2']);_0xcf901f[_0x11c7c7]=_0xc793f8,_0x1a0443+=_0xc793f8;}else{this[_0x21d8b0(0x926)](_0x1c622a)[_0x21d8b0(0x21d)](/\\I\[(\d+)\]/i);const _0xc19e1e=_0x3969a3(_0x28f783['$1'])||0x0,_0x464d64=this[_0x21d8b0(0x511)](_0xcd63d7),_0x21190d=_0x464d64['x']+_0x320979[_0x21d8b0(0xb05)]((_0x464d64['width']-_0x1f6c74[_0x21d8b0(0x565)])/0x2),_0x22a85e=_0x464d64['y']+(_0x464d64[_0x21d8b0(0xa97)]-_0x1e8506[_0x21d8b0(0x65c)])/0x2;this[_0x21d8b0(0x77e)](_0xc19e1e,_0x21190d,_0x22a85e);}}else{if(_0x5a8cd0[_0x21d8b0(0x21d)](/(.*):[ ](\d+\.?\d+)/i)){const _0x3950f0=String(RegExp['$1'])[_0x21d8b0(0xb45)](),_0x1f8db2=Number(RegExp['$2']);_0xcf901f[_0x3950f0]=_0x1f8db2,_0x1a0443+=_0x1f8db2;}else{if(_0x5a8cd0!==''){if(_0x21d8b0(0x20b)!==_0x21d8b0(0x20b)){const _0x2e48ea=_0x172205['floor'](_0x450ea2['width']/0x3),_0x133369=this['isRightInputMode']()?(_0x1b0685[_0x21d8b0(0x960)]+_0x40974a['boxWidth'])/0x2-_0x2e48ea:(_0x17462c['width']-_0x348d2f[_0x21d8b0(0x719)])/-0x2,_0x315b1a=this[_0x21d8b0(0xb25)](),_0x329485=_0x315b1a['y']+_0x315b1a['height'],_0x5cd301=this['statusWindowRectBorderStyle'](),_0xbe4f1e=_0x5cd301['y']-_0x329485;return new _0x16f645(_0x133369,_0x329485,_0x2e48ea,_0xbe4f1e);}else _0xcf901f[_0x5a8cd0]=0x1,_0x1a0443++;}}}}else _0x578603=_0x65083d[_0x21d8b0(0x743)](_0x20a69b,_0x2e52cb);}if(_0x1a0443<=0x0)return'';let _0x2339bb=Math['random']()*_0x1a0443;for(const _0xfbba91 in _0xcf901f){_0x2339bb-=_0xcf901f[_0xfbba91];if(_0x2339bb<=0x0)return _0xfbba91;}return'';},DataManager[_0xa8cad7(0x583)]=function(_0x402f35){const _0x2cfcd7=_0xa8cad7;if(!_0x402f35)return![];if(!VisuMZ[_0x2cfcd7(0x8a9)][_0x2cfcd7(0xb57)][_0x2cfcd7(0x19d)][_0x2cfcd7(0x682)])return![];if(_0x402f35[_0x2cfcd7(0x74f)][_0x2cfcd7(0x21d)](/<AUTO ACTION SEQUENCE>/i))return![];if(_0x402f35['note'][_0x2cfcd7(0x21d)](/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi))return!![];for(const _0x486e08 of _0x402f35['effects']){if(!_0x486e08)continue;if(_0x486e08[_0x2cfcd7(0x325)]===Game_Action[_0x2cfcd7(0x370)])return!![];}return![];},DataManager[_0xa8cad7(0x9e2)]=function(_0x740255){const _0x1ccce1=_0xa8cad7,_0x45898e=$dataTroops[_0x740255];if(!_0x45898e)return'';let _0x45d4f1='';_0x45d4f1+=_0x45898e['name'];for(const _0x49978c of _0x45898e['pages']){for(const _0x2438c4 of _0x49978c[_0x1ccce1(0x8cb)]){if(_0x1ccce1(0x660)===_0x1ccce1(0x660))[0x6c,0x198][_0x1ccce1(0x220)](_0x2438c4[_0x1ccce1(0x325)])&&(_0x45d4f1+='\x0a',_0x45d4f1+=_0x2438c4['parameters'][0x0]);else return this[_0x1ccce1(0xae6)]()&&this[_0x1ccce1(0xae6)]()[_0x1ccce1(0x191)]()&&!this[_0x1ccce1(0xae6)]()['isMagicSkill']();}}return _0x45d4f1;},ConfigManager[_0xa8cad7(0x162)]=ConfigManager[_0xa8cad7(0x162)]??![],ConfigManager[_0xa8cad7(0x38d)]=ConfigManager[_0xa8cad7(0x38d)]??![],ConfigManager['visualHpGauge']=ConfigManager[_0xa8cad7(0x91a)]??!![],VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x304)]=ConfigManager[_0xa8cad7(0x8e6)],ConfigManager['makeData']=function(){const _0x533ea2=_0xa8cad7,_0x35f02c=VisuMZ[_0x533ea2(0x8a9)]['ConfigManager_makeData'][_0x533ea2(0x9b5)](this);return _0x35f02c['autoBattleAtStart']=this['autoBattleAtStart'],_0x35f02c[_0x533ea2(0x38d)]=this['autoBattleUseSkills'],_0x35f02c[_0x533ea2(0x91a)]=this['visualHpGauge'],_0x35f02c;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xb92)]=ConfigManager['applyData'],ConfigManager[_0xa8cad7(0x225)]=function(_0x2f545f){const _0x2d3cec=_0xa8cad7;VisuMZ['BattleCore'][_0x2d3cec(0xb92)]['call'](this,_0x2f545f);if(_0x2d3cec(0x162)in _0x2f545f)this['autoBattleAtStart']=_0x2f545f[_0x2d3cec(0x162)];else{if(_0x2d3cec(0x169)==='xptEF'){if(_0x2a9a82['type']===0x0)this['requestMotion'](_0x2d3cec(0x5ca));else{if(_0x1daa24[_0x2d3cec(0x4fb)]===0x1)this[_0x2d3cec(0x300)](_0x2d3cec(0x918));else _0x5d9292[_0x2d3cec(0x4fb)]===0x2&&this[_0x2d3cec(0x300)](_0x2d3cec(0xb79));}}else this[_0x2d3cec(0x162)]=![];}'autoBattleUseSkills'in _0x2f545f?this[_0x2d3cec(0x38d)]=_0x2f545f['autoBattleUseSkills']:this[_0x2d3cec(0x38d)]=![],_0x2d3cec(0x91a)in _0x2f545f?this[_0x2d3cec(0x91a)]=_0x2f545f[_0x2d3cec(0x91a)]:'uIoie'===_0x2d3cec(0x34a)?_0x27df2a+=(_0x6554e6[_0x2d3cec(0x960)]-_0x534eba)/0x2:this[_0x2d3cec(0x91a)]=!![];},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xa78)]=BattleManager['initMembers'],BattleManager['initMembers']=function(){const _0x45aad1=_0xa8cad7;VisuMZ[_0x45aad1(0x8a9)][_0x45aad1(0xa78)][_0x45aad1(0x9b5)](this),this['_forcedBattlers']=[];},BattleManager[_0xa8cad7(0x3da)]=function(){const _0x2ca9ba=_0xa8cad7;if(!SceneManager[_0x2ca9ba(0x45f)]())return;const _0x44767b=SceneManager[_0x2ca9ba(0x26b)][_0x2ca9ba(0x213)];if(_0x44767b)_0x44767b['requestRefresh']();},BattleManager['battleSys']=function(){const _0x3e2a42=_0xa8cad7;if(BattleManager[_0x3e2a42(0x9af)]())return _0x3e2a42(0x419);return'DTB';},BattleManager[_0xa8cad7(0x547)]=function(_0x5bc8f7){const _0x28243b=_0xa8cad7;return _0x5bc8f7=_0x5bc8f7[_0x28243b(0x41c)]()[_0x28243b(0xb45)](),this['battleSys']()===_0x5bc8f7;},BattleManager['isDTB']=function(){const _0xde325=_0xa8cad7;return this[_0xde325(0x547)](_0xde325(0x457));},BattleManager[_0xa8cad7(0x193)]=function(){const _0x1b1b3a=_0xa8cad7;return this[_0x1b1b3a(0x241)]();},BattleManager['isTickBased']=function(){return!this['isTurnBased']();},BattleManager[_0xa8cad7(0x36b)]=function(){const _0x49c909=_0xa8cad7;return!this[_0x49c909(0x193)]()&&!this[_0x49c909(0x172)]();},BattleManager[_0xa8cad7(0x75f)]=function(_0xfa407d){const _0x3ec80c=_0xa8cad7;$gameParty[_0x3ec80c(0x75f)](_0xfa407d),$gameTroop[_0x3ec80c(0x75f)](_0xfa407d);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x43d)]=BattleManager['startBattle'],BattleManager[_0xa8cad7(0x732)]=function(){const _0x51d25c=_0xa8cad7;this[_0x51d25c(0x2de)]=![],this[_0x51d25c(0xb41)]=ConfigManager[_0x51d25c(0x162)],this[_0x51d25c(0x75f)](_0x51d25c(0x7ee)),VisuMZ[_0x51d25c(0x8a9)][_0x51d25c(0x43d)]['call'](this),this['processBattleCoreJS'](_0x51d25c(0x630));},BattleManager['processPostBattleCommonEvents']=function(_0x109328){const _0x2af7e9=_0xa8cad7,_0x47103e=VisuMZ[_0x2af7e9(0x8a9)][_0x2af7e9(0xb57)][_0x2af7e9(0x5e4)];_0x47103e['BattleEndEvent']&&VisuMZ[_0x2af7e9(0x8a9)][_0x2af7e9(0x6b5)](_0x47103e[_0x2af7e9(0x8d3)])&&(_0x2af7e9(0xaa7)==='eLynb'?this[_0x2af7e9(0x248)]():$gameTemp[_0x2af7e9(0xa71)](_0x47103e['BattleEndEvent']));const _0x12dc2d=_0x2af7e9(0x4ea)[_0x2af7e9(0x69b)](_0x109328);_0x47103e[_0x12dc2d]&&VisuMZ['BattleCore']['CheckMapBattleEventValid'](_0x47103e[_0x12dc2d])&&$gameTemp[_0x2af7e9(0xa71)](_0x47103e[_0x12dc2d]);},VisuMZ['BattleCore'][_0xa8cad7(0x228)]=BattleManager['processVictory'],BattleManager[_0xa8cad7(0x8b5)]=function(){const _0x197e3b=_0xa8cad7;this[_0x197e3b(0x75f)](_0x197e3b(0x6a1)),VisuMZ[_0x197e3b(0x8a9)][_0x197e3b(0x228)][_0x197e3b(0x9b5)](this),this[_0x197e3b(0xa00)]('Victory');},VisuMZ['BattleCore']['BattleManager_processDefeat']=BattleManager[_0xa8cad7(0x385)],BattleManager[_0xa8cad7(0x385)]=function(){const _0x3af634=_0xa8cad7;this[_0x3af634(0x75f)](_0x3af634(0x5d0)),VisuMZ['BattleCore'][_0x3af634(0x6c7)][_0x3af634(0x9b5)](this),this[_0x3af634(0xa00)]('Defeat');},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xb3c)]=BattleManager[_0xa8cad7(0xa81)],BattleManager[_0xa8cad7(0xa81)]=function(_0xac247b){const _0xf4756e=_0xa8cad7;this[_0xf4756e(0x2de)]=!![],this[_0xf4756e(0xb41)]=![],this['processBattleCoreJS']('PreEndBattleJS'),VisuMZ[_0xf4756e(0x8a9)][_0xf4756e(0xb3c)][_0xf4756e(0x9b5)](this,_0xac247b),this[_0xf4756e(0x75f)]('PostEndBattleJS');},VisuMZ[_0xa8cad7(0x8a9)]['BattleManager_startTurn']=BattleManager[_0xa8cad7(0x6be)],BattleManager[_0xa8cad7(0x6be)]=function(){const _0x310457=_0xa8cad7;if(this[_0x310457(0x193)]())this['processBattleCoreJS'](_0x310457(0x8ca));VisuMZ[_0x310457(0x8a9)][_0x310457(0x48b)]['call'](this);if(this['isTurnBased']())this[_0x310457(0x75f)](_0x310457(0xada));},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xab6)]=BattleManager[_0xa8cad7(0xb38)],BattleManager[_0xa8cad7(0xb38)]=function(){const _0x5c5b93=_0xa8cad7,_0x451ac0=this[_0x5c5b93(0x4d4)]['currentAction'](),_0x47ce4a=this['_subject'];_0x451ac0&&_0x451ac0[_0x5c5b93(0x222)]()===_0x47ce4a&&_0x451ac0[_0x5c5b93(0xa95)](_0x5c5b93(0x979)),VisuMZ['BattleCore'][_0x5c5b93(0xab6)][_0x5c5b93(0x9b5)](this),_0x451ac0&&_0x451ac0[_0x5c5b93(0x222)]()===_0x47ce4a&&_0x451ac0[_0x5c5b93(0xa95)]('PostStartActionJS');},VisuMZ['BattleCore'][_0xa8cad7(0x3c8)]=BattleManager[_0xa8cad7(0x5ce)],BattleManager[_0xa8cad7(0x5ce)]=function(){const _0xbd7b19=_0xa8cad7,_0x13b9ac=this[_0xbd7b19(0x95a)],_0xb970a8=this[_0xbd7b19(0x4d4)];_0x13b9ac&&_0x13b9ac!==this[_0xbd7b19(0x49a)]&&_0x13b9ac['subject']()===_0xb970a8&&('FQWlg'===_0xbd7b19(0x95c)?_0x13b9ac[_0xbd7b19(0xa95)](_0xbd7b19(0x4ed)):_0x488b5c[_0xbd7b19(0x4d2)](_0xbd7b19(0xb3a),this[_0xbd7b19(0x588)][_0xbd7b19(0x66e)](this))),VisuMZ[_0xbd7b19(0x8a9)][_0xbd7b19(0x3c8)]['call'](this),_0x13b9ac&&_0x13b9ac!==this[_0xbd7b19(0x49a)]&&_0x13b9ac[_0xbd7b19(0x222)]()===_0xb970a8&&_0x13b9ac[_0xbd7b19(0xa95)]('PostEndActionJS'),this[_0xbd7b19(0x780)](this['allBattleMembers']()),this[_0xbd7b19(0x49a)]=this[_0xbd7b19(0x95a)];},BattleManager[_0xa8cad7(0x780)]=function(_0x5e8c74){const _0x397000=_0xa8cad7;for(const _0x2bff60 of _0x5e8c74){if(!_0x2bff60)continue;if(!_0x2bff60[_0x397000(0xac0)]())continue;_0x2bff60[_0x397000(0xac0)]()[_0x397000(0x117)]();}},BattleManager[_0xa8cad7(0x984)]=function(){const _0x35e1c4=_0xa8cad7;!this[_0x35e1c4(0x896)]['isBusy']()&&this[_0x35e1c4(0x5ce)]();},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x8e4)]=function(){const _0xba7e35=_0xa8cad7;this[_0xba7e35(0xb3d)]();if(Imported['VisuMZ_1_SkillsStatesCore']){const _0x56f73b=VisuMZ['SkillsStatesCore'][_0xba7e35(0xb57)][_0xba7e35(0x2a3)];_0x56f73b&&_0x56f73b['ActionEndUpdate']===![]&&this[_0xba7e35(0x174)](0x1);}else this[_0xba7e35(0x174)](0x1);this[_0xba7e35(0x9ba)]();},BattleManager['makeEscapeRatio']=function(){const _0x48a17a=_0xa8cad7;this[_0x48a17a(0x3c4)]=VisuMZ[_0x48a17a(0x8a9)][_0x48a17a(0xb57)][_0x48a17a(0x5e4)][_0x48a17a(0x845)][_0x48a17a(0x9b5)](this);},VisuMZ[_0xa8cad7(0x8a9)]['BattleManager_onEscapeSuccess']=BattleManager[_0xa8cad7(0xb09)],BattleManager[_0xa8cad7(0xb09)]=function(){const _0x528fe5=_0xa8cad7;this[_0x528fe5(0x75f)](_0x528fe5(0x7e4)),BattleManager['_spriteset']['processEscape'](),VisuMZ[_0x528fe5(0x8a9)]['BattleManager_onEscapeSuccess']['call'](this),this[_0x528fe5(0xa00)](_0x528fe5(0x92f));},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xb7a)]=BattleManager[_0xa8cad7(0xb59)],BattleManager[_0xa8cad7(0xb59)]=function(){const _0x5084a2=_0xa8cad7;this[_0x5084a2(0x75f)](_0x5084a2(0x581));const _0x27ff14=this[_0x5084a2(0x3c4)];VisuMZ[_0x5084a2(0x8a9)][_0x5084a2(0xb7a)]['call'](this),this[_0x5084a2(0x3c4)]=_0x27ff14+VisuMZ[_0x5084a2(0x8a9)][_0x5084a2(0xb57)]['Mechanics'][_0x5084a2(0x145)][_0x5084a2(0x9b5)](this),this['processPostBattleCommonEvents'](_0x5084a2(0x318));},BattleManager[_0xa8cad7(0x8f2)]=function(){const _0x4d0b34=_0xa8cad7;let _0x4ff1de=![];if(this[_0x4d0b34(0x32c)]()){if(_0x4d0b34(0x84b)!==_0x4d0b34(0xaf3))for(const _0x3713b7 of $gameTroop['enemyNames']()){this[_0x4d0b34(0x896)]['push'](_0x4d0b34(0xa27),TextManager[_0x4d0b34(0x290)][_0x4d0b34(0x69b)](_0x3713b7)),this[_0x4d0b34(0x896)][_0x4d0b34(0x6c0)](_0x4d0b34(0x4ab)),_0x4ff1de=!![];}else _0x197bcc[_0x4d0b34(0x8a9)]['Sprite_Enemy_setBattler'][_0x4d0b34(0x9b5)](this,_0x527f24),this[_0x4d0b34(0xae7)](_0x287f97);}if(this[_0x4d0b34(0x519)])_0x4d0b34(0x591)===_0x4d0b34(0x856)?_0x5058b1[_0x4d0b34(0x6c0)](_0x4d0b34(0x256),_0x278285):(this['_logWindow'][_0x4d0b34(0x6c0)](_0x4d0b34(0xa27),TextManager['preemptive'][_0x4d0b34(0x69b)]($gameParty[_0x4d0b34(0x9a6)]())),this['_logWindow']['push']('wait'));else{if(this[_0x4d0b34(0x66a)]){if(_0x4d0b34(0x44b)!==_0x4d0b34(0x31e))this[_0x4d0b34(0x896)][_0x4d0b34(0x6c0)](_0x4d0b34(0xa27),TextManager[_0x4d0b34(0x801)][_0x4d0b34(0x69b)]($gameParty[_0x4d0b34(0x9a6)]())),this[_0x4d0b34(0x896)][_0x4d0b34(0x6c0)](_0x4d0b34(0x4ab));else{if(!_0x363d10[_0x4d0b34(0x1d3)]())return;const _0x116014=this[_0x4d0b34(0xac0)]();if(!_0x116014)return;_0x11c665=_0x402f56||0x0;if(_0x2f7aed>0x0){if(_0x116014[_0x4d0b34(0x7c5)]>_0x475793)_0x218da4+=_0x116014[_0x4d0b34(0x960)]/0x2+_0x4e4a66;if(_0x116014[_0x4d0b34(0x7c5)]<_0xcee5c6)_0x44b583-=_0x116014[_0x4d0b34(0x960)]/0x2+_0x32b7c8;}if(_0x2bcbc9)this['setBattlerFacePoint'](_0x290e18,_0x3c21f1,![]);_0x4a8d97-=_0x116014[_0x4d0b34(0xab8)],_0x37a34a-=_0x116014[_0x4d0b34(0x4e0)],_0x116014[_0x4d0b34(0x655)](_0x2a8390,_0x3d4ec9,_0x14f19c);if(_0x2e2ae7[_0x4d0b34(0x8a4)])_0x116014[_0x4d0b34(0x44d)](_0x2a6b2f||_0x4d0b34(0x9bc));}}}if(_0x4ff1de){if(_0x4d0b34(0xa94)!=='SqXMT')return _0x59d5ef[_0x4d0b34(0x8a9)][_0x4d0b34(0xb57)]['AutoBattle'][_0x4d0b34(0x838)];else this[_0x4d0b34(0x896)][_0x4d0b34(0x6c0)](_0x4d0b34(0x4ab)),this[_0x4d0b34(0x896)][_0x4d0b34(0x6c0)](_0x4d0b34(0x711));}this[_0x4d0b34(0x9af)]()&&this[_0x4d0b34(0x221)]()&&(this[_0x4d0b34(0x1af)]=![]);},BattleManager[_0xa8cad7(0x32c)]=function(){const _0xa9e839=_0xa8cad7;if(BattleManager[_0xa9e839(0xb41)])return![];return VisuMZ['BattleCore']['Settings'][_0xa9e839(0x8d5)][_0xa9e839(0x3c2)];},VisuMZ['BattleCore'][_0xa8cad7(0x20d)]=BattleManager[_0xa8cad7(0x7d6)],BattleManager[_0xa8cad7(0x7d6)]=function(){const _0x5d487a=_0xa8cad7;VisuMZ[_0x5d487a(0x8a9)]['BattleManager_startInput'][_0x5d487a(0x9b5)](this),this[_0x5d487a(0x241)]()&&this[_0x5d487a(0x221)]()&&!this[_0x5d487a(0x66a)]&&$gameParty[_0x5d487a(0x1bd)]()&&(_0x5d487a(0x501)!=='lwFnn'?_0x15dc35['push'](_0x5d487a(0x375),_0x344c2e,_0x3e6913):this[_0x5d487a(0x1aa)]());},BattleManager['isSkipPartyCommandWindow']=function(){const _0x40c552=_0xa8cad7;return VisuMZ[_0x40c552(0x8a9)][_0x40c552(0xb57)]['PartyCmd']['SkipPartyCmd'];},BattleManager[_0xa8cad7(0x3b7)]=function(){const _0x43e781=_0xa8cad7;this[_0x43e781(0x358)]()&&this[_0x43e781(0x1aa)]();},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x757)]=Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x9ab)],Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x9ab)]=function(){const _0x3e26c7=_0xa8cad7;VisuMZ[_0x3e26c7(0x8a9)][_0x3e26c7(0x757)][_0x3e26c7(0x9b5)](this),BattleManager[_0x3e26c7(0x9af)]()&&BattleManager[_0x3e26c7(0x1af)]&&(_0x3e26c7(0x328)==='vltsD'?(_0x2f820d[_0x3e26c7(0x8a9)]['ParseClassNotetags']&&_0xd2fd38[_0x3e26c7(0x8a9)][_0x3e26c7(0x823)][_0x3e26c7(0x9b5)](this,_0x55827d),_0x205769[_0x3e26c7(0x8a9)][_0x3e26c7(0x477)](_0x433cd8)):(BattleManager[_0x3e26c7(0x1af)]=![],this['actorCommandCancelTPB']()));},BattleManager['invokeMagicReflection']=function(_0x5afda0,_0x387cf9){const _0x4b52f2=_0xa8cad7;this[_0x4b52f2(0x95a)][_0x4b52f2(0x33a)]=_0x387cf9,this[_0x4b52f2(0x896)][_0x4b52f2(0x8e8)](_0x387cf9),this[_0x4b52f2(0x896)][_0x4b52f2(0x17b)](_0x5afda0,this['_action']),this[_0x4b52f2(0x95a)]['apply'](_0x5afda0),this[_0x4b52f2(0x896)][_0x4b52f2(0x61f)](_0x5afda0,_0x5afda0);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x836)]=BattleManager[_0xa8cad7(0x728)],BattleManager['makeActionOrders']=function(){const _0xcbb543=_0xa8cad7;VisuMZ['BattleCore'][_0xcbb543(0x836)][_0xcbb543(0x9b5)](this),this[_0xcbb543(0xa53)]=this['_actionBattlers']['filter'](_0x1d45a3=>_0x1d45a3&&_0x1d45a3[_0xcbb543(0x8b7)]());},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x60f)]=BattleManager[_0xa8cad7(0x7bf)],BattleManager['updatePhase']=function(_0x16f957){const _0xd1e439=_0xa8cad7;if(this['_phase']===_0xd1e439(0x137))this[_0xd1e439(0x659)]();else this[_0xd1e439(0x6ab)]===_0xd1e439(0x714)?_0xd1e439(0x18b)!=='VEdOl'?(this[_0xd1e439(0x8fe)]=new _0x20da11(),this[_0xd1e439(0x3ec)]['addChild'](this[_0xd1e439(0x8fe)])):this[_0xd1e439(0x74c)]():_0xd1e439(0x613)!==_0xd1e439(0x613)?_0xc612ed[_0xd1e439(0xa71)](_0x485b88):VisuMZ[_0xd1e439(0x8a9)][_0xd1e439(0x60f)][_0xd1e439(0x9b5)](this,_0x16f957);},BattleManager[_0xa8cad7(0x46d)]=function(){const _0x2ad9fe=_0xa8cad7;this['_allTargets']=this[_0x2ad9fe(0x789)][_0x2ad9fe(0x91f)](0x0),this['_targetIndex']=0x0,this['_target']=this['_allTargets'][0x0]||null,this[_0x2ad9fe(0x6ab)]='custom';},BattleManager[_0xa8cad7(0x659)]=function(){const _0x1e4714=_0xa8cad7;!this[_0x1e4714(0xb75)]()&&!this[_0x1e4714(0x896)][_0x1e4714(0xb15)]()&&(this[_0x1e4714(0x6ab)]=_0x1e4714(0x1b6));},BattleManager[_0xa8cad7(0x714)]=function(_0x2350c7){const _0x284eb1=_0xa8cad7;this['_actionBattlers'][_0x284eb1(0xafb)](_0x2350c7);if(_0x2350c7===this[_0x284eb1(0x4d4)])return;const _0x242543=JsonEx['makeDeepCopy'](_0x2350c7['currentAction']());this[_0x284eb1(0xb86)][_0x284eb1(0x6c0)]([_0x2350c7,_0x242543]);},BattleManager[_0xa8cad7(0x41e)]=function(){},BattleManager[_0xa8cad7(0x354)]=function(){const _0x45c3a8=_0xa8cad7;if(this[_0x45c3a8(0x9af)]())this[_0x45c3a8(0x6ab)]='turn';else this[_0x45c3a8(0xb86)][_0x45c3a8(0x19c)]>0x0?this[_0x45c3a8(0x6ab)]=_0x45c3a8(0x495):this[_0x45c3a8(0x7d6)]();},BattleManager['getNextSubject']=function(){const _0x5f0127=_0xa8cad7,_0x546edb=this['_subject'];_0x546edb&&this[_0x5f0127(0x9af)]()&&_0x546edb['setActionState'](_0x5f0127(0x706));for(;;){const _0x328179=this['getNextSubjectFromPool']();if(!_0x328179)return null;if(_0x328179[_0x5f0127(0x7b0)]()&&_0x328179['isAlive']())return _0x328179;}},BattleManager[_0xa8cad7(0x8c5)]=function(){const _0x5c912c=_0xa8cad7;if(this[_0x5c912c(0xb86)][_0x5c912c(0x19c)]>0x0){const _0xd79b19=this[_0x5c912c(0xb86)][_0x5c912c(0x287)](),_0x18a45b=_0xd79b19[0x0];return _0x18a45b['_actions']=_0x18a45b['_actions']||[],_0x18a45b[_0x5c912c(0x124)][0x0]=_0xd79b19[0x1],_0x18a45b;}else return this[_0x5c912c(0xa53)][_0x5c912c(0x287)]();},VisuMZ[_0xa8cad7(0x8a9)]['Game_Battler_forceAction']=Game_Battler['prototype']['forceAction'],Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x714)]=function(_0x35d779,_0x1c124b){const _0x262416=_0xa8cad7;VisuMZ[_0x262416(0x8a9)]['Game_Battler_forceAction'][_0x262416(0x9b5)](this,_0x35d779,_0x1c124b),this[_0x262416(0x124)][this[_0x262416(0x124)][_0x262416(0x19c)]-0x1][_0x262416(0x5d2)]=!![];},Game_Interpreter['prototype'][_0xa8cad7(0x814)]=function(_0x10bb44){const _0x5686c3=_0xa8cad7;return this[_0x5686c3(0x582)](_0x10bb44[0x0],_0x10bb44[0x1],_0x386955=>{const _0x18d1e9=_0x5686c3;_0x18d1e9(0x312)==='fCmHZ'?!_0x386955[_0x18d1e9(0x89b)]()&&(_0x386955['forceAction'](_0x10bb44[0x2],_0x10bb44[0x3]),BattleManager[_0x18d1e9(0x714)](_0x386955)):(this[_0x18d1e9(0x494)]=this[_0x18d1e9(0x8d1)],this[_0x18d1e9(0x67c)]=this['_targetGrowY']);}),!![];},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x978)]=Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x86d)],Game_Battler['prototype']['makeSpeed']=function(){const _0x503738=_0xa8cad7;VisuMZ[_0x503738(0x8a9)]['Game_Battler_makeSpeed']['call'](this);if(this['_actions'][_0x503738(0x19c)]<=0x0){if('PacWT'!==_0x503738(0x93c))this[_0x503738(0xa6e)]=Number['MIN_SAFE_INTEGER'];else return this['_damagePopupArray'][_0x503738(0x7be)]();}},VisuMZ[_0xa8cad7(0x8a9)]['BattleManager_selectNextCommand']=BattleManager[_0xa8cad7(0x1aa)],BattleManager[_0xa8cad7(0x1aa)]=function(){const _0x35435d=_0xa8cad7;this[_0x35435d(0x9af)]()?this[_0x35435d(0x699)]():VisuMZ[_0x35435d(0x8a9)][_0x35435d(0x652)][_0x35435d(0x9b5)](this);},BattleManager[_0xa8cad7(0x699)]=function(){const _0x43a565=_0xa8cad7;if(this[_0x43a565(0xa1b)]){if(this[_0x43a565(0xa1b)][_0x43a565(0x1aa)]()){if(_0x43a565(0x1e4)!==_0x43a565(0x1e4))_0x56e56c=(_0x2187b2+_0x628226)/0x2;else return;}this['finishActorInput'](),this[_0x43a565(0x414)](),!this[_0x43a565(0x4d4)]&&!this[_0x43a565(0xa1b)]&&SceneManager[_0x43a565(0x26b)]['updateBattleProcess']();}else!this[_0x43a565(0x4d4)]&&this[_0x43a565(0x783)]();},BattleManager[_0xa8cad7(0x414)]=function(){const _0x2d2151=_0xa8cad7;if(!this[_0x2d2151(0x358)]()||this[_0x2d2151(0xa43)]()){this[_0x2d2151(0xb6b)]&&(!$gameParty[_0x2d2151(0x321)]()[_0x2d2151(0x220)](this[_0x2d2151(0xb6b)])&&(this[_0x2d2151(0xb6b)]=null));if(!this['_tpbSceneChangeCacheActor']){if(_0x2d2151(0x626)!=='cTMjE'){const _0x2d7481=new _0x4fec10(_0x1b402b);this[_0x2d2151(0x493)]['addChild'](_0x2d7481);}else this[_0x2d2151(0xa49)](),this[_0x2d2151(0xa1b)]=null,this[_0x2d2151(0x362)]=![];}else this[_0x2d2151(0x486)]();}},BattleManager[_0xa8cad7(0x486)]=function(){const _0x1b9b56=_0xa8cad7;!$gameParty[_0x1b9b56(0x321)]()['includes'](this[_0x1b9b56(0xb6b)])&&('duRZF'===_0x1b9b56(0x31c)?_0x3bdf40[_0x1b9b56(0x379)]=new _0x49c168(this['width'],this[_0x1b9b56(0xa97)]):this[_0x1b9b56(0xb6b)]=null);if(this[_0x1b9b56(0xb6b)]){if(_0x1b9b56(0x9a9)!==_0x1b9b56(0x8b8))this[_0x1b9b56(0xa1b)]=this['_tpbSceneChangeCacheActor'],this[_0x1b9b56(0xa1b)][_0x1b9b56(0x16e)]='charged',this[_0x1b9b56(0x362)]=!![],this[_0x1b9b56(0xb6b)]=null;else{const _0x55f065=_0x40ddbf[_0x1b9b56(0xb36)]?_0x1a465b[_0x1b9b56(0x37f)][_0x1b9b56(0xb57)][_0x1b9b56(0x69e)]:_0x1b9f69[_0x1b9b56(0x8a9)][_0x1b9b56(0xb57)][_0x1b9b56(0x327)],_0x2b5cac=_0x17642d['magicSkills']['includes'](_0x5c429b),_0x2c8940=_0x2b5cac?_0x55f065[_0x1b9b56(0x53d)]:_0x55f065['IconStypeNorm'];_0x1d029d='\x5cI[%1]%2'[_0x1b9b56(0x69b)](_0x2c8940,_0x2a6c15);}}else this[_0x1b9b56(0xa49)](),this['_currentActor']=null,this['_inputting']=![];},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x93b)]=BattleManager[_0xa8cad7(0x64f)],BattleManager['isTpbMainPhase']=function(){const _0x128638=_0xa8cad7;if(this['_phase']===_0x128638(0x137))return this[_0x128638(0x891)]();else{if(_0x128638(0x239)===_0x128638(0x6bb))_0x565edd[_0x128638(0x242)](),_0x4ba92e['_autoBattle']=![],_0x2c111d[_0x128638(0x711)](),_0x530ccc[_0x128638(0x711)]();else return VisuMZ['BattleCore']['BattleManager_isTpbMainPhase'][_0x128638(0x9b5)](this);}},BattleManager[_0xa8cad7(0x891)]=function(){const _0x74d7b1=_0xa8cad7;return this[_0x74d7b1(0x6d5)]();},VisuMZ['BattleCore'][_0xa8cad7(0xb0b)]=BattleManager[_0xa8cad7(0xa49)],BattleManager[_0xa8cad7(0xa49)]=function(){const _0x283489=_0xa8cad7;this['isTpb']()&&this[_0x283489(0x6ab)]===_0x283489(0x546)&&(this['_currentActor']=null),VisuMZ[_0x283489(0x8a9)][_0x283489(0xb0b)][_0x283489(0x9b5)](this);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x710)]=BattleManager[_0xa8cad7(0x1ad)],BattleManager[_0xa8cad7(0x1ad)]=function(){const _0x242a63=_0xa8cad7,_0x48aaf9=this[_0x242a63(0xa1b)];if(_0x48aaf9&&!_0x48aaf9['inputtingAction']()){if('XrWAZ'==='qLMHD')return _0x15fb9c(_0x78af49['$1'])['split'](/[\r\n]+/);else{const _0x5e5817=_0x48aaf9[_0x242a63(0xb07)];_0x48aaf9[_0x242a63(0x124)][_0x5e5817]=new Game_Action(_0x48aaf9);}}return VisuMZ[_0x242a63(0x8a9)][_0x242a63(0x710)][_0x242a63(0x9b5)](this);},SceneManager[_0xa8cad7(0x45f)]=function(){const _0x204d32=_0xa8cad7;return this[_0x204d32(0x26b)]&&this['_scene']['constructor']===Scene_Battle;},SceneManager[_0xa8cad7(0xb26)]=function(){const _0x4f1de6=_0xa8cad7;return Spriteset_Battle[_0x4f1de6(0xa60)]['isFlipped']();},SceneManager[_0xa8cad7(0x455)]=function(){if(SceneManager['isPreviousScene'](Scene_Options))return!![];return![];},SceneManager[_0xa8cad7(0x991)]=function(){const _0x273e07=_0xa8cad7;if(SceneManager[_0x273e07(0x4cf)](Scene_Options))return!![];return![];},SceneManager[_0xa8cad7(0x2a6)]=function(_0x5937bc){const _0x2f4551=_0xa8cad7;if(!SceneManager[_0x2f4551(0x45f)]())return!![];const _0x52809e=[_0x2f4551(0x9d7),'Scene_Party'];return _0x52809e['includes'](_0x5937bc[_0x2f4551(0x9a6)]);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x4db)]=SceneManager[_0xa8cad7(0x6c0)],SceneManager['push']=function(_0x2d68d2){const _0x177deb=_0xa8cad7;if(!SceneManager[_0x177deb(0x2a6)](_0x2d68d2))return this[_0x177deb(0x90b)](_0x2d68d2);VisuMZ[_0x177deb(0x8a9)][_0x177deb(0x4db)][_0x177deb(0x9b5)](this,_0x2d68d2);},SceneManager[_0xa8cad7(0x90b)]=function(_0x247792){const _0x48fd16=_0xa8cad7;if(!$gameTemp[_0x48fd16(0x36c)]())return;if(this[_0x48fd16(0x466)])return;this[_0x48fd16(0x466)]=!![];let _0xde5ae9='';_0xde5ae9+='VisuMZ_1_BattleCore\x20does\x20NOT\x20support\x20changing',_0xde5ae9+=_0x48fd16(0xaca)[_0x48fd16(0x69b)](_0x247792[_0x48fd16(0x9a6)]),alert(_0xde5ae9);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x454)]=Game_Temp[_0xa8cad7(0xa60)][_0xa8cad7(0xb16)],Game_Temp[_0xa8cad7(0xa60)]['requestAnimation']=function(_0x37e7a5,_0x410b21,_0x44a719){const _0xdfb146=_0xa8cad7;_0x37e7a5=_0x37e7a5[_0xdfb146(0x1d2)]((_0x12b855,_0x49adcd,_0x5ee343)=>_0x5ee343[_0xdfb146(0x153)](_0x12b855)===_0x49adcd),SceneManager[_0xdfb146(0x45f)]()&&SceneManager['isBattleFlipped']()&&(_0xdfb146(0x34f)!=='gmDMS'?(this[_0xdfb146(0x494)]=this[_0xdfb146(0x59f)](this[_0xdfb146(0x494)],this[_0xdfb146(0x8d1)],_0x25f7d6,_0x3cc16f,_0x285480),this[_0xdfb146(0x67c)]=this[_0xdfb146(0x59f)](this[_0xdfb146(0x67c)],this[_0xdfb146(0x5fd)],_0xef6b64,_0x64731d,_0x1dcd3a)):_0x44a719=!_0x44a719),VisuMZ[_0xdfb146(0x8a9)][_0xdfb146(0x454)][_0xdfb146(0x9b5)](this,_0x37e7a5,_0x410b21,_0x44a719),SceneManager[_0xdfb146(0x45f)]()&&BattleManager[_0xdfb146(0x726)][_0xdfb146(0x8f7)]();},Game_Temp[_0xa8cad7(0xa60)][_0xa8cad7(0x2fd)]=function(_0x52817b){const _0xc24d4e=_0xa8cad7;this[_0xc24d4e(0x3a8)]=_0x52817b;},Game_Temp[_0xa8cad7(0xa60)]['getLastPluginCommandInterpreter']=function(){const _0x42be58=_0xa8cad7;return this[_0x42be58(0x3a8)];},Game_Temp[_0xa8cad7(0xa60)][_0xa8cad7(0x999)]=function(){const _0x3ba588=_0xa8cad7;this[_0x3ba588(0x81e)]=undefined;},Game_Temp['prototype'][_0xa8cad7(0xb42)]=function(_0x322f7a){const _0x566486=_0xa8cad7;if($gameMap&&$dataMap&&$dataMap['note']){if(_0x566486(0x88b)===_0x566486(0x78a))return _0x41f2ac[_0x566486(0xa60)][_0x566486(0x1eb)][_0x566486(0x9b5)](this)&&this[_0x566486(0xa08)]();else this[_0x566486(0x875)]($dataMap[_0x566486(0x74f)]);}const _0x16f6b0=$dataTroops[_0x322f7a];if(_0x16f6b0){let _0x221204=DataManager[_0x566486(0x9e2)](_0x16f6b0['id']);this[_0x566486(0x875)](_0x221204);}},Game_Temp[_0xa8cad7(0xa60)][_0xa8cad7(0x875)]=function(_0x52b09a){const _0x4678d2=_0xa8cad7;if(!_0x52b09a)return;if(_0x52b09a[_0x4678d2(0x21d)](/<(?:BATTLELAYOUT|BATTLE LAYOUT|LAYOUT):[ ](.*)>/i)){if(_0x4678d2(0x2ff)!==_0x4678d2(0x2ff))return _0x523f48[_0x4678d2(0x8a9)][_0x4678d2(0xb8d)][_0x4678d2(0x9b5)](this);else{const _0x4ee9ec=String(RegExp['$1']);if(_0x4ee9ec[_0x4678d2(0x21d)](/DEFAULT/i))this[_0x4678d2(0x81e)]=_0x4678d2(0x7ae);else{if(_0x4ee9ec[_0x4678d2(0x21d)](/LIST/i))_0x4678d2(0xa9a)===_0x4678d2(0xa2c)?(this[_0x4678d2(0x9e7)](),this['addAutoBattleCommand'](),this[_0x4678d2(0x91d)](),this[_0x4678d2(0x3e9)](),this[_0x4678d2(0x389)]()):this['_forcedBattleLayout']=_0x4678d2(0x8cb);else{if(_0x4ee9ec[_0x4678d2(0x21d)](/XP/i)){if(_0x4678d2(0x29b)!==_0x4678d2(0x29b)){let _0x6f0589=_0xd66a9d[_0x4678d2(0xa9e)](_0x2f3aac[_0x4678d2(0x65f)]);_0x243eb4[_0x4678d2(0x3e5)]>0x0&&(_0x6f0589+=_0x2f51d5['abs'](_0x351277[_0x4678d2(0x3e5)])),_0x3c529a[_0x4678d2(0x200)](_0x12fbfc[_0x4678d2(0x65f)],_0x6f0589);}else this[_0x4678d2(0x81e)]='xp';}else{if(_0x4ee9ec['match'](/PORTRAIT/i))this[_0x4678d2(0x81e)]='portrait';else{if(_0x4ee9ec[_0x4678d2(0x21d)](/BORDER/i)){if(_0x4678d2(0x22b)==='PHwOw')return _0x915319[_0x4678d2(0x81e)];else this[_0x4678d2(0x81e)]=_0x4678d2(0xb48);}else _0x4ee9ec[_0x4678d2(0x21d)](/(?:SIDEVIEW UI|SIDEVIEW)/i)&&(Imported[_0x4678d2(0x8f5)]?this[_0x4678d2(0x81e)]=_0x4678d2(0x2c4):this[_0x4678d2(0x81e)]=_0x4678d2(0x7ae));}}}}}}},VisuMZ['BattleCore'][_0xa8cad7(0x1e3)]=Game_System[_0xa8cad7(0xa60)][_0xa8cad7(0x4a7)],Game_System[_0xa8cad7(0xa60)]['initialize']=function(){const _0x28b5d6=_0xa8cad7;VisuMZ[_0x28b5d6(0x8a9)][_0x28b5d6(0x1e3)][_0x28b5d6(0x9b5)](this),this['initBattleCore']();},Game_System[_0xa8cad7(0xa60)][_0xa8cad7(0x865)]=function(){const _0x1d4dc3=_0xa8cad7;this[_0x1d4dc3(0x43c)]=this['_defeatedEnemies']||[];},Game_System[_0xa8cad7(0xa60)][_0xa8cad7(0xa79)]=function(){const _0x5f2ded=_0xa8cad7;if(this[_0x5f2ded(0x43c)]===undefined)this[_0x5f2ded(0x865)]();return this[_0x5f2ded(0x43c)];},Game_System['prototype'][_0xa8cad7(0x1fe)]=function(_0x4a7dce){const _0x4a67db=_0xa8cad7;if(this[_0x4a67db(0x43c)]===undefined)this[_0x4a67db(0x865)]();if(!_0x4a7dce)return;if(this[_0x4a67db(0x43c)]['includes'](_0x4a7dce))return;this[_0x4a67db(0x43c)][_0x4a67db(0x6c0)](_0x4a7dce),this['_defeatedEnemies']['sort']((_0x555f10,_0x103891)=>_0x555f10-_0x103891);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x722)]=Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x6ac)],Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x6ac)]=function(_0x4838e5){const _0x13a815=_0xa8cad7,_0x84e945=this[_0x13a815(0xab1)](),_0x3efded=this[_0x13a815(0x2b9)]();VisuMZ['BattleCore'][_0x13a815(0x722)][_0x13a815(0x9b5)](this,_0x4838e5),this['isEnemy']()&&_0x84e945&&this[_0x13a815(0xb06)]()&&(this[_0x13a815(0xaa1)]=!this['hasBeenDefeatedBefore'](),$gameSystem[_0x13a815(0x1fe)](this[_0x13a815(0x956)]())),SceneManager[_0x13a815(0x45f)]()&&_0x3efded!==this['stateMotionIndex']()&&(this[_0x13a815(0xac0)]()&&this[_0x13a815(0xac0)]()[_0x13a815(0x117)]());},Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x316)]=function(){const _0x568bae=_0xa8cad7;return $gameSystem['getDefeatedEnemies']()[_0x568bae(0x220)](this[_0x568bae(0x156)]);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x6ea)]=Game_BattlerBase['prototype']['eraseState'],Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x526)]=function(_0x1be6c8){const _0x2369ac=_0xa8cad7;VisuMZ['BattleCore']['Game_BattlerBase_eraseState'][_0x2369ac(0x9b5)](this,_0x1be6c8),this[_0x2369ac(0x31f)]()&&_0x1be6c8===this['deathStateId']()&&this[_0x2369ac(0xab1)]()&&(this[_0x2369ac(0xaa1)]=![]),!this[_0x2369ac(0x57e)]&&!this[_0x2369ac(0xaef)]&&SceneManager[_0x2369ac(0x45f)]()&&this[_0x2369ac(0x3cf)]();},VisuMZ[_0xa8cad7(0x8a9)]['Game_Action_clear']=Game_Action['prototype'][_0xa8cad7(0x711)],Game_Action['prototype']['clear']=function(){const _0x4a8912=_0xa8cad7;VisuMZ['BattleCore']['Game_Action_clear'][_0x4a8912(0x9b5)](this),this[_0x4a8912(0x645)]={'arPenRate':0x0,'arPenFlat':0x0,'arRedRate':0x0,'arRedFlat':0x0},this[_0x4a8912(0x9f4)]={'criticalHitRate':0x1,'criticalHitFlat':0x0,'criticalDmgRate':0x1,'criticalDmgFlat':0x0,'damageRate':0x1,'damageFlat':0x0,'hitRate':0x1,'hitFlat':0x0},this['_customDamageFormula']=_0x4a8912(0x7ae);},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x6e7)]=function(_0x5c68c1,_0x314e40){const _0x133edb=_0xa8cad7;return VisuMZ[_0x133edb(0x8a9)][_0x133edb(0xb57)][_0x133edb(0x741)][_0x133edb(0x531)][_0x133edb(0x9b5)](this,_0x5c68c1,_0x314e40);},Game_Action['prototype']['applyVariance']=function(_0x34c198,_0xc02ae1){const _0x1773e7=_0xa8cad7;return VisuMZ[_0x1773e7(0x8a9)]['Settings'][_0x1773e7(0x741)]['VarianceFormulaJS'][_0x1773e7(0x9b5)](this,_0x34c198,_0xc02ae1);},Game_Action['prototype'][_0xa8cad7(0x23a)]=function(_0x4208b8,_0x24f8e4){const _0x428434=_0xa8cad7;return VisuMZ[_0x428434(0x8a9)][_0x428434(0xb57)]['Damage']['GuardFormulaJS']['call'](this,_0x4208b8,_0x24f8e4);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x1d8)]=Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x21e)],Game_Action[_0xa8cad7(0xa60)]['itemHit']=function(_0x2acb1c){const _0x188754=_0xa8cad7,_0x301132=this[_0x188754(0x191)]()[_0x188754(0x74f)];if(_0x301132[_0x188754(0x21d)](/<ALWAYS HIT>/i))return 0x1;else{if(_0x301132[_0x188754(0x21d)](/<ALWAYS HIT RATE: (\d+)([%％])>/i))return Number(RegExp['$1'])/0x64;else{let _0x32ab6e=VisuMZ[_0x188754(0x8a9)][_0x188754(0x1d8)][_0x188754(0x9b5)](this,_0x2acb1c);return _0x32ab6e=this[_0x188754(0x9f4)][_0x188754(0x1cd)]*_0x32ab6e+this[_0x188754(0x9f4)]['hitFlat'],_0x32ab6e;}}},Game_Action['prototype'][_0xa8cad7(0xa93)]=function(_0x348ee5){const _0x8740db=_0xa8cad7;if(!this[_0x8740db(0x191)]()[_0x8740db(0x11d)][_0x8740db(0x8cf)])return 0x0;let _0x3270ec=VisuMZ[_0x8740db(0x8a9)][_0x8740db(0xb57)][_0x8740db(0x741)]['CriticalHitRateJS'][_0x8740db(0x9b5)](this,_0x348ee5);return _0x3270ec=this[_0x8740db(0x9f4)][_0x8740db(0xb47)]*_0x3270ec+this[_0x8740db(0x9f4)][_0x8740db(0x994)],_0x3270ec;},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0xb70)]=function(_0x1edd00){const _0x55ee27=_0xa8cad7;return _0x1edd00=VisuMZ['BattleCore'][_0x55ee27(0xb57)][_0x55ee27(0x741)]['CriticalHitMultiplier'][_0x55ee27(0x9b5)](this,_0x1edd00),_0x1edd00=this[_0x55ee27(0x9f4)][_0x55ee27(0x223)]*_0x1edd00+this[_0x55ee27(0x9f4)][_0x55ee27(0xa29)],_0x1edd00;},VisuMZ['BattleCore'][_0xa8cad7(0xa2f)]=Game_Action[_0xa8cad7(0xa60)]['evalDamageFormula'],Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x512)]=function(_0x453b17){const _0x4d651a=_0xa8cad7;if(this['_customDamageFormula']!==_0x4d651a(0x7ae))return this[_0x4d651a(0x4f1)](_0x453b17);else{if(DataManager[_0x4d651a(0x852)](this[_0x4d651a(0x191)]())==='MANUAL'){if('znHNZ'!=='znHNZ'){if(!_0x42c6c4[_0x4d651a(0x1d3)]())return;const _0x4951f2=this[_0x4d651a(0xac0)]();if(!_0x4951f2)return;if(_0x25a3b5)this['setBattlerFacePoint'](_0x2cc8b0+_0x4951f2[_0x4d651a(0x7c5)],_0x1fd3a9+_0x4951f2[_0x4d651a(0x98c)],![]);_0x1ad90f+=_0x4951f2['_homeX'],_0xb46d33+=_0x4951f2['_homeY'],_0x4951f2['startHomeMove'](_0x1fb94c,_0x34182b,_0x3d7fcd,_0x3ce26f),this['_forcedHomeX']=_0x48eebd,this[_0x4d651a(0xaa4)]=_0xbacc0a;}else return VisuMZ[_0x4d651a(0x8a9)][_0x4d651a(0xa2f)][_0x4d651a(0x9b5)](this,_0x453b17);}else{if(_0x4d651a(0xaeb)!==_0x4d651a(0x5f0))return this[_0x4d651a(0x860)](_0x453b17);else _0x1c205f[_0x4d651a(0x8a9)][_0x4d651a(0x7fb)][_0x4d651a(0x9b5)](this),this['createHelpWindowBattleCore']();}}},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x56d)]=function(_0xe49a77){this['_customDamageFormula']=_0xe49a77;},Game_Action[_0xa8cad7(0xa60)]['customDamageFormula']=function(_0x1e088e){const _0x2bffee=_0xa8cad7,_0x2e727c=this[_0x2bffee(0x191)](),_0x5c4f7b=_0x2e727c[_0x2bffee(0x11d)][_0x2bffee(0xaf4)];_0x2e727c[_0x2bffee(0x11d)][_0x2bffee(0xaf4)]=this['_customDamageFormula'];let _0x4f3d7d=VisuMZ[_0x2bffee(0x8a9)][_0x2bffee(0xa2f)]['call'](this,_0x1e088e);return _0x2e727c['damage']['formula']=_0x5c4f7b,_0x4f3d7d;},Game_Action['prototype'][_0xa8cad7(0xaf2)]=function(){const _0x361cb3=_0xa8cad7;if(this[_0x361cb3(0x191)]()['note']['match'](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x2c35d0=String(RegExp['$1'])[_0x361cb3(0x41c)]()['trim']();return _0x2c35d0;}return'MANUAL';},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x860)]=function(_0xc2d58c){const _0x62a69a=_0xa8cad7,_0x5b25ad=DataManager['getDamageStyle'](this[_0x62a69a(0x191)]()),_0x3822c3=VisuMZ[_0x62a69a(0x8fc)][_0x5b25ad];try{return _0x3822c3[_0x62a69a(0x770)][_0x62a69a(0x9b5)](this,_0xc2d58c);}catch(_0x53449b){if($gameTemp[_0x62a69a(0x36c)]())console[_0x62a69a(0x158)](_0x53449b);return VisuMZ['BattleCore'][_0x62a69a(0xa2f)][_0x62a69a(0x9b5)](this);}},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x8ee)]=function(_0x317961,_0x3f0e9b){const _0x142b9e=_0xa8cad7;if(this['isCertainHit']())return _0x3f0e9b;const _0x5f755b=this[_0x142b9e(0x222)](),_0x318f56=_0x317961;let _0x43868f=[],_0x5a2669=[];_0x43868f['push'](this[_0x142b9e(0x645)][_0x142b9e(0x43b)],this[_0x142b9e(0x645)][_0x142b9e(0x376)]),_0x5a2669['push'](this[_0x142b9e(0x645)][_0x142b9e(0x245)],this[_0x142b9e(0x645)][_0x142b9e(0x5af)]);const _0x3f9c0e=this[_0x142b9e(0xb98)]()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)>/i,_0x30cb6c=this['isPhysical']()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)([%％])>/i,_0x4d9cc5=this[_0x142b9e(0xb98)]()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)>/i,_0x362d23=this[_0x142b9e(0xb98)]()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)([%％])>/i;return _0x43868f=_0x43868f['concat'](_0x318f56[_0x142b9e(0x1db)]()[_0x142b9e(0x369)](_0x650ad=>_0x650ad&&_0x650ad[_0x142b9e(0x74f)]['match'](_0x3f9c0e)?Number(RegExp['$1']):0x0)),_0x5a2669=_0x5a2669[_0x142b9e(0xaff)](_0x318f56['traitObjects']()['map'](_0x2bf68=>_0x2bf68&&_0x2bf68[_0x142b9e(0x74f)]['match'](_0x30cb6c)?Number(RegExp['$1'])/0x64:0x0)),_0x43868f=_0x43868f[_0x142b9e(0xaff)](_0x5f755b[_0x142b9e(0x1db)]()['map'](_0x317dc1=>_0x317dc1&&_0x317dc1[_0x142b9e(0x74f)][_0x142b9e(0x21d)](_0x4d9cc5)?Number(RegExp['$1']):0x0)),_0x5a2669=_0x5a2669[_0x142b9e(0xaff)](_0x5f755b['traitObjects']()[_0x142b9e(0x369)](_0xcc772c=>_0xcc772c&&_0xcc772c['note'][_0x142b9e(0x21d)](_0x362d23)?Number(RegExp['$1'])/0x64:0x0)),this[_0x142b9e(0x191)]()[_0x142b9e(0x74f)][_0x142b9e(0x21d)](_0x4d9cc5)&&_0x43868f[_0x142b9e(0x6c0)](Number(RegExp['$1'])),this[_0x142b9e(0x191)]()[_0x142b9e(0x74f)][_0x142b9e(0x21d)](_0x362d23)&&_0x5a2669[_0x142b9e(0x6c0)](Number(RegExp['$1'])),_0x3f0e9b=_0x43868f['reduce']((_0x477906,_0x363cc5)=>_0x477906-_0x363cc5,_0x3f0e9b),_0x3f0e9b>0x0&&(_0x3f0e9b=_0x5a2669[_0x142b9e(0x9df)]((_0x49605f,_0x1a1871)=>_0x49605f*(0x1-_0x1a1871),_0x3f0e9b)),_0x3f0e9b;},VisuMZ[_0xa8cad7(0x8a9)]['Game_Action_executeDamage']=Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x373)],Game_Action['prototype'][_0xa8cad7(0x373)]=function(_0x3ca219,_0x5a7671){const _0x25c6cc=_0xa8cad7;_0x5a7671=_0x5a7671*this[_0x25c6cc(0x9f4)][_0x25c6cc(0x68c)],_0x5a7671+=this[_0x25c6cc(0x9f4)][_0x25c6cc(0x6c9)]*(_0x5a7671>=0x0?0x1:-0x1),_0x5a7671=this[_0x25c6cc(0x8ba)](_0x25c6cc(0x94a),_0x3ca219,_0x5a7671,![]),_0x5a7671=this['applyDamageCaps'](_0x5a7671),_0x5a7671=Math[_0x25c6cc(0x2cb)](_0x5a7671),this['_executedValue']=_0x5a7671,this[_0x25c6cc(0x541)]=this[_0x25c6cc(0x541)]||0x0,this['_totalValue']+=_0x5a7671,VisuMZ[_0x25c6cc(0x8a9)]['Game_Action_executeDamage'][_0x25c6cc(0x9b5)](this,_0x3ca219,_0x5a7671),this[_0x25c6cc(0x8ba)](_0x25c6cc(0x2f6),_0x3ca219,_0x5a7671,!![]);},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x974)]=function(_0xa1bbed){const _0x40b37c=_0xa8cad7;if(this[_0x40b37c(0xa21)]())return _0xa1bbed;return _0xa1bbed=this[_0x40b37c(0x29d)](_0xa1bbed),_0xa1bbed=this[_0x40b37c(0x593)](_0xa1bbed),_0xa1bbed;},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0xa21)]=function(){const _0x2e8d29=_0xa8cad7,_0x2531ef=/<BYPASS DAMAGE CAP>/i;if(this[_0x2e8d29(0x191)]()[_0x2e8d29(0x74f)][_0x2e8d29(0x21d)](_0x2531ef))return!![];if(this[_0x2e8d29(0x222)]()[_0x2e8d29(0x1db)]()[_0x2e8d29(0x5f1)](_0x266f6a=>_0x266f6a&&_0x266f6a[_0x2e8d29(0x74f)][_0x2e8d29(0x21d)](_0x2531ef)))return!![];return!VisuMZ[_0x2e8d29(0x8a9)][_0x2e8d29(0xb57)][_0x2e8d29(0x741)]['EnableDamageCap'];},Game_Action['prototype'][_0xa8cad7(0x29d)]=function(_0x4b1745){const _0xecf0fe=_0xa8cad7;if(!VisuMZ[_0xecf0fe(0x8a9)]['Settings']['Damage'][_0xecf0fe(0x11c)])return _0x4b1745;const _0x1198e4=/<BYPASS SOFT DAMAGE CAP>/i;if(this[_0xecf0fe(0x191)]()['note']['match'](_0x1198e4))return!![];if(this['subject']()['traitObjects']()[_0xecf0fe(0x5f1)](_0x188c1a=>_0x188c1a&&_0x188c1a[_0xecf0fe(0x74f)][_0xecf0fe(0x21d)](_0x1198e4)))return!![];const _0x2249ae=_0x4b1745<0x0?-0x1:0x1;_0x4b1745=Math[_0xecf0fe(0xb32)](_0x4b1745);let _0x4a4004=this[_0xecf0fe(0x222)]()[_0xecf0fe(0xb69)]();if(this[_0xecf0fe(0x191)]()[_0xecf0fe(0x74f)][_0xecf0fe(0x21d)](/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i)){if(_0xecf0fe(0x7e8)==='fFBUP')_0x4a4004+=Number(RegExp['$1'])/0x64;else return this[_0xecf0fe(0x26b)]&&this[_0xecf0fe(0x26b)][_0xecf0fe(0xa17)]===_0x22c304;}_0x4a4004=_0x4a4004[_0xecf0fe(0xb5a)](0.01,0x1);const _0x4e9a99=this['getHardDamageCap'](),_0xbeecf=_0x4a4004*_0x4e9a99;if(_0x4b1745>_0xbeecf&&_0x4e9a99>_0xbeecf){_0x4b1745-=_0xbeecf;const _0x1eea5c=VisuMZ['BattleCore'][_0xecf0fe(0xb57)][_0xecf0fe(0x741)]['DefaultSoftScaler'],_0xc116e4=Math[_0xecf0fe(0x743)](0x1-_0x4b1745/((_0x4e9a99-_0xbeecf)*_0x1eea5c+_0x4b1745),0.01);_0x4b1745*=_0xc116e4,_0x4b1745+=_0xbeecf;}return _0x4b1745*_0x2249ae;},Game_Action['prototype'][_0xa8cad7(0x3a9)]=function(){const _0x49cd75=_0xa8cad7;return this[_0x49cd75(0x191)]()[_0x49cd75(0x74f)][_0x49cd75(0x21d)](/<DAMAGE CAP:[ ](\d+)>/i)?Number(RegExp['$1']):this[_0x49cd75(0x222)]()[_0x49cd75(0x403)]();},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x593)]=function(_0x29084c){const _0x191c16=_0xa8cad7;let _0x7acad0=this[_0x191c16(0x3a9)]();return _0x29084c[_0x191c16(0xb5a)](-_0x7acad0,_0x7acad0);},VisuMZ['BattleCore'][_0xa8cad7(0x62c)]=Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x5b6)],Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x5b6)]=function(_0x2eefa5){const _0x16916b=_0xa8cad7;this[_0x16916b(0x8ba)](_0x16916b(0x336),_0x2eefa5,0x0,!![]),VisuMZ[_0x16916b(0x8a9)][_0x16916b(0x62c)][_0x16916b(0x9b5)](this,_0x2eefa5),this[_0x16916b(0x8ba)](_0x16916b(0xa39),_0x2eefa5,this[_0x16916b(0x365)]||0x0,!![]),this[_0x16916b(0xad7)](_0x2eefa5);},Game_Action['prototype'][_0xa8cad7(0x8ba)]=function(_0x315128,_0x732aea,_0x2cb73d,_0x38a5d8){const _0x566cbc=_0xa8cad7;if(this[_0x566cbc(0xaef)]||this['_tempActor'])return;_0x2cb73d=_0x2cb73d||0x0;const _0x54a5a5=_0x2cb73d,_0x17bbfd=VisuMZ[_0x566cbc(0x8a9)][_0x566cbc(0xb57)][_0x566cbc(0x5e4)],_0x331791=_0x315128[_0x566cbc(0x69b)]('');if(_0x17bbfd[_0x331791]){_0x2cb73d=_0x17bbfd[_0x331791]['call'](this,_0x2cb73d,_0x732aea);if(_0x38a5d8)_0x2cb73d=_0x54a5a5;}let _0x422b1f=VisuMZ[_0x566cbc(0x8a9)][_0x566cbc(0x50a)](this['item'](),_0x315128[_0x566cbc(0x69b)](''));if(VisuMZ[_0x566cbc(0x8a9)]['JS'][_0x422b1f]){_0x2cb73d=VisuMZ['BattleCore']['JS'][_0x422b1f][_0x566cbc(0x9b5)](this,this[_0x566cbc(0x222)](),_0x732aea,this[_0x566cbc(0x191)](),_0x2cb73d);if(_0x38a5d8)_0x2cb73d=_0x54a5a5;}for(const _0x3e7451 of this[_0x566cbc(0x222)]()['traitObjects']()){if(!_0x3e7451)continue;_0x422b1f=VisuMZ[_0x566cbc(0x8a9)][_0x566cbc(0x50a)](_0x3e7451,_0x315128['format']('AsUser'));if(VisuMZ[_0x566cbc(0x8a9)]['JS'][_0x422b1f]){_0x2cb73d=VisuMZ[_0x566cbc(0x8a9)]['JS'][_0x422b1f][_0x566cbc(0x9b5)](this,this[_0x566cbc(0x222)](),_0x732aea,_0x3e7451,_0x2cb73d);if(_0x38a5d8)_0x2cb73d=_0x54a5a5;}}for(const _0x26aa31 of _0x732aea[_0x566cbc(0x1db)]()){if(_0x566cbc(0xaba)!=='VWbWC'){if(!_0x26aa31)continue;_0x422b1f=VisuMZ[_0x566cbc(0x8a9)][_0x566cbc(0x50a)](_0x26aa31,_0x315128[_0x566cbc(0x69b)]('AsTarget'));if(VisuMZ[_0x566cbc(0x8a9)]['JS'][_0x422b1f]){if('LiPcT'!==_0x566cbc(0x4b6)){if(!_0x2c388f)return![];return _0x224349[_0x566cbc(0x723)]===0x0||_0x44daec[_0x566cbc(0x723)]===0x1;}else{_0x2cb73d=VisuMZ[_0x566cbc(0x8a9)]['JS'][_0x422b1f]['call'](this,this['subject'](),_0x732aea,_0x26aa31,_0x2cb73d);if(_0x38a5d8)_0x2cb73d=_0x54a5a5;}}}else _0x412bfa[_0x566cbc(0x8a9)]['Scene_Battle_onActorCancel'][_0x566cbc(0x9b5)](this);}return _0x2cb73d;},Game_Action[_0xa8cad7(0xa60)]['actionBattleCoreJS']=function(_0x5be31b){const _0x4d7880=_0xa8cad7,_0x57ef4e=this[_0x4d7880(0x541)]||0x0,_0x425447=VisuMZ['BattleCore']['Settings']['Mechanics'],_0x41be88=_0x5be31b[_0x4d7880(0x69b)]('');_0x425447[_0x41be88]&&_0x425447[_0x41be88][_0x4d7880(0x9b5)](this,_0x57ef4e);let _0x49975b=VisuMZ[_0x4d7880(0x8a9)][_0x4d7880(0x50a)](this[_0x4d7880(0x191)](),_0x5be31b);VisuMZ[_0x4d7880(0x8a9)]['JS'][_0x49975b]&&(_0x4d7880(0x2ec)!=='VXyyE'?VisuMZ[_0x4d7880(0x8a9)]['JS'][_0x49975b][_0x4d7880(0x9b5)](this,this[_0x4d7880(0x222)](),this[_0x4d7880(0x222)](),this[_0x4d7880(0x191)](),_0x57ef4e):(this[_0x4d7880(0x840)]['skew']['x']=this[_0x4d7880(0x31b)],this[_0x4d7880(0x840)][_0x4d7880(0x57a)]['y']=this[_0x4d7880(0x4dd)]));for(const _0x91fc8f of this[_0x4d7880(0x222)]()[_0x4d7880(0x1db)]()){if(_0x4d7880(0x972)===_0x4d7880(0x378))this[_0x4d7880(0x425)]=!this[_0x4d7880(0x7c2)][_0x4d7880(0xa84)](),!this[_0x4d7880(0x425)]&&(this['opacity']=0x0);else{if(!_0x91fc8f)continue;_0x49975b=VisuMZ[_0x4d7880(0x8a9)][_0x4d7880(0x50a)](_0x91fc8f,_0x5be31b),VisuMZ[_0x4d7880(0x8a9)]['JS'][_0x49975b]&&(_0x4d7880(0x1e6)===_0x4d7880(0x1e6)?VisuMZ[_0x4d7880(0x8a9)]['JS'][_0x49975b]['call'](this,this[_0x4d7880(0x222)](),this[_0x4d7880(0x222)](),_0x91fc8f,_0x57ef4e):_0x449809=_0x4e116c>=_0x505aff?_0x57e448:_0x394f3f);}}},Game_Action[_0xa8cad7(0xa60)]['speed']=function(){const _0xce7e5=_0xa8cad7;return VisuMZ[_0xce7e5(0x8a9)][_0xce7e5(0xb57)][_0xce7e5(0x5e4)]['CalcActionSpeedJS'][_0xce7e5(0x9b5)](this);},Game_Action['prototype'][_0xa8cad7(0x6e3)]=function(){const _0x311b5d=_0xa8cad7;return VisuMZ[_0x311b5d(0x8a9)][_0x311b5d(0xb57)]['Mechanics'][_0x311b5d(0x698)];},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x33d)]=function(){const _0x27ddbd=_0xa8cad7;return this[_0x27ddbd(0x191)]()[_0x27ddbd(0x74f)][_0x27ddbd(0x21d)](/<JS TARGETS>/i);},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x133)]=function(){const _0x451b6b=_0xa8cad7;if(!this[_0x451b6b(0x63e)]&&this[_0x451b6b(0x222)]()[_0x451b6b(0x7cf)]())return![];if(this[_0x451b6b(0x33d)]())return!![];return typeof this[_0x451b6b(0x191)]()[_0x451b6b(0x912)]===_0x451b6b(0x6ec);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x6a2)]=Game_Action[_0xa8cad7(0xa60)]['isForOpponent'],Game_Action[_0xa8cad7(0xa60)]['isForOpponent']=function(){const _0x535b46=_0xa8cad7;if(this[_0x535b46(0x133)]()&&!this[_0x535b46(0x33d)]())return this[_0x535b46(0x5e5)]();else{if(_0x535b46(0x22e)!=='CKcqe')return VisuMZ[_0x535b46(0x8a9)]['Game_Action_isForOpponent'][_0x535b46(0x9b5)](this);else{const _0xaa79da=['PreApplyAsUserJS',_0x535b46(0x83b),_0x535b46(0x810),_0x535b46(0x4bd),_0x535b46(0x1d5),'PostApplyAsTargetJS',_0x535b46(0x97e),_0x535b46(0x8d4),_0x535b46(0x979),'PostStartActionJS',_0x535b46(0x4ed),_0x535b46(0x5c7),_0x535b46(0x7ee),_0x535b46(0x630),_0x535b46(0xb4e),_0x535b46(0x952),'BattleVictoryJS',_0x535b46(0x5d0),_0x535b46(0x7e4),_0x535b46(0x581),'PreStartTurnJS',_0x535b46(0xada),'PreEndTurnJS',_0x535b46(0x207),_0x535b46(0x33e),'PostRegenerateJS'];for(const _0x5b2ecc of _0xaa79da){_0x3bcc18[_0x535b46(0x8a9)]['createJS'](_0x39faac,_0x5b2ecc);}}}},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x5e5)]=function(){const _0x26dc09=_0xa8cad7,_0x17feb0=this['item']()[_0x26dc09(0x912)];return _0x17feb0['match'](/(?:ENEMY|ENEMIES|FOE|FOES)/i);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x6c5)]=Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x61b)],Game_Action[_0xa8cad7(0xa60)]['isForFriend']=function(){const _0x599419=_0xa8cad7;if(this[_0x599419(0x133)]()&&!this[_0x599419(0x33d)]())return this[_0x599419(0x628)]();else{if(_0x599419(0x32e)!==_0x599419(0x32e)){if(!_0xd73d77[_0x599419(0x45f)]())return;const _0xdf632d=_0x4788e6[_0x599419(0x933)]();if(!_0xdf632d)return;_0xdf632d[_0x599419(0x1e7)](_0x599419(0x607));}else return VisuMZ['BattleCore'][_0x599419(0x6c5)][_0x599419(0x9b5)](this);}},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x628)]=function(){const _0x409b90=_0xa8cad7,_0x3037c9=this[_0x409b90(0x191)]()[_0x409b90(0x912)];return _0x3037c9[_0x409b90(0x21d)](/(?:ALLY|ALLIES|FRIEND|FRIENDS)/i);},VisuMZ[_0xa8cad7(0x8a9)]['Game_Action_isForRandom']=Game_Action['prototype'][_0xa8cad7(0x3f7)],Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x3f7)]=function(){const _0x15570f=_0xa8cad7;if(this['isBattleCoreTargetScope']()&&!this[_0x15570f(0x33d)]())return this[_0x15570f(0xae0)]();else{if(_0x15570f(0x7ba)!==_0x15570f(0x7ba)){if(!_0x648a6f[_0x15570f(0x45f)]())return;if(!_0x641e4e['VisuMZ_2_BattleSystemPTB'])return;if(!_0x1f6aa8[_0x15570f(0x4f8)]())return;_0x5cbcd8[_0x15570f(0x17f)](_0x2d9655,_0x239f58);const _0x3a4067=_0x493f58['_subject'][_0x15570f(0x996)](),_0x3a518c=_0x3e6831['Override'],_0x1d2a44=_0x3d5353['alterChange']||_0x15570f(0x604),_0x167cd1=_0x329b93[_0x15570f(0x6fb)]||_0x15570f(0x604),_0x13d1d5=_0x4db27c[_0x15570f(0x5d5)]||0x0,_0xf2691c=_0x2675d5['alterPriority']||0x0;(_0x3a4067[_0x15570f(0x774)]()||_0x3a518c)&&(_0x3a518c&&(_0x3a4067[_0x15570f(0x381)]=_0x3a4067[_0x15570f(0x381)]||{},_0x3a4067[_0x15570f(0x381)][_0x15570f(0x96e)]=0x0),_0x3a4067[_0x15570f(0x250)](_0x1d2a44,_0x167cd1,_0x13d1d5,_0xf2691c));}else return VisuMZ[_0x15570f(0x8a9)][_0x15570f(0x910)][_0x15570f(0x9b5)](this);}},Game_Action['prototype'][_0xa8cad7(0xae0)]=function(){const _0x226dc8=_0xa8cad7,_0x45b024=this[_0x226dc8(0x191)]()[_0x226dc8(0x912)];return _0x45b024['match'](/(?:RAND|RANDOM)/i);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x570)]=Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x649)],Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x649)]=function(){const _0x4207a8=_0xa8cad7;if(this['isBattleCoreTargetScope']()&&!this['isCustomBattleScope']()){if(_0x4207a8(0xa6a)===_0x4207a8(0xa6a))return this[_0x4207a8(0x9ea)]();else this['opacity']=0x0;}else return VisuMZ['BattleCore']['Game_Action_needsSelection'][_0x4207a8(0x9b5)](this);},Game_Action['prototype'][_0xa8cad7(0x9ea)]=function(){const _0x3f769b=_0xa8cad7,_0x4f0f6e=this[_0x3f769b(0x191)]()[_0x3f769b(0x912)];if(_0x4f0f6e[_0x3f769b(0x21d)](/RANDOM/i))return![];if(_0x4f0f6e[_0x3f769b(0x21d)](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS)/i))return![];if(_0x4f0f6e['match'](/ALL (?:ENEMY|ENEMIES|FOE|FOES)/i))return![];return VisuMZ[_0x3f769b(0x8a9)]['Game_Action_needsSelection'][_0x3f769b(0x9b5)](this);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x85b)]=Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0xa6f)],Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0xa6f)]=function(){const _0x4b013a=_0xa8cad7;let _0x29e5da=[];if(this[_0x4b013a(0x133)]())_0x29e5da=this[_0x4b013a(0x332)]();else{if(_0x4b013a(0x6b2)===_0x4b013a(0x5ac))return this[_0x4b013a(0x2d2)]()['some'](_0x4e1d72=>_0x4e1d72['isSkewing']());else _0x29e5da=VisuMZ['BattleCore'][_0x4b013a(0x85b)][_0x4b013a(0x9b5)](this);}return _0x29e5da=this['applyTargetFilters'](_0x29e5da),_0x29e5da;},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x332)]=function(){const _0x442872=_0xa8cad7;let _0x1b404d=[];const _0x2c2605=String(this['item']()[_0x442872(0x912)]),_0x9744d=VisuMZ['BattleCore'][_0x442872(0x50a)](this['item'](),_0x442872(0x171));if(VisuMZ['BattleCore']['JS'][_0x9744d]){_0x1b404d=VisuMZ[_0x442872(0x8a9)][_0x442872(0x85b)][_0x442872(0x9b5)](this);const _0x11173a=VisuMZ[_0x442872(0x8a9)][_0x442872(0x50a)](this['item'](),_0x442872(0x171));return _0x1b404d=VisuMZ['BattleCore']['JS'][_0x11173a][_0x442872(0x9b5)](this,this[_0x442872(0x222)](),_0x1b404d),this[_0x442872(0x345)](_0x1b404d);}if(_0x2c2605[_0x442872(0x21d)](/(\d+) RANDOM ANY/i)){if(_0x442872(0x14f)===_0x442872(0x14f)){let _0x37d6a6=Number(RegExp['$1']);while(_0x37d6a6--){const _0x21b653=Math[_0x442872(0xa4a)](0x2)===0x0?this[_0x442872(0xac9)]():this[_0x442872(0x996)]();_0x1b404d[_0x442872(0x6c0)](_0x21b653[_0x442872(0x2bc)]());}return this['repeatTargets'](_0x1b404d);}else _0x3a1ba5[_0x442872(0x486)]();}if(_0x2c2605[_0x442872(0x21d)](/(\d+) RANDOM (?:ENEMY|ENEMIES|FOE|FOES)/i)){let _0x2ef888=Number(RegExp['$1']);while(_0x2ef888--){if(_0x442872(0x9a8)!==_0x442872(0x3d0))_0x1b404d[_0x442872(0x6c0)](this['opponentsUnit']()[_0x442872(0x2bc)]());else return this[_0x442872(0xa48)]&&this['_actor'][_0x442872(0xb73)]();}return this[_0x442872(0x345)](_0x1b404d);}if(_0x2c2605[_0x442872(0x21d)](/(\d+) RANDOM (?:ALLY|ALLIES|FRIEND|FRIENDS)/i)){if(_0x442872(0x6cb)===_0x442872(0x851)){if(this[_0x442872(0xa07)]>0x0){const _0x11c98e=this['_borderPortraitDuration'],_0x1614d5=this[_0x442872(0x3ac)];_0x1614d5['x']=(_0x1614d5['x']*(_0x11c98e-0x1)+this[_0x442872(0x5e1)])/_0x11c98e,_0x1614d5[_0x442872(0xa4c)]=(_0x1614d5[_0x442872(0xa4c)]*(_0x11c98e-0x1)+0xff)/_0x11c98e,this['_borderPortraitDuration']--;}}else{let _0xfb1ae9=Number(RegExp['$1']);while(_0xfb1ae9--){_0x1b404d[_0x442872(0x6c0)](this[_0x442872(0x996)]()[_0x442872(0x2bc)]());}return this[_0x442872(0x345)](_0x1b404d);}}if(_0x2c2605[_0x442872(0x21d)](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS) (?:BUT|EXCEPT) (?:USER|SELF)/i))return _0x1b404d[_0x442872(0x6c0)](...this[_0x442872(0x996)]()[_0x442872(0x209)]()[_0x442872(0x1d2)](_0x41d09a=>_0x41d09a!==this['subject']())),this[_0x442872(0x345)](_0x1b404d);return VisuMZ[_0x442872(0x8a9)][_0x442872(0x85b)][_0x442872(0x9b5)](this);},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x6a7)]=function(_0x37cd01){const _0x40f635=_0xa8cad7,_0x2d5f4d=[];for(let _0x4ebc01=0x0;_0x4ebc01<this[_0x40f635(0x8a5)]();_0x4ebc01++){_0x2d5f4d[_0x40f635(0x6c0)](_0x37cd01['trueRandomTarget']());}return _0x2d5f4d;},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x87c)]=function(_0x33a680){const _0x3030cd=_0xa8cad7;if(!this[_0x3030cd(0x191)]())return _0x33a680;const _0x27e506=this['item']()[_0x3030cd(0x74f)];return _0x27e506[_0x3030cd(0x21d)](/(?:BUT|EXCEPT) (?:USER|SELF)/i)&&_0x33a680[_0x3030cd(0xafb)](this[_0x3030cd(0x222)]()),_0x33a680;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x249)]=Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x2ef)],Game_Action['prototype'][_0xa8cad7(0x2ef)]=function(_0x518c84,_0x2c2395){const _0x2341fc=_0xa8cad7;VisuMZ['BattleCore'][_0x2341fc(0x249)]['call'](this,_0x518c84,_0x2c2395);if(!_0x518c84[_0x2341fc(0x120)]())return;for(const _0x17f6a6 of this[_0x2341fc(0x222)]()[_0x2341fc(0x951)]()){if(_0x17f6a6===_0x518c84[_0x2341fc(0x2a2)]()){if(_0x2341fc(0x2af)==='KJwxB'){let _0x123afa=_0x2c2395[_0x2341fc(0x776)];_0x123afa*=_0x518c84[_0x2341fc(0x692)](_0x17f6a6),_0x123afa*=this[_0x2341fc(0x222)]()[_0x2341fc(0x357)](_0x17f6a6),_0x123afa*=this[_0x2341fc(0x386)](_0x518c84),Math[_0x2341fc(0x2c5)]()<_0x123afa&&(_0x2341fc(0x50f)===_0x2341fc(0x50f)?(_0x518c84['_deathStateApplied']=!![],this[_0x2341fc(0x4fe)](_0x518c84)):this['setup'](_0x3dd632['list'],0x0));}else _0x553d96[_0x2341fc(0x3a5)]?this[_0x2341fc(0x572)]():_0x14585f['BattleCore'][_0x2341fc(0x627)]['call'](this);}}},VisuMZ['BattleCore'][_0xa8cad7(0x894)]=Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x46b)],Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x46b)]=function(_0x124b90,_0x5161e4){const _0x2f89bc=_0xa8cad7;VisuMZ['BattleCore']['Game_Action_itemEffectAddNormalState']['call'](this,_0x124b90,_0x5161e4);if(!_0x124b90['isImmortal']())return;if(_0x5161e4[_0x2f89bc(0x4c9)]!==_0x124b90[_0x2f89bc(0x2a2)]())return;let _0x4caecd=_0x5161e4[_0x2f89bc(0x776)];if(!this['isCertainHit']()){if(_0x2f89bc(0x349)!==_0x2f89bc(0x813))_0x4caecd*=_0x124b90[_0x2f89bc(0x692)](_0x5161e4[_0x2f89bc(0x4c9)]),_0x4caecd*=this[_0x2f89bc(0x386)](_0x124b90);else{const _0x139b12=this[_0x2f89bc(0x191)]()[_0x2f89bc(0x912)];return _0x139b12['match'](/(?:ENEMY|ENEMIES|FOE|FOES)/i);}}Math[_0x2f89bc(0x2c5)]()<_0x4caecd&&(_0x124b90[_0x2f89bc(0x2dd)]=!![],this[_0x2f89bc(0x4fe)](_0x124b90));},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x617)]=Game_Action['prototype'][_0xa8cad7(0x8e5)],Game_Action['prototype']['applyGlobal']=function(){const _0x3d4de4=_0xa8cad7;VisuMZ[_0x3d4de4(0x8a9)][_0x3d4de4(0x617)][_0x3d4de4(0x9b5)](this),this[_0x3d4de4(0x516)](),this['resetResultSwitches']();},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x516)]=function(){const _0x5464fe=_0xa8cad7;if(!SceneManager[_0x5464fe(0x45f)]())return;const _0x5f5365=/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi,_0x53bf99=this[_0x5464fe(0x191)]()[_0x5464fe(0x74f)][_0x5464fe(0x21d)](_0x5f5365);if(_0x53bf99)for(const _0x219b84 of _0x53bf99){if(!_0x219b84)continue;_0x219b84['match'](_0x5f5365);const _0x388300=String(RegExp['$1'])[_0x5464fe(0x136)](',')[_0x5464fe(0x369)](_0x297f7c=>String(_0x297f7c)[_0x5464fe(0xb45)]()),_0x430516=_0x388300[_0x5464fe(0x369)](_0x4517e7=>DataManager[_0x5464fe(0x1c8)](_0x4517e7));for(const _0xf09cee of _0x430516){const _0x4dc14d=$dataCommonEvents[_0xf09cee];_0x4dc14d&&$gameTemp[_0x5464fe(0xa71)](_0xf09cee);}}},DataManager['getCommonEventIdWithName']=function(_0x742d3c){const _0x4d4dba=_0xa8cad7;_0x742d3c=_0x742d3c[_0x4d4dba(0x41c)]()['trim'](),this[_0x4d4dba(0x5bc)]=this[_0x4d4dba(0x5bc)]||{};if(this[_0x4d4dba(0x5bc)][_0x742d3c])return this['_commonEventIDs'][_0x742d3c];for(const _0x32e28f of $dataCommonEvents){if(!_0x32e28f)continue;let _0x190a60=_0x32e28f['name'];_0x190a60=_0x190a60['replace'](/\x1I\[(\d+)\]/gi,''),_0x190a60=_0x190a60['replace'](/\\I\[(\d+)\]/gi,''),this[_0x4d4dba(0x5bc)][_0x190a60['toUpperCase']()['trim']()]=_0x32e28f['id'];}return this[_0x4d4dba(0x5bc)][_0x742d3c]||0x0;},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x4c7)]=function(){const _0x27f5c7=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;const _0x48ff8d=VisuMZ['BattleCore'][_0x27f5c7(0xb57)][_0x27f5c7(0x5e4)];_0x48ff8d[_0x27f5c7(0x3b1)]&&$gameSwitches[_0x27f5c7(0x200)](_0x48ff8d['SwitchCritical'],![]);if(_0x48ff8d[_0x27f5c7(0x529)]){if(_0x27f5c7(0xb96)!==_0x27f5c7(0xb96))for(const _0x520112 of _0x29d039){const _0x492392=_0x4c687b[0x0][_0x27f5c7(0x69b)](_0x520112[0x0]),_0x410654=_0x4a6e41[0x1][_0x27f5c7(0x69b)](_0x520112[0x1]),_0x4b886b=new _0x3f79ab(_0x479d64[_0x27f5c7(0x69b)](_0x410654),'i');_0x50a1ea[_0x492392]=_0x4b886b;}else $gameSwitches[_0x27f5c7(0x200)](_0x48ff8d[_0x27f5c7(0x529)],![]);}if(_0x48ff8d[_0x27f5c7(0x65f)]){if('IvWYQ'!==_0x27f5c7(0x753))$gameVariables[_0x27f5c7(0x200)](_0x48ff8d[_0x27f5c7(0x65f)],0x0);else{const _0x2af38e=[],_0x813c6c=new _0x439c48(this);return _0x813c6c[_0x27f5c7(0x36a)](),_0x2af38e[_0x27f5c7(0x6c0)](_0x813c6c),_0x2af38e;}}_0x48ff8d['VariableHeal']&&$gameVariables[_0x27f5c7(0x200)](_0x48ff8d['VariableHeal'],0x0);},Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0xad7)]=function(_0x49704c){const _0x14a04d=_0xa8cad7;if(!SceneManager[_0x14a04d(0x45f)]())return;if(!_0x49704c)return;const _0x4fd12f=_0x49704c[_0x14a04d(0x3be)](),_0x33d526=VisuMZ[_0x14a04d(0x8a9)][_0x14a04d(0xb57)][_0x14a04d(0x5e4)];_0x33d526[_0x14a04d(0x3b1)]&&_0x4fd12f[_0x14a04d(0x8cf)]&&('ilbfF'!==_0x14a04d(0x420)?$gameSwitches[_0x14a04d(0x200)](_0x33d526[_0x14a04d(0x3b1)],!![]):this[_0x14a04d(0xb8a)]());if(_0x33d526[_0x14a04d(0x529)]&&(_0x4fd12f[_0x14a04d(0x901)]||_0x4fd12f[_0x14a04d(0xb8b)])){if(_0x14a04d(0x77c)!==_0x14a04d(0x77c)){if(!_0xba2463['BattleCore'][_0x14a04d(0x4c3)])return;if(_0x3b8424['VisuMZ_2_BattleSystemCTB']&&_0x36fa20[_0x14a04d(0x78e)]())return;const _0x327d6e=_0xc3c6a4['aliveMembers']()[_0x14a04d(0x1d2)](_0xe02a62=>_0xe02a62[_0x14a04d(0x4bc)]()&&_0xe02a62[_0x14a04d(0x1bd)]());_0x386a84['_currentActor']=_0x327d6e[0x0]||null,_0x115d7a[_0x14a04d(0xa1b)]&&_0x3770f0[_0x14a04d(0xa1b)][_0x14a04d(0x323)](_0x14a04d(0x3d5));}else $gameSwitches[_0x14a04d(0x200)](_0x33d526[_0x14a04d(0x529)],!![]);}if(_0x33d526[_0x14a04d(0x65f)]){let _0x55da53=$gameVariables['value'](_0x33d526[_0x14a04d(0x65f)]);_0x4fd12f[_0x14a04d(0x3e5)]>0x0&&(_0x55da53+=Math[_0x14a04d(0xb32)](_0x4fd12f[_0x14a04d(0x3e5)])),$gameVariables[_0x14a04d(0x200)](_0x33d526[_0x14a04d(0x65f)],_0x55da53);}if(_0x33d526['VariableHeal']){if(_0x14a04d(0x351)!==_0x14a04d(0xad4)){let _0x513340=$gameVariables[_0x14a04d(0xa9e)](_0x33d526[_0x14a04d(0x716)]);_0x4fd12f[_0x14a04d(0x3e5)]<0x0&&(_0x513340+=Math[_0x14a04d(0xb32)](_0x4fd12f['hpDamage'])),$gameVariables[_0x14a04d(0x200)](_0x33d526[_0x14a04d(0x716)],_0x513340);}else return _0x2fa16e=_0x32997c[_0x14a04d(0x41c)]()['trim'](),this[_0x14a04d(0x157)]()===_0x344fce;}},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x20a)]=Game_BattlerBase['prototype'][_0xa8cad7(0x32a)],Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x32a)]=function(){const _0x1232cd=_0xa8cad7;VisuMZ[_0x1232cd(0x8a9)][_0x1232cd(0x20a)][_0x1232cd(0x9b5)](this),this[_0x1232cd(0xad2)]();},Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0xad2)]=function(){const _0x3067d1=_0xa8cad7;this[_0x3067d1(0x5a8)]=![];},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x7ea)]=Game_BattlerBase['prototype'][_0xa8cad7(0x8ff)],Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x8ff)]=function(){const _0x92cc8b=_0xa8cad7;this[_0x92cc8b(0x4d0)]={},VisuMZ[_0x92cc8b(0x8a9)][_0x92cc8b(0x7ea)][_0x92cc8b(0x9b5)](this);},Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x82a)]=function(_0x158339){const _0x32f826=_0xa8cad7;return this[_0x32f826(0x4d0)]=this[_0x32f826(0x4d0)]||{},this[_0x32f826(0x4d0)][_0x158339]!==undefined;},Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x403)]=function(){const _0x19d2b6=_0xa8cad7;if(this[_0x19d2b6(0x4d0)][_0x19d2b6(0x403)]!==undefined)return this[_0x19d2b6(0x4d0)][_0x19d2b6(0x403)];const _0x8b8438=/<DAMAGE CAP:[ ](\d+)>/i,_0x371639=this[_0x19d2b6(0x1db)]()[_0x19d2b6(0x369)](_0xbe27bb=>_0xbe27bb&&_0xbe27bb[_0x19d2b6(0x74f)][_0x19d2b6(0x21d)](_0x8b8438)?Number(RegExp['$1']):0x0);let _0x11f9f7=_0x371639[_0x19d2b6(0x19c)]>0x0?Math[_0x19d2b6(0x743)](..._0x371639):0x0;if(_0x11f9f7<=0x0)_0x11f9f7=VisuMZ[_0x19d2b6(0x8a9)]['Settings'][_0x19d2b6(0x741)]['DefaultHardCap'];return this[_0x19d2b6(0x4d0)][_0x19d2b6(0x403)]=_0x11f9f7,this['_cache'][_0x19d2b6(0x403)];},Game_BattlerBase[_0xa8cad7(0xa60)]['softDamageCapRate']=function(){const _0x181d60=_0xa8cad7;if(this[_0x181d60(0x4d0)][_0x181d60(0x647)]!==undefined)return this[_0x181d60(0x4d0)][_0x181d60(0x647)];let _0x3dcfaf=VisuMZ[_0x181d60(0x8a9)][_0x181d60(0xb57)][_0x181d60(0x741)][_0x181d60(0x8cc)];const _0x13eb93=/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i,_0x4f3b42=this[_0x181d60(0x1db)]()[_0x181d60(0x369)](_0x1444ef=>_0x1444ef&&_0x1444ef[_0x181d60(0x74f)][_0x181d60(0x21d)](_0x13eb93)?Number(RegExp['$1'])/0x64:0x0);return _0x3dcfaf=_0x4f3b42[_0x181d60(0x9df)]((_0x164d43,_0x224c69)=>_0x164d43+_0x224c69,_0x3dcfaf),this[_0x181d60(0x4d0)][_0x181d60(0x647)]=_0x3dcfaf,this[_0x181d60(0x4d0)]['softDamageCap'][_0x181d60(0xb5a)](0.01,0x1);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x6aa)]=Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0xaaa)],Game_BattlerBase[_0xa8cad7(0xa60)]['die']=function(){const _0x44a4ff=_0xa8cad7;VisuMZ[_0x44a4ff(0x8a9)][_0x44a4ff(0x6aa)]['call'](this),SceneManager[_0x44a4ff(0x45f)]()&&this[_0x44a4ff(0x300)]('dead');},Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0xac0)]=function(){const _0x16a1c9=_0xa8cad7;if(!SceneManager['isSceneBattle']())return null;if(!SceneManager[_0x16a1c9(0x26b)][_0x16a1c9(0x726)])return null;return SceneManager[_0x16a1c9(0x26b)][_0x16a1c9(0x726)]['findTargetSprite'](this);},Game_BattlerBase[_0xa8cad7(0xa60)]['svBattlerAnchorX']=function(){const _0x38a87c=_0xa8cad7;return VisuMZ[_0x38a87c(0x8a9)][_0x38a87c(0xb57)][_0x38a87c(0x3d8)][_0x38a87c(0x784)];},Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x653)]=function(){const _0x30a36c=_0xa8cad7;return VisuMZ[_0x30a36c(0x8a9)][_0x30a36c(0xb57)]['Actor'][_0x30a36c(0x637)];},Game_BattlerBase[_0xa8cad7(0xa60)]['svBattlerShadowVisible']=function(){const _0x28ada8=_0xa8cad7;if(this[_0x28ada8(0x902)]&&this[_0x28ada8(0x902)]()){if(_0x28ada8(0x611)===_0x28ada8(0x611))return VisuMZ[_0x28ada8(0x8a9)][_0x28ada8(0xb57)][_0x28ada8(0x3d8)][_0x28ada8(0x43a)];else{if(!this['canMove']())return;if(_0x5640ea<=0x0)return;this[_0x28ada8(0x1b9)]=_0x57357e,this[_0x28ada8(0x98a)]=_0x444a14,this[_0x28ada8(0xa98)]=_0x1571bb;}}else return VisuMZ[_0x28ada8(0x8a9)][_0x28ada8(0xb57)][_0x28ada8(0x8d5)]['Shadow'];},Game_BattlerBase[_0xa8cad7(0xa60)]['battlerSmoothImage']=function(){return!![];},Game_BattlerBase[_0xa8cad7(0xa60)]['battleUIOffsetX']=function(){return 0x0;},Game_BattlerBase['prototype'][_0xa8cad7(0x705)]=function(){return 0x0;},Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x9f2)]=function(_0x462180){const _0x19464a=_0xa8cad7;if(!_0x462180)return 0x0;let _0x2ee9e4=0x0;const _0x5716f3=_0x462180[_0x19464a(0x74f)];return _0x5716f3['match'](/<BATTLE UI OFFSET X:[ ]([\+\-]\d+)>/i)&&(_0x2ee9e4+=Number(RegExp['$1'])),_0x5716f3['match'](/<BATTLE UI OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i)&&(_0x2ee9e4+=Number(RegExp['$1'])),_0x2ee9e4;},Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x745)]=function(_0x8b04e3){if(!_0x8b04e3)return 0x0;let _0x5f4fc3=0x0;const _0x484984=_0x8b04e3['note'];return _0x484984['match'](/<BATTLE UI OFFSET Y:[ ]([\+\-]\d+)>/i)&&(_0x5f4fc3+=Number(RegExp['$1'])),_0x484984['match'](/<BATTLE UI OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i)&&(_0x5f4fc3+=Number(RegExp['$2'])),_0x5f4fc3;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x68e)]=Game_BattlerBase[_0xa8cad7(0xa60)]['isStateResist'],Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x773)]=function(_0x283e4a){const _0x453c53=_0xa8cad7;if(_0x283e4a===this[_0x453c53(0x2a2)]()&&this[_0x453c53(0x120)]())return _0x453c53(0x971)===_0x453c53(0x238)?this[_0x453c53(0x7c2)][_0x453c53(0x4ec)]():!![];return VisuMZ[_0x453c53(0x8a9)][_0x453c53(0x68e)][_0x453c53(0x9b5)](this,_0x283e4a);},Game_BattlerBase['prototype'][_0xa8cad7(0x120)]=function(){const _0x14608a=_0xa8cad7;return this[_0x14608a(0x5a8)];},Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0xa0b)]=function(_0x31c5e5){const _0xd16011=_0xa8cad7;_0x31c5e5?this[_0xd16011(0x367)]():_0xd16011(0x448)!==_0xd16011(0x448)?(_0x426d8c--,_0x1a40f6++):this[_0xd16011(0x760)]();},Game_BattlerBase[_0xa8cad7(0xa60)]['addImmortal']=function(){const _0x8f5c33=_0xa8cad7;if(this['isDead']())return;this[_0x8f5c33(0x5a8)]=!![],this[_0x8f5c33(0x2dd)]=![];},Game_BattlerBase['prototype'][_0xa8cad7(0x760)]=function(){const _0x39e89d=_0xa8cad7,_0x32ec7f=this['isAlive']();this[_0x39e89d(0x5a8)]=![];if(_0x32ec7f&&this[_0x39e89d(0x2dd)]){if(_0x39e89d(0x2ba)==='ahYDS')this[_0x39e89d(0xaaa)]();else for(const _0x22d475 of _0x13ebc7){const _0x2189ee=_0x5c5be7[0x0]['format'](_0x22d475[0x0],_0xc47f17[0x0]),_0x22cb0e=_0x2de10e[0x1][_0x39e89d(0x69b)](_0x22d475[0x1],_0x236317[0x1])[_0x39e89d(0xb45)](),_0x4af542=new _0x24a69b(_0x109bc6[_0x39e89d(0x69b)](_0x22cb0e),'i');_0x48ddc6[_0x2189ee]=_0x4af542;}}this[_0x39e89d(0x2dd)]=![],this['refresh'](),this[_0x39e89d(0xb06)]()&&_0x32ec7f&&('hflWw'!==_0x39e89d(0x665)?(_0x1ce139[_0x39e89d(0xa60)][_0x39e89d(0x623)][_0x39e89d(0x9b5)](this),this[_0x39e89d(0x726)]&&this['_spriteset'][_0x39e89d(0x99e)](),_0x10863f[_0x39e89d(0xb6b)]&&_0x3454ab['revertTpbCachedActor']()):(this[_0x39e89d(0x506)](),this[_0x39e89d(0x3cf)]()));},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x955)]=Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x163)],Game_Action['prototype'][_0xa8cad7(0x163)]=function(){const _0x3248c0=_0xa8cad7;return this[_0x3248c0(0x191)]()?VisuMZ[_0x3248c0(0x8a9)][_0x3248c0(0x955)][_0x3248c0(0x9b5)](this):0x0;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x3ce)]=Game_Action[_0xa8cad7(0xa60)]['setAttack'],Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x36a)]=function(){const _0x466b03=_0xa8cad7;this[_0x466b03(0x222)]()&&this[_0x466b03(0x222)]()[_0x466b03(0xa83)]()?VisuMZ[_0x466b03(0x8a9)][_0x466b03(0x3ce)][_0x466b03(0x9b5)](this):this[_0x466b03(0x711)]();},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x906)]=Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0xa83)],Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0xa83)]=function(){const _0x4ae548=_0xa8cad7;if(!this[_0x4ae548(0x43f)]())return![];return VisuMZ[_0x4ae548(0x8a9)]['Game_BattlerBase_canAttack']['call'](this);},Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x43f)]=function(){const _0x3ddf99=_0xa8cad7;for(const _0x56e290 of this['traitObjects']()){if(!_0x56e290)continue;if(_0x56e290[_0x3ddf99(0x74f)][_0x3ddf99(0x21d)](/<(?:ATTACK SEAL|SEAL ATTACK)>/i))return![];}return!![];},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x44f)]=Game_Action[_0xa8cad7(0xa60)][_0xa8cad7(0x7fa)],Game_Action['prototype']['setGuard']=function(){const _0x2b6f42=_0xa8cad7;this[_0x2b6f42(0x222)]()[_0x2b6f42(0x39b)]()&&VisuMZ[_0x2b6f42(0x8a9)][_0x2b6f42(0x44f)][_0x2b6f42(0x9b5)](this);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x30e)]=Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x39b)],Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x39b)]=function(){const _0xccf8ed=_0xa8cad7;if(!this[_0xccf8ed(0x919)]())return![];return VisuMZ['BattleCore'][_0xccf8ed(0x30e)][_0xccf8ed(0x9b5)](this);},Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0x919)]=function(){const _0x2e5355=_0xa8cad7;for(const _0x422203 of this['traitObjects']()){if(!_0x422203)continue;if(_0x422203[_0x2e5355(0x74f)]['match'](/<(?:GUARD SEAL|SEAL GUARD)>/i))return![];}return!![];},Game_BattlerBase[_0xa8cad7(0xa60)][_0xa8cad7(0xb73)]=function(){const _0x2c6672=_0xa8cad7;for(const _0x93073b of this[_0x2c6672(0x1db)]()){if('MhIFp'===_0x2c6672(0x713))_0x2fc0e7[_0x550684]=0x1,_0x242d11++;else{if(!_0x93073b)continue;if(_0x93073b[_0x2c6672(0x74f)][_0x2c6672(0x21d)](/<(?:ITEM SEAL|SEAL ITEM|SEAL ITEMS)>/i))return![];}}return!![];},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x6e3)]=function(){const _0x587880=_0xa8cad7;return VisuMZ['BattleCore'][_0x587880(0xb57)][_0x587880(0x5e4)][_0x587880(0x698)];},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x78b)]=Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xa4f)],Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xa4f)]=function(){const _0x4d126b=_0xa8cad7;if(SceneManager['isSceneBattle']()&&$gameTroop[_0x4d126b(0x8f1)]()<=0x0)return;if(SceneManager[_0x4d126b(0x45f)]()&&BattleManager[_0x4d126b(0x9af)]()&&this[_0x4d126b(0x3a6)]===Graphics['frameCount'])return;this[_0x4d126b(0x3a6)]=Graphics['frameCount'],this['processBattleCoreJS'](_0x4d126b(0x33e)),VisuMZ[_0x4d126b(0x8a9)][_0x4d126b(0x78b)]['call'](this),this[_0x4d126b(0x4b4)](),this[_0x4d126b(0x75f)]('PostRegenerateJS');},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x4b4)]=function(){const _0x2ee754=_0xa8cad7;if(SceneManager[_0x2ee754(0x45f)]())for(const _0x432f46 of this['traitObjects']()){if(!_0x432f46)continue;this[_0x2ee754(0x53f)](_0x432f46);}},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x53f)]=function(_0x1d98e8){const _0x3226a5=_0xa8cad7;if(!Imported[_0x3226a5(0x8a4)])return;if(!SceneManager[_0x3226a5(0x45f)]())return;if(this[_0x3226a5(0xb06)]())return;if(this[_0x3226a5(0xa84)]())return;if(_0x1d98e8[_0x3226a5(0x74f)][_0x3226a5(0x21d)](/<(?:REGENERATE|REGEN|DEGEN|DOT|SLIP)[ ]ANIMATION:[ ](\d+)>/i)){const _0xa54a26=Number(RegExp['$1']);$gameTemp['requestFauxAnimation']([this],_0xa54a26,![],![]);}},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x13d)]=Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x964)],Game_Battler[_0xa8cad7(0xa60)]['startTpbTurn']=function(){const _0x3cbf40=_0xa8cad7;this[_0x3cbf40(0x75f)](_0x3cbf40(0x8ca)),VisuMZ[_0x3cbf40(0x8a9)]['Game_Battler_startTpbTurn']['call'](this),this[_0x3cbf40(0x75f)](_0x3cbf40(0xada));},VisuMZ['BattleCore'][_0xa8cad7(0x2d7)]=Game_Battler[_0xa8cad7(0xa60)]['onTurnEnd'],Game_Battler['prototype'][_0xa8cad7(0x7e2)]=function(){const _0x4a962d=_0xa8cad7;this[_0x4a962d(0x75f)](_0x4a962d(0x431)),VisuMZ[_0x4a962d(0x8a9)]['Game_Battler_onTurnEnd'][_0x4a962d(0x9b5)](this),this[_0x4a962d(0x75f)](_0x4a962d(0x207));},Game_Battler['prototype'][_0xa8cad7(0x75f)]=function(_0x1f96bc){const _0x1b1f42=_0xa8cad7;if(this['_tempBattler']||this[_0x1b1f42(0x57e)])return;const _0x214110=VisuMZ[_0x1b1f42(0x8a9)]['Settings'][_0x1b1f42(0x5e4)];if(_0x214110[_0x1f96bc])_0x214110[_0x1f96bc][_0x1b1f42(0x9b5)](this);for(const _0x5eee15 of this['traitObjects']()){if(!_0x5eee15)continue;key=VisuMZ[_0x1b1f42(0x8a9)][_0x1b1f42(0x50a)](_0x5eee15,_0x1f96bc),VisuMZ['BattleCore']['JS'][key]&&VisuMZ[_0x1b1f42(0x8a9)]['JS'][key][_0x1b1f42(0x9b5)](this,this,this,_0x5eee15,0x0);}},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xb88)]=function(){const _0x3f14d5=_0xa8cad7;return VisuMZ['BattleCore'][_0x3f14d5(0xb57)][_0x3f14d5(0x3d8)]['ChantStyle']||![];},Game_Battler[_0xa8cad7(0xa60)]['isChanting']=function(){const _0x30e016=_0xa8cad7;if(this[_0x30e016(0x485)]()){if(this[_0x30e016(0xb88)]()){if(this[_0x30e016(0x124)][_0x30e016(0x5f1)](_0x994f2a=>_0x994f2a[_0x30e016(0x191)]()&&_0x994f2a[_0x30e016(0x889)]()))return!![];}else{if(this[_0x30e016(0x124)][_0x30e016(0x5f1)](_0x3d52c1=>_0x3d52c1[_0x30e016(0x191)]()&&_0x3d52c1[_0x30e016(0xb56)]()))return!![];}}if(BattleManager[_0x30e016(0x9af)]()&&this[_0x30e016(0x16e)]===_0x30e016(0x6e4))return this[_0x30e016(0xb88)]()?this[_0x30e016(0xae6)]()&&this[_0x30e016(0xae6)]()['item']()&&this[_0x30e016(0xae6)]()[_0x30e016(0x889)]():this[_0x30e016(0xae6)]()&&this[_0x30e016(0xae6)]()[_0x30e016(0x191)]()&&this[_0x30e016(0xae6)]()[_0x30e016(0xb56)]();return![];},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xa74)]=function(){const _0x12cf62=_0xa8cad7;if(BattleManager[_0x12cf62(0x9af)]()&&this[_0x12cf62(0x16e)]==='casting')return this[_0x12cf62(0xb88)]()?this[_0x12cf62(0xae6)]()&&this[_0x12cf62(0xae6)]()[_0x12cf62(0x191)]()&&!this[_0x12cf62(0xae6)]()[_0x12cf62(0x889)]():this[_0x12cf62(0xae6)]()&&this[_0x12cf62(0xae6)]()['item']()&&!this['currentAction']()['isMagicSkill']();return![];},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x683)]=Game_Battler[_0xa8cad7(0xa60)]['clearDamagePopup'],Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x3e8)]=function(){const _0x572028=_0xa8cad7;VisuMZ[_0x572028(0x8a9)][_0x572028(0x683)][_0x572028(0x9b5)](this),this['_damagePopupArray']=[];},Game_Battler[_0xa8cad7(0xa60)]['isDamagePopupRequested']=function(){const _0x5944dc=_0xa8cad7;if(!this[_0x5944dc(0xa3b)])this[_0x5944dc(0x3e8)]();return this['_damagePopupArray'][_0x5944dc(0x19c)]>0x0;},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x7f2)]=function(){const _0x491f0c=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;if(!this[_0x491f0c(0xa3b)])this['clearDamagePopup']();this[_0x491f0c(0xa5a)]();const _0x47e73b=this[_0x491f0c(0xac0)]();if(_0x47e73b)_0x47e73b[_0x491f0c(0x586)]();},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xa5a)]=function(){const _0x2a3d24=_0xa8cad7,_0x25af13=this[_0x2a3d24(0x3be)]();if(_0x25af13['missed']||_0x25af13[_0x2a3d24(0xb8b)]){if(_0x2a3d24(0x1dc)!==_0x2a3d24(0x1dc))this['_attackAnimationId']=_0x271a6a(_0x5e0e08['$1']);else{const _0x5e7943=JsonEx['makeDeepCopy'](_0x25af13);_0x5e7943[_0x2a3d24(0x555)]=![],_0x5e7943['mpDamage']=0x0,this[_0x2a3d24(0xa3b)][_0x2a3d24(0x6c0)](_0x5e7943);}}if(_0x25af13[_0x2a3d24(0x555)]){if(_0x2a3d24(0x25b)!==_0x2a3d24(0x25b)){if(!_0xcd8d2e[_0x2a3d24(0x45f)]())return;if(!_0x256a49[_0x2a3d24(0x1d1)])return;const _0x217c61=_0x23a127[_0x2a3d24(0x933)]();if(!_0x217c61)return;_0x217c61['setWaitMode'](_0x2a3d24(0x67a));}else{const _0x30ad2f=JsonEx[_0x2a3d24(0x673)](_0x25af13);_0x30ad2f['missed']=![],_0x30ad2f['evaded']=![],_0x30ad2f[_0x2a3d24(0xb4d)]=0x0,this['_damagePopupArray'][_0x2a3d24(0x6c0)](_0x30ad2f);}}if(_0x25af13[_0x2a3d24(0xb4d)]!==0x0){const _0x46589f=JsonEx[_0x2a3d24(0x673)](_0x25af13);_0x46589f['missed']=![],_0x46589f[_0x2a3d24(0xb8b)]=![],_0x46589f[_0x2a3d24(0x555)]=![],this[_0x2a3d24(0xa3b)]['push'](_0x46589f);}},Game_Battler[_0xa8cad7(0xa60)]['getNextDamagePopup']=function(){const _0x18d4b4=_0xa8cad7;if(!this[_0x18d4b4(0xa3b)])this[_0x18d4b4(0x3e8)]();return VisuMZ[_0x18d4b4(0x8a9)]['Settings'][_0x18d4b4(0x741)][_0x18d4b4(0x5a9)]?this['_damagePopupArray'][_0x18d4b4(0x287)]():this[_0x18d4b4(0xa3b)][_0x18d4b4(0x7be)]();},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x6d2)]=function(_0x59f282,_0x518935){const _0x33c45e=_0xa8cad7;if(!SceneManager[_0x33c45e(0x45f)]())return;if(!this[_0x33c45e(0xac0)]())return;if(_0x59f282[_0x33c45e(0x19c)]<=0x0)return;_0x518935=_0x518935||{},_0x518935[_0x33c45e(0x968)]=_0x518935[_0x33c45e(0x968)]||_0x33c45e(0x6af),_0x518935['flashColor']=_0x518935[_0x33c45e(0x52d)]||[0x0,0x0,0x0,0x0],_0x518935[_0x33c45e(0x271)]=_0x518935[_0x33c45e(0x271)]||0x0,this[_0x33c45e(0xac0)]()[_0x33c45e(0x6d2)](_0x59f282,_0x518935);},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x284)]=function(_0x5e7c12,_0x28ad88,_0x3acb3b){const _0x4a964d=_0xa8cad7;if(!SceneManager[_0x4a964d(0x45f)]())return;if(!this[_0x4a964d(0xac0)]())return;if(_0x28ad88[_0x4a964d(0x19c)]<=0x0)return;_0x3acb3b=_0x3acb3b||{},_0x3acb3b[_0x4a964d(0x968)]=_0x3acb3b[_0x4a964d(0x968)]||_0x4a964d(0x6af),_0x3acb3b[_0x4a964d(0x52d)]=_0x3acb3b[_0x4a964d(0x52d)]||[0x0,0x0,0x0,0x0],_0x3acb3b['flashDuration']=_0x3acb3b[_0x4a964d(0x271)]||0x0,this[_0x4a964d(0xac0)]()[_0x4a964d(0x284)](_0x5e7c12,_0x28ad88,_0x3acb3b);},Game_Battler['prototype']['notFocusValid']=function(){const _0x3a8677=_0xa8cad7;if(this[_0x3a8677(0xa84)]())return![];if(this['isAlive']()&&this[_0x3a8677(0x8b7)]())return!![];if(this[_0x3a8677(0x31f)]()&&this[_0x3a8677(0xb29)]()){if(this[_0x3a8677(0xb06)]()&&this['allowCollapse']())return![];}else{if(this['isDead']())return![];}return!![];},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x834)]=Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xb46)],Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xb46)]=function(){const _0x44892d=_0xa8cad7;VisuMZ[_0x44892d(0x8a9)][_0x44892d(0x834)]['call'](this),this[_0x44892d(0x23c)]();},Game_Battler['prototype'][_0xa8cad7(0x76b)]=function(){return!![];},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x23e)]=function(){return![];},VisuMZ['BattleCore'][_0xa8cad7(0x92e)]=Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x1be)],Game_Battler['prototype'][_0xa8cad7(0x1be)]=function(_0x1762fb){const _0x5ee501=_0xa8cad7;VisuMZ[_0x5ee501(0x8a9)][_0x5ee501(0x92e)][_0x5ee501(0x9b5)](this,_0x1762fb),this[_0x5ee501(0x58c)](_0x1762fb);},Game_Battler['prototype'][_0xa8cad7(0x58c)]=function(_0x1e2c2e){const _0x4be376=_0xa8cad7;this['setBattlerFlip'](![]),this[_0x4be376(0x9ed)]=undefined,this[_0x4be376(0xaa4)]=undefined;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x5b2)]=Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x82c)],Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x82c)]=function(){const _0x1e86b4=_0xa8cad7;VisuMZ[_0x1e86b4(0x8a9)][_0x1e86b4(0x5b2)]['call'](this),this[_0x1e86b4(0x87f)]();},Game_Battler['prototype'][_0xa8cad7(0x87f)]=function(){const _0x874bc0=_0xa8cad7;this[_0x874bc0(0x9ed)]=undefined,this[_0x874bc0(0xaa4)]=undefined;},VisuMZ['BattleCore'][_0xa8cad7(0x14b)]=Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x6d3)],Game_Battler['prototype'][_0xa8cad7(0x6d3)]=function(_0x528afa){const _0x3fd5a1=_0xa8cad7;VisuMZ[_0x3fd5a1(0x8a9)][_0x3fd5a1(0x14b)][_0x3fd5a1(0x9b5)](this,_0x528afa);if(!_0x528afa[_0x3fd5a1(0x766)]()){const _0x3af7e1=this['battler']();_0x3af7e1&&(_0x3fd5a1(0x9fc)!=='CTdJi'?(this[_0x3fd5a1(0x47a)]=new _0x5cee25(),this[_0x3fd5a1(0x9ac)](this['_damageContainer'])):_0x3af7e1[_0x3fd5a1(0xb33)]());}this['setBattlerFlip'](![]);},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x428)]=function(){const _0x53ff19=_0xa8cad7,_0x167d39=this['_flinched'];this[_0x53ff19(0x311)]=![];if(BattleManager[_0x53ff19(0x6d5)]()&&this[_0x53ff19(0x3f1)]()){if('oiZmG'!==_0x53ff19(0x523)){const _0x5ca3b5=this['battler']();if(_0x5ca3b5&&_0x167d39)_0x5ca3b5['stepForward']();return;}else _0x2407d4[_0x53ff19(0x86b)]([_0x2b13ab]);}const _0x2744b7=this[_0x53ff19(0xac0)]();if(_0x2744b7)_0x2744b7['stepBack']();this[_0x53ff19(0x7a0)](![]),this[_0x53ff19(0x3cf)]();},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x482)]=function(_0x4613bd){const _0x1f9498=_0xa8cad7;if(_0x4613bd[_0x1f9498(0x3df)]()){if('ILTym'===_0x1f9498(0x3ab)){const _0x233bca=this[_0x1f9498(0x4d9)]();return _0x233bca?_0x233bca[_0x1f9498(0x73c)]:0x0;}else this[_0x1f9498(0x4fc)]();}else{if(_0x4613bd['isGuard']())_0x1f9498(0x7dc)===_0x1f9498(0x7dc)?this[_0x1f9498(0x300)](_0x1f9498(0x452)):(this['_shadowSprite'][_0x1f9498(0x7d0)]=this[_0x1f9498(0x959)][_0x1f9498(0xb29)](),this[_0x1f9498(0x343)]());else{if(_0x4613bd[_0x1f9498(0x889)]())this[_0x1f9498(0x300)](_0x1f9498(0x8de));else{if(_0x4613bd[_0x1f9498(0x12c)]())_0x1f9498(0x876)!==_0x1f9498(0xa58)?_0x4613bd[_0x1f9498(0x191)]()[_0x1f9498(0x11d)][_0x1f9498(0x4fb)]>0x0?this[_0x1f9498(0x4fc)]():this['requestMotion'](_0x1f9498(0x7e1)):_0x232aec[_0x1f9498(0x8a9)][_0x1f9498(0xb7e)]['call'](this,_0x4f66c3);else{if(_0x4613bd[_0x1f9498(0x72b)]()){if('IBLjh'!==_0x1f9498(0x231))return;else this[_0x1f9498(0x300)](_0x1f9498(0x191));}}}}}},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x4d9)]=function(){return $dataSystem['attackMotions'][0x0];},Game_Battler[_0xa8cad7(0xa60)]['getAttackWeaponAnimationId']=function(){const _0x2f39ed=_0xa8cad7,_0x334a83=this[_0x2f39ed(0x4d9)]();return _0x334a83?_0x334a83[_0x2f39ed(0x73c)]:0x0;},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x528)]=function(_0x22f809){const _0x27dcc3=_0xa8cad7;if(!$gameSystem['isSideView']())return;const _0x442692=this[_0x27dcc3(0xac0)](),_0xec7ad4=_0x22f809[_0x27dcc3(0xac0)]();if(!_0x442692||!_0xec7ad4)return;const _0x3df514=_0xec7ad4['_baseX'],_0x54aed5=_0xec7ad4['_baseY'];this[_0x27dcc3(0xb81)](_0x3df514,_0x54aed5,0x0,![],_0x27dcc3(0x9bc),-0x1),_0x442692[_0x27dcc3(0x14e)]();const _0x89aca2=VisuMZ[_0x27dcc3(0x8a9)][_0x27dcc3(0xb57)][_0x27dcc3(0x19d)];let _0x1007c9=(_0xec7ad4[_0x27dcc3(0x960)]+_0x442692[_0x27dcc3(0x960)])/0x2;_0x1007c9*=this['isActor']()?0x1:-0x1;let _0x174733=_0x89aca2[_0x27dcc3(0x95f)]*(this[_0x27dcc3(0x902)]()?0x1:-0x1);_0x22f809[_0x27dcc3(0x75b)](_0x1007c9,_0x174733,0x0,![],_0x27dcc3(0x9bc)),_0xec7ad4[_0x27dcc3(0x14e)]();},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x300)]=function(_0x563feb){const _0x2b0958=_0xa8cad7;if(SceneManager[_0x2b0958(0x45f)]()){const _0x29f981=this[_0x2b0958(0xac0)]();if(_0x29f981){_0x29f981[_0x2b0958(0xa46)](_0x563feb);if([_0x2b0958(0x918),_0x2b0958(0x5ca),'missile'][_0x2b0958(0x220)](_0x563feb)){if(_0x2b0958(0xa80)!==_0x2b0958(0xb5e))this[_0x2b0958(0x932)]();else return this[_0x2b0958(0x940)]>0x0;}}}this['clearFreezeMotion']();},Game_Battler['prototype'][_0xa8cad7(0x932)]=function(){},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x3b8)]=function(_0x479885){const _0x22a443=_0xa8cad7;if(SceneManager[_0x22a443(0x45f)]()){const _0x2a718b=this['battler']();if(_0x2a718b)_0x2a718b[_0x22a443(0x59e)](_0x479885);}},Game_Battler['prototype']['startAttackWeaponAnimation']=function(){const _0x3496ce=_0xa8cad7;if(SceneManager['isSceneBattle']()){const _0x1158ea=this[_0x3496ce(0x6b4)]();this[_0x3496ce(0x3b8)](_0x1158ea);}},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x835)]=function(_0x3b027f,_0x1327d5){const _0x3e54e8=_0xa8cad7;if(!_0x3b027f)return;if(!_0x3b027f[_0x3e54e8(0x191)]())return;if(_0x3b027f['isAttack']())return;if(_0x3b027f[_0x3e54e8(0x766)]())return;if(_0x3b027f[_0x3e54e8(0x72b)]())return;let _0x41ce3d=0x0;const _0x424fb0=VisuMZ['BattleCore'][_0x3e54e8(0xb57)][_0x3e54e8(0x19d)],_0x1cfac4=_0x3b027f[_0x3e54e8(0x191)]()[_0x3e54e8(0x74f)];if(_0x1cfac4[_0x3e54e8(0x21d)](/<CAST ANIMATION: (\d+)>/i))_0x41ce3d=Number(RegExp['$1']);else{if(_0x1cfac4[_0x3e54e8(0x21d)](/<NO CAST ANIMATION>/i))return;else{if(_0x3b027f[_0x3e54e8(0xa5f)]())_0x41ce3d=_0x424fb0['CastCertain'];else{if(_0x3b027f['isPhysical']())_0x3e54e8(0x4a4)!=='wLnyP'?(_0x1131fd[_0x3e54e8(0x8a9)][_0x3e54e8(0x20d)][_0x3e54e8(0x9b5)](this),this[_0x3e54e8(0x241)]()&&this['isSkipPartyCommandWindow']()&&!this[_0x3e54e8(0x66a)]&&_0x58f43f[_0x3e54e8(0x1bd)]()&&this[_0x3e54e8(0x1aa)]()):_0x41ce3d=_0x424fb0[_0x3e54e8(0x2e0)];else _0x3b027f[_0x3e54e8(0x889)]()&&(_0x3e54e8(0x8f8)===_0x3e54e8(0x8f8)?_0x41ce3d=_0x424fb0['CastMagical']:_0x13652a=_0x245aa0);}}}_0x41ce3d>0x0&&$gameTemp[_0x3e54e8(0xb16)]([this],_0x41ce3d,!!_0x1327d5);},Game_Battler['prototype'][_0xa8cad7(0xa4b)]=function(){const _0x4bc862=_0xa8cad7;SoundManager[_0x4bc862(0x168)]();let _0x550fed=VisuMZ[_0x4bc862(0x8a9)][_0x4bc862(0xb57)][_0x4bc862(0x19d)][_0x4bc862(0xaee)];if(_0x550fed>0x0){if(Imported['VisuMZ_0_CoreEngine'])$gameTemp[_0x4bc862(0x3eb)]([this],_0x550fed);else{if(_0x4bc862(0xa55)!==_0x4bc862(0xa55)){const _0x14021e=_0x1a2d63[_0x4bc862(0x74f)];if(_0x14021e[_0x4bc862(0x21d)](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](\d+)([%％])>/i))return _0x3576ff(_0x3e6071['$1'])*0.01;else{if(_0x14021e[_0x4bc862(0x21d)](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](.*)>/i))return _0x73b145(_0xab50fd['$1'])||0x0;}}else $gameTemp[_0x4bc862(0xb16)]([this],_0x550fed);}}},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x51c)]=Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x70f)],Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x70f)]=function(){const _0x19e12d=_0xa8cad7;VisuMZ[_0x19e12d(0x8a9)][_0x19e12d(0x51c)]['call'](this),this[_0x19e12d(0x334)]();},VisuMZ['BattleCore']['Game_Battler_performMiss']=Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x4ba)],Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x4ba)]=function(){const _0x4698eb=_0xa8cad7;VisuMZ[_0x4698eb(0x8a9)]['Game_Battler_performMiss'][_0x4698eb(0x9b5)](this),this[_0x4698eb(0x334)]();},VisuMZ[_0xa8cad7(0x8a9)]['Game_Battler_performEvasion']=Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x91e)],Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x91e)]=function(){const _0x56f6ec=_0xa8cad7;VisuMZ[_0x56f6ec(0x8a9)][_0x56f6ec(0x2c8)][_0x56f6ec(0x9b5)](this),this[_0x56f6ec(0x334)]();},Game_Battler['prototype']['performFlinch']=function(){const _0x4d7923=_0xa8cad7;if(!$gameSystem[_0x4d7923(0x1d3)]())return;if(this[_0x4d7923(0x311)])return;this['_flinched']=!![];const _0x58bfec=this[_0x4d7923(0xac0)]();if(_0x58bfec)_0x58bfec['stepFlinch']();},Game_Battler[_0xa8cad7(0xa60)]['requestMotionRefresh']=function(){const _0x427737=_0xa8cad7;if(this[_0x427737(0xb06)]()&&this[_0x427737(0x3d4)]!==_0x427737(0x8b3)){if(_0x427737(0x5cc)===_0x427737(0x5cc)){this[_0x427737(0x300)](_0x427737(0x8b3));return;}else this['_mainSprite']&&this[_0x427737(0xb80)]['setHue'](_0xf529fe);}if(this['isDead']()&&this[_0x427737(0x3d4)]===_0x427737(0x8b3))return;if(!!this['_freezeMotionData'])return;if(this[_0x427737(0x31f)]()){if(_0x427737(0x664)===_0x427737(0x9b9))_0x47e44a=_0x52b045+_0x3e0d0b[_0x427737(0x565)]/0x2-0x4,_0x26edf4=_0x320158-_0x204f95[_0x427737(0x65c)]/0x2;else{if(!this[_0x427737(0x815)]()&&this!==BattleManager['_subject']){if(this[_0x427737(0xac0)]())this[_0x427737(0xac0)]()[_0x427737(0x117)]();}this[_0x427737(0x23c)]();return;}}if(this['_motionType']===_0x427737(0x467))return;if(this[_0x427737(0x3d4)]===_0x427737(0x1ce)&&!BattleManager['isInputting']())return;if(this[_0x427737(0x3d4)]===_0x427737(0x452)&&!BattleManager[_0x427737(0x3f1)]())return;this[_0x427737(0xb46)]();if(this[_0x427737(0xac0)]()&&BattleManager[_0x427737(0x3f1)]()){this[_0x427737(0xac0)]()[_0x427737(0x117)](),this['clearFreezeMotion']();return;}},Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x815)]=function(){const _0x10a881=_0xa8cad7;if(!this[_0x10a881(0xb29)]())return![];const _0x3f5d07=this[_0x10a881(0xac0)]();if(!_0x3f5d07)return![];const _0x158439=_0x3f5d07[_0x10a881(0x130)];if(!_0x158439)return![];const _0x2325e1=_0x158439[_0x10a881(0x8fa)];return _0x2325e1&&!_0x2325e1[_0x10a881(0x71e)];},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x3c7)]=function(){const _0x544905=_0xa8cad7;return this[_0x544905(0x8dc)];},Game_Battler['prototype'][_0xa8cad7(0x7a0)]=function(_0x253792){const _0x486714=_0xa8cad7;if(!$gameSystem[_0x486714(0x1d3)]())return;this[_0x486714(0x8dc)]=_0x253792;const _0x180953=this[_0x486714(0xac0)]();if(_0x180953)_0x180953['updateFlip']();},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x6f3)]=function(_0x273159,_0x24aa6d,_0x1e6e43){const _0x536533=_0xa8cad7;if(!$gameSystem[_0x536533(0x1d3)]())return;const _0x3cc8a7=this[_0x536533(0xac0)]();if(!_0x3cc8a7)return;if(_0x273159===_0x3cc8a7[_0x536533(0x7c5)])return;let _0x4ce44f=![];if(this[_0x536533(0x902)]()){if(_0x536533(0x859)===_0x536533(0x9a0)){this['contents'][_0x536533(0x711)]();const _0x17786f=_0x351313[_0x536533(0x8a9)][_0x536533(0xb57)][_0x536533(0xa3f)][_0x536533(0x36e)],_0x577b78=_0x17786f[_0x536533(0x69b)](this[_0x536533(0x1b2)](),this['cancelButtonText']()),_0x4f1536=this[_0x536533(0x30d)](_0x577b78)[_0x536533(0x960)],_0x2bdd8e=_0x4074bc[_0x536533(0xb05)]((this[_0x536533(0x8af)]-_0x4f1536)/0x2);this[_0x536533(0x1f9)](_0x577b78,_0x2bdd8e,0x0,_0x4f1536);}else{if(_0x273159>_0x3cc8a7[_0x536533(0x7c5)])_0x4ce44f=!![];if(_0x273159<_0x3cc8a7[_0x536533(0x7c5)])_0x4ce44f=![];}}else{if(this[_0x536533(0x31f)]()){if(_0x273159>_0x3cc8a7['_baseX'])_0x4ce44f=![];if(_0x273159<_0x3cc8a7['_baseX'])_0x4ce44f=!![];}};this['setBattlerFlip'](_0x1e6e43?!_0x4ce44f:_0x4ce44f),_0x3cc8a7[_0x536533(0x89f)]();},Game_Battler[_0xa8cad7(0xa60)]['moveBattlerDistance']=function(_0x154304,_0x12a074,_0x8819b4,_0xff496d,_0x351ca3){const _0x5763b4=_0xa8cad7;if(!$gameSystem['isSideView']())return;const _0x37ad87=this[_0x5763b4(0xac0)]();if(!_0x37ad87)return;if(_0xff496d)this[_0x5763b4(0x6f3)](_0x154304+_0x37ad87['_baseX'],_0x12a074+_0x37ad87[_0x5763b4(0x98c)],![]);_0x154304+=_0x37ad87[_0x5763b4(0x7c5)]-_0x37ad87[_0x5763b4(0xab8)],_0x12a074+=_0x37ad87[_0x5763b4(0x98c)]-_0x37ad87[_0x5763b4(0x4e0)],_0x37ad87['startMove'](_0x154304,_0x12a074,_0x8819b4);if(Imported[_0x5763b4(0x8a4)])_0x37ad87[_0x5763b4(0x44d)](_0x351ca3||_0x5763b4(0x9bc));},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xb81)]=function(_0x4ae4bf,_0x249e45,_0x393bdd,_0x23adad,_0x515842,_0x52cbfd){const _0x5a8656=_0xa8cad7;if(!$gameSystem[_0x5a8656(0x1d3)]())return;const _0x287ac5=this[_0x5a8656(0xac0)]();if(!_0x287ac5)return;_0x52cbfd=_0x52cbfd||0x0;if(_0x52cbfd>0x0){if(_0x5a8656(0x99d)!==_0x5a8656(0x1ca)){if(_0x287ac5['_baseX']>_0x4ae4bf)_0x4ae4bf+=_0x287ac5[_0x5a8656(0x960)]/0x2+_0x52cbfd;if(_0x287ac5['_baseX']<_0x4ae4bf)_0x4ae4bf-=_0x287ac5['width']/0x2+_0x52cbfd;}else this[_0x5a8656(0x6c3)]['x']=_0x3e2b13[_0x5a8656(0x960)]-(_0x525d03[_0x5a8656(0x960)]-_0x115fd7[_0x5a8656(0x719)])/0x2-this[_0x5a8656(0x6c3)]['width']-0x4;}if(_0x23adad)this[_0x5a8656(0x6f3)](_0x4ae4bf,_0x249e45,![]);_0x4ae4bf-=_0x287ac5['_homeX'],_0x249e45-=_0x287ac5['_homeY'],_0x287ac5['startMove'](_0x4ae4bf,_0x249e45,_0x393bdd);if(Imported[_0x5a8656(0x8a4)])_0x287ac5[_0x5a8656(0x44d)](_0x515842||_0x5a8656(0x9bc));},Game_Battler['prototype'][_0xa8cad7(0x422)]=function(_0xa10329,_0x38cdfc,_0x150a22,_0x4c34a1,_0x168710){const _0x20653c=_0xa8cad7;if(!$gameSystem[_0x20653c(0x1d3)]())return;const _0x3293e4=this[_0x20653c(0xac0)]();if(!_0x3293e4)return;if(_0x4c34a1)this[_0x20653c(0x6f3)](_0xa10329+_0x3293e4[_0x20653c(0x7c5)],_0x38cdfc+_0x3293e4[_0x20653c(0x98c)],![]);_0xa10329+=_0x3293e4[_0x20653c(0xab8)],_0x38cdfc+=_0x3293e4[_0x20653c(0x4e0)],_0x3293e4[_0x20653c(0x36d)](_0xa10329,_0x38cdfc,_0x150a22,_0x168710),this[_0x20653c(0x9ed)]=_0xa10329,this[_0x20653c(0xaa4)]=_0x38cdfc;},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x3ed)]=function(_0x3c5e41,_0x7e2e84,_0x2ea9bc,_0x2ff473,_0x99c1db,_0xcdcf80){const _0x481dec=_0xa8cad7;if(!$gameSystem[_0x481dec(0x1d3)]())return;const _0x5623ff=this[_0x481dec(0xac0)]();if(!_0x5623ff)return;_0xcdcf80=_0xcdcf80||0x0;if(_0xcdcf80>0x0){if(_0x481dec(0x5ec)===_0x481dec(0x577)){const _0xcc46ce=this[_0x481dec(0x511)](_0x644afd),_0x55673b=this[_0x481dec(0x926)](_0x2ffd71),_0x4d1c59=this['textSizeEx'](_0x55673b)['width'];this['changePaintOpacity'](this[_0x481dec(0x80c)](_0x3c759c));const _0x27694c=this[_0x481dec(0x7ce)]();if(_0x27694c===_0x481dec(0x1de))this['drawTextEx'](_0x55673b,_0xcc46ce['x']+_0xcc46ce[_0x481dec(0x960)]-_0x4d1c59,_0xcc46ce['y'],_0x4d1c59);else{if(_0x27694c===_0x481dec(0x725)){const _0x7038cc=_0xcc46ce['x']+_0x6d4de3['floor']((_0xcc46ce[_0x481dec(0x960)]-_0x4d1c59)/0x2);this[_0x481dec(0x1f9)](_0x55673b,_0x7038cc,_0xcc46ce['y'],_0x4d1c59);}else this[_0x481dec(0x1f9)](_0x55673b,_0xcc46ce['x'],_0xcc46ce['y'],_0x4d1c59);}}else{if(_0x5623ff[_0x481dec(0x7c5)]>_0x3c5e41)_0x3c5e41+=_0x5623ff['width']/0x2+_0xcdcf80;if(_0x5623ff[_0x481dec(0x7c5)]<_0x3c5e41)_0x3c5e41-=_0x5623ff[_0x481dec(0x960)]/0x2+_0xcdcf80;}}if(_0x2ff473)this[_0x481dec(0x6f3)](_0x3c5e41,_0x7e2e84,![]);_0x5623ff['startHomeMove'](_0x3c5e41,_0x7e2e84,_0x2ea9bc,_0x99c1db),this['_forcedHomeX']=_0x3c5e41,this['_forcedHomeY']=_0x7e2e84;},Game_Battler[_0xa8cad7(0xa60)]['floatBattler']=function(_0xb141c2,_0x2fdaa5,_0x3629da){const _0x47673b=_0xa8cad7;if(!$gameSystem['isSideView']())return;const _0x13b86f=this[_0x47673b(0xac0)]();if(!_0x13b86f)return;_0x13b86f[_0x47673b(0x9d2)](_0xb141c2,_0x2fdaa5,_0x3629da);},Game_Battler[_0xa8cad7(0xa60)]['jumpBattler']=function(_0x32458c,_0x47d01c){const _0x2851bb=_0xa8cad7;if(!$gameSystem[_0x2851bb(0x1d3)]())return;const _0x3dc054=this[_0x2851bb(0xac0)]();if(!_0x3dc054)return;_0x3dc054[_0x2851bb(0x532)](_0x32458c,_0x47d01c);},Game_Battler[_0xa8cad7(0xa60)]['spinBattler']=function(_0x14bf0e,_0x2a4a27,_0x4ea0ce,_0x37981a){const _0x557796=_0xa8cad7;if(!$gameSystem['isSideView']())return;const _0x2b99f4=this[_0x557796(0xac0)]();if(!_0x2b99f4)return;_0x2b99f4[_0x557796(0x244)](_0x14bf0e,_0x2a4a27,_0x4ea0ce,_0x37981a);},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x433)]=function(_0x38737e,_0x41794d,_0xbefb1f,_0x55a95f){const _0x2ebbf0=_0xa8cad7;if(!$gameSystem[_0x2ebbf0(0x1d3)]())return;const _0x27868d=this[_0x2ebbf0(0xac0)]();if(!_0x27868d)return;if(this[_0x2ebbf0(0x902)]()){if(_0x2ebbf0(0xa2e)===_0x2ebbf0(0x7fe)){if(_0x4441dd[_0x2ebbf0(0x81e)]!==_0x1a8520)return _0x3cd851[_0x2ebbf0(0x81e)];if(this[_0x2ebbf0(0x7a9)])return this[_0x2ebbf0(0x7a9)];return this[_0x2ebbf0(0x7a9)]=_0x4aa5ff['BattleCore'][_0x2ebbf0(0xb57)][_0x2ebbf0(0x56f)]['Style'][_0x2ebbf0(0x341)]()[_0x2ebbf0(0xb45)](),this['_battleLayoutStyle']===_0x2ebbf0(0x2c4)&&!_0x49d36c[_0x2ebbf0(0x8f5)]&&(this[_0x2ebbf0(0x7a9)]=_0x2ebbf0(0x7ae)),this['_battleLayoutStyle'];}else _0x38737e*=-0x1,_0x41794d*=-0x1;}_0x27868d[_0x2ebbf0(0x930)](_0x38737e,_0x41794d,_0xbefb1f,_0x55a95f);},Game_Battler[_0xa8cad7(0xa60)]['growBattler']=function(_0x39c248,_0x159663,_0xffa8a3,_0x5c059b){const _0x1d7aca=_0xa8cad7;if(!$gameSystem[_0x1d7aca(0x1d3)]())return;const _0x189e8a=this[_0x1d7aca(0xac0)]();if(!_0x189e8a)return;_0x189e8a[_0x1d7aca(0x751)](_0x39c248,_0x159663,_0xffa8a3,_0x5c059b);},Game_Battler[_0xa8cad7(0xa60)]['changeBattlerOpacity']=function(_0x5e1ee4,_0x206dfb,_0x62ec4e){const _0x544be8=_0xa8cad7;if(!$gameSystem[_0x544be8(0x1d3)]())return;const _0x3d9a79=this[_0x544be8(0xac0)]();if(!_0x3d9a79)return;_0x3d9a79['startOpacity'](_0x5e1ee4,_0x206dfb,_0x62ec4e);},Game_Battler['prototype']['clearFreezeMotion']=function(){const _0x4067b7=_0xa8cad7,_0x7aae3d=!!this[_0x4067b7(0x39d)];this[_0x4067b7(0x39d)]=undefined;if(_0x7aae3d){if('OXLyd'==='WZNDg'){if(!this[_0x4067b7(0x959)])return![];if(this[_0x4067b7(0x959)][_0x4067b7(0x902)]())return!![];const _0x5cab0f=this[_0x4067b7(0x959)][_0x4067b7(0xac4)]()[_0x4067b7(0x74f)];if(_0x5cab0f[_0x4067b7(0x21d)](/<SHOW HP GAUGE>/i))return!![];if(_0x5cab0f[_0x4067b7(0x21d)](/<HIDE HP GAUGE>/i))return![];const _0x45b1f6=_0x17c0eb['BattleCore'][_0x4067b7(0xb57)][_0x4067b7(0xb2e)];if(_0x45b1f6[_0x4067b7(0x921)]){if(_0x45b1f6[_0x4067b7(0x3f0)]&&_0x40f17f[_0x4067b7(0x291)]())return!![];if(this[_0x4067b7(0x959)][_0x4067b7(0xaa1)])return![];return this[_0x4067b7(0x959)][_0x4067b7(0x316)]();}return!![];}else this[_0x4067b7(0x3cf)](),this[_0x4067b7(0x35d)]();}},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x35d)]=function(){const _0x42f044=_0xa8cad7;if(!SceneManager['isSceneBattle']())return;const _0x30c7b5=this[_0x42f044(0xac0)]();if(!_0x30c7b5)return;let _0x49e590=this[_0x42f044(0x902)]()?_0x30c7b5[_0x42f044(0x765)]:_0x30c7b5[_0x42f044(0x130)][_0x42f044(0x765)];_0x49e590&&_0x49e590[_0x42f044(0xb84)](0x0);},Game_Battler['prototype']['freezeMotion']=function(_0x186f13,_0x44d4e8,_0x50ee0a){const _0x59cfc4=_0xa8cad7;if(this['isEnemy']()&&!this[_0x59cfc4(0xb29)]())return;let _0x33c941=0x0,_0x497679=0x0;_0x186f13['match'](/ATTACK[ ](\d+)/i)&&(_0x497679=Number(RegExp['$1']),_0x497679--);if(this[_0x59cfc4(0x902)]()){const _0x4a4bff=this[_0x59cfc4(0x7ca)]();_0x33c941=_0x4a4bff[_0x497679]?_0x4a4bff[_0x497679][_0x59cfc4(0x90a)]:0x0;}else{if(this['isEnemy']()){if(_0x59cfc4(0xa85)===_0x59cfc4(0xa85))_0x33c941=this[_0x59cfc4(0x418)]()[_0x59cfc4(0x90a)]||0x0;else return-0x1;}}const _0x210de3=$dataSystem[_0x59cfc4(0x394)][_0x33c941];_0x186f13['match'](/attack/i)&&(_0x186f13=[_0x59cfc4(0x5ca),_0x59cfc4(0x918),_0x59cfc4(0xb79)][_0x210de3[_0x59cfc4(0x4fb)]]||_0x59cfc4(0x918)),this[_0x59cfc4(0x39d)]={'motionType':_0x186f13,'weaponImageId':_0x44d4e8?_0x210de3[_0x59cfc4(0x73c)]:0x0,'pattern':_0x50ee0a};},Game_Battler[_0xa8cad7(0xa60)]['isFriendly']=function(_0x18dfae){const _0x430a3c=_0xa8cad7;if(!_0x18dfae)return![];return _0x18dfae[_0x430a3c(0x996)]()===this['friendsUnit']();},Game_Battler['prototype'][_0xa8cad7(0x731)]=function(_0x1dca88){const _0x54a1aa=_0xa8cad7;if(!_0x1dca88)return![];return _0x1dca88[_0x54a1aa(0xac9)]()===this[_0x54a1aa(0x996)]();},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x2aa)]=Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0xb84)],Game_Actor['prototype'][_0xa8cad7(0xb84)]=function(_0x21e560){const _0x318cd6=_0xa8cad7;VisuMZ[_0x318cd6(0x8a9)][_0x318cd6(0x2aa)][_0x318cd6(0x9b5)](this,_0x21e560),this[_0x318cd6(0x554)]();},Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x554)]=function(){const _0x479860=_0xa8cad7;this[_0x479860(0x1c5)]='';if(this[_0x479860(0x3e7)]()&&this[_0x479860(0x3e7)]()['note']['match'](/<BATTLE (?:IMAGE|PORTRAIT):[ ](.*)>/i)){if(_0x479860(0x7ed)!==_0x479860(0x7ed)){if(!_0x48cab0[_0x479860(0x1d3)]())return;this[_0x479860(0x8dc)]=_0xd8ae18;const _0x274ea3=this['battler']();if(_0x274ea3)_0x274ea3[_0x479860(0x89f)]();}else this[_0x479860(0x1c5)]=String(RegExp['$1']);}},Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x18c)]=function(){const _0x4f6603=_0xa8cad7;if(this[_0x4f6603(0x2ac)]()!==''){if(_0x4f6603(0x281)===_0x4f6603(0x48c))this[_0x4f6603(0x840)]=new _0x2ccc21(),this[_0x4f6603(0x840)][_0x4f6603(0xa5c)]['x']=0.5,this[_0x4f6603(0x840)][_0x4f6603(0xa5c)]['y']=0.5,this[_0x4f6603(0x9ac)](this[_0x4f6603(0x840)]);else return this['getBattlePortrait']();}else{if(Imported[_0x4f6603(0x451)]&&this[_0x4f6603(0xa70)]()!=='')return this[_0x4f6603(0xa70)]();}return'';},Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x2ac)]=function(){const _0x15b1a5=_0xa8cad7;if(this[_0x15b1a5(0x1c5)]===undefined)this['initBattlePortrait']();return this[_0x15b1a5(0x1c5)];},Game_Actor['prototype']['setBattlePortrait']=function(_0x4da3ba){const _0x3033b6=_0xa8cad7;if(this[_0x3033b6(0x1c5)]===undefined)this[_0x3033b6(0x554)]();this[_0x3033b6(0x1c5)]=_0x4da3ba;if(SceneManager[_0x3033b6(0x45f)]()&&$gameParty[_0x3033b6(0x321)]()[_0x3033b6(0x220)](this)){if('YJGqe'===_0x3033b6(0x509)){const _0x4d39b5=SceneManager[_0x3033b6(0x26b)][_0x3033b6(0x213)];if(_0x4d39b5)_0x4d39b5[_0x3033b6(0x69a)](this);}else{if(_0x409789===_0x363ee1[_0x3033b6(0x2a2)]()){let _0x470247=_0x18c0b9[_0x3033b6(0x776)];_0x470247*=_0x1872fd['stateRate'](_0x1a19f3),_0x470247*=this['subject']()[_0x3033b6(0x357)](_0x47e920),_0x470247*=this['lukEffectRate'](_0x9c4a06),_0x3872dc[_0x3033b6(0x2c5)]()<_0x470247&&(_0x4eb163[_0x3033b6(0x2dd)]=!![],this[_0x3033b6(0x4fe)](_0x3bada1));}}}},Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x9f6)]=function(){return!![];},Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x186)]=function(){const _0x4b0a0c=_0xa8cad7;if(!this['isConfused']()&&BattleManager[_0x4b0a0c(0xb41)])return!![];return Game_Battler[_0x4b0a0c(0xa60)]['isAutoBattle'][_0x4b0a0c(0x9b5)](this);},VisuMZ['BattleCore']['Game_Actor_makeActionList']=Game_Actor['prototype'][_0xa8cad7(0x5cf)],Game_Actor[_0xa8cad7(0xa60)]['makeActionList']=function(){const _0x25d4b0=_0xa8cad7;if(BattleManager[_0x25d4b0(0xb41)]&&!ConfigManager[_0x25d4b0(0x38d)])return this['makeActionListAutoAttack']();else{if(_0x25d4b0(0xb01)===_0x25d4b0(0x350))_0x54d14c+=_0x3c9ea5(_0x3c324a['$1']);else{return VisuMZ[_0x25d4b0(0x8a9)][_0x25d4b0(0xb90)][_0x25d4b0(0x9b5)](this);;}}},Game_Actor['prototype'][_0xa8cad7(0x429)]=function(){const _0xd620b4=_0xa8cad7,_0x13b00c=[],_0x5192cd=new Game_Action(this);return _0x5192cd[_0xd620b4(0x36a)](),_0x13b00c[_0xd620b4(0x6c0)](_0x5192cd),_0x13b00c;},Game_Actor[_0xa8cad7(0xa60)]['battleCommands']=function(){const _0x4aae99=_0xa8cad7;return this[_0x4aae99(0x73a)]()[_0x4aae99(0x74f)][_0x4aae99(0x21d)](/<BATTLE COMMANDS>\s*([\s\S]*)\s*<\/BATTLE COMMANDS>/i)?'DgLee'===_0x4aae99(0x4a0)?String(RegExp['$1'])[_0x4aae99(0x136)](/[\r\n]+/):!![]:VisuMZ[_0x4aae99(0x8a9)][_0x4aae99(0xb57)][_0x4aae99(0x327)][_0x4aae99(0x4b3)];},Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0xa2d)]=function(){const _0x59aa10=_0xa8cad7;if(this['_cache'][_0x59aa10(0x1a3)]!==undefined)return this['_cache'][_0x59aa10(0x1a3)];return this[_0x59aa10(0x3e7)]()[_0x59aa10(0x74f)]['match'](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)?(this['_cache'][_0x59aa10(0x1a3)]=eval(RegExp['$1']),this[_0x59aa10(0x4d0)]['svAnchorY']=eval(RegExp['$2'])):this[_0x59aa10(0x4d0)][_0x59aa10(0x1a3)]=Game_Battler[_0x59aa10(0xa60)][_0x59aa10(0xa2d)][_0x59aa10(0x9b5)](this),this[_0x59aa10(0x4d0)][_0x59aa10(0x1a3)];},Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x653)]=function(){const _0x45346e=_0xa8cad7;if(this[_0x45346e(0x4d0)]['svAnchorY']!==undefined)return this[_0x45346e(0x4d0)][_0x45346e(0x6f9)];return this[_0x45346e(0x3e7)]()[_0x45346e(0x74f)][_0x45346e(0x21d)](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)?(this[_0x45346e(0x4d0)][_0x45346e(0x1a3)]=eval(RegExp['$1']),this[_0x45346e(0x4d0)][_0x45346e(0x6f9)]=eval(RegExp['$2'])):this[_0x45346e(0x4d0)]['svAnchorY']=Game_Battler[_0x45346e(0xa60)][_0x45346e(0x653)][_0x45346e(0x9b5)](this),this[_0x45346e(0x4d0)]['svAnchorY'];},Game_Actor['prototype']['svBattlerShadowVisible']=function(){const _0x3f94de=_0xa8cad7;if(this['_cache']['svShadow']!==undefined)return this[_0x3f94de(0x4d0)]['svShadow'];if(this[_0x3f94de(0x3e7)]()[_0x3f94de(0x74f)]['match'](/<SIDEVIEW SHOW SHADOW>/i)){if(_0x3f94de(0x372)===_0x3f94de(0x6c4)){if(!_0x4d264b[_0x3f94de(0x45f)]())return;if(!_0xba6d8b[_0x3f94de(0x9e4)])return;_0xac81db[_0x3f94de(0x17f)](_0x567e7a,_0x426881);const _0x21dd16=_0xf139f1[_0x3f94de(0x933)](),_0x5d5b29=_0x3b654e[_0x3f94de(0x81d)];if(!_0x21dd16)return;const _0x19d96f=_0x509633['_spriteset'];if(!_0x19d96f)return;_0x19d96f[_0x3f94de(0x923)](_0x63d4a);if(_0x5d5b29)_0x21dd16[_0x3f94de(0x1e7)]('battleProjectiles');}else this[_0x3f94de(0x4d0)]['svShadow']=!![];}else this[_0x3f94de(0x3e7)]()[_0x3f94de(0x74f)]['match'](/<SIDEVIEW HIDE SHADOW>/i)?this[_0x3f94de(0x4d0)]['svShadow']=![]:this[_0x3f94de(0x4d0)][_0x3f94de(0x9d0)]=Game_Battler[_0x3f94de(0xa60)][_0x3f94de(0x4f9)][_0x3f94de(0x9b5)](this);return this['_cache'][_0x3f94de(0x9d0)];},Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x2ea)]=function(){const _0x6d61e2=_0xa8cad7;return VisuMZ['BattleCore'][_0x6d61e2(0xb57)][_0x6d61e2(0x3d8)][_0x6d61e2(0x115)];},Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x932)]=function(){const _0x2538a1=_0xa8cad7,_0x504385=this[_0x2538a1(0x7ca)](),_0x8a882c=_0x504385[0x0]?_0x504385[0x0][_0x2538a1(0x90a)]:0x0,_0x18bf5f=$dataSystem[_0x2538a1(0x394)][_0x8a882c];_0x18bf5f&&this[_0x2538a1(0x3b8)](_0x18bf5f[_0x2538a1(0x73c)]);},Game_Actor['prototype'][_0xa8cad7(0x1d7)]=function(_0x2274ab){const _0x23bdf2=_0xa8cad7;Game_Battler[_0x23bdf2(0xa60)]['performAction'][_0x23bdf2(0x9b5)](this,_0x2274ab),this['performActionMotions'](_0x2274ab);},Game_Actor['prototype'][_0xa8cad7(0x4d9)]=function(){const _0xa7be93=_0xa8cad7,_0x3e13ab=this['weapons'](),_0x4fa653=_0x3e13ab[0x0]?_0x3e13ab[0x0][_0xa7be93(0x90a)]:0x0;return $dataSystem[_0xa7be93(0x394)][_0x4fa653];},Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x440)]=function(_0x237a2d){const _0x4ad4c1=_0xa8cad7;_0x237a2d=_0x237a2d||0x1,_0x237a2d--;const _0x4f2fda=this[_0x4ad4c1(0x7ca)]();return _0x4f2fda[_0x237a2d]?_0x4f2fda[_0x237a2d][_0x4ad4c1(0x94c)]:0x0;},Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x3b2)]=function(_0x10a7a1){const _0x409561=_0xa8cad7;_0x10a7a1=_0x10a7a1||0x1,_0x10a7a1--;const _0x403764=this[_0x409561(0x7ca)](),_0x232a3b=_0x403764[_0x10a7a1]?_0x403764[_0x10a7a1][_0x409561(0x90a)]:0x0;return $dataSystem[_0x409561(0x394)][_0x232a3b];},Game_Actor[_0xa8cad7(0xa60)]['performAttackSlot']=function(_0xb6e6f0){const _0x1c9983=_0xa8cad7;_0xb6e6f0=_0xb6e6f0||0x1,_0xb6e6f0--;const _0x1213b7=this[_0x1c9983(0x7ca)](),_0x22008e=_0x1213b7[_0xb6e6f0]?_0x1213b7[_0xb6e6f0]['wtypeId']:0x0,_0x16114c=$dataSystem[_0x1c9983(0x394)][_0x22008e];if(_0x16114c){if(_0x16114c[_0x1c9983(0x4fb)]===0x0)this[_0x1c9983(0x300)](_0x1c9983(0x5ca));else{if(_0x16114c[_0x1c9983(0x4fb)]===0x1)this[_0x1c9983(0x300)](_0x1c9983(0x918));else _0x16114c[_0x1c9983(0x4fb)]===0x2&&this[_0x1c9983(0x300)](_0x1c9983(0xb79));}this['startWeaponAnimation'](_0x16114c[_0x1c9983(0x73c)]);}},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xaf0)]=function(_0xd9ff){const _0x290b13=_0xa8cad7;this[_0x290b13(0x497)]=_0xd9ff||0x0;},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x20e)]=function(){const _0x1ef392=_0xa8cad7;this[_0x1ef392(0x497)]=this[_0x1ef392(0x497)]||0x0,this[_0x1ef392(0x497)]++;},Game_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xb13)]=function(){const _0x5d640b=_0xa8cad7;this[_0x5d640b(0x497)]=undefined;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xb43)]=Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x3ad)],Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x3ad)]=function(){const _0x5bebe6=_0xa8cad7;let _0x1d9ef9=VisuMZ[_0x5bebe6(0x8a9)][_0x5bebe6(0xb43)]['call'](this);if(this['_tempEquipCheck'])return _0x1d9ef9;if(this['_activeWeaponSlot']!==undefined){this['_tempEquipCheck']=!![];const _0x6efef0=this[_0x5bebe6(0x3a1)]();for(let _0x4b38ea=0x0;_0x4b38ea<_0x6efef0[_0x5bebe6(0x19c)];_0x4b38ea++){_0x6efef0[_0x4b38ea]===0x1&&this['_activeWeaponSlot']!==_0x4b38ea&&(_0x1d9ef9[_0x4b38ea]=null);}this['_tempEquipCheck']=undefined;}return _0x1d9ef9;},Window_BattleLog[_0xa8cad7(0xa60)][_0xa8cad7(0xa41)]=function(_0x90e2d3){const _0x40dfa2=_0xa8cad7;if(_0x90e2d3[_0x40dfa2(0x902)]())return _0x90e2d3[_0x40dfa2(0x7ca)]()[_0x40dfa2(0x19c)]||0x1;else{if(_0x40dfa2(0x9ee)==='Mkjlv')return 0x1;else this['push'](_0x40dfa2(0x256),_0x4b7748);}},Window_BattleLog[_0xa8cad7(0xa60)]['setActiveWeaponSet']=function(_0x573c69,_0x55e1ba){const _0x1de683=_0xa8cad7;_0x573c69&&_0x573c69[_0x1de683(0x902)]()&&_0x573c69[_0x1de683(0xaf0)](_0x55e1ba),this[_0x1de683(0xa8a)]();},Window_BattleLog['prototype']['clearActiveWeaponSet']=function(_0x34b4ae){const _0x430525=_0xa8cad7;if(_0x34b4ae&&_0x34b4ae['isActor']()){if(_0x430525(0x21a)===_0x430525(0x352)){return;this[_0x430525(0xa1e)]&&(this['_effectsContainer']['x']=this['x'],this[_0x430525(0xa1e)]['y']=this['y']),this[_0x430525(0x47a)]&&(this['_damageContainer']['x']=this['x'],this[_0x430525(0x47a)]['y']=this['y']);}else _0x34b4ae[_0x430525(0xb13)]();}this[_0x430525(0xa8a)]();},Game_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x206)]=function(){const _0x55b923=_0xa8cad7;let _0x52b053=_0x55b923(0x206);if(this[_0x55b923(0x82a)](_0x52b053))return this[_0x55b923(0x4d0)][_0x52b053];return this[_0x55b923(0x4d0)][_0x52b053]=this[_0x55b923(0x9f2)](this['actor']()),this[_0x55b923(0x4d0)][_0x52b053];},Game_Actor['prototype'][_0xa8cad7(0x705)]=function(){const _0x3f516b=_0xa8cad7;let _0x3b2df6=_0x3f516b(0x705);if(this[_0x3f516b(0x82a)](_0x3b2df6))return this[_0x3f516b(0x4d0)][_0x3b2df6];return this['_cache'][_0x3b2df6]=this[_0x3f516b(0x745)](this[_0x3f516b(0x3e7)]()),this[_0x3f516b(0x4d0)][_0x3b2df6];},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x701)]=Game_Enemy['prototype']['setup'],Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0xb84)]=function(_0xdc9f17,_0x30b619,_0x240516){const _0x66ebfc=_0xa8cad7;_0xdc9f17=DataManager[_0x66ebfc(0x957)](_0xdc9f17),VisuMZ[_0x66ebfc(0x8a9)][_0x66ebfc(0x701)][_0x66ebfc(0x9b5)](this,_0xdc9f17,_0x30b619,_0x240516);Imported['VisuMZ_1_ElementStatusCore']&&this[_0x66ebfc(0xa7c)]();this[_0x66ebfc(0x7f6)](),this[_0x66ebfc(0x8a3)]();if(Imported[_0x66ebfc(0x4f4)]){if(_0x66ebfc(0x566)!=='wPUQy')return _0x2b55b3['BattleCore'][_0x66ebfc(0xb57)][_0x66ebfc(0x3d8)][_0x66ebfc(0x115)];else this[_0x66ebfc(0x432)]();}},Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x7f6)]=function(){const _0x46287c=_0xa8cad7,_0xba1900=VisuMZ[_0x46287c(0x8a9)][_0x46287c(0xb57)]['Enemy'];this[_0x46287c(0xb5d)]=_0xba1900[_0x46287c(0x1e2)],this[_0x46287c(0x9b7)]={};},Game_Enemy['prototype']['setupBattleCoreData']=function(){const _0x5cdba3=_0xa8cad7,_0x833124=VisuMZ[_0x5cdba3(0x8a9)][_0x5cdba3(0xb57)][_0x5cdba3(0x8d5)],_0x58337b=this[_0x5cdba3(0xac4)]()['note'];this[_0x5cdba3(0x9b7)]={'name':'','wtypeId':_0x833124[_0x5cdba3(0x1b3)],'collapse':_0x833124[_0x5cdba3(0x9d9)],'motionIdle':_0x833124['MotionIdle'],'width':_0x833124['Width']||0x40,'height':_0x833124[_0x5cdba3(0xa47)]||0x40,'anchorX':_0x833124[_0x5cdba3(0x784)]||0x0,'anchorY':_0x833124[_0x5cdba3(0x637)]||0x0,'shadow':_0x833124['Shadow']};_0x58337b[_0x5cdba3(0x21d)](/<ATTACK ANIMATION:[ ](\d+)>/i)&&(this[_0x5cdba3(0xb5d)]=Number(RegExp['$1']));const _0x1a6304=this[_0x5cdba3(0x9b7)];if(_0x58337b[_0x5cdba3(0x21d)](/<SIDEVIEW BATTLER: (.*)>/i))_0x1a6304['name']=String(RegExp['$1']);else{if(_0x58337b[_0x5cdba3(0x21d)](/<SIDEVIEW BATTLERS>\s*([\s\S]*)\s*<\/SIDEVIEW BATTLERS>/i)){const _0x3e0168=String(RegExp['$1'])[_0x5cdba3(0x136)](/[\r\n]+/)[_0x5cdba3(0xafb)]('');_0x1a6304[_0x5cdba3(0x9a6)]=DataManager[_0x5cdba3(0xa33)](_0x3e0168);}}_0x58337b[_0x5cdba3(0x21d)](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)&&(_0x1a6304[_0x5cdba3(0x25e)]=eval(RegExp['$1']),_0x1a6304['anchorY']=eval(RegExp['$2']));if(_0x58337b[_0x5cdba3(0x21d)](/<SIDEVIEW COLLAPSE>/i)){if('gIeAt'!==_0x5cdba3(0x709)){if(!_0x383313[_0x5cdba3(0x45f)]())return;_0x35b674[_0x5cdba3(0x17f)](_0xfa8909,_0x326960);const _0x4d4982=_0x57dcf2[_0x5cdba3(0x933)](),_0x5f0b02=_0x36d0dc[_0x5cdba3(0x30a)];if(!_0x4d4982)return;_0xddc244[_0x5cdba3(0x4e3)]--,_0x5accbe[_0x5cdba3(0x123)]=_0x4ab22d[_0x5cdba3(0x257)][_0x4cac3b[_0x5cdba3(0x4e3)]]||null,_0xf205aa[_0x5cdba3(0x123)]&&_0x5f0b02[_0x5cdba3(0x41c)]()['trim']()!==_0x5cdba3(0x76c)&&_0x4d4982[_0x5cdba3(0x86b)]([_0x5f0b02]);}else _0x1a6304[_0x5cdba3(0x81c)]=!![];}else _0x58337b[_0x5cdba3(0x21d)](/<SIDEVIEW NO COLLAPSE>/i)&&(_0x1a6304[_0x5cdba3(0x81c)]=![]);if(_0x58337b[_0x5cdba3(0x21d)](/<SIDEVIEW SHOW SHADOW>/i))_0x1a6304[_0x5cdba3(0x276)]=!![];else _0x58337b[_0x5cdba3(0x21d)](/<SIDEVIEW HIDE SHADOW>/i)&&(_0x1a6304[_0x5cdba3(0x276)]=![]);if(_0x58337b[_0x5cdba3(0x21d)](/<SIDEVIEW IDLE MOTION: (.*)>/i))_0x1a6304[_0x5cdba3(0x7f3)]=String(RegExp['$1'])[_0x5cdba3(0x341)]()[_0x5cdba3(0xb45)]();else{if(_0x58337b['match'](/<SIDEVIEW IDLE MOTIONS>\s*([\s\S]*)\s*<\/SIDEVIEW IDLE MOTIONS>/i)){const _0x23f2a3=String(RegExp['$1'])[_0x5cdba3(0x136)](/[\r\n]+/)[_0x5cdba3(0xafb)]('');_0x1a6304[_0x5cdba3(0x7f3)]=DataManager[_0x5cdba3(0xa33)](_0x23f2a3);}}_0x58337b[_0x5cdba3(0x21d)](/<SIDEVIEW SIZE: (\d+), (\d+)>/i)&&(_0x1a6304['width']=Number(RegExp['$1']),_0x1a6304[_0x5cdba3(0xa97)]=Number(RegExp['$2']));if(_0x58337b[_0x5cdba3(0x21d)](/<SIDEVIEW WEAPON: (.*)>/i)){if(_0x5cdba3(0x798)==='LaUBl')_0x1a6304[_0x5cdba3(0x90a)]=DataManager[_0x5cdba3(0x4e5)](RegExp['$1']);else{const _0x52f8f5=_0xbfa2b1['prototype'][_0x5cdba3(0x91f)][_0x5cdba3(0x9b5)](arguments,0x1),_0x5cf137={'name':_0x42f5c9,'params':_0x52f8f5},_0x5615bc=this[_0x5cdba3(0x149)][_0x5cdba3(0x369)](_0x3e6924=>_0x3e6924[_0x5cdba3(0x9a6)])[_0x5cdba3(0x153)](_0x5cdba3(0x8f6));_0x5615bc>=0x0?this[_0x5cdba3(0x149)][_0x5cdba3(0x758)](_0x5615bc,0x0,_0x5cf137):this[_0x5cdba3(0x149)][_0x5cdba3(0x6c0)](_0x5cf137);}}else{if(_0x58337b[_0x5cdba3(0x21d)](/<SIDEVIEW WEAPONS>\s*([\s\S]*)\s*<\/SIDEVIEW WEAPONS>/i)){if('dQAHM'===_0x5cdba3(0x7c8)){const _0x10f005=String(RegExp['$1'])[_0x5cdba3(0x136)](/[\r\n]+/)[_0x5cdba3(0xafb)](''),_0x5110d5=DataManager[_0x5cdba3(0xa33)](_0x10f005);_0x1a6304[_0x5cdba3(0x90a)]=DataManager[_0x5cdba3(0x4e5)](_0x5110d5);}else this[_0x5cdba3(0x840)][_0x5cdba3(0x9ac)](this[_0x5cdba3(0x540)]);}}if(Imported[_0x5cdba3(0x4f4)]){const _0x1f9cd9=this[_0x5cdba3(0xad3)]();for(const _0x17411e of _0x1f9cd9){if(_0x5cdba3(0x7ac)===_0x5cdba3(0x2d1)){const _0x150f43=this[_0x5cdba3(0x511)](_0x1df2a3),_0xa69cfb=this[_0x5cdba3(0x30d)](_0x5f01a0)['width'];return _0xa69cfb<=_0x150f43['width']?_0x5cdba3(0x5d6):_0x5cdba3(0x9f3);}else{const _0x3d1bcc=this[_0x5cdba3(0x8a2)](_0x17411e)['Name'][_0x5cdba3(0x41c)]()[_0x5cdba3(0xb45)](),_0x33f3e9=_0x17411e['toUpperCase']()[_0x5cdba3(0xb45)]();if(_0x58337b['match'](VisuMZ[_0x5cdba3(0x4e1)][_0x5cdba3(0xa37)]['SvBattlerSolo-%1-%2'['format'](_0x33f3e9,_0x3d1bcc)]))_0x1a6304[_0x5cdba3(0x9a6)]=String(RegExp['$1']);else{if(_0x58337b[_0x5cdba3(0x21d)](VisuMZ[_0x5cdba3(0x4e1)][_0x5cdba3(0xa37)][_0x5cdba3(0x987)['format'](_0x33f3e9,_0x3d1bcc)])){if('ymanB'===_0x5cdba3(0x3ba)){const _0x549c74=String(RegExp['$1'])[_0x5cdba3(0x136)](/[\r\n]+/)[_0x5cdba3(0xafb)]('');_0x1a6304[_0x5cdba3(0x9a6)]=DataManager[_0x5cdba3(0xa33)](_0x549c74);}else this[_0x5cdba3(0x130)][_0x5cdba3(0x64d)][_0x5cdba3(0x122)]['x']=-0x1/(this[_0x5cdba3(0x122)]['x']||0.001),this[_0x5cdba3(0x130)]['_stateSprite'][_0x5cdba3(0x122)]['y']=0x1/(this[_0x5cdba3(0x122)]['y']||0.001);}}if(_0x58337b[_0x5cdba3(0x21d)](VisuMZ[_0x5cdba3(0x4e1)]['RegExp']['SvWeaponSolo-%1-%2'[_0x5cdba3(0x69b)](_0x33f3e9,_0x3d1bcc)])){if(_0x5cdba3(0xb87)===_0x5cdba3(0x556)){if(this[_0x5cdba3(0x43c)]===_0x257fe2)this[_0x5cdba3(0x865)]();return this[_0x5cdba3(0x43c)];}else _0x1a6304[_0x5cdba3(0x90a)]=DataManager[_0x5cdba3(0x4e5)](RegExp['$1']);}else{if(_0x58337b['match'](VisuMZ['ElementStatusCore'][_0x5cdba3(0xa37)]['SvWeaponMass-%1-%2'['format'](_0x33f3e9,_0x3d1bcc)])){if(_0x5cdba3(0x73d)!==_0x5cdba3(0x761)){const _0x10efe4=String(RegExp['$1'])[_0x5cdba3(0x136)](/[\r\n]+/)[_0x5cdba3(0xafb)](''),_0x1feacf=DataManager['processRandomizedData'](_0x10efe4);_0x1a6304['wtypeId']=DataManager['getWtypeIdWithName'](_0x1feacf);}else _0x5db7e3[_0x5cdba3(0xa60)][_0x5cdba3(0x93a)]['call'](this);}}if(_0x58337b['match'](VisuMZ[_0x5cdba3(0x4e1)][_0x5cdba3(0xa37)]['SvMotionIdleSolo-%1-%2'[_0x5cdba3(0x69b)](_0x33f3e9,_0x3d1bcc)]))_0x1a6304[_0x5cdba3(0x7f3)]=String(RegExp['$1'])[_0x5cdba3(0x341)]()[_0x5cdba3(0xb45)]();else{if(_0x58337b[_0x5cdba3(0x21d)](VisuMZ[_0x5cdba3(0x4e1)][_0x5cdba3(0xa37)][_0x5cdba3(0x7a3)['format'](_0x33f3e9,_0x3d1bcc)])){const _0x619633=String(RegExp['$1'])[_0x5cdba3(0x136)](/[\r\n]+/)[_0x5cdba3(0xafb)]('');_0x1a6304[_0x5cdba3(0x7f3)]=DataManager[_0x5cdba3(0xa33)](_0x619633);}}}}}},Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x880)]=function(){const _0x3c6a89=_0xa8cad7;return this[_0x3c6a89(0xb5d)]||0x0;},Game_Enemy[_0xa8cad7(0xa60)]['attackAnimationId2']=function(){const _0x5e0e5d=_0xa8cad7;return this[_0x5e0e5d(0x880)]();},Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x440)]=function(_0x459ebc){const _0x1255b3=_0xa8cad7;return this[_0x1255b3(0x880)]();},Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x76b)]=function(){const _0x3f5365=_0xa8cad7;if(this[_0x3f5365(0xac4)]()[_0x3f5365(0x74f)][_0x3f5365(0x21d)](/<BATTLER SPRITE CANNOT MOVE>/i))return![];return Game_Battler[_0x3f5365(0xa60)][_0x3f5365(0x76b)][_0x3f5365(0x9b5)](this);},Game_Enemy['prototype']['isBattlerGrounded']=function(){const _0xc4a740=_0xa8cad7;if(this[_0xc4a740(0xac4)]()[_0xc4a740(0x74f)][_0xc4a740(0x21d)](/<BATTLER SPRITE GROUNDED>/i))return!![];return![];},Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x579)]=function(){const _0x2aec20=_0xa8cad7,_0x1fc34c=[];for(const _0x50c18 of this[_0x2aec20(0xac4)]()['actions']){if(_0x2aec20(0xb1a)!==_0x2aec20(0xb1a))this['addPartyCommand']();else{const _0x207cf0=$dataSkills[_0x50c18[_0x2aec20(0x258)]];if(_0x207cf0&&!_0x1fc34c[_0x2aec20(0x220)](_0x207cf0))_0x1fc34c[_0x2aec20(0x6c0)](_0x207cf0);}}return _0x1fc34c;},Game_Enemy['prototype'][_0xa8cad7(0x206)]=function(){const _0x4e9fcf=_0xa8cad7;let _0x187fbc='battleUIOffsetX';if(this[_0x4e9fcf(0x82a)](_0x187fbc))return this['_cache'][_0x187fbc];return this[_0x4e9fcf(0x4d0)][_0x187fbc]=this[_0x4e9fcf(0x9f2)](this[_0x4e9fcf(0xac4)]()),this[_0x4e9fcf(0x4d0)][_0x187fbc];},Game_Enemy['prototype'][_0xa8cad7(0x705)]=function(){const _0x88ca02=_0xa8cad7;let _0x4f87af=_0x88ca02(0x705);if(this[_0x88ca02(0x82a)](_0x4f87af))return this[_0x88ca02(0x4d0)][_0x4f87af];return this[_0x88ca02(0x4d0)][_0x4f87af]=this['createBattleUIOffsetY'](this[_0x88ca02(0xac4)]()),this['_cache'][_0x4f87af];},Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x418)]=function(){const _0x4503e7=_0xa8cad7;if(this[_0x4503e7(0x9b7)]!==undefined)return this['_svBattlerData'];return this[_0x4503e7(0x8a3)](),this['_svBattlerData'];},Game_Enemy[_0xa8cad7(0xa60)]['hasSvBattler']=function(){const _0xe352b6=_0xa8cad7;return this[_0xe352b6(0x418)]()[_0xe352b6(0x9a6)]!=='';},Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x742)]=function(){const _0x2abdd3=_0xa8cad7;return this[_0x2abdd3(0x418)]()[_0x2abdd3(0x9a6)];},Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x2ea)]=function(){const _0x24fe3c=_0xa8cad7;if(this['hasSvBattler']()){if('UvCEL'===_0x24fe3c(0x66f)){this[_0x24fe3c(0x853)]=[];for(let _0x482187=0x0;_0x482187<_0x445ec6[_0x24fe3c(0xa1f)]();_0x482187++){const _0x4274ad=_0x550c3d[_0x24fe3c(0x321)]()[_0x482187],_0x3d9d82=new _0x43dfba();_0x3d9d82['moveToStartPositionBattleCore'](_0x4274ad),_0x3d9d82[_0x24fe3c(0x393)](_0x4274ad),_0x3d9d82[_0x24fe3c(0x99e)](),this['_actorSprites'][_0x24fe3c(0x6c0)](_0x3d9d82),this[_0x24fe3c(0x4ee)][_0x24fe3c(0x9ac)](_0x3d9d82);}}else return VisuMZ[_0x24fe3c(0x8a9)]['Settings'][_0x24fe3c(0x3d8)][_0x24fe3c(0x115)];}else{if(_0x24fe3c(0x542)!==_0x24fe3c(0x905))return VisuMZ[_0x24fe3c(0x8a9)][_0x24fe3c(0xb57)][_0x24fe3c(0x8d5)]['SmoothImage'];else this[_0x24fe3c(0x5b0)]();}},Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x1d7)]=function(_0x775e4d){const _0x5409c3=_0xa8cad7;Game_Battler[_0x5409c3(0xa60)][_0x5409c3(0x1d7)]['call'](this,_0x775e4d);if(this[_0x5409c3(0xb29)]())this[_0x5409c3(0x482)](_0x775e4d);},Game_Enemy[_0xa8cad7(0xa60)]['performAttack']=function(){const _0x1e22db=_0xa8cad7,_0x2e1971=this[_0x1e22db(0x418)]()[_0x1e22db(0x90a)]||0x0,_0x3b2294=$dataSystem[_0x1e22db(0x394)][_0x2e1971];if(_0x3b2294){if(_0x3b2294[_0x1e22db(0x4fb)]===0x0)this['requestMotion'](_0x1e22db(0x5ca));else{if(_0x3b2294[_0x1e22db(0x4fb)]===0x1){if(_0x1e22db(0x946)==='iVmTo'){const _0x40704f=_0x14eaa2[_0x1e22db(0x673)](_0x9bc783);_0x40704f[_0x1e22db(0x901)]=![],_0x40704f[_0x1e22db(0xb8b)]=![],_0x40704f[_0x1e22db(0xb4d)]=0x0,this['_damagePopupArray'][_0x1e22db(0x6c0)](_0x40704f);}else this[_0x1e22db(0x300)](_0x1e22db(0x918));}else _0x3b2294[_0x1e22db(0x4fb)]===0x2&&this[_0x1e22db(0x300)](_0x1e22db(0xb79));}}},Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x932)]=function(){const _0x3244f5=_0xa8cad7,_0x3416f2=this[_0x3244f5(0x418)]()[_0x3244f5(0x90a)]||0x0,_0x51e7b6=$dataSystem['attackMotions'][_0x3416f2];_0x51e7b6&&this['startWeaponAnimation'](_0x51e7b6[_0x3244f5(0x73c)]);},Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x4d9)]=function(){const _0x427f05=_0xa8cad7,_0x2abacd=this[_0x427f05(0x418)]()[_0x427f05(0x90a)]||0x0;return $dataSystem[_0x427f05(0x394)][_0x2abacd];},Game_Enemy['prototype'][_0xa8cad7(0x3b2)]=function(_0x33c5ca){return this['getAttackMotion']();},Game_Enemy['prototype'][_0xa8cad7(0x70f)]=function(){const _0x468701=_0xa8cad7;Game_Battler[_0x468701(0xa60)]['performDamage']['call'](this),this[_0x468701(0x9f6)]()&&this[_0x468701(0xb29)]()&&(_0x468701(0x2ad)===_0x468701(0x2ad)?this[_0x468701(0x300)]('damage'):this[_0x468701(0x3a8)]=_0x75baa8),SoundManager['playEnemyDamage']();},Game_Enemy[_0xa8cad7(0xa60)]['performEvasion']=function(){const _0xbfb658=_0xa8cad7;Game_Battler[_0xbfb658(0xa60)][_0xbfb658(0x91e)][_0xbfb658(0x9b5)](this),this[_0xbfb658(0x300)](_0xbfb658(0xa8e));},Game_Enemy['prototype'][_0xa8cad7(0x885)]=function(){const _0x4b824c=_0xa8cad7;Game_Battler['prototype'][_0x4b824c(0x885)][_0x4b824c(0x9b5)](this),this[_0x4b824c(0x300)]('evade');},Game_Enemy['prototype']['performCounter']=function(){const _0x33b1f0=_0xa8cad7;Game_Battler[_0x33b1f0(0xa60)][_0x33b1f0(0x729)][_0x33b1f0(0x9b5)](this),this[_0x33b1f0(0x4fc)]();},Game_Enemy['prototype'][_0xa8cad7(0x4ec)]=function(){const _0xb0b91e=_0xa8cad7;if(this[_0xb0b91e(0xb29)]()){if(this['collapseType']()>=0x1)return!![];return this[_0xb0b91e(0x418)]()[_0xb0b91e(0x81c)];}else return!![];},Game_Enemy[_0xa8cad7(0xa60)]['svBattlerAnchorX']=function(){const _0x575f06=_0xa8cad7;return this[_0x575f06(0x418)]()['anchorX'];},Game_Enemy[_0xa8cad7(0xa60)]['svBattlerAnchorY']=function(){const _0x4dfb93=_0xa8cad7;return this['svBattlerData']()[_0x4dfb93(0xadf)];},Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x4f9)]=function(){const _0x290e93=_0xa8cad7;return this['svBattlerData']()[_0x290e93(0x276)];},VisuMZ['BattleCore'][_0xa8cad7(0x948)]=Game_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x95e)],Game_Enemy[_0xa8cad7(0xa60)]['transform']=function(_0x47a95c){const _0x4ebfbb=_0xa8cad7;VisuMZ[_0x4ebfbb(0x8a9)][_0x4ebfbb(0x948)][_0x4ebfbb(0x9b5)](this,_0x47a95c),this[_0x4ebfbb(0x7f6)](),this[_0x4ebfbb(0x8a3)]();const _0x4eaca8=this[_0x4ebfbb(0xac0)]();if(_0x4eaca8)_0x4eaca8[_0x4ebfbb(0x393)](this);},Game_Unit[_0xa8cad7(0xa60)][_0xa8cad7(0x75f)]=function(_0x1a4c97){const _0x4c6adf=_0xa8cad7;for(const _0x2f56f4 of this[_0x4c6adf(0x563)]()){if(_0x2f56f4)_0x2f56f4[_0x4c6adf(0x75f)](_0x1a4c97);}},Game_Unit[_0xa8cad7(0xa60)][_0xa8cad7(0x2bc)]=function(){const _0x46ba78=_0xa8cad7,_0x58a327=this[_0x46ba78(0x209)]();return _0x58a327[Math['randomInt'](_0x58a327['length'])];},VisuMZ[_0xa8cad7(0x8a9)]['Game_Party_addActor']=Game_Party[_0xa8cad7(0xa60)][_0xa8cad7(0x866)],Game_Party['prototype'][_0xa8cad7(0x866)]=function(_0x1d7969){const _0x2c6e7f=_0xa8cad7;VisuMZ[_0x2c6e7f(0x8a9)]['Game_Party_addActor'][_0x2c6e7f(0x9b5)](this,_0x1d7969),BattleManager[_0x2c6e7f(0x3da)]();},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x16f)]=Game_Party[_0xa8cad7(0xa60)][_0xa8cad7(0x2b5)],Game_Party[_0xa8cad7(0xa60)][_0xa8cad7(0x2b5)]=function(_0x6b6c8d){const _0x12714e=_0xa8cad7;VisuMZ[_0x12714e(0x8a9)]['Game_Party_removeActor'][_0x12714e(0x9b5)](this,_0x6b6c8d),BattleManager[_0x12714e(0x3da)]();},VisuMZ['BattleCore'][_0xa8cad7(0x80b)]=Game_Troop[_0xa8cad7(0xa60)][_0xa8cad7(0xb84)],Game_Troop['prototype'][_0xa8cad7(0xb84)]=function(_0x510030){const _0x4213f5=_0xa8cad7;$gameTemp[_0x4213f5(0x999)](),$gameTemp[_0x4213f5(0xb42)](_0x510030),VisuMZ[_0x4213f5(0x8a9)]['Game_Troop_setup']['call'](this,_0x510030);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x6d8)]=Game_Troop['prototype'][_0xa8cad7(0x9f7)],Game_Troop[_0xa8cad7(0xa60)][_0xa8cad7(0x9f7)]=function(){const _0x58095d=_0xa8cad7;let _0x3f213b=VisuMZ[_0x58095d(0x8a9)][_0x58095d(0x6d8)][_0x58095d(0x9b5)](this);return this['expRate']&&(_0x3f213b*=this[_0x58095d(0x273)]()),Math[_0x58095d(0x412)](_0x3f213b);},Game_Troop[_0xa8cad7(0xa60)][_0xa8cad7(0x273)]=function(){return 0x1;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x690)]=Game_Map[_0xa8cad7(0xa60)][_0xa8cad7(0x8e1)],Game_Map[_0xa8cad7(0xa60)][_0xa8cad7(0x8e1)]=function(){const _0x412c07=_0xa8cad7;VisuMZ[_0x412c07(0x8a9)][_0x412c07(0x690)][_0x412c07(0x9b5)](this),this[_0x412c07(0x35b)]();},Game_Map[_0xa8cad7(0xa60)][_0xa8cad7(0x35b)]=function(){const _0x480c63=_0xa8cad7;this[_0x480c63(0x1a4)]={},this[_0x480c63(0x140)]={};if(!$dataMap)return;const _0x19e386=$dataMap[_0x480c63(0x74f)];if(!_0x19e386)return;const _0x4a744d=_0x19e386[_0x480c63(0x21d)](/<REGION (\d+) BATTLEBACK(\d+): (.*)>/gi);if(_0x4a744d){if(_0x480c63(0x7f7)!==_0x480c63(0x226))for(const _0x39f1b0 of _0x4a744d){_0x39f1b0['match'](/<REGION (\d+) BATTLEBACK(\d+): (.*)>/i);const _0x1acc3e=Number(RegExp['$1']),_0x336607=Number(RegExp['$2']),_0x415e2f=_0x336607===0x1?this['_regionBattleback1']:this[_0x480c63(0x140)],_0x53e8bd=String(RegExp['$3']);_0x415e2f[_0x1acc3e]=_0x53e8bd;}else _0x55c6a3[_0x480c63(0x381)]=_0x3dd43d['_ptbActionCost']||{},_0x5e2b92['_ptbActionCost'][_0x480c63(0x96e)]=0x0;}},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x805)]=Game_Map[_0xa8cad7(0xa60)]['battleback1Name'],Game_Map[_0xa8cad7(0xa60)]['battleback1Name']=function(){const _0x20f01c=_0xa8cad7;if(!BattleManager[_0x20f01c(0x291)]()){if('bxzFY'!==_0x20f01c(0x7bb)){const _0x21f7a8=this[_0x20f01c(0x818)]['worldTransform'][_0x20f01c(0x5b6)](new _0x4c1499(0x0,0x0)),_0x3902d9=this[_0x20f01c(0x818)][_0x20f01c(0x99a)];_0x3902d9['x']=_0x21f7a8['x']+this[_0x20f01c(0x3f8)]['x'],_0x3902d9['y']=_0x21f7a8['y']+this['origin']['y'],_0x3902d9[_0x20f01c(0x960)]=this['innerWidth'],_0x3902d9[_0x20f01c(0xa97)]=this['innerHeight'];}else{const _0x49a177=$gamePlayer[_0x20f01c(0x65d)]($gamePlayer['x'],$gamePlayer['y']);if(this[_0x20f01c(0x1a4)]&&this[_0x20f01c(0x1a4)][_0x49a177])return this['_regionBattleback1'][_0x49a177];}}return VisuMZ['BattleCore'][_0x20f01c(0x805)][_0x20f01c(0x9b5)](this);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x68a)]=Game_Map['prototype'][_0xa8cad7(0xae9)],Game_Map['prototype'][_0xa8cad7(0xae9)]=function(){const _0x188f46=_0xa8cad7;if(!BattleManager[_0x188f46(0x291)]()){const _0x5e190b=$gamePlayer[_0x188f46(0x65d)]($gamePlayer['x'],$gamePlayer['y']);if(this[_0x188f46(0x1a4)]&&this['_regionBattleback2'][_0x5e190b]){if(_0x188f46(0x294)!==_0x188f46(0xaad))return this['_regionBattleback2'][_0x5e190b];else _0x4aeeb2=_0x4f8ffc>=_0x3682d7?_0x3ebccf:_0x4e7608;}}return VisuMZ[_0x188f46(0x8a9)][_0x188f46(0x68a)][_0x188f46(0x9b5)](this);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x490)]=Game_Map[_0xa8cad7(0xa60)]['encounterList'],Game_Map[_0xa8cad7(0xa60)][_0xa8cad7(0x831)]=function(){const _0x58153c=_0xa8cad7;let _0xd5ded3=JsonEx[_0x58153c(0x673)](VisuMZ[_0x58153c(0x8a9)][_0x58153c(0x490)][_0x58153c(0x9b5)](this));return VisuMZ[_0x58153c(0x8a9)][_0x58153c(0x34b)](_0xd5ded3);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x34b)]=function(_0x1e40a8){const _0x22b7a3=_0xa8cad7;var _0x14778f,_0x95a309,_0x4d22d5;for(_0x4d22d5=_0x1e40a8['length']-0x1;_0x4d22d5>0x0;_0x4d22d5--){_0x14778f=Math[_0x22b7a3(0xb05)](Math[_0x22b7a3(0x2c5)]()*(_0x4d22d5+0x1)),_0x95a309=_0x1e40a8[_0x4d22d5],_0x1e40a8[_0x4d22d5]=_0x1e40a8[_0x14778f],_0x1e40a8[_0x14778f]=_0x95a309;}return _0x1e40a8;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x5c1)]=Game_Interpreter[_0xa8cad7(0xa60)][_0xa8cad7(0x5ab)],Game_Interpreter[_0xa8cad7(0xa60)][_0xa8cad7(0x5ab)]=function(_0x343b4a){const _0x4c0a7b=_0xa8cad7;return $gameTemp[_0x4c0a7b(0x2fd)](this),VisuMZ[_0x4c0a7b(0x8a9)][_0x4c0a7b(0x5c1)]['call'](this,_0x343b4a);},VisuMZ[_0xa8cad7(0x8a9)]['Game_Interpreter_updateWaitMode']=Game_Interpreter[_0xa8cad7(0xa60)][_0xa8cad7(0x85e)],Game_Interpreter['prototype'][_0xa8cad7(0x85e)]=function(){const _0x49eece=_0xa8cad7;if(SceneManager[_0x49eece(0x45f)]()){if(_0x49eece(0x17e)===_0x49eece(0x7c9))_0x3d8d71[_0x49eece(0x8a9)][_0x49eece(0x56c)][_0x49eece(0x9b5)](this,_0x224c72),this[_0x49eece(0x16c)](_0x1b8a51);else switch(this[_0x49eece(0x4c2)]){case _0x49eece(0xab3):if(Imported[_0x49eece(0x1d1)]){if($gameScreen[_0x49eece(0x4bb)]()[_0x49eece(0x8a6)]>0x0)return!![];this[_0x49eece(0x4c2)]='';}break;case _0x49eece(0x607):if(BattleManager[_0x49eece(0x726)][_0x49eece(0x396)]())return!![];this[_0x49eece(0x4c2)]='';break;case _0x49eece(0x7f9):if(Imported[_0x49eece(0x1d1)]){if(_0x49eece(0x915)==='ujMUB'){if($gameScreen['battleCameraData']()['cameraDuration']>0x0)return!![];if($gameScreen[_0x49eece(0x4bb)]()[_0x49eece(0x561)]>0x0)return!![];this[_0x49eece(0x4c2)]='';}else{const _0x4a6f04=_0xee8b77['BattleCore'][_0x49eece(0xb57)][_0x49eece(0x56f)];if(_0x4a6f04[_0x49eece(0x89c)])return;_0x5e409f[_0x49eece(0xa60)][_0x49eece(0x545)]['call'](this,_0x47b288);}}break;case'battleEffect':if(BattleManager[_0x49eece(0x726)]['isEffecting']())return!![];this[_0x49eece(0x4c2)]='';break;case _0x49eece(0x436):if(BattleManager[_0x49eece(0x726)][_0x49eece(0x4aa)]())return!![];this['_waitMode']='';break;case'battleJump':if(BattleManager[_0x49eece(0x726)][_0x49eece(0x4d1)]())return!![];this[_0x49eece(0x4c2)]='';break;case _0x49eece(0x3b9):if(BattleManager['_logWindow'][_0x49eece(0xb15)]())return!![];this['_waitMode']='';break;case _0x49eece(0xadc):if(BattleManager['_spriteset'][_0x49eece(0x190)]())return!![];this[_0x49eece(0x4c2)]='';break;case _0x49eece(0x337):if(BattleManager[_0x49eece(0x726)][_0x49eece(0x261)]())return!![];this[_0x49eece(0x4c2)]='';break;case _0x49eece(0x6c8):if(BattleManager[_0x49eece(0x726)]['isAnyoneGrowing']())return!![];this[_0x49eece(0x4c2)]='';break;case _0x49eece(0x34d):if(BattleManager[_0x49eece(0x726)]['isAnyoneSkewing']())return!![];this[_0x49eece(0x4c2)]='';break;case'battleProjectiles':if(Imported['VisuMZ_3_ActSeqProjectiles']){if(BattleManager[_0x49eece(0x726)][_0x49eece(0x4ac)]())return!![];this[_0x49eece(0x4c2)]='';}break;case _0x49eece(0x67a):if(Imported[_0x49eece(0x1d1)]){if($gameScreen[_0x49eece(0x4bb)]()[_0x49eece(0xb5b)]>0x0)return!![];this[_0x49eece(0x4c2)]='';}break;case'battleSpin':if(BattleManager[_0x49eece(0x726)][_0x49eece(0x6ef)]())return!![];this[_0x49eece(0x4c2)]='';break;case _0x49eece(0x90f):if(Imported[_0x49eece(0x1d1)]){if($gameScreen[_0x49eece(0x4bb)]()[_0x49eece(0x8bd)]>0x0)return!![];this['_waitMode']='';}break;}}return VisuMZ[_0x49eece(0x8a9)][_0x49eece(0x79c)][_0x49eece(0x9b5)](this);},VisuMZ[_0xa8cad7(0x8a9)]['Game_Interpreter_command301']=Game_Interpreter[_0xa8cad7(0xa60)][_0xa8cad7(0x6b1)],Game_Interpreter['prototype'][_0xa8cad7(0x6b1)]=function(_0x398250){const _0x1c66a8=_0xa8cad7;return!$gameParty['inBattle']()?this[_0x1c66a8(0x40b)](_0x398250):VisuMZ[_0x1c66a8(0x8a9)][_0x1c66a8(0x1a0)]['call'](this,_0x398250);},Game_Interpreter[_0xa8cad7(0xa60)][_0xa8cad7(0x1fd)]=function(_0x3d99d8){const _0x215b53=_0xa8cad7;return VisuMZ['BattleCore'][_0x215b53(0x1a0)][_0x215b53(0x9b5)](this,_0x3d99d8),BattleManager['setEventCallback'](_0x2cf064=>{const _0x572534=_0x215b53;this[_0x572534(0x70d)][this['_indent']]=_0x2cf064;}),!![];},VisuMZ[_0xa8cad7(0x8a9)]['CheckMapBattleEventValid']=function(_0x40703f){const _0x2224eb=_0xa8cad7,_0x5f0e25=$dataCommonEvents[_0x40703f];if(!_0x5f0e25)return![];if(_0x5f0e25[_0x2224eb(0x8cb)]['length']<=0x1)return![];return!![];},Game_Interpreter[_0xa8cad7(0xa60)][_0xa8cad7(0x40b)]=function(_0x134481){const _0x2c1286=_0xa8cad7,_0x125df8=VisuMZ[_0x2c1286(0x8a9)]['Settings']['Mechanics'],_0x4bb383=_0x125df8[_0x2c1286(0x1b4)],_0xfd23e0=$dataCommonEvents[_0x4bb383];if(_0xfd23e0&&VisuMZ[_0x2c1286(0x8a9)]['CheckMapBattleEventValid'](_0x4bb383)){const _0x4f085c=this['isOnCurrentMap']()?this['_eventId']:0x0,_0x25d06f=_0xfd23e0[_0x2c1286(0x8cb)];this['setupChild'](_0x25d06f,_0x4f085c),this[_0x2c1286(0x525)]=JsonEx[_0x2c1286(0x673)](this['_list']);const _0x368c16={'code':0xbc3,'indent':this['_indent'],'parameters':JsonEx[_0x2c1286(0x673)](_0x134481)};return this[_0x2c1286(0x525)][_0x2c1286(0x758)](this['_index']+0x1,0x0,_0x368c16),!![];}else{if(_0x2c1286(0xb00)!==_0x2c1286(0xb00)){if(_0x422a['match'](/(.*):[ ](\d+)/i)){const _0x24f8dd=_0x53e87a(_0x3035f2['$1'])[_0x2c1286(0xb45)](),_0x52e8f0=_0xa44587(_0x5e33b2['$2']);_0x22b906[_0x24f8dd]=_0x52e8f0,_0x30c2c7+=_0x52e8f0;}else{if(_0x49544e[_0x2c1286(0x21d)](/(.*):[ ](\d+\.?\d+)/i)){const _0x52983b=_0x196268(_0x4b6846['$1'])[_0x2c1286(0xb45)](),_0x506653=_0x3c159a(_0x4747d8['$2']);_0x3636fc[_0x52983b]=_0x506653,_0x7e161+=_0x506653;}else _0x20c702!==''&&(_0x81c328[_0x29ae7d]=0x1,_0x520d0e++);}}else return VisuMZ[_0x2c1286(0x8a9)][_0x2c1286(0x1a0)]['call'](this,_0x134481);}},VisuMZ['BattleCore'][_0xa8cad7(0x7c6)]=BattleManager[_0xa8cad7(0xa6d)],BattleManager[_0xa8cad7(0xa6d)]=function(){const _0x2a636a=_0xa8cad7;VisuMZ[_0x2a636a(0x8a9)]['BattleManager_onEncounter'][_0x2a636a(0x9b5)](this),this[_0x2a636a(0x911)]();},BattleManager[_0xa8cad7(0x911)]=function(){const _0x290120=_0xa8cad7,_0x4d6594=VisuMZ[_0x290120(0x8a9)][_0x290120(0xb57)][_0x290120(0x5e4)],_0x28b1ee=_0x4d6594['BattleStartEvent'];_0x28b1ee&&VisuMZ[_0x290120(0x8a9)][_0x290120(0x6b5)](_0x28b1ee)&&(this[_0x290120(0x3a5)]=!![],$gameTemp[_0x290120(0xa71)](_0x4d6594['BattleStartEvent']),$gameMap['updateInterpreter'](),$gameMap['_interpreter'][_0x290120(0xac6)]=!![]),_0x4d6594[_0x290120(0x182)]>0x0&&(this['_canLose']=!![]);},VisuMZ['BattleCore'][_0xa8cad7(0x390)]=Scene_Map[_0xa8cad7(0xa60)][_0xa8cad7(0x666)],Scene_Map[_0xa8cad7(0xa60)]['updateCallMenu']=function(){const _0x55dd5e=_0xa8cad7;if(BattleManager[_0x55dd5e(0x3a5)])return;VisuMZ[_0x55dd5e(0x8a9)][_0x55dd5e(0x390)][_0x55dd5e(0x9b5)](this);},VisuMZ['BattleCore'][_0xa8cad7(0x627)]=Scene_Map[_0xa8cad7(0xa60)][_0xa8cad7(0x575)],Scene_Map[_0xa8cad7(0xa60)][_0xa8cad7(0x575)]=function(){const _0x4517fe=_0xa8cad7;if(BattleManager[_0x4517fe(0x3a5)]){if(_0x4517fe(0x382)!=='maNqW')return this[_0x4517fe(0x4f1)](_0x2939c3);else this[_0x4517fe(0x572)]();}else VisuMZ['BattleCore']['Scene_Map_launchBattle'][_0x4517fe(0x9b5)](this);},Scene_Map['prototype']['battleCorePreBattleCommonEvent']=function(){this['_active']=!![];},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x278)]=SceneManager['isSceneChanging'],SceneManager[_0xa8cad7(0x839)]=function(){const _0x494ab1=_0xa8cad7;if(BattleManager[_0x494ab1(0x3a5)])return![];return VisuMZ['BattleCore'][_0x494ab1(0x278)][_0x494ab1(0x9b5)](this);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x6f7)]=Game_Interpreter[_0xa8cad7(0xa60)]['terminate'],Game_Interpreter['prototype']['terminate']=function(){const _0x32cc97=_0xa8cad7;VisuMZ[_0x32cc97(0x8a9)][_0x32cc97(0x6f7)][_0x32cc97(0x9b5)](this),this['_preBattleCommonEvent']&&(this[_0x32cc97(0xac6)]=undefined,SceneManager['_scene'][_0x32cc97(0x176)]());},Scene_Map['prototype'][_0xa8cad7(0x176)]=function(){const _0x1b83e5=_0xa8cad7;BattleManager['_battleCoreBattleStartEvent']=undefined,BattleManager['_battleCoreBattleResumeAfter']=!![],this[_0x1b83e5(0x380)]();},VisuMZ[_0xa8cad7(0x8a9)]['Scene_Map_initializeAfter']=Scene_Map[_0xa8cad7(0xa60)]['initialize'],Scene_Map[_0xa8cad7(0xa60)][_0xa8cad7(0x4a7)]=function(){const _0x3b3192=_0xa8cad7;VisuMZ[_0x3b3192(0x8a9)][_0x3b3192(0x27c)][_0x3b3192(0x9b5)](this),BattleManager[_0x3b3192(0x967)]&&(this[_0x3b3192(0x510)]=!![],BattleManager[_0x3b3192(0x967)]=undefined);},VisuMZ['BattleCore']['Scene_Map_initialize']=Scene_Map[_0xa8cad7(0xa60)][_0xa8cad7(0x4a7)],Scene_Map[_0xa8cad7(0xa60)]['initialize']=function(){const _0x192734=_0xa8cad7;VisuMZ[_0x192734(0x8a9)][_0x192734(0x9d1)][_0x192734(0x9b5)](this),$gameTemp['clearForcedGameTroopSettingsBattleCore']();},VisuMZ['BattleCore'][_0xa8cad7(0x3cb)]=Scene_ItemBase[_0xa8cad7(0xa60)][_0xa8cad7(0x5e0)],Scene_ItemBase['prototype'][_0xa8cad7(0x5e0)]=function(){const _0x3d436d=_0xa8cad7;VisuMZ[_0x3d436d(0x8a9)][_0x3d436d(0x3cb)][_0x3d436d(0x9b5)](this),this['item']()[_0x3d436d(0x74f)]['match'](/<CUSTOM ACTION SEQUENCE>/i)&&($gameTemp['_commonEventQueue']=[]),DataManager[_0x3d436d(0x583)](this[_0x3d436d(0x191)]())&&(_0x3d436d(0x4e2)!==_0x3d436d(0x4e2)?this[_0x3d436d(0x828)](_0x3d436d(0x18e)):$gameTemp[_0x3d436d(0x7b4)]=[]);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x2bd)]=Scene_Options[_0xa8cad7(0xa60)][_0xa8cad7(0x1a5)],Scene_Options['prototype'][_0xa8cad7(0x1a5)]=function(){const _0x34f5f9=_0xa8cad7;let _0x47277a=VisuMZ[_0x34f5f9(0x8a9)][_0x34f5f9(0x2bd)][_0x34f5f9(0x9b5)](this);const _0x253395=VisuMZ[_0x34f5f9(0x8a9)][_0x34f5f9(0xb57)];if(_0x253395[_0x34f5f9(0xa3f)][_0x34f5f9(0x38b)]&&_0x253395[_0x34f5f9(0xa3f)]['AdjustRect'])_0x47277a+=0x2;if(_0x253395[_0x34f5f9(0xb2e)][_0x34f5f9(0x38b)]&&_0x253395[_0x34f5f9(0xb2e)][_0x34f5f9(0x4fa)])_0x47277a+=0x1;return _0x47277a;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x8bb)]=Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x4a7)],Scene_Battle[_0xa8cad7(0xa60)]['initialize']=function(){const _0x4d7ee8=_0xa8cad7;VisuMZ[_0x4d7ee8(0x8a9)][_0x4d7ee8(0x8bb)][_0x4d7ee8(0x9b5)](this),this['clearOnceParallelInterpreters']();},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x2a8)]=Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x623)],Scene_Battle[_0xa8cad7(0xa60)]['start']=function(){const _0x184885=_0xa8cad7;SceneManager['isPreviousSceneBattleTransitionable']()?(Scene_Message[_0x184885(0xa60)][_0x184885(0x623)][_0x184885(0x9b5)](this),this['_spriteset']&&this[_0x184885(0x726)]['update'](),BattleManager[_0x184885(0xb6b)]&&BattleManager['revertTpbCachedActor']()):VisuMZ[_0x184885(0x8a9)][_0x184885(0x2a8)]['call'](this);},VisuMZ[_0xa8cad7(0x8a9)]['Scene_Battle_stop']=Scene_Battle[_0xa8cad7(0xa60)]['stop'],Scene_Battle[_0xa8cad7(0xa60)]['stop']=function(){const _0x45f71a=_0xa8cad7;if(SceneManager[_0x45f71a(0x991)]()){if(_0x45f71a(0x315)===_0x45f71a(0x970)){if(!this[_0x45f71a(0x75e)]())return;const _0x370969=this[_0x45f71a(0x5da)](),_0x5e742a=_0x448558[_0x45f71a(0x8a9)]['Settings'][_0x45f71a(0xb35)]['CmdIconAutoBattle'],_0x3531ba=_0x370969==='text'?_0x5941e0[_0x45f71a(0x178)]:_0x45f71a(0x71f)[_0x45f71a(0x69b)](_0x5e742a,_0x23cc2e[_0x45f71a(0x178)]),_0x1cab90=this['isAutoBattleCommandEnabled']();this[_0x45f71a(0x87d)](_0x3531ba,_0x45f71a(0x178),_0x1cab90);}else Scene_Message['prototype'][_0x45f71a(0x380)][_0x45f71a(0x9b5)](this);}else VisuMZ[_0x45f71a(0x8a9)][_0x45f71a(0x505)][_0x45f71a(0x9b5)](this);},VisuMZ[_0xa8cad7(0x8a9)]['Scene_Battle_terminate']=Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x5b0)],Scene_Battle[_0xa8cad7(0xa60)]['terminate']=function(){const _0x5302cd=_0xa8cad7;SceneManager[_0x5302cd(0x991)]()?Scene_Message['prototype'][_0x5302cd(0x5b0)][_0x5302cd(0x9b5)](this):VisuMZ[_0x5302cd(0x8a9)][_0x5302cd(0x928)][_0x5302cd(0x9b5)](this),this[_0x5302cd(0x679)]();},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x70c)]=function(){const _0x38d565=_0xa8cad7;if(ConfigManager[_0x38d565(0xb10)]&&ConfigManager[_0x38d565(0x976)]!==undefined)return ConfigManager[_0x38d565(0x976)];else{if(this[_0x38d565(0x1cc)]()===_0x38d565(0xb48))return![];else{return Scene_Message[_0x38d565(0xa60)]['isRightInputMode']['call'](this);;}}},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x49c)]=Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x76f)],Scene_Battle['prototype']['createAllWindows']=function(){const _0xc58217=_0xa8cad7;this[_0xc58217(0xa16)](),VisuMZ[_0xc58217(0x8a9)]['Scene_Battle_createAllWindows'][_0xc58217(0x9b5)](this),this['createAutoBattleWindow']();},VisuMZ[_0xa8cad7(0x8a9)]['Scene_Battle_createCancelButton']=Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x17a)],Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x17a)]=function(){const _0x35754e=_0xa8cad7;VisuMZ[_0x35754e(0x8a9)]['Scene_Battle_createCancelButton'][_0x35754e(0x9b5)](this),this[_0x35754e(0x1cc)]()==='border'&&this[_0x35754e(0x185)]();},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x439)]=function(_0x402aa2){const _0x5b39eb=_0xa8cad7;_0x402aa2?(this[_0x5b39eb(0x954)]['x']=(Graphics[_0x5b39eb(0x960)]-Graphics['boxWidth'])/0x2,this[_0x5b39eb(0x954)]['y']=(Graphics[_0x5b39eb(0xa97)]-Graphics[_0x5b39eb(0x9ef)])/0x2):'kBRmr'===_0x5b39eb(0x768)?_0x338e0a=this['_baseLineStack'][this['_baseLineStack']['length']-0x1]:(this[_0x5b39eb(0x954)]['x']=Graphics['width']*0xa,this[_0x5b39eb(0x954)]['y']=Graphics[_0x5b39eb(0xa97)]*0xa);},VisuMZ[_0xa8cad7(0x8a9)]['Scene_Battle_selectNextCommand']=Scene_Battle['prototype'][_0xa8cad7(0x1aa)],Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x1aa)]=function(){const _0x38f7c1=_0xa8cad7,_0x440888=BattleManager[_0x38f7c1(0x3e7)]();VisuMZ['BattleCore'][_0x38f7c1(0x4c5)][_0x38f7c1(0x9b5)](this);if(_0x440888){if(_0x38f7c1(0x704)===_0x38f7c1(0xb93))_0x4323c9[_0x38f7c1(0xb84)](0x0);else{if(_0x440888===BattleManager[_0x38f7c1(0x3e7)]())return;if(_0x440888===BattleManager[_0x38f7c1(0x4d4)])return;if(_0x440888[_0x38f7c1(0xac0)]())_0x440888[_0x38f7c1(0xac0)]()['stepBack']();}}},VisuMZ['BattleCore'][_0xa8cad7(0x29f)]=Scene_Battle[_0xa8cad7(0xa60)]['selectPreviousCommand'],Scene_Battle['prototype'][_0xa8cad7(0x234)]=function(){const _0x32c287=_0xa8cad7,_0x34d2ee=BattleManager[_0x32c287(0x3e7)]();if(_0x34d2ee&&_0x34d2ee[_0x32c287(0xac0)])_0x34d2ee[_0x32c287(0xac0)]()[_0x32c287(0x596)]();VisuMZ[_0x32c287(0x8a9)][_0x32c287(0x29f)]['call'](this);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x703)]=Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x7b8)],Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x7b8)]=function(){const _0x47a4b1=_0xa8cad7;if(VisuMZ['BattleCore']['Settings'][_0x47a4b1(0x6df)][_0x47a4b1(0x738)])return VisuMZ[_0x47a4b1(0x8a9)][_0x47a4b1(0xb57)][_0x47a4b1(0x6df)][_0x47a4b1(0x738)]['call'](this);return VisuMZ['BattleCore'][_0x47a4b1(0x703)][_0x47a4b1(0x9b5)](this);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xb19)]=Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x81b)],Scene_Battle['prototype'][_0xa8cad7(0x81b)]=function(){const _0x1550cb=_0xa8cad7;VisuMZ[_0x1550cb(0x8a9)][_0x1550cb(0xb19)][_0x1550cb(0x9b5)](this),this['createPartyCommandWindowBattleCore']();},Scene_Battle[_0xa8cad7(0xa60)]['createPartyCommandWindowBattleCore']=function(){const _0x47a8df=_0xa8cad7,_0x544314=this[_0x47a8df(0x148)];_0x544314[_0x47a8df(0x4d2)](_0x47a8df(0x178),this[_0x47a8df(0x904)][_0x47a8df(0x66e)](this)),_0x544314[_0x47a8df(0x4d2)](_0x47a8df(0x2a1),this['commandOptions'][_0x47a8df(0x66e)](this));const _0x6cd985=this['battleLayoutStyle']();switch(_0x6cd985){case'xp':case'portrait':return this[_0x47a8df(0x148)][_0x47a8df(0x882)](0x1);break;}},Scene_Battle[_0xa8cad7(0xa60)]['commandAutoBattle']=function(){const _0x413a50=_0xa8cad7;BattleManager[_0x413a50(0xb41)]=!![],$gameParty['makeActions'](),this[_0x413a50(0x1aa)](),BattleManager[_0x413a50(0x9af)]()&&(BattleManager[_0x413a50(0x362)]=![]);},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x404)]=function(){const _0x4b7565=_0xa8cad7;if(this[_0x4b7565(0xb6a)]())this['_callSceneOptions']=!![],this[_0x4b7565(0x896)]['push'](_0x4b7565(0xa27),VisuMZ[_0x4b7565(0x8a9)][_0x4b7565(0xb57)][_0x4b7565(0xb35)][_0x4b7565(0x9f8)]);else{if('oNNfu'===_0x4b7565(0x1f3))this['callOptions']();else{if(this[_0x4b7565(0xa7e)]){const _0x31fcc0=this[_0x4b7565(0xa7e)][_0x4b7565(0x379)],_0x4dba3f=this['width']-0x8,_0x47c7b8=this[_0x4b7565(0xa97)],_0x3694d2=this[_0x4b7565(0x1b8)],_0x13f17e=_0x2455fb[_0x4b7565(0x63a)](),_0x443e74=_0x33ebf8[_0x4b7565(0xb5c)]();this[_0x4b7565(0xa7e)]['x']=0x4,_0x31fcc0[_0x4b7565(0x24e)](_0x4dba3f,_0x47c7b8),_0x31fcc0[_0x4b7565(0x2bb)](0x0,0x0,_0x4dba3f,_0x3694d2,_0x443e74,_0x13f17e,!![]),_0x31fcc0[_0x4b7565(0x71a)](0x0,_0x3694d2,_0x4dba3f,_0x47c7b8-_0x3694d2*0x2,_0x13f17e),_0x31fcc0['gradientFillRect'](0x0,_0x47c7b8-_0x3694d2,_0x4dba3f,_0x3694d2,_0x13f17e,_0x443e74,!![]),this[_0x4b7565(0xa7e)][_0x4b7565(0xafe)](0x0,0x0,_0x4dba3f,_0x47c7b8);}}}},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0xb6a)]=function(){const _0x893d48=_0xa8cad7;return BattleManager[_0x893d48(0x6d5)]();},Scene_Battle['prototype'][_0xa8cad7(0x4b9)]=function(){const _0x549d28=_0xa8cad7;this[_0x549d28(0x5b9)]=![],this[_0x549d28(0x726)][_0x549d28(0x99e)](),this[_0x549d28(0x954)][_0x549d28(0x7d0)]=![];if(BattleManager[_0x549d28(0x291)]())_0x549d28(0x3f6)!==_0x549d28(0x19e)?($dataSystem['battleback1Name']||$dataSystem[_0x549d28(0xae9)])&&SceneManager[_0x549d28(0xa3c)]():this[_0x549d28(0xb6a)]()?(this[_0x549d28(0x5b9)]=!![],this[_0x549d28(0x896)]['push'](_0x549d28(0xa27),_0x23be9c['BattleCore'][_0x549d28(0xb57)][_0x549d28(0xb35)]['ActiveTpbOptionsMessage'])):this['callOptions']();else($gameMap['battleback1Name']()||$gameMap[_0x549d28(0xae9)]())&&(_0x549d28(0x685)!=='ktNav'?(_0x54bd4c&&(_0x25476f['_ptbActionCost']=_0x244a5e[_0x549d28(0x381)]||{},_0xa4725c['_ptbActionCost']['priority']=0x0),_0x55a5dd[_0x549d28(0x250)](_0x5e2fb1,_0x49115f,_0x3b97e2,_0x2ddff0)):SceneManager[_0x549d28(0xa3c)]());SceneManager[_0x549d28(0x6c0)](Scene_Options),BattleManager[_0x549d28(0x9af)]()&&(BattleManager[_0x549d28(0xb6b)]=BattleManager[_0x549d28(0x3e7)]());},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x89e)]=Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x205)],Scene_Battle[_0xa8cad7(0xa60)]['updateBattleProcess']=function(){const _0x5b72ff=_0xa8cad7;VisuMZ[_0x5b72ff(0x8a9)]['Scene_Battle_updateBattleProcess']['call'](this);if(this[_0x5b72ff(0x5b9)]&&!BattleManager[_0x5b72ff(0x4d4)])this[_0x5b72ff(0x4b9)]();this[_0x5b72ff(0x51b)]();},Scene_Battle['prototype'][_0xa8cad7(0x9cf)]=function(){const _0x2f779d=_0xa8cad7,_0x5e90be=this[_0x2f779d(0x2b2)]();this['_autoBattleWindow']=new Window_AutoBattleCancel(_0x5e90be),this[_0x2f779d(0x189)]['hide'](),this['addChild'](this[_0x2f779d(0x189)]);},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x2b2)]=function(){const _0x519c4e=_0xa8cad7;return VisuMZ[_0x519c4e(0x8a9)][_0x519c4e(0xb57)][_0x519c4e(0xa3f)][_0x519c4e(0x674)][_0x519c4e(0x9b5)](this);},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x679)]=function(){const _0x49e5d8=_0xa8cad7;this[_0x49e5d8(0x22d)]=[];},Scene_Battle[_0xa8cad7(0xa60)]['updateOnceParallelInterpreters']=function(){const _0x57329c=_0xa8cad7;if(!this[_0x57329c(0x22d)])return;for(const _0x4e0470 of this[_0x57329c(0x22d)]){_0x4e0470&&_0x4e0470['update']();}},Scene_Battle['prototype'][_0xa8cad7(0x5dc)]=function(_0x243e49){const _0x537757=_0xa8cad7,_0x18239e=$dataCommonEvents[_0x243e49];if(!_0x18239e)return;const _0x1dc0c1=new Game_BattleOnceParallelInterpreter();this[_0x537757(0x769)](_0x1dc0c1),_0x1dc0c1['setCommonEvent'](_0x243e49);},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x769)]=function(_0x4329bb){const _0x3530cd=_0xa8cad7;this[_0x3530cd(0x22d)]=this[_0x3530cd(0x22d)]||[],this[_0x3530cd(0x22d)][_0x3530cd(0x6c0)](_0x4329bb);},Scene_Battle['prototype']['removeOnceParallelInterpreter']=function(_0x1df6fb){const _0x296678=_0xa8cad7;this[_0x296678(0x22d)]=this[_0x296678(0x22d)]||[],this[_0x296678(0x22d)][_0x296678(0xafb)](_0x1df6fb);};function Game_BattleOnceParallelInterpreter(){const _0x99a0a7=_0xa8cad7;this[_0x99a0a7(0x4a7)](...arguments);}function _0xfe26(_0x46ea13,_0x20e41d){const _0x417524=_0x4175();return _0xfe26=function(_0xfe26ae,_0x5eb88d){_0xfe26ae=_0xfe26ae-0x115;let _0x3732c3=_0x417524[_0xfe26ae];return _0x3732c3;},_0xfe26(_0x46ea13,_0x20e41d);}Game_BattleOnceParallelInterpreter[_0xa8cad7(0xa60)]=Object[_0xa8cad7(0x423)](Game_Interpreter[_0xa8cad7(0xa60)]),Game_BattleOnceParallelInterpreter[_0xa8cad7(0xa60)][_0xa8cad7(0xa17)]=Game_BattleOnceParallelInterpreter,Game_BattleOnceParallelInterpreter[_0xa8cad7(0xa60)]['setCommonEvent']=function(_0x14257d){const _0x29e76c=_0xa8cad7,_0x249794=$dataCommonEvents[_0x14257d];_0x249794?this[_0x29e76c(0xb84)](_0x249794[_0x29e76c(0x8cb)],0x0):_0x29e76c(0x861)===_0x29e76c(0x850)?(_0x581f74[_0x29e76c(0x8a9)][_0x29e76c(0x173)]['call'](this),this[_0x29e76c(0xa8a)]()):this[_0x29e76c(0x5b0)]();},Game_BattleOnceParallelInterpreter['prototype'][_0xa8cad7(0x5b0)]=function(){const _0xa383ee=_0xa8cad7;if(!SceneManager[_0xa383ee(0x45f)]())return;SceneManager[_0xa383ee(0x26b)][_0xa383ee(0x8fd)](this),Game_Interpreter[_0xa383ee(0xa60)]['terminate']['call'](this);},Scene_Battle['prototype'][_0xa8cad7(0x48d)]=function(){const _0x4a585f=_0xa8cad7;return VisuMZ[_0x4a585f(0x8a9)][_0x4a585f(0xb57)]['PartyCmd'][_0x4a585f(0x53e)];},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x181)]=Scene_Battle['prototype'][_0xa8cad7(0x35c)],Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x35c)]=function(){const _0x3d72a7=_0xa8cad7;if(this[_0x3d72a7(0x48d)]()){if(_0x3d72a7(0xaa8)!==_0x3d72a7(0xaa8))return this[_0x3d72a7(0xa53)][_0x3d72a7(0x287)]();else this[_0x3d72a7(0x1ac)]();}else VisuMZ[_0x3d72a7(0x8a9)]['Scene_Battle_startPartyCommandSelection'][_0x3d72a7(0x9b5)](this);},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x1ac)]=function(){const _0x2b8346=_0xa8cad7;if(BattleManager[_0x2b8346(0x241)]())_0x2b8346(0x98e)===_0x2b8346(0x986)?this[_0x2b8346(0xa8a)]():this[_0x2b8346(0x1aa)]();else BattleManager[_0x2b8346(0x9af)]()&&VisuMZ[_0x2b8346(0x8a9)][_0x2b8346(0x181)][_0x2b8346(0x9b5)](this);},VisuMZ['BattleCore'][_0xa8cad7(0x9b3)]=Scene_Battle[_0xa8cad7(0xa60)]['commandFight'],Scene_Battle['prototype'][_0xa8cad7(0x72f)]=function(){const _0x3f12bf=_0xa8cad7;if(BattleManager['isTpb']())_0x3f12bf(0x9f0)!==_0x3f12bf(0xa69)?(this[_0x3f12bf(0x543)](),this['startActorCommandSelection']()):(_0xd172b6[_0x3f12bf(0x8a9)][_0x3f12bf(0x2f0)][_0x3f12bf(0x9b5)](this,_0x532488),this[_0x3f12bf(0xa8a)]());else{if(_0x3f12bf(0x59c)!=='qRweY')VisuMZ['BattleCore'][_0x3f12bf(0x9b3)][_0x3f12bf(0x9b5)](this);else{const _0x504b6e=_0x3dc67b['autoBattleStart'],_0x308fa6=_0x3f12bf(0x162);this[_0x3f12bf(0x87d)](_0x504b6e,_0x308fa6);}}},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x543)]=function(){const _0x39fdfb=_0xa8cad7;if(!VisuMZ['BattleCore'][_0x39fdfb(0x4c3)])return;if(Imported[_0x39fdfb(0x456)]&&BattleManager[_0x39fdfb(0x78e)]())return;const _0x32b300=$gameParty['aliveMembers']()['filter'](_0x63c2a4=>_0x63c2a4[_0x39fdfb(0x4bc)]()&&_0x63c2a4[_0x39fdfb(0x1bd)]());BattleManager[_0x39fdfb(0xa1b)]=_0x32b300[0x0]||null;if(BattleManager[_0x39fdfb(0xa1b)]){if(_0x39fdfb(0x822)==='JhVas')BattleManager['_currentActor']['setActionState'](_0x39fdfb(0x3d5));else{const _0x2cefde=_0x2ec1ac[_0x39fdfb(0x74f)];if(_0x2cefde['match'](/<SIDEVIEW SHADOW (?:SCALE|SCALE Y):[ ](\d+)([%％])>/i))return _0x1678e2(_0x37b8ac['$1'])*0.01;else{if(_0x2cefde['match'](/<SIDEVIEW SHADOW (?:SCALE|SCALE Y):[ ](.*)>/i))return _0x4f8eb(_0x154a73['$1'])||0x0;}}}},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x8f9)]=Scene_Battle['prototype'][_0xa8cad7(0x2bf)],Scene_Battle[_0xa8cad7(0xa60)]['createActorCommandWindow']=function(){const _0x40d2df=_0xa8cad7;VisuMZ['BattleCore'][_0x40d2df(0x8f9)][_0x40d2df(0x9b5)](this),this[_0x40d2df(0x183)]();},Scene_Battle['prototype']['createActorCommandWindowBattleCore']=function(){const _0x4296ff=_0xa8cad7,_0x31ed1d=this[_0x4296ff(0x9e9)];_0x31ed1d['setHandler']('escape',this[_0x4296ff(0x18f)]['bind'](this)),_0x31ed1d[_0x4296ff(0x4d2)](_0x4296ff(0x178),this[_0x4296ff(0x3d9)]['bind'](this)),_0x31ed1d[_0x4296ff(0x4d2)](_0x4296ff(0x374),this[_0x4296ff(0xa3e)][_0x4296ff(0x66e)](this));if(BattleManager[_0x4296ff(0x9af)]()){if(_0x4296ff(0x272)==='izXiC')this[_0x4296ff(0x48d)]()?'CepJC'!==_0x4296ff(0x584)?this[_0x4296ff(0x1e7)](_0x4296ff(0x949)):delete _0x31ed1d['_handlers']['cancel']:_0x31ed1d[_0x4296ff(0x4d2)](_0x4296ff(0xb3a),this[_0x4296ff(0x588)][_0x4296ff(0x66e)](this));else{if(_0x315726[_0x4296ff(0x45f)]()){const _0x47a65b=this[_0x4296ff(0xac0)]();_0x47a65b&&(_0x47a65b[_0x4296ff(0xa46)](_0x4f32cc),[_0x4296ff(0x918),_0x4296ff(0x5ca),_0x4296ff(0xb79)][_0x4296ff(0x220)](_0x99fb73)&&this[_0x4296ff(0x932)]());}this['clearFreezeMotion']();}}},Scene_Battle['prototype'][_0xa8cad7(0x18f)]=function(){const _0x1b8a4f=_0xa8cad7;this[_0x1b8a4f(0x94d)]();},Scene_Battle[_0xa8cad7(0xa60)]['actorCommandAutoBattle']=function(){const _0xfbd19f=_0xa8cad7;BattleManager[_0xfbd19f(0x3e7)]()[_0xfbd19f(0x79e)](),BattleManager[_0xfbd19f(0x557)](),BattleManager['selectNextActor'](),this[_0xfbd19f(0x998)]();},Scene_Battle[_0xa8cad7(0xa60)]['actorCommandSingleSkill']=function(){const _0x48dc57=_0xa8cad7,_0x2ed15a=BattleManager[_0x48dc57(0x1ad)]();_0x2ed15a[_0x48dc57(0x1a6)](this[_0x48dc57(0x9e9)][_0x48dc57(0x9b6)]()),this[_0x48dc57(0x7d5)]();},Scene_Battle[_0xa8cad7(0xa60)]['actorCommandCancelTPB']=function(){const _0x244e80=_0xa8cad7;this[_0x244e80(0x6ae)]()?this[_0x244e80(0x782)]():_0x244e80(0x925)!==_0x244e80(0x925)?this['initialize'](...arguments):this[_0x244e80(0xb31)]();},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x4c3)]=![],Scene_Battle['prototype'][_0xa8cad7(0x6ae)]=function(){const _0x409b41=_0xa8cad7;if(Imported['VisuMZ_2_BattleSystemCTB']&&BattleManager['isCTB']())return![];else{if(_0x409b41(0x2cd)!==_0x409b41(0x2b8)){if(!VisuMZ[_0x409b41(0x8a9)]['TpbActiveChangeEnabled'])return![];const _0x1bfd3e=$gameParty['aliveMembers']()['filter'](_0x51f3b3=>_0x51f3b3['isTpbCharged']()&&_0x51f3b3[_0x409b41(0x1bd)]());return _0x1bfd3e[_0x409b41(0x19c)]>0x0&&BattleManager[_0x409b41(0x3e7)]()!==_0x1bfd3e[_0x1bfd3e[_0x409b41(0x19c)]-0x1];}else _0x420585-=this[_0x409b41(0x669)],_0x477698-=this[_0x409b41(0x747)];}},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x782)]=function(){const _0x2f37ad=_0xa8cad7,_0x1b7a63=BattleManager[_0x2f37ad(0x3e7)](),_0x5ab85f=_0x1b7a63[_0x2f37ad(0xac0)]();if(_0x5ab85f)_0x5ab85f['stepBack']();const _0x59b889=$gameParty[_0x2f37ad(0x209)]()[_0x2f37ad(0x1d2)](_0x332c09=>_0x332c09['isTpbCharged']()&&_0x332c09[_0x2f37ad(0x1bd)]()),_0x5d7870=_0x59b889[_0x2f37ad(0x153)](_0x1b7a63),_0x32ceb=_0x59b889[_0x5d7870+0x1];BattleManager[_0x2f37ad(0xa1b)]=_0x32ceb||null;if(_0x32ceb)_0x32ceb[_0x2f37ad(0x323)](_0x2f37ad(0x3d5));_0x1b7a63[_0x2f37ad(0x323)](_0x2f37ad(0x706)),this[_0x2f37ad(0x998)]();},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0xb31)]=function(){const _0x5278e1=_0xa8cad7;this[_0x5278e1(0x148)][_0x5278e1(0xb84)](),this['_actorCommandWindow'][_0x5278e1(0x19b)]();if(!VisuMZ[_0x5278e1(0x8a9)][_0x5278e1(0x4c3)])return;if(Imported[_0x5278e1(0x456)]&&BattleManager[_0x5278e1(0x78e)]())return;if(BattleManager[_0x5278e1(0xa1b)]){BattleManager['_currentActor']['setActionState']('undecided');const _0x1345ce=BattleManager['_currentActor'][_0x5278e1(0xac0)]();if(_0x1345ce)_0x1345ce['stepBack']();}BattleManager['_currentActor']=null;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x7fb)]=Scene_Battle[_0xa8cad7(0xa60)]['createHelpWindow'],Scene_Battle['prototype']['createHelpWindow']=function(){const _0x4a185e=_0xa8cad7;VisuMZ[_0x4a185e(0x8a9)][_0x4a185e(0x7fb)][_0x4a185e(0x9b5)](this),this[_0x4a185e(0x9e5)]();},Scene_Battle[_0xa8cad7(0xa60)]['createHelpWindowBattleCore']=function(){const _0x50d307=_0xa8cad7;this[_0x50d307(0x9e9)][_0x50d307(0xad6)](this[_0x50d307(0x7a4)]),this[_0x50d307(0x148)][_0x50d307(0xad6)](this[_0x50d307(0x7a4)]);},Scene_Battle['prototype'][_0xa8cad7(0x1cc)]=function(){const _0x54ec86=_0xa8cad7;if($gameTemp[_0x54ec86(0x81e)]!==undefined)return $gameTemp[_0x54ec86(0x81e)];if(this['_battleLayoutStyle'])return this[_0x54ec86(0x7a9)];return this[_0x54ec86(0x7a9)]=VisuMZ[_0x54ec86(0x8a9)][_0x54ec86(0xb57)][_0x54ec86(0x56f)][_0x54ec86(0x44c)]['toLowerCase']()[_0x54ec86(0xb45)](),this[_0x54ec86(0x7a9)]===_0x54ec86(0x2c4)&&!Imported[_0x54ec86(0x8f5)]&&(this[_0x54ec86(0x7a9)]=_0x54ec86(0x7ae)),this[_0x54ec86(0x7a9)];},VisuMZ[_0xa8cad7(0x8a9)]['Scene_Battle_windowAreaHeight']=Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x65b)],Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x65b)]=function(){const _0x261c5c=_0xa8cad7,_0x368748=this[_0x261c5c(0x1cc)]();switch(_0x368748){case'list':return this[_0x261c5c(0x408)](Math[_0x261c5c(0x743)](0x1,$gameParty[_0x261c5c(0xa1f)]()),!![]);break;default:return VisuMZ[_0x261c5c(0x8a9)][_0x261c5c(0x364)][_0x261c5c(0x9b5)](this);break;}},VisuMZ['BattleCore'][_0xa8cad7(0x867)]=Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x4a1)],Scene_Battle['prototype'][_0xa8cad7(0x4a1)]=function(){const _0x20e969=_0xa8cad7,_0xf7727b=this[_0x20e969(0x1cc)]();switch(_0xf7727b){case'border':return this[_0x20e969(0xb25)]();break;case _0x20e969(0x7ae):case'list':case'xp':case'portrait':default:return VisuMZ['BattleCore'][_0x20e969(0x867)][_0x20e969(0x9b5)](this);break;}},Scene_Battle[_0xa8cad7(0xa60)]['statusWindowRect']=function(){const _0x31f03a=_0xa8cad7,_0x2f5ed8=this['battleLayoutStyle']();switch(_0x2f5ed8){case'xp':case _0x31f03a(0x33b):return this['statusWindowRectXPStyle']();break;case _0x31f03a(0xb48):return this[_0x31f03a(0x9bb)]();break;case _0x31f03a(0x7ae):case _0x31f03a(0x8cb):default:return this[_0x31f03a(0x7af)]();break;}},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x1f1)]=Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x74e)],Scene_Battle['prototype'][_0xa8cad7(0x74e)]=function(){const _0x3dee1e=_0xa8cad7,_0x287242=this[_0x3dee1e(0x1cc)]();switch(_0x287242){case'xp':case'portrait':return this['partyCommandWindowRectXPStyle']();break;case _0x3dee1e(0xb48):return this['partyCommandWindowRectBorderStyle']();case _0x3dee1e(0x7ae):case _0x3dee1e(0x8cb):default:return this[_0x3dee1e(0x6f1)]();break;}},Scene_Battle['prototype'][_0xa8cad7(0x6f1)]=function(){const _0xa60268=_0xa8cad7,_0x36a8be=VisuMZ[_0xa60268(0x8a9)][_0xa60268(0xb57)]['BattleLayout'],_0x2623e6=_0x36a8be[_0xa60268(0x1f7)]||0xc0,_0x296160=this[_0xa60268(0x65b)](),_0x4bfac2=this[_0xa60268(0x70c)]()?Graphics[_0xa60268(0x719)]-_0x2623e6:0x0,_0x28ca66=Graphics[_0xa60268(0x9ef)]-_0x296160;return new Rectangle(_0x4bfac2,_0x28ca66,_0x2623e6,_0x296160);},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x77f)]=function(){const _0x4bccbc=_0xa8cad7;return this[_0x4bccbc(0x74e)]();},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x52b)]=Scene_Battle[_0xa8cad7(0xa60)]['updateStatusWindowPosition'],Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x9b0)]=function(){const _0x5335f0=_0xa8cad7,_0x395d66=this[_0x5335f0(0x1cc)]();switch(_0x395d66){case'xp':case'portrait':case _0x5335f0(0xb48):break;case _0x5335f0(0x7ae):case _0x5335f0(0x8cb):default:VisuMZ[_0x5335f0(0x8a9)][_0x5335f0(0x52b)][_0x5335f0(0x9b5)](this);break;}},VisuMZ[_0xa8cad7(0x8a9)]['Scene_Battle_startActorSelection']=Scene_Battle['prototype']['startActorSelection'],Scene_Battle[_0xa8cad7(0xa60)]['startActorSelection']=function(){const _0x4f195c=_0xa8cad7;VisuMZ[_0x4f195c(0x8a9)][_0x4f195c(0x938)][_0x4f195c(0x9b5)](this),this[_0x4f195c(0x66c)]();},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xa68)]=Scene_Battle['prototype']['startEnemySelection'],Scene_Battle['prototype'][_0xa8cad7(0x85c)]=function(){const _0x35951e=_0xa8cad7;VisuMZ['BattleCore'][_0x35951e(0xa68)][_0x35951e(0x9b5)](this),this[_0x35951e(0x63b)][_0x35951e(0x340)](),this['makeTargetSelectionMoreVisible']();},Scene_Battle['prototype'][_0xa8cad7(0x66c)]=function(){const _0x357233=_0xa8cad7,_0x553e0a=this[_0x357233(0x1cc)]();['xp',_0x357233(0x33b),_0x357233(0xb48)][_0x357233(0x220)](_0x553e0a)&&this[_0x357233(0x9e9)][_0x357233(0x19b)](),(_0x553e0a===_0x357233(0xb48)||this[_0x357233(0x863)]())&&(this[_0x357233(0x539)]['close'](),this[_0x357233(0xac8)][_0x357233(0x19b)]());},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xb37)]=Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x77a)],Scene_Battle[_0xa8cad7(0xa60)]['onActorOk']=function(){const _0x1c48ee=_0xa8cad7;VisuMZ[_0x1c48ee(0x8a9)][_0x1c48ee(0xb37)][_0x1c48ee(0x9b5)](this),this[_0x1c48ee(0x934)]();},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x1f4)]=function(){const _0x31f47c=_0xa8cad7;return['attack',_0x31f47c(0x452),'singleSkill'][_0x31f47c(0x220)](this[_0x31f47c(0x9e9)][_0x31f47c(0x11b)]());},VisuMZ['BattleCore'][_0xa8cad7(0x84c)]=Scene_Battle['prototype'][_0xa8cad7(0x2e6)],Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x2e6)]=function(){const _0x2b287b=_0xa8cad7;this['isNonSubmenuCancel']()?(this[_0x2b287b(0x213)]['show'](),this[_0x2b287b(0x60a)][_0x2b287b(0x21c)](),this[_0x2b287b(0x9e9)][_0x2b287b(0x9c8)]()):VisuMZ[_0x2b287b(0x8a9)][_0x2b287b(0x84c)][_0x2b287b(0x9b5)](this),this[_0x2b287b(0x844)]();},VisuMZ[_0xa8cad7(0x8a9)]['Scene_Battle_onEnemyOk']=Scene_Battle[_0xa8cad7(0xa60)]['onEnemyOk'],Scene_Battle[_0xa8cad7(0xa60)]['onEnemyOk']=function(){const _0x38b80b=_0xa8cad7;VisuMZ[_0x38b80b(0x8a9)][_0x38b80b(0x1e9)][_0x38b80b(0x9b5)](this),this[_0x38b80b(0x934)]();},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x803)]=Scene_Battle[_0xa8cad7(0xa60)]['onEnemyCancel'],Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x6a3)]=function(){const _0x4b1035=_0xa8cad7;this[_0x4b1035(0x1f4)]()?(this[_0x4b1035(0x213)][_0x4b1035(0x518)](),this[_0x4b1035(0x63b)][_0x4b1035(0x21c)](),this['_actorCommandWindow'][_0x4b1035(0x9c8)]()):_0x4b1035(0x1c9)!==_0x4b1035(0x1c9)?(this[_0x4b1035(0x224)]=new _0x32cddd(),this['_shadowSprite'][_0x4b1035(0x379)]=_0x193ed9[_0x4b1035(0xb2a)](_0x4b1035(0x3fb)),this[_0x4b1035(0x224)][_0x4b1035(0x379)][_0x4b1035(0xb20)]=_0x1ae561[_0x4b1035(0x8a9)][_0x4b1035(0xb57)][_0x4b1035(0x3d8)][_0x4b1035(0x115)],this[_0x4b1035(0x224)]['anchor']['x']=0.5,this[_0x4b1035(0x224)][_0x4b1035(0xa5c)]['y']=0.5,this[_0x4b1035(0x224)]['y']=-0x2,this[_0x4b1035(0x224)][_0x4b1035(0x7d0)]=![],this['addChild'](this[_0x4b1035(0x224)])):VisuMZ['BattleCore'][_0x4b1035(0x803)][_0x4b1035(0x9b5)](this),this['cancelTargetSelectionVisibility']();},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x934)]=function(){const _0x8effa6=_0xa8cad7,_0x21f3c7=this['battleLayoutStyle']();if(_0x21f3c7===_0x8effa6(0xb48)||this[_0x8effa6(0x863)]()){this[_0x8effa6(0x539)][_0x8effa6(0x7da)]();this[_0x8effa6(0x539)][_0x8effa6(0xa30)]&&this[_0x8effa6(0x539)][_0x8effa6(0x518)]();this[_0x8effa6(0xac8)]['open']();if(this[_0x8effa6(0xac8)][_0x8effa6(0xa30)]){if(_0x8effa6(0x4c8)!==_0x8effa6(0x4c8)){let _0x54d371=0x0;if(this[_0x8effa6(0x840)]&&this[_0x8effa6(0xa17)]!==_0x170af6){const _0x87e1a3=this['_distortionSprite']['scale']['y'];_0x54d371-=(_0x87e1a3-0x1)*this['height'];}return _0x54d371;}else this[_0x8effa6(0xac8)]['show']();}}},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x844)]=function(){const _0x4d49c5=_0xa8cad7,_0x5afe23=this[_0x4d49c5(0x1cc)]();['xp',_0x4d49c5(0x33b),_0x4d49c5(0xb48)][_0x4d49c5(0x220)](_0x5afe23)&&this[_0x4d49c5(0x9e9)][_0x4d49c5(0x7da)](),this['okTargetSelectionVisibility']();},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x7af)]=function(){const _0x2255c7=_0xa8cad7,_0xb7f688=VisuMZ[_0x2255c7(0x8a9)][_0x2255c7(0xb57)][_0x2255c7(0x56f)],_0x17bbec=Window_BattleStatus[_0x2255c7(0xa60)][_0x2255c7(0x1b1)](),_0x29d95c=Graphics['boxWidth']-(_0xb7f688[_0x2255c7(0x1f7)]||0xc0),_0x1ebb5b=this[_0x2255c7(0x65b)]()+_0x17bbec,_0x32016f=this['isRightInputMode']()?0x0:Graphics[_0x2255c7(0x719)]-_0x29d95c,_0x38a399=Graphics[_0x2255c7(0x9ef)]-_0x1ebb5b+_0x17bbec;return new Rectangle(_0x32016f,_0x38a399,_0x29d95c,_0x1ebb5b);},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x151)]=function(){const _0x5ad622=_0xa8cad7,_0x58c124=Window_BattleStatus['prototype']['extraHeight'](),_0x30d411=Graphics[_0x5ad622(0x719)],_0x1cb002=this[_0x5ad622(0x65b)]()+_0x58c124,_0x59ce8b=0x0,_0x490873=Graphics[_0x5ad622(0x9ef)]-_0x1cb002+_0x58c124;return new Rectangle(_0x59ce8b,_0x490873,_0x30d411,_0x1cb002);},Scene_Battle['prototype'][_0xa8cad7(0x874)]=function(){const _0x41d869=_0xa8cad7,_0x1018e8=Graphics[_0x41d869(0x719)]/0x2,_0x46a6db=this[_0x41d869(0x408)](VisuMZ['BattleCore'][_0x41d869(0xb57)][_0x41d869(0x56f)][_0x41d869(0x91c)],!![]),_0x5dc6f9=Math[_0x41d869(0x2cb)]((Graphics[_0x41d869(0x719)]-_0x1018e8)/0x2),_0x14b2fe=Graphics[_0x41d869(0x9ef)]-_0x46a6db-this['statusWindowRectXPStyle']()['height'];return new Rectangle(_0x5dc6f9,_0x14b2fe,_0x1018e8,_0x46a6db);},Scene_Battle[_0xa8cad7(0xa60)]['helpWindowRectBorderStyle']=function(){const _0x56ca6d=_0xa8cad7,_0x59d38d=Graphics[_0x56ca6d(0x960)],_0x20693b=Math[_0x56ca6d(0x2cb)]((Graphics[_0x56ca6d(0x719)]-_0x59d38d)/0x2),_0x1e5d83=this['helpAreaHeight'](),_0xb7a134=(Graphics[_0x56ca6d(0xa97)]-Graphics[_0x56ca6d(0x9ef)])/-0x2;return new Rectangle(_0x20693b,_0xb7a134,_0x59d38d,_0x1e5d83);},Scene_Battle['prototype'][_0xa8cad7(0x9bb)]=function(){const _0x2548ec=_0xa8cad7,_0x3bb4d7=Graphics['width'],_0x2035c3=Math[_0x2548ec(0x2cb)]((Graphics['boxWidth']-_0x3bb4d7)/0x2),_0x29b567=this[_0x2548ec(0x408)](0x4,!![]),_0x3c631c=Graphics[_0x2548ec(0x9ef)]-_0x29b567+(Graphics[_0x2548ec(0xa97)]-Graphics['boxHeight'])/0x2;return new Rectangle(_0x2035c3,_0x3c631c,_0x3bb4d7,_0x29b567);},Scene_Battle[_0xa8cad7(0xa60)]['partyCommandWindowRectBorderStyle']=function(){const _0x32165e=_0xa8cad7,_0x3a405c=Math[_0x32165e(0xb05)](Graphics[_0x32165e(0x960)]/0x3),_0x39c7ac=this[_0x32165e(0x70c)]()?(Graphics[_0x32165e(0x960)]+Graphics[_0x32165e(0x719)])/0x2-_0x3a405c:(Graphics[_0x32165e(0x960)]-Graphics[_0x32165e(0x719)])/-0x2,_0x5875d2=this[_0x32165e(0xb25)](),_0x4f0308=_0x5875d2['y']+_0x5875d2[_0x32165e(0xa97)],_0x5ec8cc=this[_0x32165e(0x9bb)](),_0x5c4da3=_0x5ec8cc['y']-_0x4f0308;return new Rectangle(_0x39c7ac,_0x4f0308,_0x3a405c,_0x5c4da3);},Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0xaa0)]=function(){const _0x1af138=_0xa8cad7,_0x2e2c5a=Math[_0x1af138(0x412)](Graphics[_0x1af138(0x960)]/0x3),_0x5cbefc=Math[_0x1af138(0x2cb)]((Graphics[_0x1af138(0x719)]-_0x2e2c5a)/0x2),_0x2279e3=this['partyCommandWindowRectBorderStyle'](),_0x26c659=_0x2279e3['y'],_0x44ae14=_0x2279e3['height'];return new Rectangle(_0x5cbefc,_0x26c659,_0x2e2c5a,_0x44ae14);},Scene_Battle[_0xa8cad7(0xa60)]['repositionCancelButtonBorderStyle']=function(){const _0x345096=_0xa8cad7;this[_0x345096(0x6c3)]['y']=this[_0x345096(0x7a4)]['y']+this[_0x345096(0x7a4)][_0x345096(0xa97)];if(this[_0x345096(0x70c)]()){if('VEeEY'!==_0x345096(0xa2a))return _0x2379db(_0x15c688['$1'])||0x0;else this[_0x345096(0x1cc)]()===_0x345096(0xb48)?this[_0x345096(0x6c3)]['x']=0x8:this['_cancelButton']['x']=-this['_cancelButton']['width']-0x4;}else this[_0x345096(0x6c3)]['x']=Graphics[_0x345096(0x960)]-(Graphics[_0x345096(0x960)]-Graphics[_0x345096(0x719)])/0x2-this['_cancelButton'][_0x345096(0x960)]-0x4;},VisuMZ['BattleCore'][_0xa8cad7(0xb8d)]=Scene_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x4d7)],Scene_Battle['prototype'][_0xa8cad7(0x4d7)]=function(){const _0x1b0a84=_0xa8cad7;if(this['battleLayoutStyle']()==='border'){if(_0x1b0a84(0x53b)!==_0x1b0a84(0x662))return this['skillItemWindowRectBorderStyle']();else this[_0x1b0a84(0x3ac)]['x']=0x0,this[_0x1b0a84(0x5e1)]=_0x435b1a['ceil'](_0x502d48[_0x1b0a84(0x960)]/0x2);}else{if(this[_0x1b0a84(0x863)]()){if(_0x1b0a84(0x7d2)!=='YDTHU')return this[_0x1b0a84(0x568)]();else{if(_0x2f89a6[_0x1b0a84(0x455)]())return;if(!_0x505b8e)return;if(!_0x23923a[_0x1b0a84(0x8b9)]())return;_0x1c4985[_0x1b0a84(0x8a9)][_0x1b0a84(0x1d0)][_0x1b0a84(0x9b5)](this);}}else{if(_0x1b0a84(0x8f3)===_0x1b0a84(0x8f3))return VisuMZ['BattleCore'][_0x1b0a84(0xb8d)][_0x1b0a84(0x9b5)](this);else this[_0x1b0a84(0x954)]['x']=_0x10158c[_0x1b0a84(0x960)]*0xa,this[_0x1b0a84(0x954)]['y']=_0x5c7905[_0x1b0a84(0xa97)]*0xa;}}},VisuMZ['BattleCore'][_0xa8cad7(0xa8c)]=Scene_Battle['prototype'][_0xa8cad7(0x64e)],Scene_Battle['prototype'][_0xa8cad7(0x64e)]=function(){const _0x27fcde=_0xa8cad7;if(this[_0x27fcde(0x1cc)]()===_0x27fcde(0xb48))return _0x27fcde(0x601)!==_0x27fcde(0x3b6)?this[_0x27fcde(0xaa0)]():[_0x533944][_0x27fcde(0xaff)](_0x6373b0);else{if(this['isSkillItemWindowsMiddle']())return this[_0x27fcde(0x568)]();else{if('UJzcX'==='UJzcX')return VisuMZ[_0x27fcde(0x8a9)][_0x27fcde(0xa8c)][_0x27fcde(0x9b5)](this);else{if(!_0x2d0211[_0x27fcde(0x45f)]())return;if(!this[_0x27fcde(0xa3b)])this[_0x27fcde(0x3e8)]();this[_0x27fcde(0xa5a)]();const _0x3a5095=this[_0x27fcde(0xac0)]();if(_0x3a5095)_0x3a5095[_0x27fcde(0x586)]();}}}},Scene_Battle['prototype'][_0xa8cad7(0x863)]=function(){const _0x4cb074=_0xa8cad7;return VisuMZ[_0x4cb074(0x8a9)]['Settings'][_0x4cb074(0x56f)][_0x4cb074(0x746)];},Scene_Battle['prototype']['skillItemWindowRectMiddle']=function(){const _0x595618=_0xa8cad7,_0x6481a6=Sprite_Button[_0x595618(0xa60)][_0x595618(0xabe)]()*0x2+0x4;let _0x31d164=Graphics[_0x595618(0x719)]-_0x6481a6;if(Imported[_0x595618(0x8a4)]&&SceneManager[_0x595618(0x192)]()){if(_0x595618(0x7fc)===_0x595618(0x7fc))_0x31d164+=_0x6481a6;else return this[_0x595618(0x133)]()&&!this[_0x595618(0x33d)]()?this[_0x595618(0x628)]():_0x52a5f3['BattleCore'][_0x595618(0x6c5)]['call'](this);}const _0x4c7439=this[_0x595618(0x2c3)](),_0x314ffa=Graphics['boxHeight']-_0x4c7439-this['statusWindowRect']()[_0x595618(0xa97)]+Window_BattleStatus[_0x595618(0xa60)][_0x595618(0x1b1)](),_0x5b2653=0x0;return new Rectangle(_0x5b2653,_0x4c7439,_0x31d164,_0x314ffa);},Scene_Battle['prototype']['createEnemyNameContainer']=function(){const _0x2e52fd=_0xa8cad7;if(!VisuMZ[_0x2e52fd(0x8a9)][_0x2e52fd(0xb57)][_0x2e52fd(0x8d5)][_0x2e52fd(0x360)])return;this[_0x2e52fd(0x493)]=new Sprite(),this['_enemyNameContainer']['x']=this[_0x2e52fd(0x954)]['x'],this[_0x2e52fd(0x493)]['y']=this[_0x2e52fd(0x954)]['y'];const _0x581da5=this[_0x2e52fd(0x285)]['indexOf'](this['_windowLayer']);this[_0x2e52fd(0x1fc)](this['_enemyNameContainer'],_0x581da5);for(let _0x3e0c07=0x0;_0x3e0c07<0x8;_0x3e0c07++){const _0x5f5add=new Window_EnemyName(_0x3e0c07);this[_0x2e52fd(0x493)][_0x2e52fd(0x9ac)](_0x5f5add);}},Sprite_Battler[_0xa8cad7(0x837)]=VisuMZ[_0xa8cad7(0x8a9)]['Settings'][_0xa8cad7(0x3d8)]['MotionSpeed'],VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x32b)]=Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x32a)],Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x32a)]=function(){const _0x39d28f=_0xa8cad7;VisuMZ['BattleCore']['Sprite_Battler_initMembers']['call'](this),this[_0x39d28f(0xad2)]();if(this[_0x39d28f(0xa17)]===Sprite_Enemy)this[_0x39d28f(0x671)]();this[_0x39d28f(0x602)]();},Sprite_Battler[_0xa8cad7(0xa60)]['initMembersBattleCore']=function(){const _0x57dfd3=_0xa8cad7;this[_0x57dfd3(0x7c5)]=0x0,this['_baseY']=0x0,this[_0x57dfd3(0x669)]=0x0,this[_0x57dfd3(0xae8)]=0x0,this[_0x57dfd3(0x940)]=0x0,this[_0x57dfd3(0x9d5)]=0x0,this[_0x57dfd3(0x9a1)]=_0x57dfd3(0x9bc),this[_0x57dfd3(0x747)]=0x0,this['_jumpMaxHeight']=0x0,this['_jumpDuration']=0x0,this[_0x57dfd3(0xa98)]=0x0,this['_targetOpacity']=0xff,this[_0x57dfd3(0x6a0)]=0x0,this[_0x57dfd3(0x73b)]=0x0,this[_0x57dfd3(0x1df)]='Linear',this[_0x57dfd3(0x513)]=0x0,this[_0x57dfd3(0x3a4)]=0x0,this[_0x57dfd3(0x939)]=0x0,this[_0x57dfd3(0x5fb)]=0x0,this['_angleEasing']=_0x57dfd3(0x9bc),this[_0x57dfd3(0x8d7)]=!![],this[_0x57dfd3(0xb1c)]=0x0,this[_0x57dfd3(0x78c)]=0x0,this[_0x57dfd3(0x31b)]=0x0,this['_targetSkewY']=0x0,this[_0x57dfd3(0x908)]=0x0,this[_0x57dfd3(0x9e8)]=0x0,this['_skewEasing']=_0x57dfd3(0x9bc),this[_0x57dfd3(0x494)]=0x1,this[_0x57dfd3(0x67c)]=0x1,this['_targetGrowX']=0x1,this[_0x57dfd3(0x5fd)]=0x1,this[_0x57dfd3(0x573)]=0x0,this['_growWholeDuration']=0x0,this['_growEasing']=_0x57dfd3(0x9bc),this[_0x57dfd3(0x42d)]=0x1,this[_0x57dfd3(0xa24)]=0x0,this['_targetHomeY']=0x0,this[_0x57dfd3(0x12b)]=0x0,this[_0x57dfd3(0xa0e)]=0x0,this[_0x57dfd3(0x35a)]=_0x57dfd3(0x9bc);},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x671)]=function(){const _0x520f88=_0xa8cad7;this[_0x520f88(0x224)]=new Sprite(),this[_0x520f88(0x224)][_0x520f88(0x379)]=ImageManager[_0x520f88(0xb2a)](_0x520f88(0x3fb)),this['_shadowSprite']['bitmap']['smooth']=VisuMZ['BattleCore']['Settings'][_0x520f88(0x3d8)][_0x520f88(0x115)],this['_shadowSprite'][_0x520f88(0xa5c)]['x']=0.5,this[_0x520f88(0x224)]['anchor']['y']=0.5,this[_0x520f88(0x224)]['y']=-0x2,this[_0x520f88(0x224)]['visible']=![],this[_0x520f88(0x9ac)](this['_shadowSprite']);},Sprite_Battler['prototype'][_0xa8cad7(0x602)]=function(){const _0x26b95f=_0xa8cad7;this[_0x26b95f(0x840)]=new Sprite(),this[_0x26b95f(0x840)][_0x26b95f(0xa5c)]['x']=0.5,this[_0x26b95f(0x840)]['anchor']['y']=0.5,this[_0x26b95f(0x9ac)](this[_0x26b95f(0x840)]);},Sprite_Battler['prototype'][_0xa8cad7(0x920)]=function(){const _0x13eb29=_0xa8cad7;if(!this[_0x13eb29(0x840)])return;if(this[_0x13eb29(0x224)]){if(_0x13eb29(0x363)!=='yYtaQ')this[_0x13eb29(0xae3)](_0x42f3d8,_0x7ca03,_0x290e3d);else{const _0x28732b=this[_0x13eb29(0x73f)](this['_distortionSprite']);this[_0x13eb29(0x1fc)](this[_0x13eb29(0x224)],_0x28732b),this[_0x13eb29(0x5ea)]();}}this[_0x13eb29(0x130)]&&this[_0x13eb29(0x840)][_0x13eb29(0x9ac)](this[_0x13eb29(0x130)]);this['_weaponSprite']&&this[_0x13eb29(0x840)][_0x13eb29(0x9ac)](this[_0x13eb29(0x765)]);this['_mainSprite']&&this[_0x13eb29(0x840)]['addChild'](this[_0x13eb29(0xb80)]);if(this[_0x13eb29(0x540)]){if(_0x13eb29(0xaea)!=='RSARF')return![];else this['_distortionSprite'][_0x13eb29(0x9ac)](this[_0x13eb29(0x540)]);}},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x5ea)]=function(){const _0x1d6209=_0xa8cad7;if(!this[_0x1d6209(0x224)])return;if(this[_0x1d6209(0x959)]&&this['_battler'][_0x1d6209(0x4f9)]()){if('gFuaJ'===_0x1d6209(0x27e)){const _0x1935b7=this[_0x1d6209(0x224)][_0x1d6209(0x379)];this[_0x1d6209(0x224)][_0x1d6209(0xafe)](0x0,0x0,_0x1935b7[_0x1d6209(0x960)],_0x1935b7[_0x1d6209(0xa97)]);}else _0x2cebd9&&_0x3752fa[_0x1d6209(0x902)]()&&_0x1f68f1[_0x1d6209(0xaf0)](_0x5895aa),this[_0x1d6209(0xa8a)]();}else this[_0x1d6209(0x224)][_0x1d6209(0xafe)](0x0,0x0,0x0,0x0);},Sprite_Battler['prototype'][_0xa8cad7(0x4eb)]=function(){const _0x36c0be=_0xa8cad7;return SceneManager['isSceneBattle']()?SceneManager[_0x36c0be(0x26b)][_0x36c0be(0x726)][_0x36c0be(0x47a)]:this[_0x36c0be(0x9b4)];},Sprite_Battler['prototype']['setupTextPopup']=function(_0x4e4b8a,_0x2161fb){const _0x31354d=_0xa8cad7;if(!this[_0x31354d(0x959)][_0x31354d(0x9f6)]())return;const _0x1a1377=VisuMZ[_0x31354d(0x8a9)][_0x31354d(0xb57)][_0x31354d(0x741)],_0x260a10=new Sprite_Damage();_0x260a10[_0x31354d(0x265)]=_0x1a1377[_0x31354d(0x17d)],this['sortDamageSprites'](_0x260a10),_0x260a10[_0x31354d(0x6d2)](_0x4e4b8a,_0x2161fb),this['addDamageSprite'](_0x260a10);},Sprite_Battler['prototype'][_0xa8cad7(0x284)]=function(_0x7e9beb,_0x104d2f,_0x1bb00c){const _0x1ef185=_0xa8cad7;if(!this[_0x1ef185(0x959)][_0x1ef185(0x9f6)]())return;const _0x2110e4=VisuMZ['BattleCore']['Settings'][_0x1ef185(0x741)],_0x240445=new Sprite_Damage();_0x240445['_duration']=_0x2110e4[_0x1ef185(0x17d)],this['sortDamageSprites'](_0x240445),_0x240445['setupIconTextPopup'](_0x7e9beb,_0x104d2f,_0x1bb00c),this[_0x1ef185(0x57c)](_0x240445);},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x586)]=function(){const _0x4294ed=_0xa8cad7;if(!this[_0x4294ed(0x959)]['isDamagePopupRequested']())return;while(this[_0x4294ed(0x959)][_0x4294ed(0xacb)]()){_0x4294ed(0x808)==='VdnSf'?this['_battler'][_0x4294ed(0x9f6)]()&&this[_0x4294ed(0x7a5)]():this[_0x4294ed(0x2fa)]=_0x33369e;}this[_0x4294ed(0x959)][_0x4294ed(0x3e8)](),this[_0x4294ed(0x959)][_0x4294ed(0xb3d)]();},Sprite_Battler[_0xa8cad7(0xa60)]['createDamageSprite']=function(){const _0x20439a=_0xa8cad7,_0x17771b=VisuMZ['BattleCore'][_0x20439a(0xb57)][_0x20439a(0x741)],_0x40c5aa=new Sprite_Damage();_0x40c5aa[_0x20439a(0x265)]=_0x17771b[_0x20439a(0x17d)],this['sortDamageSprites'](_0x40c5aa),_0x40c5aa[_0x20439a(0xb84)](this[_0x20439a(0x959)]),_0x40c5aa[_0x20439a(0xa19)](this[_0x20439a(0x959)]),this[_0x20439a(0x57c)](_0x40c5aa);},Sprite_Battler[_0xa8cad7(0xa60)]['addDamageSprite']=function(_0x4422ab){const _0x453c95=_0xa8cad7;this[_0x453c95(0x916)][_0x453c95(0x6c0)](_0x4422ab);if(this['isShownOnBattlePortrait']()){if(_0x453c95(0x9c5)!=='PuVip')SceneManager[_0x453c95(0x26b)]['_statusWindow'][_0x453c95(0x57c)](_0x4422ab,this[_0x453c95(0x959)]);else{this[_0x453c95(0x4eb)]()['addChild'](_0x384eba);if(_0x1369e9['isBattleFlipped']())_0x1b1a44[_0x453c95(0x122)]['x']=-0x1;}}else{this['damageContainer']()[_0x453c95(0x9ac)](_0x4422ab);if(SceneManager[_0x453c95(0xb26)]())_0x4422ab[_0x453c95(0x122)]['x']=-0x1;}},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x99f)]=function(){const _0x30c4bb=_0xa8cad7;return!$gameSystem[_0x30c4bb(0x1d3)]()&&this['_battler']&&this[_0x30c4bb(0x959)]['isActor']();},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x24f)]=function(_0x497343){const _0x2bcad2=_0xa8cad7;this[_0x2bcad2(0x7df)](_0x497343,!![]);const _0x392cf1=VisuMZ[_0x2bcad2(0x8a9)][_0x2bcad2(0xb57)][_0x2bcad2(0x741)],_0x5a2d41=SceneManager['isBattleFlipped']()?-0x1:0x1;if(_0x392cf1[_0x2bcad2(0x5a9)])for(const _0x4a3e8f of this[_0x2bcad2(0x916)]){if(_0x2bcad2(0x618)!==_0x2bcad2(0x618))return _0x3505a3[_0x2bcad2(0x8a9)][_0x2bcad2(0x6c5)][_0x2bcad2(0x9b5)](this);else _0x4a3e8f['x']+=_0x392cf1['PopupShiftX']*_0x5a2d41,_0x4a3e8f['y']+=_0x392cf1[_0x2bcad2(0x34c)];}else{const _0x4bee0c=this[_0x2bcad2(0x916)][this[_0x2bcad2(0x916)][_0x2bcad2(0x19c)]-0x1];_0x4bee0c&&(_0x497343['x']=_0x4bee0c['x']+_0x392cf1[_0x2bcad2(0xa38)]*_0x5a2d41,_0x497343['y']=_0x4bee0c['y']+_0x392cf1[_0x2bcad2(0x34c)]);}},Sprite_Battler[_0xa8cad7(0xa60)]['alignBattleCoreDamageSprite']=function(_0x19ea25,_0xebfc5f){const _0x1b32e8=_0xa8cad7,_0x342d95=SceneManager['isBattleFlipped']()?-0x1:0x1;let _0x5754b7=this['_baseX'];_0x5754b7+=this[_0x1b32e8(0x5f3)]();let _0x29fa08=this[_0x1b32e8(0x98c)];const _0x560305=this['_distortionSprite']['scale']['y'];_0x29fa08+=this[_0x1b32e8(0xb02)]();const _0x269a33=SceneManager[_0x1b32e8(0x26b)]['_statusWindow'];if(_0x269a33&&this['parent']===_0x269a33){_0x5754b7+=_0x269a33['x']-this[_0x1b32e8(0x395)]();const _0x16648d=_0x269a33[_0x1b32e8(0x8c3)]()*0x3/0x4;_0x29fa08=_0x269a33['y']+_0x16648d,_0x29fa08=Math['min'](_0x29fa08,_0x269a33['y']+this['y']-this[_0x1b32e8(0xa97)]+_0x16648d);}_0x19ea25['x']=Math[_0x1b32e8(0x2cb)](_0x5754b7+this[_0x1b32e8(0x395)]()*_0x342d95),_0x19ea25['y']=Math[_0x1b32e8(0x2cb)](_0x29fa08+this[_0x1b32e8(0x42f)]());},VisuMZ['BattleCore']['Sprite_Battler_damageOffsetX']=Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x395)],Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x395)]=function(){const _0x2c584a=_0xa8cad7;let _0x556d55=VisuMZ[_0x2c584a(0x8a9)][_0x2c584a(0xa35)][_0x2c584a(0x9b5)](this),_0x234996=VisuMZ[_0x2c584a(0x8a9)][_0x2c584a(0xb57)][_0x2c584a(0x741)][_0x2c584a(0x86a)]||0x0;return Math[_0x2c584a(0x2cb)](_0x556d55+_0x234996);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x5b4)]=Sprite_Battler['prototype'][_0xa8cad7(0x42f)],Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x42f)]=function(){const _0x3b6f81=_0xa8cad7;let _0x413cc3=VisuMZ[_0x3b6f81(0x8a9)][_0x3b6f81(0x5b4)][_0x3b6f81(0x9b5)](this);switch(VisuMZ['BattleCore'][_0x3b6f81(0xb57)][_0x3b6f81(0x741)]['PopupPosition']){case _0x3b6f81(0x8b1):_0x413cc3-=this[_0x3b6f81(0xa97)]*this['scale']['y'];break;case'center':_0x413cc3-=this['height']*this['scale']['y']*0.5;break;}let _0x3bd865=VisuMZ[_0x3b6f81(0x8a9)][_0x3b6f81(0xb57)][_0x3b6f81(0x741)]['PopupOffsetY']||0x0;return Math['round'](_0x413cc3+_0x3bd865);},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x395)]=function(){const _0x4e0edb=_0xa8cad7;return Sprite_Battler[_0x4e0edb(0xa60)][_0x4e0edb(0x395)][_0x4e0edb(0x9b5)](this);},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x42f)]=function(){const _0x128a2a=_0xa8cad7;return Sprite_Battler[_0x128a2a(0xa60)][_0x128a2a(0x42f)][_0x128a2a(0x9b5)](this);},Sprite_Battler[_0xa8cad7(0xa60)]['destroyDamageSprite']=function(_0x12034b){const _0x32e0f0=_0xa8cad7;if(this[_0x32e0f0(0x99f)]()){if(_0x32e0f0(0xb11)!==_0x32e0f0(0xb11))return!![];else SceneManager[_0x32e0f0(0x26b)]['_statusWindow'][_0x32e0f0(0x297)](_0x12034b);}else this['damageContainer']()[_0x32e0f0(0x535)](_0x12034b),this[_0x32e0f0(0x916)][_0x32e0f0(0xafb)](_0x12034b),_0x12034b['destroy']();},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x5ba)]=Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x411)],Sprite_Battler['prototype'][_0xa8cad7(0x411)]=function(_0x272625,_0x13407c){const _0x5cd363=_0xa8cad7,_0x3bb157=VisuMZ['BattleCore'][_0x5cd363(0xb57)];if(this[_0x5cd363(0xa17)]===Sprite_Actor)'KQJTk'===_0x5cd363(0x19f)?(_0x272625+=_0x3bb157['Actor'][_0x5cd363(0x131)]||0x0,_0x13407c+=_0x3bb157[_0x5cd363(0x3d8)][_0x5cd363(0x944)]||0x0):this[_0x5cd363(0x828)]('chant');else this['constructor']===Sprite_Enemy&&(_0x5cd363(0x469)===_0x5cd363(0x829)?(_0x1a588a[_0x5cd363(0x8a9)][_0x5cd363(0x1e9)][_0x5cd363(0x9b5)](this),this[_0x5cd363(0x934)]()):(_0x272625+=_0x3bb157[_0x5cd363(0x8d5)][_0x5cd363(0x131)]||0x0,_0x13407c+=_0x3bb157[_0x5cd363(0x8d5)]['OffsetY']||0x0));this[_0x5cd363(0x959)]&&(_0x272625=this[_0x5cd363(0x959)][_0x5cd363(0x9ed)]??_0x272625,_0x13407c=this[_0x5cd363(0x959)][_0x5cd363(0xaa4)]??_0x13407c),VisuMZ['BattleCore'][_0x5cd363(0x5ba)][_0x5cd363(0x9b5)](this,_0x272625,_0x13407c),this['_targetHomeX']=this[_0x5cd363(0xab8)],this['_targetHomeY']=this[_0x5cd363(0x4e0)],this['_homeDuration']=0x0,this[_0x5cd363(0xa0e)]=0x0,this[_0x5cd363(0x35a)]='Linear';},VisuMZ[_0xa8cad7(0x8a9)]['Sprite_Battler_update']=Sprite_Battler[_0xa8cad7(0xa60)]['update'],Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x99e)]=function(){const _0x40b086=_0xa8cad7;VisuMZ[_0x40b086(0x8a9)][_0x40b086(0xa7a)][_0x40b086(0x9b5)](this),!this['_battler']&&this[_0x40b086(0x161)]&&(this['_hpGaugeSprite'][_0x40b086(0x7d0)]=![]);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x7f5)]=Sprite_Battler[_0xa8cad7(0xa60)]['updateMain'],Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xa90)]=function(){const _0x39b8be=_0xa8cad7;this[_0x39b8be(0x883)](),this['updateSkew'](),this[_0x39b8be(0x689)](),this[_0x39b8be(0x89f)](),this['updateHpGaugePosition'](),VisuMZ['BattleCore']['Sprite_Battler_updateMain'][_0x39b8be(0x9b5)](this);if(this['constructor']===Sprite_Enemy)this[_0x39b8be(0xb51)]();},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x721)]=Sprite_Battler['prototype'][_0xa8cad7(0x14e)],Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x14e)]=function(){const _0x30031c=_0xa8cad7;this[_0x30031c(0x308)](),VisuMZ['BattleCore'][_0x30031c(0x721)][_0x30031c(0x9b5)](this),this[_0x30031c(0x13b)](),this[_0x30031c(0xae2)]();},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x36d)]=function(_0x424b83,_0x3b9ae2,_0x47a9f6,_0x29a735){const _0x422b3e=_0xa8cad7;(this['_targetHomeX']!==_0x424b83||this['_targetHomeY']!==_0x3b9ae2)&&(this[_0x422b3e(0xa24)]=_0x424b83,this[_0x422b3e(0xa99)]=_0x3b9ae2,this['_homeDuration']=_0x47a9f6,this[_0x422b3e(0xa0e)]=_0x47a9f6,this['_homeEasing']=_0x29a735,_0x47a9f6<=0x0&&(_0x422b3e(0x980)==='fnshK'?this['onHomeMoveEnd']():_0x4eeb25+=_0x3093cd));},Sprite_Battler[_0xa8cad7(0xa60)]['updateHomeMove']=function(){const _0x58fc86=_0xa8cad7;if(this[_0x58fc86(0x12b)]<=0x0)return;const _0x42c538=this[_0x58fc86(0x12b)],_0x421b7a=this[_0x58fc86(0xa0e)],_0x5441d3=this[_0x58fc86(0x35a)];if(Imported['VisuMZ_0_CoreEngine']){if('bwsVR'!==_0x58fc86(0x320)){const _0x298eac=_0x388abe[_0x58fc86(0x8a9)][_0x58fc86(0xb57)][_0x58fc86(0xa3f)],_0x6ba9c7=this[_0x58fc86(0x990)]('autoBattleUseSkills');return _0x6ba9c7?_0x298eac[_0x58fc86(0x61e)]:_0x298eac[_0x58fc86(0x524)];}else this[_0x58fc86(0xab8)]=this[_0x58fc86(0x59f)](this[_0x58fc86(0xab8)],this[_0x58fc86(0xa24)],_0x42c538,_0x421b7a,_0x5441d3),this[_0x58fc86(0x4e0)]=this[_0x58fc86(0x59f)](this[_0x58fc86(0x4e0)],this[_0x58fc86(0xa99)],_0x42c538,_0x421b7a,_0x5441d3);}else this['_homeX']=(this['_homeX']*(_0x42c538-0x1)+this[_0x58fc86(0xa24)])/_0x42c538,this[_0x58fc86(0x4e0)]=(this[_0x58fc86(0x4e0)]*(_0x42c538-0x1)+this[_0x58fc86(0xa99)])/_0x42c538;this[_0x58fc86(0x12b)]--;if(this[_0x58fc86(0x12b)]<=0x0)this[_0x58fc86(0xb8a)]();},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xb8a)]=function(){const _0x5417bd=_0xa8cad7;this[_0x5417bd(0xab8)]=this['_targetHomeX'],this[_0x5417bd(0x4e0)]=this[_0x5417bd(0xa99)];},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x13b)]=function(){const _0x326649=_0xa8cad7;this['_baseX']=this['x'],this[_0x326649(0x98c)]=this['y'],this[_0x326649(0x6ff)](),this[_0x326649(0x25d)](),this['x']+=this[_0x326649(0x5f3)](),this['y']+=this[_0x326649(0xb02)](),this['y']+=this[_0x326649(0x84e)](),this['x']=Math[_0x326649(0xb05)](this['x']),this['y']=Math[_0x326649(0xb05)](this['y']);},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x5f3)]=function(){let _0x3a74a0=0x0;return _0x3a74a0;},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xb02)]=function(){const _0x3293d4=_0xa8cad7;let _0x3f982c=0x0;if(this['_battler']&&!this[_0x3293d4(0x959)]['isBattlerGrounded']()){if(_0x3293d4(0x459)===_0x3293d4(0x459))_0x3f982c-=this['_floatHeight'],_0x3f982c-=this[_0x3293d4(0x747)];else return this[_0x3293d4(0x241)]();}return _0x3f982c;},Sprite_Battler[_0xa8cad7(0xa60)]['extraPositionScaledY']=function(){const _0x572943=_0xa8cad7;let _0x493c35=0x0;if(this[_0x572943(0x840)]&&this[_0x572943(0xa17)]!==Sprite_SvEnemy){if(_0x572943(0x807)!==_0x572943(0x807))this[_0x572943(0x828)](_0x572943(0x9aa));else{const _0x3a4bc7=this['_distortionSprite'][_0x572943(0x122)]['y'];_0x493c35-=(_0x3a4bc7-0x1)*this[_0x572943(0xa97)];}}return _0x493c35;},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x89f)]=function(){const _0x362f2d=_0xa8cad7,_0x414a16=this['_battler']&&this[_0x362f2d(0x959)]['isBattlerFlipped']();this[_0x362f2d(0x42d)]=(_0x414a16?-0x1:0x1)*Math[_0x362f2d(0xb32)](this[_0x362f2d(0x122)]['x']);},Sprite_Battler[_0xa8cad7(0xa60)]['startFloat']=function(_0x513017,_0x2fb88e,_0x4cb06d){const _0x1415cc=_0xa8cad7;if(!this[_0x1415cc(0x8b9)]())return;if(this[_0x1415cc(0xae8)]===_0x513017)return;this['_targetFloatHeight']=_0x513017,this[_0x1415cc(0x940)]=_0x2fb88e,this[_0x1415cc(0x9d5)]=_0x2fb88e,this[_0x1415cc(0x9a1)]=_0x4cb06d||'Linear';if(_0x2fb88e<=0x0)this[_0x1415cc(0x669)]=_0x513017;},Sprite_Battler['prototype']['updateFloat']=function(){const _0x225a75=_0xa8cad7;if(this[_0x225a75(0x940)]<=0x0)return;const _0x2db048=this[_0x225a75(0x940)],_0x4b9c55=this['_floatWholeDuration'],_0x106f74=this[_0x225a75(0x9a1)];Imported[_0x225a75(0x8a4)]?this[_0x225a75(0x669)]=this[_0x225a75(0x59f)](this['_floatHeight'],this[_0x225a75(0xae8)],_0x2db048,_0x4b9c55,_0x106f74):this[_0x225a75(0x669)]=(this[_0x225a75(0x669)]*(_0x2db048-0x1)+this[_0x225a75(0xae8)])/_0x2db048;this[_0x225a75(0x940)]--;if(this[_0x225a75(0x940)]<=0x0)this[_0x225a75(0x3e0)]();},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x3e0)]=function(){const _0x3ee6fe=_0xa8cad7;this[_0x3ee6fe(0x669)]=this[_0x3ee6fe(0xae8)];},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x8c4)]=function(){const _0x208715=_0xa8cad7;return this[_0x208715(0x940)]>0x0;},Sprite_Battler['prototype'][_0xa8cad7(0x532)]=function(_0x4842bc,_0x58d2c2){const _0x31a99c=_0xa8cad7;if(!this[_0x31a99c(0x8b9)]())return;if(_0x58d2c2<=0x0)return;this['_jumpMaxHeight']=_0x4842bc,this['_jumpDuration']=_0x58d2c2,this['_jumpWholeDuration']=_0x58d2c2;},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x25d)]=function(){const _0x43adf3=_0xa8cad7;if(this[_0x43adf3(0x98a)]<=0x0)return;const _0x421685=this['_jumpWholeDuration']-this[_0x43adf3(0x98a)],_0x31c1d8=this['_jumpWholeDuration']/0x2,_0x2a8270=this[_0x43adf3(0x1b9)],_0x1242e5=-_0x2a8270/Math[_0x43adf3(0x1cb)](_0x31c1d8,0x2);this[_0x43adf3(0x747)]=_0x1242e5*Math['pow'](_0x421685-_0x31c1d8,0x2)+_0x2a8270,this['_jumpDuration']--;if(this[_0x43adf3(0x98a)]<=0x0)return this[_0x43adf3(0x4ef)]();},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x4ef)]=function(){const _0xe39129=_0xa8cad7;this[_0xe39129(0x747)]=0x0;},Sprite_Battler[_0xa8cad7(0xa60)]['isJumping']=function(){const _0x1cf7ab=_0xa8cad7;return this[_0x1cf7ab(0x98a)]>0x0;},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x39c)]=function(_0x430ad0,_0x561c96,_0x5c5e9d){const _0x657197=_0xa8cad7;if(this[_0x657197(0x392)]===_0x430ad0)return;this[_0x657197(0x392)]=_0x430ad0,this[_0x657197(0x6a0)]=_0x561c96,this['_opacityWholeDuration']=_0x561c96,this[_0x657197(0x1df)]=_0x5c5e9d||_0x657197(0x9bc);if(_0x561c96<=0x0)this[_0x657197(0xa4c)]=_0x430ad0;},Sprite_Battler['prototype'][_0xa8cad7(0xae2)]=function(){const _0x3247b5=_0xa8cad7;if(this[_0x3247b5(0xa17)][_0x3247b5(0x9a6)]===_0x3247b5(0xaf9))return;if(this[_0x3247b5(0x6a0)]<=0x0)return;const _0x53e8e0=this[_0x3247b5(0x6a0)],_0x16f909=this['_opacityWholeDuration'],_0x5aa563=this[_0x3247b5(0x1df)];if(Imported[_0x3247b5(0x8a4)]){if(_0x3247b5(0x1d9)===_0x3247b5(0x75d))return this[_0x3247b5(0x133)]()&&!this[_0x3247b5(0x33d)]()?this['isForOpponentBattleCore']():_0x19e222[_0x3247b5(0x8a9)]['Game_Action_isForOpponent'][_0x3247b5(0x9b5)](this);else this[_0x3247b5(0xa4c)]=this[_0x3247b5(0x59f)](this[_0x3247b5(0xa4c)],this[_0x3247b5(0x392)],_0x53e8e0,_0x16f909,_0x5aa563);}else _0x3247b5(0x2f9)!==_0x3247b5(0x9cc)?this[_0x3247b5(0xa4c)]=(this[_0x3247b5(0xa4c)]*(_0x53e8e0-0x1)+this['_targetOpacity'])/_0x53e8e0:_0x2d0700[_0x3247b5(0x46d)]();this[_0x3247b5(0x6a0)]--;if(this[_0x3247b5(0x6a0)]<=0x0)this[_0x3247b5(0x848)]();},Sprite_Battler['prototype']['onOpacityEnd']=function(){const _0x46ce28=_0xa8cad7;this['opacity']=this[_0x46ce28(0x392)];},Sprite_Battler[_0xa8cad7(0xa60)]['isChangingOpacity']=function(){const _0x33240d=_0xa8cad7;return this[_0x33240d(0x6a0)]>0x0;},Sprite_Battler[_0xa8cad7(0xa60)]['updateShadow']=function(){const _0x3e6ce6=_0xa8cad7;this['_shadowSprite'][_0x3e6ce6(0x7d0)]=this['_battler'][_0x3e6ce6(0xb29)](),this[_0x3e6ce6(0x343)]();},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x343)]=function(){const _0x36f2d6=_0xa8cad7;if(!this['_shadowSprite'])return;this[_0x36f2d6(0x224)]['y']=this[_0x36f2d6(0x98c)]-this['y']-0x2;},Sprite_Battler['prototype'][_0xa8cad7(0x8c8)]=function(){const _0x2cc27c=_0xa8cad7;if(!this[_0x2cc27c(0x959)])return;this[_0x2cc27c(0xb22)]=this[_0x2cc27c(0x959)][_0x2cc27c(0xb1e)](),this['_shadowScaleY']=this[_0x2cc27c(0x959)][_0x2cc27c(0x8ab)]();},Game_BattlerBase[_0xa8cad7(0xa60)]['battlerShadowScaleX']=function(){const _0x586f68=_0xa8cad7,_0x33b8ba=this[_0x586f68(0x902)]()?this[_0x586f68(0x3e7)]():this[_0x586f68(0xac4)]();if(_0x33b8ba){const _0x56ce5c=_0x33b8ba[_0x586f68(0x74f)];if(_0x56ce5c['match'](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](\d+)([%％])>/i)){if(_0x586f68(0x314)!==_0x586f68(0x314)){this[_0x586f68(0x18a)](_0x387ee0);for(const _0x17aa5c of _0x3333f9[_0x586f68(0xaec)]){_0x17aa5c['endAnimation']&&_0x17aa5c[_0x586f68(0x37e)]();}_0x4922bf[_0x586f68(0x38c)]();}else return Number(RegExp['$1'])*0.01;}else{if(_0x56ce5c['match'](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](.*)>/i)){if(_0x586f68(0x8eb)===_0x586f68(0x371)){if(this[_0x586f68(0x908)]<=0x0)return;if(!this[_0x586f68(0x840)])return;const _0x702a01=this['_skewDuration'],_0x54567d=this[_0x586f68(0x9e8)],_0x12afdf=this[_0x586f68(0x407)],_0x15e32e=this['_distortionSprite'];_0x387e33[_0x586f68(0x8a4)]?(_0x15e32e[_0x586f68(0x57a)]['x']=this[_0x586f68(0x59f)](_0x15e32e[_0x586f68(0x57a)]['x'],this['_targetSkewX'],_0x702a01,_0x54567d,_0x12afdf),_0x15e32e[_0x586f68(0x57a)]['y']=this[_0x586f68(0x59f)](_0x15e32e[_0x586f68(0x57a)]['y'],this[_0x586f68(0x4dd)],_0x702a01,_0x54567d,_0x12afdf)):(_0x15e32e[_0x586f68(0x57a)]['x']=(_0x15e32e['skew']['x']*(_0x702a01-0x1)+this['_targetSkewX'])/_0x702a01,_0x15e32e['skew']['y']=(_0x15e32e[_0x586f68(0x57a)]['y']*(_0x702a01-0x1)+this['_targetSkewY'])/_0x702a01);this[_0x586f68(0x908)]--;if(this[_0x586f68(0x908)]<=0x0)this[_0x586f68(0xa4e)]();}else return Number(RegExp['$1'])||0x0;}}}return 0x1;},Game_BattlerBase[_0xa8cad7(0xa60)]['battlerShadowScaleY']=function(){const _0x213a82=_0xa8cad7,_0x3099df=this[_0x213a82(0x902)]()?this[_0x213a82(0x3e7)]():this[_0x213a82(0xac4)]();if(_0x3099df){if(_0x213a82(0x1c6)===_0x213a82(0x28a))_0x50a473[_0x213a82(0x8a4)]?_0x4b2185[_0x213a82(0x3eb)]([this],_0xe081de):_0x1862be[_0x213a82(0xb16)]([this],_0x4c8ce7);else{const _0x3223fe=_0x3099df[_0x213a82(0x74f)];if(_0x3223fe[_0x213a82(0x21d)](/<SIDEVIEW SHADOW (?:SCALE|SCALE Y):[ ](\d+)([%％])>/i)){if(_0x213a82(0xa32)===_0x213a82(0x1cf)){const _0x186823=_0x4ed759[_0x213a82(0xa60)][_0x213a82(0x1cc)]();[_0x213a82(0x7ae),_0x213a82(0x8cb),'portrait','border'][_0x213a82(0x220)](_0x186823)&&(this['opacity']=0x0);}else return Number(RegExp['$1'])*0.01;}else{if(_0x3223fe['match'](/<SIDEVIEW SHADOW (?:SCALE|SCALE Y):[ ](.*)>/i)){if(_0x213a82(0x5b7)===_0x213a82(0x5b7))return Number(RegExp['$1'])||0x0;else{const _0x3199da=_0x4c0923[_0x49a9f0[_0x213a82(0x1b4)]],_0x39dbc4=_0x3199da[_0x213a82(0x8cb)][_0x213a82(0x19c)]-0x2,_0x9ca36b=_0x3199da[_0x213a82(0x8cb)][_0x39dbc4];if(_0x9ca36b&&_0x9ca36b[_0x213a82(0x325)]!==0xe6){const _0x2fbb2e={'code':0xe6,'indent':0x0,'parameters':[0x1]},_0x4c36db=_0x3199da[_0x213a82(0x8cb)]['pop']();_0x3199da['list'][_0x213a82(0xa77)](_0x2fbb2e),_0x3199da[_0x213a82(0x8cb)][_0x213a82(0xa77)](_0x4c36db);}}}}}}return 0x1;},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x883)]=function(){const _0x5b7940=_0xa8cad7;if(this[_0x5b7940(0xa17)]===Sprite_SvEnemy)return;this[_0x5b7940(0x447)](),this[_0x5b7940(0x55b)]();},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x55b)]=function(){const _0x41fef9=_0xa8cad7,_0x1a78d0=this[_0x41fef9(0x840)];if(_0x1a78d0){if('EUHMx'===_0x41fef9(0x6bf))_0x1a78d0[_0x41fef9(0x122)]['x']=this[_0x41fef9(0x3bf)](),_0x1a78d0[_0x41fef9(0x122)]['y']=this[_0x41fef9(0x142)]();else{const _0x32b649=this[_0x41fef9(0xa48)][_0x41fef9(0x927)]();for(const _0x4bc1a9 of _0x32b649){this[_0x41fef9(0x5f2)](_0x4bc1a9);}}}},Sprite_Battler[_0xa8cad7(0xa60)]['mainSpriteScaleX']=function(){let _0x176224=0x1;return _0x176224*=this['_flipScaleX'],_0x176224*=this['_growX'],_0x176224;},Sprite_Battler['prototype']['mainSpriteScaleY']=function(){const _0x56a0b4=_0xa8cad7;return 0x1*this[_0x56a0b4(0x67c)];},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x8da)]=function(){const _0x95549=_0xa8cad7;return this['width']*this[_0x95549(0x3bf)]();},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x3ae)]=function(){const _0x4c735a=_0xa8cad7;return this[_0x4c735a(0xa97)]*this[_0x4c735a(0x142)]();},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x751)]=function(_0x446b1b,_0x52da46,_0x2e5838,_0x304aff){const _0xba7a80=_0xa8cad7;if(!this[_0xba7a80(0x8b9)]())return;if(!this[_0xba7a80(0x840)])return;if(this[_0xba7a80(0x8d1)]===_0x446b1b&&this[_0xba7a80(0x5fd)]===_0x52da46)return;this['_targetGrowX']=_0x446b1b,this[_0xba7a80(0x5fd)]=_0x52da46,this['_growDuration']=_0x2e5838,this[_0xba7a80(0xb67)]=_0x2e5838,this[_0xba7a80(0x391)]=_0x304aff||_0xba7a80(0x9bc),_0x2e5838<=0x0&&(this['_growX']=this['_targetGrowX'],this['_growY']=this[_0xba7a80(0x5fd)]);},Sprite_Battler[_0xa8cad7(0xa60)]['updateGrow']=function(){const _0x1a7151=_0xa8cad7;if(this[_0x1a7151(0x573)]<=0x0)return;if(!this[_0x1a7151(0x840)])return;const _0x1053c4=this[_0x1a7151(0x573)],_0x59c83c=this['_growWholeDuration'],_0x391d17=this[_0x1a7151(0x391)];Imported['VisuMZ_0_CoreEngine']?(this['_growX']=this[_0x1a7151(0x59f)](this[_0x1a7151(0x494)],this[_0x1a7151(0x8d1)],_0x1053c4,_0x59c83c,_0x391d17),this[_0x1a7151(0x67c)]=this[_0x1a7151(0x59f)](this['_growY'],this[_0x1a7151(0x5fd)],_0x1053c4,_0x59c83c,_0x391d17)):(this[_0x1a7151(0x494)]=(this['_growX']*(_0x1053c4-0x1)+this[_0x1a7151(0x8d1)])/_0x1053c4,this[_0x1a7151(0x67c)]=(this[_0x1a7151(0x67c)]*(_0x1053c4-0x1)+this[_0x1a7151(0x5fd)])/_0x1053c4);this[_0x1a7151(0x573)]--;if(this['_growDuration']<=0x0)this[_0x1a7151(0x72c)]();},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x72c)]=function(){const _0x1f7ba5=_0xa8cad7;this[_0x1f7ba5(0x494)]=this[_0x1f7ba5(0x8d1)],this[_0x1f7ba5(0x67c)]=this[_0x1f7ba5(0x5fd)];},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xaf1)]=function(){const _0x3ae0a9=_0xa8cad7;return this[_0x3ae0a9(0x573)]>0x0;},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x930)]=function(_0x41eb59,_0x4225da,_0x27b41a,_0x2edd8d){const _0x3f6697=_0xa8cad7;if(!this[_0x3f6697(0x8b9)]())return;if(!this[_0x3f6697(0x840)])return;if(this[_0x3f6697(0x31b)]===_0x41eb59&&this[_0x3f6697(0x4dd)]===_0x4225da)return;this[_0x3f6697(0x31b)]=_0x41eb59,this[_0x3f6697(0x4dd)]=_0x4225da,this['_skewDuration']=_0x27b41a,this[_0x3f6697(0x9e8)]=_0x27b41a,this[_0x3f6697(0x407)]=_0x2edd8d||_0x3f6697(0x9bc),_0x27b41a<=0x0&&(this[_0x3f6697(0x840)]['skew']['x']=this[_0x3f6697(0x31b)],this[_0x3f6697(0x840)][_0x3f6697(0x57a)]['y']=this[_0x3f6697(0x4dd)]);},Sprite_Battler['prototype'][_0xa8cad7(0x629)]=function(){const _0x2adce6=_0xa8cad7;if(this['_skewDuration']<=0x0)return;if(!this['_distortionSprite'])return;const _0x444a90=this[_0x2adce6(0x908)],_0xfc501e=this[_0x2adce6(0x9e8)],_0x4a141e=this[_0x2adce6(0x407)],_0x49591e=this['_distortionSprite'];Imported[_0x2adce6(0x8a4)]?(_0x49591e[_0x2adce6(0x57a)]['x']=this[_0x2adce6(0x59f)](_0x49591e[_0x2adce6(0x57a)]['x'],this['_targetSkewX'],_0x444a90,_0xfc501e,_0x4a141e),_0x49591e[_0x2adce6(0x57a)]['y']=this[_0x2adce6(0x59f)](_0x49591e[_0x2adce6(0x57a)]['y'],this['_targetSkewY'],_0x444a90,_0xfc501e,_0x4a141e)):'hHxHq'!==_0x2adce6(0x2ee)?(_0x49591e[_0x2adce6(0x57a)]['x']=(_0x49591e['skew']['x']*(_0x444a90-0x1)+this['_targetSkewX'])/_0x444a90,_0x49591e['skew']['y']=(_0x49591e[_0x2adce6(0x57a)]['y']*(_0x444a90-0x1)+this[_0x2adce6(0x4dd)])/_0x444a90):(_0x1d9783+=_0x17868c[_0x2adce6(0x902)]()?-_0xd8fe7:_0x10c7f6,_0x47a04d+=_0xb20c1e['isActor']()?-_0x4d5ebd:_0x4bc0ac);this[_0x2adce6(0x908)]--;if(this[_0x2adce6(0x908)]<=0x0)this[_0x2adce6(0xa4e)]();},Sprite_Battler[_0xa8cad7(0xa60)]['onSkewEnd']=function(){const _0x379f48=_0xa8cad7;this[_0x379f48(0x840)]['skew']['x']=this[_0x379f48(0x31b)],this[_0x379f48(0x840)][_0x379f48(0x57a)]['y']=this[_0x379f48(0x4dd)];},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x92a)]=function(){return this['_skewDuration']>0x0;},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x244)]=function(_0x5cad48,_0x13e452,_0x475691,_0x5730aa){const _0x3bf5e3=_0xa8cad7;if(!this[_0x3bf5e3(0x8b9)]())return;if(!this[_0x3bf5e3(0x840)])return;if(this[_0x3bf5e3(0x3a4)]===_0x5cad48)return;this[_0x3bf5e3(0x3a4)]=_0x5cad48,this[_0x3bf5e3(0x939)]=_0x13e452,this[_0x3bf5e3(0x5fb)]=_0x13e452,this[_0x3bf5e3(0x877)]=_0x475691||'Linear',this[_0x3bf5e3(0x8d7)]=_0x5730aa;if(this[_0x3bf5e3(0x8d7)]===undefined){if(_0x3bf5e3(0x7d1)==='WNRHg'){this[_0x3bf5e3(0x926)](_0x35febf)[_0x3bf5e3(0x21d)](/\\I\[(\d+)\]/i);const _0x5a5c50=_0x152b6d(_0x1688c9['$1'])||0x0,_0x2e5733=this[_0x3bf5e3(0x511)](_0x4f6698),_0x200b08=_0x2e5733['x']+_0x10ca13[_0x3bf5e3(0xb05)]((_0x2e5733['width']-_0x4d52b6[_0x3bf5e3(0x565)])/0x2),_0x3911e7=_0x2e5733['y']+(_0x2e5733[_0x3bf5e3(0xa97)]-_0x2af7c6[_0x3bf5e3(0x65c)])/0x2;this['drawIcon'](_0x5a5c50,_0x200b08,_0x3911e7);}else this['_angleRevertOnFinish']=!![];}if(_0x13e452<=0x0){if(_0x3bf5e3(0x9a7)===_0x3bf5e3(0xaa2)){const _0x5c3f28=this[_0x3bf5e3(0x73f)](this[_0x3bf5e3(0x840)]);this[_0x3bf5e3(0x1fc)](this[_0x3bf5e3(0x224)],_0x5c3f28),this[_0x3bf5e3(0x5ea)]();}else this[_0x3bf5e3(0x513)]=_0x5cad48,this['_angleRevertOnFinish']&&(this[_0x3bf5e3(0x3a4)]=0x0,this[_0x3bf5e3(0x513)]=0x0);}},Sprite_Battler[_0xa8cad7(0xa60)]['updateSpin']=function(){const _0x1cf9c2=_0xa8cad7;this[_0x1cf9c2(0x62b)](),this[_0x1cf9c2(0x943)]();},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x62b)]=function(){const _0x9c57d7=_0xa8cad7;if(this[_0x9c57d7(0x939)]<=0x0)return;const _0x374648=this['_angleDuration'],_0x19935d=this[_0x9c57d7(0x5fb)],_0x4fc2db=this['_angleEasing'];if(Imported[_0x9c57d7(0x8a4)])this[_0x9c57d7(0x513)]=this[_0x9c57d7(0x59f)](this['_currentAngle'],this[_0x9c57d7(0x3a4)],_0x374648,_0x19935d,_0x4fc2db);else{if(_0x9c57d7(0x388)===_0x9c57d7(0x81a)){if(!this[_0x9c57d7(0xa3b)])this['clearDamagePopup']();return this['_damagePopupArray']['length']>0x0;}else this[_0x9c57d7(0x513)]=(this[_0x9c57d7(0x513)]*(_0x374648-0x1)+this[_0x9c57d7(0x3a4)])/_0x374648;}this[_0x9c57d7(0x939)]--;if(this[_0x9c57d7(0x939)]<=0x0)this[_0x9c57d7(0x4f7)]();},Sprite_Battler[_0xa8cad7(0xa60)]['onAngleEnd']=function(){const _0x12a8fd=_0xa8cad7;this[_0x12a8fd(0x513)]=this['_targetAngle'],this[_0x12a8fd(0x8d7)]&&(this['_targetAngle']=0x0,this[_0x12a8fd(0x513)]=0x0);},Sprite_Battler[_0xa8cad7(0xa60)]['isSpinning']=function(){const _0x50fbc4=_0xa8cad7;return this[_0x50fbc4(0x939)]>0x0;},Sprite_Battler['prototype'][_0xa8cad7(0x943)]=function(){const _0xa1346=_0xa8cad7;if(!this['_distortionSprite'])return;const _0x50c57c=this[_0xa1346(0x513)],_0x1455da=this[_0xa1346(0x122)]['x'],_0x296871=this[_0xa1346(0x959)][_0xa1346(0x902)]()?-0x1:0x1;this[_0xa1346(0x840)][_0xa1346(0x548)]=_0x50c57c*_0x1455da*_0x296871;const _0x3805ad=this[_0xa1346(0x840)][_0xa1346(0x122)]['y'];this[_0xa1346(0x840)]['y']=this[_0xa1346(0xa97)]*-0.5*(0x2-_0x3805ad),this[_0xa1346(0x840)]['y']=Math[_0xa1346(0x412)](this[_0xa1346(0x840)]['y']);const _0xfab084=[this[_0xa1346(0xb80)],this[_0xa1346(0x130)],this[_0xa1346(0x540)]];for(const _0x92e3ed of _0xfab084){if(_0xa1346(0xa61)===_0xa1346(0x35e)){const _0x26fe10=_0x52d3a1[_0xa1346(0x707)]('['+_0x4ad669['$1']['match'](/\d+/g)+']');for(const _0x2eaa0c of _0x26fe10){if(!_0x3ff830[_0xa1346(0xa9e)](_0x2eaa0c))return![];}return!![];}else{if(!_0x92e3ed)continue;_0x92e3ed['y']=this[_0xa1346(0xa97)]*0.5;}}this[_0xa1346(0x224)]&&(_0xa1346(0x7a6)!==_0xa1346(0x8e2)?(this[_0xa1346(0xb22)]=this[_0xa1346(0xb22)]??0x1,this['_shadowScaleY']=this['_shadowScaleY']??0x1,this[_0xa1346(0x224)][_0xa1346(0x122)]['x']=this[_0xa1346(0x840)][_0xa1346(0x122)]['x']*this[_0xa1346(0xb22)],this[_0xa1346(0x224)][_0xa1346(0x122)]['y']=this[_0xa1346(0x840)][_0xa1346(0x122)]['y']*this[_0xa1346(0xace)]):(this[_0xa1346(0x530)]=this[_0xa1346(0xac4)]()['name'](),this['refresh']()));},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xa10)]=Sprite_Actor['prototype'][_0xa8cad7(0x6b0)],Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x6b0)]=function(){const _0x5f0be2=_0xa8cad7;VisuMZ[_0x5f0be2(0x8a9)][_0x5f0be2(0xa10)][_0x5f0be2(0x9b5)](this),VisuMZ['BattleCore'][_0x5f0be2(0xb57)][_0x5f0be2(0xb2e)][_0x5f0be2(0x6dc)]&&(_0x5f0be2(0xac7)==='qwBSt'?this['x']=_0x130ae5[_0x5f0be2(0x719)]-this[_0x5f0be2(0xac4)]()[_0x5f0be2(0xac0)]()['_baseX']:this['createHpGaugeSprite']());},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x92d)]=Sprite_Enemy['prototype'][_0xa8cad7(0xa1c)],Sprite_Enemy['prototype'][_0xa8cad7(0xa1c)]=function(){const _0x1589b4=_0xa8cad7;VisuMZ[_0x1589b4(0x8a9)][_0x1589b4(0xb57)]['HpGauge']['ShowEnemyGauge']&&this[_0x1589b4(0x634)](),VisuMZ[_0x1589b4(0x8a9)][_0x1589b4(0x92d)]['call'](this);},Sprite_Battler['prototype'][_0xa8cad7(0x634)]=function(){const _0x1e958d=_0xa8cad7;if(!ConfigManager[_0x1e958d(0x91a)])return;if(this[_0x1e958d(0xa17)]===Sprite_SvEnemy)return;const _0x4d7263=VisuMZ[_0x1e958d(0x8a9)][_0x1e958d(0xb57)]['HpGauge'],_0x7de48a=new Sprite_HpGauge();_0x7de48a['anchor']['x']=_0x4d7263[_0x1e958d(0x784)],_0x7de48a[_0x1e958d(0xa5c)]['y']=_0x4d7263[_0x1e958d(0x637)],_0x7de48a['scale']['x']=_0x7de48a[_0x1e958d(0x122)]['y']=_0x4d7263[_0x1e958d(0x8d9)],this['_hpGaugeSprite']=_0x7de48a,this[_0x1e958d(0x9ac)](this[_0x1e958d(0x161)]);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x950)]=Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x393)],Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x393)]=function(_0x42e12c){const _0x75f8ca=_0xa8cad7,_0x4f6f95=this[_0x75f8ca(0x959)];VisuMZ[_0x75f8ca(0x8a9)]['Sprite_Battler_setBattler'][_0x75f8ca(0x9b5)](this,_0x42e12c),this[_0x75f8ca(0x42a)](_0x42e12c);if(_0x4f6f95!==_0x42e12c)this[_0x75f8ca(0x8c8)]();},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x42a)]=function(_0x26a512){const _0x5af3af=_0xa8cad7;if(!_0x26a512)return;if(!this[_0x5af3af(0x161)])return;if(_0x26a512[_0x5af3af(0x902)]()){}else{if(_0x26a512[_0x5af3af(0x31f)]()){if(this[_0x5af3af(0xa17)]===Sprite_SvEnemy&&!_0x26a512[_0x5af3af(0xb29)]())return;}}this[_0x5af3af(0x161)]['setup'](_0x26a512,'hp');},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x888)]=function(){const _0x37c34d=_0xa8cad7;if(!this[_0x37c34d(0x959)])return;if(!this[_0x37c34d(0x161)])return;const _0x3b6eaf=VisuMZ[_0x37c34d(0x8a9)][_0x37c34d(0xb57)][_0x37c34d(0xb2e)],_0x2c4a52=this['_hpGaugeSprite'];_0x2c4a52[_0x37c34d(0x7d0)]=this[_0x37c34d(0x2a7)]();const _0x5456b4=_0x3b6eaf[_0x37c34d(0x131)],_0x1412cb=_0x3b6eaf[_0x37c34d(0x944)];_0x2c4a52['x']=_0x5456b4,_0x2c4a52['x']+=this[_0x37c34d(0x959)][_0x37c34d(0x206)](),_0x2c4a52['y']=-this[_0x37c34d(0xa97)]+_0x1412cb,_0x2c4a52['y']+=this['_battler'][_0x37c34d(0x705)]();},Sprite_Battler['prototype'][_0xa8cad7(0x2a7)]=function(){const _0x11b237=_0xa8cad7;if(!this[_0x11b237(0x959)])return![];if(this['_battler'][_0x11b237(0x902)]())return!![];const _0xb10299=this[_0x11b237(0x959)][_0x11b237(0xac4)]()[_0x11b237(0x74f)];if(_0xb10299[_0x11b237(0x21d)](/<SHOW HP GAUGE>/i))return!![];if(_0xb10299[_0x11b237(0x21d)](/<HIDE HP GAUGE>/i))return![];const _0xda067f=VisuMZ[_0x11b237(0x8a9)][_0x11b237(0xb57)]['HpGauge'];if(_0xda067f[_0x11b237(0x921)]){if(_0xda067f[_0x11b237(0x3f0)]&&BattleManager[_0x11b237(0x291)]())return!![];if(this[_0x11b237(0x959)]['_visualHpGauge_JustDied'])return![];return this[_0x11b237(0x959)][_0x11b237(0x316)]();}return!![];},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x88f)]=Sprite_Battler[_0xa8cad7(0xa60)]['isMoving'],Sprite_Battler[_0xa8cad7(0xa60)]['isMoving']=function(){const _0x1c315d=_0xa8cad7;if(!this[_0x1c315d(0x959)])return![];if(this[_0x1c315d(0x12b)]>0x0)return!![];return VisuMZ[_0x1c315d(0x8a9)][_0x1c315d(0x88f)]['call'](this);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x160)]=Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x655)],Sprite_Battler['prototype'][_0xa8cad7(0x655)]=function(_0x4b25b4,_0x4a290e,_0xdb7a42){const _0x466502=_0xa8cad7;this['canMove']()&&VisuMZ['BattleCore'][_0x466502(0x160)][_0x466502(0x9b5)](this,_0x4b25b4,_0x4a290e,_0xdb7a42);},Sprite_Battler[_0xa8cad7(0xa60)]['canMove']=function(){const _0x544b7d=_0xa8cad7;if(this[_0x544b7d(0x959)]&&this[_0x544b7d(0x959)][_0x544b7d(0xb06)]())return![];if(this[_0x544b7d(0x959)]&&!this[_0x544b7d(0x959)]['canBattlerMove']())return![];return $gameSystem[_0x544b7d(0x1d3)]();},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0xb33)]=function(){},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x596)]=function(){const _0x177f38=_0xa8cad7;this[_0x177f38(0x655)](0x0,0x0,0xc);},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x4ce)]=function(){},Sprite_Battler[_0xa8cad7(0xa60)][_0xa8cad7(0x435)]=function(){const _0x122401=_0xa8cad7,_0x48bff6=VisuMZ[_0x122401(0x8a9)][_0x122401(0xb57)][_0x122401(0x3d8)],_0x87d2dd=this[_0x122401(0x959)]&&this['_battler']['isActor']()?0x1:-0x1,_0x4212df=this[_0x122401(0x7c5)]-this[_0x122401(0xab8)]+_0x87d2dd*_0x48bff6['FlinchDistanceX'],_0x556c5b=this['_baseY']-this['_homeY']+_0x87d2dd*_0x48bff6[_0x122401(0x72a)],_0x57e102=_0x48bff6[_0x122401(0x237)];this[_0x122401(0x655)](_0x4212df,_0x556c5b,_0x57e102);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x2ca)]=Sprite_Actor['prototype'][_0xa8cad7(0x32a)],Sprite_Actor['prototype'][_0xa8cad7(0x32a)]=function(){const _0x100908=_0xa8cad7;VisuMZ['BattleCore'][_0x100908(0x2ca)][_0x100908(0x9b5)](this),this[_0x100908(0x920)]();},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x7d7)]=function(){const _0x3185b9=_0xa8cad7;return this['_distortionSprite']||this[_0x3185b9(0xb80)]||this;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x1d0)]=Sprite_Actor['prototype'][_0xa8cad7(0x72e)],Sprite_Actor[_0xa8cad7(0xa60)]['moveToStartPosition']=function(){},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x4a9)]=function(_0x3ee69f){const _0x49a37e=_0xa8cad7;if(SceneManager[_0x49a37e(0x455)]())return;if(!_0x3ee69f)return;if(!_0x3ee69f[_0x49a37e(0x8b9)]())return;VisuMZ[_0x49a37e(0x8a9)][_0x49a37e(0x1d0)][_0x49a37e(0x9b5)](this);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x70b)]=Sprite_Actor['prototype'][_0xa8cad7(0x795)],Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x795)]=function(_0x419206){const _0xbba036=_0xa8cad7;VisuMZ['BattleCore'][_0xbba036(0xb57)][_0xbba036(0x3d8)][_0xbba036(0x54f)]?VisuMZ[_0xbba036(0x8a9)][_0xbba036(0xb57)][_0xbba036(0x3d8)][_0xbba036(0x54f)][_0xbba036(0x9b5)](this,_0x419206):VisuMZ[_0xbba036(0x8a9)][_0xbba036(0x70b)][_0xbba036(0x9b5)](this,_0x419206);},VisuMZ[_0xa8cad7(0x8a9)]['Sprite_Actor_setBattler']=Sprite_Actor[_0xa8cad7(0xa60)]['setBattler'],Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x393)]=function(_0x468e58){const _0x29176f=_0xa8cad7;VisuMZ[_0x29176f(0x8a9)]['Sprite_Actor_setBattler'][_0x29176f(0x9b5)](this,_0x468e58),this[_0x29176f(0x266)](_0x468e58);},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x266)]=function(_0x1256fe){const _0x258d4c=_0xa8cad7;if(!_0x1256fe)return;if(!this[_0x258d4c(0xb80)])return;this['_mainSprite']['anchor']['x']=this['_actor'][_0x258d4c(0xa2d)](),this[_0x258d4c(0xb80)][_0x258d4c(0xa5c)]['y']=this[_0x258d4c(0xa48)]['svBattlerAnchorY'](),this['updateShadowVisibility']();},VisuMZ['BattleCore'][_0xa8cad7(0x58e)]=Sprite_Actor[_0xa8cad7(0xa60)]['update'],Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x99e)]=function(){const _0x4b406c=_0xa8cad7;VisuMZ[_0x4b406c(0x8a9)][_0x4b406c(0x58e)][_0x4b406c(0x9b5)](this);if(this[_0x4b406c(0xa48)]){if(_0x4b406c(0xb34)!==_0x4b406c(0xb91))this['updateStateSprite'](),this[_0x4b406c(0x771)]();else{let _0x3d1f5d=_0x178c0e(_0xe3d30e['$1']);while(_0x3d1f5d--){_0x37e351[_0x4b406c(0x6c0)](this[_0x4b406c(0xac9)]()['trueRandomTarget']());}return this[_0x4b406c(0x345)](_0x382479);}}},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xac2)]=Sprite_Actor[_0xa8cad7(0xa60)]['updateBitmap'],Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x3e1)]=function(){const _0xb2fca3=_0xa8cad7;VisuMZ[_0xb2fca3(0x8a9)][_0xb2fca3(0xac2)][_0xb2fca3(0x9b5)](this);if(this[_0xb2fca3(0xb80)]&&this[_0xb2fca3(0xb80)][_0xb2fca3(0x379)]&&this[_0xb2fca3(0x959)]){if(_0xb2fca3(0x2cc)!==_0xb2fca3(0x3ca))this[_0xb2fca3(0xb80)][_0xb2fca3(0x379)][_0xb2fca3(0xb20)]!==this[_0xb2fca3(0x959)][_0xb2fca3(0x2ea)]()&&(this[_0xb2fca3(0xb80)][_0xb2fca3(0x379)][_0xb2fca3(0xb20)]=this['_battler'][_0xb2fca3(0x2ea)]());else{const _0x87e995=this[_0xb2fca3(0xb80)][_0xb2fca3(0x379)];_0x87e995&&(this[_0xb2fca3(0x379)]=new _0x521ec8(_0x87e995[_0xb2fca3(0x960)],_0x87e995[_0xb2fca3(0xa97)]));}}},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x17c)]=Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0xb51)],Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0xb51)]=function(){const _0x2d6de0=_0xa8cad7;VisuMZ['BattleCore'][_0x2d6de0(0x17c)][_0x2d6de0(0x9b5)](this),this[_0x2d6de0(0x165)]();},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x165)]=function(){const _0x4d29d1=_0xa8cad7;if(!this[_0x4d29d1(0xb80)])return;if(!this[_0x4d29d1(0x224)])return;this[_0x4d29d1(0x5ea)](),this[_0x4d29d1(0x343)]();},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x92b)]=function(){const _0x204f49=_0xa8cad7;this[_0x204f49(0x64d)]['scale']['x']=0x1/(this['scale']['x']||0.001),this[_0x204f49(0x64d)][_0x204f49(0x122)]['y']=0x1/(this[_0x204f49(0x122)]['y']||0.001);},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x771)]=function(){const _0x474467=_0xa8cad7;if(!$gameSystem[_0x474467(0x1d3)]()&&this['constructor']===Sprite_Actor){if('yMylV'!==_0x474467(0xb44)){this[_0x474467(0x6c0)]('performSubstitute',_0x3238ae,_0x4767a2);if(!_0x2da9a9['BattleCore'][_0x474467(0xb57)][_0x474467(0x6df)][_0x474467(0x942)])return;const _0x39fc82=_0x264f32[_0x474467(0x9a6)](),_0x36bd87=_0x4f82dd['substitute']['format'](_0x39fc82,_0x7c9608[_0x474467(0x9a6)]());this[_0x474467(0x6c0)](_0x474467(0xa27),_0x36bd87);}else{const _0x7d25df=Scene_Battle[_0x474467(0xa60)][_0x474467(0x1cc)]();['default',_0x474467(0x8cb),_0x474467(0x33b),'border'][_0x474467(0x220)](_0x7d25df)&&(this[_0x474467(0xa4c)]=0x0);}}},Sprite_Actor['prototype'][_0xa8cad7(0x117)]=function(){const _0x4c4794=_0xa8cad7,_0x1146f1=this['_actor'];if(_0x1146f1){const _0x26d135=_0x1146f1[_0x4c4794(0x2b9)]();if(_0x1146f1['isInputting']()||_0x1146f1[_0x4c4794(0x54a)]())this[_0x4c4794(0x828)](_0x4c4794(0x18e));else{if(_0x26d135===0x3){if(_0x4c4794(0x695)===_0x4c4794(0x7db))return this['width']*this[_0x4c4794(0x3bf)]();else this[_0x4c4794(0x828)](_0x4c4794(0x8b3));}else{if(_0x26d135===0x2)this['startMotion'](_0x4c4794(0x82e));else{if(this[_0x4c4794(0x65a)])this['startMotion'](_0x4c4794(0x1ce));else{if(_0x1146f1[_0x4c4794(0xa74)]())this[_0x4c4794(0x828)](_0x4c4794(0x4ab));else{if(_0x1146f1[_0x4c4794(0x3f2)]())this['startMotion'](_0x4c4794(0x5db));else{if(_0x1146f1[_0x4c4794(0x766)]()||_0x1146f1['isGuardWaiting']())this[_0x4c4794(0x828)](_0x4c4794(0x452));else{if(_0x26d135===0x1)this[_0x4c4794(0x828)](_0x4c4794(0x9aa));else{if(_0x1146f1[_0x4c4794(0x873)]())this[_0x4c4794(0x828)](_0x4c4794(0x8ae));else{if(_0x1146f1[_0x4c4794(0x8d2)]())this[_0x4c4794(0x828)](_0x4c4794(0x18e));else{if(_0x1146f1[_0x4c4794(0xae6)]()){if(_0x4c4794(0x2b1)===_0x4c4794(0x2b1))this['startMotion'](_0x4c4794(0x4ab));else{_0x20f877[_0x4c4794(0xa60)][_0x4c4794(0x8ff)][_0x4c4794(0x9b5)](this),this[_0x4c4794(0xb24)][_0x4c4794(0x711)]();if(!this[_0x4c4794(0xac4)]())return;this[_0x4c4794(0xad1)]();}}else{if(_0x4c4794(0x7c3)!==_0x4c4794(0x2fc))this[_0x4c4794(0x828)](_0x4c4794(0x18e));else{if(!_0x21cbc6['BattleCore'][_0x4c4794(0xb57)][_0x4c4794(0xb2e)][_0x4c4794(0xb71)])return;const _0x5b93b0=_0x421825[_0x4c4794(0x91a)],_0x233d32=_0x4c4794(0x91a);this[_0x4c4794(0x87d)](_0x5b93b0,_0x233d32);}}}}}}}}}}}}}},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x4ce)]=function(){const _0xa57e6d=0xa,_0x550bc3=0x12c*_0xa57e6d,_0xe422be=0x1e*_0xa57e6d;this['startMove'](_0x550bc3,0x0,_0xe422be);},Sprite_Actor['prototype']['onMoveEnd']=function(){const _0x256b90=_0xa8cad7;Sprite_Battler[_0x256b90(0xa60)][_0x256b90(0x93a)][_0x256b90(0x9b5)](this);},Sprite_Actor['prototype'][_0xa8cad7(0x534)]=function(){const _0x542700=_0xa8cad7;return Sprite_Battler[_0x542700(0x837)];},Sprite_Weapon[_0xa8cad7(0xa60)]['animationWait']=function(){return Sprite_Battler['_motionSpeed'];},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x638)]=function(){},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x5d4)]=function(){},Sprite_Actor[_0xa8cad7(0xa60)]['updateMotionCount']=function(){const _0x24830b=_0xa8cad7;if(this[_0x24830b(0x8fa)]&&++this[_0x24830b(0x4e9)]>=this[_0x24830b(0x534)]()){if(this[_0x24830b(0x8fa)][_0x24830b(0x71e)])this[_0x24830b(0x60d)]=(this[_0x24830b(0x60d)]+0x1)%0x4;else this['_pattern']<0x2?this[_0x24830b(0x60d)]++:this[_0x24830b(0x117)]();this[_0x24830b(0x4e9)]=0x0;}},Sprite_Actor[_0xa8cad7(0xa60)]['forceMotion']=function(_0x5a8765){const _0x231164=_0xa8cad7;if(_0x5a8765===_0x231164(0x467))this['_checkOn']=!![];if(this[_0x231164(0x959)]&&this[_0x231164(0x959)]['isDead']()){this[_0x231164(0x8fa)]=Sprite_Actor[_0x231164(0x3e3)][_0x231164(0x8b3)];return;}const _0x24e93e=Sprite_Actor[_0x231164(0x3e3)][_0x5a8765];this[_0x231164(0x8fa)]=_0x24e93e,this['_motionCount']=0x0,this[_0x231164(0x60d)]=0x0;},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x59e)]=function(_0x13f698){const _0x3641c8=_0xa8cad7;this[_0x3641c8(0x41b)](),this[_0x3641c8(0x765)][_0x3641c8(0xb84)](_0x13f698),this['_actor'][_0x3641c8(0x3b5)]();},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x41b)]=function(){const _0x18ef11=_0xa8cad7;let _0x38a7b5=-0x10,_0x154b52=this[_0x18ef11(0xa97)]*0.5;const _0x58efdb=/<SIDEVIEW WEAPON OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i,_0x5d4e0b=this['_battler'][_0x18ef11(0x1db)]()[_0x18ef11(0x369)](_0x2d9ed2=>_0x2d9ed2&&_0x2d9ed2[_0x18ef11(0x74f)][_0x18ef11(0x21d)](_0x58efdb)?Number(RegExp['$1']):0x0),_0x509a65=this[_0x18ef11(0x959)][_0x18ef11(0x1db)]()[_0x18ef11(0x369)](_0x365524=>_0x365524&&_0x365524[_0x18ef11(0x74f)][_0x18ef11(0x21d)](_0x58efdb)?Number(RegExp['$2']):0x0);_0x38a7b5=_0x5d4e0b[_0x18ef11(0x9df)]((_0x3c8e9e,_0x56ed86)=>_0x3c8e9e+_0x56ed86,_0x38a7b5),_0x154b52=_0x509a65['reduce']((_0x54ab1e,_0x14d38a)=>_0x54ab1e+_0x14d38a,_0x154b52),this[_0x18ef11(0x765)]['x']=_0x38a7b5,this[_0x18ef11(0x765)]['y']=_0x154b52,this[_0x18ef11(0x765)][_0x18ef11(0x99e)]();},Sprite_Weapon['prototype'][_0xa8cad7(0xb84)]=function(_0x2538ff){const _0x197628=_0xa8cad7;this['_weaponImageId']=_0x2538ff,this[_0x197628(0x355)]=-0x1,this[_0x197628(0x60d)]=0x0,this[_0x197628(0x22a)](),this['updateFrame']();},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x8c2)]=function(){},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0xb33)]=function(){const _0x185143=_0xa8cad7,_0x24f146=VisuMZ[_0x185143(0x8a9)]['Settings'][_0x185143(0x19d)],_0x355528=_0x24f146['StepDistanceX'],_0x5615e5=_0x24f146['StepDistanceY'],_0x3d5995=_0x24f146[_0x185143(0x756)];this[_0x185143(0x655)](-_0x355528,-_0x5615e5,_0x3d5995);},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xa88)]=Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x471)],Sprite_Actor['prototype']['updateFrame']=function(){const _0x400964=_0xa8cad7;this[_0x400964(0x116)](),VisuMZ[_0x400964(0x8a9)][_0x400964(0xa88)][_0x400964(0x9b5)](this);},Sprite_Actor[_0xa8cad7(0xa60)][_0xa8cad7(0x116)]=function(){const _0x47b6a9=_0xa8cad7;if(this['_battler']&&this[_0x47b6a9(0x959)][_0x47b6a9(0x39d)]){if(_0x47b6a9(0x700)!==_0x47b6a9(0x8bc)){const _0x8999ce=this['_battler'][_0x47b6a9(0x39d)];this[_0x47b6a9(0x8fa)]=Sprite_Actor[_0x47b6a9(0x3e3)][_0x8999ce[_0x47b6a9(0x578)]],this['_pattern']=_0x8999ce[_0x47b6a9(0x89d)];const _0x406be6=this[_0x47b6a9(0x765)];_0x406be6[_0x47b6a9(0x1a1)](_0x8999ce[_0x47b6a9(0x73c)],_0x8999ce[_0x47b6a9(0x89d)]),this[_0x47b6a9(0x41b)]();}else this[_0x47b6a9(0x4f2)]=null,_0x275212['BattleCore'][_0x47b6a9(0x977)][_0x47b6a9(0x9b5)](this,_0x31d674);}},Sprite_Weapon[_0xa8cad7(0xa60)][_0xa8cad7(0x1a1)]=function(_0x3cfd73,_0x564083){const _0x333594=_0xa8cad7;this[_0x333594(0x914)]=_0x3cfd73,this[_0x333594(0x355)]=-Infinity,this[_0x333594(0x60d)]=_0x564083,this[_0x333594(0x22a)](),this['updateFrame']();},Sprite_Enemy[_0xa8cad7(0xa60)]['initMembers']=function(){const _0x2de445=_0xa8cad7;Sprite_Battler['prototype']['initMembers']['call'](this),this[_0x2de445(0x7c2)]=null,this[_0x2de445(0x425)]=![],this[_0x2de445(0x1ba)]='',this['_battlerHue']=0x0,this[_0x2de445(0xb17)]=null,this['_effectDuration']=0x0,this[_0x2de445(0x7d8)]=0x0,this['createMainSprite'](),this[_0x2de445(0xa1c)]();},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xb08)]=Sprite_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x99e)],Sprite_Enemy['prototype']['update']=function(){const _0x4d87d0=_0xa8cad7;VisuMZ[_0x4d87d0(0x8a9)][_0x4d87d0(0xb08)][_0x4d87d0(0x9b5)](this),this[_0x4d87d0(0x5ea)]();},Sprite_Enemy[_0xa8cad7(0xa60)]['createMainSprite']=function(){const _0x576540=_0xa8cad7;this[_0x576540(0xb80)]=new Sprite(),this[_0x576540(0xb80)][_0x576540(0xa5c)]['x']=0.5,this[_0x576540(0xb80)][_0x576540(0xa5c)]['y']=0x1,this[_0x576540(0x9ac)](this['_mainSprite']),this['attachSpritesToDistortionSprite']();},Sprite_Enemy['prototype'][_0xa8cad7(0x7d7)]=function(){const _0x23822d=_0xa8cad7;return this[_0x23822d(0x840)]||this[_0x23822d(0xb80)]||this;},Sprite_Enemy['prototype'][_0xa8cad7(0x22a)]=function(_0x33091b){const _0x3951af=_0xa8cad7;this['bitmap']=new Bitmap(0x1,0x1);if(this[_0x3951af(0xb29)]()){const _0x3a542e=this[_0x3951af(0x7c2)][_0x3951af(0x418)]();this[_0x3951af(0x379)]=new Bitmap(_0x3a542e[_0x3951af(0x960)],_0x3a542e[_0x3951af(0xa97)]),this[_0x3951af(0xb80)][_0x3951af(0x379)]=new Bitmap(0x1,0x1);}else{if($gameSystem[_0x3951af(0x1d3)]()){if(_0x3951af(0x802)!=='AmBaE')this[_0x3951af(0xb80)][_0x3951af(0x379)]=ImageManager['loadSvEnemy'](_0x33091b),this[_0x3951af(0xb80)][_0x3951af(0x379)]['addLoadListener'](this[_0x3951af(0x49b)][_0x3951af(0x66e)](this));else{if(!_0x306522['isSceneBattle']())return;_0x35ddf3['_scene']['removeOnceParallelInterpreter'](this),_0x15a034[_0x3951af(0xa60)][_0x3951af(0x5b0)]['call'](this);}}else this[_0x3951af(0xb80)][_0x3951af(0x379)]=ImageManager[_0x3951af(0x80d)](_0x33091b),this[_0x3951af(0xb80)][_0x3951af(0x379)][_0x3951af(0x842)](this[_0x3951af(0x49b)][_0x3951af(0x66e)](this));}},Sprite_Enemy['prototype'][_0xa8cad7(0x49b)]=function(){const _0x516ac4=_0xa8cad7,_0x29612f=this[_0x516ac4(0xb80)]['bitmap'];_0x29612f&&(this['bitmap']=new Bitmap(_0x29612f['width'],_0x29612f[_0x516ac4(0xa97)]));},VisuMZ[_0xa8cad7(0x8a9)]['Sprite_Enemy_setHue']=Sprite_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x83f)],Sprite_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x83f)]=function(_0x9dc397){const _0x8ef8f2=_0xa8cad7;this['_mainSprite']&&this[_0x8ef8f2(0xb80)][_0x8ef8f2(0x83f)](_0x9dc397);},VisuMZ['BattleCore'][_0xa8cad7(0x694)]=Sprite_Enemy['prototype'][_0xa8cad7(0x87b)],Sprite_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x87b)]=function(){const _0x139ee=_0xa8cad7;this[_0x139ee(0x4ec)]()?VisuMZ['BattleCore'][_0x139ee(0x694)][_0x139ee(0x9b5)](this):_0x139ee(0x759)==='PsnMZ'?(this['_requestRefresh']=![],_0x2b78f8[_0x139ee(0x8a9)][_0x139ee(0x85a)][_0x139ee(0x9b5)](this)):(this[_0x139ee(0x425)]=!this[_0x139ee(0x7c2)]['isHidden'](),!this[_0x139ee(0x425)]&&(this[_0x139ee(0xa4c)]=0x0));},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x2b7)]=Sprite_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x6c1)],Sprite_Enemy[_0xa8cad7(0xa60)]['updateCollapse']=function(){const _0x621d38=_0xa8cad7;if(this[_0x621d38(0x4ec)]())VisuMZ[_0x621d38(0x8a9)][_0x621d38(0x2b7)]['call'](this);},Sprite_Enemy['prototype'][_0xa8cad7(0x471)]=function(){const _0x100833=_0xa8cad7;Sprite_Battler[_0x100833(0xa60)][_0x100833(0x471)]['call'](this);const _0x1639d7=this[_0x100833(0x7d7)]()||this;if(!_0x1639d7)return;!_0x1639d7['bitmap']&&(_0x1639d7[_0x100833(0x379)]=new Bitmap(this[_0x100833(0x960)],this[_0x100833(0xa97)]));if(this[_0x100833(0xb17)]==='bossCollapse')this[_0x100833(0xb80)][_0x100833(0xafe)](0x0,0x0,this[_0x100833(0xb80)][_0x100833(0x960)],this[_0x100833(0xa86)]);else{if('gpznJ'==='gpznJ')_0x1639d7[_0x100833(0xafe)](0x0,0x0,_0x1639d7[_0x100833(0x379)][_0x100833(0x960)],this[_0x100833(0x379)][_0x100833(0xa97)]);else{if(!_0x131a46[_0x100833(0x45f)]())return;if(!_0x20393a[_0x100833(0x4f4)])return;_0x573c0a[_0x100833(0x17f)](_0x3ceff1,_0x2cfb6e);const _0x18dd92=_0x3b1cfb[_0x100833(0x95a)],_0x2f4ba6=_0x1908e7[_0x100833(0x194)];if(!_0x18dd92)return;_0x18dd92[_0x100833(0x5e6)]=_0x2f4ba6;}}},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x2e5)]=Sprite_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x282)],Sprite_Enemy[_0xa8cad7(0xa60)]['updateBossCollapse']=function(){const _0x4c050a=_0xa8cad7;if(this['allowCollapse']())VisuMZ[_0x4c050a(0x8a9)][_0x4c050a(0x2e5)][_0x4c050a(0x9b5)](this);},Sprite_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x558)]=function(){const _0x2045d0=_0xa8cad7;return Sprite_Battler[_0x2045d0(0xa60)]['isMoving'][_0x2045d0(0x9b5)](this);},VisuMZ[_0xa8cad7(0x8a9)]['Sprite_Enemy_updateStateSprite']=Sprite_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x92b)],Sprite_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x92b)]=function(){const _0x25778f=_0xa8cad7;VisuMZ[_0x25778f(0x8a9)][_0x25778f(0xb2c)][_0x25778f(0x9b5)](this),this[_0x25778f(0x855)]();},Sprite_Enemy['prototype'][_0xa8cad7(0x855)]=function(){const _0x2e8f7b=_0xa8cad7,_0x55edf1=VisuMZ[_0x2e8f7b(0x8a9)][_0x2e8f7b(0xb57)][_0x2e8f7b(0x8d5)];if(_0x55edf1[_0x2e8f7b(0x631)]&&!_0x55edf1['NameLegacy']){if(_0x2e8f7b(0xb50)!==_0x2e8f7b(0xb50))_0x460eb7[_0x2e8f7b(0x8a9)]['JS'][_0x1e1622][_0x2e8f7b(0x9b5)](this,this[_0x2e8f7b(0x222)](),this[_0x2e8f7b(0x222)](),this[_0x2e8f7b(0x191)](),_0x86657d);else{this[_0x2e8f7b(0x907)][_0x2e8f7b(0xa4c)]=0x0;return;}}this[_0x2e8f7b(0x907)]['x']=0x0,this[_0x2e8f7b(0x907)]['x']+=this[_0x2e8f7b(0x959)]['battleUIOffsetX'](),this['_stateIconSprite']['y']=-this[_0x2e8f7b(0x379)]['height']-this[_0x2e8f7b(0x907)][_0x2e8f7b(0xa97)],this[_0x2e8f7b(0x907)]['y']+=this[_0x2e8f7b(0x959)]['battleUIOffsetY'](),this['_stateIconSprite'][_0x2e8f7b(0x122)]['x']=0x1/(this[_0x2e8f7b(0x122)]['x']||0.001),this[_0x2e8f7b(0x907)][_0x2e8f7b(0x122)]['y']=0x1/(this['scale']['y']||0.001);if(this[_0x2e8f7b(0xb29)]()){if(_0x2e8f7b(0xb68)!=='bpgrC'){const _0x49ae08=this[_0x2e8f7b(0x959)][_0x2e8f7b(0x39d)];this[_0x2e8f7b(0x8fa)]=_0x2107f6[_0x2e8f7b(0x3e3)][_0x49ae08[_0x2e8f7b(0x578)]],this[_0x2e8f7b(0x60d)]=_0x49ae08[_0x2e8f7b(0x89d)];const _0x466613=this[_0x2e8f7b(0x765)];_0x466613['freezeFrame'](_0x49ae08['weaponImageId'],_0x49ae08[_0x2e8f7b(0x89d)]),this[_0x2e8f7b(0x41b)]();}else this['_svBattlerSprite'][_0x2e8f7b(0x64d)][_0x2e8f7b(0x122)]['x']=-0x1/(this['scale']['x']||0.001),this[_0x2e8f7b(0x130)][_0x2e8f7b(0x64d)]['scale']['y']=0x1/(this['scale']['y']||0.001);}},VisuMZ[_0xa8cad7(0x8a9)]['Sprite_Enemy_setBattler']=Sprite_Enemy[_0xa8cad7(0xa60)]['setBattler'],Sprite_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x393)]=function(_0x481e2a){const _0x560afc=_0xa8cad7;VisuMZ[_0x560afc(0x8a9)]['Sprite_Enemy_setBattler'][_0x560afc(0x9b5)](this,_0x481e2a),this[_0x560afc(0xae7)](_0x481e2a);},Sprite_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0xae7)]=function(_0x58148a){const _0x3da832=_0xa8cad7;!this['_svBattlerSprite']&&(this['_svBattlerSprite']=new Sprite_SvEnemy(_0x58148a),this['attachSpritesToDistortionSprite']()),this[_0x3da832(0x130)][_0x3da832(0x393)](_0x58148a);},Sprite_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0xb29)]=function(){const _0x2f0134=_0xa8cad7;return this[_0x2f0134(0x7c2)]&&this['_enemy']['hasSvBattler']();},Sprite_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0x4ec)]=function(){const _0x3e212c=_0xa8cad7;return this[_0x3e212c(0xb29)]()?this['_enemy'][_0x3e212c(0x4ec)]():_0x3e212c(0x5ad)===_0x3e212c(0x5ad)?!![]:_0x1c5176[_0x3e212c(0x6d5)]();},Sprite_Enemy['prototype'][_0xa8cad7(0x117)]=function(){const _0x5615a5=_0xa8cad7;this[_0x5615a5(0xb29)]()&&this[_0x5615a5(0x130)][_0x5615a5(0x117)]();},Sprite_Enemy['prototype'][_0xa8cad7(0xa46)]=function(_0x46312c){const _0x59bf39=_0xa8cad7;if(this[_0x59bf39(0xb29)]())this[_0x59bf39(0x130)][_0x59bf39(0xa46)](_0x46312c);},Sprite_Enemy['prototype'][_0xa8cad7(0x59e)]=function(_0x5e1969){if(this['hasSvBattler']())this['_svBattlerSprite']['forceWeaponAnimation'](_0x5e1969);},Sprite_Enemy[_0xa8cad7(0xa60)][_0xa8cad7(0xb33)]=function(){const _0xb84fd7=_0xa8cad7,_0x239fba=VisuMZ[_0xb84fd7(0x8a9)][_0xb84fd7(0xb57)][_0xb84fd7(0x19d)],_0x5778a5=_0x239fba[_0xb84fd7(0x3b3)],_0x4d32df=_0x239fba[_0xb84fd7(0x95f)],_0x20149d=_0x239fba[_0xb84fd7(0x756)];this['startMove'](_0x5778a5,_0x4d32df,_0x20149d);};function _0x4175(){const _0x430df7=['smooth','ActSeq_Camera_FocusPoint','_shadowScaleX','Kfkcm','contents','helpWindowRectBorderStyle','isBattleFlipped','ActSeq_Projectile_Picture','etjHU','hasSvBattler','loadSystem','ATK','Sprite_Enemy_updateStateSprite','ITEM','HpGauge','yPydl','qARFJ','processActorCommandCancelTPB','abs','stepForward','fRHon','PartyCmd','VisuMZ_1_SkillsStatesCore','Scene_Battle_onActorOk','startAction','isAnyoneSkewing','cancel','+%1','BattleManager_endBattle','clearResult','performActionEnd','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','NsHNt','_autoBattle','applyForcedGameTroopSettingsBattleCore','Game_Actor_equips','yMylV','trim','clearMotion','criticalHitRate','border','Window_BattleLog_displayEvasion','canUse','targetActionSet','exit','mpDamage','PreEndBattleJS','ActionSkillMsg2','KcDyV','updateShadow','CmdIconAutoBattle','MXldT','_commandNameWindow','description','isMagicSkill','Settings','WaitForScale','onEscapeFailure','clamp','skewDuration','dimColor2','_attackAnimationId','YhjYM','context','dead\x20enemies','_back1Sprite','VisuMZ_2_BattleSystemATB','magicReflection','wNqhi','NameFontSize','displayFailure','_growWholeDuration','bpgrC','softDamageCapRate','isQueueOptionsMenu','_tpbSceneChangeCacheActor','ActSeq_Horror_GlitchCreate','ActionEffect','vRIAe','DamageRate','applyCritical','AddHpGaugeOption','ARRAYEVAL','canUseItemCommand','VisuMZ_2_WeaponSwapSystem','updateEventMain','clearElementChanges','ActSeq_Mechanics_BoostPointsStoreData','_updateCursorFilterArea','missile','BattleManager_onEscapeFailure','TriJW','WaitForZoom','%1StartBattleJS','ParseEnemyNotetags','vmFUU','_mainSprite','moveBattlerToPoint','YqYAq','PTNXg','setup','BindCommonEventKeysForGroup','_forcedBattlers','VuWbX','chantStyle','NameAlwaysHidden','onHomeMoveEnd','evaded','isFastForward','Scene_Battle_skillWindowRect','CastAnimation','FollowTurn','Game_Actor_makeActionList','tzZpQ','ConfigManager_applyData','TyeED','ShowHpDmg','RgnTu','zMxLc','ResetOffset','isPhysical','updateRefresh','SmoothImage','applyFreezeMotionFrames','refreshMotion','VisuMZ_2_HorrorEffects','VisuMZ_3_ActSeqImpact','createActors','currentSymbol','EnableSoftCap','damage','ActSeq_Movement_HomeMoveToTarget','waitForAnimation','isImmortal','font','scale','_target','_actions','placeTimeGauge','displayEvasion','updateVisibility','setSTBExploited','process_VisuMZ_BattleCore_PreBattleCommonEvent','Window_BattleLog_displayActionResults','_homeDuration','isSkill','_createCursorArea','textWidth','auto','_svBattlerSprite','OffsetX','yeQer','isBattleCoreTargetScope','displayAddedStates','cancelButtonText','split','custom','drawItem','Window_BattleLog_performDamage','YGHfp','updatePositionBattleCore','isAtbChargingState','Game_Battler_startTpbTurn','isTriggered','statusTextAutoBattleStyle','_regionBattleback2','BravePoints','mainSpriteScaleY','COMBAT\x20LOG','commandSymbol','CalcEscapeRaiseJS','pmKzU','drawSingleSkillCost','_partyCommandWindow','_methods','ScaleDown','Game_Battler_performActionStart','XPSpriteYLocation','uQRyt','updatePosition','XZpEh','WqxDR','statusWindowRectXPStyle','jWLVR','indexOf','StatusWindowAttachmentFrontOffsetY','Spriteset_Battle_update','_enemyId','battleSys','log','sort','textAlign','getEnemyIdWithName','actionEffect','Sprite_AnimationMV_updatePosition','VisuMZ_2_BattleSystemFTB','TpbGaugeOffsetY','Sprite_Battler_startMove','_hpGaugeSprite','autoBattleAtStart','numRepeats','xbYZw','updateShadowBattleCore','ARRAYJSON','PqISg','playReflection','AEJOh','FlashDuration','Rate','createCommandNameWindow','DrdUT','_tpbState','Game_Party_removeActor','ParseSkillNotetags','Targets','isTickBased','Window_BattleLog_pushBaseLine','removeStatesAuto','ActionStart','battleCoreResumeLaunchBattle','NameOffsetY','autoBattle','GroupDigits','createCancelButton','displayReflectionPlayBack','Sprite_Actor_updateShadow','PopupDuration','rpbkC','ConvertParams','DefaultStyle','Scene_Battle_startPartyCommandSelection','DefeatEvent','createActorCommandWindowBattleCore','Window_BattleLog_displayCurrentState','repositionCancelButtonBorderStyle','isAutoBattle','PMidd','ActSeq_Mechanics_RemoveState','_autoBattleWindow','removeAnimationFromContainer','VEdOl','getBattlePortraitFilename','5588604MSKkVL','walk','actorCommandEscape','isAnyoneMoving','item','isSideButtonLayout','isTurnBased','Elements','4977jhJFjN','JsTar','tWIqj','performSTBExploiter','updateAttachedSprites','ActionSkillMsg1','close','length','ActionSequence','PKsSe','KQJTk','Game_Interpreter_command301','freezeFrame','jRJxZ','svAnchorX','_regionBattleback1','maxCommands','setSkill','ChangeOrderBy','TkCQI','getSkillIdWithName','selectNextCommand','WaitComplete','onDisabledPartyCommandSelection','inputtingAction','ShowMpDmg','_tpbNeedsPartyCommand','SideviewSelect','extraHeight','okButtonText','WtypeId','BattleStartEvent','setHelpWindowItem','action','MAXMP','padding','_jumpMaxHeight','_battlerName','animationNextDelay','performMoveToTargets','canInput','onBattleStart','drawItemImageXPStyle','SwXmu','setBattleZoom','coreEngineRepositionEnemies','position','Radius','_battlePortrait','dSXca','ActSeq_Animation_ActionAnimation','getCommonEventIdWithName','wDoxd','XkbVV','pow','battleLayoutStyle','hitRate','escape','InLAd','Sprite_Actor_moveToStartPosition','VisuMZ_3_ActSeqCamera','filter','isSideView','left','PreApplyAsTargetJS','TimeScale','performAction','Game_Action_itemHit','zFgto','isSTB','traitObjects','jCbSG','Window_BattleLog_performSubstitute','right','_opacityEasing','adjustPosition_1for1','xcbKm','AttackAnimation','Game_System_initialize','sCdwY','ActSeq_Projectile_Icon','LLVee','setWaitMode','addAttackCommand','Scene_Battle_onEnemyOk','fontSize','isOkEnabled','blt','VIZhT','_lineHeight','measureTextWidth','_drawTextOutline','Scene_Battle_partyCommandWindowRect','ActSeq_Movement_WaitForOpacity','oNNfu','isNonSubmenuCancel','jumpBattler','ShowAddedBuff','CommandWidth','hiQob','drawTextEx','performMoveToPoint','XhIsV','addChildAt','command3011','registerDefeatedEnemy','_updateClientArea','setValue','oDjVd','updateActors','WaitCount','LastSelected','updateBattleProcess','battleUIOffsetX','PostEndTurnJS','CeEBw','aliveMembers','Game_BattlerBase_initMembers','TxAGB','BackColor','BattleManager_startInput','nextActiveWeaponSlot','applyImmortal','ZSqeV','ActSeq_Mechanics_OnceParallel','wkYfS','_statusWindow','process_VisuMZ_BattleCore_PluginParams','Window_BattleLog_displayCritical','tYnhY','QiVOQ','ActSeq_Angle_WaitForAngle','14224fGyQuF','IwSbx','hSSkr','hide','match','itemHit','isBattleRefreshRequested','includes','isSkipPartyCommandWindow','subject','criticalDmgRate','_shadowSprite','applyData','QzaYc','updateHelp','BattleManager_processVictory','ActSeq_Horror_NoiseCreate','loadBitmap','fSGmc','FzYmE','_onceParallelInterpreters','NOFgc','SkewY','ActSeq_Mechanics_CtbSpeed','IBLjh','CoreEngine','ActSeq_Movement_Opacity','selectPreviousCommand','Window_BattleLog_update','drawTextTopAligned','FlinchDuration','fcUfn','DWnsG','applyGuard','param','clearFreezeMotion','IYlQd','isBattlerGrounded','HpGaugeOffsetY','gcDMO','isDTB','playCancel','jqSHA','startSpin','arPenRate','ActSeq_BattleLog_AddText','weatherPower','showHelpWindow','Game_Action_itemEffectAddAttackState','_flashDuration','isAffectedByBreakShield','iDiml','ActSeq_Movement_WaitForSpin','resize','sortDamageSprites','alterActionCostPTB','dHLFE','aIcqD','backColor','LHCUd','DefaultDamageStyle','clearActiveWeaponSet','_allTargets','skillId','cbaSY','alive\x20actors\x20not\x20user','gPeDX','innerHeight','updateJump','anchorX','createWeather','changePaintOpacity','isAnyoneChangingOpacity','setupRgbSplitImpactFilter','oINed','Window_BattleLog_performAction','_duration','setBattlerBattleCore','3XKNXCb','alive\x20friends\x20not\x20user','ActSeq_Mechanics_StbExploit','VisuMZ_2_BattleSystemOTB','_scene','SJooP','GggcV','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','autoMeleeSingleTargetActionSet','pBURR','flashDuration','izXiC','expRate','SoYOa','dBuhr','shadow','move','SceneManager_isSceneChanging','Amp','ActSeq_BattleLog_Clear','alive\x20actors','Scene_Map_initializeAfter','waitForJump','gFuaJ','allBattleMembers','qMzYo','HODFq','updateBossCollapse','StatusWindowAttachmentBack','setupIconTextPopup','children','isBorderStylePortraitShown','shift','Spriteset_Battle_createLowerLayer','DSlZz','TJkzM','bwWng','ActSeq_Movement_HomeMoveToPoint','windowPadding','gaugeX','ZyZlm','emerge','isBattleTest','ParseItemNotetags','TsGtA','VpRwI','Window_BattleLog_displayFailure','gainBravePoints','removeDamageSprite','removeBuff','iIcja','3036076ovjwBM','UkKCH','tYMeK','applySoftDamageCap','waitForFloat','Scene_Battle_selectPreviousCommand','resizeWindowXPStyle','options','deathStateId','States','PRE-','battleCommandIcon','checkSceneBattleTransitionable','isVisualHpGaugeDisplayed','Scene_Battle_start','AttachStateOffsetY','Game_Actor_setup','%1EndTurnJS','getBattlePortrait','RAVfV','NextTurn','KJwxB','ActSeq_Movement_Float','GiFzO','autoBattleWindowRect','mfrDJ','ARRAYNUM','removeActor','_commonEventKey','Sprite_Enemy_updateCollapse','uBEzZ','stateMotionIndex','ahYDS','gradientFillRect','trueRandomTarget','Scene_Options_maxCommands','qhofi','createActorCommandWindow','ActSeq_Impact_ShockwaveCenterTargets','HHnjW','toString','helpAreaBottom','sideview_ui','random','Mirror','SlXnH','Game_Battler_performEvasion','TextAlign','Sprite_Actor_initMembers','round','CYDcR','iRvTD','isETB','iOpaN','battleCommands','YAFZG','battlerSprites','ActSeq_Camera_FocusTarget','StatusWindowAttachmentFront','toUseBoostPoints','nameY','Game_Battler_onTurnEnd','fight','ForceDeath','CriticalColor','getBattlePortraitOffsetX','ActSeq_Target_RandTarget','_deathStateApplied','_endBattle','DamageDisplay','CastPhysical','fayrQ','ActSeq_Movement_MoveToPoint','Post','uRBIR','Sprite_Enemy_updateBossCollapse','onActorCancel','QPEEK','addedBuffs','nOcNr','battlerSmoothImage','riIMD','mdiVU','ActSeq_Horror_GlitchRemove','OJSuy','itemEffectAddAttackState','Window_BattleLog_performEvasion','createChildSprite','ActSeq_Movement_FaceDirection','HMjow','JS\x20%1DAMAGE\x20%2','OdrIL','PostDamage%1JS','rLagH','index','bzufP','_customDamageFormula','Vabjt','SDMHE','setLastPluginCommandInterpreter','YsQuH','oINLE','requestMotion','alive\x20actors\x20not\x20target','FaceDirection','isOpen','ConfigManager_makeData','OZNpN','uLUqk','GZBZp','updateHomeMove','message2','JumpToLabel','MIN_SAFE_INTEGER','fnordAddedStates','textSizeEx','Game_BattlerBase_canGuard','ActSeq_Mechanics_PtbAlterCost','command236','_flinched','fCmHZ','_enemyIDs','xccZM','gsAbJ','hasBeenDefeatedBefore','ActSeq_Element_Clear','EscapeFail','isItemCommandEnabled','_animation','_targetSkewX','aRdhp','JS\x20ESCAPE\x20FAILURE','SCAaC','isEnemy','bwsVR','battleMembers','ActSeq_Skew_Reset','setActionState','-%1','code','vLniE','ActorCmd','dmctt','redraw','initMembers','Sprite_Battler_initMembers','isDisplayEmergedEnemies','ActSeq_Motion_MotionType','qvYNX','VariableID','itemRect','slices','makeTargetsBattleCore','cvipp','performFlinch','BTRPF','PreApply%1JS','battleOpacity','createJS','jOEfU','_reflectionTarget','portrait','ActSeq_Mechanics_CtbOrder','isCustomBattleScope','PreRegenerateJS','waitForMovement','autoSelect','toLowerCase','pages','updateShadowPosition','windowskin','repeatTargets','setHalfActionsPTB','drawBackgroundRect','battleEffect','xDNLr','USotD','ShuffleArray','PopupShiftY','battleSpriteSkew','IoXKD','gmDMS','Hznjq','SQKSn','FRvZO','adjustPosition_ScaleDown','updateStart','_animationCount','iconIndex','attackStatesRate','isPartyTpbInputtable','HitFlat','_homeEasing','setupBattlebackBattleCore','startPartyCommandSelection','clearFreezeMotionForWeapons','oCmoB','CmdIconEscape','NameLegacy','isSelected','_inputting','yYtaQ','Scene_Battle_windowAreaHeight','_executedValue','waitCount','addImmortal','ActSeq_Mechanics_DeathBreak','map','setAttack','isTeamBased','isPlaytest','startHomeMove','AutoBattleMsg','ActSeq_Motion_RefreshMotion','EFFECT_COMMON_EVENT','mBMFh','uZvLQ','executeDamage','singleSkill','setActiveWeaponSet','arRedFlat','isATB','tipWp','bitmap','PerformAction','Duration','maxTp','FocusX','endAnimation','SkillsStatesCore','stop','_ptbActionCost','maNqW','Slot','isAutoBattleCommandEnabled','processDefeat','lukEffectRate','process_VisuMZ_BattleCore_TraitObject_Notetags','ljpJO','addEscapeCommand','isIncludedInEnemyWindow','AddOption','destroy','autoBattleUseSkills','xXIVl','DamageFlat','Scene_Map_updateCallMenu','_growEasing','_targetOpacity','setBattler','attackMotions','damageOffsetX','isAnimationPlaying','TpbGaugeOffsetX','Scene_Boot_onDatabaseLoaded','sUDTr','loadPicture','canGuard','startOpacity','_freezeMotionData','NdMsN','ActSeq_BattleLog_PushBaseLine','Window_BattleLog_performMagicEvasion','equipSlots','StatusWindowAttachmentBackOffsetX','finishActionSet','_targetAngle','_battleCoreBattleStartEvent','_lastRegenFrameCount','drawItemImagePortraitStyle','_lastPluginCommandInterpreter','getHardDamageCap','ActSeq_BattleLog_DisplayAction','HMEnm','_borderPortraitSprite','equips','mainSpriteHeight','DFxNB','PtgoZ','SwitchCritical','getAttackMotionSlot','StepDistanceX','MDF','clearWeaponAnimation','lojvY','checkTpbInputOpen','startWeaponAnimation','battlelog','ymanB','ShowRemovedState','refreshRequest','ActSeq_Mechanics_ArmorPenetration','result','mainSpriteScaleX','Window_BattleLog_performActionStart','EqORw','EmergeText','setBattleAngle','_escapeRatio','setupCriticalEffect','QPYBn','isBattlerFlipped','BattleManager_endAction','ShowMissEvasion','cbcHs','Scene_ItemBase_applyItem','JS\x20%1END\x20ACTION','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','Game_Action_setAttack','requestMotionRefresh','Yboyp','tone','CriticalDmgFlat','isBTB','_motionType','inputting','Rfmfo','playEnemyAttack','Actor','actorCommandAutoBattle','refreshStatusWindow','GUARD','ActSeq_Movement_Spin','faceWidth','Setting','isAttack','onFloatEnd','updateBitmap','globalAlpha','MOTIONS','drawText','hpDamage','XEwsM','actor','clearDamagePopup','addOptionsCommand','qJNAZ','requestFauxAnimation','_battleField','moveBattlerHomeToPoint','battleJump','MAXHP','BTestBypass','isInputting','isChanting','addSkillCommands','HelpEscape','revealNewWeaknesses','MtzJR','isForRandom','origin','addGuardCommand','%1StartTurnJS','Shadow2','CmdTextAutoBattle','JS\x20ESCAPE\x20SUCCESS','isFlipped','buffAdd','Window_BattleLog_displayMiss','uAVjo','ActSeq_Movement_FacePoint','hardDamageCap','commandOptions','lvuqT','STRUCT','_skewEasing','calcWindowHeight','addSingleSkillCommand','_linkedSprite','command301_PreBattleEvent','contains','_offsetX','isAlwaysHidden','prev\x20target','PXHqB','setHome','ceil','Enemy-%1-%2','checkTpbInputClose','createAttachmentSprites','VnRMY','isForOpponent','svBattlerData','TPB','centerFrontViewSprite','adjustWeaponSpriteOffset','toUpperCase','alterPriority','processForcedAction','NBhiA','venQi','debuffAdd','moveBattlerHomeDistance','create','compatibilityVisible','_appeared','_colorType','TargetLocation','performActionEndMembers','makeActionListAutoAttack','setupHpGaugeSprite','WaitForAnimation','focus','_flipScaleX','displayAffectedStatus','damageOffsetY','gainCurrentActionsETB','PreEndTurnJS','recoverAll','skewBattler','useDigitGrouping','stepFlinch','battleFloat','PSTtF','QoL','setVisibleUI','Shadow','arPenFlat','_defeatedEnemies','BattleManager_startBattle','StateIconOffsetY','canAttackBattleCore','attackAnimationIdSlot','ActSeq_Target_PrevTarget','updateCommandNameWindow','getNextDamagePopup','spinBattler','ActSeq_Horror_Clear','alive\x20enemies\x20not\x20target','updateGrow','xIIZH','CreateActionSequenceTargets','displayCurrentState','YkkWg','Style','setMoveEasingType','FmaJS','Game_Action_setGuard','requestPointAnimation','VisuMZ_1_MainMenuCore','guard','ActSeq_BattleLog_UI','Game_Temp_requestAnimation','isPreviousSceneBattleTransitionable','VisuMZ_2_BattleSystemCTB','DTB','MP_Rate','QBAjV','HpGaugeOffsetX','setupFont','JSON','AutoMeleeAoE','isMeleeSingleTargetAction','isSceneBattle','whGMt','return\x200','HP_Flat','noSimilarSTypes','zlyzy','ActSeq_Impact_ShockwavePoint','_displayBattleCoreTransitionErrorMsg','victory','setBattleCameraOffset','ACNZe','power','itemEffectAddNormalState','WaitForMovement','prepareCustomActionSequence','_baseTexture','ActSeq_Mechanics_OtbOrder','checkShowHideBattleNotetags','updateFrame','battleback1Name','ActionItemMsg','findTargetSprite','Skill-%1-%2','Frame','Parse_Notetags_TraitObjects','jZpeK','message1','_damageContainer','wOOOh','waitForNewLine','animationShouldMirror','weaponTypes','FrontViewSelect','TaOti','gainHp','performActionMotions','_createClientArea','ActSeq_Mechanics_AddBuffDebuff','isWaiting','revertTpbCachedActor','ThELi','bEOLJ','DualWield','bmSlm','BattleManager_startTurn','WWPXI','isPartyCommandWindowDisabled','ActSeq_Set_TargetActionSet','sortEnemies','Game_Map_encounterList','updatePointAnimations','addPartyCommand','_enemyNameContainer','_growX','turn','ActSeq_Impact_MotionTrailCreate','_activeWeaponSlot','VTwZv','FLcnN','_lastAction','createEmptyBitmap','Scene_Battle_createAllWindows','AS\x20TARGET','CMAeE','isSpinning','DgLee','helpWindowRect','_offsetY','checkShowHideSkillNotetags','wLnyP','AutoMeleeSolo','ajPCT','initialize','Index','moveToStartPositionBattleCore','isAnyoneFloating','wait','isAnyProjectilePresent','Turns','isHiddenSkill','callUpdateHelp','POST-','Sprite_Weapon_loadBitmap','yVPYo','BattleCmdList','regenerateAllBattleCore','ActSeq_Movement_WaitForFloat','LiPcT','Window_BattleEnemy_show','animation','callOptions','performMiss','battleCameraData','isTpbCharged','PostDamageAsUserJS','gZfbL','MANUAL','VisuMZ_2_BattleSystemBTB','updateCancel','_waitMode','TpbActiveChangeEnabled','mainFontSize','Scene_Battle_selectNextCommand','JS\x20BATTLE\x20DEFEAT','resetResultSwitches','FElOW','dataId','DistanceAdjust','loadBattleback1','canAddSkillCommand','dead\x20friends','retreat','isNextScene','_cache','isAnyoneJumping','setHandler','%1StartActionJS','_subject','383609UljoAu','AS\x20USER','skillWindowRect','timeScale','getAttackMotion','ActSeq_Movement_Scale','SceneManager_push','DEF','_targetSkewY','changeBattlerOpacity','showPortraits','_homeY','ElementStatusCore','FdLYX','_targetIndex','nzWhQ','getWtypeIdWithName','createCommandVisibleJS','DamageStyleList','gGKpC','_motionCount','%1Event','damageContainer','allowCollapse','PreEndActionJS','_battlerContainer','onJumpEnd','4244210GHFShm','customDamageFormula','_lastEnemy','JEWhK','VisuMZ_1_ElementStatusCore','_battleCoreNoElement','LacxC','onAngleEnd','isPTB','svBattlerShadowVisible','AdjustRect','type','performAttack','ActSeq_Mechanics_BoostPointsChange','makeSuccess','mpDamageFmt','dVzfQ','lwFnn','StyleName','updateBattlerContainer','AnCSU','Scene_Battle_stop','performCollapse','XlQFQ','BeQdx','YJGqe','createKeyJS','Window_BattleLog_performRecovery','gVAEA','QgrwT','_baseLineStack','dZHsJ','_active','itemLineRect','evalDamageFormula','_currentAngle','lCYNi','tuZwX','applyGlobalCommonEventNotetags','refreshCursor','show','_preemptive','ParseWeaponNotetags','updateOnceParallelInterpreters','Game_Battler_performDamage','HncAr','CpBBT','ActSeq_Mechanics_StbExtraAction','%1EndActionJS','_frontAttachmentSprite','displayItemMessage','ogDWB','StyleOFF','_list','eraseState','drawGauge','performSubstitute','SwitchMissEvade','ARRAYSTR','Scene_Battle_updateStatusWindowPosition','Nksek','flashColor','sliceMin','clearRect','_text','OverallFormulaJS','startJump','ActSeq_BattleLog_WaitForNewLine','motionSpeed','removeChild','replace','xXRFi','Window_BattleLog_performActionEnd','_skillWindow','checkShowHideSwitchNotetags','lXUup','setupMotionBlurImpactFilter','IconStypeMagic','DisablePartyCmd','onRegeneratePlayStateAnimation','_dragonbonesSpriteContainer','_totalValue','EqkYi','tpbCommandFight','ActSeq_Mechanics_VariablePopup','drawItemBackground','battleEnd','isBattleSys','angle','clone','isActing','AkMLu','<CENTER>%1','_createEffectsContainer','PTgfA','HomePosJS','updateEffectsContainer','ShowAddedDebuff','MDeEF','pzziQ','initBattlePortrait','hpAffected','Xerwt','finishActorInput','isMoving','ShowFailure','addedStateObjects','finalizeScale','pyZUn','fnordRemovedStates','targetDistortionSpritePosition','Game_Action_executeDamage','validTargets','cameraOffsetDuration','cyULu','members','JS\x20%1START\x20ACTION','iconWidth','wPUQy','addState','skillItemWindowRectMiddle','IVRiY','status','drawItemImage','Window_PartyCommand_initialize','setCustomDamageFormula','qUkNV','BattleLayout','Game_Action_needsSelection','_backAttachmentSprite','battleCorePreBattleCommonEvent','_growDuration','reverse','launchBattle','join','VPAdN','motionType','skills','skew','Window_BattleLog_displayTpDamage','addDamageSprite','turnOrderChangeOTB','_tempActor','btbll','isCancelled','EscapeFailureJS','iterateBattler','checkAutoCustomActionSequenceNotetagEffect','CepJC','becomeSTBExploited','setupDamagePopup','hOWpn','actorCommandCancelTPB','PopupPosition','PLYwY','tlXpA','onBattleStartBattleCore','alterBreakShield','Sprite_Actor_update','addChildToBack','FaceAway','SgoKM','KdgrQ','applyHardDamageCap','ultQk','HfIIS','stepBack','ActSeq_Animation_ChangeBattlePortrait','addAnimationSpriteToContainer','COMBATLOG','IiLXw','gedQC','WmxHc','PreApplyAsUserJS','forceWeaponAnimation','applyEasing','woaJP','KYpUq','TfxCE','ActSeq_Horror_TVCreate','gainFullActionsPTB','command283','loadSvActor','ShowCounter','_immortal','NewPopupBottom','clearBattlerMotionTrailData','command357','UfVLU','ogFlM','setBattleSkew','arRedRate','terminate','min','Game_Battler_onBattleEnd','Direction','Sprite_Battler_damageOffsetY','drain','apply','BIGmH','ConvertActionSequenceTarget','_callSceneOptions','Sprite_Battler_setHome','getItemDamageAmountTextOriginal','_commonEventIDs','dnGpA','spriteId','CriticalHitRate','isFrameVisible','Game_Interpreter_PluginCommand','Window_Options_addGeneralOptions','_drawTextBody','usePremadeActionSequence','EIofQ','delay','PostEndActionJS','Sprite_StateIcon_updateFrame','ActSeq_Motion_FreezeMotionFrame','thrust','MaxLines','mFkkI','isGuardWaiting','endAction','makeActionList','BattleDefeatJS','CreateCommonEventKeys','_forceAction','ActSeq_Impact_ColorBreak','setupWeaponAnimation','alterCost','iconText','MINsT','autoBattleStyle','AvgBg','commandStyle','chant','playOnceParallelInterpreter','isMVAnimation','_enemySprites','noise','applyItem','_borderPortraitTargetX','restore','Window_BattleLog_displayMpDamage','Mechanics','isForOpponentBattleCore','_battleCoreForcedElements','isEscapeCommandEnabled','HitRate','ActSeq_Movement_FaceTarget','updateShadowVisibility','forceSelect','tQDAf','WEAPON\x20SWAP','PostDamageJS','bgType','KcfMc','some','addSkillTypeCommand','extraPositionX','\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20arguments[1];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20obj\x20=\x20arguments[2];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20value\x20=\x20arguments[3]\x20||\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20originalValue\x20=\x20value;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Constants\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20action\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this\x20:\x20user.currentAction();\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20attacker\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20defender\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20healer\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20receiver\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20actor\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20currentClass\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20skill\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this.item()\x20:\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20item\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this.item()\x20:\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20weapon\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20armor\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20enemy\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20state\x20=\x20obj;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Create\x20Compatibility\x20Variables\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20origin\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(Imported.VisuMZ_1_SkillsStatesCore\x20&&\x20$dataStates.includes(obj))\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20origin\x20=\x20target.getStateOrigin(obj.id);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20NaN\x20Check\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(isNaN(value)){\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27NaN\x20value\x20created\x20by\x20%2\x27.format(\x27\x27,obj.name));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27Restoring\x20value\x20to\x20%2\x27.format(\x27\x27,originalValue));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20value\x20=\x20originalValue;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20value;\x0a\x20\x20\x20\x20\x20\x20\x20\x20','ActionAnimation','setText','addedDebuffs','ARRAYFUNC','OcdzW','putActiveBattlerOnTop','_angleWholeDuration','fOilV','_targetGrowY','CommandAddAutoBattle','NKGUb','Window_ItemList_maxCols','CirZR','createDistortionSprite','dPavD','unchanged','actorId','adjustFlippedBattlefield','battleAnimation','alterChange','_enemies','_actorWindow','ArRedRate','contentsOpacity','_pattern','ActSeq_Horror_TVRemove','BattleManager_updatePhase','removeState','NiqXD','autoSelectLastSelected','mlCLz','eqaUp','tANls','Window_ActorCommand_setup','Game_Action_applyGlobal','Fyyfw','ActSeq_Movement_WaitForJump','IXRni','isForFriend','removeAnimation','MpGaugeOffsetX','StyleON','displayActionResults','VkeFi','Window_BattleLog_performCollapse','isCustomActionSequence','start','adjustPosition_ScaleToFit','XPActorDefaultHeight','cTMjE','Scene_Map_launchBattle','isForFriendBattleCore','updateSkew','SGbRE','updateAngleCalculations','Game_Action_apply','adjustPosition_ScaleUp','Point','getItemDamageAmountLabelOriginal','PostStartBattleJS','NameAttachStateIcon','ConvertCount','udtYS','createHpGaugeSprite','drawItemStatusXPStyle','hhVNY','AnchorY','setupMotion','pgcba','dimColor1','_enemyWindow','Strength','DADyc','_forcing','drawItemStyleIconText','ActSeq_Element_AddElements','TP_Rate','YMyoi','_flashColor','optDisplayTp','_armorPenetration','ileds','softDamageCap','WkmVF','needsSelection','HrkMN','xLfVs','ActSeq_Element_ForceElements','_stateSprite','itemWindowRect','isTpbMainPhase','getInputButtonString','_padding','BattleManager_selectNextCommand','svBattlerAnchorY','setBattleCameraPoint','startMove','ZALSh','battleDisplayText','Pre','updateCustomActionSequence','forceEscapeSprite','windowAreaHeight','iconHeight','regionId','removedStateObjects','VariableDmg','uYyNo','ZpMjT','bopBV','createEffectActionSet','obpDN','hflWw','updateCallMenu','buffRemove','ext','_floatHeight','_surprise','ActSeq_Mechanics_Collapse','makeTargetSelectionMoreVisible','ActSeq_Mechanics_FtbAction','bind','Nhinh','ActSeq_Motion_WaitMotionFrame','createShadowSprite','mUgrS','makeDeepCopy','AutoBattleRect','MotionFrameWait','MesDb','vqioL','PortraitScaleBorderStyle','clearOnceParallelInterpreters','battleSkew','setHorrorEffectSettings','_growY','opacityStart','JS\x20%1REGENERATE','ActSeq_Movement_Jump','addGeneralOptions','HelpFight','AutoNotetag','Game_Battler_clearDamagePopup','WElOZ','ktNav','BattleManager_onEscapeSuccess','ActSeq_Animation_AttackAnimation','glitch','updateSpin','Game_Map_battleback2Name','createDamageContainer','damageRate','ActSeq_BattleLog_Refresh','Game_BattlerBase_isStateResist','pCndx','Game_Map_setupBattleback','targetSpritePosition','stateRate','Variable','Sprite_Enemy_initVisibility','KmUhc','ipkcX','PreApplyJS','AllowRandomSpeed','selectNextCommandTpb','refreshActorPortrait','format','createBattleFieldContainer','_cursorSprite','Skills','Window_BattleLog_performCounter','_opacityDuration','BattleVictoryJS','Game_Action_isForOpponent','onEnemyCancel','makeTargetSprites','JcChh','479080ORJUwX','randomTargets','Occsj','MfOPV','Game_BattlerBase_die','_phase','addNewState','CyLxj','tpbActorSwitchConditionsMet','#ffffff','createStateSprite','command301','ffOtM','BARE\x20HANDS','getAttackWeaponAnimationId','CheckMapBattleEventValid','process_VisuMZ_BattleCore_BaseTroops','ArPenRate','statusText','WZdaJ','filters','NCQus','Spriteset_Battle_updateActors','AutoBattleBgType','startTurn','EUHMx','push','updateCollapse','ScaleToFit','_cancelButton','FFpYW','Game_Action_isForFriend','Psyoj','BattleManager_processDefeat','battleGrow','damageFlat','drawItemStatusListStyle','Mftns','OvApy','process_VisuMZ_BattleCore_Failsafes','effect','message4','BindCommonEventKeysForObj','BdrUp','setupTextPopup','performActionStart','process_VisuMZ_BattleCore_CommonEventKeys','isActiveTpb','makeHpDamageText','ShowCritical','Game_Troop_expTotal','commandNameWindowDrawBackground','QGgOf','AGI','ShowActorGauge','qoecG','YkEJB','BattleLog','displayTpDamage','fittingHeight','updateEffectContainers','allowRandomSpeed','casting','setupActionSet','addSingleSkillCommands','makeDamageValue','EPdrG','WaitForCamera','Game_BattlerBase_eraseState','VisuMZ_2_PartySystem','string','Njeoz','PrioritySortActors','isAnyoneSpinning','_back2Sprite','partyCommandWindowRectDefaultStyle','updateStateIconSprite','setBattlerFacePoint','getFullActionsPTB','HkDsE','changeAtbChargeTime','Game_Interpreter_terminate','LKVzH','svAnchorY','createBorderStylePortraitSprite','alterType','drawActorFace','Window_ActorCommand_initialize','CmdIconOptions','updateFloat','RvPIn','Game_Enemy_setup','_updateFilterArea','Scene_Battle_logWindowRect','VMsCQ','battleUIOffsetY','undecided','parse','getSkillTypes','gIeAt','ActSeq_Mechanics_SwapWeapon','Sprite_Actor_setActorHome','isRightInputMode','_branch','cQZxx','performDamage','BattleManager_inputtingAction','clear','TgtzX','SSNOj','forceAction','isBreakStunned','VariableHeal','ShowReflect','process_VisuMZ_BattleCore_Notetags','boxWidth','fillRect','IconStypeNorm','Text','ActSeq_ChangeAngle','loop','\x5cI[%1]%2','ArPenFlat','Sprite_Battler_updatePosition','Game_BattlerBase_addNewState','occasion','ShowHide','center','_spriteset','MotionType','makeActionOrders','performCounter','FlinchDistanceY','isItem','onGrowEnd','NameOffsetX','moveToStartPosition','commandFight','switchToWeaponType','isOpponent','startBattle','user','isClicked','commandNameWindowDrawText','loadBattleback2','VisuMZ_3_WeaknessDisplay','BattleLogRectJS','axilQ','currentClass','_opacityWholeDuration','weaponImageId','jHHNm','isFTB','getChildIndex','displayBuffs','Damage','svBattlerName','max','ActSeq_Camera_Offset','createBattleUIOffsetY','SkillItemMiddleLayout','_jumpHeight','LUK','isOptionsCommandAdded','JS\x20%1START\x20TURN','isOTB','updateForceAction','battleSpin','partyCommandWindowRect','note','Destination','startGrow','StartName','FKjel','isMeleeMultiTargetAction','_requestRefresh','StepDuration','Scene_Battle_startActorCommandSelection','splice','MXtwO','drawSkillCost','moveBattlerDistance','visibilityState','nHKTC','isAutoBattleCommandAdded','processBattleCoreJS','removeImmortal','yhDJd','ShowFacesListStyle','ActSeq_Mechanics_StbRemoveExcessActions','STwMq','_weaponSprite','isGuard','_lines','TuqfZ','addOnceParallelInterpreter','VJCep','canBattlerMove','UNTITLED','addItemCommand','VdZHl','createAllWindows','Formula','updateStyleOpacity','showEnemyAttackAnimation','isStateResist','canAlterActionCostPTB','Name','value1','TpGaugeOffsetX','dead\x20opponents','displayChangedStates','onActorOk','alive\x20battlers\x20not\x20user','clfaD','FgDyE','drawIcon','actorCommandWindowRect','refreshBattlerMotions','NsHJS','performTpbActiveCheckSwitch','selectNextActor','AnchorX','qMjZd','kzLEO','createDigits','displayAction','_targets','gTpkZ','Game_Battler_regenerateAll','_skewY','_skillIDs','isCTB','_wtypeIDs','autoBattleStart','ActSeq_Mechanics_BreakShieldReset','onDatabaseLoaded','ActSeq_Movement_WaitForScale','ResetFocus','setActorHome','_battleCoreAddedElements','ActSeq_DB_DragonbonesTimeScale','LaUBl','%1EndBattleJS','ActSeq_Motion_ClearFreezeFrame','logActionList','Game_Interpreter_updateWaitMode','alive\x20friends','makeAutoBattleActions','Armor-%1-%2','setBattlerFlip','StatusWindowSkinFilename','DamageType%1','SvMotionIdleMass-%1-%2','_helpWindow','createDamageSprite','rmUgq','ChargeRate','CmdIconFight','_battleLayoutStyle','partyCommandWindowRectBorderStyle','autoSelectPriority','fHdju','ActSeq_Camera_Reset','default','statusWindowRectDefaultStyle','isBattleMember','resizeWindowBorderStyle','kpFKz','DefaultSoftScaler','_commonEventQueue','HelpSkillType','ActSeq_Angle_Reset','DigitGroupingDamageSprites','logWindowRect','displayHpDamage','AdamS','bxzFY','WaitCount2','Window_BattleStatus_initialize','pop','updatePhase','createEnemies','ActSeq_Zoom_Scale','_enemy','eyaPU','BoostPoints','_baseX','BattleManager_onEncounter','\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20skill\x20=\x20arguments[1];\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20let\x20visible\x20=\x20true;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20return\x20visible;\x0a\x20\x20\x20\x20','dQAHM','yGSsd','weapons','ActSeq_Mechanics_WaitForEffect','ActSeq_DB_DragonbonesMotionAni','STR','itemTextAlign','isConfused','visible','yLQQX','YTAoc','\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20let\x20targets\x20=\x20arguments[1];\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20return\x20targets\x20||\x20[];\x0a\x20\x20\x20\x20','gaugeLineHeight','onSelectAction','startInput','mainSprite','_shake','ActSeq_Mechanics_BtbGain','open','qqLpX','hzPxn','Class-%1-%2','XcECZ','alignBattleCoreDamageSprite','displayType','skill','onTurnEnd','current\x20target','EscapeSuccessJS','adjustPosition','ActionCenteredName','CheckSkillCommandShowSwitches','fFBUP','_item','Game_BattlerBase_refresh','StateIconOffsetX','JS\x20BATTLE\x20VICTORY','qoVda','PreStartBattleJS','LwDmF','ActSeq_Impact_MotionBlurScreen','createString','startDamagePopup','motionIdle','qmsAC','Sprite_Battler_updateMain','clearBattleCoreData','Gupre','ActSeq_Impact_MotionTrailRemove','battleCamera','setGuard','Scene_Battle_createHelpWindow','trkAa','vRNbl','wWral','getColor','#%1','surprise','Bzjhq','Scene_Battle_onEnemyCancel','float','Game_Map_battleback1Name','VYOBr','rfRyk','VdnSf','isFightCommandEnabled','Sprite_Battleback_adjustPosition','Game_Troop_setup','isCommandEnabled','loadEnemy','preparePartyRefresh','rowSpacing','PreDamageAsUserJS','drawItemStatus','processBorderActor','vbBaf','command339','isDuringNonLoopingMotion','zTGOz','battleCommandName','_cursorArea','REGuI','Aqvyr','createPartyCommandWindow','collapse','WaitForProjectile','_forcedBattleLayout','EaLwM','getStypeIdWithName','CokOn','JhVas','ParseClassNotetags','_cacheTextWidth','WaitCount1','sliceMax','mhp','startMotion','IdYjZ','checkCacheKey','ActionCount','onBattleEnd','hasSkill','sleep','setCursorRect','FVIir','encounterList','NameAlwaysSelectOnly','worldTransform','Game_Battler_clearMotion','performCastAnimation','BattleManager_makeActionOrders','_motionSpeed','AutoBattleOK','isSceneChanging','isBuffAffected','PostApplyAsUserJS','changeWeather','nSZPV','gWTjm','setHue','_distortionSprite','ctsfP','addLoadListener','GQafX','cancelTargetSelectionVisibility','CalcEscapeRatioJS','ekTeL','DistanceY','onOpacityEnd','PostApplyAsTargetJS','setupShockwaveImpactFilter','vOOnH','Scene_Battle_onActorCancel','guardSkillId','extraPositionScaledY','getItemDamageAmountLabelBattleCore','gzjSX','XlLJW','getDamageStyle','_actorSprites','CVIdv','updateStateSpriteBattleCore','UQzRq','uHage','IconSet','VyilJ','Window_BattleLog_refresh','Game_Action_makeTargets','startEnemySelection','qrYut','updateWaitMode','gZiCs','evalDamageFormulaBattleCore','vPdeO','process_VisuMZ_BattleCore_Action_Notetags','isSkillItemWindowsMiddle','createInnerPortrait','initBattleCore','addActor','Scene_Battle_helpWindowRect','SkillItemBorderCols','placeStateIcon','PopupOffsetX','command119','ActSeq_Mechanics_HpMpTp','makeSpeed','drawItemStyleIcon','ArRedFlat','addShowHpGaugeCommand','updateBattlebackBitmap2','_iconIndex','isDying','partyCommandWindowRectXPStyle','parseForcedGameTroopSettingsBattleCore','sKDCZ','_angleEasing','ActSeq_Movement_HomeMoveBy','registerCommand','front\x20base','initVisibility','applyTargetFilters','addCommand','loadWindowskin','onBattleEndBattleCore','attackAnimationId1','CommonEventID','setBackgroundType','updateScale','maxCols','performMagicEvasion','ATTACK','AlphaFilter','updateHpGaugePosition','isMagical','Battleback','xljYT','BcEnv','createMiss','ActSeq_Mechanics_AnalyzeWeakness','Sprite_Battler_isMoving','HP_Rate','battleCoreTpbMainPhase','_animationSprites','hue','Game_Action_itemEffectAddNormalState','performRecovery','_logWindow','ALL\x20SKILLS','YCezM','updateAttachmentSprites','FEkdo','isDeathStateAffected','StatusWindowSelectableBackHide','pattern','Scene_Battle_updateBattleProcess','updateFlip','ActSeq_Animation_WaitForAnimation','_enemyID','traitSet','setupBattleCoreData','VisuMZ_0_CoreEngine','numTargets','angleDuration','SlotID','HelpAutoBattle','BattleCore','ActionEnd','battlerShadowScaleY','VisuMZ_2_BattleSystemSTB','ActSeq_Animation_PlayAtCoordinate','dying','innerWidth','updateBorderStyle','head','AnimationID','dead','ShowAddedState','processVictory','OffsetAdjust','isAppeared','hEgHt','canMove','applyBattleCoreJS','Scene_Battle_initialize','dakVC','zoomDuration','HalfActions','_createDamageContainer','frontviewSpriteY','useItem','updateTargetPosition','lineHeight','isFloating','getNextSubjectFromPool','process_VisuMZ_BattleCore_jsFunctions','edoNo','updateShadowScale','isJumping','PreStartTurnJS','list','DefaultSoftCap','Fbvmg','getItemDamageAmountTextBattleCore','critical','lMpvB','_targetGrowX','isUndecided','BattleEndEvent','PostDamageAsTargetJS','Enemy','%1Apply%2JS','_angleRevertOnFinish','AsTarget','Scale','mainSpriteWidth','addTextToCombatLog','_isBattlerFlipped','itVGr','spell','text','maxItems','setupBattleback','ipCbq','commandNameWindowCenter','onAllActionsEnd','applyGlobal','makeData','displayChangedBuffs','displayReflection','pointX','displayCritical','zDWds','_checkOn','addAutoBattleCommands','applyArmorModifiers','RhcOW','ApplyImmortal','turnCount','displayStartMessages','NCLwx','Reveal','VisuMZ_3_SideviewBattleUI','actionSplicePoint','processAnimationRequests','JZaUx','Scene_Battle_createActorCommandWindow','_motion','MeleeDistance','DamageStyles','removeOnceParallelInterpreter','_uiContainer','refresh','ParseStateNotetags','missed','isActor','ESjKR','commandAutoBattle','SMDVT','Game_BattlerBase_canAttack','_stateIconSprite','_skewDuration','Parse_Notetags_Targets','wtypeId','displayBattleCoreTransitionErrorMsg','oxqwl','createAnimationContainer','getBattlePortraitOffsetY','battleZoom','Game_Action_isForRandom','onEncounterBattleCore','scope','repositionEnemiesByResolution','_weaponImageId','ujMUB','_damages','CounterPlayback','swing','canGuardBattleCore','visualHpGauge','Game_Interpreter_command283','XPActorCommandLines','addCustomCommands','performEvasion','slice','attachSpritesToDistortionSprite','RequiresDefeat','faceRect','createActionSequenceProjectile','Window_BattleLog_performMiss','iPukX','commandName','skillTypes','Scene_Battle_terminate','Interrupt','isSkewing','updateStateSprite','cameraClamp','Sprite_Enemy_createStateIconSprite','Game_Battler_onBattleStart','EscapeSuccess','startSkew','createContents','performWeaponAnimation','getLastPluginCommandInterpreter','okTargetSelectionVisibility','CriticalDuration','STYPES','DisplayAction','Scene_Battle_startActorSelection','_angleDuration','onMoveEnd','BattleManager_isTpbMainPhase','EGjlO','StatusWindowSkinHide','save','not\x20focus','_floatDuration','MotionAni','ShowSubstitute','applyAngleChange','OffsetY','Item-%1-%2','aeunh','isForAll','Game_Enemy_transform','jump','PreDamage%1JS','dYynm','animationId','commandEscape','Debuffs','front\x20center','Sprite_Battler_setBattler','attackStates','PostEndBattleJS','ActSeq_Zoom_Reset','_windowLayer','Game_Action_numRepeats','enemyId','swapEnemyIDs','canEscape','_battler','_action','JUGcz','FQWlg','mpHealingFmt','transform','StepDistanceY','width','itemHeight','Wave','DNMQn','startTpbTurn','CriticalHitFlat','snYJc','_battleCoreBattleResumeAfter','textColor','CNPod','YJQwH','ForceExploiter','createEnemyNames','createLowerLayer','priority','ActSeq_Animation_CastAnimation','WSQbT','hBeeR','yRzaz','commandStyleCheck','applyDamageCaps','GZNId','uiInputPosition','Window_BattleEnemy_initialize','Game_Battler_makeSpeed','PreStartActionJS','State-%1-%2','WaitForSkew','%1RegenerateJS','performAttackSlot','PreDamageAsTargetJS','CopyCombatLog','fnshK','ParseActorNotetags','autoMeleeMultiTargetActionSet','CJzCn','updateAction','SdcyM','xgtgG','SvBattlerMass-%1-%2','addDebuff','NNHoq','_jumpDuration','ActSeq_Set_FinishAction','_baseY','SkillItemStandardCols','nQizG','wqySm','getConfigValue','isNextSceneBattleTransitionable','base','ActSeq_Element_NullElements','criticalHitFlat','attack','friendsUnit','isAlwaysVisible','changeInputWindow','clearForcedGameTroopSettingsBattleCore','filterArea','ActSeq_Mechanics_Multipliers','ActSeq_Impact_ZoomBlurTargetCenter','ZatwE','update','isShownOnBattlePortrait','REGDJ','_floatEasing','callOkHandler','battleStatusWindowAnimationContainer','MAT','attackSkillId','name','vSYvM','sTwhU','jNRCR','abnormal','startActorCommandSelection','addChild','bitmapWidth','PortraitScale','isTpb','updateStatusWindowPosition','repeats','GwRxF','Scene_Battle_commandFight','parent','call','currentExt','_svBattlerData','IftkP','FFetx','removeBuffsAuto','statusWindowRectBorderStyle','Linear','ZuzNC','popupDamage','MpGaugeOffsetY','processEscape','xpAOV','ActSeq_Weapon_ClearActiveWeapon','YKtci','linkSprite','IpccD','effects','PostStartActionJS','activate','StartTurnShow','maxLines','Window_BattleLog_popupDamage','Mbdld','yyFFQ','process_VisuMZ_BattleCore_DamageStyles','createAutoBattleWindow','svShadow','Scene_Map_initialize','startFloat','yJGQk','CommandVisible','_floatWholeDuration','displayMpDamage','Scene_Options','addAutoBattleCommand','AllowCollapse','FullActions','setBattlePortrait','CXbVF','process_VisuMZ_BattleCore_CreateRegExp','VisuMZ_4_BreakShields','reduce','mmp','playEnemyDamage','createTroopNote','performJump','VisuMZ_3_ActSeqProjectiles','createHelpWindowBattleCore','pushBaseLine','addFightCommand','_skewWholeDuration','_actorCommandWindow','needsSelectionBattleCore','DbEri','alive\x20enemies','_forcedHomeX','Mkjlv','boxHeight','DgKsf','updateWeather','createBattleUIOffsetX','icon','_multipliers','ActSeq_Mechanics_DamagePopup','isSpriteVisible','expTotal','ActiveTpbOptionsMessage','makeBattleCommand','Window_BattleLog_popBaseLine','isLearnedSkill','CTdJi','waitForEffect','HelpOptions','WeaponTypeID','processPostBattleCommonEvents','changeTurnOrderByCTB','ghIVD','Dkbvp','updateLink','Buffs','placeActorName','_borderPortraitDuration','isActionSelectionValid','alive\x20opponents\x20not\x20target','_animationContainer','setImmortal','ShowCosts','makeCommandList','_homeWholeDuration','lineRect','Sprite_Actor_createStateSprite','Window_BattleStatus_drawItemImage','QuQpS','showNormalAnimation','gainTp','MessageWait','createEnemyNameContainer','constructor','SbIMZ','setupBattleCore','rjTej','_currentActor','createStateIconSprite','deadMembers','_effectsContainer','maxBattleMembers','battleProjectiles','isBypassDamageCap','_stypeIDs','lztZQ','_targetHomeX','_weather','TGXtX','addText','setupZoomBlurImpactFilter','criticalDmgFlat','VEeEY','basicGaugesY','ToGXC','svBattlerAnchorX','ZCncb','Game_Action_evalDamageFormula','active','ActSeq_Impact_ZoomBlurPoint','VBrMB','processRandomizedData','ActSeq_ChangeSkew','Sprite_Battler_damageOffsetX','227970aYmJoe','RegExp','PopupShiftX','PostApply%1JS','createAttachedSprites','_damagePopupArray','snapForBackground','displayRemovedStates','actorCommandSingleSkill','AutoBattle','ParseArmorNotetags','getDualWieldTimes','waitForOpacity','needsActorInputCancel','clearBattleRefreshRequest','zMKDa','forceMotion','Height','_actor','cancelActorInput','randomInt','performReflection','opacity','QqbUv','onSkewEnd','regenerateAll','_emptyBitmap','WaitForAngle','alive\x20opponents','_actionBattlers','hSuyj','fVade','PrioritySortActive','resetFontSettings','KBBdQ','SkewX','createSeparateDamagePopups','ActSeq_Zoom_WaitForZoom','anchor','ZwVeY','ARRAYSTRUCT','isCertainHit','prototype','sfWZe','Intensity','inHomePosition','isAnimationShownOnBattlePortrait','ActSeq_Target_CurrentIndex','VisuMZ_2_BattleSystemETB','ShowTpDmg','Scene_Battle_startEnemySelection','rbUDT','LAJnG','bUJbH','VisuMZ_2_BattleSystemPTB','onEncounter','_speed','makeTargets','getMenuImage','reserveCommonEvent','drawLineText','createUIContainer','isCharging','isOptionsCommandEnabled','alphabetic','unshift','BattleManager_initMembers','getDefeatedEnemies','Sprite_Battler_update','WaitForJump','initElementStatusCore','PARTY','_dimmerSprite','Actor-%1-%2','Qgnbv','endBattle','qatKN','canAttack','isHidden','VjdkU','_effectDuration','CriticalHitRateJS','Sprite_Actor_updateFrame','physical','callNextMethod','FtsjB','Scene_Battle_itemWindowRect','dead\x20actors','evade','ReflectPlayback','updateMain','NLQbi','CmdStyle','itemCri','SqXMT','actionBattleCoreJS','processRefresh','height','_jumpWholeDuration','_targetHomeY','ieunF','TpGaugeOffsetY','createTargetsJS','NameAlwaysVisible','value','Targets1','skillItemWindowRectBorderStyle','_visualHpGauge_JustDied','XXrIw','Dnzvl','_forcedHomeY','dySDM','VisuMZ_3_BoostAction','WvbQV','uIOTf','ESCAPE','die','<CUSTOM\x20ACTION\x20SEQUENCE>','ActSeq_Movement_WaitForMovement','uYEcz','updatePadding','OAYoi','vTvUi','isAlive','Parse_Notetags_Action','battleAngle','bitmapHeight','addBattleCoreAutoBattleStartupCommand','BattleManager_startAction','requestRefresh','_homeX','removeHorrorEffect','AdJCb','notFocusValid','createBattleFieldBattleCore','clearHorrorEffects','blockWidth','EasingType','battler','Window_Options_statusText','Sprite_Actor_updateBitmap','lkAuy','enemy','Angle','_preBattleCommonEvent','oHTkq','_itemWindow','opponentsUnit','\x20to\x20%1\x20midbattle.','isDamagePopupRequested','compareBattlerSprites','AUTO\x20BATTLE','_shadowScaleY','DRbVu','LoRAc','drawEnemyName','initMembersBattleCore','getTraitSetKeys','wXkxD','invokeAction','setHelpWindow','applyResultSwitches','wlWiR','textBaseline','PostStartTurnJS','ActSeq_Mechanics_PtbFullHalfAction','battleMove','XaTTI','placeGauge','anchorY','isForRandomBattleCore','eKRxH','updateOpacity','wholeActionSet','ActSeq_Camera_Clamp','_createCursorSprite','currentAction','setSvBattlerSprite','_targetFloatHeight','battleback2Name','RSARF','UbYsn','targetObjects','DPudX','ReflectAnimation','_tempBattler','setActiveWeaponSlot','isGrowing','damageStyle','nEunE','formula','popBaseLine','magicSkills','ActSeq_Mechanics_Immortal','Window_SkillList_maxCols','Sprite_SvEnemy','Window_BattleLog_performReflection','remove','Spriteset_Battle_createBattleField','TextColor','setFrame','concat','FFmTa','acxwU','extraPositionY','isEffecting','createBattleField','floor','isDead','_actionInputIndex','Sprite_Enemy_update','onEscapeSuccess','prepareBorderActor','BattleManager_cancelActorInput','tcOcm','ScaleUp','displayMiss','ActSeq_Mechanics_AddState','uiMenuStyle','tzvuM','FUNC','clearActiveWeaponSlot','CriticalDmgRate','isBusy','requestAnimation','_effectType','CombatLogIcon','Scene_Battle_createPartyCommandWindow','LbNmZ','ulbwm','_skewX','ClearBattleLog','battlerShadowScaleX','showAnimation'];_0x4175=function(){return _0x430df7;};return _0x4175();}function Sprite_SvEnemy(){this['initialize'](...arguments);}Sprite_SvEnemy[_0xa8cad7(0xa60)]=Object[_0xa8cad7(0x423)](Sprite_Actor['prototype']),Sprite_SvEnemy[_0xa8cad7(0xa60)]['constructor']=Sprite_SvEnemy,Sprite_SvEnemy['prototype']['initialize']=function(_0xb0d0c4){const _0x55243a=_0xa8cad7;Sprite_Actor[_0x55243a(0xa60)][_0x55243a(0x4a7)]['call'](this,_0xb0d0c4),this[_0x55243a(0x122)]['x']=-0x1,this[_0x55243a(0x64d)][_0x55243a(0x122)]['x']=-0x1;},Sprite_SvEnemy[_0xa8cad7(0xa60)][_0xa8cad7(0x671)]=function(){},Sprite_SvEnemy[_0xa8cad7(0xa60)][_0xa8cad7(0x72e)]=function(){},Sprite_SvEnemy[_0xa8cad7(0xa60)]['setActorHome']=function(_0x1aa861){},Sprite_SvEnemy[_0xa8cad7(0xa60)][_0xa8cad7(0xb51)]=function(){},Sprite_SvEnemy[_0xa8cad7(0xa60)][_0xa8cad7(0x343)]=function(){},Sprite_SvEnemy[_0xa8cad7(0xa60)][_0xa8cad7(0x92b)]=function(){const _0x133bce=_0xa8cad7;this[_0x133bce(0x64d)][_0x133bce(0x7d0)]=![];},Sprite_SvEnemy['prototype'][_0xa8cad7(0x3e1)]=function(){const _0x1cc869=_0xa8cad7;Sprite_Battler[_0x1cc869(0xa60)][_0x1cc869(0x3e1)]['call'](this);const _0x20a232=this['_actor'][_0x1cc869(0x742)]();this[_0x1cc869(0x1ba)]!==_0x20a232&&(_0x1cc869(0x2f5)!==_0x1cc869(0x6a5)?(this[_0x1cc869(0x1ba)]=_0x20a232,this[_0x1cc869(0xb80)]['bitmap']=ImageManager[_0x1cc869(0x5a6)](_0x20a232)):(this[_0x1cc869(0xa25)][_0x1cc869(0x4fb)]=_0x5d8281['weatherType'](),this[_0x1cc869(0xa25)][_0x1cc869(0x46a)]=_0xefb231['weatherPower']()));if(this[_0x1cc869(0xb80)]&&this[_0x1cc869(0xb80)]['bitmap']&&this[_0x1cc869(0x959)]){if(_0x1cc869(0x401)==='uAVjo')this[_0x1cc869(0xb80)][_0x1cc869(0x379)][_0x1cc869(0xb20)]!==this[_0x1cc869(0x959)][_0x1cc869(0x2ea)]()&&(this['_mainSprite']['bitmap'][_0x1cc869(0xb20)]=this[_0x1cc869(0x959)][_0x1cc869(0x2ea)]());else{if(this['_currentActor']['selectNextCommand']())return;this[_0x1cc869(0x557)](),this[_0x1cc869(0x414)](),!this[_0x1cc869(0x4d4)]&&!this[_0x1cc869(0xa1b)]&&_0x423799['_scene'][_0x1cc869(0x205)]();}}},Sprite_SvEnemy[_0xa8cad7(0xa60)][_0xa8cad7(0x4ce)]=function(){},Sprite_SvEnemy['prototype'][_0xa8cad7(0x655)]=function(_0x2245bd,_0x5b65bd,_0x2fb6d8){const _0xba558c=_0xa8cad7;if(this[_0xba558c(0x9b4)])this['parent'][_0xba558c(0x655)](_0x2245bd,_0x5b65bd,_0x2fb6d8);},Sprite_SvEnemy[_0xa8cad7(0xa60)][_0xa8cad7(0x117)]=function(){const _0x2c107e=_0xa8cad7,_0x55515e=this[_0x2c107e(0xa48)];if(_0x55515e){if(_0x2c107e(0x6de)!=='YkEJB'){const _0x29fc92=this[_0x2c107e(0xac0)]();_0x29fc92&&_0x29fc92[_0x2c107e(0xb33)]();}else{const _0x26792c=_0x55515e[_0x2c107e(0x2b9)]();if(_0x55515e[_0x2c107e(0x3f1)]()||_0x55515e[_0x2c107e(0x54a)]())this['startMotion']('walk');else{if(_0x26792c===0x3)this[_0x2c107e(0x828)](_0x2c107e(0x8b3));else{if(_0x26792c===0x2){if(_0x2c107e(0x26d)==='GggcV')this[_0x2c107e(0x828)](_0x2c107e(0x82e));else{var _0x4c8555,_0x2b9806,_0x20fed1;for(_0x20fed1=_0x5c85b1['length']-0x1;_0x20fed1>0x0;_0x20fed1--){_0x4c8555=_0x15546f[_0x2c107e(0xb05)](_0x31e072[_0x2c107e(0x2c5)]()*(_0x20fed1+0x1)),_0x2b9806=_0x502a00[_0x20fed1],_0x35b474[_0x20fed1]=_0x31c3db[_0x4c8555],_0x5ccfb2[_0x4c8555]=_0x2b9806;}return _0x4584b4;}}else{if(_0x55515e[_0x2c107e(0x3f2)]())_0x2c107e(0xa5d)!==_0x2c107e(0xa5d)?_0x3dde6e+=_0x42b7f2[_0x2c107e(0x565)]:this[_0x2c107e(0x828)](_0x2c107e(0x5db));else{if(_0x55515e['isGuard']()||_0x55515e[_0x2c107e(0x5cd)]())this[_0x2c107e(0x828)]('guard');else{if(_0x26792c===0x1)this[_0x2c107e(0x828)](_0x2c107e(0x9aa));else{if(_0x55515e[_0x2c107e(0x873)]())this['startMotion'](_0x2c107e(0x8ae));else{if(_0x55515e[_0x2c107e(0x8d2)]()){if('hSuyj'!==_0x2c107e(0xa54)){this['_borderPortraitDuration']=0x14,this[_0x2c107e(0x3ac)][_0x2c107e(0x379)]=_0x538f49;_0x19748f[_0x2c107e(0x26b)]['isRightInputMode']()?(this[_0x2c107e(0x3ac)]['x']=0x0,this[_0x2c107e(0x5e1)]=_0x415aca['ceil'](_0x1316a5[_0x2c107e(0x960)]/0x2)):(this[_0x2c107e(0x3ac)]['x']=this['width'],this['_borderPortraitTargetX']=this[_0x2c107e(0x960)]*0x3/0x4);this['_borderPortraitSprite'][_0x2c107e(0xa4c)]=0x0,this[_0x2c107e(0x3ac)]['y']=this['y']+this['height'];const _0x5e4e7a=_0x17ae69[_0x2c107e(0x3e7)]();_0x5e4e7a&&(this[_0x2c107e(0x5e1)]+=_0x5e4e7a['getBattlePortraitOffsetX'](),this['_borderPortraitSprite']['y']+=_0x5e4e7a[_0x2c107e(0x90e)]());}else this[_0x2c107e(0x828)](_0x2c107e(0x18e));}else this['startMotion'](_0x55515e[_0x2c107e(0x418)]()['motionIdle']||_0x2c107e(0x18e));}}}}}}}}}},Sprite_SvEnemy['prototype'][_0xa8cad7(0xa63)]=function(){const _0x435fa8=_0xa8cad7;if(this[_0x435fa8(0x9b4)])return this[_0x435fa8(0x9b4)][_0x435fa8(0x40d)]===0x0&&this['parent'][_0x435fa8(0x4a2)]===0x0;else{if(_0x435fa8(0x132)===_0x435fa8(0x132))return!![];else{let _0x121276=0x0;return this[_0x435fa8(0x959)]&&!this[_0x435fa8(0x959)]['isBattlerGrounded']()&&(_0x121276-=this[_0x435fa8(0x669)],_0x121276-=this[_0x435fa8(0x747)]),_0x121276;}}},Sprite_SvEnemy[_0xa8cad7(0xa60)][_0xa8cad7(0x89f)]=function(){},VisuMZ['BattleCore']['Sprite_Animation_targetSpritePosition']=Sprite_Animation[_0xa8cad7(0xa60)]['targetSpritePosition'],Sprite_Animation[_0xa8cad7(0xa60)][_0xa8cad7(0x691)]=function(_0x961f9f){const _0x399bc7=_0xa8cad7;return _0x961f9f[_0x399bc7(0x840)]?this[_0x399bc7(0x55e)](_0x961f9f):VisuMZ[_0x399bc7(0x8a9)]['Sprite_Animation_targetSpritePosition'][_0x399bc7(0x9b5)](this,_0x961f9f);},Sprite_Animation[_0xa8cad7(0xa60)][_0xa8cad7(0x55e)]=function(_0x1a3649){const _0x1dd286=_0xa8cad7;let _0x2b705a=_0x1a3649['x'],_0xc9db43=_0x1a3649['y'],_0x16bd48=_0x1a3649['height'],_0x5c4d35=_0x1a3649[_0x1dd286(0x840)][_0x1dd286(0x122)]['y'];_0x1a3649['x']=_0x1a3649[_0x1dd286(0x7c5)]+_0x1a3649[_0x1dd286(0x5f3)](),_0x1a3649['y']=_0x1a3649[_0x1dd286(0x98c)]+_0x1a3649['extraPositionY'](),_0x1a3649['height']*=_0x5c4d35;let _0x16eaca=VisuMZ[_0x1dd286(0x8a9)]['Sprite_Animation_targetSpritePosition'][_0x1dd286(0x9b5)](this,_0x1a3649);return _0x1a3649['x']=_0x2b705a,_0x1a3649['y']=_0xc9db43,_0x1a3649[_0x1dd286(0xa97)]=_0x16bd48,_0x16eaca;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x15d)]=Sprite_AnimationMV[_0xa8cad7(0xa60)][_0xa8cad7(0x14e)],Sprite_AnimationMV[_0xa8cad7(0xa60)][_0xa8cad7(0x14e)]=function(){const _0x18366e=_0xa8cad7;VisuMZ[_0x18366e(0x8a9)][_0x18366e(0x15d)][_0x18366e(0x9b5)](this);if(this[_0x18366e(0x31a)][_0x18366e(0x1c3)]===0x3){if(this['x']===0x0)this['x']=Math[_0x18366e(0x2cb)](Graphics[_0x18366e(0x960)]/0x2);if(this['y']===0x0)this['y']=Math[_0x18366e(0x2cb)](Graphics[_0x18366e(0xa97)]/0x2);}},Sprite_Damage['prototype'][_0xa8cad7(0xa19)]=function(_0x13edd1){const _0x441c9a=_0xa8cad7,_0x4de83b=_0x13edd1[_0x441c9a(0x443)]()||_0x13edd1['result']();if(_0x4de83b[_0x441c9a(0x901)]||_0x4de83b[_0x441c9a(0xb8b)]){if(_0x441c9a(0x335)!=='BTRPF'){if(!this[_0x441c9a(0xa48)][_0x441c9a(0x82d)](_0x152b87['id']))return![];}else this[_0x441c9a(0x426)]=0x0,this[_0x441c9a(0x88d)]();}else{if(_0x4de83b[_0x441c9a(0x555)])this[_0x441c9a(0x426)]=_0x4de83b['hpDamage']>=0x0?0x0:0x1,this[_0x441c9a(0x787)](_0x4de83b[_0x441c9a(0x3e5)]);else _0x13edd1[_0x441c9a(0xab1)]()&&_0x4de83b[_0x441c9a(0xb4d)]!==0x0&&(this[_0x441c9a(0x426)]=_0x4de83b['mpDamage']>=0x0?0x2:0x3,this['createDigits'](_0x4de83b[_0x441c9a(0xb4d)]));}_0x4de83b[_0x441c9a(0x8cf)]&&(_0x441c9a(0x9bd)===_0x441c9a(0x9bd)?this[_0x441c9a(0x3c5)]():this[_0x441c9a(0x344)]=_0x11a68[_0x441c9a(0xb2a)](_0x544be6[_0x441c9a(0x7a1)]));},Sprite_Damage[_0xa8cad7(0xa60)][_0xa8cad7(0xb84)]=function(_0x1b83d3){},Sprite_Damage[_0xa8cad7(0xa60)][_0xa8cad7(0x787)]=function(_0x4f0403){const _0x552cfc=_0xa8cad7;let _0x4557d5=this[_0x552cfc(0x7f1)](_0x4f0403);const _0x234def=this[_0x552cfc(0x1ea)](),_0x3f9728=Math[_0x552cfc(0xb05)](_0x234def*0.75);for(let _0x2bb522=0x0;_0x2bb522<_0x4557d5[_0x552cfc(0x19c)];_0x2bb522++){if('uKwKj'!=='pyyTO'){const _0x1b7a0c=this[_0x552cfc(0x2f1)](_0x3f9728,_0x234def);_0x1b7a0c[_0x552cfc(0x379)][_0x552cfc(0x3e4)](_0x4557d5[_0x2bb522],0x0,0x0,_0x3f9728,_0x234def,_0x552cfc(0x725)),_0x1b7a0c['x']=(_0x2bb522-(_0x4557d5[_0x552cfc(0x19c)]-0x1)/0x2)*_0x3f9728,_0x1b7a0c['dy']=-_0x2bb522;}else this['_endBattle']=![],this[_0x552cfc(0xb41)]=_0x4f6df4['autoBattleAtStart'],this[_0x552cfc(0x75f)](_0x552cfc(0x7ee)),_0x249298[_0x552cfc(0x8a9)][_0x552cfc(0x43d)]['call'](this),this['processBattleCoreJS']('PostStartBattleJS');}},Sprite_Damage['prototype'][_0xa8cad7(0x7f1)]=function(_0x159971){const _0x23cc6a=_0xa8cad7;let _0x3041fc=Math[_0x23cc6a(0xb32)](_0x159971)[_0x23cc6a(0x2c2)]();if(this[_0x23cc6a(0x434)]()){if('WmVIh'!==_0x23cc6a(0x661))_0x3041fc=VisuMZ[_0x23cc6a(0x179)](_0x3041fc);else return 0x0;}const _0x4c1892=VisuMZ[_0x23cc6a(0x8a9)][_0x23cc6a(0xb57)][_0x23cc6a(0x741)];let _0x2627a6='',_0x342b71='';switch(this['_colorType']){case 0x0:_0x2627a6=_0x4c1892['hpDamageFmt']||_0x23cc6a(0x324),_0x342b71=TextManager['hp'];if(_0x159971===0x0)_0x2627a6='%1';break;case 0x1:_0x2627a6=_0x4c1892['hpHealingFmt']||_0x23cc6a(0xb3b),_0x342b71=TextManager['hp'];break;case 0x2:_0x2627a6=_0x4c1892[_0x23cc6a(0x4ff)]||'-%1\x20MP',_0x342b71=TextManager['mp'];break;case 0x3:_0x2627a6=_0x4c1892[_0x23cc6a(0x95d)]||'+%1\x20MP',_0x342b71=TextManager['mp'];break;}return _0x2627a6[_0x23cc6a(0x69b)](_0x3041fc,_0x342b71)[_0x23cc6a(0xb45)]();},Sprite_Damage[_0xa8cad7(0xa60)][_0xa8cad7(0x434)]=function(){const _0xce59d5=_0xa8cad7;if(Imported[_0xce59d5(0x8a4)]){if(_0xce59d5(0x841)===_0xce59d5(0x843)){let _0x4a47fe=_0xce59d5(0x206);if(this['checkCacheKey'](_0x4a47fe))return this[_0xce59d5(0x4d0)][_0x4a47fe];return this['_cache'][_0x4a47fe]=this[_0xce59d5(0x9f2)](this['enemy']()),this['_cache'][_0x4a47fe];}else return VisuMZ[_0xce59d5(0x232)][_0xce59d5(0xb57)][_0xce59d5(0x438)][_0xce59d5(0x7b7)];}else{if('bUJbH'===_0xce59d5(0xa6b))return![];else this['cancelActorInput'](),this[_0xce59d5(0xa1b)]=null,this[_0xce59d5(0x362)]=![];}},Sprite_Damage[_0xa8cad7(0xa60)][_0xa8cad7(0x3c5)]=function(){const _0x4dd4bc=_0xa8cad7,_0x59dadf=VisuMZ['BattleCore']['Settings']['Damage'];this['_flashColor']=_0x59dadf[_0x4dd4bc(0x2da)][_0x4dd4bc(0x91f)](0x0),this['_flashDuration']=_0x59dadf[_0x4dd4bc(0x935)];},Sprite_Damage[_0xa8cad7(0xa60)][_0xa8cad7(0x6d2)]=function(_0x39073b,_0x4348c9){const _0x30082e=_0xa8cad7;this['_flashColor']=_0x4348c9[_0x30082e(0x52d)]||[0x0,0x0,0x0,0x0],this[_0x30082e(0x643)]=JsonEx[_0x30082e(0x673)](this[_0x30082e(0x643)]),this[_0x30082e(0x24a)]=_0x4348c9[_0x30082e(0x271)]||0x0;const _0x2a1a6a=this[_0x30082e(0x1ea)](),_0x4404eb=Math[_0x30082e(0xb05)](_0x2a1a6a*0x1e),_0x22c74a=this[_0x30082e(0x2f1)](_0x4404eb,_0x2a1a6a);_0x22c74a['bitmap']['textColor']=ColorManager[_0x30082e(0x7ff)](_0x4348c9[_0x30082e(0x968)]),_0x22c74a[_0x30082e(0x379)][_0x30082e(0x3e4)](_0x39073b,0x0,0x0,_0x4404eb,_0x2a1a6a,_0x30082e(0x725)),_0x22c74a['dy']=0x0;},Sprite_Damage[_0xa8cad7(0xa60)][_0xa8cad7(0x284)]=function(_0x5dd98b,_0x48e986,_0x5efac4){const _0x415a45=_0xa8cad7,_0x192481=Math[_0x415a45(0x743)](this[_0x415a45(0x1ea)](),ImageManager[_0x415a45(0x65c)]),_0x4afaa3=Math[_0x415a45(0xb05)](_0x192481*0x1e),_0x24a790=this['createChildSprite'](_0x4afaa3,_0x192481),_0x566b12=ImageManager[_0x415a45(0x565)]/0x2,_0x38e760=_0x24a790[_0x415a45(0x379)][_0x415a45(0x1ef)](_0x48e986+'\x20');_0x24a790[_0x415a45(0x379)][_0x415a45(0x968)]=ColorManager[_0x415a45(0x7ff)](_0x5efac4[_0x415a45(0x968)]),_0x24a790[_0x415a45(0x379)][_0x415a45(0x3e4)](_0x48e986,_0x566b12,0x0,_0x4afaa3-_0x566b12,_0x192481,_0x415a45(0x725));const _0xa14c9a=Math['round']((_0x192481-ImageManager[_0x415a45(0x65c)])/0x2),_0x4c68ad=_0x4afaa3/0x2-ImageManager[_0x415a45(0x565)]-_0x38e760/0x2+_0x566b12/0x2,_0x2c4b21=ImageManager[_0x415a45(0xb2a)](_0x415a45(0x858)),_0x61c48d=ImageManager['iconWidth'],_0x25532e=ImageManager[_0x415a45(0x65c)],_0x2c34ea=_0x5dd98b%0x10*_0x61c48d,_0x26040a=Math['floor'](_0x5dd98b/0x10)*_0x25532e;_0x24a790[_0x415a45(0x379)][_0x415a45(0x1ec)](_0x2c4b21,_0x2c34ea,_0x26040a,_0x61c48d,_0x25532e,_0x4c68ad,_0xa14c9a),this[_0x415a45(0x643)]=_0x5efac4[_0x415a45(0x52d)]||[0x0,0x0,0x0,0x0],this[_0x415a45(0x643)]=JsonEx[_0x415a45(0x673)](this['_flashColor']),this[_0x415a45(0x24a)]=_0x5efac4['flashDuration']||0x0,_0x24a790['dy']=0x0;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x5c8)]=Sprite_StateIcon[_0xa8cad7(0xa60)][_0xa8cad7(0x471)],Sprite_StateIcon['prototype'][_0xa8cad7(0x471)]=function(){const _0x2763cb=_0xa8cad7;VisuMZ[_0x2763cb(0x8a9)][_0x2763cb(0x5c8)]['call'](this),this[_0x2763cb(0xa4c)]=this[_0x2763cb(0x872)]>0x0?0xff:0x0;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x4b1)]=Sprite_Weapon['prototype'][_0xa8cad7(0x22a)],Sprite_Weapon['prototype']['loadBitmap']=function(){const _0x29bb20=_0xa8cad7;VisuMZ[_0x29bb20(0x8a9)][_0x29bb20(0x4b1)][_0x29bb20(0x9b5)](this),this[_0x29bb20(0x379)]&&(this[_0x29bb20(0x379)]['smooth']=VisuMZ[_0x29bb20(0x8a9)][_0x29bb20(0xb57)][_0x29bb20(0x3d8)][_0x29bb20(0x115)]);};function Sprite_HpGauge(){this['initialize'](...arguments);}Sprite_HpGauge[_0xa8cad7(0xa60)]=Object['create'](Sprite_Gauge[_0xa8cad7(0xa60)]),Sprite_HpGauge[_0xa8cad7(0xa60)][_0xa8cad7(0xa17)]=Sprite_HpGauge,Sprite_HpGauge['prototype']['initialize']=function(){const _0xe81373=_0xa8cad7;Sprite_Gauge[_0xe81373(0xa60)]['initialize'][_0xe81373(0x9b5)](this);},Sprite_HpGauge[_0xa8cad7(0xa60)][_0xa8cad7(0x28e)]=function(){return 0x0;},Sprite_HpGauge[_0xa8cad7(0xa60)][_0xa8cad7(0x329)]=function(){const _0x1b1f71=_0xa8cad7;this[_0x1b1f71(0x379)][_0x1b1f71(0x711)]();const _0x20c364=this['currentValue']();!isNaN(_0x20c364)&&this[_0x1b1f71(0x527)]();};function Sprite_EnemyName(){const _0x50bdf8=_0xa8cad7;this[_0x50bdf8(0x4a7)](...arguments);}Sprite_EnemyName[_0xa8cad7(0xa60)]=Object[_0xa8cad7(0x423)](Sprite_Name[_0xa8cad7(0xa60)]),Sprite_EnemyName[_0xa8cad7(0xa60)][_0xa8cad7(0xa17)]=Sprite_EnemyName,Sprite_EnemyName[_0xa8cad7(0xa60)][_0xa8cad7(0x4a7)]=function(){const _0x598520=_0xa8cad7;Sprite_Name[_0x598520(0xa60)]['initialize']['call'](this),this[_0x598520(0xa3a)]();},Sprite_EnemyName[_0xa8cad7(0xa60)][_0xa8cad7(0x32a)]=function(){const _0x5bb044=_0xa8cad7;Sprite_Name[_0x5bb044(0xa60)][_0x5bb044(0x32a)][_0x5bb044(0x9b5)](this),this['opacity']=0x0,this[_0x5bb044(0x40a)]=null,this[_0x5bb044(0xa5c)]['x']=0.5,this[_0x5bb044(0xa5c)]['y']=0x0;},Sprite_EnemyName[_0xa8cad7(0xa60)][_0xa8cad7(0xa3a)]=function(){const _0x29a428=_0xa8cad7;VisuMZ['BattleCore'][_0x29a428(0xb57)][_0x29a428(0x8d5)]['NameAttachStateIcon']&&(_0x29a428(0xa26)===_0x29a428(0x259)?this['_canLose']=!![]:(this['_stateIconSprite']=new Sprite_StateIcon(),this[_0x29a428(0x9ac)](this[_0x29a428(0x907)])));},Sprite_EnemyName[_0xa8cad7(0xa60)][_0xa8cad7(0x9ad)]=function(){const _0x33838b=_0xa8cad7;return Graphics[_0x33838b(0x719)];},Sprite_EnemyName[_0xa8cad7(0xa60)][_0xa8cad7(0xab4)]=function(){const _0x37e710=_0xa8cad7;return this[_0x37e710(0x1ee)]=this['_lineHeight']||Window_Base[_0x37e710(0xa60)][_0x37e710(0x8c3)]()||0x24,this[_0x37e710(0x1ee)]*0x4;},Sprite_EnemyName[_0xa8cad7(0xa60)][_0xa8cad7(0x1ea)]=function(){const _0x1704b7=_0xa8cad7;return VisuMZ['BattleCore']['Settings'][_0x1704b7(0x8d5)][_0x1704b7(0xb65)]||$gameSystem[_0x1704b7(0x4c4)]();},Sprite_EnemyName['prototype'][_0xa8cad7(0x9c4)]=function(_0x22c696){const _0x52654f=_0xa8cad7;this[_0x52654f(0x40a)]=_0x22c696;},Sprite_EnemyName[_0xa8cad7(0xa60)][_0xa8cad7(0x99e)]=function(){const _0x1bec41=_0xa8cad7;Sprite_Name[_0x1bec41(0xa60)]['update'][_0x1bec41(0x9b5)](this),this[_0x1bec41(0xa04)](),this[_0x1bec41(0x14e)](),this[_0x1bec41(0x199)](),this[_0x1bec41(0xae2)]();},Sprite_EnemyName['prototype']['redraw']=function(){const _0x5e4a71=_0xa8cad7;this[_0x5e4a71(0x824)]=undefined;const _0xd11764=this[_0x5e4a71(0x9a6)](),_0xb4821=this['bitmapWidth'](),_0x12de06=Window_Base[_0x5e4a71(0xa60)][_0x5e4a71(0x8c3)]();this[_0x5e4a71(0x45b)](),this[_0x5e4a71(0x379)][_0x5e4a71(0x711)](),this[_0x5e4a71(0x379)][_0x5e4a71(0x3e4)](_0xd11764,0x0,0x0,_0xb4821,_0x12de06,_0x5e4a71(0x725));},Sprite_EnemyName['prototype'][_0xa8cad7(0xa04)]=function(){const _0x2d76dc=_0xa8cad7;if(!this[_0x2d76dc(0x40a)])return;this[_0x2d76dc(0x959)]!==this[_0x2d76dc(0x40a)][_0x2d76dc(0x959)]&&this['setup'](this['_linkedSprite'][_0x2d76dc(0x959)]);},Sprite_EnemyName[_0xa8cad7(0xa60)][_0xa8cad7(0x14e)]=function(){const _0x3a4596=_0xa8cad7;if(!this[_0x3a4596(0x40a)])return;this[_0x3a4596(0x1ee)]=this[_0x3a4596(0x1ee)]||Window_Base[_0x3a4596(0xa60)]['lineHeight'](),this['x']=this['_linkedSprite']['_baseX'],this['y']=this[_0x3a4596(0x40a)][_0x3a4596(0x98c)]-this[_0x3a4596(0x1ee)]*0.5;const _0xed2731=VisuMZ[_0x3a4596(0x8a9)][_0x3a4596(0xb57)][_0x3a4596(0x8d5)];this['x']+=_0xed2731['NameOffsetX']||0x0,this['y']+=_0xed2731[_0x3a4596(0x177)]||0x0;},Sprite_EnemyName[_0xa8cad7(0xa60)][_0xa8cad7(0x199)]=function(){this['updateStateIconSprite']();},Sprite_EnemyName[_0xa8cad7(0xa60)][_0xa8cad7(0x6f2)]=function(){const _0x579354=_0xa8cad7;if(!this['_stateIconSprite'])return;this[_0x579354(0x959)]!==this[_0x579354(0x907)]['_battler']&&this[_0x579354(0x907)][_0x579354(0xb84)](this[_0x579354(0x959)]);const _0x365019=this[_0x579354(0x12e)]();this['_lineHeight']=this[_0x579354(0x1ee)]||Window_Base[_0x579354(0xa60)][_0x579354(0x8c3)](),this[_0x579354(0x907)]['x']=Math[_0x579354(0x2cb)]((_0x365019+ImageManager['iconWidth'])/0x2)+0x8,this[_0x579354(0x907)]['y']=this[_0x579354(0x1ee)]/0x2;const _0xc4f828=VisuMZ[_0x579354(0x8a9)][_0x579354(0xb57)]['Enemy'];this[_0x579354(0x907)]['x']+=_0xc4f828['AttachStateOffsetX']||0x0,this[_0x579354(0x907)]['y']+=_0xc4f828[_0x579354(0x2a9)]||0x0;},Sprite_EnemyName['prototype']['updateOpacity']=function(){const _0x55ef7e=_0xa8cad7,_0x24869f=this[_0x55ef7e(0x75c)]();if(_0x24869f&&this[_0x55ef7e(0xa4c)]<0xff)'xfIgD'==='xfIgD'?this['opacity']+=0x10:(this['push'](_0x55ef7e(0x55d)),this['push']('popBaseLine'),this[_0x55ef7e(0x6c0)](_0x55ef7e(0x9e6)),this[_0x55ef7e(0x6c0)](_0x55ef7e(0xa27),_0x4090a9[_0x55ef7e(0x6cf)]['format'](_0x318cd3[_0x55ef7e(0x9a6)]())),this[_0x55ef7e(0x6c0)](_0x55ef7e(0x4ab)));else!_0x24869f&&this[_0x55ef7e(0xa4c)]>0x0&&(_0x55ef7e(0x70e)===_0x55ef7e(0x70e)?this['opacity']-=0x10:(this['_windowLayer']['x']=(_0x202f01[_0x55ef7e(0x960)]-_0x10c849['boxWidth'])/0x2,this[_0x55ef7e(0x954)]['y']=(_0x324b4e[_0x55ef7e(0xa97)]-_0x50c08a['boxHeight'])/0x2));},Sprite_EnemyName[_0xa8cad7(0xa60)][_0xa8cad7(0x75c)]=function(){const _0x2d2964=_0xa8cad7;if(this['isAlwaysHidden']()){if(_0x2d2964(0xa82)===_0x2d2964(0xa82))return![];else{if(_0x22da89[_0x2d2964(0x4cf)](_0x328689))return!![];return![];}}else{if(!this['_battler'])return![];else{if(this['_battler'][_0x2d2964(0xb06)]())return![];else{if(!this[_0x2d2964(0x959)]['isAppeared']())return![];else{if(this[_0x2d2964(0x424)]()){if(_0x2d2964(0x8dd)!==_0x2d2964(0x8dd))_0x2af6e7=!_0x2d717d;else return!![];}else{if(this[_0x2d2964(0x997)]())return!![];else{if(this[_0x2d2964(0x38a)]())return!![];else{if(this[_0x2d2964(0xa4c)]>0x0){if(_0x2d2964(0x50c)===_0x2d2964(0x416))this[_0x2d2964(0x38d)]=_0x2e04dd[_0x2d2964(0x38d)];else return![];}}}}}}}}},Sprite_EnemyName[_0xa8cad7(0xa60)][_0xa8cad7(0x40e)]=function(){const _0x3ff6f0=_0xa8cad7;return VisuMZ['BattleCore'][_0x3ff6f0(0xb57)][_0x3ff6f0(0x8d5)][_0x3ff6f0(0xb89)];},Sprite_EnemyName['prototype'][_0xa8cad7(0x424)]=function(){return![];},Sprite_EnemyName[_0xa8cad7(0xa60)]['isAlwaysVisible']=function(){const _0x2aa4a4=_0xa8cad7;return VisuMZ[_0x2aa4a4(0x8a9)][_0x2aa4a4(0xb57)][_0x2aa4a4(0x8d5)][_0x2aa4a4(0xa9d)];},Sprite_EnemyName[_0xa8cad7(0xa60)][_0xa8cad7(0x38a)]=function(){const _0x4147c4=_0xa8cad7;if(VisuMZ[_0x4147c4(0x8a9)]['Settings']['Enemy'][_0x4147c4(0x832)]){if('CVIdv'===_0x4147c4(0x854))return this[_0x4147c4(0x959)][_0x4147c4(0x361)]();else _0x22b0ba[_0x4147c4(0x122)]['x']=this[_0x4147c4(0x3bf)](),_0x2407b3[_0x4147c4(0x122)]['y']=this[_0x4147c4(0x142)]();}else return _0x4147c4(0x2c7)!==_0x4147c4(0x537)?SceneManager[_0x4147c4(0x26b)][_0x4147c4(0x63b)]&&SceneManager[_0x4147c4(0x26b)][_0x4147c4(0x63b)][_0x4147c4(0xa30)]&&SceneManager[_0x4147c4(0x26b)][_0x4147c4(0x63b)][_0x4147c4(0x609)]['includes'](this[_0x4147c4(0x959)]):_0x4fe166['BattleCore'][_0x4147c4(0xb57)][_0x4147c4(0xa3f)][_0x4147c4(0x674)]['call'](this);},Sprite_EnemyName['prototype'][_0xa8cad7(0x12e)]=function(){const _0x5e9b12=_0xa8cad7;if(!this['_battler'])return 0x0;if(this[_0x5e9b12(0x824)])return this[_0x5e9b12(0x824)];const _0x86dc7a=this[_0x5e9b12(0x9a6)]();return this['setupFont'](),this[_0x5e9b12(0x824)]=this['bitmap'][_0x5e9b12(0x1ef)](_0x86dc7a)||0x1,this[_0x5e9b12(0x824)];},VisuMZ['BattleCore'][_0xa8cad7(0x80a)]=Sprite_Battleback[_0xa8cad7(0xa60)][_0xa8cad7(0x7e5)],Sprite_Battleback['prototype'][_0xa8cad7(0x7e5)]=function(){const _0x8dba1=_0xa8cad7,_0xec8e24=VisuMZ['BattleCore']['Settings'][_0x8dba1(0x88a)];if(!_0xec8e24){if(_0x8dba1(0x55c)==='pyZUn')return VisuMZ[_0x8dba1(0x8a9)][_0x8dba1(0x80a)][_0x8dba1(0x9b5)](this);else _0x32a202['result']()[_0x8dba1(0x3e5)]>0x0&&!_0x10ff4c[_0x8dba1(0x3be)]()[_0x8dba1(0x5b5)]&&this[_0x8dba1(0x6c0)]('performDamage',_0x1a7f04),_0x3605ae[_0x8dba1(0x3be)]()['hpDamage']<0x0&&this[_0x8dba1(0x6c0)](_0x8dba1(0x895),_0x38e785),_0x5d9bb6[_0x8dba1(0x8a9)]['Settings'][_0x8dba1(0x6df)]['ShowHpDmg']&&this[_0x8dba1(0x6c0)]('addText',this[_0x8dba1(0x6d6)](_0x3171cc));}const _0x2f8dec=String(_0xec8e24[_0x8dba1(0x180)])||'MZ';switch(_0x2f8dec){case'MZ':VisuMZ['BattleCore'][_0x8dba1(0x80a)]['call'](this);break;case'1:1':this[_0x8dba1(0x1e0)]();break;case _0x8dba1(0x6c2):this[_0x8dba1(0x624)]();break;case _0x8dba1(0x14a):this['adjustPosition_ScaleDown']();break;case _0x8dba1(0xb0d):this[_0x8dba1(0x62d)]();break;}},Sprite_Battleback['prototype']['adjustPosition_1for1']=function(){const _0x5980a9=_0xa8cad7;this[_0x5980a9(0x960)]=Graphics[_0x5980a9(0x960)],this[_0x5980a9(0xa97)]=Graphics[_0x5980a9(0xa97)];const _0x584f61=0x1;this['scale']['x']=_0x584f61,this[_0x5980a9(0x122)]['y']=_0x584f61,this['x']=0x0,this['y']=0x0;},Sprite_Battleback[_0xa8cad7(0xa60)][_0xa8cad7(0x624)]=function(){const _0x23a786=_0xa8cad7;this[_0x23a786(0x960)]=Graphics[_0x23a786(0x960)],this['height']=Graphics['height'];const _0x5b43c1=this[_0x23a786(0x960)]/this[_0x23a786(0x379)][_0x23a786(0x960)],_0x50466c=this[_0x23a786(0xa97)]/this['bitmap'][_0x23a786(0xa97)],_0x5b5d72=Math[_0x23a786(0x743)](_0x5b43c1,_0x50466c);this[_0x23a786(0x122)]['x']=_0x5b5d72,this[_0x23a786(0x122)]['y']=_0x5b5d72,this['x']=(Graphics['width']-this[_0x23a786(0x960)])/0x2,this['y']=Graphics[_0x23a786(0xa97)]-this['height'];},Sprite_Battleback[_0xa8cad7(0xa60)][_0xa8cad7(0x353)]=function(){const _0x55f13a=_0xa8cad7;this[_0x55f13a(0x960)]=Graphics['width'],this[_0x55f13a(0xa97)]=Graphics[_0x55f13a(0xa97)];const _0x296bca=Math['min'](0x1,this[_0x55f13a(0x960)]/this[_0x55f13a(0x379)]['width']),_0x259544=Math[_0x55f13a(0x5b1)](0x1,this['height']/this[_0x55f13a(0x379)]['height']),_0x39832c=Math['max'](_0x296bca,_0x259544);this['scale']['x']=_0x39832c,this['scale']['y']=_0x39832c,this['x']=(Graphics[_0x55f13a(0x960)]-this[_0x55f13a(0x960)])/0x2,this['y']=Graphics['height']-this[_0x55f13a(0xa97)];},Sprite_Battleback['prototype'][_0xa8cad7(0x62d)]=function(){const _0x1307d8=_0xa8cad7;this[_0x1307d8(0x960)]=Graphics['width'],this['height']=Graphics['height'];const _0x5f4bc8=Math[_0x1307d8(0x743)](0x1,this[_0x1307d8(0x960)]/this[_0x1307d8(0x379)][_0x1307d8(0x960)]),_0x1a222d=Math[_0x1307d8(0x743)](0x1,this[_0x1307d8(0xa97)]/this[_0x1307d8(0x379)][_0x1307d8(0xa97)]),_0x4aeef4=Math['max'](_0x5f4bc8,_0x1a222d);this['scale']['x']=_0x4aeef4,this[_0x1307d8(0x122)]['y']=_0x4aeef4,this['x']=(Graphics[_0x1307d8(0x960)]-this[_0x1307d8(0x960)])/0x2,this['y']=Graphics[_0x1307d8(0xa97)]-this['height'];},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x3fe)]=function(){const _0x466deb=_0xa8cad7;if(!$gameSystem[_0x466deb(0x1d3)]())return![];return![];},Spriteset_Battle['prototype']['animationBaseDelay']=function(){return 0x0;},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x1bb)]=function(){return 0x0;},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x288)]=Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x96d)],Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x96d)]=function(){const _0x5343b1=_0xa8cad7;VisuMZ[_0x5343b1(0x8a9)][_0x5343b1(0x288)][_0x5343b1(0x9b5)](this),this[_0x5343b1(0x25f)](),this[_0x5343b1(0xa73)](),this[_0x5343b1(0x96c)]();},VisuMZ[_0xa8cad7(0x8a9)]['Spriteset_Battle_update']=Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x99e)],Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x99e)]=function(){const _0x152c26=_0xa8cad7;VisuMZ['BattleCore'][_0x152c26(0x155)][_0x152c26(0x9b5)](this),this[_0x152c26(0x9f1)]();},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x25f)]=function(){const _0x394a7d=_0xa8cad7;this['_weather']=new Weather(),this[_0x394a7d(0x3ec)][_0x394a7d(0x9ac)](this[_0x394a7d(0xa25)]);},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x9f1)]=function(){const _0x27c1b1=_0xa8cad7;this[_0x27c1b1(0xa25)][_0x27c1b1(0x4fb)]=$gameScreen['weatherType'](),this[_0x27c1b1(0xa25)][_0x27c1b1(0x46a)]=$gameScreen[_0x27c1b1(0x247)]();},Game_Interpreter[_0xa8cad7(0xa60)][_0xa8cad7(0x310)]=function(_0x2627e0){const _0x4053f4=_0xa8cad7;$gameScreen['changeWeather'](_0x2627e0[0x0],_0x2627e0[0x1],_0x2627e0[0x2]);if(_0x2627e0[0x3])this[_0x4053f4(0x4ab)](_0x2627e0[0x2]);return!![];},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x91b)]=Game_Interpreter[_0xa8cad7(0xa60)][_0xa8cad7(0x5a5)],Game_Interpreter[_0xa8cad7(0xa60)][_0xa8cad7(0x5a5)]=function(_0x12140d){const _0x4046ee=_0xa8cad7;if(SceneManager[_0x4046ee(0x45f)]()){if(_0x4046ee(0xb30)!==_0x4046ee(0x437))return SceneManager[_0x4046ee(0x26b)][_0x4046ee(0x726)]['changeBattlebacks'](_0x12140d[0x0],_0x12140d[0x1]),!![];else _0x3528ab['isAttack']()&&_0x45fc21[_0x4046ee(0x902)]()&&this['push']('setActiveWeaponSet',_0xd108d,_0x169a52),_0x132d6f[_0x4046ee(0x191)]()[_0x4046ee(0x94c)]<0x0?this['targetActionSet'](_0x173f2c,_0x175a72,_0x494f0e):this[_0x4046ee(0xae3)](_0x1bc90b,_0x349236,_0x2d025e);}else return VisuMZ['BattleCore'][_0x4046ee(0x91b)][_0x4046ee(0x9b5)](this,_0x12140d);},Spriteset_Battle[_0xa8cad7(0xa60)]['updateBattlebackBitmap']=function(_0x3fb61e,_0x4df969){const _0x466bec=_0xa8cad7;_0x3fb61e[_0x466bec(0x379)]=_0x4df969;},Spriteset_Battle[_0xa8cad7(0xa60)]['changeBattlebacks']=function(_0x5b833f,_0x16a92f){const _0x4b4ba9=_0xa8cad7;_0x5b833f=_0x5b833f||'',_0x16a92f=_0x16a92f||'';_0x5b833f===''&&_0x16a92f===''&&('meZkU'!=='meZkU'?(_0x34a868[_0x4b4ba9(0x8a9)]['Sprite_Actor_createStateSprite'][_0x4b4ba9(0x9b5)](this),_0x2caa5e[_0x4b4ba9(0x8a9)][_0x4b4ba9(0xb57)][_0x4b4ba9(0xb2e)]['ShowActorGauge']&&this[_0x4b4ba9(0x634)]()):(_0x5b833f=this[_0x4b4ba9(0xb61)][_0x4b4ba9(0x472)](),_0x16a92f=this[_0x4b4ba9(0x6f0)][_0x4b4ba9(0xae9)]()));const _0x4ef15c=ImageManager[_0x4b4ba9(0x4cb)](_0x5b833f),_0x3426db=ImageManager[_0x4b4ba9(0x736)](_0x16a92f);_0x4ef15c['addLoadListener'](this['updateBattlebackBitmap1'][_0x4b4ba9(0x66e)](this,this[_0x4b4ba9(0xb61)],this[_0x4b4ba9(0x6f0)],_0x4ef15c,_0x3426db));},Spriteset_Battle[_0xa8cad7(0xa60)]['updateBattlebackBitmap1']=function(_0x534639,_0x45d10a,_0x40bc52,_0xeb232f){const _0x5809f7=_0xa8cad7;_0xeb232f[_0x5809f7(0x842)](this['updateBattlebackBitmap2']['bind'](this,_0x534639,_0x45d10a,_0x40bc52,_0xeb232f));},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x871)]=function(_0x5b5a43,_0x4ba650,_0x4ac63b,_0x1768b7){const _0x3f9155=_0xa8cad7;_0x5b5a43[_0x3f9155(0x379)]=_0x4ac63b,_0x4ba650[_0x3f9155(0x379)]=_0x1768b7,_0x5b5a43['adjustPosition'](),_0x4ba650[_0x3f9155(0x7e5)]();},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0xafc)]=Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0xb04)],Spriteset_Battle[_0xa8cad7(0xa60)]['createBattleField']=function(){const _0x1292e4=_0xa8cad7;VisuMZ[_0x1292e4(0x8a9)][_0x1292e4(0xafc)][_0x1292e4(0x9b5)](this),this[_0x1292e4(0xabc)]();},Spriteset_Battle[_0xa8cad7(0xa60)]['createBattleFieldBattleCore']=function(){const _0x15a21d=_0xa8cad7;this[_0x15a21d(0x69c)](),this[_0x15a21d(0x90d)](),this['createDamageContainer'](),this[_0x15a21d(0x606)]();},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x69c)]=function(){const _0x2bb1ad=_0xa8cad7;this['_battlerContainer']=new Sprite(),this['_battleField'][_0x2bb1ad(0x9ac)](this[_0x2bb1ad(0x4ee)]);},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x90d)]=function(){const _0x315662=_0xa8cad7;this[_0x315662(0xa0a)]=new Sprite(),this['_battleField'][_0x315662(0x9ac)](this[_0x315662(0xa0a)]);},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x68b)]=function(){const _0x533760=_0xa8cad7;this[_0x533760(0x47a)]=new Sprite(),this[_0x533760(0x47a)]['x']=this[_0x533760(0x3ec)]['x'],this[_0x533760(0x47a)]['y']=this[_0x533760(0x3ec)]['y'],this['addChild'](this['_damageContainer']);},Spriteset_Battle['prototype'][_0xa8cad7(0x606)]=function(){const _0x56afd1=_0xa8cad7;if(!this['isFlipped']())return;this['_battlerContainer']['scale']['x']=-0x1,this[_0x56afd1(0x4ee)]['x']=this[_0x56afd1(0x3ec)][_0x56afd1(0x960)],this[_0x56afd1(0xa0a)]['scale']['x']=-0x1,this['_animationContainer']['x']=this['_battleField'][_0x56afd1(0x960)],this[_0x56afd1(0x47a)][_0x56afd1(0x122)]['x']=-0x1,this[_0x56afd1(0x47a)]['x']=this[_0x56afd1(0x3ec)]['x']+this['_battleField'][_0x56afd1(0x960)];},Spriteset_Battle['prototype'][_0xa8cad7(0x7c0)]=function(){const _0x17653b=_0xa8cad7;Imported[_0x17653b(0x8a4)]&&this[_0x17653b(0x1c2)]()&&(_0x17653b(0x216)==='AgInw'?(this['_growX']=(this[_0x17653b(0x494)]*(_0x101b94-0x1)+this['_targetGrowX'])/_0xa63ae2,this['_growY']=(this['_growY']*(_0x208baf-0x1)+this[_0x17653b(0x5fd)])/_0x47dd8c):this['repositionEnemiesByResolution']());const _0x4a5d47=$gameTroop[_0x17653b(0x563)](),_0x27d2e8=[];for(const _0x45eab6 of _0x4a5d47){_0x27d2e8[_0x17653b(0x6c0)](new Sprite_Enemy(_0x45eab6));}_0x27d2e8['sort'](this['compareEnemySprite'][_0x17653b(0x66e)](this));for(const _0x21f7dd of _0x27d2e8){_0x17653b(0xb0c)!=='tcOcm'?this['requestMotion']('guard'):this[_0x17653b(0x4ee)][_0x17653b(0x9ac)](_0x21f7dd);}this[_0x17653b(0x5de)]=_0x27d2e8;},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x11a)]=function(){const _0x3bc69c=_0xa8cad7;this[_0x3bc69c(0x853)]=[];for(let _0x32c355=0x0;_0x32c355<$gameParty[_0x3bc69c(0xa1f)]();_0x32c355++){const _0x398ba3=$gameParty['battleMembers']()[_0x32c355],_0x81a349=new Sprite_Actor();_0x81a349[_0x3bc69c(0x4a9)](_0x398ba3),_0x81a349['setBattler'](_0x398ba3),_0x81a349[_0x3bc69c(0x99e)](),this[_0x3bc69c(0x853)][_0x3bc69c(0x6c0)](_0x81a349),this[_0x3bc69c(0x4ee)][_0x3bc69c(0x9ac)](_0x81a349);}},Spriteset_Battle['prototype']['createAnimationSprite']=function(_0x444931,_0x47b815,_0x25762d,_0x221bfe){const _0x154fa1=_0xa8cad7,_0x3c95b0=this[_0x154fa1(0x5dd)](_0x47b815),_0xa127e0=new(_0x3c95b0?Sprite_AnimationMV:Sprite_Animation)(),_0x217b47=this[_0x154fa1(0x6a4)](_0x444931);this[_0x154fa1(0x47d)](_0x444931[0x0])&&(_0x25762d=!_0x25762d),_0xa127e0['targetObjects']=_0x444931,_0xa127e0[_0x154fa1(0xb84)](_0x217b47,_0x47b815,_0x25762d,_0x221bfe),this[_0x154fa1(0x598)](_0xa127e0);},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x598)]=function(_0x2f8631){const _0x3ed3db=_0xa8cad7;this[_0x3ed3db(0xa64)](_0x2f8631)?this[_0x3ed3db(0x9a3)]()['addChild'](_0x2f8631):this[_0x3ed3db(0xa0a)]['addChild'](_0x2f8631),this[_0x3ed3db(0x892)][_0x3ed3db(0x6c0)](_0x2f8631);},Spriteset_Battle['prototype'][_0xa8cad7(0xa64)]=function(_0x2b6951){const _0x424705=_0xa8cad7;if(!_0x2b6951)return![];if(!_0x2b6951[_0x424705(0x31a)])return![];if(_0x2b6951[_0x424705(0x31a)][_0x424705(0x7e0)]!==0x0)return![];if(!_0x2b6951[_0x424705(0xaec)][0x0])return![];if(_0x2b6951[_0x424705(0xaec)][0x0][_0x424705(0x902)]&&!_0x2b6951[_0x424705(0xaec)][0x0][_0x424705(0x902)]())return![];if($gameSystem['isSideView']())return![];if(!this[_0x424705(0x9a3)]())return![];const _0x41cd1d=Window_BattleStatus[_0x424705(0xa60)][_0x424705(0x1cc)]();return[_0x424705(0x33b),'xp'][_0x424705(0x40c)](_0x41cd1d);},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x9a3)]=function(){const _0x3f1dd7=_0xa8cad7;if(!SceneManager['_scene'])return null;if(!SceneManager['_scene']['_statusWindow'])return null;if(!SceneManager[_0x3f1dd7(0x26b)][_0x3f1dd7(0x213)][_0x3f1dd7(0xa1e)])return null;return SceneManager['_scene'][_0x3f1dd7(0x213)]['_effectsContainer'];},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x61c)]=function(_0x1d8c4b){const _0x2e5c26=_0xa8cad7;this['removeAnimationFromContainer'](_0x1d8c4b);for(const _0x294d48 of _0x1d8c4b[_0x2e5c26(0xaec)]){_0x294d48[_0x2e5c26(0x37e)]&&_0x294d48[_0x2e5c26(0x37e)]();}_0x1d8c4b['destroy']();},Spriteset_Battle['prototype'][_0xa8cad7(0x18a)]=function(_0x498648){const _0x4a30d4=_0xa8cad7;this[_0x4a30d4(0x892)][_0x4a30d4(0xafb)](_0x498648);if(this[_0x4a30d4(0xa64)](_0x498648)){if('blbIw'==='blbIw')this['battleStatusWindowAnimationContainer']()[_0x4a30d4(0x535)](_0x498648);else return _0x33e9cb=_0x14c3f(_0xdd7299),_0x2a52ce[_0x4a30d4(0x21d)](/#(.*)/i)?_0x4a30d4(0x800)[_0x4a30d4(0x69b)](_0x5bc8b3(_0x41312a['$1'])):this[_0x4a30d4(0x968)](_0x149773(_0x20bdac));}else _0x4a30d4(0x615)===_0x4a30d4(0x615)?this['_animationContainer'][_0x4a30d4(0x535)](_0x498648):(_0x427f6e[_0x4a30d4(0x8a9)][_0x4a30d4(0x7bd)]['call'](this,_0x1dd8a7),this[_0x4a30d4(0x865)](),this[_0x4a30d4(0x415)]());},VisuMZ[_0xa8cad7(0x8a9)][_0xa8cad7(0x6bc)]=Spriteset_Battle['prototype'][_0xa8cad7(0x202)],Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x202)]=function(){const _0x993978=_0xa8cad7;VisuMZ['BattleCore'][_0x993978(0x6bc)][_0x993978(0x9b5)](this),this[_0x993978(0x503)]();},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x503)]=function(){const _0x204a32=_0xa8cad7;this['_battlerContainer']['children']['sort'](this['compareBattlerSprites']['bind'](this)),this[_0x204a32(0x5fa)]();},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0xacc)]=function(_0x339cba,_0x3a8ae9){const _0xc0be70=_0xa8cad7;if(VisuMZ[_0xc0be70(0x8a9)][_0xc0be70(0xb57)][_0xc0be70(0x3d8)]['PrioritySortActors']){if(_0x339cba[_0xc0be70(0x959)]&&_0x3a8ae9[_0xc0be70(0x959)]){if(_0xc0be70(0xa1a)!==_0xc0be70(0x52c)){if(_0x339cba[_0xc0be70(0x959)]['isActor']()&&_0x3a8ae9['_battler'][_0xc0be70(0x31f)]())return 0x1;else{if(_0x3a8ae9[_0xc0be70(0x959)][_0xc0be70(0x902)]()&&_0x339cba[_0xc0be70(0x959)][_0xc0be70(0x31f)]())return-0x1;}}else{if(!_0x8a5676[_0xc0be70(0x45f)]())return![];if(!_0x28d88c)return![];if(!_0x1f459c[_0xc0be70(0x191)]())return![];if(_0x4bfdf3[_0xc0be70(0x191)]()[_0xc0be70(0x74f)]['match'](/<CUSTOM ACTION SEQUENCE>/i))return!![];if(_0x3c320c[_0xc0be70(0x583)](_0x26b934[_0xc0be70(0x191)]()))return!![];return![];}}}if(_0x339cba[_0xc0be70(0x98c)]!==_0x3a8ae9[_0xc0be70(0x98c)])return _0x339cba[_0xc0be70(0x98c)]-_0x3a8ae9[_0xc0be70(0x98c)];else{if(_0xc0be70(0x83d)===_0xc0be70(0x595))for(const _0x51a0d3 of this[_0xc0be70(0x563)]()){if(_0x51a0d3)_0x51a0d3[_0xc0be70(0x75f)](_0x4edf38);}else return _0x3a8ae9[_0xc0be70(0x5be)]-_0x339cba['spriteId'];}},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x5fa)]=function(){const _0x15aa44=_0xa8cad7;if(!VisuMZ[_0x15aa44(0x8a9)]['Settings']['Actor']['PrioritySortActive'])return;const _0x5e8a41=BattleManager[_0x15aa44(0x4d4)];if(_0x5e8a41){if(_0x5e8a41[_0x15aa44(0x902)]()&&!$gameSystem['isSideView']())return;const _0x8d55f9=_0x5e8a41[_0x15aa44(0xac0)]();if(_0x8d55f9&&_0x5e8a41['isActor']())this[_0x15aa44(0x4ee)][_0x15aa44(0x9ac)](_0x8d55f9);}},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x9c0)]=function(){const _0x272b53=_0xa8cad7;for(const _0x455444 of $gameParty['aliveMembers']()){if(_0x272b53(0x9cd)===_0x272b53(0x9d3)){_0x52e311[_0x272b53(0x8a9)]['Game_Battler_performActionStart'][_0x272b53(0x9b5)](this,_0x3768a8);if(!_0x3ad9fa[_0x272b53(0x766)]()){const _0x1f407b=this[_0x272b53(0xac0)]();_0x1f407b&&_0x1f407b[_0x272b53(0xb33)]();}this['setBattlerFlip'](![]);}else{if(!_0x455444)continue;if(!_0x455444['battler']())continue;_0x455444[_0x272b53(0xac0)]()[_0x272b53(0x65a)]=!![],_0x455444['battler']()[_0x272b53(0x4ce)]();}}},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0xa73)]=function(){const _0x31edf0=_0xa8cad7;this[_0x31edf0(0x8fe)]=new Sprite(),this[_0x31edf0(0x3ec)][_0x31edf0(0x9ac)](this[_0x31edf0(0x8fe)]);},Spriteset_Battle[_0xa8cad7(0xa60)]['createEnemyNames']=function(){const _0x54235a=_0xa8cad7;if(VisuMZ[_0x54235a(0x8a9)][_0x54235a(0xb57)][_0x54235a(0x8d5)][_0x54235a(0x360)])return;this[_0x54235a(0x493)]=new Sprite(),this[_0x54235a(0x8fe)][_0x54235a(0x9ac)](this[_0x54235a(0x493)]);for(const _0x17dac1 of this[_0x54235a(0x5de)]){if(_0x54235a(0x3c6)!==_0x54235a(0x187)){const _0x4add8f=new Sprite_EnemyName();this[_0x54235a(0x493)][_0x54235a(0x9ac)](_0x4add8f),_0x4add8f[_0x54235a(0x9c4)](_0x17dac1);}else this[_0x54235a(0x48d)]()?this['onDisabledPartyCommandSelection']():_0x239cfe[_0x54235a(0x8a9)][_0x54235a(0x181)][_0x54235a(0x9b5)](this);}},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0xb15)]=function(){return![];},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0x4aa)]=function(){const _0x1e5e82=_0xa8cad7;return this[_0x1e5e82(0x2d2)]()[_0x1e5e82(0x5f1)](_0x21bd45=>_0x21bd45['isFloating']());},Spriteset_Battle[_0xa8cad7(0xa60)]['isAnyoneJumping']=function(){const _0x4f8fc7=_0xa8cad7;return this[_0x4f8fc7(0x2d2)]()[_0x4f8fc7(0x5f1)](_0x3781f8=>_0x3781f8[_0x4f8fc7(0x8c9)]());},Spriteset_Battle['prototype']['isAnyoneGrowing']=function(){const _0x4eeccb=_0xa8cad7;return this['battlerSprites']()[_0x4eeccb(0x5f1)](_0x36e954=>_0x36e954['isGrowing']());},Spriteset_Battle[_0xa8cad7(0xa60)][_0xa8cad7(0xb39)]=function(){const _0x240ef5=_0xa8cad7;return this[_0x240ef5(0x2d2)]()[_0x240ef5(0x5f1)](_0x1160ce=>_0x1160ce[_0x240ef5(0x92a)]());},Spriteset_Battle[_0xa8cad7(0xa60)]['isAnyoneSpinning']=function(){const _0x1c0357=_0xa8ca