/*:
 * @target MZ
 * @plugindesc Ctrlキー長押しでメッセージ早送り＆入力待ちを自動進行（RPGツクールMZ） v1.1
 * @author nino
 * @help
 * ・Ctrl押下中：全文即表示（showFast）＋入力待ちもOK押下扱いで自動進行
 * ・通常時：従来どおり（手動で決定キーを押して進む）
 *
 * 重要：
 * 以前版(v1.0)の「updateInputを直接上書き」するやり方は不要です。
 * この版では Window_Message.isTriggered を拡張して、
 * Ctrl を「OK入力扱い」にするだけなのでループしません。
 */

(() => {
  // 文字送り高速化（Ctrl押下中は showFast = true）
  const _Window_Message_updateShowFast = Window_Message.prototype.updateShowFast;
  Window_Message.prototype.updateShowFast = function() {
    if (Input.isPressed("control")) this._showFast = true;
    _Window_Message_updateShowFast.call(this);
  };

  // 入力待ち（文章末/改ページ待ち/一時停止）での「OK入力」判定に Ctrl を追加
  const _Window_Message_isTriggered = Window_Message.prototype.isTriggered;
  Window_Message.prototype.isTriggered = function() {
    // CtrlをOK入力と同等に扱う
    if (Input.isPressed("control")) return true;
    return _Window_Message_isTriggered.call(this);
  };


})();