/*:
 * @target MZ
 * @plugindesc メニューウィンドウの位置変更（MZ専用）v1.1 修正版（Argument must be a Rectangle対応） @author あああああ
 *
 * @param Horizontal
 * @text 横位置
 * @type select
 * @option 左
 * @value left
 * @option 中央
 * @value center
 * @option 右
 * @value right
 * @default left
 *
 * @param Vertical
 * @text 縦位置
 * @type select
 * @option 上
 * @value top
 * @option 中央
 * @value middle
 * @option 下
 * @value bottom
 * @default top
 *
 * @param HideStatusWindow
 * @text ステータスウィンドウを非表示
 * @type boolean
 * @on 非表示
 * @off 表示
 * @default false
 *
 * @param HideGoldWindow
 * @text 所持金ウィンドウを非表示
 * @type boolean
 * @on 非表示
 * @off 表示
 * @default false
 */

(() => {
    const parameters = PluginManager.parameters('MyMenuPosition_MZ');
    const horizontal = parameters['Horizontal'] || 'left';
    const vertical = parameters['Vertical'] || 'top';
    const hideStatusWindow = parameters['HideStatusWindow'] === 'true';
    const hideGoldWindow = parameters['HideGoldWindow'] === 'true';

    Scene_Menu.prototype.createCommandWindow = function() {
        const width = 240;
        const tempWindow = new Window_MenuCommand(new Rectangle(0, 0, 0, 0));
        const commandCount = tempWindow.maxItems();
        const height = tempWindow.fittingHeight(commandCount);

        let x = 0;
        let y = 0;

        if (horizontal === 'center') {
            x = (Graphics.boxWidth - width) / 2;
        } else if (horizontal === 'right') {
            x = Graphics.boxWidth - width;
        }

        if (vertical === 'middle') {
            y = (Graphics.boxHeight - height) / 2;
        } else if (vertical === 'bottom') {
            y = Graphics.boxHeight - height;
        }

        const rect = new Rectangle(x, y, width, height);
        this._commandWindow = new Window_MenuCommand(rect);
        this._commandWindow.setHandler('item', this.commandItem.bind(this));
        this._commandWindow.setHandler('skill', this.commandPersonal.bind(this));
        this._commandWindow.setHandler('equip', this.commandPersonal.bind(this));
        this._commandWindow.setHandler('status', this.commandPersonal.bind(this));
        this._commandWindow.setHandler('formation', this.commandFormation.bind(this));
        this._commandWindow.setHandler('options', this.commandOptions.bind(this));
        this._commandWindow.setHandler('save', this.commandSave.bind(this));
        this._commandWindow.setHandler('gameEnd', this.commandGameEnd.bind(this));
        this._commandWindow.setHandler('cancel', this.popScene.bind(this));
        this.addWindow(this._commandWindow);
    };

    const _Scene_Menu_createStatusWindow = Scene_Menu.prototype.createStatusWindow;
    Scene_Menu.prototype.createStatusWindow = function() {
        _Scene_Menu_createStatusWindow.call(this);
        if (hideStatusWindow) {
            this._statusWindow.hide();
        }
    };

    const _Scene_Menu_createGoldWindow = Scene_Menu.prototype.createGoldWindow;
    Scene_Menu.prototype.createGoldWindow = function() {
        _Scene_Menu_createGoldWindow.call(this);
        if (hideGoldWindow) {
            this._goldWindow.hide();
        }
    };
})();
