﻿//=============================================================================
// TitleCommandPositionMZ.js
//=============================================================================
/*:
 * @target MZ
 * @plugindesc タイトルコマンドウィンドウの位置・幅・背景タイプを変更します。
 * @author Yoji Ojima（MZ用調整：半分）
 *
 * @param OffsetX
 * @text Xオフセット
 * @type number
 * @default 0
 * @desc タイトルコマンドウィンドウのX座標をこの値だけずらします。
 *
 * @param OffsetY
 * @text Yオフセット
 * @type number
 * @default 0
 * @desc タイトルコマンドウィンドウのY座標をこの値だけずらします。
 *
 * @param WindowWidth
 * @text ウィンドウ幅
 * @type number
 * @default 240
 * @desc コマンドウィンドウの幅を指定します。
 *
 * @param Background
 * @text 背景タイプ
 * @type select
 * @option 通常
 * @value 0
 * @option 暗くする
 * @value 1
 * @option 透明
 * @value 2
 * @default 0
 * @desc 背景の種類を選びます。
 *
 * @help
 * 【概要】
 * タイトル画面の「ニューゲーム」「コンティニュー」などの
 * コマンドウィンドウの位置・幅・背景タイプを変更します。
 *
 * 【使用方法】
 * プラグインを有効にして、パラメータで調整するだけです。
 *
 * 【注意点】
 * - 他のタイトル画面改変プラグインと競合する場合があります。
 * - このプラグインにコマンドやスクリプトコールはありません。
 *
 * 【更新履歴】
 * ver.1.1 (2025/11/07) RPGツクールMZ対応化
 * ver.1.0 初版（MV版）
 */

(() => {
    const pluginName = "TitleCommandPositionMZ";
    const parameters = PluginManager.parameters(pluginName);

    const offsetX = Number(parameters["OffsetX"] || 0);
    const offsetY = Number(parameters["OffsetY"] || 0);
    const windowWidth = Number(parameters["WindowWidth"] || 240);
    const background = Number(parameters["Background"] || 0);

    // MZ標準クラスを上書き
    const _Window_TitleCommand_updatePlacement = Window_TitleCommand.prototype.updatePlacement;
    Window_TitleCommand.prototype.updatePlacement = function() {
        _Window_TitleCommand_updatePlacement.call(this);
        this.x += offsetX;
        this.y += offsetY;
        this.setBackgroundType(background);
    };

    Window_TitleCommand.prototype.windowWidth = function() {
        return windowWidth;
    };
})();
