//=============================================================================
// 100CommandData.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 保存データ
 * @help
 * 使用ピクチャ番号一覧:
 *  - 1〜4：背景（背景セット）
 *  - 10：立ち絵用（NPic）
 *  - 30：UI用（UIPic、Spine "UI"）
 *  - 49：黒背景
 *  - 50：ウィンドウ用（Spine）
 *  - 55：アイテム用（Spine）
 *  - 60〜74：テキストUI表示（Dテキスト）
 *  - 99：CG用（特定条件下）
 *  - 100：タイトル、アルバイト、ステータス用（Spine）
 *  - 150：オプション、セーブ用（Spine）
 *  - 199：セーブ用（Spine）
 *  - 200：確認用（Spine）
 */


(() => {
    let UIPic   = 30; //UIのピクチャ番号
    let NPic    = 10;
    let Skinval = 21;
    let SkinVal2 = 22;
    AudioManager._bgsBuffers = [];
    const wait  = frames => new Promise(r => setTimeout(r, frames * (1000/60)));

    const BgMapp = {
        "リビング": ["living1", "living3", "living2", "living1"],
        "義妹部屋": ["sister_room4", "sister_room3", "sister_room2", "sister_room1"],
        "自室"    : ["room4", "room3", "room2", "room1"],
        "玄関"    : ["entrance3", "entrance3", "entrance2", "entrance1"],
        "脱衣所"   : ["changing_room2", "changing_room2", "changing_room1", "changing_room1"],
        "飲食店" : ["Job_bg1-1","Job_bg1-3","Job_bg1-2","Job_bg1-1"],
        "引っ越し" : ["Job_bg2-1","Job_bg2-3","Job_bg2-2","Job_bg2-1"],
        "塾講師" : ["Job_bg3-1","Job_bg3-3","Job_bg3-2","Job_bg3-1"],
    };

    const BgMapp2 = {
        "リビング": "living",
        "義妹部屋": "sister_room",
        "自室"    : "room",
        "玄関"    : "entrance",
        "脱衣所"  : "changing_room",
        "黒背景"  : "bbg",
        "青空"    : "sky",
        "夕方"    : "sky",
        "夜空"    : "sky",
        "廊下"    : "廊下",
        "T"       : "T",
    };

    const SeMapp = {
        1: "決定",
        2: "キャンセル音",
        3: "カーソル",
        4: "目覚まし止める",
        5: "ドア開ける",
        6: "ドア開ける2",
        7: "走る",
        8: "射精",
        9: "ひととき",
        10: "勉強",
        11: "取り出す",
        12: "金獲得",
        13: "カートin",
        14: "カートout",
        15: "避ける",
        16: "AA",
        17: "歩く",
    };

    const BgmMapp = {
        1: "声が届かない",    //タイトル
        2: "お菓子作り",     //明るい
        3: "to_You",      //朝
        4: "別れの夕暮れ",   //スチル
        5: "Lonely_Dream",//昼
        6: "夢の中を泳ぐ魚",//夜
        7: "Ups_and_downs", //店
        8: "モノクロームの時計", //暗い
        9: "New_hope",
    };

    const BgsMapp = {
        1: "目覚まし",
        2: "手コキ1",
        3: "手コキ2",
        4: "手コキ3",
        5: "Kuchu",
        6: "Kuchu2",
        7: "Piston",
        8: "Piston2",
        9: "Piston3",
        10: "1033",
        11: "1034",
        12: "1035",
        13: "1036",
        14: "1037",
        15: "1034",
        16: "1036",
        17: "1037",
        18: "1041",
        19: "1042",
        20: "1043",
        21: "1044",
        22: "1045",
        23: "1046",
    };

    const GageAnime = {
        "好感度" : "ハート1",
        "淫乱度" : "ハート2",
        "性知識" : "ハート3",
        "学力"   : "ハート4",
        "手コキ" : "ハート5",
        "フェラ" : "ハート6",
        "セックス" : "ハート7",
    };

    const GageAnime2 = {
        "好感度" : "ダウン1",
        "淫乱度" : "ダウン2",
        "性知識" : "ダウン3",
        "学力"   : "ダウン4",
        "手コキ" : "ダウン5",
        "フェラ" : "ダウン6",
        "セックス" : "ダウン7",
    };

    window.初期セット = function() {
        アイコン指定 = "私服";
        $gameVariables.setValue(51,0);
        $gameVariables.setValue(53,0);
        $gameVariables.setValue(55,0);
        $gameVariables.setValue(57,0);
        $gameVariables.setValue(59,0);
        $gameVariables.setValue(61,0);
        $gameVariables.setValue(101,1);
        $gameVariables.setValue(105,10000);
        $gameVariables.setValue(106,100);
        $gameVariables.setValue(107,100);
        $gameVariables.setValue(108,6);
        $gameVariables.setValue(112,3);
        $gameVariables.setValue(113,3);
        TimeSet = 1000;
        曜日更新();
        $gameVariables.setValue(21,["私服"]);
        $gameVariables.setValue(22,$gameVariables.value(21))
    }

    window.タイトル = async function() {
        $gameVariables.setValue(10,100);
        $gameScreen.startFadeOut(30);
        await wait(30);
        AudioManager.stopAll();
        SceneManager.goto(Scene_Title);
        $gameVariables.setValue(10,100);
        await wait(30);
        $gameVariables.setValue(10,0);
    }

    window.終了 = async function() {
        $gameVariables.setValue(10,100);
        $gameScreen.startFadeOut(30);
        NrCustomMessage.destroy();
        await wait(30);
        SceneManager.exit();
    }

    Object.defineProperty(window, 'Dテキスト', {
        set: function(Call) {
            Call = Array.isArray(Call) ? Call : [];

            var CallPic  = Number(Call[0] != null ? Call[0] : 1);     // ピクチャID
            var CallX    = Number(Call[1] != null ? Call[1] : 0);     // X座標
            var CallY    = Number(Call[2] != null ? Call[2] : 0);     // Y座標
            var CallOpac = Number(Call[3] != null ? Call[3] : 255);   // 不透明度
            var CallText = String(Call[4] != null ? Call[4] : "");    // 表示テキスト
            var CallSize = Number(Call[5] != null ? Call[5] : 26);    // フォントサイズ
            var CallAli  = String(Call[6] != null ? Call[6] : "left");// left, center, right
            var CallWin  = Number(Call[7] != null ? Call[7] : CallSize * 10); // 表示幅
            var CallHigh = Number(Call[8] != null ? Call[8] : 300);   // 表示高さ（新追加）

            if (!/^(left|center|right)$/i.test(CallAli)) CallAli = "left";

            $gameScreen.setDtextSetting({
                realTime: true,
                align   : CallAli.toLowerCase(),
                pictureHigh: CallHigh,
                pictureWidth: CallWin
            });

            $gameScreen.setDTextPicture("\n" + CallText + "\n", CallSize);
            $gameScreen.showPicture(CallPic, "", 0, CallX, CallY - (CallSize - 5), 100, 100, CallOpac, 0);
        },
        configurable: true
    });

    Object.defineProperty(window, '獲得', {
        set(value) {
            console.log("1");
            const CallName = value[0];
            const CallExp  = value[1];
            if(CallExp > 0) {
                var Anime = GageAnime[CallName];
            } else {
                var Anime = GageAnime2[CallName];
            }
            if ([23, 24, 25, 26, 27, 28, 32, 33, 34, 39, 41, 43].some(id => $gameSwitches.value(id))) {
            } else {
                アニメ更新 = [1,UIPic,35,Anime,"000"];
            }
            NrGAIN_EXP(CallName, CallExp)
        },
        configurable: true
    });

    Object.defineProperty(window, '獲得2', {
        set(value) {
            console.log("2");
            const CallName = value[0];
            const CallExp  = value[1];
            if(CallExp > 0) {
                var Anime = GageAnime[CallName];
            } else {
                var Anime = GageAnime2[CallName];
            }
            if ([23, 24, 25, 26, 27, 28, 32, 33, 34, 39, 41, 43].some(id => $gameSwitches.value(id))) {
            } else {
                アニメ更新 = [1,UIPic,35,Anime,"000"];
            }
            NrGAIN_EXP(CallName, CallExp)
        },
        configurable: true
    });

    window.ウェイト = function(frameCount = 60) {
        const itp = (SceneManager._scene instanceof Scene_Battle)
            ? $gameTroop._interpreter
            : $gameMap._interpreter;
        if (itp && itp.wait) itp.wait(frameCount);
    };

    Object.defineProperty(window, '背景', {
        set(value) {
            const Pic = (value[0] === 30) ? 31 : value[0];
            const match = value[1].match(/^(.+?)(\d+)?$/);
            const key = match[1];
            const Num = match[2] || "";
            const PicName = "bg/" + BgMapp2[key] + Num;
            $gameScreen.showPicture(Pic, PicName, 1, 960, 540, 100, 100, 255, 0);
        },
        configurable: true
    });

    Object.defineProperty(window, '背景セット', {
        set(value) {
            const list = BgMapp[value];
            if (!list) return;

            for (let i = 0; i < list.length; i++) {
                $gameScreen.showPicture(i + 1, "bg/" + list[i], 1, 960, 540, 100, 100, 255, 0);
            }
        },
        configurable: true
    });

    Object.defineProperty(window, '背景セット2', {
        set(value) {
            const list = BgMapp[value[1]];
            if (!list) return;
            for (let i = 0; i < list.length; i++) {
                const id = value[0] + i;
                $gameScreen.showPicture(id, "bg/" + list[i], 1, 960, 540, 100, 100, 255, 0);
            }
        },
        configurable: true
    });

    window.背景管理 = function() {
        var Time = $gameVariables.value(103);
        var pictureId = 0;

        if (Time >= 7 && Time <= 16) pictureId = 5;
        if (Time >= 17 && Time <= 19) pictureId = 4;
        if (Time >= 20 && Time <= 24) pictureId = 3;
        if (Time >= 0 && Time <= 6) pictureId = 2;

        if (pictureId === 5) {
            for (var i = 1; i <= 4; i++) {
                Pフェード = [0, i, 255, 30];
            }
        } else {
            Pフェード = [0, pictureId, 0, 30];
        }
    };

    Object.defineProperty(window, 'P移動', {
        set(value) {
            if (!Array.isArray(value) || value.length < 4) return;

            const picId    = Number(value[0]);
            const targetX  = Number(value[1]);
            const targetY  = Number(value[2]);
            const scale    = Number(value[3]);
            const duration = Number(value[4] || 60);

            const p = $gameScreen.picture(picId);
            if (!p) return;

            $gameScreen.movePicture(
                picId,
                p.origin(),
                targetX,
                targetY,
                scale,
                scale,
                p.opacity(),
                p.blendMode(),
                duration
            );
        },
        configurable: true
    });

    Object.defineProperty(window, 'Pフェード', {
        set(value) {
            const mode    = value[0];
            const startId = value[1];
            let endId, opacity, duration;

            if (mode === 0) {
                opacity  = value[2];
                duration = value[3] ?? 60;
                endId = startId;
            } else {
                endId   = value[2];
                opacity = value[3];
                duration = value[4] ?? 60;
            }

            for (let id = startId; id <= endId; id++) {
                const p = $gameScreen.picture(id);
                if (!p) continue;
                $gameScreen.movePicture(
                    id,
                    p.origin(),
                    p.x(),
                    p.y(),
                    p.scaleX(),
                    p.scaleY(),
                    opacity,
                    p.blendMode(),
                    duration
                );
            }
        },
        configurable: true
    });

    Object.defineProperty(window, 'P消去', {
        set(value) {
            if (!Array.isArray(value) || value.length < 2) return;
            const mode = Number(value[0]);
            const startId = Number(value[1]);
            const endId = mode === 0 ? startId : Number(value[2] || startId);
            for (let id = startId; id <= endId; id++) {
                if ($gameScreen.picture(id)) $gameScreen.erasePicture(id);
            }
        },
        configurable: true
    });

    Object.defineProperty(window, 'TimePlus', {
        set(value) {
            var Plus = Number(value);
            var Hour = $gameVariables.value(103);
            var Hour2 = Hour;
            var Min = $gameVariables.value(109);
            var Min2 = Min;
            var DaySw = false;
            
            Min2 += Plus;
            while (Min2 >= 60) {
                Min2 -= 60;
                Hour2++;
            }

            if (Hour2 >= 24) {
                NrPictureEffect.stopLoopEffect();
                Hour2 -= 24;
                DaySw = true;
            }

            if (Hour2 >= 20) {
                アニメ更新 = [0,UIPic,1,"夜コマンド"];
            }

            if (Hour !== Hour2) {
                $gameVariables.setValue(103, Hour2);
                背景管理();
                Bgm切り替え();
            }
            if (Min !== Min2) {
                $gameVariables.setValue(109,Min2);
                var paddedMin = Min2 < 10 ? "0" + Min2 : String(Min2);
                $gameVariables.setValue(104, paddedMin);
            }

            if (DaySw) {
                次の日へ();
            } else {
                UI更新();
            }
        },
        configurable: true
    });

    Object.defineProperty(window, 'TimeSet', {
        set(value) {
            var time = Number(value);
            var hour = Math.floor(time / 100);
            var min = time % 100;
            var paddedMin = min < 10 ? min : String(min);

            $gameVariables.setValue(103, hour);
            $gameVariables.setValue(109, paddedMin);
            if (hour >= 20) {
                アニメ更新 = [0,UIPic,1,"夜コマンド"];
            }
            UI更新();
            背景管理();
            Bgm切り替え();
        },
        configurable: true
    });


    window.曜日更新 = function() {
        var weekNames = ["日","月","火","水","木","金","土"];
        var index = $gameVariables.value(108) || 0;
        index = (index + 1) % 7;
        $gameVariables.setValue(108, index);
        $gameVariables.setValue(102, weekNames[index]);
    };

    window.行動消費 = function(Call) {
        var Pra = $gameVariables.value(106);
        var PraSw = false;

        Pra = Pra - Call;
        if (Pra < 0) {
            Pra = 0;
            PraSw = true;
        }

        $gameVariables.setValue(106, Pra);
        NrSpineGage.forceUpdate("行動");
    };

    window.FadeC = function([r,g,b]) {
        $gameScreen._fadeColor = [r, g, b, 255];
    };


    //=============================================================
    //                        音関連
    //=============================================================

    window.CallSe = function(index) {
        if(index === 15) return;
        const seName = SeMapp[index];
        if (!seName) return;

        AudioManager.playSe({
            name: seName,
            volume: 90,
            pitch: 100,
            pan: 0
        });
    };

    window.CallBgm = function(index) {
        const bgmName = BgmMapp[index];
        if (!bgmName) return;
        AudioManager.playBgm({
            name: bgmName,
            volume: 60,
            pitch: 100,
            pan: 0
        });
    };

    window.Bgm切り替え = function() {
        var SetTime = $gameVariables.value(103);
        var index = (SetTime < 10) ? 3 : (SetTime < 18) ? 5 : 6;

        const bgmName = BgmMapp[index];
        if (!bgmName) return;
        AudioManager.playBgm({
            name: bgmName,
            volume: 60,
            pitch: 100,
            pan: 0
        });
    };

    AudioManager.playBgsLine = function(bgs, lineIndex) {
        if (!bgs.name) return;
        this.stopBgsLine(lineIndex);
        const buffer = this.createBuffer("bgs/", bgs.name);
        buffer.volume = (bgs.volume || 90) / 100;
        buffer.pitch = (bgs.pitch || 100) / 100;
        buffer.pan = (bgs.pan || 0) / 100;
        buffer.play(true, 0);
        this._bgsBuffers[lineIndex] = buffer;
    };

    AudioManager.stopBgsLine = function(lineIndex) {
        const buffer = this._bgsBuffers[lineIndex];
        if (buffer) {
            buffer.stop();
            this._bgsBuffers[lineIndex] = null;
        }
    };

    AudioManager.stopAllBgs = function() {
        for (let i = 0; i < this._bgsBuffers.length; i++) {
            this.stopBgsLine(i);
        }
    };

    window.CallBgs = function(index, lineIndex = 0) {
        const bgsName = BgsMapp[index];
        if (!bgsName) return;
        AudioManager.playBgsLine({
            name: bgsName,
            volume: 90,
            pitch: 100,
            pan: 0
        }, lineIndex);
    };

    window.停止 = function(arg) {
        let type = arg;
        let line = null;

        if (Array.isArray(arg)) {
            type = arg[0];
            line = arg[1];
        }

        switch (type) {
            case "BGM":
                AudioManager.fadeOutBgm(60);
                break;
            case "BGS":
                if (line !== null) {
                    AudioManager.stopBgsLine(line);
                } else {
                    AudioManager.stopAllBgs();
                }
                break;
            case "SE":
                AudioManager.stopSe();
                break;
            case "Voice":
                AudioManager.stopVoice(null, null);
                break;
            case "voice":
                AudioManager.stopVoice(null, null);
                break;
            }
    };

    //=============================================================
    //                        Spine関連
    //=============================================================

    Object.defineProperty(window, 'Spine', {
        set(value) {
            const Spinemapping = {
                // [ピクチャ番号, スケルトン名, 拡大率, x, y]
                "UI": [30, "UI", 100, 0, 0],
                "タイトル": [100, "タイトル", 100, 0, 0],
                "オプション": [150, "オプション", 100, 0, 0],
                "ウィンドウ": [50, "ウィンドウ", 100, 0, 0],
                "ウィンドウ2": [105, "ウィンドウ", 100, 0, 0],
                "セーブ": [150, "セーブロード", 100, 0, 0],
                "セーブ2": [199, "セーブロード", 100, 0, 0],
                "確認": [200, "確認", 100, 0, 0],
                "アルバイト": [100, "アルバイト", 100, 0, 50],
                "ステータス": [100, "ステータス", 100, 0, 0],
                "おさわり": [100, "おさわりUI", 100, 0, 0],
                "勉強": [100, "勉強", 100, 0, 0],
                "アルバイト2": [110, "勉強", 100, 0, 0],
                "アイテム": [55, "アイテム", 100, 0, 0],
                "ショップ": [100, "ショップ", 100, 0, 0],
                "お風呂": [100, "お風呂", 100, 0, 0],
                "回想": [100, "回想", 100, 0, 0],
            };

            var NSpine = Spinemapping[value];
            if (!NSpine) return;

            var sPic   = NSpine[0];
            var skName = NSpine[1];
            var NScale = NSpine[2];
            var NXx    = NSpine[3];
            var NYy    = NSpine[4];

            if ($gameScreen.picture(sPic)) $gameScreen.erasePicture(sPic);

            $gameScreen.showPicture(sPic, "", 0, NXx, NYy, NScale, NScale, 255, 0);
            $gameScreen.spine(sPic)
                .setSkeleton(skName)
                .setAnimation(0, "000", "continue", true);

        },
        configurable: true
    });

    Object.defineProperty(window, 'SpineFree', {
        set(value) {
            var NSpine = value;
            if (!NSpine) return;

            //0:ピクチャ番号、1:スケルトン名、2:大きさ、3:X、4:Y
            var sPic   = NSpine[0];
            var skName = NSpine[1];
            var NScale = NSpine[2];
            var NXx    = NSpine[3];
            var NYy    = NSpine[4];

            if ($gameScreen.picture(sPic)) $gameScreen.erasePicture(sPic);

            $gameScreen.showPicture(sPic, "", 1, NXx, NYy, NScale, NScale, 255, 0);
            $gameScreen.spine(sPic)
                .setSkeleton(skName)
                .setAnimation(0, "000", "continue", true);

        },
        configurable: true
    });

    Object.defineProperty(window, 'SpineFree2', {
        set(value) {
            var NSpine = value;
            if (!NSpine) return;

            //0:ピクチャ番号、1:スケルトン名、2:大きさ、3:X、4:Y
            var sPic   = NSpine[0];
            var skName = NSpine[1];
            var NScale = NSpine[2];
            var NScale2 = NSpine[3];
            var NXx    = NSpine[4];
            var NYy    = NSpine[5];

            if ($gameScreen.picture(sPic)) $gameScreen.erasePicture(sPic);

            $gameScreen.showPicture(sPic, "", 1, NXx, NYy, NScale, NScale2, 255, 0);
            $gameScreen.spine(sPic)
                .setSkeleton(skName)
                .setAnimation(0, "000", "continue", true);

        },
        configurable: true
    });

    Object.defineProperty(window, 'CG', {
        set(value) {
            const CGSpinemapping = {
                // [ピクチャ番号, スケルトン名, 拡大率, x, y]
                1: [10, "CG1", 50, 0, 0],
                2: [10, "CG2", 50, 0, 0],
                3: [10, "CG3", 50, 0, 0],
                32: [99, "CG3", 50, 0, 0],
                4: [10, "CG4", 50, 0, 0],
                42: [40, "CG4", 100, -500, -920],
                5: [10, "CG5", 50, 0, 0],
                6: [10, "CG6", 50, 0, 0],
                7: [10, "CG7", 50, 0, 0],
                8: [10, "CG8", 50, 0, 0],
                11: [100, "CG1", 50, 0, 0],
                12: [100, "CG2", 50, 0, 0],
                13: [100, "CG3", 50, 0, 0],
                14: [99, "CG4", 50, 0, 0],
            };

            var NSpine = CGSpinemapping[value];
            if (!NSpine) return;

            var sPic   = NSpine[0];
            var skName = NSpine[1];
            var NScale = NSpine[2];
            var NXx    = NSpine[3];
            var NYy    = NSpine[4];

            if ($gameScreen.picture(sPic)) $gameScreen.erasePicture(sPic);

            $gameScreen.showPicture(sPic, "", 0, NXx, NYy, NScale, NScale, 255, 0);
            $gameScreen.spine(sPic).setSkeleton(skName);
            for (let i = 0; i <= 10; i++) {
                $gameScreen.spine(sPic).setAnimation(i, "000", "continue", false);
            }
            if(value !== 8) {
                $gameScreen.spine(sPic).setMix(0.1);
            }
            
            if(value === 32) {
                $gameScreen.spine(sPic).setMix(0);
            }

            if(![32, 11, 12, 13, 14].includes(value)) {
                眉 = "通常";
                目 = "通常";
                口 = "通常";
            }
			
			if ([1, 2, 11, 12].includes(value)) $gameScreen.spine(sPic).setSkin("服2");
            if ([3, 32].includes(value)) $gameScreen.spine(sPic).setSkin("私服2");
            if ([4].includes(value)) {
                アニメ更新 = [0,sPic,0,"待機"];
            }
            if($gameVariables.value(507) === "肉奴隷") {
                if(value === 32) {
                    アニメ更新 = [0,99,65,"【合成】ハイライト"];
                } else {
                    if(sPic === 100 || value === 2) return;
                    アニメ更新 = [0,10,65,"【合成】ハイライト"];
                }
            }

        },
        configurable: true
    });

    Object.defineProperty(window, "スキン指定", {
        set: function(value) {
            if (!value) return;

            var skinName = "";

            if (typeof value === "string") {
                skinName = value;
            } else if (Array.isArray(value) && value.length >= 2) {
                var data = value.slice();
                var varId = Number(data[0]);
                var baseName = String(data[1] || "");
                var baseArray = $gameVariables.value(Skinval).slice();
                baseArray[varId] = baseName;
                skinName = baseArray;
            }

            if (!skinName) return;
            $gameScreen.spine(varId).setSkin(skinName);
        }
    });

    window.スキン変更 = function([pictureId, skinName]) {
        $gameScreen.spine(pictureId).setSkin(skinName);
    };

    Object.defineProperty(window, "アイコン指定", {
        set: function(value) {
            $gameVariables.setValue(SkinVal2,value);
        }
    });

    window.立ち絵 = async function() {
        const NName   = "立ち絵";
        const NScale  = 35;
        const NXx     = 424;
        const NYy     = -34;
        var Skinname  = 22;
        var Skinname2 = 21;

        if($gameScreen.picture(NPic)) P消去 = [0,NPic];

        $gameScreen.showPicture(NPic, "", 0, NXx, NYy, NScale, NScale, 255, 0);

        $gameScreen.spine(NPic).setSkeleton(NName);
        const s = $gameScreen.spine(NPic);

        if(!$gameVariables.value(Skinval)) 初期セット();

        const original = $gameVariables.value(Skinval);
        const SkinName = JSON.parse(JSON.stringify(original));
        s.setSkin.apply(s, SkinName);

        for (let i = 0; i <= 10; i++) {
            s.setAnimation(i, "000", "continue", false);
        }
        s.setMix(0.1);
        $gameVariables.setValue(Skinname,$gameVariables.value(Skinname2));

        アニメ更新 = [0,NPic,0,"【待機】通常"];
        if($gameVariables.value(507) === "肉奴隷") アニメ更新 = [0,NPic,55,"【合成】ハイライト"];
    }

    Object.defineProperty(window, '待機', {
        set(value) {
            if(value === "000") {
                var Anime = "000";
            } else {
                var Anime = "【待機】" + value;
            }
            $gameScreen.spine(NPic).setAnimation(0, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '眉', {
        set(value) {
            if(value === "") return;
            if(value === "000") {
                var Anime = "000";
            } else {
                var Anime = "表情/【眉】" + value;
            }
            $gameScreen.spine(NPic).setAnimation(20, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '目', {
        set(value) {
            if(value === "") return;
            if(value === "000") {
                var Anime = "000";
            } else {
                var Anime = "表情/【目】" + value;
            }
            $gameScreen.spine(NPic).setAnimation(21, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '口', {
        set(value) {
            if(value === "") return;
            if(value === "000") {
                var Anime = "000";
            } else {
                var Anime = "表情/【口】" + value;
            }
            $gameScreen.spine(NPic).setAnimation(22, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '頬', {
        set(value) {
            var Anime = value;
            $gameScreen.spine(NPic).setAnimation(4, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '汗', {
        set(value) {
            var Anime = value;
            $gameScreen.spine(NPic).setAnimation(5, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '合成', {
        set(value) {
			if(value !== "000") {
                var Anime = "【合成】" + value;
			} else {
				var Anime = value;
			}
            $gameScreen.spine(NPic).setAnimation(6, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '合成2', {
        set(value) {
			if(value !== "000") {
                var Anime = "【合成】" + value;
			} else {
				var Anime = value;
			}
            $gameScreen.spine(NPic).setAnimation(7, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '合成3', {
        set(value) {
			if(value !== "000") {
                var Anime = "【合成】" + value;
			} else {
				var Anime = value;
			}
            $gameScreen.spine(NPic).setAnimation(8, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '合成4', {
        set(value) {
			if(value !== "000") {
                var Anime = "【合成】" + value;
			} else {
				var Anime = value;
			}
            $gameScreen.spine(NPic).setAnimation(9, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '合成5', {
        set(value) {
			if(value !== "000") {
                var Anime = "【合成】" + value;
			} else {
				var Anime = value;
			}
            $gameScreen.spine(NPic).setAnimation(10, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '合成6', {
        set(value) {
			if(value !== "000") {
                var Anime = "【合成】" + value;
			} else {
				var Anime = value;
			}
            $gameScreen.spine(NPic).setAnimation(11, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '合成7', {
        set(value) {
			if(value !== "000") {
                var Anime = "【合成】" + value;
			} else {
				var Anime = value;
			}
            $gameScreen.spine(NPic).setAnimation(12, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '合成8', {
        set(value) {
			if(value !== "000") {
                var Anime = "【合成】" + value;
			} else {
				var Anime = value;
			}
            $gameScreen.spine(NPic).setAnimation(13, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '合成9', {
        set(value) {
			if(value !== "000") {
                var Anime = "【合成】" + value;
			} else {
				var Anime = value;
			}
            $gameScreen.spine(NPic).setAnimation(14, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '合成10', {
        set(value) {
			if(value !== "000") {
                var Anime = "【合成】" + value;
			} else {
				var Anime = value;
			}
            $gameScreen.spine(NPic).setAnimation(15, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, '合成11', {
        set(value) {
			if(value !== "000") {
                var Anime = "【合成】" + value;
			} else {
				var Anime = value;
			}
            $gameScreen.spine(NPic).setMix('000', '【合成】挿入', 0);
            $gameScreen.spine(NPic).setMix('000', '【合成】ピストン', 0); 
            $gameScreen.spine(NPic).setMix('【合成】挿入', '【合成】ピストン', 0); 
            $gameScreen.spine(NPic).setMix('【合成】ピストン', '【合成】挿入', 0); 
            $gameScreen.spine(NPic).setMix('【合成】ピストン', '【合成】射精', 0); 
            $gameScreen.spine(NPic).setAnimation(16, Anime, "continue", true);
        },
        configurable: true
    });

    Object.defineProperty(window, 'アニメ呼び出し', {
        set(value) {
            var NNh = value[0];

            if (NNh === 0) {
                var Pic   = value[1];
                var Trc   = value[2];
                var Anime = value[3];

                    const spine = $gameScreen.spine(Pic);
                    if (spine) {
                        spine.setAnimation(Trc, Anime, 'continue', true);
                    } else {
                        //console.warn(`Spine for picture ${Pic} does not exist`);
                    }
                } else {
                var Pic    = value[1];
                var Trc    = value[2];
                var Anime  = value[3];
                var Anime2 = value[4];

                    $gameScreen.spine(Pic).setAnimation(Trc, [Anime, Anime2], 'sequential', 'continue', true);
            }
        },
        configurable: true
    });

    Object.defineProperty(window, 'アニメ更新', {
        set(value) {
            const wait = ms => new Promise(r => setTimeout(r, ms));

            (async () => {
                var NNh = value[0];

                if (NNh === 0) {
                    var Pic   = value[1];
                    var Trc   = value[2];
                    var Anime = value[3];

                    await wait(1);
                    const spine = $gameScreen.spine(Pic);
                    if (spine) {
                        spine.setAnimation(Trc, Anime, 'continue', true);
                    } else {
                        //console.warn(`Spine for picture ${Pic} does not exist`);
                    }
                } else {
                    var Pic    = value[1];
                    var Trc    = value[2];
                    var Anime  = value[3];
                    var Anime2 = value[4];

                    await wait(1);
                    const spine = $gameScreen.spine(Pic);
                    if (spine) {
                        spine.setAnimation(Trc, [Anime, Anime2], 'sequential', 'continue', true);
                    } else {
                        console.warn(`Spine for picture ${Pic} does not exist`);
                    }
                }
            })();
        },
        configurable: true
    });

    Object.defineProperty(window, 'アニメ更新2', {
        set(value) {
            const wait = ms => new Promise(r => setTimeout(r, ms));

            (async () => {
                var NNh = value[0];

                if (NNh === 0) {
                    var Pic   = value[1];
                    var Trc   = value[2];
                    var Anime = value[3];

                    await wait(1);
                    $gameScreen.spine(Pic).setAnimation(Trc, Anime, 'none', true);
                } else {
                    var Pic    = value[1];
                    var Trc    = value[2];
                    var Anime  = value[3];
                    var Anime2 = value[4];

                    await wait(1);
                    $gameScreen.spine(Pic).setAnimation(Trc, [Anime, Anime2], 'sequential', 'none', true);
                }
            })();
        },
        configurable: true
    });

    window.ランダム乱数 = function(args) {
        const variableId = Number(args[0]);
        const min = Number(args[1]);
        const max = Number(args[2]);
        if (!variableId || isNaN(min) || isNaN(max)) return;
        const value = Math.floor(Math.random() * (max - min + 1)) + min;
        $gameVariables.setValue(variableId, value);
    };

    window.絶頂処理 = async function () {
        $gameScreen.startFlash([255, 255, 255, 100], 30);
        await wait(30);
        $gameScreen.startFlash([255, 255, 255, 100], 60);
        await wait(60);
    }

    window.射精処理 = async function () {
        停止("BGS");
        CallSe(8);
        $gameScreen.startFlash([255, 255, 255, 100], 30);
        await wait(30);
        $gameScreen.startFlash([255, 255, 255, 100], 60);
        await wait(75);
        $gameScreen.startFlash([255, 255, 255, 100], 90);
    }

    window.ボイス再生 = async function (Call) {
        if(Call === null) return;
        NrPlayVoice(Call);
    }
})();
