//=============================================================================
// 100ItemCall.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 保存データ
 * @help
 * 保存データに関する処理を行うサンプルです。
 * メインシーンのコマンド
 * 
 * 
 * トラック一覧
 * 0  - 待機
 * 1  - コマンド切り替え
 * 2  - 
 * 3  - 
 * 4  - 土台
 * 5  - 自主トレ
 * 6  - 
 * 7  - 
 * 8  - 
 * 9  - 
 * 10 - 選択
*/

(() => {
    let UIPic   = 30; //UIのピクチャ番号
    let ItemSw  = 42;
    let ItemSw2 = false;
    ItemSw3 = false;
    isItemDragging = false;
    let itemDragType = 0;
    const wait  = frames => new Promise(r => setTimeout(r, frames * (1000/60)));

    const ItemMapp = {
        "noname": ["000", 7, " "],
        "UIB12":  ["アイテム選択1", 0, " "],
        "UIB13":  ["アイテム選択2", 1, " "],
        "UIB14":  ["アイテム選択3", 2, " "],
        "UIB15":  ["アイテム選択4", 3, " "],
        "UIB16":  ["アイテム選択5", 4, " "],
        "UIB17":  ["アイテム選択6", 5, " "],
        "UIB18":  ["アイテム選択7", 6, " "],
        "UIB19":  ["000", 10, " "]
    };

    const effectMap = {
        "媚薬": 効果_媚薬,
        "睡眠薬": 効果_睡眠薬,
        "筋トレ本 初級": 効果_筋トレ本_初級,
        "筋トレ本 中級": 効果_筋トレ本_中級,
        "筋トレ本 上級": 効果_筋トレ本_上級,
        "技術書 初級": 効果_技術書_初級,
        "技術書 中級": 効果_技術書_中級,
        "技術書 上級": 効果_技術書_上級,
        "解説書 初級": 効果_解説書_初級,
        "解説書 中級": 効果_解説書_中級,
        "解説書 上級": 効果_解説書_上級,
        "栄養剤 普通": 効果_栄養剤_普通,
        "栄養剤 強力": 効果_栄養剤_強力,
        "栄養剤 極上": 効果_栄養剤_極上,
        "桜餅": 効果_桜餅,
        "ドーナツ": 効果_ドーナツ,
        "パフェ": 効果_パフェ,
        "薄い本 R-12": 効果_薄い本_R12,
        "薄い本 R-15": 効果_薄い本_R15,
        "薄い本 R-18": 効果_薄い本_R18,
        "参考書 普通": 効果_参考書_普通,
        "参考書 高級": 効果_参考書_高級,
        "参考書 最高級": 効果_参考書_最高級
    };

    window.アイテム呼び出し = async function() {
        $gameVariables.setValue(10,75);
        ItemSw2 = false;
        ItemSw3 = false;
        isItemDragging = false;
        itemDragType = 0;

        await アイテム仕分け();
        await アイテム表示();
        await アイテムテキスト設定();
        アニメ更新 = [0,UIPic,0,"出現3"];
        アニメ更新 = [1,UIPic,5,"道具","道具2"];

        await wait(30);
        Pフェード = [1,101,112,255,5];
        $gameVariables.setValue(10,0);
        $gameSwitches.setValue(ItemSw,true);
        registerItemEventListeners();
    }

    window.アイテム実行 = async function(Call) {
        var ICall = ItemMapp[Call][1];

        if(ICall < 6) {
            var ICall = ICall + $gameVariables.value(419);
            アイテム効果(ItemNameList[ICall]);
            アニメ更新 = [0,UIPic,30,"000"];
            CallSe(1);
        } else if(ICall === 6) {
            アイテム終了();
        } else if(ICall === 10) {
            アイテムつまみ();
        }
    }

    window.アイテム終了 = async function() {
        unregisterItemEventListeners();

        $gameVariables.setValue(10,108);
        アニメ更新 = [0,UIPic,0,"出現2"];
        アニメ更新 = [0,UIPic,5,"000"];
        アニメ更新 = [0,UIPic,30,"000"];
        for (i = 20; i <= 26; i++) {
            アニメ更新 = [0,UIPic,i,"000"];
        }
        Pフェード = [1,101,112,0,1];

        await wait(15);
        $gameVariables.setValue(10,0);
        $gameSwitches.setValue(ItemSw,false);
    }

    window.アイテム選択 = async function(Call) {
        var Anime = ItemMapp[Call];

        アニメ更新 = [0,UIPic,30,Anime[0]];
        if(Anime[0] !== "000") CallSe(3);
    }

    window.アイテム表示 = async function() {
        var Pic  = 101;
        var TT   = ($gameSwitches.value(ItemSw)) ? 255 : 0;
        var x    = 105;
        var x2   = 140;
        var y    = 395;
        var y2   = 63;
        var y3   = 0;
        var Val  = 401;
        var Val2 = 407;
        var Te   = "\\NrOws[4]\\NrOw[255]\\NrOwc[#c499ca]\\NrC[#fafafa]\\NRSH[#000000, 10, 200, 60, 5, 0]";

        for (var y3 = 0; y3 <= 5; y3++) {
            Dテキスト = [Pic++, x,  30 + y + (y2 * y3), TT, Te + "\\f[b]\\v[" + Val++ + "]", 35, "left"];   //アイテム名
            Dテキスト = [Pic++, x2, 30 + y + (y2 * y3), TT, Te + "\\f[b]\\v[" + Val2++ + "] ", 35, "right"];  //個数
        }

    }

    window.アイテムテキスト設定 = async function() {
        let itemIndex = $gameVariables.value(419);
        let varIdNum  = 407;

        for (let varIdName = 401; varIdName <= 406; varIdName++) {
            const name = ItemNameList[itemIndex];
            const num  = ItemNumList[itemIndex];

            const safeName = (name != null) ? name : " ";
            const safeNum  = (num  != null) ? num  : " ";

            $gameVariables.setValue(varIdName, safeName);
            $gameVariables.setValue(varIdNum++, safeNum);

            itemIndex++;
        }
    };

    window.アイテム仕分け = async function() {
        ItemNameList = [];
        ItemNumList  = [];

        var startVarId = 162;
        var endVarId   = 184;
        var labelTags  = ["【1】", "【12】", "【21】", "【22】", "【23】", "【31】",
            "【32】", "【33】", "【41】", "【42】", "【43】", "【51】",
            "【52】", "【53】", "【61】", "【62】", "【63】", "【71】",
            "【72】", "【73】", "【81】", "【82】", "【83】"];
        var tempList   = [];

        for (var i = startVarId; i <= endVarId; i++) {
            var value = $gameVariables.value(i);
            if (value >= 1) {
                var name = $dataSystem.variables[i];
                tempList.push({ name: name, value: value });
            }
        }

        var collator = new Intl.Collator("ja");
        tempList.sort(function(a, b) {
            return collator.compare(a.name, b.name);
        });

        for (var k = 0; k < tempList.length; k++) {
            var name = tempList[k].name;
            for (var j = 0; j < labelTags.length; j++) {
                var tag = labelTags[j];
                if (name.indexOf(tag) !== -1) {
                    name = name.replace(tag, "");
                }
            }
            ItemNameList.push(name);
            ItemNumList.push(tempList[k].value);
        }

        $gameVariables.setValue(419,0);
        $gameVariables.setValue(420,ItemNameList.length - 6);
        var i = ItemNameList.length;

        if (i > 0) {
            var ii = 20;
            if(i > 6) {
                for (ii = 20; ii <= 25; ii++) {
                    アニメ更新 = [0, UIPic, ii, "アイテム" + (ii - 19)];
                }
                if(i >= 7) {
                    アニメ更新 = [0,UIPic,ii - 1,"アイテム7"];
                    ItemSw2   = true;
                }
            } else {
                for (ii = 20; ii <= 19 + i; ii++) {
                    アニメ更新 = [0, UIPic, ii, "アイテム" + (ii - 19)];
                }
            }
        }
    }

    const getItemScrollType = y => {
        if (y >= 413 && y <= 770) return 1;
        return 0;
    };

    function registerItemEventListeners() {
        if (window._itemListenersRegistered) return;
        window._itemListenersRegistered = true;

        document.addEventListener("wheel", handleItemWheel, { passive: true });
        document.addEventListener("mousedown", handleItemMouseDown);
        document.addEventListener("mousemove", handleItemMouseMove);
        document.addEventListener("mouseup", handleItemMouseUp);
    }

    function unregisterItemEventListeners() {
        document.removeEventListener("wheel", handleItemWheel);
        document.removeEventListener("mousedown", handleItemMouseDown);
        document.removeEventListener("mousemove", handleItemMouseMove);
        document.removeEventListener("mouseup", handleItemMouseUp);
        window._itemListenersRegistered = false;
    }

    async function handleItemMouseDown() {
        if (!$gameSwitches.value(ItemSw) || !ItemSw3) return;

        const y = TouchInput.y;
        itemDragType = getItemScrollType(y);

        if (itemDragType > 0) {
            isItemDragging = true;
            await アイテムつまみ割合();
            await wait(1);
            await アイテムつまみ();
        }
    }

    async function handleItemMouseMove() {
        if (!isItemDragging || !$gameSwitches.value(ItemSw) || !ItemSw3) return;
        await アイテムつまみ割合();
    }

    function handleItemMouseUp() {
        isItemDragging = false;
        itemDragType = 0;
    }

    async function handleItemWheel(e) {
        if ($gameVariables.value(10) !== 0 || !$gameSwitches.value(ItemSw) || !ItemSw2) return;

        if (e.deltaY > 0) {
            await アイテムスクロール(1);
        } else if (e.deltaY < 0) {
            await アイテムスクロール(2);
        }
    }

    window.アイテムつまみ割合 = async function() {
        $gameVariables.setValue(10,105);
        const y = TouchInput.y;
        const topY = 413;
        const bottomY = 770;
        const maxIndex = $gameVariables.value(420);
        const range = bottomY - topY;

        let ratio = (y - topY) / range;
        ratio = Math.max(0, Math.min(1, ratio));

        const index = Math.floor(ratio * (maxIndex));
        $gameVariables.setValue(419, index);

        await アイテムテキスト設定();
        await wait(1);
        await $gameVariables.setValue(10,0);
    };

    window.アイテムスクロール = async function(Call) {
        if ($gameVariables.value(10) !== 0) return;
        if (!ItemSw2) return;

        $gameVariables.setValue(10, 105);

        let index = $gameVariables.value(419);
        const max = $gameVariables.value(420);

        if (Call === 1) index++;
        else if (Call === 2) index--;

        if (index < 0) index = 0;
        if (index > max) index = max;

        $gameVariables.setValue(419, index);

        await アイテムテキスト設定();

        await wait(1);
        $gameVariables.setValue(10, 0);
    };

    window.アイテムつまみ = async function() {
        if (!ItemSw2) return;

        $gameVariables.setValue(10,105);
        const y = TouchInput.y;
        const topY     = 413;
        const bottomY  = 770;
        const maxIndex = $gameVariables.value(420);
        const range = bottomY - topY;

        let ratio = (y - topY) / range;
        ratio = Math.max(0, Math.min(1, ratio));

        const index = Math.floor(ratio * (maxIndex));
        $gameVariables.setValue(419, index);

        await アイテムテキスト設定();
        await $gameVariables.setValue(10,0);
    };

    window.アイテム効果 = async function(itemName) {
        if (!itemName) return;

        const effectFunc = effectMap[itemName];
        if (effectFunc) {
            await effectFunc();
            await アイテム消費再描画();
        }
    };

    window.アイテム消費再描画 = async function() {
        var oldCount = ItemNameList.length;
        var curIndex = $gameVariables.value(419);

        await アイテム仕分け();
        await wait(1);

        var newNames = ItemNameList;
        var newNums  = ItemNumList;
        var newCount = newNames.length;
        var maxIndex = $gameVariables.value(420);

        let newIndex = curIndex;
        if (newCount === oldCount) {
            newIndex = curIndex;
        } else {
            if (newCount <= 6) {
                newIndex = 0;
            } else if (curIndex > maxIndex) {
                newIndex = maxIndex;
            }
        }

        $gameVariables.setValue(419, newIndex);

        let itemIndex = newIndex;
        for (let j = 0; j < 6; j++) {
            const name = newNames[itemIndex] || " ";
            const num = newNums[itemIndex] || " ";
            $gameVariables.setValue(401 + j, name);
            $gameVariables.setValue(407 + j, num);
            itemIndex++;
        }

        if (oldCount >= 7 || newCount <= 6) {
            for (let i = 0; i < 6; i++) {
                var Anime = (i < newCount) ? "アイテム" + (i + 1) : "000";
                アニメ更新 = [0, UIPic, 20 + i, Anime];
            }

            Pフェード = [1, 101 + newCount * 2, 112, 0, 5];
        }

    };

    async function 効果_媚薬() {
        if(!$gameSwitches.value(63)) {
            if($gameSwitches.value(88) || $gameSwitches.value(89)) {
                獲得 = ["好感度", -15];
                //NrPictureEffect.startLoopEffect(8, 1000, 500);
            }
            $gameVariables.setValue(162,$gameVariables.value(162) - 1);
            $gameSwitches.setValue(63,true);
            会話アイテム実行(2);
        }
    }

    async function 効果_睡眠薬() {
        if(!$gameSwitches.value(62)) {
            if($gameSwitches.value(88) || $gameSwitches.value(89)) {
                獲得 = ["好感度", -15];
                //NrPictureEffect.startLoopEffect(8, 1000, 500);
            }
            $gameVariables.setValue(163,$gameVariables.value(163) - 1)
            $gameSwitches.setValue(62,true);
            会話アイテム実行(2);
        }
    }

    async function 効果_筋トレ本_初級() {
            var Up = 5;
            var UpVal = 90;
            var Up2 = $gameVariables.value(UpVal) + Up;
            var Max = 999 - Up;

        if($gameVariables.value(98) <= Max) {
            $gameVariables.setValue(UpVal,Up2);
            $gameVariables.setValue(164,$gameVariables.value(164) - 1);
        }
    }

    async function 効果_筋トレ本_中級() {
        var Up = 25;
        var UpVal = 90;
        var Up2 = $gameVariables.value(UpVal) + Up;
        var Max = 999 - Up;

        if ($gameVariables.value(UpVal) <= Max) {
            $gameVariables.setValue(UpVal, Up2);
            $gameVariables.setValue(165, $gameVariables.value(165) - 1);
        }
    }

    async function 効果_筋トレ本_上級() {
        var Up = 50;
        var UpVal = 90;
        var Up2 = $gameVariables.value(UpVal) + Up;
        var Max = 999 - Up;

        if ($gameVariables.value(UpVal) <= Max) {
            $gameVariables.setValue(UpVal, Up2);
            $gameVariables.setValue(166, $gameVariables.value(166) - 1);
        }
    }

    async function 効果_技術書_初級() {
        var Up = 5;
        var UpVal = 91;
        var Up2 = $gameVariables.value(UpVal) + Up;
        var Max = 999 - Up;

        if ($gameVariables.value(UpVal) <= Max) {
            $gameVariables.setValue(UpVal, Up2);
            $gameVariables.setValue(167, $gameVariables.value(167) - 1);
        }
    }

    async function 効果_技術書_中級() {
        var Up = 25;
        var UpVal = 91;
        var Up2 = $gameVariables.value(UpVal) + Up;
        var Max = 999 - Up;

        if ($gameVariables.value(UpVal) <= Max) {
            $gameVariables.setValue(UpVal, Up2);
            $gameVariables.setValue(168, $gameVariables.value(168) - 1);
        }
    }

    async function 効果_技術書_上級() {
        var Up = 50;
        var UpVal = 91;
        var Up2 = $gameVariables.value(UpVal) + Up;
        var Max = 999 - Up;

        if ($gameVariables.value(UpVal) <= Max) {
            $gameVariables.setValue(UpVal, Up2);
            $gameVariables.setValue(169, $gameVariables.value(169) - 1);
        }
    }

    async function 効果_解説書_初級() {
        var Up = 5;
        var UpVal = 92;
        var Up2 = $gameVariables.value(UpVal) + Up;
        var Max = 999 - Up;

        if ($gameVariables.value(UpVal) <= Max) {
            $gameVariables.setValue(UpVal, Up2);
            $gameVariables.setValue(170, $gameVariables.value(170) - 1);
        }
    }

    async function 効果_解説書_中級() {
        var Up = 25;
        var UpVal = 92;
        var Up2 = $gameVariables.value(UpVal) + Up;
        var Max = 999 - Up;

        if ($gameVariables.value(UpVal) <= Max) {
            $gameVariables.setValue(UpVal, Up2);
            $gameVariables.setValue(171, $gameVariables.value(171) - 1);
        }
    }

    async function 効果_解説書_上級() {
        var Up = 50;
        var UpVal = 92;
        var Up2 = $gameVariables.value(UpVal) + Up;
        var Max = 999 - Up;

        if ($gameVariables.value(UpVal) <= Max) {
            $gameVariables.setValue(UpVal, Up2);
            $gameVariables.setValue(172, $gameVariables.value(172) - 1);
        }
    }

    async function 効果_栄養剤_普通() {
        var Up = 5;
        var UpVal1 = 93;
        var UpVal2 = 94;
        var Max = 999 - Up;
        var used = false;

        if ($gameVariables.value(UpVal1) <= Max) {
            $gameVariables.setValue(UpVal1, $gameVariables.value(UpVal1) + Up);
            used = true;
        }
        if ($gameVariables.value(UpVal2) <= Max) {
            $gameVariables.setValue(UpVal2, $gameVariables.value(UpVal2) + Up);
            used = true;
        }

        if (used) {
            $gameVariables.setValue(173, $gameVariables.value(173) - 1);
        }
    }

    async function 効果_栄養剤_強力() {
        var Up = 25;
        var UpVal1 = 93;
        var UpVal2 = 94;
        var Max = 999 - Up;
        var used = false;

        if ($gameVariables.value(UpVal1) <= Max) {
            $gameVariables.setValue(UpVal1, $gameVariables.value(UpVal1) + Up);
            used = true;
        }
        if ($gameVariables.value(UpVal2) <= Max) {
            $gameVariables.setValue(UpVal2, $gameVariables.value(UpVal2) + Up);
            used = true;
        }

        if (used) {
            $gameVariables.setValue(174, $gameVariables.value(174) - 1);
        }
    }

    async function 効果_栄養剤_極上() {
        var Up = 50;
        var UpVal1 = 93;
        var UpVal2 = 94;
        var Max = 999 - Up;
        var used = false;

        if ($gameVariables.value(UpVal1) <= Max) {
            $gameVariables.setValue(UpVal1, $gameVariables.value(UpVal1) + Up);
            used = true;
        }
        if ($gameVariables.value(UpVal2) <= Max) {
            $gameVariables.setValue(UpVal2, $gameVariables.value(UpVal2) + Up);
            used = true;
        }

        if (used) {
            $gameVariables.setValue(175, $gameVariables.value(175) - 1);
        }
    }

    async function 効果_桜餅() {
        var Up      = 5;
        var UpVal  = 42;
        var UpVal2 = 52;
        var ExpName = "好感度";

        if($gameVariables.value(UpVal) < 100) {
            Up  = $gameVariables.value(UpVal2) * (Up / 100);
            獲得 = [ExpName,Up];
            $gameVariables.setValue(176, $gameVariables.value(176) - 1);
            //NrPictureEffect.startLoopEffect(1, 1000, 500);
            会話アイテム実行(1);
        }
    }

    async function 効果_ドーナツ() {
        var Up = 25;
        var UpVal = 42;
        var UpRate = 52;
        var ExpName = "好感度";

        if ($gameVariables.value(UpVal) < 100) {
            Up = $gameVariables.value(UpRate) * (Up / 100);
            獲得 = [ExpName, Up];
            $gameVariables.setValue(177, $gameVariables.value(177) - 1);
            //NrPictureEffect.startLoopEffect(1, 1000, 500);
            会話アイテム実行(1);
        }
    }

    async function 効果_パフェ() {
        var Up = 50;
        var UpVal = 42;
        var UpRate = 52;
        var ExpName = "好感度";

        if ($gameVariables.value(UpVal) < 100) {
            Up = $gameVariables.value(UpRate) * (Up / 100);
            獲得 = [ExpName, Up];
            $gameVariables.setValue(178, $gameVariables.value(178) - 1);
            //NrPictureEffect.startLoopEffect(1, 1000, 500);
            会話アイテム実行(1);
        }
    }

    async function 効果_薄い本_R12() {
        var Up1 = 5, Val1 = 43, Rate1 = 54, Name1 = "淫乱度", BonusVar1 = 86;
        var Up2 = 2, Val2 = 44, Rate2 = 56, Name2 = "性知識", BonusVar2 = 45;
        var used = false;
        var rate1 = $gameVariables.value(Rate1);
        var rate2 = $gameVariables.value(Rate2);

        if ($gameVariables.value(Val1) < 100 && rate1 > 0) {
            Up1 = rate1 * (Up1 / 100);
            獲得 = [Name1, Up1];
            used = true;
        }

        if ($gameVariables.value(Val2) < 100 && rate2 > 0) {
            Up2 = rate2 * (Up2 / 100);
            獲得 = [Name2, Up2];
            used = true;
        }

        if (used) {
            if (!$gameSwitches.value(88) && !$gameSwitches.value(89)) {
                獲得 = ["好感度", -50];
            }
            $gameVariables.setValue(179, $gameVariables.value(179) - 1);
            会話アイテム実行(2);
        }
    }

    async function 効果_薄い本_R15() {
        var Up1 = 25, Val1 = 43, Rate1 = 54, Name1 = "淫乱度", BonusVar1 = 86;
        var Up2 = 15, Val2 = 44, Rate2 = 56, Name2 = "性知識", BonusVar2 = 45;
        var used = false;
        var rate1 = $gameVariables.value(Rate1);
        var rate2 = $gameVariables.value(Rate2);

        if ($gameVariables.value(Val1) < 100 && rate1 > 0) {
            Up1 = rate1 * (Up1 / 100);
            獲得 = [Name1, Up1];
            used = true;
        }

        if ($gameVariables.value(Val2) < 100 && rate2 > 0) {
            Up2 = rate2 * (Up2 / 100);
            獲得 = [Name2, Up2];
            used = true;
        }

        if (used) {
            if (!$gameSwitches.value(88) && !$gameSwitches.value(89)) {
                獲得 = ["好感度", -50];
            }
            $gameVariables.setValue(180, $gameVariables.value(180) - 1);
            会話アイテム実行(2);
        }
    }

    async function 効果_薄い本_R18() {
        var Up1 = 50, Val1 = 43, Rate1 = 54, Name1 = "淫乱度", BonusVar1 = 86;
        var Up2 = 25, Val2 = 44, Rate2 = 56, Name2 = "性知識", BonusVar2 = 45;
        var used = false;
        var rate1 = $gameVariables.value(Rate1);
        var rate2 = $gameVariables.value(Rate2);

        if ($gameVariables.value(Val1) < 100 && rate1 > 0) {
            Up1 = rate1 * (Up1 / 100);
            console.log(Up1);
            獲得 = [Name1, Up1];
            used = true;
        }

        if ($gameVariables.value(Val2) < 100 && rate2 > 0) {
            Up2 = rate2 * (Up2 / 100);
            獲得 = [Name2, Up2];
            used = true;
        }

        if (used) {
            if (!$gameSwitches.value(88) && !$gameSwitches.value(89)) {
                獲得 = ["好感度", -50];
            }
            $gameVariables.setValue(181, $gameVariables.value(181) - 1);
            会話アイテム実行(2);
        }
    }

    async function 効果_参考書_普通() {
        var Up = 5;
        var Val = 45;
        var Rate = 56;
        var Name = "学力";

        if ($gameVariables.value(Val) < 100) {
            Up = $gameVariables.value(Rate) * (Up / 100);
            獲得 = [Name, Up];
            //NrPictureEffect.startLoopEffect(4, 1000, 500);
            $gameVariables.setValue(182, $gameVariables.value(182) - 1);
            会話アイテム実行(1);
        }
    }

    async function 効果_参考書_高級() {
        var Up = 25;
        var Val = 44;
        var Rate = 56;
        var Name = "学力";

        if ($gameVariables.value(Val) < 100) {
            Up = $gameVariables.value(Rate) * (Up / 100);
            獲得 = [Name, Up];
            //NrPictureEffect.startLoopEffect(4, 1000, 500);
            $gameVariables.setValue(183, $gameVariables.value(183) - 1);
            会話アイテム実行(1);
        }
    }

    async function 効果_参考書_最高級() {
        var Up = 50;
        var Val = 44;
        var Rate = 56;
        var Name = "学力";

        if ($gameVariables.value(Val) < 100) {
            Up = $gameVariables.value(Rate) * (Up / 100);
            獲得 = [Name, Up];
            //NrPictureEffect.startLoopEffect(4, 1000, 500);
            $gameVariables.setValue(184, $gameVariables.value(184) - 1);
            会話アイテム実行(1);
        }
    }

})();